/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLUtil;

class ContentReader
extends Reader {
    private IXMLReader reader;
    private String buffer;
    private int bufferIndex;
    private IXMLEntityResolver resolver;

    ContentReader(IXMLReader iXMLReader, IXMLEntityResolver iXMLEntityResolver, String string) {
        this.reader = iXMLReader;
        this.resolver = iXMLEntityResolver;
        this.buffer = string;
        this.bufferIndex = 0;
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        this.resolver = null;
        this.buffer = null;
        super.finalize();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        try {
            int n3 = 0;
            int n4 = this.buffer.length();
            if (n + n2 > cArray.length) {
                n2 = cArray.length - n;
            }
            while (n3 < n2) {
                char c;
                String string = "";
                if (this.bufferIndex < n4) {
                    c = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    cArray[n3] = c;
                    ++n3;
                    continue;
                }
                string = XMLUtil.read(this.reader, '&');
                c = string.charAt(0);
                if (c == '<') {
                    this.reader.unread(c);
                    break;
                }
                if (c == '&' && string.length() > 1) {
                    if (string.charAt(1) == '#') {
                        c = XMLUtil.processCharLiteral(string);
                    } else {
                        XMLUtil.processEntity(string, this.reader, this.resolver);
                        continue;
                    }
                }
                cArray[n3] = c;
                ++n3;
            }
            if (n3 == 0) {
                n3 = -1;
            }
            return n3;
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            int n = this.buffer.length();
            while (true) {
                char c;
                String string = "";
                if (this.bufferIndex < n) {
                    c = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    continue;
                }
                string = XMLUtil.read(this.reader, '&');
                c = string.charAt(0);
                if (c == '<') {
                    this.reader.unread(c);
                    break;
                }
                if (c != '&' || string.length() <= 1 || string.charAt(1) == '#') continue;
                XMLUtil.processEntity(string, this.reader, this.resolver);
            }
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }
}

