/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

public final class PersisterFactory {
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, CacheConcurrencyStrategy.class, SessionFactoryImplementor.class, Mapping.class};
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CacheConcurrencyStrategy.class, Configuration.class, SessionFactoryImplementor.class};

    private PersisterFactory() {
    }

    public static EntityPersister createClassPersister(PersistentClass model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping cfg) throws HibernateException {
        Class persisterClass = model.getEntityPersisterClass();
        if (persisterClass == null || persisterClass == SingleTableEntityPersister.class) {
            return new SingleTableEntityPersister(model, cache, factory, cfg);
        }
        if (persisterClass == JoinedSubclassEntityPersister.class) {
            return new JoinedSubclassEntityPersister(model, cache, factory, cfg);
        }
        if (persisterClass == UnionSubclassEntityPersister.class) {
            return new UnionSubclassEntityPersister(model, cache, factory, cfg);
        }
        return PersisterFactory.create(persisterClass, model, cache, factory, cfg);
    }

    public static CollectionPersister createCollectionPersister(Configuration cfg, Collection model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory) throws HibernateException {
        Class persisterClass = model.getCollectionPersisterClass();
        if (persisterClass == null) {
            return model.isOneToMany() ? new OneToManyPersister(model, cache, cfg, factory) : new BasicCollectionPersister(model, cache, cfg, factory);
        }
        return PersisterFactory.create(persisterClass, cfg, model, cache, factory);
    }

    private static EntityPersister create(Class persisterClass, PersistentClass model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping cfg) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (EntityPersister)pc.newInstance(model, cache, factory, cfg);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)e;
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
    }

    private static CollectionPersister create(Class persisterClass, Configuration cfg, Collection model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (CollectionPersister)pc.newInstance(model, cache, cfg, factory);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)e;
            }
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
    }
}

