/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.wiztools.commons.FileUtil;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityByteArray;
import org.wiztools.restclient.bean.ReqEntityByteArrayBean;
import org.wiztools.restclient.persistence.XMLException;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.dnd.DndAction;
import org.wiztools.restclient.ui.dnd.FileDropTargetListener;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;
import org.wiztools.restclient.util.HexDump;
import org.wiztools.restclient.util.Util;
import org.wiztools.restclient.util.XMLUtil;

public class ReqBodyPanelByteArray
extends JPanel
implements ReqBodyPanel {
    @Inject
    private RESTUserInterface rest_ui;
    @Inject
    private ContentTypeCharsetComponent jp_content_type_charset;
    private final JButton jb_body = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private final JTextArea jta = new JTextArea();
    private byte[] body;
    private static final int FILE_SIZE_THRESHOLD_LIMIT_MB = 2;

    @PostConstruct
    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel(new FlowLayout(0));
        jp_north.add(this.jp_content_type_charset.getComponent());
        this.jb_body.setToolTipText("Select file having body content");
        this.jb_body.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReqBodyPanelByteArray.this.fileOpen();
            }
        });
        jp_north.add(this.jb_body);
        this.add((Component)jp_north, "North");
        this.jta.setFont(UIUtil.FONT_MONO_PLAIN);
        this.jta.setEditable(false);
        this.add((Component)new JScrollPane(this.jta), "Center");
        FileDropTargetListener l = new FileDropTargetListener();
        l.addDndAction(new DndAction(){

            @Override
            public void onDrop(List<File> files) {
                ReqBodyPanelByteArray.this.fileOpen(files.get(0));
            }
        });
        new DropTarget(this.jta, l);
        new DropTarget(this.jb_body, l);
    }

    private void fileOpen() {
        File f = this.rest_ui.getOpenFile(FileChooserType.OPEN_REQUEST_BODY);
        this.fileOpen(f);
    }

    private void fileOpen(File f) {
        int yesNoOption;
        long fileSizeMB;
        int result;
        String origContentType;
        if (f == null) {
            return;
        }
        if (!f.canRead()) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "File not readable: " + f.getAbsolutePath(), "IO Error", 0);
            return;
        }
        String mime = FileUtil.getMimeType(f);
        if (!mime.equals("content/unknown") && !mime.equals(origContentType = this.jp_content_type_charset.getContentType().getContentType()) && (result = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "The content-type selected (" + origContentType + ") does NOT match\nthe computed file mime type (" + mime + ")\nDo you want to update the content-type to `" + mime + "'?", "Mime-type mismatch correction", 0)) == 0) {
            this.jp_content_type_charset.setContentType(mime);
            if ("application/xml".equals(mime)) {
                try {
                    int charsetYesNo;
                    String charset = XMLUtil.getDocumentCharset(f);
                    if (charset != null && !charset.equals(this.jp_content_type_charset.getCharsetString()) && (charsetYesNo = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "Change charset to `" + charset + "'?", "Change charset?", 0)) == 0) {
                        this.jp_content_type_charset.setCharset(Charset.forName(charset));
                    }
                }
                catch (IOException charset) {
                }
                catch (XMLException charset) {
                    // empty catch block
                }
            }
        }
        if ((fileSizeMB = f.length() / 0x100000L) > 2L && (yesNoOption = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "File size is more than 2 MB.\nBigger files are recommended to be configured using the File body.\nDo you want to continue loading?", "File exceeds threshold size", 0)) == 1) {
            return;
        }
        try {
            byte[] data = FileUtil.getContentAsBytes(f);
            this.body = data;
            this.jta.setText(HexDump.getHexDataDumpAsString(data));
            this.jta.setCaretPosition(0);
        }
        catch (IOException ex) {
            this.rest_ui.getView().doError(Util.getStackTrace(ex));
        }
    }

    @Override
    public void enableBody() {
        this.jp_content_type_charset.enableComponent();
        this.jb_body.setEnabled(true);
        this.jta.setEnabled(true);
    }

    @Override
    public void disableBody() {
        this.jp_content_type_charset.disableComponent();
        this.jb_body.setEnabled(false);
        this.jta.setEnabled(false);
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityByteArray) {
            ReqEntityByteArray e = (ReqEntityByteArray)entity;
            this.jp_content_type_charset.setContentTypeCharset(e.getContentType());
            this.body = e.getBody();
            this.jta.setText(HexDump.getHexDataDumpAsString(e.getBody()));
        }
    }

    @Override
    public ReqEntity getEntity() {
        ReqEntityByteArrayBean out = new ReqEntityByteArrayBean(this.body, this.jp_content_type_charset.getContentType());
        return out;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.jp_content_type_charset.clear();
        this.body = null;
        this.jta.setText("");
    }
}

