/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <assert.h>
#include <vsync/atomic.h>
#define BYTE_WIDTH 8U
/*****************************************************************************
 * UnitTest: vatomic64_read
 *****************************************************************************/
static inline void
ut_atomic_u64_read(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_read_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_read_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read_acq(&obj);
    assert(val == (vuint64_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_read_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_read_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read_rlx(&obj);
    assert(val == (vuint64_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_init
 *****************************************************************************/
static inline void
ut_atomic_u64_init(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vatomic64_init(&obj, VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_write
 *****************************************************************************/
static inline void
ut_atomic_u64_write(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vatomic64_write(&obj, VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_write_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_write_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vatomic64_write_rel(&obj, VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_write_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_write_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vatomic64_write_rlx(&obj, VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_xchg
 *****************************************************************************/
static inline void
ut_atomic_u64_xchg(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vuint64_t old = vatomic64_xchg(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_xchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_xchg_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vuint64_t old = vatomic64_xchg_acq(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_xchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_xchg_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vuint64_t old = vatomic64_xchg_rel(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_xchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_xchg_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t val   = vatomic64_read(&obj);
    assert(val == (vuint64_t)1);
    vuint64_t old = vatomic64_xchg_rlx(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_cmpxchg
 *****************************************************************************/
static inline void
ut_atomic_u64_cmpxchg(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    /* test failure */
    vuint64_t old = vatomic64_cmpxchg(&obj, VUINT64_MAX, (vuint64_t)1);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic64_cmpxchg(&obj, (vuint64_t)1, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_cmpxchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_cmpxchg_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    /* test failure */
    vuint64_t old = vatomic64_cmpxchg_acq(&obj, VUINT64_MAX, (vuint64_t)1);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic64_cmpxchg_acq(&obj, (vuint64_t)1, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_cmpxchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_cmpxchg_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    /* test failure */
    vuint64_t old = vatomic64_cmpxchg_rel(&obj, VUINT64_MAX, (vuint64_t)1);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic64_cmpxchg_rel(&obj, (vuint64_t)1, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_cmpxchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_cmpxchg_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    /* test failure */
    vuint64_t old = vatomic64_cmpxchg_rlx(&obj, VUINT64_MAX, (vuint64_t)1);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic64_cmpxchg_rlx(&obj, (vuint64_t)1, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val, old);
}
/* ****************************************************************************
 * UnitTest: vatomic64_add
 * ****************************************************************************/
static inline void
ut_atomic_u64_add(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_add(&obj, v);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_add_rel
 * ****************************************************************************/
static inline void
ut_atomic_u64_add_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_add_rel(&obj, v);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_add_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u64_add_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_add_rlx(&obj, v);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_add
 *****************************************************************************/
static inline void
ut_atomic_u64_get_add(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_add(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_add_get
 *****************************************************************************/
static inline void
ut_atomic_u64_add_get(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_add_get(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_add_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_add_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_add_acq(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_add_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_add_get_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_add_get_acq(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_add_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_add_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_add_rel(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_add_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_add_get_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_add_get_rel(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_add_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_add_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_add_rlx(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_add_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_add_get_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_add_get_rlx(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic64_inc
 * ****************************************************************************/
static inline void
ut_atomic_u64_inc(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_inc(&obj);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_inc_rel
 * ****************************************************************************/
static inline void
ut_atomic_u64_inc_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_inc_rel(&obj);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_inc_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u64_inc_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_inc_rlx(&obj);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_inc
 *****************************************************************************/
static inline void
ut_atomic_u64_get_inc(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_inc(&obj);
        assert(old == ref);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_inc_get
 *****************************************************************************/
static inline void
ut_atomic_u64_inc_get(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref++;
        cur = vatomic64_inc_get(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_inc_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_inc_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_inc_acq(&obj);
        assert(old == ref);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_inc_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_inc_get_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref++;
        cur = vatomic64_inc_get_acq(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_inc_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_inc_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_inc_rel(&obj);
        assert(old == ref);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_inc_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_inc_get_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref++;
        cur = vatomic64_inc_get_rel(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_inc_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_inc_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_inc_rlx(&obj);
        assert(old == ref);
        ref++;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_inc_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_inc_get_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref++;
        cur = vatomic64_inc_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_sub
 * ****************************************************************************/
static inline void
ut_atomic_u64_sub(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_sub(&obj, v);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_sub_rel
 * ****************************************************************************/
static inline void
ut_atomic_u64_sub_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_sub_rel(&obj, v);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_sub_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u64_sub_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_sub_rlx(&obj, v);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_sub
 *****************************************************************************/
static inline void
ut_atomic_u64_get_sub(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_sub(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_sub_get
 *****************************************************************************/
static inline void
ut_atomic_u64_sub_get(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_sub_get(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_sub_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_sub_acq(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_sub_acq(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_sub_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_sub_get_acq(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_sub_get_acq(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_sub_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_sub_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_sub_rel(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_sub_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_sub_get_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_sub_get_rel(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_sub_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_sub_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t old   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_sub_rlx(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_sub_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_sub_get_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;
    vuint64_t cur   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        cur = vatomic64_sub_get_rlx(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic64_dec
 * ****************************************************************************/
static inline void
ut_atomic_u64_dec(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_dec(&obj);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_dec_rel
 * ****************************************************************************/
static inline void
ut_atomic_u64_dec_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_dec_rel(&obj);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic64_dec_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u64_dec_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        vatomic64_dec_rlx(&obj);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_dec
 *****************************************************************************/
static inline void
ut_atomic_u64_get_dec(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t old   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_dec(&obj);
        assert(old == ref);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_dec_get
 *****************************************************************************/
static inline void
ut_atomic_u64_dec_get(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref--;
        cur = vatomic64_dec_get(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_dec_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_dec_acq(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t old   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_dec_acq(&obj);
        assert(old == ref);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_dec_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_dec_get_acq(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref--;
        cur = vatomic64_dec_get_acq(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_dec_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_dec_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t old   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_dec_rel(&obj);
        assert(old == ref);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_dec_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_dec_get_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref--;
        cur = vatomic64_dec_get_rel(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_dec_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_dec_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t old   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        old = vatomic64_get_dec_rlx(&obj);
        assert(old == ref);
        ref--;
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_dec_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_dec_get_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t max   = (vuint64_t)1 + (vuint64_t)10;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t val   = 0;

    for (vuint64_t v = (vuint64_t)1; v <= max; v++) {
        ref--;
        cur = vatomic64_dec_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic64_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_max
 *****************************************************************************/
static inline void
ut_atomic_u64_max(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vatomic64_max(&obj, VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    vatomic64_max(&obj, (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_max_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vatomic64_max_rel(&obj, VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    vatomic64_max_rel(&obj, (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_max_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vatomic64_max_rlx(&obj, VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    vatomic64_max_rlx(&obj, (vuint64_t)1);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_max
 *****************************************************************************/
static inline void
ut_atomic_u64_get_max(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t old = vatomic64_get_max(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    old = vatomic64_get_max(&obj, (vuint64_t)1);
    assert(old == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_max_get
 *****************************************************************************/
static inline void
ut_atomic_u64_max_get(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t cur = vatomic64_max_get(&obj, VUINT64_MAX);
    assert(cur == VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    cur = vatomic64_max_get(&obj, (vuint64_t)1);
    assert(cur == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_max_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_max_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t old = vatomic64_get_max_acq(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    old = vatomic64_get_max_acq(&obj, (vuint64_t)1);
    assert(old == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_max_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_max_get_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t cur = vatomic64_max_get_acq(&obj, VUINT64_MAX);
    assert(cur == VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    cur = vatomic64_max_get_acq(&obj, (vuint64_t)1);
    assert(cur == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_max_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t old = vatomic64_get_max_rel(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    old = vatomic64_get_max_rel(&obj, (vuint64_t)1);
    assert(old == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_max_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_max_get_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t cur = vatomic64_max_get_rel(&obj, VUINT64_MAX);
    assert(cur == VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    cur = vatomic64_max_get_rel(&obj, (vuint64_t)1);
    assert(cur == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_max_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t old = vatomic64_get_max_rlx(&obj, VUINT64_MAX);
    assert(old == (vuint64_t)1);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    old = vatomic64_get_max_rlx(&obj, (vuint64_t)1);
    assert(old == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_max_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_max_get_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};

    /* test write */
    vuint64_t cur = vatomic64_max_get_rlx(&obj, VUINT64_MAX);
    assert(cur == VUINT64_MAX);
    vuint64_t val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    /* test no write */
    cur = vatomic64_max_get_rlx(&obj, (vuint64_t)1);
    assert(cur == VUINT64_MAX);
    val = vatomic64_read(&obj);
    assert(val == VUINT64_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic64_and
 *****************************************************************************/
static inline void
ut_atomic_u64_and(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic64_and(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_and_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic64_and_rel(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_and_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic64_and_rlx(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_and
 *****************************************************************************/
static inline void
ut_atomic_u64_get_and(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic64_get_and(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_and_get
 *****************************************************************************/
static inline void
ut_atomic_u64_and_get(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic64_and_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_and_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_and_acq(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic64_get_and_acq(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_and_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_and_get_acq(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic64_and_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_and_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic64_get_and_rel(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_and_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_and_get_rel(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic64_and_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_and_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic64_get_and_rlx(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_and_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_and_get_rlx(void)
{
    vatomic64_t obj = {VUINT64_MAX};
    vuint64_t mask  = VUINT64_MAX;
    vuint64_t ref   = VUINT64_MAX;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic64_and_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or
 *****************************************************************************/
static inline void
ut_atomic_u64_or(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic64_or(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_or_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic64_or_rel(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_or_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic64_or_rlx(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_or
 *****************************************************************************/
static inline void
ut_atomic_u64_get_or(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic64_get_or(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get
 *****************************************************************************/
static inline void
ut_atomic_u64_or_get(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic64_or_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_or_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_or_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic64_get_or_acq(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_or_get_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic64_or_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_or_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic64_get_or_rel(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_or_get_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic64_or_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_or_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic64_get_or_rlx(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_or_get_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic64_or_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_xor
 *****************************************************************************/
static inline void
ut_atomic_u64_xor(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic64_xor(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_xor_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic64_xor_rel(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_xor_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic64_xor_rlx(&obj, mask);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_xor
 *****************************************************************************/
static inline void
ut_atomic_u64_get_xor(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic64_get_xor(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get
 *****************************************************************************/
static inline void
ut_atomic_u64_xor_get(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic64_xor_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_xor_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_get_xor_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic64_get_xor_acq(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u64_xor_get_acq(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic64_xor_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_get_xor_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic64_get_xor_rel(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u64_xor_get_rel(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic64_xor_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_get_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_get_xor_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0x33;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;
    vuint64_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic64_get_xor_rlx(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic64_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u64_xor_get_rlx(void)
{
    vatomic64_t obj = {(vuint64_t)1};
    vuint64_t mask  = 0xFF;
    vuint64_t ref   = (vuint64_t)1;
    vuint64_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint64_t); i++) {
        mask = (vuint64_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic64_xor_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic64_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    ut_atomic_u64_read();
    ut_atomic_u64_read_acq();
    ut_atomic_u64_read_rlx();

    ut_atomic_u64_init();

    ut_atomic_u64_write();
    ut_atomic_u64_write_rel();
    ut_atomic_u64_write_rlx();

    ut_atomic_u64_xchg();
    ut_atomic_u64_xchg_acq();
    ut_atomic_u64_xchg_rel();
    ut_atomic_u64_xchg_rlx();

    ut_atomic_u64_cmpxchg();
    ut_atomic_u64_cmpxchg_acq();
    ut_atomic_u64_cmpxchg_rel();
    ut_atomic_u64_cmpxchg_rlx();

    ut_atomic_u64_add();
    ut_atomic_u64_add_rel();
    ut_atomic_u64_add_rlx();
    ut_atomic_u64_get_add();
    ut_atomic_u64_add_get();
    ut_atomic_u64_get_add_acq();
    ut_atomic_u64_add_get_acq();
    ut_atomic_u64_get_add_rel();
    ut_atomic_u64_add_get_rel();
    ut_atomic_u64_get_add_rlx();
    ut_atomic_u64_add_get_rlx();

    ut_atomic_u64_inc();
    ut_atomic_u64_inc_rel();
    ut_atomic_u64_inc_rlx();
    ut_atomic_u64_get_inc();
    ut_atomic_u64_inc_get();
    ut_atomic_u64_get_inc_acq();
    ut_atomic_u64_inc_get_acq();
    ut_atomic_u64_get_inc_rel();
    ut_atomic_u64_inc_get_rel();
    ut_atomic_u64_get_inc_rlx();
    ut_atomic_u64_inc_get_rlx();

    ut_atomic_u64_sub();
    ut_atomic_u64_sub_rel();
    ut_atomic_u64_sub_rlx();
    ut_atomic_u64_get_sub();
    ut_atomic_u64_sub_get();
    ut_atomic_u64_get_sub_acq();
    ut_atomic_u64_sub_get_acq();
    ut_atomic_u64_get_sub_rel();
    ut_atomic_u64_sub_get_rel();
    ut_atomic_u64_get_sub_rlx();
    ut_atomic_u64_sub_get_rlx();

    ut_atomic_u64_dec();
    ut_atomic_u64_dec_rel();
    ut_atomic_u64_dec_rlx();
    ut_atomic_u64_get_dec();
    ut_atomic_u64_dec_get();
    ut_atomic_u64_get_dec_acq();
    ut_atomic_u64_dec_get_acq();
    ut_atomic_u64_get_dec_rel();
    ut_atomic_u64_dec_get_rel();
    ut_atomic_u64_get_dec_rlx();
    ut_atomic_u64_dec_get_rlx();

    ut_atomic_u64_max();
    ut_atomic_u64_max_rel();
    ut_atomic_u64_max_rlx();
    ut_atomic_u64_get_max();
    ut_atomic_u64_max_get();
    ut_atomic_u64_get_max_acq();
    ut_atomic_u64_max_get_acq();
    ut_atomic_u64_get_max_rel();
    ut_atomic_u64_max_get_rel();
    ut_atomic_u64_get_max_rlx();
    ut_atomic_u64_max_get_rlx();

    ut_atomic_u64_and();
    ut_atomic_u64_and_rel();
    ut_atomic_u64_and_rlx();
    ut_atomic_u64_get_and();
    ut_atomic_u64_and_get();
    ut_atomic_u64_get_and_acq();
    ut_atomic_u64_and_get_acq();
    ut_atomic_u64_get_and_rel();
    ut_atomic_u64_and_get_rel();
    ut_atomic_u64_get_and_rlx();
    ut_atomic_u64_and_get_rlx();

    ut_atomic_u64_or();
    ut_atomic_u64_or_rel();
    ut_atomic_u64_or_rlx();
    ut_atomic_u64_get_or();
    ut_atomic_u64_or_get();
    ut_atomic_u64_get_or_acq();
    ut_atomic_u64_or_get_acq();
    ut_atomic_u64_get_or_rel();
    ut_atomic_u64_or_get_rel();
    ut_atomic_u64_get_or_rlx();
    ut_atomic_u64_or_get_rlx();

    ut_atomic_u64_xor();
    ut_atomic_u64_xor_rel();
    ut_atomic_u64_xor_rlx();
    ut_atomic_u64_get_xor();
    ut_atomic_u64_xor_get();
    ut_atomic_u64_get_xor_acq();
    ut_atomic_u64_xor_get_acq();
    ut_atomic_u64_get_xor_rel();
    ut_atomic_u64_xor_get_rel();
    ut_atomic_u64_get_xor_rlx();
    ut_atomic_u64_xor_get_rlx();
    return 0;
}
