/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */
#ifndef VATOMIC_CORE_U8_HPP
#define VATOMIC_CORE_U8_HPP
/*!!!Warning: File generated by tmplr; DO NOT EDIT.!!!*/
extern "C" {
#include <vsync/atomic.h>
}
namespace vsync
{
    template <> struct atomic<vuint8_t> {
        atomic(const atomic &)                     = delete;
        atomic &operator=(const atomic &)          = delete;
        atomic &operator=(const atomic &) volatile = delete;

        atomic()
        {
            vatomic8_init(&_v, 0U);
        }
        atomic(vuint8_t v)
        {
            vatomic8_init(&_v, v);
        }
        vuint8_t
        load(memory_order order = memory_order_seq_cst) volatile const noexcept
        {
            switch (order) {
                case memory_order_consume:
                case memory_order_acquire:
                    return (vatomic8_read_acq(const_cast<vatomic8_t *>(&_v)));
                case memory_order_relaxed:
                    return (vatomic8_read_rlx(const_cast<vatomic8_t *>(&_v)));
                case memory_order_release:
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return (vatomic8_read(const_cast<vatomic8_t *>(&_v)));
            }
        }
        void store(vuint8_t v,
                   memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    vatomic8_write_rel(const_cast<vatomic8_t *>(&_v), v);
                    break;
                case memory_order_relaxed:
                    vatomic8_write_rlx(const_cast<vatomic8_t *>(&_v), v);
                    break;
                case memory_order_acquire:
                case memory_order_acq_rel:
                case memory_order_consume:
                case memory_order_seq_cst:
                default:
                    return vatomic8_write(const_cast<vatomic8_t *>(&_v), v);
            }
        }

        vuint8_t operator=(vuint8_t v) volatile noexcept
        {
            store(v);
            return v;
        }

        operator vuint8_t() volatile const noexcept
        {
            return load();
        }

        vuint8_t
        exchange(vuint8_t v,
                 memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return (
                        vatomic8_xchg_rel(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_relaxed:
                    return (
                        vatomic8_xchg_rlx(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return (
                        vatomic8_xchg_acq(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return (vatomic8_xchg(const_cast<vatomic8_t *>(&_v), v));
            }
        }

        bool compare_exchange_strong(
            vuint8_t &expected, vuint8_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) volatile noexcept
        {
            (void)failure;
            vuint8_t old = 0;
            switch (order) {
                case memory_order_release:
                    old = (vatomic8_cmpxchg_rel(const_cast<vatomic8_t *>(&_v),
                                                expected, desired));
                    break;
                case memory_order_relaxed:
                    old = (vatomic8_cmpxchg_rlx(const_cast<vatomic8_t *>(&_v),
                                                expected, desired));
                    break;
                case memory_order_consume:
                case memory_order_acquire:
                    old = (vatomic8_cmpxchg_acq(const_cast<vatomic8_t *>(&_v),
                                                expected, desired));
                    break;
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    old = (vatomic8_cmpxchg(const_cast<vatomic8_t *>(&_v),
                                            expected, desired));
                    break;
            }
            if (old == expected) {
                return true;
            } else {
                expected = old;
                return false;
            }
        }
        bool compare_exchange_weak(
            vuint8_t &expected, vuint8_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) volatile noexcept
        {
            return compare_exchange_strong(expected, desired, order, failure);
        }

        vuint8_t load(memory_order order = memory_order_seq_cst) const noexcept
        {
            switch (order) {
                case memory_order_consume:
                case memory_order_acquire:
                    return (vatomic8_read_acq((&_v)));
                case memory_order_relaxed:
                    return (vatomic8_read_rlx((&_v)));
                case memory_order_release:
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return (vatomic8_read((&_v)));
            }
        }
        void store(vuint8_t v,
                   memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    vatomic8_write_rel((&_v), v);
                    break;
                case memory_order_relaxed:
                    vatomic8_write_rlx((&_v), v);
                    break;
                case memory_order_acquire:
                case memory_order_acq_rel:
                case memory_order_consume:
                case memory_order_seq_cst:
                default:
                    return vatomic8_write((&_v), v);
            }
        }

        vuint8_t operator=(vuint8_t v) noexcept
        {
            store(v);
            return v;
        }

        operator vuint8_t() const noexcept
        {
            return load();
        }

        vuint8_t exchange(vuint8_t v,
                          memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return (vatomic8_xchg_rel((&_v), v));
                case memory_order_relaxed:
                    return (vatomic8_xchg_rlx((&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return (vatomic8_xchg_acq((&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return (vatomic8_xchg((&_v), v));
            }
        }

        bool compare_exchange_strong(
            vuint8_t &expected, vuint8_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) noexcept
        {
            (void)failure;
            vuint8_t old = 0;
            switch (order) {
                case memory_order_release:
                    old = (vatomic8_cmpxchg_rel((&_v), expected, desired));
                    break;
                case memory_order_relaxed:
                    old = (vatomic8_cmpxchg_rlx((&_v), expected, desired));
                    break;
                case memory_order_consume:
                case memory_order_acquire:
                    old = (vatomic8_cmpxchg_acq((&_v), expected, desired));
                    break;
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    old = (vatomic8_cmpxchg((&_v), expected, desired));
                    break;
            }
            if (old == expected) {
                return true;
            } else {
                expected = old;
                return false;
            }
        }
        bool compare_exchange_weak(
            vuint8_t &expected, vuint8_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) noexcept
        {
            return compare_exchange_strong(expected, desired, order, failure);
        }

        vuint8_t
        fetch_add(vuint8_t v,
                  memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return (
                        vatomic8_get_add_rel(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_relaxed:
                    return (
                        vatomic8_get_add_rlx(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return (
                        vatomic8_get_add_acq(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return (vatomic8_get_add(const_cast<vatomic8_t *>(&_v), v));
            }
        }
        vuint8_t operator+=(vuint8_t v) volatile noexcept
        {
            return fetch_add(v);
        }
        // v++
        vuint8_t operator++(int) volatile noexcept
        {
            return vatomic8_get_inc(const_cast<vatomic8_t *>(&_v));
        }
        // ++v
        vuint8_t operator++() volatile noexcept
        {
            return vatomic8_inc_get(const_cast<vatomic8_t *>(&_v));
        }

        vuint8_t
        fetch_sub(vuint8_t v,
                  memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_sub_rel(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_relaxed:
                    return vatomic8_get_sub_rlx(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_sub_acq(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_sub(const_cast<vatomic8_t *>(&_v), v);
            }
        }
        vuint8_t operator-=(vuint8_t v) volatile noexcept
        {
            return fetch_sub(v);
        }
        // v--
        vuint8_t operator--(int) volatile noexcept
        {
            return vatomic8_get_dec(const_cast<vatomic8_t *>(&_v));
        }
        // --v
        vuint8_t operator--() volatile noexcept
        {
            return vatomic8_dec_get(const_cast<vatomic8_t *>(&_v));
        }

        vuint8_t
        fetch_and(vuint8_t v,
                  memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_and_rel(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_relaxed:
                    return vatomic8_get_and_rlx(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_and_acq(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_and(const_cast<vatomic8_t *>(&_v), v);
            }
        }

        vuint8_t operator&=(vuint8_t v) volatile noexcept
        {
            return fetch_and(v);
        }

        vuint8_t
        fetch_or(vuint8_t v,
                 memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_or_rel(const_cast<vatomic8_t *>(&_v),
                                               v);
                case memory_order_relaxed:
                    return vatomic8_get_or_rlx(const_cast<vatomic8_t *>(&_v),
                                               v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_or_acq(const_cast<vatomic8_t *>(&_v),
                                               v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_or(const_cast<vatomic8_t *>(&_v), v);
            }
        }

        vuint8_t operator|=(vuint8_t v) volatile noexcept
        {
            return fetch_or(v);
        }

        vuint8_t
        fetch_xor(vuint8_t v,
                  memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_xor_rel(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_relaxed:
                    return vatomic8_get_xor_rlx(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_xor_acq(const_cast<vatomic8_t *>(&_v),
                                                v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_xor(const_cast<vatomic8_t *>(&_v), v);
            }
        }

        vuint8_t operator^=(vuint8_t v) volatile noexcept
        {
            return fetch_xor(v);
        }
        vuint8_t fetch_add(vuint8_t v,
                           memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return (vatomic8_get_add_rel((&_v), v));
                case memory_order_relaxed:
                    return (vatomic8_get_add_rlx((&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return (vatomic8_get_add_acq((&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return (vatomic8_get_add((&_v), v));
            }
        }
        vuint8_t operator+=(vuint8_t v) noexcept
        {
            return fetch_add(v);
        }
        // v++
        vuint8_t operator++(int) noexcept
        {
            return vatomic8_get_inc((&_v));
        }
        // ++v
        vuint8_t operator++() noexcept
        {
            return vatomic8_inc_get((&_v));
        }

        vuint8_t fetch_sub(vuint8_t v,
                           memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_sub_rel((&_v), v);
                case memory_order_relaxed:
                    return vatomic8_get_sub_rlx((&_v), v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_sub_acq((&_v), v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_sub((&_v), v);
            }
        }
        vuint8_t operator-=(vuint8_t v) noexcept
        {
            return fetch_sub(v);
        }
        // v--
        vuint8_t operator--(int) noexcept
        {
            return vatomic8_get_dec((&_v));
        }
        // --v
        vuint8_t operator--() noexcept
        {
            return vatomic8_dec_get((&_v));
        }

        vuint8_t fetch_and(vuint8_t v,
                           memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_and_rel((&_v), v);
                case memory_order_relaxed:
                    return vatomic8_get_and_rlx((&_v), v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_and_acq((&_v), v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_and((&_v), v);
            }
        }

        vuint8_t operator&=(vuint8_t v) noexcept
        {
            return fetch_and(v);
        }

        vuint8_t fetch_or(vuint8_t v,
                          memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_or_rel((&_v), v);
                case memory_order_relaxed:
                    return vatomic8_get_or_rlx((&_v), v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_or_acq((&_v), v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_or((&_v), v);
            }
        }

        vuint8_t operator|=(vuint8_t v) noexcept
        {
            return fetch_or(v);
        }

        vuint8_t fetch_xor(vuint8_t v,
                           memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return vatomic8_get_xor_rel((&_v), v);
                case memory_order_relaxed:
                    return vatomic8_get_xor_rlx((&_v), v);
                case memory_order_consume:
                case memory_order_acquire:
                    return vatomic8_get_xor_acq((&_v), v);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return vatomic8_get_xor((&_v), v);
            }
        }

        vuint8_t operator^=(vuint8_t v) noexcept
        {
            return fetch_xor(v);
        }
        bool is_lock_free() volatile const noexcept
        {
            return true;
        }
        bool is_lock_free() const noexcept
        {
            return true;
        }

      private:
        vatomic8_t _v;
    };
}; // namespace vsync

#endif
