/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */
#ifndef VATOMIC_CORE_PTR_HPP
#define VATOMIC_CORE_PTR_HPP
/*!!!Warning: File generated by tmplr; DO NOT EDIT.!!!*/
extern "C" {
#include <vsync/atomic.h>
}
namespace vsync
{
    template <typename PTR> struct atomic<PTR *> {
        atomic(const atomic &)                     = delete;
        atomic &operator=(const atomic &)          = delete;
        atomic &operator=(const atomic &) volatile = delete;

        atomic()
        {
            vatomicptr_init(&_v, nullptr);
        }
        atomic(PTR *v)
        {
            vatomicptr_init(&_v, v);
        }
        PTR *
        load(memory_order order = memory_order_seq_cst) volatile const noexcept
        {
            switch (order) {
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<PTR *>(
                        vatomicptr_read_acq(const_cast<vatomicptr_t *>(&_v)));
                case memory_order_relaxed:
                    return static_cast<PTR *>(
                        vatomicptr_read_rlx(const_cast<vatomicptr_t *>(&_v)));
                case memory_order_release:
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<PTR *>(
                        vatomicptr_read(const_cast<vatomicptr_t *>(&_v)));
            }
        }
        void store(PTR *v,
                   memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    vatomicptr_write_rel(const_cast<vatomicptr_t *>(&_v), v);
                    break;
                case memory_order_relaxed:
                    vatomicptr_write_rlx(const_cast<vatomicptr_t *>(&_v), v);
                    break;
                case memory_order_acquire:
                case memory_order_acq_rel:
                case memory_order_consume:
                case memory_order_seq_cst:
                default:
                    return vatomicptr_write(const_cast<vatomicptr_t *>(&_v), v);
            }
        }

        PTR *operator=(PTR *v) volatile noexcept
        {
            store(v);
            return v;
        }

        operator PTR *() volatile const noexcept
        {
            return load();
        }

        PTR *
        exchange(PTR *v,
                 memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return static_cast<PTR *>(vatomicptr_xchg_rel(
                        const_cast<vatomicptr_t *>(&_v), v));
                case memory_order_relaxed:
                    return static_cast<PTR *>(vatomicptr_xchg_rlx(
                        const_cast<vatomicptr_t *>(&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<PTR *>(vatomicptr_xchg_acq(
                        const_cast<vatomicptr_t *>(&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<PTR *>(
                        vatomicptr_xchg(const_cast<vatomicptr_t *>(&_v), v));
            }
        }

        bool compare_exchange_strong(
            PTR *&expected, PTR *desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) volatile noexcept
        {
            (void)failure;
            PTR *old = 0;
            switch (order) {
                case memory_order_release:
                    old = static_cast<PTR *>(vatomicptr_cmpxchg_rel(
                        const_cast<vatomicptr_t *>(&_v), expected, desired));
                    break;
                case memory_order_relaxed:
                    old = static_cast<PTR *>(vatomicptr_cmpxchg_rlx(
                        const_cast<vatomicptr_t *>(&_v), expected, desired));
                    break;
                case memory_order_consume:
                case memory_order_acquire:
                    old = static_cast<PTR *>(vatomicptr_cmpxchg_acq(
                        const_cast<vatomicptr_t *>(&_v), expected, desired));
                    break;
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    old = static_cast<PTR *>(vatomicptr_cmpxchg(
                        const_cast<vatomicptr_t *>(&_v), expected, desired));
                    break;
            }
            if (old == expected) {
                return true;
            } else {
                expected = old;
                return false;
            }
        }
        bool compare_exchange_weak(
            PTR *&expected, PTR *desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) volatile noexcept
        {
            return compare_exchange_strong(expected, desired, order, failure);
        }

        PTR *load(memory_order order = memory_order_seq_cst) const noexcept
        {
            switch (order) {
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<PTR *>(vatomicptr_read_acq((&_v)));
                case memory_order_relaxed:
                    return static_cast<PTR *>(vatomicptr_read_rlx((&_v)));
                case memory_order_release:
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<PTR *>(vatomicptr_read((&_v)));
            }
        }
        void store(PTR *v, memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    vatomicptr_write_rel((&_v), v);
                    break;
                case memory_order_relaxed:
                    vatomicptr_write_rlx((&_v), v);
                    break;
                case memory_order_acquire:
                case memory_order_acq_rel:
                case memory_order_consume:
                case memory_order_seq_cst:
                default:
                    return vatomicptr_write((&_v), v);
            }
        }

        PTR *operator=(PTR *v) noexcept
        {
            store(v);
            return v;
        }

        operator PTR *() const noexcept
        {
            return load();
        }

        PTR *exchange(PTR *v,
                      memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return static_cast<PTR *>(vatomicptr_xchg_rel((&_v), v));
                case memory_order_relaxed:
                    return static_cast<PTR *>(vatomicptr_xchg_rlx((&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<PTR *>(vatomicptr_xchg_acq((&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<PTR *>(vatomicptr_xchg((&_v), v));
            }
        }

        bool compare_exchange_strong(
            PTR *&expected, PTR *desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) noexcept
        {
            (void)failure;
            PTR *old = 0;
            switch (order) {
                case memory_order_release:
                    old = static_cast<PTR *>(
                        vatomicptr_cmpxchg_rel((&_v), expected, desired));
                    break;
                case memory_order_relaxed:
                    old = static_cast<PTR *>(
                        vatomicptr_cmpxchg_rlx((&_v), expected, desired));
                    break;
                case memory_order_consume:
                case memory_order_acquire:
                    old = static_cast<PTR *>(
                        vatomicptr_cmpxchg_acq((&_v), expected, desired));
                    break;
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    old = static_cast<PTR *>(
                        vatomicptr_cmpxchg((&_v), expected, desired));
                    break;
            }
            if (old == expected) {
                return true;
            } else {
                expected = old;
                return false;
            }
        }
        bool compare_exchange_weak(
            PTR *&expected, PTR *desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) noexcept
        {
            return compare_exchange_strong(expected, desired, order, failure);
        }

        PTR *
        fetch_add(ptrdiff_t v,
                  memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return add_rel(v, true);
                case memory_order_relaxed:
                    return add_rlx(v, true);
                case memory_order_consume:
                case memory_order_acquire:
                    return add_acq(v, true);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return add(v, true);
            }
        }
        PTR *operator+=(ptrdiff_t v) volatile noexcept
        {
            return add(v, true);
        }
        // ptr++
        PTR *operator++(int) volatile noexcept
        {
            return add(1, true);
        }
        // ++ptr
        PTR *operator++() volatile noexcept
        {
            return add(1, false);
        }

        PTR *
        fetch_sub(ptrdiff_t v,
                  memory_order order = memory_order_seq_cst) volatile noexcept
        {
            return fetch_add(-v, order);
        }

        PTR *operator-=(ptrdiff_t v) volatile noexcept
        {
            return add(-v, true);
        }
        // ptr--
        PTR *operator--(int) volatile noexcept
        {
            return add(-1, true);
        }
        // --ptr
        PTR *operator--() volatile noexcept
        {
            return add(-1, false);
        }
        PTR *fetch_add(ptrdiff_t v,
                       memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return add_rel(v, true);
                case memory_order_relaxed:
                    return add_rlx(v, true);
                case memory_order_consume:
                case memory_order_acquire:
                    return add_acq(v, true);
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return add(v, true);
            }
        }
        PTR *operator+=(ptrdiff_t v) noexcept
        {
            return add(v, true);
        }
        // ptr++
        PTR *operator++(int) noexcept
        {
            return add(1, true);
        }
        // ++ptr
        PTR *operator++() noexcept
        {
            return add(1, false);
        }

        PTR *fetch_sub(ptrdiff_t v,
                       memory_order order = memory_order_seq_cst) noexcept
        {
            return fetch_add(-v, order);
        }

        PTR *operator-=(ptrdiff_t v) noexcept
        {
            return add(-v, true);
        }
        // ptr--
        PTR *operator--(int) noexcept
        {
            return add(-1, true);
        }
        // --ptr
        PTR *operator--() noexcept
        {
            return add(-1, false);
        }
        inline PTR *add(ptrdiff_t v, bool return_old) volatile
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(
                vatomicptr_read(const_cast<vatomicptr_t *>(&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(vatomicptr_cmpxchg(
                         const_cast<vatomicptr_t *>(&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add(ptrdiff_t v, bool return_old)
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(vatomicptr_read((&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(
                    vatomicptr_cmpxchg((&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add_acq(ptrdiff_t v, bool return_old) volatile
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(
                vatomicptr_read(const_cast<vatomicptr_t *>(&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(vatomicptr_cmpxchg_acq(
                         const_cast<vatomicptr_t *>(&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add_acq(ptrdiff_t v, bool return_old)
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(vatomicptr_read((&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(
                    vatomicptr_cmpxchg_acq((&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add_rel(ptrdiff_t v, bool return_old) volatile
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(
                vatomicptr_read(const_cast<vatomicptr_t *>(&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(vatomicptr_cmpxchg_rel(
                         const_cast<vatomicptr_t *>(&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add_rel(ptrdiff_t v, bool return_old)
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(vatomicptr_read((&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(
                    vatomicptr_cmpxchg_rel((&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add_rlx(ptrdiff_t v, bool return_old) volatile
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(
                vatomicptr_read(const_cast<vatomicptr_t *>(&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(vatomicptr_cmpxchg_rlx(
                         const_cast<vatomicptr_t *>(&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        inline PTR *add_rlx(ptrdiff_t v, bool return_old)
        {
            PTR *old      = nullptr;
            PTR *expected = nullptr;
            PTR *desired  = nullptr;
            old           = static_cast<PTR *>(vatomicptr_read((&_v)));
            do {
                expected = old;
                desired  = expected + v;
                old      = static_cast<PTR *>(
                    vatomicptr_cmpxchg_rlx((&_v), expected, desired));
            } while (old != expected);
            return return_old ? old : desired;
        }
        bool is_lock_free() volatile const noexcept
        {
            return true;
        }
        bool is_lock_free() const noexcept
        {
            return true;
        }

      private:
        vatomicptr_t _v;
    };
}; // namespace vsync

#endif
