/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */
#ifndef VATOMIC_CORE_BOOL_HPP
#define VATOMIC_CORE_BOOL_HPP
/*!!!Warning: File generated by tmplr; DO NOT EDIT.!!!*/
extern "C" {
#include <vsync/atomic.h>
}
namespace vsync
{
    template <> struct atomic<vbool_t> {
        atomic(const atomic &)                     = delete;
        atomic &operator=(const atomic &)          = delete;
        atomic &operator=(const atomic &) volatile = delete;

        atomic()
        {
            vatomic8_init(&_v, false);
        }
        atomic(vbool_t v)
        {
            vatomic8_init(&_v, v);
        }
        vbool_t
        load(memory_order order = memory_order_seq_cst) volatile const noexcept
        {
            switch (order) {
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<vbool_t>(
                        vatomic8_read_acq(const_cast<vatomic8_t *>(&_v)));
                case memory_order_relaxed:
                    return static_cast<vbool_t>(
                        vatomic8_read_rlx(const_cast<vatomic8_t *>(&_v)));
                case memory_order_release:
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<vbool_t>(
                        vatomic8_read(const_cast<vatomic8_t *>(&_v)));
            }
        }
        void store(vbool_t v,
                   memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    vatomic8_write_rel(const_cast<vatomic8_t *>(&_v), v);
                    break;
                case memory_order_relaxed:
                    vatomic8_write_rlx(const_cast<vatomic8_t *>(&_v), v);
                    break;
                case memory_order_acquire:
                case memory_order_acq_rel:
                case memory_order_consume:
                case memory_order_seq_cst:
                default:
                    return vatomic8_write(const_cast<vatomic8_t *>(&_v), v);
            }
        }

        vbool_t operator=(vbool_t v) volatile noexcept
        {
            store(v);
            return v;
        }

        operator vbool_t() volatile const noexcept
        {
            return load();
        }

        vbool_t
        exchange(vbool_t v,
                 memory_order order = memory_order_seq_cst) volatile noexcept
        {
            switch (order) {
                case memory_order_release:
                    return static_cast<vbool_t>(
                        vatomic8_xchg_rel(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_relaxed:
                    return static_cast<vbool_t>(
                        vatomic8_xchg_rlx(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<vbool_t>(
                        vatomic8_xchg_acq(const_cast<vatomic8_t *>(&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<vbool_t>(
                        vatomic8_xchg(const_cast<vatomic8_t *>(&_v), v));
            }
        }

        bool compare_exchange_strong(
            vbool_t &expected, vbool_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) volatile noexcept
        {
            (void)failure;
            vbool_t old = 0;
            switch (order) {
                case memory_order_release:
                    old = static_cast<vbool_t>(vatomic8_cmpxchg_rel(
                        const_cast<vatomic8_t *>(&_v), expected, desired));
                    break;
                case memory_order_relaxed:
                    old = static_cast<vbool_t>(vatomic8_cmpxchg_rlx(
                        const_cast<vatomic8_t *>(&_v), expected, desired));
                    break;
                case memory_order_consume:
                case memory_order_acquire:
                    old = static_cast<vbool_t>(vatomic8_cmpxchg_acq(
                        const_cast<vatomic8_t *>(&_v), expected, desired));
                    break;
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    old = static_cast<vbool_t>(vatomic8_cmpxchg(
                        const_cast<vatomic8_t *>(&_v), expected, desired));
                    break;
            }
            if (old == expected) {
                return true;
            } else {
                expected = old;
                return false;
            }
        }
        bool compare_exchange_weak(
            vbool_t &expected, vbool_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) volatile noexcept
        {
            return compare_exchange_strong(expected, desired, order, failure);
        }

        vbool_t load(memory_order order = memory_order_seq_cst) const noexcept
        {
            switch (order) {
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<vbool_t>(vatomic8_read_acq((&_v)));
                case memory_order_relaxed:
                    return static_cast<vbool_t>(vatomic8_read_rlx((&_v)));
                case memory_order_release:
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<vbool_t>(vatomic8_read((&_v)));
            }
        }
        void store(vbool_t v,
                   memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    vatomic8_write_rel((&_v), v);
                    break;
                case memory_order_relaxed:
                    vatomic8_write_rlx((&_v), v);
                    break;
                case memory_order_acquire:
                case memory_order_acq_rel:
                case memory_order_consume:
                case memory_order_seq_cst:
                default:
                    return vatomic8_write((&_v), v);
            }
        }

        vbool_t operator=(vbool_t v) noexcept
        {
            store(v);
            return v;
        }

        operator vbool_t() const noexcept
        {
            return load();
        }

        vbool_t exchange(vbool_t v,
                         memory_order order = memory_order_seq_cst) noexcept
        {
            switch (order) {
                case memory_order_release:
                    return static_cast<vbool_t>(vatomic8_xchg_rel((&_v), v));
                case memory_order_relaxed:
                    return static_cast<vbool_t>(vatomic8_xchg_rlx((&_v), v));
                case memory_order_consume:
                case memory_order_acquire:
                    return static_cast<vbool_t>(vatomic8_xchg_acq((&_v), v));
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    return static_cast<vbool_t>(vatomic8_xchg((&_v), v));
            }
        }

        bool compare_exchange_strong(
            vbool_t &expected, vbool_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) noexcept
        {
            (void)failure;
            vbool_t old = 0;
            switch (order) {
                case memory_order_release:
                    old = static_cast<vbool_t>(
                        vatomic8_cmpxchg_rel((&_v), expected, desired));
                    break;
                case memory_order_relaxed:
                    old = static_cast<vbool_t>(
                        vatomic8_cmpxchg_rlx((&_v), expected, desired));
                    break;
                case memory_order_consume:
                case memory_order_acquire:
                    old = static_cast<vbool_t>(
                        vatomic8_cmpxchg_acq((&_v), expected, desired));
                    break;
                case memory_order_acq_rel:
                case memory_order_seq_cst:
                default:
                    old = static_cast<vbool_t>(
                        vatomic8_cmpxchg((&_v), expected, desired));
                    break;
            }
            if (old == expected) {
                return true;
            } else {
                expected = old;
                return false;
            }
        }
        bool compare_exchange_weak(
            vbool_t &expected, vbool_t desired,
            memory_order order   = memory_order_seq_cst,
            memory_order failure = memory_order_seq_cst) noexcept
        {
            return compare_exchange_strong(expected, desired, order, failure);
        }

        bool is_lock_free() volatile const noexcept
        {
            return true;
        }
        bool is_lock_free() const noexcept
        {
            return true;
        }

      private:
        vatomic8_t _v;
    };
}; // namespace vsync

#endif
