// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i16x8_cmp.wast

// ./test/core/simd/simd_i16x8_cmp.wast:4
let $0 = instantiate(`(module
  (func (export "eq") (param \$x v128) (param \$y v128) (result v128) (i16x8.eq (local.get \$x) (local.get \$y)))
  (func (export "ne") (param \$x v128) (param \$y v128) (result v128) (i16x8.ne (local.get \$x) (local.get \$y)))
  (func (export "lt_s") (param \$x v128) (param \$y v128) (result v128) (i16x8.lt_s (local.get \$x) (local.get \$y)))
  (func (export "lt_u") (param \$x v128) (param \$y v128) (result v128) (i16x8.lt_u (local.get \$x) (local.get \$y)))
  (func (export "le_s") (param \$x v128) (param \$y v128) (result v128) (i16x8.le_s (local.get \$x) (local.get \$y)))
  (func (export "le_u") (param \$x v128) (param \$y v128) (result v128) (i16x8.le_u (local.get \$x) (local.get \$y)))
  (func (export "gt_s") (param \$x v128) (param \$y v128) (result v128) (i16x8.gt_s (local.get \$x) (local.get \$y)))
  (func (export "gt_u") (param \$x v128) (param \$y v128) (result v128) (i16x8.gt_u (local.get \$x) (local.get \$y)))
  (func (export "ge_s") (param \$x v128) (param \$y v128) (result v128) (i16x8.ge_s (local.get \$x) (local.get \$y)))
  (func (export "ge_u") (param \$x v128) (param \$y v128) (result v128) (i16x8.ge_u (local.get \$x) (local.get \$y)))
)`);

// ./test/core/simd/simd_i16x8_cmp.wast:23
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:26
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:29
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:32
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:35
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:38
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:41
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:46
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:49
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:52
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:55
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:58
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:63
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:66
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:69
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:72
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:75
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:78
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:81
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:86
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:89
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:94
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:97
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:100
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:103
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:106
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:111
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:114
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:117
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:120
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:123
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:126
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:129
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:134
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:137
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:140
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:143
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:146
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:149
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0x0, 0x0, 0x1, 0x1, 0x8000, 0x8000]),
    i32x4([0xffff, 0x0, 0x1, 0x8000]),
  ]),
  [i16x8([0xffff, 0x0, 0xffff, 0xffff, 0xffff, 0x0, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:152
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:155
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:158
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:167
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:170
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:173
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:176
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:179
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:182
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:185
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:190
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:193
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:196
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:199
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:202
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:207
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:210
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:213
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:216
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:219
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:222
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:225
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xff, 0x7fff, 0x0, 0x0, 0x1, 0x2, 0xfffe, 0xffff]),
    i16x8([0xff, 0x7fff, 0x0, 0x0, 0x1, 0x2, 0xfffe, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:230
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:233
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:238
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:241
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:244
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:247
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x8081, 0x8283, 0xfdfe, 0xff00, 0x1, 0x27f, 0x80fd, 0xfeff]),
    i16x8([0xfeff, 0x80fd, 0x27f, 0x1, 0xff00, 0xfdfe, 0x8283, 0x8081]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:250
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x80, 0x81, 0x82, 0x83, 0x0, 0xff, 0x7ffe, 0x7fff]),
    i16x8([0x7fff, 0x7ffe, 0xff, 0x0, 0x83, 0x82, 0x81, 0x1c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:255
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:258
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:261
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:264
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:267
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:270
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:273
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:278
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:281
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:284
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:287
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:290
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:293
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0x0, 0xffff, 0x0, 0x0, 0x0, 0xffff, 0x0, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:296
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:299
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:302
assert_return(
  () => invoke($0, `ne`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:311
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:314
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:317
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:320
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:323
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:326
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:329
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:332
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:335
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:338
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:341
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:344
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:347
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:350
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:353
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:356
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:359
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:362
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:365
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xff, 0x7fff, 0x0, 0x0, 0x1, 0x2, 0xfffe, 0xffff]),
    i16x8([0xff, 0x7fff, 0x0, 0x0, 0x1, 0x2, 0xfffe, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:368
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:371
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:376
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:379
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:382
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0x0, 0x0, 0xffff, 0x0, 0x0, 0x0, 0x0, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:385
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x8081, 0x8283, 0xfdfe, 0xff00, 0x1, 0x27f, 0x80fd, 0xfeff]),
    i16x8([0xfeff, 0x80fd, 0x27f, 0x1, 0xff00, 0xfdfe, 0x8283, 0x8081]),
  ]),
  [i16x8([0xffff, 0x0, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:388
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x80, 0x81, 0x82, 0x83, 0x0, 0xff, 0x7ffe, 0x7fff]),
    i16x8([0x7fff, 0x7ffe, 0xff, 0x0, 0x83, 0x82, 0x81, 0x1c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0x0, 0xffff, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:393
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:396
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:399
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:402
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:405
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:408
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:411
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:416
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:419
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:422
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:425
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:428
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:431
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0x0, 0xffff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:434
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:437
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:440
assert_return(
  () => invoke($0, `lt_s`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:449
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:452
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:455
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:458
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:461
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:464
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:467
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:472
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:475
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:478
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:481
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:484
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:489
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:492
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:495
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:498
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:501
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:504
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:507
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xff, 0x7fff, 0x0, 0x0, 0x1, 0x2, 0xfffe, 0xffff]),
    i16x8([0xff, 0x7fff, 0x0, 0x0, 0x1, 0x2, 0xfffe, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:512
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:515
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:520
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:523
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:526
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:529
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x8081, 0x8283, 0xfdfe, 0xff00, 0x1, 0x27f, 0x80fd, 0xfeff]),
    i16x8([0xfeff, 0x80fd, 0x27f, 0x1, 0xff00, 0xfdfe, 0x8283, 0x8081]),
  ]),
  [i16x8([0xffff, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:532
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x80, 0x81, 0x82, 0x83, 0x0, 0xff, 0x7ffe, 0x7fff]),
    i16x8([0x7fff, 0x7ffe, 0xff, 0x0, 0x83, 0x82, 0x81, 0x1c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0x0, 0xffff, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:537
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:540
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:543
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:546
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:549
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:552
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:555
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:560
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:563
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:566
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:569
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:572
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:575
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0x0, 0xffff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:578
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:581
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:584
assert_return(
  () => invoke($0, `lt_u`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:593
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:596
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:599
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:602
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:605
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:608
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:611
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:616
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:619
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:622
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:625
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:628
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:633
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:636
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:639
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:642
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:645
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:648
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:651
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:656
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:659
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:664
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:667
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:670
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0x0, 0x0, 0xffff, 0x0, 0x0, 0x0, 0x0, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:673
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:676
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:681
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:684
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:687
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:690
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:693
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:696
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:699
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:704
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:707
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:710
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:713
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:716
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:719
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:722
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:725
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:728
assert_return(
  () => invoke($0, `le_s`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:737
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:740
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:743
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:746
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:749
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:752
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:755
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:760
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:763
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:766
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:769
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:772
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:777
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:780
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:783
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:786
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:789
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:792
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:795
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:800
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:803
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:808
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:811
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:814
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:817
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:820
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0x0, 0xffff, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:825
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:828
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:831
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:834
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:837
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:840
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:843
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:848
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:851
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:854
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:857
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:860
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:863
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:866
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:869
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:872
assert_return(
  () => invoke($0, `le_u`, [
    i16x8([0xedcb, 0xedcb, 0xedcb, 0xedcb, 0xedcb, 0xedcb, 0xedcb, 0xedcb]),
    i16x8([0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:881
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:884
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:887
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:890
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:893
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:896
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:899
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:904
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:907
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:910
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:913
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:916
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:921
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:924
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:927
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:930
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:933
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:936
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:939
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:944
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:947
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:952
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:955
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:958
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:961
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:964
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:969
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:972
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:975
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:978
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:981
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:984
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:987
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:992
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:995
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:998
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1001
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1004
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1007
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0xffff, 0xffff, 0x0, 0x0, 0x1, 0x1, 0x8000, 0x8000]),
    i32x4([0xffff, 0x0, 0x1, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0xffff, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1010
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1013
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1016
assert_return(
  () => invoke($0, `gt_s`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1025
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1028
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1031
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1034
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1037
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1040
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1043
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1048
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1051
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1054
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1057
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1060
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1065
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1068
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1071
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1074
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1077
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1080
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1083
assert_return(
  () => invoke($0, `eq`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1088
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1091
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1096
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1099
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1102
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1105
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1108
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0xffff, 0x0, 0xffff, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1113
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1116
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1119
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1122
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1125
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1128
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1131
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i8x16([0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1136
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1139
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1142
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1145
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1148
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1151
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0xffff, 0x0, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1154
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1157
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1160
assert_return(
  () => invoke($0, `gt_u`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1169
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1172
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1175
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1178
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1181
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1184
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1187
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1192
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1195
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1198
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1201
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1204
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1209
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1212
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1215
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1218
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1221
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1224
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1227
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1232
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1235
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1240
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1243
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1246
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1249
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1252
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1257
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1260
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1263
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1266
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1269
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1272
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1275
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1280
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1283
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1286
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1289
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1292
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1295
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0xffff, 0xffff, 0x0, 0x0, 0x1, 0x1, 0x8000, 0x8000]),
    i32x4([0xffff, 0x0, 0x1, 0x8000]),
  ]),
  [i16x8([0xffff, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1298
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1301
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1304
assert_return(
  () => invoke($0, `ge_s`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1313
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1316
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1319
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1322
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1325
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1328
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1331
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
    i16x8([0x100, 0x302, 0x904, 0x1110, 0xa12, 0x1a0b, 0xaa1b, 0xffab]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1336
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1339
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1342
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1345
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1348
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1353
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1356
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1359
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1362
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1365
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1368
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1371
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
    i16x8([0x8000, 0xfffe, 0xffff, 0x0, 0x0, 0x1, 0x2, 0xffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1376
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0xc300, 0x0, 0xc2fe, 0x0, 0xbf80, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1379
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x3f80, 0x0, 0x42fe, 0x0, 0x4300, 0x0, 0x437f]),
    f32x4([1, 127, 128, 255]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1384
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f, 0xf0f]),
    i16x8([0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1387
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1390
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x1, 0x203, 0x409, 0x1011, 0x120a, 0xb1a, 0x1baa, 0xabff]),
    i16x8([0xffab, 0xaa1b, 0x1a0b, 0xa12, 0x1110, 0x904, 0x302, 0x100]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1393
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007]),
    i16x8([0x8007, 0x8006, 0x8005, 0x8004, 0x8003, 0x8002, 0x8001, 0x8000]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1396
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8000, 0x8001, 0xfffe, 0xffff, 0x0, 0xffff, 0x8001, 0x8000]),
    i16x8([0x8000, 0x8001, 0xffff, 0x0, 0xffff, 0xfffe, 0x8001, 0x8000]),
  ]),
  [i16x8([0xffff, 0xffff, 0x0, 0xffff, 0x0, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1401
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1404
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1407
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1410
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1413
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1416
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1419
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1424
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1427
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1430
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1433
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1436
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1439
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0xffff, 0xffff, 0x0, 0x0, 0x1, 0x1, 0x8000, 0x8000]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1442
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555, 0x5555]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1445
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
    i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1448
assert_return(
  () => invoke($0, `ge_u`, [
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
    i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
  ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_cmp.wast:1455
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.eq (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1456
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.ge_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1457
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.ge_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1458
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.gt_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1459
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.gt_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1460
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.le_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1461
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.le_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1462
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.lt_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1463
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.lt_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1464
assert_invalid(
  () => instantiate(`(module (func (result v128) (i16x8.ne (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1469
let $1 = instantiate(`(module (memory 1)
  (func (export "eq-in-block")
    (block
      (drop
        (block (result v128)
          (i16x8.eq
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "ne-in-block")
    (block
      (drop
        (block (result v128)
          (i16x8.ne
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "lt_s-in-block")
    (block
      (drop
        (block (result v128)
          (i16x8.lt_s
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "le_u-in-block")
    (block
      (drop
        (block (result v128)
          (i16x8.le_u
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "gt_u-in-block")
    (block
      (drop
        (block (result v128)
          (i16x8.gt_u
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "ge_s-in-block")
    (block
      (drop
        (block (result v128)
          (i16x8.ge_s
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "nested-eq")
    (drop
      (i16x8.eq
        (i16x8.eq
          (i16x8.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.eq
          (i16x8.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-ne")
    (drop
      (i16x8.ne
        (i16x8.ne
          (i16x8.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.ne
          (i16x8.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-lt_s")
    (drop
      (i16x8.lt_s
        (i16x8.lt_s
          (i16x8.lt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.lt_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.lt_s
          (i16x8.lt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.lt_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-le_u")
    (drop
      (i16x8.le_u
        (i16x8.le_u
          (i16x8.le_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.le_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.le_u
          (i16x8.le_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.le_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-gt_u")
    (drop
      (i16x8.gt_u
        (i16x8.gt_u
          (i16x8.gt_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.gt_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.gt_u
          (i16x8.gt_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.gt_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-ge_s")
    (drop
      (i16x8.ge_s
        (i16x8.ge_s
          (i16x8.ge_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.ge_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.ge_s
          (i16x8.ge_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.ge_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "as-param")
    (drop
      (i16x8.ge_u
        (i16x8.eq
          (i16x8.lt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.le_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i16x8.ne
          (i16x8.gt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i16x8.lt_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
)`);

// ./test/core/simd/simd_i16x8_cmp.wast:1725
assert_return(() => invoke($1, `eq-in-block`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1726
assert_return(() => invoke($1, `ne-in-block`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1727
assert_return(() => invoke($1, `lt_s-in-block`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1728
assert_return(() => invoke($1, `le_u-in-block`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1729
assert_return(() => invoke($1, `gt_u-in-block`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1730
assert_return(() => invoke($1, `ge_s-in-block`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1731
assert_return(() => invoke($1, `nested-eq`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1732
assert_return(() => invoke($1, `nested-ne`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1733
assert_return(() => invoke($1, `nested-lt_s`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1734
assert_return(() => invoke($1, `nested-le_u`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1735
assert_return(() => invoke($1, `nested-gt_u`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1736
assert_return(() => invoke($1, `nested-ge_s`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1737
assert_return(() => invoke($1, `as-param`, []), []);

// ./test/core/simd/simd_i16x8_cmp.wast:1742
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.eq-1st-arg-empty (result v128)
      (i16x8.eq (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1750
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.eq-arg-empty (result v128)
      (i16x8.eq)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1758
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.ne-1st-arg-empty (result v128)
      (i16x8.ne (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1766
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.ne-arg-empty (result v128)
      (i16x8.ne)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1774
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.lt_s-1st-arg-empty (result v128)
      (i16x8.lt_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1782
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.lt_s-arg-empty (result v128)
      (i16x8.lt_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1790
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.lt_u-1st-arg-empty (result v128)
      (i16x8.lt_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1798
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.lt_u-arg-empty (result v128)
      (i16x8.lt_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1806
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.le_s-1st-arg-empty (result v128)
      (i16x8.le_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1814
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.le_s-arg-empty (result v128)
      (i16x8.le_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1822
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.le_u-1st-arg-empty (result v128)
      (i16x8.le_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1830
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.le_u-arg-empty (result v128)
      (i16x8.le_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1838
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.gt_s-1st-arg-empty (result v128)
      (i16x8.gt_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1846
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.gt_s-arg-empty (result v128)
      (i16x8.gt_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1854
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.gt_u-1st-arg-empty (result v128)
      (i16x8.gt_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1862
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.gt_u-arg-empty (result v128)
      (i16x8.gt_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1870
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.ge_s-1st-arg-empty (result v128)
      (i16x8.ge_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1878
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.ge_s-arg-empty (result v128)
      (i16x8.ge_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1886
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.ge_u-1st-arg-empty (result v128)
      (i16x8.ge_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_cmp.wast:1894
assert_invalid(
  () => instantiate(`(module
    (func \$i16x8.ge_u-arg-empty (result v128)
      (i16x8.ge_u)
    )
  )`),
  `type mismatch`,
);
