# MD036 - Use real headings, not just bold text

Aliases: `no-emphasis-as-heading`

## What this rule does

Detects when bold or italic text is used as a standalone heading.

## Why this matters

- **Better document structure**: Real headings create a proper outline that tools can understand
- **Improved accessibility**: Screen readers rely on heading tags to navigate documents
- **Enables navigation**: Proper headings allow table of contents generation and quick jumping
- **Cleaner formatting**: Headings have consistent styling across different viewers

## Examples

<!-- rumdl-disable MD036 -->

### ✅ Correct

Using proper heading syntax:

```markdown
# Main Title

## Section Heading

This paragraph contains **bold text** and *italic text* inline.

**Table of Contents**  <!-- Allowed exception -->
```

### ❌ Incorrect

Using emphasis as headings:

```markdown
**This looks like a heading**

*Another section title*

***Important Section***

**Configuration:**
```

### 🔧 Fixed Output (when auto-fix enabled)

```markdown
## This looks like a heading

## Another section title

## Configuration
```

<!-- rumdl-enable MD036 -->

## Configuration

```toml
# .rumdl.toml
[MD036]
punctuation = ".,;:!?"  # Characters that prevent flagging when at end (default)
fix = false             # Enable auto-fix (opt-in, default: false)
heading-style = "atx"   # Heading style for auto-fix (default: "atx")
heading-level = 2       # Heading level to use for auto-fix (1-6, default: 2)
```

### Options

- `punctuation`: String of punctuation marks that, when found at the end of emphasized text, prevent it from being flagged (default: `".,;:!?"`)
  - Set to `""` to flag all emphasized lines regardless of punctuation
  - Customize to remove only specific marks

- `fix`: Enable automatic conversion of emphasis-as-heading to real headings (default: `false`)
  - When `true`, `rumdl check --fix` converts detected emphasis-only lines to ATX headings
  - Opt-in to avoid unexpected document changes

- `heading-style`: The heading style to use when auto-fixing (default: `"atx"`)
  - Currently only `"atx"` (## Heading) is supported

- `heading-level`: The heading level (1-6) to use when auto-fixing (default: `2`)
  - `1` produces `# Heading`
  - `2` produces `## Heading`
  - `6` produces `###### Heading`
  - Invalid values (0 or >6) produce a config validation error

## Automatic fixes

Auto-fix is **opt-in** via the `fix = true` configuration option.

**When `fix = false` (default):**
- Warnings are reported but content is unchanged
- Users should manually review each case

**When `fix = true`:**
- Single-line paragraphs with only emphasis are converted to ATX headings
- The same detection logic is used as for warnings (punctuation, skip contexts, etc.)
- Fixes are idempotent (running twice produces the same result)

**What gets skipped (not converted):**
- Emphasis in lists, blockquotes, or code blocks
- Lines ending with punctuation (based on `punctuation` setting)
- Emphasis that contains links or inline code
- Table of Contents labels ("**Table of Contents**", etc.)
- Nested or complex emphasis patterns

## Example usage

```bash
# Check only (reports warnings)
rumdl check file.md

# Check and fix with default settings (fix disabled)
rumdl check --fix file.md  # No changes

# Enable fix in config
echo '[MD036]
fix = true
heading-level = 2' > .rumdl.toml

# Now fix will convert emphasis-as-heading
rumdl check --fix file.md
```

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Web Content Accessibility Guidelines (WCAG) on headings](https://www.w3.org/WAI/WCAG21/Understanding/info-and-relationships.html)

## Related rules

- [MD001 - Heading increment](md001.md) - Ensure heading levels increase properly
- [MD003 - Heading style](md003.md) - Keep heading formats consistent
- [MD018 - No missing space in ATX heading](md018.md) - Ensure proper heading spacing
