# MD071 - Blank line after frontmatter

Aliases: `blank-line-after-frontmatter`

## Rule Details

This rule ensures there is a blank line after YAML, TOML, or JSON frontmatter.

A blank line after frontmatter improves readability and prevents issues with some markdown parsers that may incorrectly interpret the first content line as part of the frontmatter.

## Examples

### Incorrect

```markdown
---
title: My Document
author: John Doe
---
# Heading

Content here.
```

### Correct

```markdown
---
title: My Document
author: John Doe
---

# Heading

Content here.
```

## Rationale

- Improves visual separation between metadata and content
- Prevents potential parsing issues with some markdown processors
- Consistent with MD022 (blanks around headings) when a heading follows frontmatter
- Aligns with common style guides and documentation best practices

## Auto-fix

This rule supports automatic fixing. Running `rumdl fmt` will insert a blank line after the frontmatter closing delimiter when missing.

## Supported Frontmatter Types

- YAML (`---` delimiters)
- TOML (`+++` delimiters)
- JSON (`{` and `}` delimiters)

## Configuration

This rule has no configuration options.

## Related Rules

- [MD022](md022.md) - Blanks around headings
- [MD072](md072.md) - YAML key sort

## Version

Added in rumdl 0.0.210.
