/*
 * constants for pcie configurations space from pci express spec.
 *
 * TODO:
 * Those constants and macros should go to Linux pci_regs.h
 * Once they're merged, they will go away.
 */
#ifndef QEMU_PCIE_REGS_H
#define QEMU_PCIE_REGS_H


/* express capability */

#define PCI_EXP_VER1_SIZEOF             0x14 /* express capability of ver. 1 */
#define PCI_EXP_VER2_SIZEOF             0x3c /* express capability of ver. 2 */
#define PCI_EXT_CAP_VER_SHIFT           16
#define PCI_EXT_CAP_NEXT_SHIFT          20
#define PCI_EXT_CAP_NEXT_MASK           (0xffc << PCI_EXT_CAP_NEXT_SHIFT)

#define PCI_EXT_CAP(id, ver, next)                                      \
    ((id) |                                                             \
     ((ver) << PCI_EXT_CAP_VER_SHIFT) |                                 \
     ((next) << PCI_EXT_CAP_NEXT_SHIFT))

#define PCI_EXT_CAP_ALIGN               4
#define PCI_EXT_CAP_ALIGNUP(x)                                  \
    (((x) + PCI_EXT_CAP_ALIGN - 1) & ~(PCI_EXT_CAP_ALIGN - 1))

/* PCI_EXP_FLAGS */
#define PCI_EXP_FLAGS_VER1              1
#define PCI_EXP_FLAGS_VER2              2
#define PCI_EXP_FLAGS_IRQ_SHIFT         ctz32(PCI_EXP_FLAGS_IRQ)
#define PCI_EXP_FLAGS_TYPE_SHIFT        ctz32(PCI_EXP_FLAGS_TYPE)

/* PCI_EXP_LINK{CAP, STA} */
/* link speed */
typedef enum PCIExpLinkSpeed {
    QEMU_PCI_EXP_LNK_2_5GT = 1,
    QEMU_PCI_EXP_LNK_5GT,
    QEMU_PCI_EXP_LNK_8GT,
    QEMU_PCI_EXP_LNK_16GT,
} PCIExpLinkSpeed;

#define QEMU_PCI_EXP_LNKCAP_MLS(speed)  (speed)
#define QEMU_PCI_EXP_LNKSTA_CLS         QEMU_PCI_EXP_LNKCAP_MLS

typedef enum PCIExpLinkWidth {
    QEMU_PCI_EXP_LNK_X1 = 1,
    QEMU_PCI_EXP_LNK_X2 = 2,
    QEMU_PCI_EXP_LNK_X4 = 4,
    QEMU_PCI_EXP_LNK_X8 = 8,
    QEMU_PCI_EXP_LNK_X12 = 12,
    QEMU_PCI_EXP_LNK_X16 = 16,
    QEMU_PCI_EXP_LNK_X32 = 32,
} PCIExpLinkWidth;

#define PCI_EXP_LNK_MLW_SHIFT           ctz32(PCI_EXP_LNKCAP_MLW)
#define QEMU_PCI_EXP_LNKCAP_MLW(width)  (width << PCI_EXP_LNK_MLW_SHIFT)
#define QEMU_PCI_EXP_LNKSTA_NLW         QEMU_PCI_EXP_LNKCAP_MLW

/* PCI_EXP_LINKCAP */
#define PCI_EXP_LNKCAP_ASPMS_SHIFT      ctz32(PCI_EXP_LNKCAP_ASPMS)
#define PCI_EXP_LNKCAP_ASPMS_0S         (1 << PCI_EXP_LNKCAP_ASPMS_SHIFT)

#define PCI_EXP_LNKCAP_PN_SHIFT         ctz32(PCI_EXP_LNKCAP_PN)

#define PCI_EXP_SLTCAP_PSN_SHIFT        ctz32(PCI_EXP_SLTCAP_PSN)

#define PCI_EXP_SLTCTL_IND_RESERVED     0x0
#define PCI_EXP_SLTCTL_IND_ON           0x1
#define PCI_EXP_SLTCTL_IND_BLINK        0x2
#define PCI_EXP_SLTCTL_IND_OFF          0x3
#define PCI_EXP_SLTCTL_AIC_SHIFT        ctz32(PCI_EXP_SLTCTL_AIC)
#define PCI_EXP_SLTCTL_AIC_OFF                          \
    (PCI_EXP_SLTCTL_IND_OFF << PCI_EXP_SLTCTL_AIC_SHIFT)

#define PCI_EXP_SLTCTL_PIC_SHIFT        ctz32(PCI_EXP_SLTCTL_PIC)
#define PCI_EXP_SLTCTL_PIC_OFF                          \
    (PCI_EXP_SLTCTL_IND_OFF << PCI_EXP_SLTCTL_PIC_SHIFT)
#define PCI_EXP_SLTCTL_PIC_ON                          \
    (PCI_EXP_SLTCTL_IND_ON << PCI_EXP_SLTCTL_PIC_SHIFT)

#define PCI_EXP_SLTCTL_SUPPORTED        \
            (PCI_EXP_SLTCTL_ABPE |      \
             PCI_EXP_SLTCTL_PDCE |      \
             PCI_EXP_SLTCTL_CCIE |      \
             PCI_EXP_SLTCTL_HPIE |      \
             PCI_EXP_SLTCTL_AIC |       \
             PCI_EXP_SLTCTL_PCC |       \
             PCI_EXP_SLTCTL_EIC)

#define PCI_EXP_DEVCAP2_EFF             0x100000
#define PCI_EXP_DEVCAP2_EETLPP          0x200000

#define PCI_EXP_DEVCTL2_EETLPPB         0x8000

/* ARI */
#define PCI_ARI_VER                     1
#define PCI_ARI_SIZEOF                  8

/* AER */
#define PCI_ERR_VER                     2
#define PCI_ERR_SIZEOF                  0x48

#define PCI_ERR_UNC_SDN                 0x00000020      /* surprise down */
#define PCI_ERR_UNC_ACSV                0x00200000      /* ACS Violation */
#define PCI_ERR_UNC_INTN                0x00400000      /* Internal Error */
#define PCI_ERR_UNC_MCBTLP              0x00800000      /* MC Blcoked TLP */
#define PCI_ERR_UNC_ATOP_EBLOCKED       0x01000000      /* atomic op egress blocked */
#define PCI_ERR_UNC_TLP_PRF_BLOCKED     0x02000000      /* TLP Prefix Blocked */
#define PCI_ERR_COR_ADV_NONFATAL        0x00002000      /* Advisory Non-Fatal */
#define PCI_ERR_COR_INTERNAL            0x00004000      /* Corrected Internal */
#define PCI_ERR_COR_HL_OVERFLOW         0x00008000      /* Header Long Overflow */
#define PCI_ERR_CAP_FEP_MASK            0x0000001f
#define PCI_ERR_CAP_MHRC                0x00000200
#define PCI_ERR_CAP_MHRE                0x00000400
#define PCI_ERR_CAP_TLP                 0x00000800

#define PCI_ERR_HEADER_LOG_SIZE         16
#define PCI_ERR_TLP_PREFIX_LOG          0x38
#define PCI_ERR_TLP_PREFIX_LOG_SIZE     16

#define PCI_SEC_STATUS_RCV_SYSTEM_ERROR         0x4000

/* aer root error command/status */
#define PCI_ERR_ROOT_CMD_EN_MASK        (PCI_ERR_ROOT_CMD_COR_EN |      \
                                         PCI_ERR_ROOT_CMD_NONFATAL_EN | \
                                         PCI_ERR_ROOT_CMD_FATAL_EN)

#define PCI_ERR_ROOT_IRQ_MAX            32
#define PCI_ERR_ROOT_IRQ                0xf8000000
#define PCI_ERR_ROOT_IRQ_SHIFT          ctz32(PCI_ERR_ROOT_IRQ)
#define PCI_ERR_ROOT_STATUS_REPORT_MASK (PCI_ERR_ROOT_COR_RCV |         \
                                         PCI_ERR_ROOT_MULTI_COR_RCV |   \
                                         PCI_ERR_ROOT_UNCOR_RCV |       \
                                         PCI_ERR_ROOT_MULTI_UNCOR_RCV | \
                                         PCI_ERR_ROOT_FIRST_FATAL |     \
                                         PCI_ERR_ROOT_NONFATAL_RCV |    \
                                         PCI_ERR_ROOT_FATAL_RCV)

#define PCI_ERR_UNC_SUPPORTED           (PCI_ERR_UNC_DLP |              \
                                         PCI_ERR_UNC_SDN |              \
                                         PCI_ERR_UNC_POISON_TLP |       \
                                         PCI_ERR_UNC_FCP |              \
                                         PCI_ERR_UNC_COMP_TIME |        \
                                         PCI_ERR_UNC_COMP_ABORT |       \
                                         PCI_ERR_UNC_UNX_COMP |         \
                                         PCI_ERR_UNC_RX_OVER |          \
                                         PCI_ERR_UNC_MALF_TLP |         \
                                         PCI_ERR_UNC_ECRC |             \
                                         PCI_ERR_UNC_UNSUP |            \
                                         PCI_ERR_UNC_ACSV |             \
                                         PCI_ERR_UNC_INTN |             \
                                         PCI_ERR_UNC_MCBTLP |           \
                                         PCI_ERR_UNC_ATOP_EBLOCKED |    \
                                         PCI_ERR_UNC_TLP_PRF_BLOCKED)

#define PCI_ERR_UNC_SEVERITY_DEFAULT    (PCI_ERR_UNC_DLP |              \
                                         PCI_ERR_UNC_SDN |              \
                                         PCI_ERR_UNC_FCP |              \
                                         PCI_ERR_UNC_RX_OVER |          \
                                         PCI_ERR_UNC_MALF_TLP |         \
                                         PCI_ERR_UNC_INTN)

#define PCI_ERR_COR_SUPPORTED           (PCI_ERR_COR_RCVR |             \
                                         PCI_ERR_COR_BAD_TLP |          \
                                         PCI_ERR_COR_BAD_DLLP |         \
                                         PCI_ERR_COR_REP_ROLL |         \
                                         PCI_ERR_COR_REP_TIMER |        \
                                         PCI_ERR_COR_ADV_NONFATAL |     \
                                         PCI_ERR_COR_INTERNAL |         \
                                         PCI_ERR_COR_HL_OVERFLOW)

#define PCI_ERR_COR_MASK_DEFAULT        (PCI_ERR_COR_ADV_NONFATAL |     \
                                         PCI_ERR_COR_INTERNAL |         \
                                         PCI_ERR_COR_HL_OVERFLOW)

/* ACS */
#define PCI_ACS_VER                     0x1
#define PCI_ACS_SIZEOF                  8

/* DOE Capability Register Fields */
#define PCI_DOE_VER                     0x1
#define PCI_DOE_SIZEOF                  24

#endif /* QEMU_PCIE_REGS_H */
