---
authors: "czosel"
title: "Prettier for PHP 0.1: First alpha release 🎉"
---

After more than 200 merged pull requests since mid December 2017, we're happy to announce the first alpha release of [Prettier for PHP](https://github.com/prettier/plugin-php). In this blog post, we'd like to give a short overview of how the plugin works, its philosophy, and what to expect in the future.

<!-- truncate -->

## How does it work?

Adding support for a new language to Prettier requires two things:

- A parser, which turns your source code into an abstract syntax tree (AST). Since Prettier is written in JavaScript, we're using [php-parser](https://github.com/glayzzle/php-parser), which is a PHP parser written in JS.

- A printer, that turns the AST into a special format called `doc` that Prettier requires to do its magic. It is basically your source code plus some information about where linebreaks can be added, how it should be indented, and so on.

While we could benefit from existing work on the parsing side, the printer had to be developed from scratch to support all of PHP's various AST node types. Our first alpha release today means that we are confident that the printer can re-print your code without breaking it.

If you'd like to read more about the plugin API, see [the docs](https://prettier.io/docs/plugins).

## Philosophy

When building a code formatter, it can be tempting to add many options to account for all the different code styles there are. The PHP plugin sticks to Prettier's opinionated philosophy and doesn't add any new options. Instead, we identified [PSR-1, PSR-2 and PSR-12](https://www.php-fig.org/psr/) as one of the most popular coding styles in the PHP community, and decided to use this as our guide when it came to formatting our re-printed PHP code.

From the experience gained with Prettier for JavaScript, we believe that offering as few configuration options as possible is one of Prettier's biggest strengths. After our first stable release, we will consider adding a very limited set of options for the most controversial styling decisions (e.g. [brace style](https://github.com/prettier/plugin-php/issues/107)), but remain conservative about it.

## What's next

For our first stable release, the following milestones still have to be reached:

1.  100% safety that we're not breaking code during formatting.

    We're quite close to this goal already today.

2.  Pretty output

    The plugin doesn't deserve its name if the output isn't pretty. While it is already quite good today, handling all the edge cases will require some more work.

3.  Integrations

    Today, you can try the plugin from the command line by following the [instructions in the README](https://github.com/prettier/plugin-php#install). Plugin support in your favorite editor might not work yet, though (see the related issues for [VS Code](https://github.com/prettier/prettier-vscode/issues/395), [Atom](https://github.com/prettier/prettier-atom/issues/395) and [Vim](https://github.com/prettier/vim-prettier/issues/119)). Also, the PHP plugin is not integrated in Prettier's [playground](https://prettier.io/playground/) yet.

Are you excited about Prettier for PHP? Then we'd love you to help us reach our first stable release by

- Trying it on your code base
- [Reporting any issues](https://github.com/prettier/plugin-php/issues) you find with it
- Contributing ([how to get started](https://github.com/prettier/plugin-php/blob/master/CONTRIBUTING.md))
- Spreading the word 😉
