---
id: related-projects
title: Related Projects
---

## ESLint Integrations

- [eslint-config-prettier](https://github.com/prettier/eslint-config-prettier) turns off all ESLint rules that are unnecessary or might conflict with Prettier
- [eslint-plugin-prettier](https://github.com/prettier/eslint-plugin-prettier) runs Prettier as an ESLint rule and reports differences as individual ESLint issues
- [prettier-eslint](https://github.com/prettier/prettier-eslint) passes `prettier` output to `eslint --fix`
- [prettier-standard](https://github.com/sheerun/prettier-standard) uses `prettierx` and `prettier-eslint` to format code with `standard` rules

## stylelint Integrations

- [stylelint-config-prettier](https://github.com/prettier/stylelint-config-prettier) turns off all rules that are unnecessary or might conflict with Prettier.
- [stylelint-prettier](https://github.com/prettier/stylelint-prettier) runs Prettier as a stylelint rule and reports differences as individual stylelint issues
- [prettier-stylelint](https://github.com/hugomrdias/prettier-stylelint) passes `prettier` output to `stylelint --fix`

## Forks

- [prettierx](https://github.com/brodybits/prettierx) less opinionated fork of Prettier

## Misc

- [parallel-prettier](https://github.com/microsoft/parallel-prettier) is an alternative CLI that formats files in parallel to speed up large projects
- [prettier_d](https://github.com/josephfrazier/prettier_d.js) runs Prettier as a server to avoid Node.js startup delay
- [pretty-quick](https://github.com/azz/pretty-quick) formats changed files with Prettier
- [rollup-plugin-prettier](https://github.com/mjeanroy/rollup-plugin-prettier) allows you to use Prettier with Rollup
- [jest-runner-prettier](https://github.com/keplersj/jest-runner-prettier) is Prettier as a Jest runner
- [prettier-chrome](https://github.com/u3u/prettier-chrome) is an extension that runs Prettier in the browser
- [spotless](https://github.com/diffplug/spotless) lets you run prettier from [gradle](https://github.com/diffplug/spotless/tree/main/plugin-gradle#prettier) or [maven](https://github.com/diffplug/spotless/tree/main/plugin-maven#prettier).
- [csharpier](https://github.com/belav/csharpier) is a port of Prettier for C#
- [Prettier](https://github.com/jaywcjlove/Prettier) is a Swift version based on Prettier
- [reviewdog-action-prettier](https://github.com/EPMatt/reviewdog-action-prettier) runs Prettier in GitHub Actions CI/CD workflows
- [monaco-prettier](https://github.com/remcohaszing/monaco-prettier) integrates Prettier into [Monaco editor](https://microsoft.github.io/monaco-editor/)
