/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.text.ParseException;

public final class Version
implements Comparable {
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    public Version(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray == null || stringArray.length == 0 || stringArray.length > 4) {
            throw new ParseException("Ill formed OSGi version", 0);
        }
        try {
            this.major = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Major part of an OSGi version should be an integer", 0);
        }
        try {
            this.minor = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Minor part of an OSGi version should be an integer", 0);
        }
        try {
            this.patch = stringArray.length >= 3 ? Integer.parseInt(stringArray[2]) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Patch part of an OSGi version should be an integer", 0);
        }
        this.qualifier = stringArray.length == 4 ? stringArray[3] : null;
    }

    public Version(int n, int n2, int n3, String string) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.qualifier = string;
    }

    public final String toString() {
        Version version = this;
        return version.major + "." + version.minor + "." + version.patch + (this.qualifier == null ? "" : "." + this.qualifier);
    }

    public final int hashCode() {
        int n = 31 + this.major;
        n = n * 31 + this.minor;
        n = n * 31 + this.patch;
        return n * 31 + (this.qualifier == null ? 0 : this.qualifier.hashCode());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.patch != version.patch) {
            return false;
        }
        return !(this.qualifier == null ? version.qualifier != null : !this.qualifier.equals(version.qualifier));
    }

    public final Version withNudgedPatch() {
        return new Version(this.major, this.minor, this.patch + 1, null);
    }

    public final int compareTo(Object object) {
        return this.compareTo((Version)object);
    }

    public final int compareTo(Version version) {
        int n;
        Version version2 = version;
        Version version3 = this;
        int n2 = version3.major - version2.major;
        if ((n2 != 0 ? n2 : ((n2 = version3.minor - version2.minor) != 0 ? n2 : (n = (n2 = version3.patch - version2.patch) != 0 ? n2 : 0))) != 0) {
            return n;
        }
        if (this.qualifier == null) {
            if (version.qualifier != null) {
                return -1;
            }
            return 0;
        }
        if (version.qualifier == null) {
            return 1;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

