//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ホストネットワークの tap ドライバ
//

#pragma once

#include "netdriver.h"

class NetDriverTap : public NetDriver
{
	using inherited = NetDriver;
 public:
	NetDriverTap(HostDevice *hostdev_, const std::string& devpath_);
	~NetDriverTap() override;

	bool InitDriver(bool startup) override;
	int Read(NetPacket *p) override;
	void Write(const void *buf, int buflen) override;

	void MonitorScreenMD(TextScreen&, int y) override;

 private:
#if defined(__linux__)
	bool OpenLinux();
#endif
	bool OpenDirect();
	bool OpenNumbered();
	bool OpenCloning();

	void Close();

	// デバイスファイルパス
	std::string devpath {};
};
