// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

use crate::provider::hijri::PackedHijriYearInfo;

pub const UMMALQURA_DATA_STARTING_YEAR: i32 = 1300;

#[rustfmt::skip]
pub const UMMALQURA_DATA: [PackedHijriYearInfo; 1601 - UMMALQURA_DATA_STARTING_YEAR as usize] = {
    use calendrical_calculations::iso::const_fixed_from_iso as iso;
    let l = true; // long
    let s = false; // short
    [
        PackedHijriYearInfo::new(UMMALQURA_DATA_STARTING_YEAR, [l, s, l, s, l, s, l, s, l, s, l, s], iso(1882, 11, 12)),
        PackedHijriYearInfo::new(1301, [l, l, s, l, s, l, s, l, s, l, s, s], iso(1883, 11, 1)),
        PackedHijriYearInfo::new(1302, [l, l, l, s, l, l, s, s, l, s, s, l], iso(1884, 10, 20)),
        PackedHijriYearInfo::new(1303, [s, l, l, s, l, l, s, l, s, l, s, s], iso(1885, 10, 10)),
        PackedHijriYearInfo::new(1304, [s, l, l, s, l, l, l, s, l, s, l, s], iso(1886, 9, 29)),
        PackedHijriYearInfo::new(1305, [s, s, l, l, s, l, l, s, l, l, s, s], iso(1887, 9, 19)),
        PackedHijriYearInfo::new(1306, [l, s, l, s, l, s, l, s, l, l, s, l], iso(1888, 9, 7)),
        PackedHijriYearInfo::new(1307, [s, l, s, l, s, l, s, l, s, l, s, l], iso(1889, 8, 28)),
        PackedHijriYearInfo::new(1308, [s, l, l, s, l, s, l, s, l, s, s, l], iso(1890, 8, 17)),
        PackedHijriYearInfo::new(1309, [s, l, l, l, l, s, s, l, s, s, l, s], iso(1891, 8, 6)),
        PackedHijriYearInfo::new(1310, [l, s, l, l, l, s, l, s, l, s, s, l], iso(1892, 7, 25)),
        PackedHijriYearInfo::new(1311, [s, l, s, l, l, l, s, l, s, l, s, s], iso(1893, 7, 15)),
        PackedHijriYearInfo::new(1312, [l, s, l, s, l, l, s, l, l, s, l, s], iso(1894, 7, 4)),
        PackedHijriYearInfo::new(1313, [s, l, s, l, s, l, s, l, l, l, s, s], iso(1895, 6, 24)),
        PackedHijriYearInfo::new(1314, [l, l, s, l, s, s, l, s, l, l, s, l], iso(1896, 6, 12)),
        PackedHijriYearInfo::new(1315, [s, l, l, s, l, s, s, l, s, l, s, l], iso(1897, 6, 2)),
        PackedHijriYearInfo::new(1316, [s, l, l, l, s, l, s, s, l, s, l, s], iso(1898, 5, 22)),
        PackedHijriYearInfo::new(1317, [l, s, l, l, s, l, s, l, s, l, s, s], iso(1899, 5, 11)),
        PackedHijriYearInfo::new(1318, [l, s, l, l, s, l, l, s, l, s, l, s], iso(1900, 4, 30)),
        PackedHijriYearInfo::new(1319, [s, l, s, l, l, s, l, s, l, l, s, l], iso(1901, 4, 20)),
        PackedHijriYearInfo::new(1320, [s, l, s, s, l, s, l, s, l, l, l, s], iso(1902, 4, 10)),
        PackedHijriYearInfo::new(1321, [l, s, l, s, s, l, s, s, l, l, l, l], iso(1903, 3, 30)),
        PackedHijriYearInfo::new(1322, [s, l, s, l, s, s, s, l, s, l, l, l], iso(1904, 3, 19)),
        PackedHijriYearInfo::new(1323, [s, l, l, s, l, s, s, s, l, s, l, l], iso(1905, 3, 8)),
        PackedHijriYearInfo::new(1324, [s, l, l, s, l, s, l, s, s, l, s, l], iso(1906, 2, 25)),
        PackedHijriYearInfo::new(1325, [l, s, l, s, l, l, s, l, s, l, s, l], iso(1907, 2, 14)),
        PackedHijriYearInfo::new(1326, [s, s, l, s, l, l, s, l, s, l, l, s], iso(1908, 2, 4)),
        PackedHijriYearInfo::new(1327, [l, s, s, l, s, l, s, l, l, s, l, l], iso(1909, 1, 23)),
        PackedHijriYearInfo::new(1328, [s, l, s, s, l, s, s, l, l, l, s, l], iso(1910, 1, 13)),
        PackedHijriYearInfo::new(1329, [l, s, l, s, s, l, s, s, l, l, s, l], iso(1911, 1, 2)),
        PackedHijriYearInfo::new(1330, [l, l, s, l, s, s, l, s, s, l, l, s], iso(1911, 12, 22)),
        PackedHijriYearInfo::new(1331, [l, l, s, l, l, s, s, l, s, l, s, l], iso(1912, 12, 10)),
        PackedHijriYearInfo::new(1332, [s, l, s, l, l, s, l, s, l, l, s, s], iso(1913, 11, 30)),
        PackedHijriYearInfo::new(1333, [l, s, s, l, l, s, l, l, s, l, l, s], iso(1914, 11, 19)),
        PackedHijriYearInfo::new(1334, [s, s, l, s, l, s, l, l, l, s, l, s], iso(1915, 11, 9)),
        PackedHijriYearInfo::new(1335, [l, s, l, s, s, l, s, l, l, s, l, l], iso(1916, 10, 28)),
        PackedHijriYearInfo::new(1336, [s, l, s, l, s, s, l, s, l, s, l, l], iso(1917, 10, 18)),
        PackedHijriYearInfo::new(1337, [l, s, l, s, l, s, s, l, s, l, s, l], iso(1918, 10, 7)),
        PackedHijriYearInfo::new(1338, [s, l, l, s, l, l, s, s, l, s, l, s], iso(1919, 9, 26)),
        PackedHijriYearInfo::new(1339, [l, s, l, s, l, l, l, s, l, s, s, l], iso(1920, 9, 14)),
        PackedHijriYearInfo::new(1340, [s, s, l, s, l, l, l, l, s, l, s, s], iso(1921, 9, 4)),
        PackedHijriYearInfo::new(1341, [l, s, s, l, s, l, l, l, s, l, l, s], iso(1922, 8, 24)),
        PackedHijriYearInfo::new(1342, [s, s, l, s, l, s, l, l, s, l, l, s], iso(1923, 8, 14)),
        PackedHijriYearInfo::new(1343, [l, s, s, l, s, l, s, l, s, l, l, s], iso(1924, 8, 2)),
        PackedHijriYearInfo::new(1344, [l, s, l, s, l, l, s, s, l, s, l, s], iso(1925, 7, 22)),
        PackedHijriYearInfo::new(1345, [l, s, l, l, l, s, l, s, s, l, s, s], iso(1926, 7, 11)),
        PackedHijriYearInfo::new(1346, [l, s, l, l, l, l, s, l, s, s, l, s], iso(1927, 6, 30)),
        PackedHijriYearInfo::new(1347, [s, l, s, l, l, l, s, l, l, s, s, l], iso(1928, 6, 19)),
        PackedHijriYearInfo::new(1348, [s, s, l, s, l, l, s, l, l, l, s, s], iso(1929, 6, 9)),
        PackedHijriYearInfo::new(1349, [l, s, s, l, s, l, l, s, l, l, s, l], iso(1930, 5, 29)),
        PackedHijriYearInfo::new(1350, [s, l, s, l, s, l, s, s, l, l, s, l], iso(1931, 5, 19)),
        PackedHijriYearInfo::new(1351, [l, s, l, s, l, s, l, s, s, l, s, l], iso(1932, 5, 7)),
        PackedHijriYearInfo::new(1352, [l, s, l, l, s, l, s, l, s, s, l, s], iso(1933, 4, 26)),
        PackedHijriYearInfo::new(1353, [l, s, l, l, l, s, l, s, s, l, s, l], iso(1934, 4, 15)),
        PackedHijriYearInfo::new(1354, [s, l, s, l, l, s, l, l, s, l, s, s], iso(1935, 4, 5)),
        PackedHijriYearInfo::new(1355, [l, s, s, l, l, s, l, l, s, l, l, s], iso(1936, 3, 24)),
        PackedHijriYearInfo::new(1356, [s, l, s, l, s, l, s, l, s, l, l, l], iso(1937, 3, 14)),
        PackedHijriYearInfo::new(1357, [s, s, l, s, l, s, s, l, s, l, l, l], iso(1938, 3, 4)),
        PackedHijriYearInfo::new(1358, [s, l, s, l, s, l, s, s, l, s, l, l], iso(1939, 2, 21)),
        PackedHijriYearInfo::new(1359, [s, l, l, s, l, s, l, s, s, s, l, l], iso(1940, 2, 10)),
        PackedHijriYearInfo::new(1360, [s, l, l, l, s, l, s, l, s, s, l, s], iso(1941, 1, 29)),
        PackedHijriYearInfo::new(1361, [l, s, l, l, s, l, l, s, s, l, s, l], iso(1942, 1, 18)),
        PackedHijriYearInfo::new(1362, [s, l, s, l, s, l, l, s, l, s, l, s], iso(1943, 1, 8)),
        PackedHijriYearInfo::new(1363, [l, s, l, s, l, s, l, s, l, s, l, l], iso(1943, 12, 28)),
        PackedHijriYearInfo::new(1364, [s, l, s, l, s, s, l, s, l, s, l, l], iso(1944, 12, 17)),
        PackedHijriYearInfo::new(1365, [l, l, s, s, l, s, s, l, s, l, s, l], iso(1945, 12, 6)),
        PackedHijriYearInfo::new(1366, [l, l, s, l, s, l, s, s, l, s, l, s], iso(1946, 11, 25)),
        PackedHijriYearInfo::new(1367, [l, l, s, l, l, s, l, s, s, l, s, l], iso(1947, 11, 14)),
        PackedHijriYearInfo::new(1368, [s, l, s, l, l, l, s, s, l, s, l, s], iso(1948, 11, 3)),
        PackedHijriYearInfo::new(1369, [l, s, l, s, l, l, s, l, s, l, l, s], iso(1949, 10, 23)),
        PackedHijriYearInfo::new(1370, [l, s, s, l, s, l, s, l, s, l, l, l], iso(1950, 10, 13)),
        PackedHijriYearInfo::new(1371, [s, l, s, s, l, s, l, s, l, s, l, l], iso(1951, 10, 3)),
        PackedHijriYearInfo::new(1372, [l, s, s, l, s, l, s, s, l, s, l, l], iso(1952, 9, 21)),
        PackedHijriYearInfo::new(1373, [l, s, l, s, l, s, l, s, s, l, s, l], iso(1953, 9, 10)),
        PackedHijriYearInfo::new(1374, [l, s, l, l, s, l, s, l, s, s, l, s], iso(1954, 8, 30)),
        PackedHijriYearInfo::new(1375, [l, s, l, l, s, l, l, s, l, s, l, s], iso(1955, 8, 19)),
        PackedHijriYearInfo::new(1376, [s, l, s, l, s, l, l, l, s, l, s, l], iso(1956, 8, 8)),
        PackedHijriYearInfo::new(1377, [s, s, l, s, s, l, l, l, s, l, l, s], iso(1957, 7, 29)),
        PackedHijriYearInfo::new(1378, [l, s, s, s, l, s, l, l, s, l, l, l], iso(1958, 7, 18)),
        PackedHijriYearInfo::new(1379, [s, l, s, s, s, l, s, l, l, s, l, l], iso(1959, 7, 8)),
        PackedHijriYearInfo::new(1380, [s, l, s, l, s, l, s, l, s, l, s, l], iso(1960, 6, 26)),
        PackedHijriYearInfo::new(1381, [s, l, s, l, l, s, l, s, l, s, s, l], iso(1961, 6, 15)),
        PackedHijriYearInfo::new(1382, [s, l, s, l, l, s, l, l, s, l, s, s], iso(1962, 6, 4)),
        PackedHijriYearInfo::new(1383, [l, s, s, l, l, l, s, l, l, s, l, s], iso(1963, 5, 24)),
        PackedHijriYearInfo::new(1384, [s, l, s, s, l, l, s, l, l, l, s, l], iso(1964, 5, 13)),
        PackedHijriYearInfo::new(1385, [s, s, l, s, s, l, l, s, l, l, l, s], iso(1965, 5, 3)),
        PackedHijriYearInfo::new(1386, [l, s, s, l, s, s, l, l, s, l, l, s], iso(1966, 4, 22)),
        PackedHijriYearInfo::new(1387, [l, s, l, s, l, s, l, s, l, s, l, s], iso(1967, 4, 11)),
        PackedHijriYearInfo::new(1388, [l, l, s, l, s, l, s, l, s, l, s, s], iso(1968, 3, 30)),
        PackedHijriYearInfo::new(1389, [l, l, s, l, l, s, l, l, s, s, l, s], iso(1969, 3, 19)),
        PackedHijriYearInfo::new(1390, [s, l, s, l, l, l, s, l, s, l, s, l], iso(1970, 3, 9)),
        PackedHijriYearInfo::new(1391, [s, s, l, s, l, l, s, l, l, s, l, s], iso(1971, 2, 27)),
        PackedHijriYearInfo::new(1392, [l, s, s, l, s, l, s, l, l, s, l, l], iso(1972, 2, 16)),
        PackedHijriYearInfo::new(1393, [s, l, s, s, l, s, l, s, l, s, l, l], iso(1973, 2, 5)),
        PackedHijriYearInfo::new(1394, [l, s, l, s, s, l, s, l, s, l, s, l], iso(1974, 1, 25)),
        PackedHijriYearInfo::new(1395, [l, s, l, l, s, l, s, s, l, s, s, l], iso(1975, 1, 14)),
        PackedHijriYearInfo::new(1396, [l, s, l, l, s, l, l, s, s, l, s, s], iso(1976, 1, 3)),
        PackedHijriYearInfo::new(1397, [l, s, l, l, s, l, l, l, s, s, s, l], iso(1976, 12, 22)),
        PackedHijriYearInfo::new(1398, [s, l, s, l, l, s, l, l, s, l, s, s], iso(1977, 12, 12)),
        PackedHijriYearInfo::new(1399, [l, s, l, s, l, s, l, l, s, l, s, l], iso(1978, 12, 1)),
        PackedHijriYearInfo::new(1400, [l, s, l, s, s, l, s, l, s, l, s, l], iso(1979, 11, 21)),
        PackedHijriYearInfo::new(1401, [l, l, s, l, s, s, l, s, s, l, s, l], iso(1980, 11, 9)),
        PackedHijriYearInfo::new(1402, [l, l, l, s, l, s, s, l, s, s, l, s], iso(1981, 10, 29)),
        PackedHijriYearInfo::new(1403, [l, l, l, s, l, l, s, s, l, s, s, l], iso(1982, 10, 18)),
        PackedHijriYearInfo::new(1404, [s, l, l, s, l, l, s, l, s, l, s, s], iso(1983, 10, 8)),
        PackedHijriYearInfo::new(1405, [l, s, l, s, l, l, l, s, l, s, s, l], iso(1984, 9, 26)),
        PackedHijriYearInfo::new(1406, [l, s, s, l, s, l, l, s, l, s, l, l], iso(1985, 9, 16)),
        PackedHijriYearInfo::new(1407, [s, l, s, s, l, s, l, s, l, s, l, l], iso(1986, 9, 6)),
        PackedHijriYearInfo::new(1408, [l, s, l, s, l, s, s, l, s, s, l, l], iso(1987, 8, 26)),
        PackedHijriYearInfo::new(1409, [l, l, s, l, s, l, s, s, l, s, s, l], iso(1988, 8, 14)),
        PackedHijriYearInfo::new(1410, [l, l, s, l, l, s, l, s, s, l, s, s], iso(1989, 8, 3)),
        PackedHijriYearInfo::new(1411, [l, l, s, l, l, s, l, l, s, s, l, s], iso(1990, 7, 23)),
        PackedHijriYearInfo::new(1412, [l, s, l, s, l, s, l, l, l, s, s, l], iso(1991, 7, 13)),
        PackedHijriYearInfo::new(1413, [s, l, s, s, l, s, l, l, l, s, l, s], iso(1992, 7, 2)),
        PackedHijriYearInfo::new(1414, [l, s, l, s, s, l, s, l, l, s, l, l], iso(1993, 6, 21)),
        PackedHijriYearInfo::new(1415, [s, l, s, l, s, s, l, s, l, s, l, l], iso(1994, 6, 11)),
        PackedHijriYearInfo::new(1416, [l, s, l, s, l, s, s, l, s, l, s, l], iso(1995, 5, 31)),
        PackedHijriYearInfo::new(1417, [l, s, l, l, s, s, l, s, l, s, l, s], iso(1996, 5, 19)),
        PackedHijriYearInfo::new(1418, [l, s, l, l, s, l, s, l, s, l, s, l], iso(1997, 5, 8)),
        PackedHijriYearInfo::new(1419, [s, l, s, l, s, l, s, l, l, l, s, s], iso(1998, 4, 28)),
        PackedHijriYearInfo::new(1420, [s, l, s, s, l, s, l, l, l, l, s, l], iso(1999, 4, 17)),
        PackedHijriYearInfo::new(1421, [s, s, l, s, s, s, l, l, l, l, s, l], iso(2000, 4, 6)),
        PackedHijriYearInfo::new(1422, [l, s, s, l, s, s, s, l, l, l, s, l], iso(2001, 3, 26)),
        PackedHijriYearInfo::new(1423, [l, s, l, s, l, s, s, l, s, l, s, l], iso(2002, 3, 15)),
        PackedHijriYearInfo::new(1424, [l, s, l, l, s, l, s, s, l, s, l, s], iso(2003, 3, 4)),
        PackedHijriYearInfo::new(1425, [l, s, l, l, s, l, s, l, l, s, l, s], iso(2004, 2, 21)),
        PackedHijriYearInfo::new(1426, [s, l, s, l, s, l, l, s, l, l, s, l], iso(2005, 2, 10)),
        PackedHijriYearInfo::new(1427, [s, s, l, s, l, s, l, l, s, l, l, s], iso(2006, 1, 31)),
        PackedHijriYearInfo::new(1428, [l, s, s, l, s, s, l, l, l, s, l, l], iso(2007, 1, 20)),
        PackedHijriYearInfo::new(1429, [s, l, s, s, l, s, s, l, l, s, l, l], iso(2008, 1, 10)),
        PackedHijriYearInfo::new(1430, [s, l, l, s, s, l, s, l, s, l, s, l], iso(2008, 12, 29)),
        PackedHijriYearInfo::new(1431, [s, l, l, s, l, s, l, s, l, s, s, l], iso(2009, 12, 18)),
        PackedHijriYearInfo::new(1432, [s, l, l, l, s, l, s, l, s, l, s, s], iso(2010, 12, 7)),
        PackedHijriYearInfo::new(1433, [l, s, l, l, s, l, l, s, l, s, l, s], iso(2011, 11, 26)),
        PackedHijriYearInfo::new(1434, [s, l, s, l, s, l, l, s, l, l, s, s], iso(2012, 11, 15)),
        PackedHijriYearInfo::new(1435, [l, s, l, s, l, s, l, s, l, l, s, l], iso(2013, 11, 4)),
        PackedHijriYearInfo::new(1436, [s, l, s, l, s, l, s, l, s, l, s, l], iso(2014, 10, 25)),
        PackedHijriYearInfo::new(1437, [l, s, l, l, s, s, l, s, l, s, s, l], iso(2015, 10, 14)),
        PackedHijriYearInfo::new(1438, [l, s, l, l, l, s, s, l, s, s, l, s], iso(2016, 10, 2)),
        PackedHijriYearInfo::new(1439, [l, s, l, l, l, s, l, s, l, s, s, l], iso(2017, 9, 21)),
        PackedHijriYearInfo::new(1440, [s, l, s, l, l, l, s, l, s, l, s, s], iso(2018, 9, 11)),
        PackedHijriYearInfo::new(1441, [l, s, l, s, l, l, s, l, l, s, l, s], iso(2019, 8, 31)),
        PackedHijriYearInfo::new(1442, [s, l, s, l, s, l, s, l, l, s, l, s], iso(2020, 8, 20)),
        PackedHijriYearInfo::new(1443, [l, s, l, s, l, s, l, s, l, s, l, l], iso(2021, 8, 9)),
        PackedHijriYearInfo::new(1444, [s, l, s, l, l, s, s, l, s, l, s, l], iso(2022, 7, 30)),
        PackedHijriYearInfo::new(1445, [s, l, l, l, s, l, s, s, l, s, s, l], iso(2023, 7, 19)),
        PackedHijriYearInfo::new(1446, [s, l, l, l, s, l, l, s, s, l, s, s], iso(2024, 7, 7)),
        PackedHijriYearInfo::new(1447, [l, s, l, l, l, s, l, s, l, s, l, s], iso(2025, 6, 26)),
        PackedHijriYearInfo::new(1448, [s, l, s, l, l, s, l, l, s, l, s, l], iso(2026, 6, 16)),
        PackedHijriYearInfo::new(1449, [s, s, l, s, l, s, l, l, s, l, l, s], iso(2027, 6, 6)),
        PackedHijriYearInfo::new(1450, [l, s, l, s, s, l, s, l, s, l, l, s], iso(2028, 5, 25)),
        PackedHijriYearInfo::new(1451, [l, l, l, s, s, l, s, s, l, l, s, l], iso(2029, 5, 14)),
        PackedHijriYearInfo::new(1452, [l, s, l, l, s, s, l, s, s, l, s, l], iso(2030, 5, 4)),
        PackedHijriYearInfo::new(1453, [l, s, l, l, s, l, s, l, s, s, l, s], iso(2031, 4, 23)),
        PackedHijriYearInfo::new(1454, [l, s, l, l, s, l, l, s, l, s, l, s], iso(2032, 4, 11)),
        PackedHijriYearInfo::new(1455, [s, l, s, l, l, s, l, s, l, l, s, l], iso(2033, 4, 1)),
        PackedHijriYearInfo::new(1456, [s, s, l, s, l, s, l, s, l, l, l, s], iso(2034, 3, 22)),
        PackedHijriYearInfo::new(1457, [l, s, s, l, s, s, l, s, l, l, l, l], iso(2035, 3, 11)),
        PackedHijriYearInfo::new(1458, [s, l, s, s, l, s, s, l, s, l, l, l], iso(2036, 2, 29)),
        PackedHijriYearInfo::new(1459, [s, l, l, s, s, l, s, s, l, s, l, l], iso(2037, 2, 17)),
        PackedHijriYearInfo::new(1460, [s, l, l, s, l, s, l, s, s, l, s, l], iso(2038, 2, 6)),
        PackedHijriYearInfo::new(1461, [s, l, l, s, l, s, l, s, l, l, s, s], iso(2039, 1, 26)),
        PackedHijriYearInfo::new(1462, [l, s, l, s, l, l, s, l, s, l, l, s], iso(2040, 1, 15)),
        PackedHijriYearInfo::new(1463, [s, l, s, l, s, l, s, l, l, l, s, l], iso(2041, 1, 4)),
        PackedHijriYearInfo::new(1464, [s, l, s, s, l, s, s, l, l, l, s, l], iso(2041, 12, 25)),
        PackedHijriYearInfo::new(1465, [l, s, l, s, s, l, s, s, l, l, s, l], iso(2042, 12, 14)),
        PackedHijriYearInfo::new(1466, [l, l, s, l, s, s, s, l, s, l, l, s], iso(2043, 12, 3)),
        PackedHijriYearInfo::new(1467, [l, l, s, l, l, s, s, l, s, l, s, l], iso(2044, 11, 21)),
        PackedHijriYearInfo::new(1468, [s, l, s, l, l, s, l, s, l, s, l, s], iso(2045, 11, 11)),
        PackedHijriYearInfo::new(1469, [s, l, s, l, l, s, l, l, s, l, s, l], iso(2046, 10, 31)),
        PackedHijriYearInfo::new(1470, [s, s, l, s, l, l, s, l, l, s, l, s], iso(2047, 10, 21)),
        PackedHijriYearInfo::new(1471, [l, s, s, l, s, l, s, l, l, s, l, l], iso(2048, 10, 9)),
        PackedHijriYearInfo::new(1472, [s, l, s, s, l, s, l, s, l, l, s, l], iso(2049, 9, 29)),
        PackedHijriYearInfo::new(1473, [s, l, s, l, l, s, s, l, s, l, s, l], iso(2050, 9, 18)),
        PackedHijriYearInfo::new(1474, [s, l, l, s, l, l, s, s, l, s, l, s], iso(2051, 9, 7)),
        PackedHijriYearInfo::new(1475, [s, l, l, s, l, l, l, s, s, l, s, s], iso(2052, 8, 26)),
        PackedHijriYearInfo::new(1476, [l, s, l, s, l, l, l, s, l, s, l, s], iso(2053, 8, 15)),
        PackedHijriYearInfo::new(1477, [s, l, s, s, l, l, l, l, s, l, s, l], iso(2054, 8, 5)),
        PackedHijriYearInfo::new(1478, [s, s, l, s, l, s, l, l, s, l, l, s], iso(2055, 7, 26)),
        PackedHijriYearInfo::new(1479, [l, s, s, l, s, l, s, l, s, l, l, s], iso(2056, 7, 14)),
        PackedHijriYearInfo::new(1480, [l, s, l, s, l, s, l, s, l, s, l, s], iso(2057, 7, 3)),
        PackedHijriYearInfo::new(1481, [l, s, l, l, s, l, s, l, s, l, s, s], iso(2058, 6, 22)),
        PackedHijriYearInfo::new(1482, [l, s, l, l, l, l, s, l, s, s, l, s], iso(2059, 6, 11)),
        PackedHijriYearInfo::new(1483, [s, l, s, l, l, l, s, l, l, s, s, l], iso(2060, 5, 31)),
        PackedHijriYearInfo::new(1484, [s, s, l, s, l, l, l, s, l, s, l, s], iso(2061, 5, 21)),
        PackedHijriYearInfo::new(1485, [l, s, s, l, s, l, l, s, l, l, s, l], iso(2062, 5, 10)),
        PackedHijriYearInfo::new(1486, [s, l, s, s, l, s, l, s, l, l, s, l], iso(2063, 4, 30)),
        PackedHijriYearInfo::new(1487, [l, s, l, s, l, s, s, l, s, l, s, l], iso(2064, 4, 18)),
        PackedHijriYearInfo::new(1488, [l, s, l, l, s, l, s, s, l, s, l, s], iso(2065, 4, 7)),
        PackedHijriYearInfo::new(1489, [l, s, l, l, l, s, l, s, s, l, s, l], iso(2066, 3, 27)),
        PackedHijriYearInfo::new(1490, [s, l, s, l, l, s, l, l, s, s, l, s], iso(2067, 3, 17)),
        PackedHijriYearInfo::new(1491, [l, s, s, l, l, s, l, l, s, l, s, l], iso(2068, 3, 5)),
        PackedHijriYearInfo::new(1492, [s, l, s, s, l, l, s, l, s, l, l, s], iso(2069, 2, 23)),
        PackedHijriYearInfo::new(1493, [l, s, l, s, l, s, s, l, s, l, l, l], iso(2070, 2, 12)),
        PackedHijriYearInfo::new(1494, [s, l, s, l, s, l, s, s, s, l, l, l], iso(2071, 2, 2)),
        PackedHijriYearInfo::new(1495, [s, l, l, s, l, s, s, l, s, s, l, l], iso(2072, 1, 22)),
        PackedHijriYearInfo::new(1496, [s, l, l, l, s, l, s, s, l, s, s, l], iso(2073, 1, 10)),
        PackedHijriYearInfo::new(1497, [l, s, l, l, s, l, s, l, s, l, s, l], iso(2073, 12, 30)),
        PackedHijriYearInfo::new(1498, [s, l, s, l, s, l, l, s, l, s, l, s], iso(2074, 12, 20)),
        PackedHijriYearInfo::new(1499, [l, s, l, s, s, l, l, s, l, s, l, l], iso(2075, 12, 9)),
        PackedHijriYearInfo::new(1500, [s, l, s, l, s, s, l, s, l, s, l, l], iso(2076, 11, 28)),
        PackedHijriYearInfo::new(1501, [l, s, l, s, l, s, s, s, l, s, l, l], iso(2077, 11, 17)),
        PackedHijriYearInfo::new(1502, [l, l, s, l, s, l, s, s, s, l, l, s], iso(2078, 11, 6)),
        PackedHijriYearInfo::new(1503, [l, l, s, l, l, s, l, s, s, s, l, l], iso(2079, 10, 26)),
        PackedHijriYearInfo::new(1504, [s, l, s, l, l, l, s, s, l, s, l, s], iso(2080, 10, 15)),
        PackedHijriYearInfo::new(1505, [l, s, l, s, l, l, s, l, s, l, l, s], iso(2081, 10, 4)),
        PackedHijriYearInfo::new(1506, [s, l, s, s, l, l, s, l, l, s, l, l], iso(2082, 9, 24)),
        PackedHijriYearInfo::new(1507, [s, s, l, s, s, l, l, s, l, s, l, l], iso(2083, 9, 14)),
        PackedHijriYearInfo::new(1508, [l, s, s, l, s, l, s, s, l, s, l, l], iso(2084, 9, 2)),
        PackedHijriYearInfo::new(1509, [l, s, l, s, l, s, l, s, s, l, s, l], iso(2085, 8, 22)),
        PackedHijriYearInfo::new(1510, [l, s, l, l, s, l, s, l, s, s, l, s], iso(2086, 8, 11)),
        PackedHijriYearInfo::new(1511, [l, s, l, l, s, l, l, s, l, s, s, l], iso(2087, 7, 31)),
        PackedHijriYearInfo::new(1512, [s, l, s, l, s, l, l, l, s, l, s, l], iso(2088, 7, 20)),
        PackedHijriYearInfo::new(1513, [s, s, s, l, s, l, l, l, s, l, l, s], iso(2089, 7, 10)),
        PackedHijriYearInfo::new(1514, [l, s, s, s, l, s, l, l, s, l, l, l], iso(2090, 6, 29)),
        PackedHijriYearInfo::new(1515, [s, s, l, s, s, l, s, l, l, s, l, l], iso(2091, 6, 19)),
        PackedHijriYearInfo::new(1516, [s, l, s, l, s, s, l, s, l, s, l, l], iso(2092, 6, 7)),
        PackedHijriYearInfo::new(1517, [s, l, s, l, s, l, l, s, s, l, s, l], iso(2093, 5, 27)),
        PackedHijriYearInfo::new(1518, [s, l, s, l, l, s, l, l, s, l, s, s], iso(2094, 5, 16)),
        PackedHijriYearInfo::new(1519, [l, s, s, l, l, l, s, l, l, s, l, s], iso(2095, 5, 5)),
        PackedHijriYearInfo::new(1520, [s, l, s, s, l, l, l, s, l, l, s, l], iso(2096, 4, 24)),
        PackedHijriYearInfo::new(1521, [s, s, s, l, s, l, l, s, l, l, s, l], iso(2097, 4, 14)),
        PackedHijriYearInfo::new(1522, [l, s, s, s, l, s, l, l, s, l, l, s], iso(2098, 4, 3)),
        PackedHijriYearInfo::new(1523, [l, s, l, s, l, s, l, s, s, l, l, s], iso(2099, 3, 23)),
        PackedHijriYearInfo::new(1524, [l, l, s, l, s, l, s, l, s, s, l, s], iso(2100, 3, 12)),
        PackedHijriYearInfo::new(1525, [l, l, s, l, l, s, l, s, l, s, s, l], iso(2101, 3, 1)),
        PackedHijriYearInfo::new(1526, [s, l, s, l, l, l, s, l, s, l, s, s], iso(2102, 2, 19)),
        PackedHijriYearInfo::new(1527, [l, s, l, s, l, l, s, l, l, s, l, s], iso(2103, 2, 8)),
        PackedHijriYearInfo::new(1528, [l, s, s, l, s, l, s, l, l, s, l, l], iso(2104, 1, 29)),
        PackedHijriYearInfo::new(1529, [s, l, s, s, l, s, l, s, l, s, l, l], iso(2105, 1, 18)),
        PackedHijriYearInfo::new(1530, [s, l, l, s, s, l, s, l, s, s, l, l], iso(2106, 1, 7)),
        PackedHijriYearInfo::new(1531, [s, l, l, l, s, s, l, s, l, s, s, l], iso(2106, 12, 27)),
        PackedHijriYearInfo::new(1532, [s, l, l, l, s, l, l, s, s, s, l, s], iso(2107, 12, 16)),
        PackedHijriYearInfo::new(1533, [l, s, l, l, l, s, l, s, l, s, s, l], iso(2108, 12, 4)),
        PackedHijriYearInfo::new(1534, [s, l, s, l, l, s, l, l, s, s, l, s], iso(2109, 11, 24)),
        PackedHijriYearInfo::new(1535, [l, s, l, s, l, s, l, l, s, l, s, l], iso(2110, 11, 13)),
        PackedHijriYearInfo::new(1536, [s, l, s, l, s, l, s, l, s, l, s, l], iso(2111, 11, 3)),
        PackedHijriYearInfo::new(1537, [l, s, l, l, s, s, l, s, s, l, s, l], iso(2112, 10, 22)),
        PackedHijriYearInfo::new(1538, [l, l, s, l, l, s, s, l, s, s, l, s], iso(2113, 10, 11)),
        PackedHijriYearInfo::new(1539, [l, l, l, s, l, l, s, s, l, s, s, l], iso(2114, 9, 30)),
        PackedHijriYearInfo::new(1540, [s, l, l, s, l, l, s, l, s, s, l, s], iso(2115, 9, 20)),
        PackedHijriYearInfo::new(1541, [l, s, l, s, l, l, l, s, l, s, s, l], iso(2116, 9, 8)),
        PackedHijriYearInfo::new(1542, [s, l, s, l, s, l, l, s, l, s, l, l], iso(2117, 8, 29)),
        PackedHijriYearInfo::new(1543, [s, l, s, s, l, s, l, s, l, s, l, l], iso(2118, 8, 19)),
        PackedHijriYearInfo::new(1544, [l, s, l, s, s, l, s, l, s, l, s, l], iso(2119, 8, 8)),
        PackedHijriYearInfo::new(1545, [l, l, s, l, s, s, l, s, l, s, s, l], iso(2120, 7, 27)),
        PackedHijriYearInfo::new(1546, [l, l, s, l, s, l, s, l, s, l, s, s], iso(2121, 7, 16)),
        PackedHijriYearInfo::new(1547, [l, l, s, l, l, s, l, s, l, s, l, s], iso(2122, 7, 5)),
        PackedHijriYearInfo::new(1548, [l, s, s, l, l, s, l, l, s, l, s, l], iso(2123, 6, 25)),
        PackedHijriYearInfo::new(1549, [s, l, s, s, l, s, l, l, l, s, l, s], iso(2124, 6, 14)),
        PackedHijriYearInfo::new(1550, [l, s, l, s, s, s, l, l, l, s, l, l], iso(2125, 6, 3)),
        PackedHijriYearInfo::new(1551, [s, l, s, s, l, s, s, l, l, s, l, l], iso(2126, 5, 24)),
        PackedHijriYearInfo::new(1552, [l, s, l, s, s, l, s, s, l, l, s, l], iso(2127, 5, 13)),
        PackedHijriYearInfo::new(1553, [l, s, l, s, l, s, l, s, l, s, l, s], iso(2128, 5, 1)),
        PackedHijriYearInfo::new(1554, [l, s, l, s, l, l, s, l, s, l, s, l], iso(2129, 4, 20)),
        PackedHijriYearInfo::new(1555, [s, s, l, s, l, l, s, l, l, s, l, s], iso(2130, 4, 10)),
        PackedHijriYearInfo::new(1556, [l, s, s, l, s, l, s, l, l, l, s, l], iso(2131, 3, 30)),
        PackedHijriYearInfo::new(1557, [s, l, s, s, s, l, s, l, l, l, l, s], iso(2132, 3, 19)),
        PackedHijriYearInfo::new(1558, [l, s, l, s, s, s, l, s, l, l, l, s], iso(2133, 3, 8)),
        PackedHijriYearInfo::new(1559, [l, l, s, s, l, s, s, l, l, s, l, s], iso(2134, 2, 25)),
        PackedHijriYearInfo::new(1560, [l, l, s, l, s, l, s, l, s, l, s, l], iso(2135, 2, 14)),
        PackedHijriYearInfo::new(1561, [s, l, l, s, l, s, l, l, s, s, l, s], iso(2136, 2, 4)),
        PackedHijriYearInfo::new(1562, [s, l, l, s, l, s, l, l, l, s, s, l], iso(2137, 1, 23)),
        PackedHijriYearInfo::new(1563, [s, l, s, s, l, s, l, l, l, s, l, s], iso(2138, 1, 13)),
        PackedHijriYearInfo::new(1564, [l, s, l, s, s, l, s, l, l, l, s, l], iso(2139, 1, 2)),
        PackedHijriYearInfo::new(1565, [s, l, s, l, s, s, l, s, l, l, s, l], iso(2139, 12, 23)),
        PackedHijriYearInfo::new(1566, [l, s, l, s, l, s, s, l, s, l, s, l], iso(2140, 12, 11)),
        PackedHijriYearInfo::new(1567, [l, s, l, l, s, l, s, l, s, s, l, s], iso(2141, 11, 30)),
        PackedHijriYearInfo::new(1568, [l, s, l, l, l, s, l, s, l, s, s, s], iso(2142, 11, 19)),
        PackedHijriYearInfo::new(1569, [l, s, l, l, l, s, l, l, s, l, s, s], iso(2143, 11, 8)),
        PackedHijriYearInfo::new(1570, [s, l, s, l, l, s, l, l, l, s, s, l], iso(2144, 10, 28)),
        PackedHijriYearInfo::new(1571, [s, s, l, s, l, l, s, l, l, s, l, s], iso(2145, 10, 18)),
        PackedHijriYearInfo::new(1572, [l, s, s, l, s, l, s, l, l, s, l, s], iso(2146, 10, 7)),
        PackedHijriYearInfo::new(1573, [l, s, l, l, s, l, s, s, l, s, l, s], iso(2147, 9, 26)),
        PackedHijriYearInfo::new(1574, [l, l, s, l, l, s, l, s, s, l, s, s], iso(2148, 9, 14)),
        PackedHijriYearInfo::new(1575, [l, l, l, s, l, l, s, l, s, s, s, l], iso(2149, 9, 3)),
        PackedHijriYearInfo::new(1576, [s, l, l, s, l, l, l, s, l, s, s, s], iso(2150, 8, 24)),
        PackedHijriYearInfo::new(1577, [l, s, l, l, s, l, l, s, l, s, l, s], iso(2151, 8, 13)),
        PackedHijriYearInfo::new(1578, [s, l, s, l, s, l, l, s, l, l, s, l], iso(2152, 8, 2)),
        PackedHijriYearInfo::new(1579, [s, l, s, l, s, s, l, l, s, l, s, l], iso(2153, 7, 23)),
        PackedHijriYearInfo::new(1580, [s, l, l, s, l, s, s, l, s, l, s, l], iso(2154, 7, 12)),
        PackedHijriYearInfo::new(1581, [l, l, s, l, s, l, s, s, l, s, l, s], iso(2155, 7, 1)),
        PackedHijriYearInfo::new(1582, [l, l, s, l, l, s, l, s, l, s, s, s], iso(2156, 6, 19)),
        PackedHijriYearInfo::new(1583, [l, l, s, l, l, l, s, l, s, l, s, s], iso(2157, 6, 8)),
        PackedHijriYearInfo::new(1584, [s, l, l, s, l, l, s, l, l, s, l, s], iso(2158, 5, 29)),
        PackedHijriYearInfo::new(1585, [s, l, s, l, s, l, s, l, l, s, l, l], iso(2159, 5, 19)),
        PackedHijriYearInfo::new(1586, [s, s, l, s, l, s, s, l, l, l, s, l], iso(2160, 5, 8)),
        PackedHijriYearInfo::new(1587, [s, l, l, s, s, s, l, s, l, s, l, l], iso(2161, 4, 27)),
        PackedHijriYearInfo::new(1588, [l, s, l, l, s, s, s, l, s, l, s, l], iso(2162, 4, 16)),
        PackedHijriYearInfo::new(1589, [l, s, l, l, s, l, s, s, l, s, l, s], iso(2163, 4, 5)),
        PackedHijriYearInfo::new(1590, [l, s, l, l, l, s, s, l, s, l, s, l], iso(2164, 3, 24)),
        PackedHijriYearInfo::new(1591, [s, l, s, l, l, s, l, s, l, s, l, s], iso(2165, 3, 14)),
        PackedHijriYearInfo::new(1592, [l, s, l, s, l, s, l, s, l, l, l, s], iso(2166, 3, 3)),
        PackedHijriYearInfo::new(1593, [l, s, s, l, s, s, l, s, l, l, l, s], iso(2167, 2, 21)),
        PackedHijriYearInfo::new(1594, [l, l, s, s, l, s, s, s, l, l, l, l], iso(2168, 2, 10)),
        PackedHijriYearInfo::new(1595, [s, l, s, l, s, s, l, s, s, l, l, l], iso(2169, 1, 30)),
        PackedHijriYearInfo::new(1596, [s, l, l, s, l, s, s, l, s, l, s, l], iso(2170, 1, 19)),
        PackedHijriYearInfo::new(1597, [s, l, l, s, l, s, l, s, l, s, l, s], iso(2171, 1, 8)),
        PackedHijriYearInfo::new(1598, [l, s, l, s, l, l, s, l, s, l, l, s], iso(2171, 12, 28)),
        PackedHijriYearInfo::new(1599, [s, l, s, l, s, l, s, l, l, l, s, l], iso(2172, 12, 17)),
        PackedHijriYearInfo::new(1600, [s, s, l, s, l, s, s, l, l, l, s, l], iso(2173, 12, 7)),
    ]
};
