// PKCS#8 private keys for ML-DSA variants
var pkcs8 = {
  'ML-DSA-44': new Uint8Array([
    48, 52, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 17, 4, 34, 128,
    32, 153, 21, 95, 99, 48, 150, 218, 124, 190, 8, 122, 137, 72, 184, 79, 118,
    123, 16, 249, 1, 200, 35, 194, 64, 177, 221, 43, 200, 112, 5, 201, 62,
  ]),
  'ML-DSA-65': new Uint8Array([
    48, 52, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 18, 4, 34, 128,
    32, 132, 164, 137, 75, 123, 70, 164, 178, 3, 156, 206, 16, 195, 26, 133,
    186, 176, 195, 102, 48, 254, 35, 29, 66, 103, 17, 67, 152, 38, 7, 130, 139,
  ]),
  'ML-DSA-87': new Uint8Array([
    48, 52, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 19, 4, 34, 128,
    32, 161, 80, 109, 145, 76, 109, 101, 140, 117, 39, 228, 51, 151, 221, 109,
    76, 37, 246, 164, 121, 116, 51, 90, 76, 208, 59, 254, 105, 131, 68, 18, 81,
  ]),
};

// SPKI public keys for ML-DSA variants
var spki = {
  'ML-DSA-44': new Uint8Array([
    48, 130, 5, 50, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 17, 3, 130, 5,
    33, 0, 85, 152, 213, 68, 198, 20, 177, 84, 200, 188, 33, 104, 36, 161, 193,
    127, 226, 151, 48, 107, 122, 191, 89, 86, 188, 3, 245, 199, 18, 79, 168,
    192, 218, 218, 223, 227, 84, 133, 41, 187, 9, 183, 14, 222, 155, 137, 84,
    111, 138, 97, 234, 152, 52, 15, 163, 47, 227, 218, 19, 20, 229, 93, 99, 252,
    155, 213, 30, 241, 158, 211, 213, 191, 155, 73, 211, 145, 59, 194, 75, 140,
    3, 161, 149, 139, 48, 172, 155, 172, 120, 234, 142, 79, 78, 116, 215, 184,
    50, 182, 162, 192, 93, 221, 179, 216, 70, 186, 92, 93, 51, 190, 61, 173,
    105, 206, 9, 208, 52, 54, 208, 252, 115, 176, 146, 118, 23, 0, 5, 41, 151,
    121, 241, 246, 193, 206, 212, 160, 181, 7, 99, 220, 78, 96, 123, 142, 35,
    107, 37, 218, 138, 139, 228, 207, 166, 132, 87, 36, 116, 251, 174, 10, 41,
    196, 171, 26, 212, 90, 213, 223, 141, 87, 232, 59, 46, 173, 16, 247, 173, 4,
    219, 165, 234, 8, 217, 233, 163, 13, 10, 160, 22, 87, 232, 2, 9, 92, 177,
    35, 67, 55, 104, 51, 204, 231, 81, 209, 62, 31, 117, 56, 141, 78, 109, 148,
    118, 191, 93, 193, 59, 30, 88, 237, 19, 169, 14, 11, 150, 102, 215, 144, 69,
    246, 32, 159, 110, 49, 75, 78, 225, 121, 184, 206, 234, 126, 171, 164, 43,
    237, 244, 63, 83, 70, 136, 213, 244, 121, 184, 34, 201, 249, 95, 64, 165,
    99, 14, 195, 231, 18, 121, 20, 156, 80, 231, 133, 197, 0, 94, 195, 22, 251,
    255, 174, 213, 103, 75, 88, 58, 138, 66, 37, 85, 162, 15, 242, 29, 49, 147,
    191, 163, 170, 109, 195, 22, 63, 197, 149, 117, 100, 36, 81, 115, 203, 126,
    62, 86, 103, 193, 182, 69, 238, 233, 162, 62, 248, 132, 158, 212, 208, 187,
    127, 212, 198, 169, 245, 26, 153, 28, 207, 85, 65, 145, 200, 23, 196, 38,
    64, 49, 54, 233, 185, 72, 156, 86, 230, 127, 152, 108, 184, 240, 109, 8,
    103, 228, 206, 142, 73, 74, 214, 52, 182, 203, 82, 201, 175, 188, 111, 42,
    232, 8, 177, 131, 47, 237, 92, 120, 210, 124, 48, 185, 215, 137, 36, 70,
    162, 164, 119, 0, 155, 20, 57, 33, 27, 220, 77, 254, 233, 190, 106, 135, 21,
    194, 57, 238, 95, 162, 78, 164, 33, 210, 215, 43, 100, 96, 232, 87, 19, 43,
    65, 240, 183, 17, 131, 247, 97, 241, 7, 111, 159, 40, 252, 45, 228, 76, 71,
    46, 85, 181, 54, 41, 135, 162, 144, 227, 128, 121, 173, 207, 119, 54, 19,
    197, 23, 231, 176, 125, 190, 32, 76, 60, 34, 24, 160, 42, 73, 190, 124, 99,
    5, 9, 214, 6, 220, 177, 206, 79, 222, 10, 142, 250, 63, 179, 67, 21, 159,
    57, 126, 239, 28, 238, 240, 107, 79, 185, 174, 232, 168, 146, 128, 229, 119,
    19, 21, 33, 239, 193, 42, 178, 152, 124, 24, 203, 131, 193, 93, 162, 2, 208,
    231, 20, 203, 232, 47, 54, 114, 255, 236, 97, 99, 156, 15, 160, 75, 60, 111,
    59, 35, 25, 230, 43, 91, 170, 161, 74, 70, 179, 180, 251, 71, 197, 240, 104,
    42, 39, 202, 206, 12, 115, 249, 138, 55, 252, 216, 61, 185, 121, 76, 137,
    172, 166, 88, 92, 130, 18, 52, 67, 13, 187, 49, 147, 212, 77, 74, 56, 59,
    123, 99, 205, 36, 137, 96, 111, 148, 121, 157, 2, 83, 246, 86, 156, 152, 98,
    172, 77, 244, 214, 225, 184, 240, 121, 144, 56, 213, 161, 43, 67, 4, 161,
    104, 202, 91, 134, 247, 108, 24, 46, 187, 63, 216, 50, 125, 120, 17, 216,
    22, 228, 156, 253, 7, 180, 15, 130, 180, 72, 71, 169, 3, 236, 247, 11, 170,
    32, 76, 236, 225, 133, 250, 20, 235, 200, 143, 89, 25, 158, 49, 158, 164,
    213, 221, 81, 120, 241, 150, 210, 19, 79, 165, 24, 35, 170, 182, 242, 255,
    143, 171, 148, 140, 41, 207, 186, 98, 224, 16, 152, 224, 38, 110, 175, 169,
    111, 132, 201, 178, 114, 25, 196, 50, 149, 158, 193, 180, 101, 183, 92, 109,
    131, 102, 119, 123, 78, 107, 223, 4, 1, 206, 140, 130, 237, 205, 36, 18,
    180, 197, 154, 26, 236, 140, 173, 230, 101, 35, 189, 121, 104, 21, 75, 81,
    224, 186, 212, 81, 107, 66, 244, 235, 64, 90, 206, 39, 44, 43, 162, 187, 63,
    229, 217, 154, 185, 157, 24, 125, 252, 91, 136, 59, 47, 182, 200, 73, 19,
    137, 132, 81, 16, 234, 227, 210, 32, 16, 160, 188, 250, 27, 190, 164, 53,
    244, 219, 199, 177, 146, 117, 50, 99, 72, 235, 37, 154, 72, 51, 203, 61, 39,
    230, 34, 132, 117, 217, 167, 201, 42, 17, 76, 72, 103, 172, 93, 169, 29, 76,
    88, 178, 226, 32, 53, 190, 60, 210, 132, 113, 198, 26, 70, 179, 47, 34, 184,
    88, 178, 208, 1, 196, 89, 136, 167, 33, 38, 9, 255, 89, 202, 27, 93, 229,
    100, 192, 24, 234, 200, 186, 125, 231, 212, 188, 11, 29, 51, 189, 70, 147,
    176, 231, 81, 16, 114, 152, 159, 21, 124, 185, 208, 50, 74, 211, 113, 207,
    35, 54, 173, 205, 133, 52, 167, 199, 87, 158, 120, 33, 204, 163, 146, 233,
    21, 61, 28, 102, 48, 232, 184, 15, 219, 238, 240, 215, 222, 239, 3, 110,
    180, 95, 103, 147, 236, 10, 57, 195, 159, 231, 50, 92, 145, 165, 44, 204,
    121, 187, 9, 210, 80, 86, 251, 169, 132, 236, 248, 23, 207, 222, 227, 13,
    53, 1, 88, 69, 105, 13, 238, 202, 251, 194, 245, 14, 38, 1, 245, 157, 212,
    162, 182, 217, 230, 115, 139, 175, 219, 199, 74, 124, 186, 158, 3, 220, 87,
    220, 177, 85, 13, 58, 168, 223, 6, 238, 156, 80, 121, 44, 166, 176, 0, 48,
    98, 70, 93, 78, 50, 192, 16, 186, 2, 233, 105, 105, 120, 195, 17, 100, 141,
    214, 158, 144, 63, 4, 88, 190, 101, 209, 55, 119, 46, 128, 117, 225, 121,
    204, 195, 19, 61, 170, 116, 251, 225, 230, 28, 27, 249, 84, 195, 224, 190,
    60, 212, 83, 3, 148, 204, 4, 103, 50, 233, 175, 207, 47, 51, 216, 79, 251,
    150, 81, 171, 7, 145, 55, 188, 187, 217, 200, 155, 246, 85, 42, 123, 18,
    112, 192, 116, 163, 40, 187, 132, 192, 210, 188, 106, 117, 217, 185, 183,
    202, 33, 11, 205, 10, 61, 52, 15, 66, 131, 121, 112, 26, 96, 166, 241, 1,
    68, 206, 80, 92, 132, 83, 89, 126, 135, 157, 4, 202, 16, 5, 131, 112, 62,
    56, 234, 176, 213, 119, 205, 203, 17, 106, 156, 117, 251, 135, 21, 73, 219,
    238, 3, 88, 21, 71, 136, 118, 0, 7, 106, 151, 200, 221, 179, 206, 50, 198,
    27, 118, 181, 27, 85, 35, 248, 44, 57, 15, 221, 97, 121, 4, 167, 111, 182,
    207, 195, 52, 134, 195, 128, 173, 111, 98, 152, 29, 138, 197, 175, 171, 247,
    194, 20, 134, 209, 232, 94, 17, 203, 139, 30, 237, 187, 243, 16, 180, 43,
    105, 236, 66, 175, 170, 139, 24, 99, 28, 225, 141, 96, 250, 119, 0, 111,
    212, 34, 217, 42, 134, 88, 78, 76, 126, 169, 168, 59, 154, 93, 54, 43, 161,
    29, 111, 124, 59, 225, 52, 86, 147, 38, 151, 161, 36, 119, 204, 164, 121,
    46, 186, 65, 84, 70, 38, 15, 203, 48, 168, 235, 231, 30, 55, 95, 36, 10, 20,
    166, 109, 8, 18, 109, 251, 213, 82, 142, 240, 49, 249, 180, 78, 69,
  ]),
  'ML-DSA-65': new Uint8Array([
    48, 130, 7, 178, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 18, 3, 130, 7,
    161, 0, 216, 177, 233, 60, 151, 24, 246, 66, 175, 161, 192, 118, 9, 177, 87,
    232, 5, 216, 49, 254, 251, 160, 51, 216, 250, 171, 229, 104, 149, 117, 135,
    107, 5, 239, 244, 167, 83, 57, 49, 153, 29, 135, 108, 138, 117, 236, 120,
    65, 89, 65, 17, 201, 127, 147, 246, 103, 238, 204, 25, 83, 240, 29, 173,
    127, 140, 1, 88, 40, 43, 134, 51, 19, 125, 131, 224, 50, 167, 82, 20, 217,
    215, 162, 41, 95, 215, 56, 130, 226, 177, 216, 20, 169, 133, 85, 140, 9,
    105, 172, 54, 121, 0, 87, 202, 18, 93, 96, 147, 103, 127, 164, 63, 197, 97,
    49, 230, 125, 53, 80, 64, 20, 239, 29, 90, 118, 102, 221, 177, 6, 220, 220,
    170, 107, 107, 18, 138, 125, 138, 70, 66, 60, 185, 232, 209, 4, 100, 17,
    118, 24, 181, 110, 241, 50, 250, 138, 209, 19, 84, 220, 61, 96, 80, 128, 81,
    101, 160, 9, 5, 53, 33, 112, 60, 59, 195, 79, 115, 190, 101, 93, 56, 171,
    146, 51, 82, 233, 66, 225, 226, 211, 72, 58, 9, 74, 222, 185, 175, 211, 156,
    164, 68, 188, 119, 46, 14, 64, 160, 13, 207, 60, 81, 68, 108, 148, 59, 88,
    88, 92, 88, 171, 249, 204, 160, 137, 222, 234, 168, 233, 3, 86, 224, 174,
    105, 224, 1, 177, 184, 230, 236, 30, 85, 249, 56, 105, 211, 50, 83, 168,
    139, 28, 175, 181, 22, 89, 166, 215, 152, 218, 184, 111, 65, 24, 82, 71,
    185, 100, 172, 66, 178, 6, 215, 164, 252, 56, 40, 198, 207, 152, 110, 186,
    207, 39, 235, 179, 38, 215, 88, 105, 109, 177, 130, 91, 5, 223, 164, 78,
    241, 176, 125, 197, 94, 100, 40, 214, 251, 239, 253, 88, 154, 14, 75, 254,
    94, 210, 86, 244, 51, 95, 168, 139, 213, 73, 87, 151, 209, 150, 126, 88, 69,
    251, 116, 157, 122, 96, 212, 206, 42, 218, 38, 85, 184, 50, 246, 188, 35,
    72, 60, 226, 155, 246, 86, 209, 110, 133, 161, 129, 126, 80, 154, 238, 64,
    64, 170, 156, 177, 225, 52, 87, 42, 88, 154, 174, 246, 30, 84, 143, 221, 51,
    27, 65, 60, 40, 22, 120, 42, 145, 34, 82, 235, 79, 20, 215, 211, 231, 151,
    108, 119, 53, 116, 190, 13, 139, 199, 189, 84, 54, 186, 222, 90, 116, 253,
    227, 207, 104, 209, 118, 42, 144, 94, 22, 219, 198, 211, 216, 171, 75, 245,
    61, 240, 157, 108, 81, 19, 238, 39, 120, 210, 242, 63, 126, 6, 15, 18, 97,
    232, 207, 184, 84, 239, 72, 115, 90, 95, 112, 78, 45, 201, 13, 102, 208,
    151, 146, 253, 153, 177, 115, 14, 194, 184, 107, 118, 120, 63, 105, 89, 144,
    60, 242, 80, 106, 32, 11, 204, 170, 165, 221, 182, 31, 187, 159, 216, 118,
    218, 207, 182, 107, 136, 211, 162, 231, 196, 128, 83, 251, 192, 189, 149, 1,
    245, 36, 146, 159, 11, 116, 30, 191, 141, 182, 157, 227, 91, 88, 72, 224,
    55, 195, 96, 245, 135, 249, 142, 16, 229, 237, 27, 60, 2, 91, 138, 82, 197,
    210, 40, 8, 123, 172, 202, 207, 119, 199, 190, 102, 40, 141, 174, 93, 211,
    219, 134, 105, 26, 103, 100, 102, 62, 130, 224, 135, 173, 82, 224, 200, 213,
    76, 211, 38, 181, 16, 97, 99, 75, 14, 42, 162, 223, 237, 141, 1, 29, 140,
    191, 146, 49, 236, 179, 88, 202, 220, 124, 239, 231, 131, 101, 134, 111, 28,
    54, 151, 172, 67, 167, 113, 96, 204, 63, 76, 169, 95, 14, 175, 149, 189,
    173, 39, 177, 102, 23, 158, 102, 236, 224, 70, 203, 190, 132, 230, 136, 3,
    28, 201, 131, 148, 164, 219, 181, 208, 26, 239, 111, 86, 35, 102, 133, 114,
    113, 180, 184, 82, 180, 106, 124, 248, 126, 87, 177, 165, 176, 204, 128,
    141, 179, 141, 34, 119, 160, 57, 206, 168, 95, 197, 110, 79, 60, 48, 170,
    125, 206, 147, 137, 156, 85, 46, 7, 193, 228, 150, 22, 46, 147, 51, 153,
    157, 248, 151, 253, 114, 58, 126, 38, 127, 19, 225, 99, 183, 235, 175, 90,
    166, 8, 233, 141, 10, 85, 232, 147, 7, 20, 137, 240, 84, 231, 86, 134, 50,
    212, 201, 6, 253, 18, 150, 114, 160, 140, 2, 254, 189, 152, 14, 68, 110, 50,
    134, 199, 73, 237, 56, 116, 110, 135, 36, 40, 14, 167, 50, 71, 81, 9, 178,
    54, 182, 247, 64, 32, 204, 116, 92, 131, 40, 30, 246, 188, 236, 182, 187,
    132, 239, 124, 136, 238, 146, 137, 247, 87, 52, 15, 78, 108, 135, 178, 101,
    70, 199, 193, 192, 144, 196, 106, 186, 141, 42, 101, 214, 196, 67, 175, 38,
    8, 189, 148, 166, 253, 221, 144, 119, 81, 1, 232, 175, 81, 237, 13, 188,
    220, 230, 47, 115, 184, 179, 0, 51, 118, 39, 22, 114, 232, 88, 15, 121, 216,
    130, 107, 173, 108, 175, 225, 113, 40, 223, 185, 6, 244, 227, 73, 38, 64,
    84, 10, 200, 53, 81, 179, 217, 106, 172, 59, 161, 70, 180, 70, 48, 56, 46,
    233, 133, 245, 57, 120, 154, 167, 49, 109, 188, 152, 245, 181, 1, 159, 247,
    44, 167, 152, 6, 191, 246, 38, 120, 141, 57, 241, 168, 60, 38, 6, 82, 248,
    87, 85, 0, 10, 22, 19, 44, 178, 63, 38, 78, 1, 210, 166, 140, 3, 199, 112,
    135, 155, 36, 13, 204, 124, 47, 5, 190, 103, 91, 205, 147, 248, 115, 177,
    196, 180, 234, 85, 35, 24, 182, 16, 207, 107, 167, 10, 54, 193, 146, 71, 95,
    45, 109, 184, 43, 101, 155, 184, 55, 171, 196, 136, 89, 227, 84, 183, 31, 0,
    137, 230, 146, 250, 6, 27, 225, 241, 11, 95, 124, 248, 133, 171, 149, 67,
    73, 19, 110, 104, 173, 86, 6, 246, 195, 196, 200, 175, 53, 18, 198, 223,
    140, 85, 208, 253, 204, 220, 255, 232, 88, 238, 20, 97, 24, 52, 13, 3, 179,
    62, 151, 101, 67, 33, 79, 253, 157, 253, 233, 197, 109, 130, 78, 11, 165,
    214, 200, 41, 157, 63, 46, 175, 251, 246, 225, 227, 199, 92, 107, 216, 58,
    124, 226, 202, 153, 92, 31, 250, 182, 92, 99, 0, 110, 18, 78, 228, 166, 190,
    67, 88, 245, 155, 139, 82, 152, 39, 204, 74, 140, 95, 82, 82, 160, 147, 144,
    33, 0, 242, 200, 22, 102, 160, 233, 102, 224, 42, 205, 240, 56, 95, 197,
    226, 175, 235, 240, 125, 10, 51, 12, 246, 150, 234, 173, 95, 132, 173, 174,
    1, 161, 23, 39, 52, 168, 87, 54, 4, 66, 201, 34, 155, 82, 133, 170, 76, 52,
    226, 109, 163, 19, 34, 184, 226, 39, 20, 75, 72, 201, 70, 188, 71, 182, 230,
    6, 19, 255, 8, 145, 193, 63, 81, 150, 24, 72, 89, 168, 74, 98, 173, 133, 67,
    227, 44, 252, 252, 227, 192, 125, 20, 227, 144, 24, 31, 48, 67, 67, 48, 94,
    163, 52, 219, 163, 225, 214, 214, 109, 211, 122, 213, 198, 90, 204, 40, 97,
    211, 121, 17, 28, 132, 246, 110, 230, 51, 197, 42, 162, 143, 199, 158, 215,
    210, 133, 60, 65, 127, 1, 153, 193, 22, 171, 250, 114, 204, 246, 255, 126,
    25, 96, 44, 164, 102, 172, 211, 23, 245, 122, 48, 221, 249, 138, 148, 134,
    206, 135, 246, 42, 235, 198, 89, 189, 45, 125, 204, 69, 193, 48, 29, 144,
    125, 224, 127, 66, 1, 134, 141, 224, 211, 193, 141, 69, 128, 75, 167, 244,
    160, 120, 54, 191, 214, 29, 40, 249, 15, 46, 68, 141, 91, 242, 91, 80, 252,
    109, 122, 154, 64, 153, 56, 65, 254, 106, 18, 4, 172, 171, 136, 80, 98, 79,
    133, 255, 4, 100, 191, 144, 171, 219, 46, 132, 181, 130, 228, 107, 68, 32,
    123, 201, 17, 67, 35, 144, 180, 160, 30, 125, 9, 55, 184, 172, 0, 159, 250,
    232, 83, 168, 162, 102, 158, 121, 208, 177, 116, 163, 160, 80, 241, 46, 156,
    58, 203, 240, 67, 176, 244, 170, 160, 115, 122, 141, 154, 101, 218, 178,
    119, 130, 195, 32, 207, 51, 149, 98, 51, 219, 57, 121, 216, 156, 101, 218,
    184, 220, 204, 41, 181, 149, 63, 80, 194, 11, 143, 164, 219, 23, 123, 141,
    119, 43, 94, 78, 175, 89, 165, 48, 167, 44, 45, 219, 197, 15, 202, 118, 116,
    245, 151, 218, 14, 199, 96, 27, 102, 206, 198, 123, 222, 178, 210, 20, 200,
    38, 25, 124, 58, 102, 92, 197, 107, 51, 5, 236, 125, 173, 198, 113, 144,
    108, 177, 22, 104, 223, 165, 39, 9, 84, 87, 124, 80, 153, 8, 212, 76, 2, 28,
    12, 90, 212, 129, 148, 212, 229, 63, 29, 200, 113, 171, 154, 107, 189, 202,
    22, 147, 7, 32, 253, 70, 37, 224, 98, 199, 129, 21, 54, 49, 52, 124, 84, 40,
    190, 194, 108, 73, 26, 15, 124, 87, 87, 198, 217, 122, 127, 82, 167, 131,
    59, 8, 172, 49, 162, 61, 64, 79, 196, 205, 65, 110, 75, 130, 128, 197, 182,
    251, 110, 141, 197, 184, 166, 244, 246, 217, 20, 105, 85, 42, 80, 251, 77,
    59, 204, 247, 179, 218, 181, 124, 209, 4, 28, 118, 234, 145, 237, 140, 106,
    54, 88, 82, 28, 235, 68, 221, 109, 139, 11, 166, 182, 63, 142, 194, 255,
    213, 219, 116, 158, 31, 224, 119, 126, 232, 160, 144, 1, 177, 92, 219, 162,
    49, 181, 116, 163, 104, 245, 193, 188, 26, 172, 15, 190, 135, 207, 106, 246,
    13, 132, 76, 189, 160, 25, 123, 26, 20, 48, 203, 59, 209, 69, 235, 103, 253,
    160, 108, 83, 206, 70, 98, 0, 2, 57, 162, 202, 63, 45, 89, 173, 201, 254,
    254, 253, 143, 21, 77, 131, 184, 234, 37, 68, 206, 69, 186, 179, 145, 147,
    135, 42, 137, 152, 253, 213, 240, 13, 122, 161, 218, 186, 180, 213, 162,
    150, 231, 63, 112, 182, 233, 86, 12, 225, 195, 133, 37, 28, 22, 147, 201,
    200, 197, 115, 3, 138, 194, 86, 79, 247, 27, 241, 149, 128, 197, 8, 11, 134,
    53, 118, 175, 248, 253, 114, 91, 31, 192, 253, 209, 111, 31, 228, 244, 184,
    179, 146, 145, 167, 137, 155, 184, 218, 38, 62, 187, 22, 181, 193, 93, 16,
    9, 195, 42, 198, 225, 100, 144, 148, 223, 184, 40, 117, 32, 131, 94, 93, 83,
    88, 125, 95, 220, 20, 206, 7, 228, 78, 54, 238, 178, 196, 38, 245, 95, 8,
    235, 106, 17, 175, 142, 193, 60, 179, 53, 244, 92, 147, 244, 218, 95, 127,
    251, 128, 42, 105, 82, 243, 224, 213, 25, 91, 151, 22, 201, 18, 25, 230,
    165, 85, 25, 249, 170, 160, 171, 210, 209, 32, 154, 124, 245, 60, 30, 255,
    138, 154, 29, 85, 156, 232, 177, 78, 14, 137, 52, 215, 247, 26, 211, 115,
    72, 20, 133, 232, 1, 151, 251, 63, 45, 120, 69, 49, 209, 130, 255, 2, 218,
    21, 251, 16, 86, 30, 62, 136, 92, 149, 60, 6, 125, 129, 145, 235, 102, 190,
    144, 248, 1, 53, 135, 21, 158, 44, 158, 230, 246, 172, 249, 161, 105, 204,
    49, 60, 70, 63, 127, 163, 231, 175, 174, 234, 147, 185, 62, 5, 244, 156, 4,
    31, 39, 156, 176, 154, 251, 166, 143, 212, 43, 30, 97, 50, 37, 176, 155, 77,
    149, 102,
  ]),
  'ML-DSA-87': new Uint8Array([
    48, 130, 10, 50, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 19, 3, 130, 10,
    33, 0, 146, 184, 67, 40, 172, 27, 204, 27, 135, 22, 109, 223, 127, 23, 97,
    130, 198, 228, 199, 62, 178, 21, 173, 20, 88, 180, 205, 168, 17, 164, 135,
    92, 85, 146, 76, 194, 152, 80, 239, 157, 33, 21, 239, 182, 176, 254, 124,
    80, 135, 138, 87, 169, 103, 99, 87, 5, 91, 161, 239, 59, 18, 246, 148, 20,
    32, 60, 117, 245, 182, 156, 196, 230, 82, 117, 228, 211, 81, 45, 115, 217,
    23, 95, 138, 95, 103, 124, 32, 89, 187, 48, 251, 103, 81, 234, 76, 4, 57,
    197, 71, 48, 125, 169, 195, 147, 183, 142, 166, 8, 147, 7, 77, 240, 111, 44,
    168, 23, 89, 107, 95, 220, 75, 202, 44, 25, 244, 200, 160, 0, 174, 111, 107,
    204, 22, 36, 122, 191, 101, 33, 52, 252, 14, 47, 25, 109, 135, 48, 131, 253,
    195, 237, 60, 86, 14, 119, 85, 28, 182, 139, 136, 191, 59, 187, 90, 126,
    207, 168, 238, 184, 83, 77, 254, 208, 21, 57, 104, 188, 228, 134, 82, 249,
    190, 249, 163, 120, 111, 68, 225, 210, 131, 29, 151, 153, 146, 71, 163, 104,
    225, 194, 33, 64, 213, 92, 145, 253, 42, 32, 233, 95, 224, 72, 184, 119,
    192, 113, 253, 177, 153, 246, 240, 49, 103, 170, 229, 82, 69, 186, 36, 252,
    29, 124, 255, 25, 148, 5, 160, 159, 105, 157, 185, 25, 158, 122, 145, 30,
    245, 51, 205, 62, 56, 154, 23, 52, 0, 225, 177, 105, 195, 131, 177, 151,
    197, 114, 110, 128, 227, 127, 176, 28, 252, 217, 56, 61, 136, 148, 190, 124,
    108, 129, 62, 243, 235, 37, 70, 228, 233, 10, 67, 124, 120, 58, 164, 83, 57,
    80, 39, 204, 98, 28, 199, 136, 75, 12, 51, 255, 24, 130, 127, 19, 239, 160,
    94, 137, 75, 15, 82, 158, 252, 163, 43, 236, 193, 234, 27, 74, 69, 14, 179,
    171, 10, 169, 27, 138, 172, 213, 189, 222, 167, 110, 24, 11, 118, 151, 223,
    94, 154, 125, 9, 21, 137, 70, 128, 51, 102, 52, 105, 104, 157, 54, 186, 75,
    217, 226, 169, 71, 125, 177, 253, 218, 85, 236, 242, 25, 215, 147, 181, 104,
    242, 82, 75, 50, 165, 49, 102, 128, 82, 237, 170, 134, 162, 196, 56, 247,
    199, 138, 102, 118, 37, 66, 114, 165, 177, 156, 251, 39, 199, 12, 167, 246,
    169, 150, 108, 91, 192, 42, 68, 192, 244, 255, 107, 18, 191, 7, 73, 19, 174,
    28, 116, 66, 131, 96, 173, 60, 131, 190, 249, 219, 246, 71, 182, 124, 183,
    129, 101, 109, 95, 180, 78, 17, 140, 182, 62, 80, 195, 184, 253, 176, 169,
    153, 1, 29, 83, 39, 252, 150, 41, 219, 176, 48, 151, 108, 60, 255, 239, 0,
    85, 101, 193, 110, 204, 12, 254, 22, 136, 15, 154, 217, 88, 13, 28, 252,
    232, 48, 32, 33, 41, 221, 103, 227, 228, 177, 54, 175, 195, 106, 174, 140,
    54, 128, 108, 214, 228, 215, 118, 226, 206, 171, 21, 155, 162, 152, 135,
    203, 16, 170, 130, 100, 173, 155, 243, 80, 40, 98, 157, 248, 7, 101, 88,
    199, 218, 224, 141, 82, 238, 121, 92, 82, 97, 49, 31, 155, 61, 63, 84, 227,
    90, 143, 164, 59, 216, 101, 19, 35, 134, 2, 20, 18, 197, 97, 215, 169, 85,
    220, 75, 254, 91, 125, 144, 43, 65, 128, 29, 66, 77, 184, 172, 89, 123, 203,
    231, 254, 59, 18, 249, 204, 249, 220, 153, 84, 166, 63, 23, 108, 120, 145,
    216, 67, 223, 123, 248, 15, 253, 63, 191, 126, 84, 95, 98, 141, 66, 200,
    129, 194, 174, 30, 80, 48, 75, 113, 14, 102, 101, 218, 249, 14, 203, 24, 6,
    11, 89, 99, 56, 49, 17, 148, 160, 242, 101, 191, 102, 227, 115, 33, 107, 71,
    235, 6, 141, 68, 161, 162, 165, 227, 159, 82, 253, 54, 157, 214, 255, 141,
    151, 154, 134, 150, 93, 141, 97, 158, 244, 180, 135, 42, 10, 3, 148, 9, 152,
    149, 20, 18, 237, 253, 180, 136, 165, 13, 80, 195, 220, 43, 3, 178, 10, 127,
    144, 2, 207, 209, 246, 40, 110, 38, 133, 9, 22, 180, 11, 223, 116, 236, 205,
    186, 25, 183, 155, 165, 77, 206, 101, 255, 106, 223, 70, 10, 22, 176, 119,
    142, 163, 197, 178, 251, 216, 112, 237, 63, 201, 77, 219, 196, 2, 176, 48,
    15, 207, 91, 74, 236, 21, 8, 205, 126, 77, 28, 13, 26, 28, 202, 250, 100,
    79, 134, 209, 193, 78, 202, 58, 248, 124, 215, 64, 143, 244, 17, 23, 163,
    162, 241, 249, 49, 210, 168, 203, 213, 135, 77, 14, 29, 35, 193, 234, 58,
    12, 106, 165, 163, 251, 192, 115, 251, 7, 198, 189, 93, 207, 178, 246, 50,
    189, 185, 51, 45, 84, 140, 194, 34, 46, 92, 90, 136, 81, 81, 53, 52, 253,
    128, 247, 131, 243, 21, 207, 245, 141, 49, 178, 213, 214, 211, 8, 17, 234,
    133, 225, 104, 197, 186, 224, 117, 1, 173, 104, 17, 177, 161, 223, 71, 195,
    159, 194, 45, 177, 116, 26, 187, 193, 161, 213, 179, 158, 8, 122, 186, 122,
    191, 158, 5, 12, 178, 235, 78, 132, 78, 189, 16, 86, 110, 73, 51, 129, 255,
    242, 110, 63, 6, 53, 209, 110, 132, 236, 43, 239, 192, 221, 138, 1, 128,
    176, 0, 113, 85, 119, 201, 36, 188, 202, 9, 223, 98, 196, 42, 130, 158, 149,
    200, 150, 202, 132, 118, 153, 97, 54, 195, 154, 15, 45, 246, 129, 144, 255,
    231, 75, 25, 56, 47, 178, 98, 10, 106, 84, 56, 113, 161, 227, 37, 246, 1,
    245, 129, 173, 70, 186, 11, 28, 125, 198, 243, 225, 113, 130, 5, 138, 52,
    251, 194, 152, 105, 48, 214, 13, 246, 228, 75, 236, 194, 223, 177, 64, 150,
    97, 167, 20, 27, 74, 76, 166, 199, 239, 91, 240, 8, 22, 54, 41, 63, 35, 112,
    255, 251, 88, 252, 147, 173, 185, 43, 98, 83, 155, 230, 176, 55, 161, 8, 83,
    15, 110, 151, 241, 110, 168, 203, 190, 198, 218, 152, 144, 150, 58, 123, 11,
    123, 250, 104, 113, 198, 93, 1, 152, 51, 172, 140, 246, 115, 113, 229, 218,
    166, 200, 35, 123, 16, 133, 169, 191, 59, 103, 12, 114, 15, 60, 37, 4, 92,
    208, 54, 31, 79, 56, 225, 6, 11, 74, 107, 79, 225, 239, 16, 73, 249, 234,
    197, 129, 230, 97, 39, 115, 49, 96, 141, 41, 242, 225, 177, 214, 18, 103,
    34, 229, 37, 176, 241, 99, 82, 227, 195, 77, 32, 64, 4, 120, 49, 199, 209,
    139, 2, 4, 222, 233, 45, 151, 141, 142, 252, 41, 124, 231, 13, 144, 63, 212,
    252, 145, 34, 142, 232, 152, 84, 135, 87, 175, 46, 53, 139, 60, 168, 135,
    167, 101, 253, 127, 152, 138, 154, 31, 231, 198, 77, 89, 182, 9, 54, 103,
    119, 100, 218, 245, 44, 191, 74, 30, 152, 84, 22, 62, 159, 131, 163, 223, 3,
    51, 194, 241, 49, 9, 213, 43, 214, 201, 75, 158, 198, 22, 203, 209, 190,
    199, 189, 75, 4, 6, 72, 60, 241, 113, 171, 30, 42, 143, 73, 51, 72, 206,
    110, 175, 203, 195, 199, 15, 155, 208, 166, 121, 26, 132, 59, 44, 72, 155,
    7, 48, 122, 132, 224, 142, 3, 7, 21, 207, 11, 30, 112, 18, 149, 146, 127,
    41, 104, 197, 169, 86, 213, 108, 253, 111, 160, 5, 11, 202, 172, 233, 32, 5,
    52, 92, 124, 152, 162, 11, 88, 28, 166, 248, 141, 251, 38, 161, 53, 49, 136,
    246, 183, 85, 9, 165, 115, 108, 18, 208, 218, 129, 165, 163, 131, 34, 32,
    94, 226, 121, 93, 24, 87, 226, 105, 25, 242, 128, 198, 78, 26, 237, 21, 92,
    33, 121, 8, 119, 131, 140, 193, 14, 60, 139, 130, 19, 65, 96, 50, 5, 249,
    12, 27, 51, 23, 195, 89, 255, 47, 23, 109, 62, 202, 190, 5, 131, 92, 91, 39,
    27, 209, 132, 146, 95, 98, 66, 26, 230, 186, 236, 186, 162, 149, 81, 143,
    221, 21, 79, 171, 236, 21, 161, 19, 135, 10, 213, 168, 200, 135, 19, 221,
    177, 207, 106, 214, 194, 124, 220, 53, 45, 176, 245, 178, 189, 49, 242, 22,
    230, 154, 241, 146, 230, 187, 180, 244, 158, 145, 197, 225, 51, 150, 140,
    26, 175, 78, 142, 243, 232, 221, 137, 205, 130, 178, 54, 216, 136, 118, 212,
    33, 90, 206, 18, 224, 158, 44, 23, 144, 204, 24, 184, 48, 81, 233, 124, 20,
    222, 77, 119, 144, 22, 145, 241, 19, 206, 135, 252, 164, 114, 84, 37, 175,
    107, 67, 243, 183, 137, 213, 53, 236, 41, 73, 50, 34, 146, 218, 204, 68,
    235, 158, 150, 139, 133, 75, 248, 157, 7, 0, 53, 68, 44, 156, 110, 56, 197,
    209, 201, 0, 155, 225, 85, 35, 169, 193, 231, 36, 31, 142, 101, 168, 29,
    192, 31, 128, 81, 191, 253, 184, 153, 226, 214, 1, 27, 6, 0, 192, 36, 101,
    72, 105, 150, 226, 3, 21, 12, 127, 72, 250, 223, 240, 136, 249, 157, 129,
    247, 91, 178, 157, 208, 86, 146, 23, 176, 150, 35, 211, 155, 22, 207, 119,
    168, 167, 122, 180, 183, 106, 97, 138, 87, 96, 34, 141, 110, 145, 231, 226,
    35, 115, 232, 129, 54, 186, 128, 190, 238, 37, 169, 194, 37, 24, 237, 211,
    164, 111, 54, 88, 245, 125, 67, 78, 194, 11, 194, 235, 217, 87, 203, 14,
    220, 189, 107, 68, 94, 139, 66, 230, 5, 54, 64, 28, 246, 143, 75, 127, 239,
    243, 20, 251, 189, 246, 246, 151, 90, 219, 227, 242, 223, 205, 40, 124, 245,
    4, 189, 72, 39, 145, 110, 96, 120, 164, 27, 117, 146, 177, 30, 76, 173, 106,
    130, 228, 192, 189, 59, 167, 30, 127, 178, 164, 5, 133, 80, 199, 207, 216,
    189, 156, 93, 222, 150, 129, 81, 193, 180, 38, 59, 8, 214, 210, 95, 150,
    182, 175, 148, 43, 153, 169, 66, 62, 135, 140, 159, 89, 195, 253, 3, 132,
    180, 164, 244, 243, 232, 71, 196, 200, 158, 194, 114, 115, 193, 88, 161,
    185, 235, 247, 14, 126, 225, 176, 111, 17, 79, 77, 245, 80, 229, 174, 6,
    180, 156, 217, 85, 174, 201, 255, 237, 85, 83, 53, 188, 153, 98, 91, 193,
    21, 211, 49, 145, 196, 252, 52, 66, 226, 131, 203, 214, 130, 237, 194, 208,
    174, 102, 133, 220, 235, 222, 79, 232, 36, 21, 161, 248, 51, 185, 164, 156,
    95, 121, 65, 57, 233, 183, 29, 199, 105, 104, 12, 90, 195, 186, 81, 199,
    176, 1, 87, 16, 226, 192, 206, 185, 197, 46, 34, 75, 174, 153, 238, 15, 50,
    87, 226, 96, 26, 197, 202, 73, 235, 19, 140, 9, 79, 12, 52, 83, 76, 85, 146,
    234, 24, 151, 179, 178, 118, 58, 162, 223, 103, 69, 244, 231, 135, 167, 204,
    117, 166, 60, 237, 82, 63, 11, 4, 207, 10, 146, 54, 126, 191, 79, 133, 60,
    128, 34, 136, 170, 23, 84, 81, 38, 94, 9, 130, 245, 100, 115, 209, 34, 228,
    158, 101, 216, 135, 208, 207, 191, 169, 115, 252, 144, 139, 226, 252, 6, 44,
    221, 134, 170, 87, 11, 46, 124, 58, 219, 179, 238, 6, 98, 216, 18, 174, 42,
    12, 97, 126, 85, 245, 81, 220, 232, 135, 114, 21, 125, 135, 225, 182, 245,
    228, 223, 242, 62, 158, 35, 76, 6, 110, 25, 184, 206, 124, 237, 54, 252,
    199, 44, 78, 89, 0, 135, 44, 176, 57, 168, 36, 221, 173, 77, 214, 209, 60,
    1, 202, 238, 237, 61, 90, 47, 114, 230, 92, 238, 235, 18, 151, 220, 243,
    225, 163, 159, 139, 189, 253, 62, 225, 182, 202, 59, 7, 83, 99, 129, 118,
    175, 37, 246, 85, 119, 251, 246, 69, 180, 247, 37, 24, 194, 89, 158, 97,
    230, 247, 254, 145, 102, 89, 77, 68, 245, 3, 103, 83, 28, 45, 168, 30, 189,
    151, 112, 120, 215, 84, 90, 198, 85, 85, 129, 55, 127, 124, 28, 137, 229,
    139, 54, 88, 229, 105, 81, 212, 83, 28, 107, 250, 82, 164, 43, 24, 15, 57,
    206, 156, 19, 145, 95, 57, 169, 8, 128, 211, 29, 213, 195, 148, 27, 73, 186,
    221, 242, 11, 167, 78, 246, 133, 18, 118, 67, 236, 59, 19, 112, 254, 93,
    168, 157, 118, 0, 107, 248, 57, 149, 67, 222, 123, 225, 207, 251, 69, 218,
    56, 110, 162, 19, 25, 209, 209, 213, 200, 158, 70, 9, 100, 208, 77, 48, 255,
    151, 200, 0, 68, 230, 70, 120, 209, 29, 86, 225, 188, 189, 226, 101, 42,
    176, 32, 147, 121, 72, 151, 130, 217, 13, 66, 148, 84, 129, 215, 249, 164,
    174, 187, 80, 85, 185, 245, 108, 169, 119, 59, 178, 144, 229, 63, 194, 132,
    250, 131, 82, 161, 125, 126, 255, 252, 220, 204, 104, 231, 201, 136, 246,
    116, 43, 88, 233, 0, 43, 128, 214, 40, 59, 81, 147, 139, 132, 69, 24, 233,
    21, 14, 91, 230, 241, 19, 138, 163, 55, 13, 221, 47, 64, 140, 248, 6, 38,
    164, 16, 219, 63, 33, 180, 71, 151, 0, 234, 103, 58, 213, 222, 163, 95, 132,
    1, 178, 146, 66, 124, 242, 223, 102, 129, 192, 214, 194, 117, 162, 252, 246,
    143, 42, 70, 139, 97, 168, 64, 141, 190, 115, 126, 93, 175, 59, 49, 9, 184,
    88, 201, 100, 182, 142, 145, 244, 72, 128, 203, 49, 196, 5, 5, 18, 46, 34,
    87, 171, 132, 158, 128, 75, 194, 8, 242, 52, 156, 229, 245, 56, 245, 88, 14,
    195, 110, 166, 51, 158, 245, 195, 120, 17, 166, 66, 100, 212, 188, 243, 2,
    236, 90, 8, 16, 35, 151, 122, 175, 115, 168, 186, 191, 60, 71, 23, 81, 217,
    79, 203, 239, 61, 146, 247, 168, 112, 83, 102, 146, 222, 178, 45, 247, 63,
    23, 181, 3, 136, 208, 62, 154, 203, 35, 250, 238, 61, 98, 207, 90, 169, 175,
    36, 227, 9, 182, 78, 226, 99, 89, 67, 105, 185, 35, 242, 162, 54, 99, 60,
    148, 14, 118, 1, 26, 120, 62, 82, 62, 222, 34, 99, 58, 174, 145, 199, 190,
    21, 182, 117, 238, 13, 170, 29, 67, 149, 44, 90, 94, 181, 125, 182, 186, 82,
    55, 105, 253, 29, 212, 67, 134, 204, 227, 94, 255, 127, 72, 157, 140, 142,
    224, 77, 149, 29, 170, 45, 163, 214, 209, 46, 28, 125, 177, 111, 2, 92, 121,
    252, 166, 204, 227, 173, 51, 60, 162, 243, 202, 207, 103, 30, 153, 182, 116,
    182, 130, 98, 59, 25, 141, 239, 49, 224, 176, 27, 237, 218, 76, 68, 189,
    108, 185, 136, 255, 105, 150, 11, 153, 44, 248, 139, 199, 178, 235, 85, 115,
    121, 144, 87, 221, 50, 222, 238, 16, 20, 51, 190, 93, 248, 228, 84, 228,
    115, 31, 229, 227, 137, 180, 44, 115, 224, 119, 129, 181, 134, 224, 144,
    186, 123, 208, 118, 96, 101, 177, 191, 232, 171, 6, 17, 247, 187, 173, 84,
    70, 249, 19, 191, 116, 172, 126, 131, 216, 123, 225, 151, 55, 205, 177, 93,
    139, 117,
  ]),
};

// Test message to sign (same for all variants)
var data = new Uint8Array([
  77, 76, 45, 68, 83, 65, 32, 116, 101, 115, 116, 32, 109, 101, 115, 115, 97,
  103, 101, 32, 102, 111, 114, 32, 115, 105, 103, 110, 105, 110, 103, 32, 97,
  110, 100, 32, 118, 101, 114, 105, 102, 105, 99, 97, 116, 105, 111, 110, 46,
  32, 84, 104, 105, 115, 32, 105, 115, 32, 97, 32, 116, 101, 115, 116, 32, 111,
  102, 32, 77, 76, 45, 68, 83, 65, 32, 105, 109, 112, 108, 101, 109, 101, 110,
  116, 97, 116, 105, 111, 110, 46,
]);

// Valid signatures for each ML-DSA variant
var signatures = {
  'ML-DSA-44': new Uint8Array([
    56, 160, 238, 165, 206, 185, 253, 250, 240, 49, 157, 80, 171, 182, 48, 254,
    218, 228, 93, 60, 65, 196, 177, 207, 50, 102, 195, 4, 191, 17, 173, 83, 203,
    142, 171, 138, 160, 201, 238, 150, 63, 111, 25, 245, 225, 122, 188, 84, 238,
    168, 92, 57, 117, 107, 112, 29, 123, 67, 78, 233, 105, 13, 11, 47, 93, 61,
    45, 70, 114, 151, 243, 126, 161, 158, 141, 176, 129, 144, 12, 210, 152, 217,
    28, 215, 47, 209, 244, 167, 31, 250, 156, 31, 191, 64, 102, 143, 189, 136,
    59, 11, 17, 34, 234, 157, 22, 171, 24, 192, 201, 119, 220, 121, 143, 236,
    72, 17, 170, 191, 172, 242, 140, 71, 202, 22, 53, 161, 156, 208, 89, 51, 54,
    0, 151, 192, 2, 176, 115, 128, 0, 172, 70, 141, 151, 88, 122, 85, 217, 107,
    2, 217, 0, 97, 191, 156, 170, 9, 53, 108, 111, 62, 157, 28, 69, 80, 71, 221,
    83, 194, 182, 184, 70, 91, 50, 149, 50, 86, 111, 150, 195, 66, 68, 151, 6,
    208, 88, 203, 135, 215, 231, 208, 61, 54, 112, 56, 69, 221, 154, 60, 62, 71,
    45, 225, 68, 91, 60, 104, 185, 182, 39, 59, 199, 247, 170, 117, 227, 100,
    92, 85, 42, 173, 238, 34, 115, 146, 20, 248, 174, 107, 164, 32, 73, 22, 175,
    215, 106, 122, 164, 134, 66, 65, 227, 83, 93, 68, 211, 184, 167, 6, 109,
    236, 160, 183, 231, 4, 135, 77, 72, 163, 40, 175, 105, 95, 205, 120, 112,
    169, 182, 4, 176, 149, 178, 72, 75, 116, 214, 198, 225, 230, 238, 63, 96,
    60, 94, 169, 222, 116, 64, 31, 95, 34, 198, 106, 182, 27, 71, 57, 80, 46,
    18, 52, 52, 55, 113, 28, 128, 191, 176, 149, 86, 143, 9, 197, 15, 39, 180,
    227, 47, 133, 211, 220, 77, 186, 247, 26, 114, 42, 177, 190, 192, 57, 60,
    69, 54, 60, 179, 174, 1, 39, 63, 247, 50, 235, 29, 188, 254, 84, 215, 116,
    231, 94, 79, 200, 50, 215, 38, 41, 10, 211, 5, 197, 136, 147, 177, 159, 104,
    52, 49, 162, 178, 232, 30, 240, 24, 39, 160, 210, 193, 137, 65, 217, 255,
    57, 196, 118, 103, 74, 121, 161, 219, 84, 64, 123, 4, 229, 206, 231, 41, 2,
    168, 159, 64, 69, 115, 2, 61, 1, 211, 129, 236, 115, 186, 236, 163, 28, 206,
    11, 106, 189, 70, 137, 152, 13, 42, 116, 11, 235, 1, 99, 177, 135, 240, 141,
    27, 254, 143, 107, 84, 37, 49, 31, 205, 181, 208, 65, 149, 37, 132, 176, 7,
    235, 209, 228, 206, 190, 145, 166, 81, 106, 99, 88, 8, 190, 66, 167, 217,
    45, 177, 185, 135, 24, 89, 235, 164, 38, 100, 111, 85, 178, 135, 27, 15, 9,
    100, 34, 112, 39, 219, 211, 175, 69, 93, 157, 138, 74, 219, 13, 171, 207,
    152, 144, 175, 43, 174, 38, 88, 51, 114, 10, 235, 79, 233, 230, 4, 5, 143,
    44, 214, 216, 194, 6, 97, 184, 183, 219, 207, 249, 178, 106, 91, 60, 201,
    126, 134, 244, 128, 231, 29, 203, 16, 48, 61, 133, 101, 133, 2, 39, 155,
    142, 66, 148, 106, 61, 117, 114, 184, 136, 214, 191, 44, 227, 122, 163, 157,
    88, 50, 236, 206, 81, 225, 204, 89, 88, 77, 78, 148, 56, 255, 13, 8, 118,
    185, 155, 214, 233, 179, 236, 159, 207, 19, 254, 98, 176, 193, 204, 71, 191,
    100, 102, 56, 95, 79, 139, 84, 13, 77, 70, 0, 13, 52, 13, 210, 15, 6, 44,
    37, 176, 61, 39, 131, 65, 14, 157, 106, 214, 57, 62, 139, 142, 32, 210, 198,
    156, 241, 74, 38, 103, 179, 34, 92, 46, 21, 160, 222, 133, 47, 239, 240,
    198, 5, 142, 47, 29, 247, 206, 160, 47, 250, 161, 102, 244, 240, 184, 201,
    224, 52, 53, 51, 151, 175, 5, 175, 211, 148, 236, 27, 59, 224, 219, 168,
    229, 117, 67, 198, 14, 43, 106, 37, 161, 179, 41, 59, 161, 145, 159, 189,
    196, 74, 148, 124, 116, 254, 191, 149, 16, 139, 118, 240, 8, 144, 88, 28,
    215, 14, 191, 219, 6, 158, 165, 245, 174, 237, 7, 239, 177, 182, 58, 175,
    180, 142, 143, 40, 169, 57, 193, 78, 66, 89, 214, 222, 2, 6, 59, 162, 30,
    149, 255, 13, 169, 203, 192, 122, 16, 33, 174, 170, 143, 146, 53, 58, 28, 3,
    156, 18, 79, 185, 148, 41, 106, 59, 228, 137, 10, 232, 169, 135, 234, 248,
    16, 163, 74, 103, 112, 95, 101, 55, 207, 152, 155, 48, 92, 59, 115, 116, 99,
    174, 67, 57, 161, 166, 60, 235, 179, 209, 216, 50, 84, 177, 173, 53, 210,
    119, 230, 235, 56, 99, 64, 135, 245, 137, 37, 146, 140, 64, 160, 141, 120,
    114, 104, 160, 253, 204, 153, 47, 139, 235, 166, 66, 87, 181, 80, 1, 250,
    130, 216, 159, 143, 79, 192, 146, 222, 243, 238, 208, 163, 190, 124, 218,
    214, 59, 37, 219, 73, 141, 224, 194, 209, 148, 205, 143, 15, 42, 47, 232,
    132, 34, 200, 79, 88, 164, 203, 70, 41, 64, 250, 18, 4, 182, 139, 73, 27,
    160, 122, 132, 39, 193, 100, 79, 28, 249, 92, 139, 50, 67, 194, 128, 83, 74,
    231, 194, 75, 118, 98, 18, 47, 36, 4, 110, 250, 132, 130, 175, 136, 110,
    226, 168, 20, 242, 63, 195, 175, 179, 144, 193, 3, 62, 126, 85, 196, 69,
    137, 228, 66, 57, 20, 56, 149, 22, 38, 247, 243, 56, 87, 207, 86, 253, 21,
    227, 88, 122, 119, 52, 85, 93, 205, 112, 214, 158, 19, 246, 218, 127, 225,
    244, 159, 99, 140, 248, 123, 36, 243, 48, 138, 151, 47, 237, 24, 188, 73,
    227, 180, 190, 122, 26, 169, 65, 136, 195, 175, 168, 212, 136, 51, 47, 81,
    9, 182, 57, 62, 244, 180, 182, 102, 2, 84, 111, 208, 53, 21, 178, 121, 89,
    237, 52, 85, 231, 167, 174, 201, 0, 181, 204, 97, 70, 200, 18, 19, 149, 213,
    254, 194, 142, 224, 253, 127, 18, 119, 68, 51, 216, 201, 227, 111, 85, 254,
    216, 207, 217, 61, 88, 148, 108, 139, 14, 226, 158, 194, 155, 118, 76, 108,
    222, 30, 26, 166, 167, 119, 65, 16, 44, 110, 11, 24, 40, 222, 190, 89, 37,
    109, 221, 152, 185, 115, 155, 175, 13, 212, 17, 12, 220, 142, 72, 206, 17,
    166, 222, 253, 146, 107, 253, 163, 34, 230, 72, 218, 42, 166, 114, 72, 230,
    22, 33, 73, 58, 51, 212, 125, 219, 137, 1, 91, 222, 156, 88, 58, 66, 127,
    204, 187, 117, 5, 107, 77, 18, 207, 35, 202, 100, 196, 247, 37, 212, 195,
    16, 243, 121, 71, 153, 5, 138, 103, 99, 82, 145, 175, 181, 44, 215, 145, 97,
    100, 252, 172, 100, 0, 237, 222, 182, 88, 242, 187, 100, 174, 32, 141, 213,
    176, 227, 39, 94, 10, 186, 33, 46, 176, 141, 218, 189, 94, 33, 74, 111, 178,
    215, 97, 117, 31, 231, 206, 31, 97, 187, 241, 77, 19, 100, 222, 237, 130,
    232, 33, 43, 3, 195, 36, 65, 7, 197, 104, 0, 119, 2, 30, 191, 253, 21, 175,
    33, 139, 109, 88, 196, 131, 84, 241, 22, 6, 112, 41, 133, 144, 241, 228,
    213, 209, 173, 18, 154, 2, 49, 23, 156, 167, 43, 206, 249, 37, 134, 14, 153,
    105, 177, 39, 88, 12, 107, 104, 249, 223, 2, 205, 217, 208, 120, 236, 241,
    185, 101, 29, 112, 22, 115, 165, 197, 55, 245, 191, 164, 22, 55, 18, 216,
    81, 200, 11, 248, 187, 143, 117, 27, 2, 162, 143, 133, 202, 173, 149, 33,
    99, 14, 206, 97, 165, 89, 41, 240, 203, 176, 168, 95, 246, 72, 224, 38, 197,
    139, 66, 26, 32, 187, 17, 1, 229, 125, 173, 64, 89, 14, 23, 5, 212, 141, 40,
    151, 107, 52, 231, 10, 81, 12, 1, 190, 243, 14, 142, 38, 238, 161, 144, 188,
    65, 245, 98, 156, 148, 125, 247, 145, 193, 87, 249, 156, 185, 240, 4, 184,
    109, 190, 5, 151, 1, 165, 198, 123, 246, 235, 175, 75, 208, 255, 38, 123,
    114, 43, 246, 87, 19, 197, 246, 50, 163, 81, 63, 90, 206, 203, 244, 47, 164,
    221, 233, 71, 123, 74, 222, 92, 78, 238, 43, 120, 98, 186, 73, 187, 223,
    153, 236, 58, 78, 86, 124, 88, 241, 250, 31, 239, 46, 243, 48, 52, 65, 204,
    13, 127, 157, 117, 235, 209, 172, 242, 96, 123, 144, 113, 213, 132, 27, 168,
    77, 104, 73, 86, 210, 14, 100, 66, 21, 189, 57, 120, 217, 33, 250, 100, 246,
    178, 34, 43, 219, 87, 122, 180, 31, 205, 19, 195, 51, 239, 57, 74, 43, 171,
    151, 227, 41, 90, 238, 89, 187, 253, 96, 154, 136, 221, 114, 36, 55, 60,
    137, 189, 209, 195, 195, 3, 123, 130, 34, 4, 122, 38, 233, 114, 155, 30, 15,
    94, 59, 53, 2, 21, 47, 28, 0, 12, 201, 166, 10, 71, 98, 125, 57, 241, 138,
    64, 127, 125, 146, 226, 225, 241, 66, 59, 148, 129, 237, 226, 31, 209, 175,
    182, 63, 33, 180, 193, 143, 238, 217, 140, 49, 200, 209, 139, 250, 236, 231,
    235, 59, 92, 248, 67, 161, 93, 58, 202, 40, 148, 229, 215, 197, 126, 147, 9,
    83, 250, 75, 134, 199, 13, 255, 23, 184, 167, 181, 7, 99, 220, 154, 54, 225,
    199, 214, 27, 254, 154, 61, 170, 134, 238, 227, 193, 229, 18, 26, 100, 61,
    159, 157, 96, 14, 13, 140, 254, 79, 109, 113, 208, 137, 155, 71, 157, 169,
    130, 106, 138, 8, 171, 116, 77, 205, 102, 164, 250, 99, 139, 56, 50, 84, 29,
    176, 171, 214, 205, 44, 156, 144, 7, 236, 167, 182, 223, 134, 64, 101, 212,
    38, 97, 62, 122, 237, 193, 189, 253, 57, 98, 211, 239, 213, 151, 181, 141,
    98, 218, 64, 114, 87, 148, 158, 94, 254, 247, 167, 193, 193, 156, 35, 69,
    215, 39, 141, 93, 102, 57, 48, 209, 216, 59, 158, 159, 1, 167, 77, 100, 170,
    194, 145, 175, 192, 81, 72, 202, 94, 131, 5, 98, 252, 162, 35, 110, 62, 226,
    154, 48, 230, 118, 247, 79, 38, 96, 87, 151, 24, 6, 244, 139, 29, 5, 162,
    227, 214, 92, 200, 12, 145, 236, 182, 198, 167, 75, 230, 187, 99, 188, 57,
    17, 194, 212, 82, 16, 46, 79, 111, 45, 246, 132, 243, 17, 32, 158, 38, 78,
    218, 225, 115, 64, 213, 201, 185, 191, 153, 32, 124, 42, 71, 121, 150, 56,
    234, 152, 81, 251, 85, 213, 232, 127, 141, 249, 68, 242, 100, 115, 247, 155,
    203, 123, 0, 76, 194, 25, 104, 79, 76, 31, 3, 24, 185, 24, 14, 223, 20, 155,
    135, 236, 101, 208, 111, 105, 79, 134, 115, 13, 144, 161, 74, 109, 163, 47,
    24, 239, 230, 155, 54, 232, 249, 127, 243, 104, 193, 34, 239, 94, 200, 182,
    229, 213, 10, 153, 173, 8, 175, 17, 219, 6, 130, 72, 229, 116, 250, 250, 49,
    2, 77, 119, 63, 87, 147, 74, 73, 93, 33, 233, 231, 250, 22, 188, 172, 73,
    148, 90, 125, 155, 126, 243, 93, 227, 209, 99, 222, 134, 100, 99, 27, 179,
    195, 130, 138, 8, 146, 66, 224, 129, 163, 238, 235, 48, 229, 88, 112, 155,
    83, 88, 253, 121, 42, 249, 31, 217, 81, 9, 226, 202, 101, 232, 123, 88, 136,
    214, 215, 63, 36, 158, 110, 171, 22, 234, 217, 125, 85, 169, 25, 21, 242,
    12, 140, 55, 130, 40, 61, 8, 117, 64, 95, 196, 157, 190, 38, 218, 156, 38,
    221, 134, 223, 206, 156, 13, 100, 70, 181, 247, 15, 186, 251, 42, 234, 217,
    191, 159, 55, 184, 251, 179, 240, 77, 192, 42, 104, 208, 246, 155, 56, 45,
    82, 180, 187, 138, 67, 216, 18, 180, 189, 116, 111, 232, 95, 202, 153, 79,
    210, 171, 0, 230, 192, 126, 41, 117, 218, 182, 190, 17, 225, 71, 133, 161,
    7, 108, 24, 63, 188, 80, 248, 225, 193, 22, 173, 60, 214, 141, 182, 185,
    140, 73, 94, 184, 143, 113, 99, 65, 100, 232, 6, 34, 124, 243, 130, 68, 183,
    202, 183, 80, 170, 243, 70, 59, 14, 21, 58, 137, 35, 154, 223, 0, 103, 86,
    141, 137, 128, 117, 57, 110, 253, 254, 3, 113, 199, 159, 64, 56, 239, 196,
    78, 45, 202, 25, 189, 249, 234, 253, 217, 132, 23, 139, 116, 98, 236, 16,
    225, 9, 216, 118, 188, 62, 244, 171, 34, 253, 138, 209, 210, 249, 249, 77,
    252, 144, 214, 3, 72, 66, 30, 196, 39, 99, 241, 236, 136, 73, 167, 250, 110,
    215, 217, 204, 140, 97, 247, 161, 176, 59, 45, 117, 39, 236, 80, 137, 194,
    220, 52, 95, 159, 46, 18, 3, 173, 138, 196, 246, 112, 84, 118, 186, 112,
    219, 108, 241, 83, 63, 103, 58, 213, 209, 254, 31, 107, 197, 48, 53, 30, 65,
    247, 71, 19, 94, 125, 169, 101, 139, 223, 219, 113, 58, 221, 168, 110, 82,
    129, 67, 41, 192, 14, 206, 24, 110, 83, 176, 90, 6, 114, 126, 55, 236, 76,
    250, 160, 249, 92, 155, 70, 186, 228, 8, 118, 144, 232, 217, 66, 189, 33,
    93, 39, 210, 57, 235, 240, 165, 72, 220, 235, 210, 107, 158, 106, 188, 102,
    197, 55, 137, 84, 159, 1, 148, 116, 19, 127, 70, 166, 193, 33, 202, 106,
    198, 233, 217, 101, 195, 196, 144, 23, 249, 8, 94, 159, 134, 167, 184, 124,
    115, 9, 144, 47, 134, 218, 99, 211, 162, 233, 188, 37, 31, 34, 25, 74, 80,
    81, 85, 107, 119, 132, 133, 141, 150, 160, 163, 167, 178, 199, 209, 212, 32,
    67, 99, 101, 109, 112, 113, 123, 142, 151, 184, 203, 205, 223, 253, 29, 31,
    35, 42, 62, 71, 75, 90, 104, 136, 138, 149, 159, 160, 171, 189, 191, 192,
    204, 217, 237, 241, 23, 29, 41, 97, 139, 148, 170, 218, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 33, 55, 63,
  ]),
  'ML-DSA-65': new Uint8Array([
    146, 96, 54, 223, 241, 155, 153, 151, 60, 82, 43, 87, 39, 239, 17, 188, 251,
    35, 188, 126, 12, 147, 179, 10, 16, 161, 49, 80, 163, 83, 247, 170, 233,
    144, 246, 62, 148, 223, 26, 93, 247, 10, 196, 20, 117, 164, 163, 35, 96,
    109, 94, 75, 5, 50, 194, 191, 246, 236, 104, 37, 180, 68, 36, 143, 106, 100,
    51, 246, 20, 35, 151, 3, 120, 165, 249, 93, 119, 239, 14, 184, 124, 170, 24,
    41, 81, 240, 137, 17, 54, 155, 146, 136, 185, 137, 70, 81, 148, 10, 252,
    219, 177, 211, 152, 5, 192, 52, 59, 169, 69, 199, 203, 2, 145, 24, 252, 66,
    121, 217, 76, 202, 225, 112, 242, 78, 31, 218, 166, 162, 57, 156, 200, 5,
    10, 24, 72, 179, 142, 134, 31, 203, 187, 171, 141, 226, 230, 62, 217, 29,
    98, 134, 77, 30, 45, 228, 120, 98, 25, 157, 216, 253, 132, 12, 183, 224,
    131, 234, 170, 71, 204, 163, 200, 145, 12, 150, 215, 66, 240, 114, 45, 188,
    161, 39, 242, 151, 1, 76, 128, 115, 174, 90, 160, 11, 52, 133, 186, 124, 4,
    157, 195, 96, 213, 102, 69, 84, 194, 211, 80, 60, 42, 193, 51, 151, 224, 36,
    33, 59, 180, 139, 218, 28, 145, 51, 114, 91, 236, 18, 125, 82, 23, 252, 130,
    3, 127, 35, 17, 44, 160, 60, 84, 5, 20, 186, 178, 5, 95, 41, 177, 14, 128,
    251, 210, 228, 211, 46, 157, 190, 13, 50, 188, 8, 128, 222, 146, 33, 181,
    39, 83, 62, 29, 8, 233, 196, 73, 44, 237, 157, 8, 48, 67, 2, 209, 65, 38,
    138, 143, 149, 52, 11, 236, 179, 250, 6, 182, 125, 218, 133, 127, 72, 107,
    46, 158, 155, 112, 147, 253, 24, 202, 2, 226, 140, 32, 153, 179, 80, 46,
    175, 23, 17, 138, 12, 226, 251, 153, 122, 232, 68, 142, 1, 154, 112, 64, 26,
    62, 35, 172, 240, 250, 70, 111, 192, 3, 69, 205, 148, 184, 193, 90, 106, 8,
    151, 169, 178, 83, 251, 173, 72, 62, 38, 102, 126, 64, 104, 39, 241, 96,
    180, 123, 141, 115, 228, 0, 39, 6, 73, 249, 26, 30, 177, 152, 194, 201, 83,
    85, 211, 184, 211, 120, 167, 169, 17, 65, 67, 158, 202, 183, 112, 232, 163,
    184, 205, 115, 164, 117, 93, 176, 138, 74, 167, 162, 135, 199, 113, 225,
    104, 38, 31, 240, 177, 11, 88, 120, 45, 225, 88, 199, 4, 193, 164, 252, 212,
    172, 142, 248, 43, 130, 113, 134, 6, 6, 149, 65, 148, 58, 25, 128, 179, 25,
    234, 107, 28, 199, 84, 157, 100, 143, 8, 164, 146, 220, 252, 251, 101, 251,
    226, 117, 179, 241, 212, 108, 98, 175, 52, 23, 103, 222, 23, 213, 114, 235,
    17, 177, 239, 228, 60, 252, 176, 29, 47, 239, 255, 52, 200, 223, 213, 152,
    214, 165, 213, 123, 103, 11, 54, 49, 183, 8, 65, 57, 103, 226, 67, 46, 198,
    233, 45, 47, 188, 38, 45, 93, 64, 50, 142, 125, 83, 156, 210, 101, 74, 31,
    184, 74, 167, 158, 84, 128, 28, 187, 159, 110, 162, 120, 82, 209, 16, 141,
    175, 175, 241, 228, 30, 166, 200, 140, 105, 192, 36, 168, 126, 203, 174,
    251, 161, 176, 30, 146, 108, 98, 197, 33, 43, 169, 176, 86, 196, 172, 3,
    214, 104, 189, 241, 66, 95, 12, 237, 155, 224, 114, 95, 12, 22, 48, 4, 149,
    37, 231, 209, 171, 45, 248, 229, 222, 187, 243, 253, 170, 200, 8, 189, 127,
    69, 31, 141, 243, 15, 148, 102, 150, 187, 95, 111, 4, 115, 110, 196, 41,
    247, 116, 153, 171, 133, 227, 80, 132, 166, 66, 42, 96, 168, 120, 46, 157,
    179, 90, 72, 16, 216, 52, 174, 255, 232, 16, 59, 128, 202, 73, 217, 37, 28,
    18, 121, 214, 53, 139, 121, 236, 238, 186, 151, 68, 156, 191, 106, 146, 222,
    62, 94, 38, 11, 177, 243, 64, 206, 69, 142, 189, 10, 15, 39, 59, 104, 83,
    174, 114, 138, 94, 180, 203, 220, 87, 93, 71, 239, 164, 131, 144, 83, 62,
    143, 71, 115, 56, 76, 174, 1, 111, 43, 8, 151, 52, 236, 64, 69, 150, 170,
    189, 209, 221, 173, 211, 34, 74, 62, 18, 33, 219, 10, 215, 139, 154, 147,
    185, 221, 250, 225, 76, 42, 104, 125, 130, 55, 189, 136, 76, 92, 49, 233, 8,
    89, 88, 36, 33, 168, 154, 94, 172, 155, 1, 246, 65, 85, 87, 95, 109, 87,
    190, 237, 3, 146, 227, 59, 213, 62, 102, 208, 85, 73, 224, 37, 225, 59, 33,
    178, 18, 107, 66, 53, 75, 250, 166, 242, 56, 46, 92, 201, 1, 153, 88, 167,
    100, 86, 27, 89, 46, 240, 74, 60, 78, 121, 48, 186, 8, 218, 77, 215, 111,
    101, 227, 83, 144, 197, 253, 232, 173, 30, 113, 165, 188, 65, 221, 177, 105,
    41, 160, 186, 177, 193, 128, 106, 91, 25, 59, 114, 213, 110, 103, 140, 79,
    166, 55, 32, 128, 142, 214, 196, 80, 162, 113, 147, 250, 188, 184, 107, 153,
    16, 94, 3, 175, 214, 101, 88, 149, 166, 135, 11, 4, 91, 11, 78, 77, 196, 97,
    248, 218, 70, 71, 118, 78, 47, 253, 143, 113, 123, 255, 77, 122, 219, 153,
    181, 125, 168, 220, 187, 212, 204, 28, 93, 60, 1, 41, 170, 118, 40, 60, 173,
    210, 136, 189, 190, 61, 252, 168, 140, 93, 132, 97, 22, 82, 63, 86, 217,
    168, 116, 37, 57, 128, 12, 218, 228, 22, 176, 59, 152, 8, 11, 72, 185, 149,
    17, 58, 252, 160, 158, 178, 252, 195, 191, 107, 208, 130, 52, 234, 232, 180,
    208, 99, 247, 86, 12, 179, 106, 244, 60, 92, 193, 111, 35, 81, 47, 117, 201,
    34, 254, 108, 165, 121, 235, 201, 118, 139, 241, 252, 110, 158, 91, 212,
    177, 41, 49, 73, 168, 30, 143, 92, 60, 185, 46, 241, 219, 107, 144, 104,
    168, 132, 31, 0, 125, 71, 124, 213, 159, 66, 38, 7, 111, 140, 115, 222, 145,
    208, 201, 173, 152, 126, 177, 122, 119, 223, 209, 40, 172, 219, 105, 239,
    127, 60, 135, 147, 24, 96, 84, 90, 10, 152, 201, 229, 198, 90, 223, 85, 1,
    36, 52, 114, 48, 240, 231, 148, 34, 183, 98, 149, 148, 171, 231, 101, 235,
    245, 22, 87, 107, 254, 252, 42, 41, 159, 147, 20, 174, 84, 121, 197, 42, 47,
    25, 219, 122, 36, 251, 46, 197, 240, 31, 120, 20, 115, 226, 31, 186, 163,
    133, 216, 9, 204, 144, 7, 204, 85, 174, 24, 252, 181, 45, 223, 193, 22, 7,
    107, 201, 213, 115, 9, 208, 55, 180, 253, 185, 49, 11, 116, 252, 137, 133,
    127, 175, 163, 160, 80, 86, 86, 170, 210, 191, 157, 145, 61, 2, 232, 142,
    201, 6, 113, 29, 4, 30, 223, 248, 227, 231, 184, 129, 174, 213, 88, 192,
    127, 123, 152, 134, 168, 182, 91, 251, 221, 145, 212, 39, 56, 60, 253, 120,
    224, 151, 4, 194, 244, 149, 233, 75, 167, 166, 53, 115, 191, 172, 19, 142,
    174, 142, 77, 194, 153, 246, 140, 49, 162, 214, 119, 171, 123, 234, 180, 88,
    53, 254, 221, 98, 31, 24, 152, 161, 17, 32, 45, 11, 165, 237, 129, 16, 30,
    115, 238, 210, 53, 124, 111, 189, 28, 131, 172, 247, 251, 54, 98, 100, 43,
    32, 196, 26, 213, 145, 146, 200, 77, 255, 67, 180, 118, 118, 131, 154, 12,
    204, 39, 113, 22, 205, 163, 87, 10, 53, 7, 11, 148, 117, 201, 70, 193, 52,
    99, 194, 248, 73, 68, 140, 19, 88, 18, 17, 81, 22, 12, 56, 187, 151, 199,
    160, 30, 158, 36, 95, 136, 106, 121, 53, 40, 118, 254, 31, 46, 86, 25, 232,
    171, 119, 136, 183, 254, 69, 172, 169, 137, 255, 111, 97, 69, 140, 190, 38,
    243, 155, 228, 182, 74, 229, 228, 153, 238, 201, 156, 120, 139, 54, 207, 73,
    241, 179, 16, 117, 108, 168, 0, 205, 102, 144, 254, 120, 68, 142, 35, 140,
    203, 38, 202, 230, 0, 117, 177, 227, 180, 179, 72, 74, 133, 199, 148, 53,
    231, 221, 2, 58, 138, 130, 94, 5, 231, 5, 11, 239, 218, 27, 242, 28, 243,
    71, 211, 223, 118, 79, 158, 49, 99, 228, 199, 107, 178, 218, 195, 209, 142,
    123, 57, 208, 221, 31, 110, 106, 198, 211, 1, 141, 37, 20, 81, 155, 18, 234,
    241, 241, 239, 206, 57, 40, 119, 65, 39, 58, 41, 102, 181, 159, 108, 21, 55,
    42, 139, 116, 74, 194, 45, 190, 131, 119, 15, 80, 115, 53, 227, 11, 151,
    181, 242, 75, 35, 54, 214, 80, 167, 233, 109, 162, 122, 38, 18, 154, 202,
    217, 74, 95, 188, 167, 76, 144, 130, 160, 10, 243, 206, 31, 37, 205, 38, 71,
    229, 143, 176, 242, 44, 237, 93, 104, 187, 27, 86, 81, 4, 55, 91, 56, 17,
    32, 151, 25, 66, 75, 116, 146, 0, 140, 8, 36, 98, 240, 82, 33, 151, 121, 14,
    57, 62, 213, 252, 115, 59, 62, 189, 9, 115, 135, 124, 0, 191, 232, 236, 116,
    167, 65, 227, 106, 176, 205, 107, 42, 131, 41, 11, 17, 150, 28, 162, 194,
    174, 188, 22, 94, 42, 221, 30, 143, 41, 116, 214, 129, 7, 35, 25, 225, 225,
    167, 161, 112, 134, 139, 209, 213, 69, 66, 235, 72, 217, 140, 5, 165, 115,
    123, 201, 243, 157, 108, 61, 74, 239, 55, 52, 37, 16, 60, 215, 104, 192,
    253, 110, 47, 0, 23, 165, 120, 29, 183, 76, 144, 152, 213, 141, 130, 113,
    98, 121, 1, 182, 128, 116, 173, 53, 61, 59, 98, 207, 179, 35, 67, 228, 199,
    162, 151, 0, 195, 71, 90, 151, 193, 245, 54, 103, 103, 33, 154, 161, 188,
    201, 97, 106, 21, 76, 213, 111, 67, 120, 251, 114, 181, 15, 224, 96, 90, 1,
    108, 91, 189, 28, 254, 184, 246, 15, 48, 77, 207, 42, 104, 66, 23, 208, 135,
    240, 237, 135, 218, 196, 45, 96, 33, 9, 192, 237, 101, 181, 76, 190, 198,
    59, 135, 169, 88, 229, 30, 201, 231, 148, 219, 51, 100, 53, 97, 173, 178,
    67, 165, 159, 190, 86, 179, 247, 35, 97, 39, 69, 246, 93, 204, 170, 83, 33,
    196, 117, 166, 254, 194, 191, 66, 22, 241, 80, 136, 201, 83, 234, 198, 116,
    38, 180, 104, 15, 241, 94, 178, 158, 207, 105, 150, 249, 229, 38, 248, 162,
    227, 158, 228, 91, 11, 112, 224, 173, 152, 168, 60, 234, 138, 82, 231, 218,
    217, 46, 214, 74, 48, 9, 19, 153, 204, 83, 19, 168, 13, 24, 30, 225, 65,
    244, 98, 151, 118, 203, 110, 231, 233, 19, 153, 84, 65, 166, 148, 211, 213,
    241, 51, 112, 217, 158, 92, 126, 209, 168, 87, 12, 80, 62, 244, 91, 203,
    220, 199, 116, 241, 209, 251, 143, 184, 4, 126, 175, 1, 103, 24, 43, 175,
    157, 20, 10, 70, 19, 239, 159, 209, 33, 24, 75, 28, 227, 141, 133, 118, 13,
    170, 71, 81, 161, 238, 97, 79, 69, 49, 152, 203, 189, 2, 139, 213, 89, 119,
    124, 241, 110, 120, 19, 143, 246, 117, 164, 153, 49, 53, 63, 125, 75, 63,
    193, 238, 127, 231, 19, 107, 245, 1, 42, 86, 30, 139, 25, 149, 62, 230, 30,
    98, 48, 69, 96, 66, 153, 65, 162, 25, 41, 118, 196, 26, 211, 66, 193, 184,
    165, 221, 198, 95, 175, 42, 10, 132, 253, 59, 166, 208, 156, 59, 97, 110,
    15, 15, 173, 116, 42, 254, 151, 202, 209, 189, 60, 69, 167, 32, 233, 153, 4,
    139, 190, 92, 164, 164, 64, 149, 106, 70, 27, 233, 109, 50, 136, 62, 154, 5,
    214, 228, 132, 247, 187, 179, 34, 163, 65, 44, 30, 106, 4, 18, 72, 146, 19,
    83, 64, 68, 36, 122, 61, 140, 227, 82, 17, 228, 105, 105, 222, 52, 94, 132,
    8, 145, 132, 192, 185, 177, 172, 34, 153, 4, 98, 98, 42, 37, 189, 195, 71,
    185, 188, 203, 88, 232, 37, 106, 251, 104, 47, 211, 78, 193, 240, 73, 178,
    250, 226, 209, 98, 29, 225, 230, 201, 192, 185, 114, 82, 14, 81, 104, 79,
    226, 133, 248, 162, 150, 139, 149, 227, 79, 81, 74, 9, 197, 54, 124, 195,
    39, 63, 34, 195, 21, 205, 76, 91, 88, 174, 243, 178, 207, 86, 64, 178, 70,
    180, 5, 30, 134, 119, 188, 116, 38, 66, 227, 65, 174, 85, 251, 49, 103, 132,
    194, 23, 203, 207, 85, 28, 99, 8, 55, 246, 177, 63, 86, 186, 172, 171, 154,
    94, 177, 53, 159, 108, 8, 1, 108, 131, 147, 145, 126, 201, 50, 183, 89, 179,
    253, 235, 56, 93, 63, 82, 7, 45, 236, 57, 108, 185, 180, 136, 175, 64, 9,
    128, 173, 56, 125, 83, 55, 208, 179, 23, 114, 21, 71, 241, 128, 70, 92, 201,
    133, 50, 108, 15, 109, 254, 103, 44, 251, 65, 201, 199, 53, 207, 67, 93, 37,
    163, 189, 196, 106, 238, 4, 56, 246, 93, 22, 131, 190, 215, 81, 50, 71, 146,
    183, 200, 112, 157, 58, 229, 245, 138, 90, 117, 99, 209, 120, 55, 181, 79,
    141, 44, 226, 33, 164, 93, 206, 44, 101, 216, 175, 108, 191, 224, 54, 36,
    120, 112, 108, 226, 81, 178, 123, 219, 216, 135, 122, 191, 177, 207, 143,
    245, 99, 122, 135, 215, 154, 11, 80, 13, 128, 52, 92, 180, 113, 238, 64,
    156, 181, 47, 89, 111, 34, 135, 232, 1, 200, 253, 243, 250, 197, 199, 170,
    29, 244, 182, 0, 244, 211, 89, 248, 34, 26, 221, 161, 183, 228, 36, 51, 106,
    115, 162, 59, 3, 144, 150, 50, 125, 29, 250, 29, 167, 162, 106, 186, 195,
    236, 55, 240, 182, 4, 165, 167, 42, 204, 148, 192, 240, 5, 100, 154, 10,
    116, 158, 205, 187, 148, 162, 91, 207, 242, 245, 163, 160, 149, 169, 118,
    27, 125, 38, 16, 2, 152, 177, 235, 138, 105, 114, 119, 73, 189, 92, 146, 9,
    65, 206, 102, 246, 139, 113, 158, 56, 148, 191, 87, 59, 228, 126, 25, 245,
    63, 31, 131, 21, 4, 217, 170, 106, 127, 49, 48, 239, 72, 113, 22, 145, 87,
    129, 149, 79, 216, 72, 48, 8, 40, 133, 33, 109, 38, 142, 200, 91, 35, 246,
    27, 252, 230, 225, 152, 14, 117, 246, 198, 139, 56, 231, 47, 30, 44, 24,
    137, 224, 158, 72, 220, 34, 250, 17, 57, 23, 4, 226, 43, 139, 77, 209, 10,
    200, 38, 187, 141, 143, 235, 106, 44, 38, 107, 24, 235, 39, 183, 94, 186,
    54, 246, 242, 242, 207, 37, 200, 132, 62, 244, 76, 6, 112, 221, 160, 199,
    45, 65, 24, 74, 244, 135, 18, 76, 16, 172, 234, 72, 0, 119, 136, 28, 228,
    34, 134, 62, 143, 108, 86, 92, 238, 165, 250, 242, 153, 31, 253, 6, 92, 172,
    75, 199, 10, 5, 146, 115, 43, 237, 140, 191, 212, 155, 231, 35, 12, 190, 9,
    5, 224, 28, 204, 220, 233, 35, 57, 107, 140, 63, 108, 145, 193, 15, 252,
    134, 18, 20, 181, 97, 5, 241, 244, 165, 249, 176, 66, 187, 116, 233, 235,
    203, 51, 58, 28, 4, 58, 70, 137, 203, 143, 190, 247, 217, 236, 55, 32, 172,
    140, 70, 168, 209, 74, 102, 137, 76, 117, 130, 130, 70, 81, 196, 193, 230,
    143, 207, 24, 127, 109, 181, 226, 100, 135, 146, 118, 235, 251, 171, 211,
    54, 103, 47, 77, 238, 135, 230, 154, 151, 145, 96, 234, 169, 194, 178, 61,
    21, 103, 175, 112, 206, 164, 133, 19, 108, 150, 151, 54, 155, 116, 87, 243,
    75, 198, 140, 206, 28, 39, 238, 43, 211, 48, 51, 37, 191, 64, 190, 151, 122,
    229, 251, 62, 44, 81, 243, 217, 8, 188, 133, 24, 233, 78, 26, 121, 180, 40,
    245, 22, 183, 199, 183, 155, 63, 229, 37, 198, 124, 245, 42, 48, 64, 178,
    128, 109, 135, 152, 226, 86, 128, 244, 67, 192, 84, 211, 244, 134, 23, 166,
    49, 69, 104, 165, 152, 77, 34, 5, 50, 167, 104, 181, 153, 112, 229, 125,
    184, 212, 66, 218, 240, 59, 163, 105, 96, 26, 166, 103, 24, 201, 131, 66,
    21, 71, 44, 115, 241, 201, 210, 93, 190, 219, 30, 151, 100, 197, 2, 211, 81,
    73, 254, 132, 204, 51, 59, 156, 182, 147, 165, 159, 183, 127, 69, 9, 138,
    12, 152, 108, 220, 148, 183, 245, 157, 94, 68, 120, 122, 147, 94, 240, 186,
    201, 21, 161, 163, 58, 37, 251, 159, 219, 241, 191, 112, 76, 198, 100, 100,
    100, 20, 52, 198, 91, 10, 129, 139, 71, 78, 51, 2, 177, 234, 67, 13, 82,
    165, 236, 19, 148, 238, 42, 60, 128, 60, 231, 175, 142, 129, 89, 213, 180,
    3, 155, 50, 51, 65, 14, 210, 87, 109, 139, 80, 138, 239, 36, 129, 197, 23,
    106, 80, 202, 21, 218, 183, 48, 198, 46, 120, 63, 148, 144, 236, 135, 142,
    38, 125, 244, 42, 142, 187, 98, 140, 22, 129, 29, 110, 191, 223, 180, 36,
    71, 107, 155, 34, 228, 213, 158, 202, 193, 175, 95, 217, 150, 91, 57, 197,
    101, 118, 20, 79, 173, 233, 5, 115, 35, 96, 254, 185, 236, 57, 115, 93, 114,
    26, 215, 195, 4, 149, 100, 247, 226, 10, 92, 169, 105, 12, 219, 94, 26, 229,
    21, 169, 55, 103, 31, 7, 47, 18, 142, 223, 171, 176, 235, 142, 10, 197, 138,
    89, 211, 28, 127, 96, 111, 86, 121, 220, 77, 174, 84, 227, 86, 182, 159, 13,
    141, 205, 11, 35, 177, 163, 94, 234, 246, 156, 154, 56, 85, 185, 251, 181,
    49, 15, 212, 74, 94, 65, 178, 8, 12, 1, 179, 175, 138, 232, 151, 78, 84,
    168, 146, 195, 140, 128, 241, 110, 32, 197, 141, 162, 37, 117, 82, 93, 166,
    105, 9, 20, 69, 112, 85, 62, 63, 126, 244, 178, 127, 59, 51, 19, 222, 167,
    229, 203, 30, 46, 105, 10, 163, 90, 97, 140, 140, 224, 99, 37, 74, 98, 219,
    130, 61, 126, 68, 43, 153, 178, 78, 177, 91, 187, 46, 225, 220, 215, 175, 1,
    137, 217, 40, 205, 47, 163, 179, 98, 81, 46, 169, 194, 25, 34, 169, 33, 143,
    24, 120, 98, 149, 147, 7, 115, 20, 65, 230, 143, 249, 82, 140, 80, 37, 205,
    230, 239, 117, 34, 174, 55, 191, 131, 22, 213, 205, 112, 92, 168, 243, 131,
    110, 227, 218, 103, 194, 57, 156, 120, 252, 116, 233, 170, 75, 55, 148, 154,
    34, 89, 220, 101, 60, 195, 152, 252, 43, 170, 250, 119, 243, 21, 139, 195,
    173, 6, 78, 244, 195, 149, 73, 87, 239, 71, 117, 80, 24, 69, 33, 149, 59,
    207, 50, 38, 243, 99, 147, 243, 72, 113, 51, 86, 80, 150, 84, 230, 64, 236,
    122, 167, 84, 29, 219, 235, 59, 245, 148, 177, 68, 4, 120, 243, 32, 157,
    239, 194, 2, 255, 83, 0, 8, 23, 40, 101, 134, 137, 145, 169, 172, 179, 188,
    4, 94, 112, 169, 11, 26, 97, 114, 236, 239, 14, 32, 176, 178, 181, 186, 13,
    37, 87, 91, 120, 231, 10, 38, 91, 164, 173, 186, 187, 230, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 11, 15, 21, 27, 33, 41,
  ]),
  'ML-DSA-87': new Uint8Array([
    114, 160, 86, 137, 42, 198, 166, 136, 233, 153, 38, 105, 246, 197, 97, 186,
    174, 108, 5, 66, 156, 228, 140, 34, 160, 168, 237, 59, 225, 85, 25, 2, 166,
    159, 149, 14, 43, 42, 188, 97, 94, 94, 209, 66, 7, 67, 27, 106, 33, 26, 223,
    95, 136, 41, 37, 24, 76, 91, 73, 22, 74, 29, 71, 38, 136, 51, 11, 169, 162,
    187, 9, 166, 202, 84, 196, 51, 243, 233, 146, 71, 56, 9, 156, 20, 119, 182,
    187, 115, 228, 13, 237, 77, 99, 100, 219, 127, 64, 62, 149, 231, 36, 52, 77,
    48, 182, 182, 172, 173, 182, 8, 78, 174, 180, 50, 14, 246, 200, 12, 17, 9,
    165, 219, 139, 215, 126, 24, 104, 147, 92, 43, 204, 188, 233, 28, 7, 165,
    14, 173, 210, 184, 99, 196, 139, 226, 96, 120, 177, 156, 133, 151, 32, 112,
    198, 113, 87, 246, 190, 29, 253, 31, 66, 42, 78, 35, 96, 196, 213, 150, 22,
    109, 201, 27, 23, 65, 63, 93, 120, 204, 123, 229, 30, 205, 226, 35, 74, 176,
    21, 34, 225, 38, 63, 131, 159, 203, 76, 26, 113, 104, 72, 110, 181, 234,
    202, 154, 172, 168, 247, 97, 156, 224, 20, 236, 190, 106, 127, 56, 197, 66,
    236, 92, 92, 134, 150, 14, 218, 213, 214, 18, 237, 99, 102, 31, 133, 13,
    203, 63, 59, 157, 144, 182, 250, 105, 59, 48, 52, 146, 208, 100, 117, 220,
    81, 60, 106, 79, 10, 147, 163, 160, 193, 110, 154, 237, 81, 137, 202, 70,
    80, 102, 59, 34, 223, 150, 99, 112, 55, 233, 79, 8, 247, 246, 181, 175, 201,
    12, 253, 226, 30, 162, 233, 23, 124, 129, 150, 78, 52, 99, 228, 217, 33,
    251, 29, 45, 138, 207, 245, 51, 44, 246, 230, 149, 163, 131, 251, 118, 44,
    111, 53, 87, 20, 193, 65, 59, 118, 96, 96, 4, 33, 136, 136, 179, 248, 25,
    196, 224, 51, 190, 37, 155, 245, 151, 9, 45, 215, 160, 104, 38, 76, 19, 172,
    11, 167, 253, 249, 105, 7, 244, 13, 82, 91, 123, 93, 134, 247, 201, 78, 35,
    231, 130, 56, 171, 221, 138, 227, 40, 170, 56, 169, 200, 232, 8, 167, 168,
    66, 0, 241, 252, 48, 185, 0, 255, 230, 91, 124, 210, 247, 241, 225, 236, 37,
    130, 218, 21, 89, 100, 68, 142, 116, 253, 152, 178, 42, 207, 218, 147, 18,
    76, 193, 115, 102, 47, 59, 116, 110, 57, 15, 142, 176, 48, 144, 79, 10, 232,
    239, 128, 180, 202, 7, 182, 100, 106, 96, 81, 210, 154, 214, 171, 96, 132,
    103, 50, 48, 116, 217, 192, 159, 10, 45, 36, 22, 173, 225, 92, 43, 18, 4,
    122, 185, 137, 245, 175, 159, 125, 111, 196, 40, 201, 28, 185, 174, 227,
    132, 205, 81, 50, 205, 124, 55, 75, 150, 127, 250, 114, 68, 224, 65, 160,
    149, 171, 7, 130, 44, 179, 157, 13, 156, 35, 77, 68, 184, 204, 245, 219,
    203, 13, 47, 140, 171, 105, 202, 138, 131, 72, 226, 70, 98, 100, 247, 31,
    31, 68, 185, 40, 55, 0, 68, 42, 102, 111, 141, 179, 78, 207, 142, 149, 142,
    248, 191, 152, 7, 191, 180, 58, 147, 68, 158, 50, 131, 98, 17, 88, 128, 71,
    223, 145, 238, 177, 172, 61, 17, 45, 178, 232, 217, 161, 51, 197, 220, 196,
    57, 80, 2, 241, 197, 107, 113, 133, 176, 221, 68, 74, 25, 223, 24, 227, 112,
    135, 51, 56, 129, 223, 43, 53, 25, 226, 209, 243, 99, 208, 247, 193, 93, 52,
    173, 159, 253, 197, 2, 70, 43, 163, 116, 74, 40, 195, 98, 233, 34, 90, 90,
    232, 27, 39, 94, 191, 9, 16, 88, 194, 250, 75, 212, 63, 73, 216, 134, 35,
    126, 13, 120, 3, 193, 173, 61, 193, 185, 72, 67, 88, 67, 64, 167, 161, 43,
    144, 28, 80, 92, 193, 75, 246, 102, 200, 224, 71, 250, 195, 219, 110, 149,
    89, 169, 64, 9, 169, 109, 140, 132, 151, 5, 49, 231, 243, 167, 198, 11, 88,
    109, 97, 90, 144, 171, 124, 145, 122, 82, 108, 133, 4, 189, 205, 21, 218,
    110, 70, 199, 137, 241, 98, 243, 157, 124, 65, 216, 195, 40, 158, 41, 135,
    227, 12, 233, 182, 195, 8, 18, 245, 222, 176, 31, 63, 168, 246, 124, 253,
    83, 33, 185, 128, 125, 215, 130, 49, 228, 157, 126, 78, 142, 72, 150, 220,
    102, 153, 161, 38, 254, 169, 174, 191, 66, 59, 151, 28, 126, 86, 205, 71, 0,
    133, 87, 188, 172, 227, 147, 133, 100, 104, 111, 192, 97, 170, 6, 253, 37,
    121, 103, 251, 155, 86, 139, 127, 53, 72, 151, 172, 69, 231, 115, 153, 253,
    212, 13, 202, 120, 126, 110, 144, 130, 198, 190, 5, 151, 56, 161, 252, 235,
    48, 119, 188, 129, 157, 215, 82, 157, 254, 187, 180, 177, 138, 73, 153, 101,
    158, 102, 144, 170, 240, 248, 251, 77, 181, 227, 163, 60, 129, 249, 68, 235,
    70, 74, 117, 161, 231, 47, 123, 186, 84, 33, 139, 193, 120, 75, 63, 218, 4,
    194, 116, 0, 189, 29, 135, 104, 249, 196, 168, 102, 47, 143, 38, 25, 156,
    27, 250, 75, 3, 102, 38, 118, 180, 92, 172, 251, 200, 202, 42, 112, 154,
    105, 203, 133, 108, 170, 10, 23, 139, 205, 111, 124, 190, 44, 11, 197, 6,
    220, 121, 230, 71, 236, 77, 110, 133, 205, 140, 255, 246, 222, 195, 24, 188,
    66, 79, 142, 101, 195, 127, 40, 243, 26, 177, 253, 242, 32, 203, 166, 37,
    60, 32, 210, 71, 252, 103, 135, 99, 153, 126, 156, 131, 48, 132, 183, 85,
    130, 59, 165, 206, 5, 107, 77, 82, 129, 70, 166, 121, 165, 154, 196, 202,
    113, 216, 239, 176, 142, 62, 149, 87, 185, 162, 93, 179, 99, 71, 2, 81, 236,
    153, 235, 31, 185, 29, 215, 212, 46, 255, 245, 173, 223, 96, 107, 192, 75,
    197, 157, 206, 121, 32, 89, 11, 149, 7, 37, 57, 228, 76, 163, 104, 182, 196,
    189, 147, 59, 181, 149, 54, 23, 146, 131, 115, 168, 48, 197, 84, 33, 36,
    251, 41, 130, 61, 79, 154, 87, 181, 51, 208, 254, 220, 210, 82, 189, 63, 84,
    118, 191, 101, 246, 220, 219, 183, 127, 186, 2, 181, 24, 183, 97, 37, 50, 1,
    136, 233, 59, 183, 154, 44, 195, 139, 30, 76, 191, 218, 0, 116, 225, 92, 8,
    5, 193, 131, 74, 234, 5, 89, 186, 156, 8, 234, 112, 3, 233, 177, 191, 40,
    240, 204, 179, 8, 27, 55, 240, 12, 175, 176, 75, 65, 63, 94, 23, 44, 39,
    103, 115, 54, 244, 33, 20, 51, 114, 87, 129, 249, 107, 66, 170, 90, 242,
    207, 237, 62, 235, 60, 121, 98, 248, 145, 159, 171, 184, 175, 22, 42, 116,
    83, 207, 92, 178, 208, 138, 26, 102, 211, 102, 51, 184, 185, 175, 121, 26,
    40, 124, 83, 226, 89, 63, 156, 92, 118, 101, 75, 8, 87, 93, 237, 119, 76,
    167, 89, 111, 187, 211, 168, 243, 182, 158, 134, 5, 223, 140, 100, 67, 100,
    15, 244, 170, 38, 123, 155, 111, 166, 43, 184, 216, 83, 72, 177, 227, 246,
    204, 82, 141, 192, 169, 127, 87, 65, 43, 5, 163, 212, 39, 90, 122, 35, 106,
    181, 202, 122, 198, 255, 134, 209, 240, 254, 235, 255, 103, 14, 175, 189,
    184, 159, 180, 178, 36, 188, 123, 187, 224, 117, 22, 95, 162, 162, 162, 188,
    173, 48, 136, 8, 115, 151, 31, 35, 88, 252, 85, 149, 176, 232, 28, 130, 205,
    5, 154, 106, 108, 13, 169, 236, 38, 43, 124, 167, 26, 174, 119, 101, 86,
    215, 5, 176, 92, 160, 50, 247, 216, 211, 110, 107, 162, 243, 46, 165, 46,
    59, 204, 104, 122, 103, 192, 183, 119, 226, 74, 249, 158, 203, 1, 153, 10,
    202, 14, 249, 89, 88, 54, 82, 119, 136, 110, 20, 175, 169, 163, 183, 248,
    225, 72, 212, 90, 239, 254, 62, 113, 223, 13, 218, 11, 250, 146, 247, 96,
    51, 5, 206, 81, 215, 252, 146, 246, 46, 28, 77, 196, 160, 251, 228, 118, 3,
    198, 54, 205, 59, 50, 156, 172, 0, 209, 14, 152, 91, 200, 191, 115, 124, 8,
    20, 184, 82, 168, 236, 0, 249, 151, 164, 106, 36, 13, 37, 208, 53, 3, 159,
    96, 68, 221, 177, 105, 110, 152, 214, 234, 156, 16, 94, 180, 99, 165, 130,
    110, 207, 147, 218, 151, 77, 241, 22, 0, 221, 148, 171, 229, 13, 228, 43,
    121, 167, 210, 50, 108, 206, 154, 159, 229, 236, 12, 245, 55, 204, 127, 2,
    114, 186, 70, 191, 183, 3, 148, 131, 102, 238, 155, 38, 230, 102, 127, 241,
    111, 246, 93, 16, 191, 195, 163, 130, 220, 103, 28, 93, 94, 15, 181, 83, 5,
    110, 75, 45, 96, 18, 83, 109, 72, 92, 201, 121, 124, 30, 88, 221, 13, 234,
    219, 68, 93, 22, 63, 170, 106, 107, 199, 160, 143, 195, 196, 203, 46, 13,
    223, 65, 51, 24, 200, 3, 72, 227, 144, 54, 146, 123, 211, 37, 29, 161, 220,
    6, 113, 115, 91, 137, 252, 146, 237, 45, 156, 93, 79, 152, 23, 238, 6, 126,
    237, 170, 40, 232, 252, 229, 87, 194, 216, 5, 183, 122, 63, 213, 120, 139,
    162, 91, 55, 27, 237, 148, 250, 225, 225, 236, 121, 19, 63, 207, 63, 7, 187,
    248, 78, 39, 79, 58, 113, 151, 147, 152, 124, 193, 51, 164, 102, 101, 13,
    158, 230, 31, 152, 65, 93, 123, 53, 129, 224, 253, 201, 219, 138, 120, 63,
    46, 214, 253, 189, 165, 129, 182, 58, 106, 118, 23, 148, 228, 30, 88, 210,
    129, 116, 73, 107, 215, 51, 248, 9, 48, 94, 50, 16, 165, 76, 85, 97, 182,
    157, 57, 207, 105, 12, 124, 194, 47, 24, 89, 155, 68, 144, 52, 134, 53, 168,
    240, 129, 206, 42, 249, 120, 142, 47, 67, 198, 230, 185, 21, 132, 57, 212,
    244, 58, 3, 48, 182, 212, 168, 51, 241, 77, 164, 236, 71, 195, 26, 162, 5,
    251, 237, 175, 43, 241, 70, 38, 112, 204, 97, 248, 235, 163, 36, 158, 185,
    52, 236, 87, 70, 12, 228, 89, 54, 60, 205, 53, 110, 77, 114, 127, 2, 207,
    224, 21, 130, 193, 112, 134, 10, 82, 28, 26, 57, 107, 62, 29, 144, 214, 41,
    206, 246, 169, 168, 66, 84, 77, 239, 177, 13, 61, 153, 100, 216, 163, 91,
    95, 97, 59, 163, 222, 181, 207, 12, 207, 241, 60, 128, 12, 89, 73, 36, 253,
    86, 54, 31, 226, 7, 19, 127, 208, 169, 95, 171, 9, 133, 39, 15, 48, 186,
    149, 227, 243, 175, 91, 116, 165, 50, 157, 68, 122, 186, 234, 109, 45, 230,
    131, 119, 154, 67, 131, 172, 162, 140, 210, 102, 30, 98, 43, 28, 147, 63,
    244, 168, 163, 100, 218, 94, 57, 222, 107, 186, 235, 38, 133, 205, 104, 80,
    94, 184, 147, 106, 50, 98, 212, 182, 85, 64, 32, 60, 177, 48, 5, 173, 132,
    215, 178, 168, 157, 250, 238, 159, 153, 101, 183, 21, 194, 232, 145, 210,
    141, 180, 37, 40, 115, 236, 23, 164, 230, 1, 86, 210, 87, 91, 110, 195, 171,
    243, 180, 177, 236, 187, 60, 168, 126, 106, 234, 166, 236, 160, 165, 208,
    89, 237, 53, 68, 129, 229, 17, 97, 162, 65, 68, 222, 243, 208, 3, 153, 129,
    47, 131, 205, 121, 216, 115, 237, 54, 137, 189, 249, 203, 243, 56, 201, 181,
    193, 145, 41, 224, 222, 94, 161, 168, 91, 85, 249, 36, 244, 65, 136, 31,
    212, 25, 27, 87, 242, 189, 22, 59, 15, 107, 53, 168, 92, 254, 12, 172, 12,
    131, 11, 7, 242, 127, 129, 34, 88, 14, 243, 207, 112, 228, 144, 242, 9, 242,
    188, 31, 238, 194, 101, 6, 189, 144, 13, 107, 108, 135, 179, 238, 19, 21,
    91, 80, 229, 36, 85, 213, 35, 243, 138, 203, 206, 128, 233, 226, 4, 178, 16,
    46, 128, 17, 174, 72, 201, 95, 6, 185, 186, 11, 124, 206, 82, 64, 25, 224,
    116, 151, 211, 55, 193, 10, 242, 145, 131, 219, 205, 146, 244, 106, 204, 38,
    50, 218, 22, 8, 132, 31, 225, 123, 221, 181, 213, 139, 34, 117, 152, 23,
    147, 166, 30, 0, 97, 173, 173, 9, 58, 250, 128, 230, 134, 9, 70, 104, 178,
    235, 232, 121, 8, 156, 245, 213, 10, 238, 136, 105, 93, 167, 120, 144, 40,
    148, 23, 243, 111, 220, 120, 222, 93, 81, 163, 48, 131, 192, 146, 191, 234,
    228, 232, 239, 95, 57, 92, 4, 77, 86, 238, 191, 81, 56, 100, 172, 114, 7,
    108, 68, 8, 187, 128, 115, 51, 113, 130, 247, 236, 167, 223, 48, 122, 142,
    57, 118, 15, 223, 147, 244, 145, 122, 59, 10, 65, 132, 0, 212, 169, 16, 115,
    161, 216, 88, 44, 231, 82, 70, 126, 49, 116, 187, 49, 71, 199, 55, 94, 249,
    152, 7, 225, 193, 189, 130, 192, 58, 54, 149, 146, 79, 149, 3, 211, 171,
    196, 127, 22, 75, 18, 228, 179, 166, 13, 40, 133, 152, 195, 37, 194, 100,
    70, 120, 6, 171, 62, 130, 230, 129, 234, 74, 114, 18, 44, 87, 164, 200, 179,
    167, 221, 168, 135, 130, 80, 185, 185, 108, 138, 79, 27, 41, 208, 90, 49,
    165, 46, 236, 89, 33, 208, 73, 118, 66, 231, 78, 18, 84, 27, 122, 84, 255,
    44, 213, 93, 118, 12, 237, 186, 251, 209, 48, 25, 14, 167, 151, 33, 126,
    210, 67, 9, 145, 219, 163, 153, 75, 40, 65, 118, 252, 191, 14, 108, 149, 8,
    26, 168, 63, 225, 25, 69, 218, 2, 189, 195, 133, 195, 128, 178, 147, 119,
    69, 69, 68, 130, 12, 141, 153, 250, 99, 93, 2, 138, 207, 6, 99, 85, 68, 192,
    140, 126, 211, 111, 10, 251, 54, 101, 170, 192, 240, 201, 116, 69, 43, 190,
    184, 230, 22, 243, 87, 87, 196, 238, 157, 185, 159, 54, 223, 185, 106, 116,
    81, 177, 89, 103, 194, 16, 181, 220, 124, 84, 189, 117, 24, 7, 110, 62, 129,
    129, 60, 9, 69, 26, 118, 198, 224, 126, 166, 130, 52, 27, 187, 216, 35, 107,
    74, 58, 60, 87, 77, 109, 243, 174, 137, 234, 173, 141, 16, 64, 17, 47, 173,
    84, 28, 47, 50, 103, 19, 190, 193, 168, 102, 152, 228, 234, 233, 61, 236,
    18, 25, 155, 152, 229, 45, 224, 182, 163, 232, 125, 205, 58, 199, 200, 28,
    203, 120, 249, 61, 54, 9, 94, 120, 191, 141, 71, 146, 25, 239, 194, 26, 225,
    186, 239, 37, 98, 0, 79, 152, 189, 67, 38, 80, 56, 165, 129, 18, 196, 86,
    33, 60, 82, 107, 252, 174, 158, 76, 116, 13, 30, 240, 79, 117, 71, 85, 85,
    154, 226, 46, 129, 63, 237, 152, 122, 118, 229, 161, 238, 236, 85, 18, 220,
    118, 87, 165, 100, 115, 196, 53, 49, 248, 101, 149, 106, 153, 32, 10, 178,
    55, 40, 245, 112, 187, 140, 158, 176, 151, 40, 139, 243, 170, 208, 56, 54,
    1, 50, 73, 94, 251, 133, 22, 97, 176, 106, 72, 17, 165, 28, 173, 48, 20, 42,
    80, 116, 46, 196, 195, 250, 92, 17, 127, 75, 186, 105, 231, 95, 160, 47,
    188, 136, 211, 196, 127, 158, 134, 204, 224, 91, 174, 250, 145, 182, 191,
    82, 213, 12, 192, 44, 110, 72, 192, 132, 197, 214, 102, 1, 222, 124, 196,
    213, 196, 121, 19, 46, 41, 92, 232, 236, 51, 96, 131, 235, 194, 84, 122, 89,
    148, 212, 12, 126, 248, 160, 159, 149, 247, 198, 6, 62, 51, 2, 251, 250, 36,
    116, 239, 161, 93, 239, 240, 140, 1, 43, 197, 196, 74, 242, 102, 243, 94,
    149, 26, 106, 209, 23, 96, 187, 67, 32, 172, 119, 2, 209, 83, 64, 223, 147,
    18, 88, 2, 156, 229, 5, 148, 111, 91, 179, 93, 196, 62, 41, 230, 16, 16,
    232, 198, 116, 227, 112, 238, 85, 103, 217, 85, 188, 231, 121, 13, 219, 16,
    77, 173, 165, 124, 57, 21, 33, 172, 153, 176, 179, 83, 97, 252, 245, 146,
    176, 160, 218, 38, 122, 93, 51, 48, 195, 89, 58, 1, 196, 211, 139, 224, 91,
    77, 122, 89, 162, 188, 73, 179, 167, 237, 243, 91, 44, 197, 70, 225, 199,
    158, 95, 104, 72, 200, 48, 168, 186, 197, 201, 219, 27, 149, 83, 52, 78, 62,
    30, 130, 35, 205, 183, 15, 61, 18, 71, 140, 233, 164, 169, 102, 91, 160,
    196, 222, 171, 172, 136, 24, 231, 152, 41, 139, 173, 127, 35, 179, 167, 9,
    103, 226, 237, 216, 99, 199, 12, 248, 17, 236, 250, 32, 16, 207, 68, 222,
    224, 124, 242, 99, 244, 186, 56, 199, 158, 40, 79, 225, 107, 14, 54, 32,
    183, 8, 107, 130, 4, 32, 161, 200, 72, 214, 175, 107, 63, 243, 133, 213,
    210, 77, 107, 166, 133, 230, 4, 105, 146, 201, 199, 201, 171, 148, 217, 5,
    170, 171, 200, 227, 234, 238, 81, 99, 39, 103, 214, 109, 103, 15, 97, 199,
    208, 64, 168, 62, 52, 143, 242, 173, 20, 138, 42, 253, 33, 31, 44, 252, 240,
    31, 199, 151, 228, 63, 220, 221, 238, 201, 151, 239, 34, 63, 71, 5, 151,
    190, 185, 167, 97, 117, 119, 3, 114, 93, 8, 228, 191, 228, 183, 104, 61,
    236, 176, 141, 98, 184, 148, 207, 210, 54, 186, 139, 118, 200, 160, 228,
    179, 70, 220, 167, 157, 187, 144, 186, 128, 51, 62, 125, 13, 170, 207, 229,
    77, 56, 173, 140, 190, 35, 68, 116, 99, 67, 113, 230, 32, 83, 208, 91, 72,
    115, 7, 225, 109, 80, 234, 225, 213, 115, 156, 166, 179, 37, 107, 49, 100,
    181, 203, 156, 228, 29, 91, 227, 141, 166, 243, 234, 180, 108, 127, 218, 90,
    7, 39, 131, 98, 104, 230, 143, 178, 193, 165, 203, 12, 153, 239, 197, 31,
    195, 189, 62, 247, 228, 77, 30, 0, 141, 153, 215, 64, 188, 240, 62, 208,
    243, 189, 31, 9, 129, 14, 26, 144, 99, 113, 247, 223, 113, 224, 175, 135,
    135, 64, 82, 15, 177, 24, 254, 89, 182, 230, 121, 25, 89, 181, 239, 236, 40,
    88, 61, 146, 96, 139, 94, 81, 82, 136, 10, 202, 177, 119, 154, 247, 74, 65,
    99, 119, 166, 106, 9, 227, 101, 167, 93, 37, 221, 106, 84, 214, 239, 138,
    202, 82, 201, 222, 222, 177, 3, 227, 175, 115, 193, 22, 132, 0, 151, 212,
    168, 128, 200, 148, 211, 205, 71, 67, 15, 246, 96, 20, 49, 161, 24, 82, 84,
    222, 74, 56, 116, 126, 249, 71, 45, 191, 52, 222, 6, 180, 43, 149, 240, 90,
    24, 28, 196, 237, 104, 58, 201, 115, 126, 237, 201, 191, 33, 44, 47, 45,
    254, 188, 16, 107, 58, 198, 134, 3, 200, 130, 53, 121, 215, 172, 176, 70,
    201, 141, 6, 23, 17, 193, 44, 11, 47, 207, 140, 209, 248, 147, 80, 86, 150,
    43, 119, 90, 162, 83, 221, 221, 103, 241, 138, 58, 74, 91, 45, 119, 236,
    146, 119, 63, 242, 164, 146, 200, 138, 158, 87, 10, 168, 1, 60, 228, 84,
    238, 83, 181, 170, 97, 185, 58, 221, 171, 202, 118, 104, 20, 233, 117, 153,
    228, 206, 129, 149, 180, 134, 85, 15, 142, 173, 108, 117, 21, 8, 164, 189,
    254, 106, 135, 243, 212, 220, 93, 107, 207, 243, 233, 69, 164, 31, 73, 73,
    186, 136, 155, 47, 216, 165, 178, 105, 219, 193, 144, 217, 242, 216, 25, 96,
    108, 16, 80, 122, 233, 97, 111, 137, 21, 96, 189, 67, 135, 249, 102, 225,
    179, 206, 193, 156, 136, 188, 1, 118, 146, 143, 183, 208, 140, 136, 171,
    143, 26, 234, 117, 119, 7, 198, 184, 147, 113, 216, 186, 67, 43, 164, 151,
    110, 102, 45, 70, 15, 168, 235, 252, 160, 89, 4, 247, 85, 14, 5, 58, 56,
    176, 146, 48, 162, 180, 76, 4, 229, 1, 50, 254, 155, 199, 46, 174, 39, 231,
    34, 111, 137, 6, 250, 18, 53, 48, 210, 228, 177, 110, 251, 101, 69, 199,
    226, 77, 203, 162, 40, 215, 9, 59, 102, 43, 4, 228, 196, 150, 81, 93, 183,
    222, 156, 188, 15, 64, 182, 197, 204, 124, 84, 0, 151, 152, 212, 31, 159,
    21, 132, 89, 230, 97, 178, 153, 209, 116, 170, 62, 215, 171, 102, 27, 4,
    236, 28, 240, 120, 245, 97, 134, 196, 200, 34, 44, 153, 162, 156, 57, 25,
    30, 35, 244, 205, 16, 224, 131, 216, 185, 116, 199, 16, 220, 25, 20, 53,
    116, 133, 146, 48, 152, 251, 180, 55, 42, 251, 229, 128, 140, 53, 80, 18,
    131, 20, 186, 150, 101, 165, 96, 139, 131, 22, 230, 38, 39, 95, 226, 103,
    210, 105, 180, 92, 134, 176, 16, 169, 34, 236, 141, 28, 31, 249, 151, 93,
    25, 90, 128, 161, 115, 193, 46, 70, 186, 120, 119, 208, 99, 40, 193, 218,
    155, 118, 72, 137, 170, 245, 32, 32, 3, 138, 58, 174, 208, 193, 81, 33, 120,
    224, 161, 46, 143, 235, 125, 191, 75, 13, 23, 115, 67, 211, 64, 208, 94,
    227, 236, 208, 121, 79, 75, 49, 209, 193, 162, 202, 92, 87, 200, 114, 90,
    153, 84, 99, 224, 8, 132, 56, 245, 171, 123, 125, 110, 253, 186, 79, 196,
    193, 180, 88, 213, 68, 63, 84, 208, 2, 156, 100, 240, 98, 32, 237, 239, 211,
    10, 50, 88, 17, 157, 207, 236, 152, 255, 164, 107, 126, 237, 195, 114, 88,
    160, 165, 38, 69, 89, 25, 35, 131, 12, 11, 249, 100, 143, 251, 47, 8, 96,
    122, 80, 35, 156, 173, 192, 87, 76, 140, 61, 45, 253, 17, 101, 129, 30, 25,
    183, 150, 84, 45, 37, 48, 149, 22, 212, 188, 103, 33, 85, 159, 21, 135, 104,
    41, 112, 155, 31, 23, 37, 241, 163, 187, 195, 184, 204, 116, 109, 231, 68,
    120, 226, 250, 76, 201, 87, 95, 126, 9, 85, 138, 27, 175, 0, 38, 197, 23,
    18, 82, 53, 65, 165, 31, 73, 86, 42, 43, 167, 24, 195, 163, 159, 130, 81,
    123, 74, 34, 202, 145, 27, 173, 174, 132, 179, 61, 90, 58, 127, 94, 29, 249,
    240, 219, 74, 52, 19, 131, 228, 29, 50, 209, 68, 158, 230, 155, 119, 129,
    169, 190, 182, 10, 148, 212, 155, 75, 65, 189, 63, 230, 103, 223, 169, 181,
    125, 229, 69, 240, 52, 241, 13, 33, 197, 32, 208, 154, 242, 31, 110, 88, 72,
    92, 20, 165, 83, 204, 34, 56, 142, 206, 38, 61, 115, 246, 195, 80, 98, 137,
    51, 109, 83, 24, 141, 32, 47, 94, 58, 1, 63, 45, 157, 183, 245, 204, 168,
    235, 188, 171, 84, 33, 186, 8, 155, 115, 119, 99, 144, 102, 112, 73, 181,
    25, 38, 23, 242, 138, 8, 218, 34, 161, 184, 115, 83, 4, 219, 206, 24, 213,
    249, 84, 159, 7, 26, 128, 250, 133, 56, 106, 197, 114, 172, 248, 35, 152,
    190, 45, 6, 6, 190, 227, 163, 77, 85, 12, 79, 14, 237, 2, 245, 245, 102, 99,
    43, 80, 144, 253, 81, 189, 237, 176, 151, 74, 72, 243, 201, 192, 140, 159,
    186, 218, 215, 10, 159, 11, 206, 203, 135, 175, 95, 98, 207, 29, 169, 87,
    65, 16, 188, 246, 198, 235, 127, 206, 108, 185, 55, 134, 243, 118, 230, 82,
    104, 35, 88, 53, 206, 171, 142, 121, 225, 217, 192, 169, 180, 219, 174, 158,
    60, 237, 250, 241, 48, 112, 214, 81, 184, 7, 29, 146, 83, 235, 116, 222, 72,
    217, 231, 148, 199, 121, 15, 59, 136, 127, 89, 126, 75, 110, 119, 112, 56,
    123, 245, 70, 156, 255, 111, 208, 142, 163, 250, 241, 133, 161, 216, 199,
    47, 65, 191, 79, 63, 90, 45, 161, 190, 250, 239, 97, 27, 222, 104, 96, 191,
    238, 77, 60, 74, 45, 114, 46, 60, 247, 142, 228, 134, 202, 67, 101, 255, 31,
    124, 187, 140, 200, 145, 21, 252, 204, 18, 136, 224, 124, 132, 132, 226, 56,
    95, 246, 135, 209, 173, 140, 251, 246, 71, 244, 93, 223, 229, 253, 14, 167,
    153, 119, 36, 57, 9, 155, 13, 199, 181, 238, 231, 173, 209, 38, 65, 251, 31,
    237, 70, 234, 110, 84, 93, 58, 158, 56, 238, 205, 240, 85, 52, 140, 124, 95,
    87, 109, 0, 11, 99, 169, 208, 123, 134, 178, 195, 19, 45, 62, 107, 221, 206,
    173, 66, 149, 213, 66, 94, 29, 166, 171, 150, 52, 110, 3, 205, 160, 247,
    205, 27, 203, 136, 246, 157, 146, 232, 73, 250, 255, 232, 213, 239, 64, 41,
    240, 230, 244, 32, 183, 86, 91, 7, 34, 61, 156, 236, 163, 207, 151, 110,
    237, 21, 13, 118, 218, 6, 62, 49, 185, 100, 116, 28, 167, 131, 152, 171, 36,
    167, 159, 181, 65, 48, 37, 92, 130, 148, 240, 140, 108, 27, 76, 84, 169,
    128, 59, 83, 147, 76, 204, 102, 41, 103, 255, 90, 108, 251, 162, 223, 130,
    216, 144, 17, 59, 124, 187, 9, 207, 234, 77, 165, 180, 81, 75, 18, 0, 22,
    148, 4, 87, 51, 149, 116, 7, 152, 153, 240, 178, 168, 106, 255, 237, 73,
    253, 58, 133, 183, 151, 186, 209, 102, 110, 91, 38, 106, 249, 171, 4, 170,
    174, 204, 88, 190, 46, 77, 233, 137, 9, 213, 85, 131, 189, 59, 47, 33, 226,
    117, 136, 186, 40, 29, 185, 211, 190, 112, 19, 103, 155, 76, 33, 66, 114,
    114, 180, 81, 24, 4, 238, 52, 149, 234, 144, 84, 204, 119, 13, 130, 160,
    118, 251, 213, 104, 6, 164, 175, 149, 237, 87, 81, 136, 117, 93, 83, 92,
    126, 4, 222, 42, 57, 47, 54, 225, 18, 6, 242, 128, 223, 203, 165, 48, 220,
    152, 112, 35, 72, 100, 143, 104, 3, 252, 228, 160, 191, 154, 71, 251, 216,
    174, 255, 207, 57, 18, 171, 148, 151, 175, 135, 158, 165, 221, 46, 157, 254,
    32, 207, 59, 224, 253, 121, 200, 175, 91, 190, 40, 12, 232, 83, 60, 73, 103,
    146, 102, 235, 216, 46, 27, 80, 219, 114, 127, 37, 210, 53, 243, 21, 9, 85,
    18, 212, 153, 112, 110, 17, 67, 243, 75, 185, 234, 52, 94, 169, 47, 208,
    210, 224, 31, 180, 176, 151, 101, 166, 13, 202, 176, 91, 29, 140, 53, 194,
    222, 219, 148, 118, 169, 26, 247, 135, 175, 173, 24, 130, 35, 213, 176, 187,
    128, 21, 27, 223, 132, 255, 128, 235, 221, 169, 139, 74, 111, 178, 223, 38,
    229, 30, 47, 71, 117, 139, 149, 212, 216, 226, 233, 244, 253, 8, 101, 110,
    114, 139, 141, 182, 200, 217, 228, 247, 251, 5, 15, 48, 140, 190, 227, 242,
    79, 136, 161, 167, 176, 252, 8, 10, 11, 40, 116, 172, 193, 233, 248, 47, 57,
    124, 165, 166, 180, 189, 3, 28, 87, 162, 163, 232, 238, 248, 1, 43, 64, 93,
    109, 149, 172, 187, 204, 210, 233, 0, 0, 0, 0, 11, 23, 30, 36, 45, 52, 60,
    71,
  ]),
};

function getTestVectors() {
  var vectors = [];

  // Basic test without context
  ['ML-DSA-44', 'ML-DSA-65', 'ML-DSA-87'].forEach((algorithmName) => {
    vectors.push({
      name: algorithmName + ' basic test',
      publicKeyBuffer: spki[algorithmName],
      publicKeyFormat: 'spki',
      publicKey: null,
      privateKeyBuffer: pkcs8[algorithmName],
      privateKeyFormat: 'pkcs8',
      privateKey: null,
      algorithmName: algorithmName,
      data: data,
      signature: signatures[algorithmName],
    });
  });

  return vectors;
}

// Invalid test vectors for negative testing
function getInvalidTestVectors() {
  var vectors = [];

  // Test with invalid signature
  ['ML-DSA-44', 'ML-DSA-65', 'ML-DSA-87'].forEach((algorithmName) => {
    vectors.push({
      name: algorithmName + ' invalid signature',
      publicKeyBuffer: spki[algorithmName],
      publicKeyFormat: 'spki',
      publicKey: null,
      privateKeyBuffer: pkcs8[algorithmName],
      privateKeyFormat: 'pkcs8',
      privateKey: null,
      algorithmName: algorithmName,
      data: data,
      signature: new Uint8Array([1, 2, 3, 4, 5]), // Invalid signature
    });
  });

  return vectors;
}
