local bit = require 'bit'

local M = {}

-- Description of the values below is contained in ex_cmds_defs.h file.
-- "EX_" prefix is omitted.
local RANGE = 0x001
local BANG = 0x002
local EXTRA = 0x004
local XFILE = 0x008
local NOSPC = 0x010
local DFLALL = 0x020
local WHOLEFOLD = 0x040
local NEEDARG = 0x080
local TRLBAR = 0x100
local REGSTR = 0x200
local COUNT = 0x400
local NOTRLCOM = 0x800
local ZEROR = 0x1000
local CTRLV = 0x2000
local CMDARG = 0x4000
local BUFNAME = 0x8000
local BUFUNL = 0x10000
local ARGOPT = 0x20000
local SBOXOK = 0x40000
local CMDWIN = 0x80000
local MODIFY = 0x100000
local FLAGS = 0x200000
local LOCK_OK = 0x1000000
local PREVIEW = 0x8000000
local FILES = bit.bor(XFILE, EXTRA)
local WORD1 = bit.bor(EXTRA, NOSPC)
local FILE1 = bit.bor(FILES, NOSPC)

M.flags = {
  RANGE = RANGE,
  DFLALL = DFLALL,
  PREVIEW = PREVIEW,
}

-- The following table is described in ex_cmds_defs.h file.
M.cmds = {
  {
    command = 'append',
    flags = bit.bor(BANG, RANGE, ZEROR, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_append',
  },
  {
    command = 'abbreviate',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'abclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abclear',
  },
  {
    command = 'aboveleft',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'all',
    flags = bit.bor(BANG, RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_all',
  },
  {
    command = 'amenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'anoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'args',
    flags = bit.bor(BANG, FILES, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_args',
  },
  {
    command = 'argadd',
    flags = bit.bor(BANG, RANGE, ZEROR, FILES, TRLBAR),
    addr_type = 'ADDR_ARGUMENTS',
    func = 'ex_argadd',
  },
  {
    command = 'argdelete',
    flags = bit.bor(BANG, RANGE, FILES, TRLBAR),
    addr_type = 'ADDR_ARGUMENTS',
    func = 'ex_argdelete',
  },
  {
    command = 'argdo',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_ARGUMENTS',
    func = 'ex_listdo',
  },
  {
    command = 'argdedupe',
    flags = TRLBAR,
    addr_type = 'ADDR_NONE',
    func = 'ex_argdedupe',
  },
  {
    command = 'argedit',
    flags = bit.bor(BANG, NEEDARG, RANGE, ZEROR, FILES, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_ARGUMENTS',
    func = 'ex_argedit',
  },
  {
    command = 'argglobal',
    flags = bit.bor(BANG, FILES, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_args',
  },
  {
    command = 'arglocal',
    flags = bit.bor(BANG, FILES, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_args',
  },
  {
    command = 'argument',
    flags = bit.bor(BANG, RANGE, COUNT, EXTRA, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_ARGUMENTS',
    func = 'ex_argument',
  },
  {
    command = 'ascii',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'do_ascii',
  },
  {
    command = 'autocmd',
    flags = bit.bor(BANG, EXTRA, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_autocmd',
  },
  {
    command = 'augroup',
    flags = bit.bor(BANG, WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_autocmd',
  },
  {
    command = 'aunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'buffer',
    flags = bit.bor(BANG, RANGE, BUFNAME, BUFUNL, COUNT, EXTRA, CMDARG, TRLBAR),
    addr_type = 'ADDR_BUFFERS',
    func = 'ex_buffer',
  },
  {
    command = 'bNext',
    flags = bit.bor(BANG, RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bprevious',
  },
  {
    command = 'ball',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_buffer_all',
  },
  {
    command = 'badd',
    flags = bit.bor(NEEDARG, FILE1, CMDARG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'balt',
    flags = bit.bor(NEEDARG, FILE1, CMDARG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'bdelete',
    flags = bit.bor(BANG, RANGE, BUFNAME, COUNT, EXTRA, TRLBAR),
    addr_type = 'ADDR_BUFFERS',
    func = 'ex_bunload',
  },
  {
    command = 'belowright',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'bfirst',
    flags = bit.bor(BANG, RANGE, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_brewind',
  },
  {
    command = 'blast',
    flags = bit.bor(BANG, RANGE, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_blast',
  },
  {
    command = 'bmodified',
    flags = bit.bor(BANG, RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bmodified',
  },
  {
    command = 'bnext',
    flags = bit.bor(BANG, RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bnext',
  },
  {
    command = 'botright',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'bprevious',
    flags = bit.bor(BANG, RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bprevious',
  },
  {
    command = 'brewind',
    flags = bit.bor(BANG, RANGE, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_brewind',
  },
  {
    command = 'break',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_break',
  },
  {
    command = 'breakadd',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_breakadd',
  },
  {
    command = 'breakdel',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_breakdel',
  },
  {
    command = 'breaklist',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_breaklist',
  },
  {
    command = 'browse',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'buffers',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'buflist_list',
  },
  {
    command = 'bufdo',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_BUFFERS',
    func = 'ex_listdo',
  },
  {
    command = 'bunload',
    flags = bit.bor(BANG, RANGE, BUFNAME, COUNT, EXTRA, TRLBAR),
    addr_type = 'ADDR_LOADED_BUFFERS',
    func = 'ex_bunload',
  },
  {
    command = 'bwipeout',
    flags = bit.bor(BANG, RANGE, BUFNAME, BUFUNL, COUNT, EXTRA, TRLBAR),
    addr_type = 'ADDR_BUFFERS',
    func = 'ex_bunload',
  },
  {
    command = 'change',
    flags = bit.bor(BANG, WHOLEFOLD, RANGE, COUNT, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_change',
  },
  {
    command = 'cNext',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'cNfile',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'cabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'cabclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abclear',
  },
  {
    command = 'cabove',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'caddbuffer',
    flags = bit.bor(RANGE, WORD1, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_cbuffer',
  },
  {
    command = 'caddexpr',
    flags = bit.bor(NEEDARG, WORD1, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_cexpr',
  },
  {
    command = 'caddfile',
    flags = bit.bor(TRLBAR, FILE1),
    addr_type = 'ADDR_NONE',
    func = 'ex_cfile',
  },
  {
    command = 'cafter',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'call',
    flags = bit.bor(RANGE, NEEDARG, EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_call',
  },
  {
    command = 'catch',
    flags = bit.bor(EXTRA, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_catch',
  },
  {
    command = 'cbuffer',
    flags = bit.bor(BANG, RANGE, WORD1, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_cbuffer',
  },
  {
    command = 'cbefore',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'cbelow',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'cbottom',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_cbottom',
  },
  {
    command = 'cc',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_QUICKFIX',
    func = 'ex_cc',
  },
  {
    command = 'cclose',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_cclose',
  },
  {
    command = 'cd',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_cd',
  },
  {
    command = 'cdo',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_QUICKFIX_VALID',
    func = 'ex_listdo',
  },
  {
    command = 'center',
    flags = bit.bor(TRLBAR, RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_align',
  },
  {
    command = 'cexpr',
    flags = bit.bor(NEEDARG, WORD1, NOTRLCOM, BANG),
    addr_type = 'ADDR_NONE',
    func = 'ex_cexpr',
  },
  {
    command = 'cfile',
    flags = bit.bor(TRLBAR, FILE1, BANG),
    addr_type = 'ADDR_NONE',
    func = 'ex_cfile',
  },
  -- Even though 'cfdo' is alphabetically lower than 'cfile', it is after
  -- 'cfile' in this cmd list to support the existing ":cf" abbreviation.
  {
    command = 'cfdo',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_QUICKFIX_VALID',
    func = 'ex_listdo',
  },
  {
    command = 'cfirst',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cc',
  },
  {
    command = 'cgetfile',
    flags = bit.bor(TRLBAR, FILE1),
    addr_type = 'ADDR_NONE',
    func = 'ex_cfile',
  },
  {
    command = 'cgetbuffer',
    flags = bit.bor(RANGE, WORD1, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_cbuffer',
  },
  {
    command = 'cgetexpr',
    flags = bit.bor(NEEDARG, WORD1, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_cexpr',
  },
  {
    command = 'chdir',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_cd',
  },
  {
    command = 'changes',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_changes',
  },
  {
    command = 'checkhealth',
    flags = bit.bor(EXTRA, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_checkhealth',
  },
  {
    command = 'checkpath',
    flags = bit.bor(TRLBAR, BANG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_checkpath',
  },
  {
    command = 'checktime',
    flags = bit.bor(RANGE, BUFNAME, COUNT, EXTRA, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_checktime',
  },
  {
    command = 'chistory',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'qf_history',
  },
  {
    command = 'clist',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'qf_list',
  },
  {
    command = 'clast',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cc',
  },
  {
    command = 'close',
    flags = bit.bor(BANG, RANGE, COUNT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_WINDOWS',
    func = 'ex_close',
  },
  {
    command = 'clearjumps',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_clearjumps',
  },
  {
    command = 'cmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'cmapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'cmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'cnext',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'cnewer',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'qf_age',
  },
  {
    command = 'cnfile',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'cnoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'cnoreabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'cnoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'copy',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_copymove',
  },
  {
    command = 'colder',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'qf_age',
  },
  {
    command = 'colorscheme',
    flags = bit.bor(WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_colorscheme',
  },
  {
    command = 'command',
    flags = bit.bor(EXTRA, BANG, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_command',
  },
  {
    command = 'comclear',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_comclear',
  },
  {
    command = 'compiler',
    flags = bit.bor(BANG, TRLBAR, WORD1, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_compiler',
  },
  {
    command = 'continue',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_continue',
  },
  {
    command = 'confirm',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'const',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_let',
  },
  {
    command = 'copen',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_copen',
  },
  {
    command = 'cprevious',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'cpfile',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_OTHER',
    func = 'ex_cnext',
  },
  {
    command = 'cquit',
    flags = bit.bor(RANGE, COUNT, ZEROR, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cquit',
  },
  {
    command = 'crewind',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cc',
  },
  {
    command = 'cunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'cunabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'cunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'cwindow',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_cwindow',
  },
  {
    command = 'delete',
    flags = bit.bor(RANGE, WHOLEFOLD, REGSTR, COUNT, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_operators',
  },
  {
    command = 'delmarks',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_delmarks',
  },
  {
    command = 'debug',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_debug',
  },
  {
    command = 'debuggreedy',
    flags = bit.bor(RANGE, ZEROR, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_debuggreedy',
  },
  {
    command = 'defer',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_call',
  },
  {
    command = 'delcommand',
    flags = bit.bor(BANG, NEEDARG, WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_delcommand',
  },
  {
    command = 'delfunction',
    flags = bit.bor(BANG, NEEDARG, WORD1, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_delfunction',
  },
  {
    command = 'detach',
    flags = bit.bor(BANG, FILES, CMDARG, ARGOPT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_detach',
  },
  {
    command = 'display',
    flags = bit.bor(EXTRA, NOTRLCOM, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_display',
  },
  {
    command = 'diffupdate',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_diffupdate',
  },
  {
    command = 'diffget',
    flags = bit.bor(RANGE, EXTRA, TRLBAR, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_diffgetput',
  },
  {
    command = 'diffoff',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_diffoff',
  },
  {
    command = 'diffpatch',
    flags = bit.bor(EXTRA, FILE1, TRLBAR, MODIFY),
    addr_type = 'ADDR_NONE',
    func = 'ex_diffpatch',
  },
  {
    command = 'diffput',
    flags = bit.bor(RANGE, EXTRA, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_diffgetput',
  },
  {
    command = 'diffsplit',
    flags = bit.bor(EXTRA, FILE1, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_diffsplit',
  },
  {
    command = 'diffthis',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_diffthis',
  },
  {
    command = 'digraphs',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_digraphs',
  },
  {
    command = 'djump',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'dlist',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'doautocmd',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_doautocmd',
  },
  {
    command = 'doautoall',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_doautoall',
  },
  {
    command = 'drop',
    flags = bit.bor(BANG, FILES, CMDARG, NEEDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_drop',
  },
  {
    command = 'dsearch',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'dsplit',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'edit',
    flags = bit.bor(BANG, FILE1, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'earlier',
    flags = bit.bor(TRLBAR, EXTRA, NOSPC, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_later',
  },
  {
    command = 'echo',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_echo',
  },
  {
    command = 'echoerr',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_execute',
  },
  {
    command = 'echohl',
    flags = bit.bor(EXTRA, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_echohl',
  },
  {
    command = 'echomsg',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_execute',
  },
  {
    command = 'echon',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_echo',
  },
  {
    command = 'else',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_else',
  },
  {
    command = 'elseif',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_else',
  },
  {
    command = 'emenu',
    flags = bit.bor(NEEDARG, EXTRA, TRLBAR, NOTRLCOM, RANGE, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_emenu',
  },
  {
    command = 'endif',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_endif',
  },
  {
    command = 'endfunction',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_endfunction',
  },
  {
    command = 'endfor',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_endwhile',
  },
  {
    command = 'endtry',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_endtry',
  },
  {
    command = 'endwhile',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_endwhile',
  },
  {
    command = 'enew',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'eval',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_eval',
  },
  {
    command = 'ex',
    flags = bit.bor(BANG, FILE1, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'execute',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_execute',
  },
  {
    command = 'exit',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILE1, ARGOPT, DFLALL, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_exit',
  },
  {
    command = 'exusage',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_exusage',
  },
  {
    command = 'file',
    flags = bit.bor(RANGE, ZEROR, BANG, FILE1, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_file',
  },
  {
    command = 'files',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'buflist_list',
  },
  {
    command = 'filetype',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_filetype',
  },
  {
    command = 'filter',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'find',
    flags = bit.bor(RANGE, BANG, FILE1, CMDARG, ARGOPT, TRLBAR, NEEDARG),
    addr_type = 'ADDR_OTHER',
    func = 'ex_find',
  },
  {
    command = 'finally',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_finally',
  },
  {
    command = 'finish',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_finish',
  },
  {
    command = 'first',
    flags = bit.bor(EXTRA, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_rewind',
  },
  {
    command = 'fold',
    flags = bit.bor(RANGE, WHOLEFOLD, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_fold',
  },
  {
    command = 'foldclose',
    flags = bit.bor(RANGE, BANG, WHOLEFOLD, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_foldopen',
  },
  {
    command = 'folddoopen',
    flags = bit.bor(RANGE, DFLALL, NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_LINES',
    func = 'ex_folddo',
  },
  {
    command = 'folddoclosed',
    flags = bit.bor(RANGE, DFLALL, NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_LINES',
    func = 'ex_folddo',
  },
  {
    command = 'foldopen',
    flags = bit.bor(RANGE, BANG, WHOLEFOLD, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_foldopen',
  },
  {
    command = 'for',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_while',
  },
  {
    command = 'function',
    flags = bit.bor(EXTRA, BANG, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_function',
  },
  {
    command = 'fclose',
    flags = bit.bor(BANG, RANGE),
    addr_type = 'ADDR_OTHER',
    func = 'ex_fclose',
  },
  {
    command = 'global',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, EXTRA, DFLALL, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_global',
  },
  {
    command = 'goto',
    flags = bit.bor(RANGE, COUNT, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_goto',
  },
  {
    command = 'grep',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_OTHER',
    func = 'ex_make',
  },
  {
    command = 'grepadd',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_OTHER',
    func = 'ex_make',
  },
  {
    command = 'gui',
    flags = bit.bor(BANG, FILES, CMDARG, ARGOPT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_nogui',
  },
  {
    command = 'gvim',
    flags = bit.bor(BANG, FILES, CMDARG, ARGOPT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_nogui',
  },
  {
    command = 'help',
    flags = bit.bor(BANG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_help',
  },
  {
    command = 'helpclose',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_helpclose',
  },
  {
    command = 'helpgrep',
    flags = bit.bor(EXTRA, NOTRLCOM, NEEDARG),
    addr_type = 'ADDR_NONE',
    func = 'ex_helpgrep',
  },
  {
    command = 'helptags',
    flags = bit.bor(NEEDARG, FILES, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_helptags',
  },
  {
    command = 'highlight',
    flags = bit.bor(BANG, EXTRA, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_highlight',
  },
  {
    command = 'hide',
    flags = bit.bor(BANG, RANGE, COUNT, EXTRA, TRLBAR),
    addr_type = 'ADDR_WINDOWS',
    func = 'ex_hide',
  },
  {
    command = 'history',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_history',
  },
  {
    command = 'horizontal',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'insert',
    flags = bit.bor(BANG, RANGE, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_append',
  },
  {
    command = 'iabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'iabclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abclear',
  },
  {
    command = 'if',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_if',
  },
  {
    command = 'ijump',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'ilist',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'imap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'imapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'imenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'inoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'inoreabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'inoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'intro',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_intro',
  },
  {
    command = 'isearch',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'isplit',
    flags = bit.bor(BANG, RANGE, DFLALL, WHOLEFOLD, EXTRA),
    addr_type = 'ADDR_LINES',
    func = 'ex_findpat',
  },
  {
    command = 'iunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'iunabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'iunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'join',
    flags = bit.bor(BANG, RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_join',
  },
  {
    command = 'jumps',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_jumps',
  },
  {
    command = 'k',
    flags = bit.bor(RANGE, WORD1, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_mark',
  },
  {
    command = 'keepmarks',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'keepjumps',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'keeppatterns',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'keepalt',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'list',
    flags = bit.bor(RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_print',
  },
  {
    command = 'lNext',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'lNfile',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'last',
    flags = bit.bor(EXTRA, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_last',
  },
  {
    command = 'labove',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'language',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_language',
  },
  {
    command = 'laddexpr',
    flags = bit.bor(NEEDARG, WORD1, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_cexpr',
  },
  {
    command = 'laddbuffer',
    flags = bit.bor(RANGE, WORD1, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_cbuffer',
  },
  {
    command = 'laddfile',
    flags = bit.bor(TRLBAR, FILE1),
    addr_type = 'ADDR_NONE',
    func = 'ex_cfile',
  },
  {
    command = 'lafter',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'later',
    flags = bit.bor(TRLBAR, EXTRA, NOSPC, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_later',
  },
  {
    command = 'lbuffer',
    flags = bit.bor(BANG, RANGE, WORD1, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_cbuffer',
  },
  {
    command = 'lbefore',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'lbelow',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cbelow',
  },
  {
    command = 'lbottom',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_cbottom',
  },
  {
    command = 'lcd',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_cd',
  },
  {
    command = 'lchdir',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_cd',
  },
  {
    command = 'lclose',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_cclose',
  },
  {
    command = 'ldo',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_QUICKFIX_VALID',
    func = 'ex_listdo',
  },
  {
    command = 'left',
    flags = bit.bor(TRLBAR, RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_align',
  },
  {
    command = 'leftabove',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'let',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_let',
  },
  {
    command = 'lexpr',
    flags = bit.bor(NEEDARG, WORD1, NOTRLCOM, BANG),
    addr_type = 'ADDR_NONE',
    func = 'ex_cexpr',
  },
  {
    command = 'lfile',
    flags = bit.bor(TRLBAR, FILE1, BANG),
    addr_type = 'ADDR_NONE',
    func = 'ex_cfile',
  },
  -- Even though 'lfdo' is alphabetically lower than 'lfile', it is after
  -- 'lfile' in this cmd list to support the existing ":lf" abbreviation.
  {
    command = 'lfdo',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_QUICKFIX_VALID',
    func = 'ex_listdo',
  },
  {
    command = 'lfirst',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cc',
  },
  {
    command = 'lgetfile',
    flags = bit.bor(TRLBAR, FILE1),
    addr_type = 'ADDR_NONE',
    func = 'ex_cfile',
  },
  {
    command = 'lgetbuffer',
    flags = bit.bor(RANGE, WORD1, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_cbuffer',
  },
  {
    command = 'lgetexpr',
    flags = bit.bor(NEEDARG, WORD1, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_cexpr',
  },
  {
    command = 'lgrep',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_OTHER',
    func = 'ex_make',
  },
  {
    command = 'lgrepadd',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_OTHER',
    func = 'ex_make',
  },
  {
    command = 'lhelpgrep',
    flags = bit.bor(EXTRA, NOTRLCOM, NEEDARG),
    addr_type = 'ADDR_NONE',
    func = 'ex_helpgrep',
  },
  {
    command = 'lhistory',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'qf_history',
  },
  {
    command = 'll',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_QUICKFIX',
    func = 'ex_cc',
  },
  {
    command = 'llast',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cc',
  },
  {
    command = 'llist',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'qf_list',
  },
  {
    command = 'lmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'lmapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'lmake',
    flags = bit.bor(BANG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_NONE',
    func = 'ex_make',
  },
  {
    command = 'lnoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'lnext',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'lnewer',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'qf_age',
  },
  {
    command = 'lnfile',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'loadview',
    flags = bit.bor(FILE1, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_loadview',
  },
  {
    command = 'loadkeymap',
    flags = bit.bor(CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_loadkeymap',
  },
  {
    command = 'lockmarks',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'lockvar',
    flags = bit.bor(BANG, EXTRA, NEEDARG, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_lockvar',
  },
  {
    command = 'lolder',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_UNSIGNED',
    func = 'qf_age',
  },
  {
    command = 'lopen',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_copen',
  },
  {
    command = 'lprevious',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cnext',
  },
  {
    command = 'lpfile',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_OTHER',
    func = 'ex_cnext',
  },
  {
    command = 'lrewind',
    flags = bit.bor(RANGE, COUNT, TRLBAR, BANG),
    addr_type = 'ADDR_UNSIGNED',
    func = 'ex_cc',
  },
  {
    command = 'ltag',
    flags = bit.bor(TRLBAR, BANG, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_tag',
  },
  {
    command = 'lunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'lua',
    flags = bit.bor(RANGE, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_lua',
  },
  {
    command = 'luado',
    flags = bit.bor(RANGE, DFLALL, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_luado',
  },
  {
    command = 'luafile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_luafile',
  },
  {
    command = 'lvimgrep',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_vimgrep',
  },
  {
    command = 'lvimgrepadd',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_vimgrep',
  },
  {
    command = 'lwindow',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_cwindow',
  },
  {
    command = 'ls',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'buflist_list',
  },
  {
    command = 'move',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_copymove',
  },
  {
    command = 'mark',
    flags = bit.bor(RANGE, WORD1, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_mark',
  },
  {
    command = 'make',
    flags = bit.bor(BANG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_NONE',
    func = 'ex_make',
  },
  {
    command = 'map',
    flags = bit.bor(BANG, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'mapclear',
    flags = bit.bor(EXTRA, BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'marks',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_marks',
  },
  {
    command = 'match',
    flags = bit.bor(RANGE, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_match',
  },
  {
    command = 'menu',
    flags = bit.bor(RANGE, ZEROR, BANG, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'menutranslate',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menutranslate',
  },
  {
    command = 'messages',
    flags = bit.bor(EXTRA, TRLBAR, RANGE, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_messages',
  },
  {
    command = 'mkexrc',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mkrc',
  },
  {
    command = 'mksession',
    flags = bit.bor(BANG, FILE1, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_mkrc',
  },
  {
    command = 'mkspell',
    flags = bit.bor(BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE),
    addr_type = 'ADDR_NONE',
    func = 'ex_mkspell',
  },
  {
    command = 'mkvimrc',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mkrc',
  },
  {
    command = 'mkview',
    flags = bit.bor(BANG, FILE1, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_mkrc',
  },
  {
    command = 'mode',
    flags = bit.bor(WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mode',
  },
  {
    command = 'mzscheme',
    flags = bit.bor(RANGE, EXTRA, DFLALL, NEEDARG, CMDWIN, LOCK_OK, SBOXOK),
    addr_type = 'ADDR_LINES',
    func = 'ex_script_ni',
  },
  {
    command = 'mzfile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_ni',
  },
  {
    command = 'next',
    flags = bit.bor(RANGE, BANG, FILES, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_next',
  },
  {
    command = 'new',
    flags = bit.bor(BANG, FILE1, RANGE, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_splitview',
  },
  {
    command = 'nmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'nmapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'nmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'nnoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'nnoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'noremap',
    flags = bit.bor(BANG, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'noautocmd',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'nohlsearch',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_nohlsearch',
  },
  {
    command = 'noreabbrev',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'noremenu',
    flags = bit.bor(RANGE, ZEROR, BANG, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'noswapfile',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'normal',
    flags = bit.bor(RANGE, BANG, EXTRA, NEEDARG, NOTRLCOM, CTRLV, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_normal',
  },
  {
    command = 'number',
    flags = bit.bor(RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_print',
  },
  {
    command = 'nunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'nunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'oldfiles',
    flags = bit.bor(BANG, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_oldfiles',
  },
  {
    command = 'omap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'omapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'omenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'only',
    flags = bit.bor(BANG, RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_WINDOWS',
    func = 'ex_only',
  },
  {
    command = 'onoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'onoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'options',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_options',
  },
  {
    command = 'ounmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'ounmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'ownsyntax',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_ownsyntax',
  },
  {
    command = 'print',
    flags = bit.bor(RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK, SBOXOK),
    addr_type = 'ADDR_LINES',
    func = 'ex_print',
  },
  {
    command = 'packadd',
    flags = bit.bor(BANG, FILE1, NEEDARG, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_packadd',
  },
  {
    command = 'packloadall',
    flags = bit.bor(BANG, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_packloadall',
  },
  {
    command = 'pbuffer',
    flags = bit.bor(BANG, RANGE, BUFNAME, BUFUNL, COUNT, EXTRA, CMDARG, TRLBAR),
    addr_type = 'ADDR_BUFFERS',
    func = 'ex_pbuffer',
  },
  {
    command = 'pclose',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_pclose',
  },
  {
    command = 'perl',
    flags = bit.bor(RANGE, EXTRA, DFLALL, NEEDARG, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_perl',
  },
  {
    command = 'perldo',
    flags = bit.bor(RANGE, EXTRA, DFLALL, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_perldo',
  },
  {
    command = 'perlfile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_perlfile',
  },
  {
    command = 'pedit',
    flags = bit.bor(BANG, FILE1, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_pedit',
  },
  {
    command = 'pop',
    flags = bit.bor(RANGE, BANG, COUNT, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'popup',
    flags = bit.bor(NEEDARG, EXTRA, BANG, TRLBAR, NOTRLCOM, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_popup',
  },
  {
    command = 'ppop',
    flags = bit.bor(RANGE, BANG, COUNT, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'preserve',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_preserve',
  },
  {
    command = 'previous',
    flags = bit.bor(EXTRA, RANGE, COUNT, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_previous',
  },
  {
    command = 'profile',
    flags = bit.bor(BANG, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_profile',
  },
  {
    command = 'profdel',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_breakdel',
  },
  {
    command = 'psearch',
    flags = bit.bor(BANG, RANGE, WHOLEFOLD, DFLALL, EXTRA),
    addr_type = 'ADDR_LINES',
    func = 'ex_psearch',
  },
  {
    command = 'ptag',
    flags = bit.bor(RANGE, BANG, WORD1, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'ptNext',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'ptfirst',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'ptjump',
    flags = bit.bor(BANG, TRLBAR, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_ptag',
  },
  {
    command = 'ptlast',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_ptag',
  },
  {
    command = 'ptnext',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'ptprevious',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'ptrewind',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_ptag',
  },
  {
    command = 'ptselect',
    flags = bit.bor(BANG, TRLBAR, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_ptag',
  },
  {
    command = 'put',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, REGSTR, TRLBAR, ZEROR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_put',
  },
  {
    command = 'pwd',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_pwd',
  },
  {
    command = 'python',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_python3',
  },
  {
    command = 'pydo',
    flags = bit.bor(RANGE, DFLALL, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_pydo3',
  },
  {
    command = 'pyfile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_py3file',
  },
  {
    command = 'py3',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_python3',
  },
  {
    command = 'py3do',
    flags = bit.bor(RANGE, DFLALL, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_pydo3',
  },
  {
    command = 'python3',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_python3',
  },
  {
    command = 'py3file',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_py3file',
  },
  {
    command = 'pyx',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_python3',
  },
  {
    command = 'pyxdo',
    flags = bit.bor(RANGE, DFLALL, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_pydo3',
  },
  {
    command = 'pythonx',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_python3',
  },
  {
    command = 'pyxfile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_py3file',
  },
  {
    command = 'quit',
    flags = bit.bor(BANG, RANGE, COUNT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_WINDOWS',
    func = 'ex_quit',
  },
  {
    command = 'quitall',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_quit_all',
  },
  {
    command = 'qall',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_quit_all',
  },
  {
    command = 'read',
    flags = bit.bor(BANG, RANGE, WHOLEFOLD, FILE1, ARGOPT, TRLBAR, ZEROR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_read',
  },
  {
    command = 'recover',
    flags = bit.bor(BANG, FILE1, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_recover',
  },
  {
    command = 'redo',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_redo',
  },
  {
    command = 'redir',
    flags = bit.bor(BANG, FILES, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_redir',
  },
  {
    command = 'redraw',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_redraw',
  },
  {
    command = 'redrawstatus',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_redrawstatus',
  },
  {
    command = 'redrawtabline',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_redrawtabline',
  },
  {
    command = 'registers',
    flags = bit.bor(EXTRA, NOTRLCOM, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_display',
  },
  {
    command = 'resize',
    flags = bit.bor(RANGE, TRLBAR, WORD1, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_resize',
  },
  {
    command = 'retab',
    flags = bit.bor(TRLBAR, RANGE, WHOLEFOLD, DFLALL, BANG, WORD1, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_retab',
  },
  {
    command = 'return',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_return',
  },
  {
    command = 'rewind',
    flags = bit.bor(EXTRA, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_rewind',
  },
  {
    command = 'right',
    flags = bit.bor(TRLBAR, RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_align',
  },
  {
    command = 'rightbelow',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'rshada',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_shada',
  },
  {
    command = 'runtime',
    flags = bit.bor(BANG, NEEDARG, FILES, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_runtime',
  },
  {
    command = 'rundo',
    flags = bit.bor(NEEDARG, FILE1),
    addr_type = 'ADDR_NONE',
    func = 'ex_rundo',
  },
  {
    command = 'ruby',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_ruby',
  },
  {
    command = 'rubydo',
    flags = bit.bor(RANGE, DFLALL, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_rubydo',
  },
  {
    command = 'rubyfile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_rubyfile',
  },
  {
    command = 'rviminfo',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_shada',
  },
  {
    command = 'substitute',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, PREVIEW),
    addr_type = 'ADDR_LINES',
    func = 'ex_substitute',
    preview_func = 'ex_substitute_preview',
  },
  {
    command = 'sNext',
    flags = bit.bor(EXTRA, RANGE, COUNT, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_previous',
  },
  {
    command = 'sargument',
    flags = bit.bor(BANG, RANGE, COUNT, EXTRA, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_ARGUMENTS',
    func = 'ex_argument',
  },
  {
    command = 'sall',
    flags = bit.bor(BANG, RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_all',
  },
  {
    command = 'sandbox',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'saveas',
    flags = bit.bor(BANG, FILE1, ARGOPT, CMDWIN, LOCK_OK, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_write',
  },
  {
    command = 'sbuffer',
    flags = bit.bor(BANG, RANGE, BUFNAME, BUFUNL, COUNT, EXTRA, CMDARG, TRLBAR),
    addr_type = 'ADDR_BUFFERS',
    func = 'ex_buffer',
  },
  {
    command = 'sbNext',
    flags = bit.bor(RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bprevious',
  },
  {
    command = 'sball',
    flags = bit.bor(RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_buffer_all',
  },
  {
    command = 'sbfirst',
    flags = bit.bor(CMDARG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_brewind',
  },
  {
    command = 'sblast',
    flags = bit.bor(CMDARG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_blast',
  },
  {
    command = 'sbmodified',
    flags = bit.bor(RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bmodified',
  },
  {
    command = 'sbnext',
    flags = bit.bor(RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bnext',
  },
  {
    command = 'sbprevious',
    flags = bit.bor(RANGE, COUNT, CMDARG, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_bprevious',
  },
  {
    command = 'sbrewind',
    flags = bit.bor(CMDARG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_brewind',
  },
  {
    command = 'scriptnames',
    flags = bit.bor(BANG, FILES, RANGE, COUNT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_scriptnames',
  },
  {
    command = 'scriptencoding',
    flags = bit.bor(WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_scriptencoding',
  },
  {
    command = 'set',
    flags = bit.bor(BANG, TRLBAR, EXTRA, CMDWIN, LOCK_OK, SBOXOK),
    addr_type = 'ADDR_NONE',
    func = 'ex_set',
  },
  {
    command = 'setfiletype',
    flags = bit.bor(TRLBAR, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_setfiletype',
  },
  {
    command = 'setglobal',
    flags = bit.bor(BANG, TRLBAR, EXTRA, CMDWIN, LOCK_OK, SBOXOK),
    addr_type = 'ADDR_NONE',
    func = 'ex_set',
  },
  {
    command = 'setlocal',
    flags = bit.bor(BANG, TRLBAR, EXTRA, CMDWIN, LOCK_OK, SBOXOK),
    addr_type = 'ADDR_NONE',
    func = 'ex_set',
  },
  {
    command = 'sfind',
    flags = bit.bor(BANG, FILE1, RANGE, CMDARG, ARGOPT, TRLBAR, NEEDARG),
    addr_type = 'ADDR_OTHER',
    func = 'ex_splitview',
  },
  {
    command = 'sfirst',
    flags = bit.bor(EXTRA, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_rewind',
  },
  {
    command = 'simalt',
    flags = bit.bor(NEEDARG, WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_ni',
  },
  {
    command = 'sign',
    flags = bit.bor(NEEDARG, RANGE, EXTRA, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_sign',
  },
  {
    command = 'silent',
    flags = bit.bor(NEEDARG, EXTRA, BANG, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'sleep',
    flags = bit.bor(BANG, RANGE, COUNT, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_sleep',
  },
  {
    command = 'slast',
    flags = bit.bor(EXTRA, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_last',
  },
  {
    command = 'smagic',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, PREVIEW),
    addr_type = 'ADDR_LINES',
    func = 'ex_submagic',
    preview_func = 'ex_submagic_preview',
  },
  {
    command = 'smap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'smapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'smenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'snext',
    flags = bit.bor(RANGE, BANG, FILES, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_next',
  },
  {
    command = 'snomagic',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, PREVIEW),
    addr_type = 'ADDR_LINES',
    func = 'ex_submagic',
    preview_func = 'ex_submagic_preview',
  },
  {
    command = 'snoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'snoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'source',
    flags = bit.bor(RANGE, DFLALL, BANG, FILE1, TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_source',
  },
  {
    command = 'sort',
    flags = bit.bor(RANGE, DFLALL, WHOLEFOLD, BANG, EXTRA, NOTRLCOM, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_sort',
  },
  {
    command = 'split',
    flags = bit.bor(BANG, FILE1, RANGE, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_splitview',
  },
  {
    command = 'spellgood',
    flags = bit.bor(BANG, RANGE, NEEDARG, EXTRA, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_spell',
  },
  {
    command = 'spelldump',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_spelldump',
  },
  {
    command = 'spellinfo',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_spellinfo',
  },
  {
    command = 'spellrepall',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_spellrepall',
  },
  {
    command = 'spellrare',
    flags = bit.bor(BANG, RANGE, NEEDARG, EXTRA, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_spell',
  },
  {
    command = 'spellundo',
    flags = bit.bor(BANG, RANGE, NEEDARG, EXTRA, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_spell',
  },
  {
    command = 'spellwrong',
    flags = bit.bor(BANG, RANGE, NEEDARG, EXTRA, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_spell',
  },
  {
    command = 'sprevious',
    flags = bit.bor(EXTRA, RANGE, COUNT, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_previous',
  },
  {
    command = 'srewind',
    flags = bit.bor(EXTRA, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_rewind',
  },
  {
    command = 'stop',
    flags = bit.bor(TRLBAR, BANG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_stop',
  },
  {
    command = 'stag',
    flags = bit.bor(RANGE, BANG, WORD1, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_stag',
  },
  {
    command = 'startinsert',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_startinsert',
  },
  {
    command = 'startgreplace',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_startinsert',
  },
  {
    command = 'startreplace',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_startinsert',
  },
  {
    command = 'stopinsert',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_stopinsert',
  },
  {
    command = 'stjump',
    flags = bit.bor(BANG, TRLBAR, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_stag',
  },
  {
    command = 'stselect',
    flags = bit.bor(BANG, TRLBAR, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_stag',
  },
  {
    command = 'sunhide',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_buffer_all',
  },
  {
    command = 'sunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'sunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'suspend',
    flags = bit.bor(TRLBAR, BANG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_stop',
  },
  {
    command = 'sview',
    flags = bit.bor(BANG, FILE1, RANGE, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_splitview',
  },
  {
    command = 'swapname',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_swapname',
  },
  {
    command = 'syntax',
    flags = bit.bor(EXTRA, NOTRLCOM, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_syntax',
  },
  {
    command = 'syntime',
    flags = bit.bor(NEEDARG, WORD1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_syntime',
  },
  {
    command = 'syncbind',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_syncbind',
  },
  {
    command = 't',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_copymove',
  },
  {
    command = 'tcd',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_cd',
  },
  {
    command = 'tchdir',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_cd',
  },
  {
    command = 'tNext',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'tag',
    flags = bit.bor(RANGE, BANG, WORD1, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'tags',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'do_tags',
  },
  {
    command = 'tab',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'tabclose',
    flags = bit.bor(BANG, RANGE, ZEROR, EXTRA, NOSPC, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_TABS',
    func = 'ex_tabclose',
  },
  {
    command = 'tabdo',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_TABS',
    func = 'ex_listdo',
  },
  {
    command = 'tabedit',
    flags = bit.bor(BANG, FILE1, RANGE, ZEROR, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_TABS',
    func = 'ex_splitview',
  },
  {
    command = 'tabfind',
    flags = bit.bor(BANG, FILE1, RANGE, ZEROR, CMDARG, ARGOPT, NEEDARG, TRLBAR),
    addr_type = 'ADDR_TABS',
    func = 'ex_splitview',
  },
  {
    command = 'tabfirst',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_tabnext',
  },
  {
    command = 'tabmove',
    flags = bit.bor(RANGE, ZEROR, EXTRA, NOSPC, TRLBAR),
    addr_type = 'ADDR_TABS',
    func = 'ex_tabmove',
  },
  {
    command = 'tablast',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_tabnext',
  },
  {
    command = 'tabnext',
    flags = bit.bor(RANGE, ZEROR, EXTRA, NOSPC, TRLBAR),
    addr_type = 'ADDR_TABS',
    func = 'ex_tabnext',
  },
  {
    command = 'tabnew',
    flags = bit.bor(BANG, FILE1, RANGE, ZEROR, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_TABS',
    func = 'ex_splitview',
  },
  {
    command = 'tabonly',
    flags = bit.bor(BANG, RANGE, ZEROR, EXTRA, NOSPC, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_TABS',
    func = 'ex_tabonly',
  },
  {
    command = 'tabprevious',
    flags = bit.bor(RANGE, ZEROR, EXTRA, NOSPC, TRLBAR),
    addr_type = 'ADDR_TABS_RELATIVE',
    func = 'ex_tabnext',
  },
  {
    command = 'tabNext',
    flags = bit.bor(RANGE, ZEROR, EXTRA, NOSPC, TRLBAR),
    addr_type = 'ADDR_TABS_RELATIVE',
    func = 'ex_tabnext',
  },
  {
    command = 'tabrewind',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_tabnext',
  },
  {
    command = 'tabs',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_tabs',
  },
  {
    command = 'tcl',
    flags = bit.bor(RANGE, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_script_ni',
  },
  {
    command = 'tcldo',
    flags = bit.bor(RANGE, DFLALL, EXTRA, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_ni',
  },
  {
    command = 'tclfile',
    flags = bit.bor(RANGE, FILE1, NEEDARG, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_ni',
  },
  {
    command = 'terminal',
    flags = bit.bor(BANG, FILES, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_terminal',
  },
  {
    command = 'tfirst',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'throw',
    flags = bit.bor(EXTRA, NEEDARG, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_throw',
  },
  {
    command = 'tjump',
    flags = bit.bor(BANG, TRLBAR, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_tag',
  },
  {
    command = 'tlast',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_tag',
  },
  {
    command = 'tlmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'tlnoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'tlunmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'tmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'tmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'tmapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'tnext',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'tnoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'topleft',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'tprevious',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'trewind',
    flags = bit.bor(RANGE, BANG, TRLBAR, ZEROR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_tag',
  },
  {
    command = 'trust',
    flags = bit.bor(EXTRA, FILE1, TRLBAR, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_trust',
  },
  {
    command = 'try',
    flags = bit.bor(TRLBAR, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_try',
  },
  {
    command = 'tselect',
    flags = bit.bor(BANG, TRLBAR, WORD1),
    addr_type = 'ADDR_NONE',
    func = 'ex_tag',
  },
  {
    command = 'tunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'tunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'undo',
    flags = bit.bor(BANG, RANGE, COUNT, ZEROR, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_undo',
  },
  {
    command = 'undojoin',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_undojoin',
  },
  {
    command = 'undolist',
    flags = bit.bor(TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_undolist',
  },
  {
    command = 'unabbreviate',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_abbreviate',
  },
  {
    command = 'unhide',
    flags = bit.bor(RANGE, COUNT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_buffer_all',
  },
  {
    command = 'unlet',
    flags = bit.bor(BANG, EXTRA, NEEDARG, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unlet',
  },
  {
    command = 'unlockvar',
    flags = bit.bor(BANG, EXTRA, NEEDARG, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_lockvar',
  },
  {
    command = 'unmap',
    flags = bit.bor(BANG, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'unmenu',
    flags = bit.bor(BANG, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'unsilent',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'update',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILE1, ARGOPT, DFLALL, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_update',
  },
  {
    command = 'vglobal',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, DFLALL, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_global',
  },
  {
    command = 'version',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_version',
  },
  {
    command = 'verbose',
    flags = bit.bor(NEEDARG, RANGE, EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'vertical',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM),
    addr_type = 'ADDR_NONE',
    func = 'ex_wrongmodifier',
  },
  {
    command = 'visual',
    flags = bit.bor(BANG, FILE1, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'view',
    flags = bit.bor(BANG, FILE1, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_edit',
  },
  {
    command = 'vimgrep',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_vimgrep',
  },
  {
    command = 'vimgrepadd',
    flags = bit.bor(RANGE, BANG, NEEDARG, EXTRA, NOTRLCOM, TRLBAR, XFILE, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_vimgrep',
  },
  {
    command = 'viusage',
    flags = bit.bor(TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_viusage',
  },
  {
    command = 'vmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'vmapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'vmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'vnoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'vnew',
    flags = bit.bor(BANG, FILE1, RANGE, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_splitview',
  },
  {
    command = 'vnoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'vsplit',
    flags = bit.bor(BANG, FILE1, RANGE, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_splitview',
  },
  {
    command = 'vunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'vunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'write',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILE1, ARGOPT, DFLALL, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_write',
  },
  {
    command = 'wNext',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILE1, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_wnext',
  },
  {
    command = 'wall',
    flags = bit.bor(BANG, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'do_wqall',
  },
  {
    command = 'while',
    flags = bit.bor(EXTRA, NOTRLCOM, SBOXOK, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_while',
  },
  {
    command = 'winsize',
    flags = bit.bor(EXTRA, NEEDARG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'ex_winsize',
  },
  {
    command = 'wincmd',
    flags = bit.bor(NEEDARG, WORD1, RANGE, COUNT, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_wincmd',
  },
  {
    command = 'windo',
    flags = bit.bor(NEEDARG, EXTRA, NOTRLCOM, RANGE, DFLALL),
    addr_type = 'ADDR_WINDOWS',
    func = 'ex_listdo',
  },
  {
    command = 'winpos',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_ni',
  },
  {
    command = 'wnext',
    flags = bit.bor(RANGE, BANG, FILE1, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_wnext',
  },
  {
    command = 'wprevious',
    flags = bit.bor(RANGE, BANG, FILE1, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_wnext',
  },
  {
    command = 'wq',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILE1, ARGOPT, DFLALL, TRLBAR),
    addr_type = 'ADDR_LINES',
    func = 'ex_exit',
  },
  {
    command = 'wqall',
    flags = bit.bor(BANG, FILE1, ARGOPT, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'do_wqall',
  },
  {
    command = 'wshada',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_shada',
  },
  {
    command = 'wundo',
    flags = bit.bor(BANG, NEEDARG, FILE1),
    addr_type = 'ADDR_NONE',
    func = 'ex_wundo',
  },
  {
    command = 'wviminfo',
    flags = bit.bor(BANG, FILE1, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_shada',
  },
  {
    command = 'xit',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILE1, ARGOPT, DFLALL, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_exit',
  },
  {
    command = 'xall',
    flags = bit.bor(BANG, TRLBAR),
    addr_type = 'ADDR_NONE',
    func = 'do_wqall',
  },
  {
    command = 'xmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'xmapclear',
    flags = bit.bor(EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_mapclear',
  },
  {
    command = 'xmenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'xnoremap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_map',
  },
  {
    command = 'xnoremenu',
    flags = bit.bor(RANGE, ZEROR, EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_OTHER',
    func = 'ex_menu',
  },
  {
    command = 'xunmap',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_unmap',
  },
  {
    command = 'xunmenu',
    flags = bit.bor(EXTRA, TRLBAR, NOTRLCOM, CTRLV, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_NONE',
    func = 'ex_menu',
  },
  {
    command = 'yank',
    flags = bit.bor(RANGE, WHOLEFOLD, REGSTR, COUNT, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_operators',
  },
  {
    command = 'z',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, EXTRA, FLAGS, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_z',
  },
  -- commands that don't start with a letter
  {
    command = '!',
    enum = 'CMD_bang',
    flags = bit.bor(RANGE, WHOLEFOLD, BANG, FILES, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_bang',
  },
  {
    command = '#',
    enum = 'CMD_pound',
    flags = bit.bor(RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_print',
  },
  {
    command = '&',
    enum = 'CMD_and',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_substitute',
  },
  {
    command = '<',
    enum = 'CMD_lshift',
    flags = bit.bor(RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_operators',
  },
  {
    command = '=',
    enum = 'CMD_equal',
    flags = bit.bor(RANGE, EXTRA, DFLALL, ARGOPT, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_equal',
  },
  {
    command = '>',
    enum = 'CMD_rshift',
    flags = bit.bor(RANGE, WHOLEFOLD, COUNT, FLAGS, TRLBAR, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_operators',
  },
  {
    command = '@',
    enum = 'CMD_at',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, TRLBAR, CMDWIN, LOCK_OK),
    addr_type = 'ADDR_LINES',
    func = 'ex_at',
  },
  {
    command = '~',
    enum = 'CMD_tilde',
    flags = bit.bor(RANGE, WHOLEFOLD, EXTRA, CMDWIN, LOCK_OK, MODIFY),
    addr_type = 'ADDR_LINES',
    func = 'ex_substitute',
  },
  -- commands that start with an uppercase letter
  {
    command = 'Next',
    flags = bit.bor(EXTRA, RANGE, COUNT, BANG, CMDARG, ARGOPT, TRLBAR),
    addr_type = 'ADDR_OTHER',
    func = 'ex_previous',
  },
}

return M
