#!/bin/sh

set -e

# Since I couldn't get crowdin-cli to work yet, I'm doing things a bit more
# manually for now. The process is as follows:
#
# 1. Download the translations from Crowdin as a zip file
# 2. Unzip the file
# 3. Run this script with the path to the unzipped directory as an argument
#
# Requires jq (1.7 or later): https://github.com/jqlang/jq

if [ "$#" -ne 1 ]; then
    echo "Usage: $0 <download_dir>"
    exit 2
fi

download_dir="$1"

echo "Updating translations..."

# The Portuguese translation is named pt-PT, but we want to use pt instead (it
# is used both for Brasilian and European Portuguese). I couldn't figure out how
# to change this in Crowdin, so we'll do it here.
[ -d "$download_dir/pt-PT" ] && mv "$download_dir/pt-PT" "$download_dir/pt"

for d in "$download_dir"/*
do
    # We need to remove empty strings from the JSON files; those are the ones
    # that haven't been translated yet. Crowdin has an option to skip these when
    # exporting, but unfortunately it doesn't work for json files.
    jq 'del(..|select(. == ""))' < "$d/en.json" > pkg/i18n/translations/$(basename "$d").json
done

# Update cheatsheets, which might be affected by changes in the translations.
echo "Regenerating auto-generated files..."
go generate ./...
