// This file is generated by generate-std.joke script. Do not edit manually!

package os

import (
	"fmt"
	. "github.com/candid82/joker/core"
	"os"
)

func InternsOrThunks() {
	if VerbosityLevel > 0 {
		fmt.Fprintln(os.Stderr, "Lazily running slow version of os.InternsOrThunks().")
	}
	osNamespace.ResetMeta(MakeMeta(nil, `Provides a platform-independent interface to operating system functionality.`, "1.0"))

	osNamespace.InternVar("SIGABRT", SIGABRT_,
		MakeMeta(
			nil,
			`SIGABRT`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGALRM", SIGALRM_,
		MakeMeta(
			nil,
			`SIGALRM`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGFPE", SIGFPE_,
		MakeMeta(
			nil,
			`SIGFPE`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGHUP", SIGHUP_,
		MakeMeta(
			nil,
			`SIGHUP`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGILL", SIGILL_,
		MakeMeta(
			nil,
			`SIGILL`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGINT", SIGINT_,
		MakeMeta(
			nil,
			`SIGINT`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGKILL", SIGKILL_,
		MakeMeta(
			nil,
			`SIGKILL`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGPIPE", SIGPIPE_,
		MakeMeta(
			nil,
			`SIGPIPE`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGQUIT", SIGQUIT_,
		MakeMeta(
			nil,
			`SIGQUIT`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGSEGV", SIGSEGV_,
		MakeMeta(
			nil,
			`SIGSEGV`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGTERM", SIGTERM_,
		MakeMeta(
			nil,
			`SIGTERM`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("SIGTRAP", SIGTRAP_,
		MakeMeta(
			nil,
			`SIGTRAP`, "1.0.1").Plus(MakeKeyword("const"), String{S: "true"}).Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("args", args_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns a sequence of the command line arguments, starting with the program name (normally, joker).`, "1.0"))

	osNamespace.InternVar("chdir", chdir_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("dirname"))),
			`Changes the current working directory to the named directory.`, "1.0"))

	osNamespace.InternVar("chmod", chmod_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("mode"))),
			`Changes the mode of the named file to mode. If the file is a symbolic link, it changes the mode of the link's target.`, "1.0"))

	osNamespace.InternVar("chown", chown_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("uid"), MakeSymbol("gid"))),
			`Changes the numeric uid and gid of the named file. If the file is a symbolic link,
  it changes the uid and gid of the link's target. A uid or gid of -1 means to not change that value.`, "1.0"))

	osNamespace.InternVar("chtimes", chtimes_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("atime"), MakeSymbol("mtime"))),
			`Changes the access and modification times of the named file, similar to the Unix utime() or utimes() functions.`, "1.0"))

	osNamespace.InternVar("clearenv", clearenv_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Deletes all environment variables.`, "1.0"))

	osNamespace.InternVar("close", close_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("f"))),
			`Closes the file, rendering it unusable for I/O.`, "1.0"))

	osNamespace.InternVar("create", create_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"))),
			`Creates the named file with mode 0666 (before umask), truncating it if it already exists.`, "1.0").Plus(MakeKeyword("tag"), String{S: "File"}))

	osNamespace.InternVar("create-temp", create_temp_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("dir"), MakeSymbol("pattern"))),
			`Creates a new temporary file in the directory dir, opens the file for reading and writing,
  and returns the resulting File. The filename is generated by taking pattern and adding a
  random string to the end. If pattern includes a "*", the random string replaces the last "*".
  If dir is the empty string, uses the default directory for temporary files (see joker.os/temp-dir).
  Multiple programs calling joker.os/make-temp-file simultaneously will not choose the same file.
  The caller can use (name f) to find the pathname of the file.
  It is the caller's responsibility to remove the file when no longer needed.`, "1.0").Plus(MakeKeyword("tag"), String{S: "File"}))

	osNamespace.InternVar("cwd", cwd_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns a rooted path name corresponding to the current directory. If the current directory can
  be reached via multiple paths (due to symbolic links), cwd may return any one of them.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("egid", egid_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the numeric effective group id of the caller.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("env", env_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns a map representing the environment.`, "1.0"))

	osNamespace.InternVar("euid", euid_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the numeric effective user id of the caller.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("exec", exec_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("opts"))),
			`Executes the named program with the given arguments. opts is a map with the following keys (all optional):
  :args - vector of arguments (all arguments must be strings),
  :dir - if specified, working directory will be set to this value before executing the program,
  :stdin - if specified, provides stdin for the program. Can be either a string or an IOReader.
  If it's a string, the string's content will serve as stdin for the program. IOReader can be, for example,
  *in* (in which case Joker's stdin will be redirected to the program's stdin) or the value returned by (joker.os/open).
  :stdout - if specified, must be an IOWriter. It can be, for example, *out* (in which case the program's stdout will be redirected
  to Joker's stdout) or the value returned by (joker.os/create).
  :stderr - the same as :stdout, but for stderr.
  Returns a map with the following keys:
  :success - whether or not the execution was successful,
  :err-msg (present iff :success if false) - string capturing error object returned by Go runtime
  :exit - exit code of program (or attempt to execute it),
  :out - string capturing stdout of the program (unless :stdout option was passed)
  :err - string capturing stderr of the program (unless :stderr option was passed).`, "1.0"))

	osNamespace.InternVar("executable", executable_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the path name for the executable that started the current process.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("exists?", isexists_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("path"))),
			`Returns true if file or directory with the given path exists. Otherwise returns false.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Boolean"}))

	osNamespace.InternVar("exit", exit_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("code")), NewVectorFrom()),
			`Causes the current program to exit with the given status code (defaults to 0).`, "1.0"))

	osNamespace.InternVar("expand-env", expand_env_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("s"))),
			`Replaces ${var} or $var in the string according to the values of the current environment variables.
  References to undefined variables are replaced by the empty string.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("get-env", get_env_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("key"))),
			`Returns the value of the environment variable named by the key or nil if the variable is not present in the environment.`, "1.0"))

	osNamespace.InternVar("gid", gid_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the numeric group id of the caller.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("groups", groups_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns a list of the numeric ids of groups that the caller belongs to.`, "1.0").Plus(MakeKeyword("tag"), String{S: "[Int]"}))

	osNamespace.InternVar("hostname", hostname_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the host name reported by the kernel.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("kill", kill_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("pid"))),
			`Causes the process with the given PID to exit immediately.
  Only kills the process itself, not any other processes it may have started.`, "1.0.1"))

	osNamespace.InternVar("lchown", lchown_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("uid"), MakeSymbol("gid"))),
			`Changes the numeric uid and gid of the named file. If the file is a symbolic link,
  it changes the uid and gid of the link itself.`, "1.0"))

	osNamespace.InternVar("link", link_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("oldname"), MakeSymbol("newname"))),
			`Creates newname as a hard link to the oldname file.`, "1.0"))

	osNamespace.InternVar("ls", ls_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("dirname"))),
			`Reads the directory named by dirname and returns a list of directory entries sorted by filename.
  Each entry is a map with the following keys:
  :name - name (String)
  :size - size in bytes (Int)
  :mode - mode (Int)
  :dir? - true if the file is a directory (Boolean)
  :modtime - modification time (unix timestamp) (Int)`, "1.0"))

	osNamespace.InternVar("lstat", lstat_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("filename"))),
			`Like stat, but if the file is a symbolic link, the result describes the symbolic link.`, "1.0"))

	osNamespace.InternVar("mkdir", mkdir_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("perm"))),
			`Creates a new directory with the specified name and permission bits.`, "1.0"))

	osNamespace.InternVar("mkdir-all", mkdir_all_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("perm"))),
			`Creates a directory named path, along with any necessary parents, and returns nil, or else throws an error.
  The permission bits perm (before umask) are used for all directories that mkdir-all creates.
  If path is already a directory, mkdir-all does nothing and returns nil.`, "1.0"))

	osNamespace.InternVar("mkdir-temp", mkdir_temp_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("dir"), MakeSymbol("pattern"))),
			`Creates a new temporary directory in the directory dir.
  The directory name is generated by taking pattern and applying a random string to the end.
  If pattern includes a "*", the random string replaces the last "*".
  Returns the name of the new directory. If dir is the empty string,
  uses the default directory for temporary files (see joker.os/temp-dir).
  Multiple programs calling joker.os/mkdir-temp simultaneously will not choose the same directory.
  It is the caller's responsibility to remove the directory when no longer needed.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("open", open_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"))),
			`Opens the named file for reading. If successful, the file can be used for reading;
  the associated file descriptor has mode O_RDONLY.`, "1.0").Plus(MakeKeyword("tag"), String{S: "File"}))

	osNamespace.InternVar("pagesize", pagesize_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the underlying system's memory page size.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("path-separator?", ispath_separator_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("c"))),
			`Reports whether c is a directory separator character.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Boolean"}))

	osNamespace.InternVar("pid", pid_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the process id of the caller.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("ppid", ppid_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the process id of the caller's parent.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("read-link", read_link_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"))),
			`Returns the destination of the named symbolic link.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("remove", remove_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"))),
			`Removes the named file or (empty) directory.`, "1.0"))

	osNamespace.InternVar("remove-all", remove_all_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("path"))),
			`Removes path and any children it contains.

  It removes everything it can, then panics with the first error (if
  any) it encountered.`, "1.0"))

	osNamespace.InternVar("rename", rename_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("oldpath"), MakeSymbol("newpath"))),
			`Renames (moves) oldpath to newpath. If newpath already exists and is not a directory, rename replaces it.`, "1.0"))

	osNamespace.InternVar("set-env", set_env_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("key"), MakeSymbol("value"))),
			`Sets the value of the environment variable named by the key.`, "1.0"))

	osNamespace.InternVar("sh", sh_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("&"), MakeSymbol("arguments"))),
			`Executes the named program with the given arguments. Returns a map with the following keys:
      :success - whether or not the execution was successful,
      :err-msg (present iff :success if false) - string capturing error object returned by Go runtime
      :exit - exit code of program (or attempt to execute it),
      :out - string capturing stdout of the program,
      :err - string capturing stderr of the program.`, "1.0"))

	osNamespace.InternVar("sh-from", sh_from_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("dir"), MakeSymbol("name"), MakeSymbol("&"), MakeSymbol("arguments"))),
			`Executes the named program with the given arguments and working directory set to dir.
  Returns a map with the following keys:
      :success - whether or not the execution was successful,
      :err-msg (present iff :success if false) - string capturing error object returned by Go runtime
      :exit - exit code of program (or attempt to execute it),
      :out - string capturing stdout of the program,
      :err - string capturing stderr of the program.`, "1.0"))

	osNamespace.InternVar("signal", signal_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("pid"), MakeSymbol("signal"))),
			`Sends signal to the process with the given PID.`, "1.0.1"))

	osNamespace.InternVar("start", start_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("opts"))),
			`Starts a new process with the program specified by name.
  opts is a map with the same keys as in exec.
  Doesn't wait for the process to finish.
  Returns the process's PID.`, "1.0.1").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("stat", stat_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("filename"))),
			`Returns a map describing the named file. The info map has the following attributes:
  :name - base name of the file
  :size - length in bytes for regular files; system-dependent for others
  :mode - file mode bits
  :modtime - modification time
  :dir? - true if file is a directory`, "1.0"))

	osNamespace.InternVar("symlink", symlink_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("oldname"), MakeSymbol("newname"))),
			`Creates newname as a symbolic link to oldname.`, "1.0"))

	osNamespace.InternVar("temp-dir", temp_dir_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the default directory to use for temporary files.
  On Unix systems, it returns $TMPDIR if non-empty, else /tmp.
  On Windows, it uses GetTempPath, returning the first non-empty
  value from %TMP%, %TEMP%, %USERPROFILE%, or the Windows directory.
  The directory is neither guaranteed to exist nor have accessible permissions.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("truncate", truncate_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("name"), MakeSymbol("size"))),
			`Changes the size of the named file. If the file is a symbolic link, it changes the size of the link's target.`, "1.0"))

	osNamespace.InternVar("uid", uid_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the numeric user id of the caller.`, "1.0").Plus(MakeKeyword("tag"), String{S: "Int"}))

	osNamespace.InternVar("unset-env", unset_env_,
		MakeMeta(
			NewListFrom(NewVectorFrom(MakeSymbol("key"))),
			`Unsets a single environment variable.`, "1.0"))

	osNamespace.InternVar("user-cache-dir", user_cache_dir_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the default root directory to use for user-specific cached data.
  Users should create their own application-specific subdirectory within this one and use that.

  On Unix systems, it returns $XDG_CACHE_HOME as specified by https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html
  if non-empty, else $HOME/.cache. On Darwin, it returns $HOME/Library/Caches. On Windows, it returns %LocalAppData%.
  On Plan 9, it returns $home/lib/cache.

  If the location cannot be determined (for example, $HOME is not defined), then it will throw an error.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("user-config-dir", user_config_dir_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the default root directory to use for user-specific configuration data.
  Users should create their own application-specific subdirectory within this one and use that.

  On Unix systems, it returns $XDG_CONFIG_HOME as specified by https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html
  if non-empty, else $HOME/.config. On Darwin, it returns $HOME/Library/Application Support. On Windows, it returns %AppData%.
  On Plan 9, it returns $home/lib.

  If the location cannot be determined (for example, $HOME is not defined), then it will throw an error.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

	osNamespace.InternVar("user-home-dir", user_home_dir_,
		MakeMeta(
			NewListFrom(NewVectorFrom()),
			`Returns the current user's home directory.

  On Unix, including macOS, it returns the $HOME environment variable. On Windows, it returns %USERPROFILE%.
  On Plan 9, it returns the $home environment variable.`, "1.0").Plus(MakeKeyword("tag"), String{S: "String"}))

}
