var __index = {"config":{"lang":["en"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"]},"docs":[{"location":"index.html","title":"Jujutsu\u2014a version control system","text":""},{"location":"index.html#welcome-to-jjs-documentation-website","title":"Welcome to <code>jj</code>'s documentation website!","text":"<p>The complete list of the available documentation pages is located in the sidebar on the left of the page. The sidebar may be hidden; if so, you can open it either by widening your browser window or by clicking on the hamburger menu that appears in this situation.</p> <p>Additional help is available using the <code>jj help</code> command if you have <code>jj</code> installed.</p> <p>You may want to jump to:</p> <ul> <li>Documentation for the latest released version of <code>jj</code>.</li> <li>Documentation for the unreleased version of <code>jj</code>. This version of the docs corresponds to the <code>main</code> branch of the <code>jj</code> repo.</li> </ul>"},{"location":"index.html#some-useful-links","title":"Some useful links","text":"<ul> <li>GitHub repo for <code>jj</code></li> <li>Overview of <code>jj</code> in the repo's README</li> <li>Installation and setup</li> <li>Tutorial and bird's eye view</li> <li>Working with Gerrit</li> <li>Working with GitHub</li> <li>Development roadmap</li> <li>Changelog</li> </ul>"},{"location":"FAQ.html","title":"Frequently asked questions","text":""},{"location":"FAQ.html#why-does-my-bookmark-not-move-to-the-new-commit-after-jj-newcommit","title":"Why does my bookmark not move to the new commit after <code>jj new/commit</code>?","text":"<p>If you're familiar with Git, you might expect the current bookmark to move forward when you commit. However, Jujutsu does not have a concept of a \"current bookmark\".</p> <p>To move bookmarks, use <code>jj bookmark move</code>.</p>"},{"location":"FAQ.html#i-made-a-commit-and-jj-git-push-all-says-nothing-changed-instead-of-pushing-it-what-do-i-do","title":"I made a commit and <code>jj git push --all</code> says \"Nothing changed\" instead of pushing it. What do I do?","text":"<p><code>jj git push --all</code> pushes all bookmarks, not all revisions. You have two options:</p> <ul> <li>Using <code>jj git push --change</code> will automatically create a bookmark and push it.</li> <li>Using <code>jj bookmark</code> commands to create or move a bookmark to either the commit   you want to push or a descendant of it. Unlike Git, Jujutsu doesn't do this   automatically (see previous question).</li> </ul>"},{"location":"FAQ.html#where-is-my-commit-why-is-it-not-visible-in-jj-log","title":"Where is my commit, why is it not visible in <code>jj log</code>?","text":"<p>Is your commit visible with <code>jj log -r 'all()'</code>?</p> <p>If yes, you should be aware that <code>jj log</code> only shows a subset of the commits in the repo by default. Most commits that exist on a remote are not shown. Local commits and their immediate parents (for context) are shown. The thinking is that you are more likely to interact with this set of commits. You can configure the set of revisions to show by default by overriding <code>revsets.log</code> as described in config.</p> <p>If not, the revision may have been abandoned (e.g. because you used <code>jj abandon</code>, or because it's an obsolete version that's been rewritten with <code>jj rebase</code>, <code>jj describe</code>, etc). In that case, <code>jj log -r commit_id</code> should show the revision as \"hidden\". <code>jj new commit_id</code> should make the revision visible again.</p> <p>See revsets and templates for further guidance.</p>"},{"location":"FAQ.html#what-are-elided-revisions-in-the-output-of-jj-log-how-can-i-display-them","title":"What are elided revisions in the output of <code>jj log</code>? How can I display them?","text":"<p>\"Elided revisions\" appears in the log when one revision descends from another, both are in the revset, but the revisions connecting them are not in the revset.</p> <p>For example, suppose you log the revset <code>tyl|mus</code> which contains exactly two revisions:</p> <pre><code>$  jj log -r 'tyl|mus'\n\u25cb  musnqzvt me@example.com 1 minute ago 9a09f8a5\n\u2502  Revision C\n~  (elided revisions)\n\u25cb  tylynnzk me@example.com 1 minute ago f26967c8\n\u2502  Revision A\n</code></pre> <p>Only the two revisions in the revset are displayed. The text \"(elided revisions)\" is shown to indicate that <code>musnqzvt</code> descends from <code>tylynnzk</code>, but the nodes connecting them are not in the revset.</p> <p>To view the elided revisions, change the revset expression so it includes the connecting revisions. The <code>connected()</code> revset function does exactly this:</p> <pre><code>$ jj log -r 'connected(tyl|mus)'\n\u25cb  musnqzvt me@example.com 43 seconds ago 9a09f8a5\n\u2502  Revision C\n\u25cb  rsvnrznr me@example.com 43 seconds ago 5b490f30\n\u2502  Revision B\n\u25cb  tylynnzk me@example.com 43 seconds ago f26967c8\n\u2502  Revision A\n</code></pre>"},{"location":"FAQ.html#how-can-i-get-jj-log-to-show-me-what-git-log-would-show-me","title":"How can I get <code>jj log</code> to show me what <code>git log</code> would show me?","text":"<p>Use <code>jj log -r ..</code>. The <code>..</code> operator lists all visible commits in the repo, excluding the root (which is never interesting and is shared by all repos).</p>"},{"location":"FAQ.html#can-i-monitor-how-jj-log-evolves","title":"Can I monitor how <code>jj log</code> evolves?","text":"<p>The simplest way to monitor how the history as shown by <code>jj log</code> evolves is by using the watch(1) command (or hwatch or viddy). For example:</p> <pre><code>watch --color jj --ignore-working-copy log --color=always\n</code></pre> <p>This will continuously update the (colored) log output in the terminal. The <code>--ignore-working-copy</code> option avoids conflicts with manual operations during the creation of snapshots. Martin used watch in a tmux pane during his presentation Jujutsu - A Git-compatible VCS.</p> <p>A similar result can be achieved with watchexec, which triggers on op log changes instead of using a two-second interval:</p> <pre><code>watchexec --quiet --clear --restart --watch=.jj/repo/op_heads/heads --ignore-nothing --wrap-process=none -- jj --ignore-working-copy log\n</code></pre> <p>Alternatively, you can use jj-fzf, where the central piece is the <code>jj log</code> view and common operations can be carried out via key bindings while the log view updates.</p> <p>The wiki lists additional TUIs and GUIs beyond the terminal: GUI-and-TUI</p>"},{"location":"FAQ.html#should-i-colocate-my-repository","title":"Should I colocate my repository?","text":"<p>Colocating a Jujutsu repository allows you to use both Jujutsu and Git in the same working copy. The benefits of doing so are:</p> <ul> <li> <p>You can use Git commands when you're not sure how to do something with   Jujutsu, Jujutsu hasn't yet implemented a feature (e.g., tagging), or you   simply prefer Git in some situations.</p> </li> <li> <p>Tooling that expects a Git repository still works (IDEs, build tooling, etc.)</p> </li> </ul> <p>The colocation documentation describes the drawbacks but the most important ones are:</p> <ul> <li> <p>Interleaving <code>git</code> and <code>jj</code> commands may create confusing bookmark conflicts   or divergent changes.</p> </li> <li> <p>If the working copy commit or its parent contain any conflicted files, tools   expecting a Git repo may interpret the commit contents or its diff in a wrong   and confusing way. You should avoid doing mutating operations with Git tools   and ignore the confusing information such tools present for conflicted commits   (unless you are curious about the details of how <code>jj</code> stores   conflicts). See   #3979 for plans to improve   this situation.</p> </li> <li> <p>Jujutsu commands may be a little slower in very large repositories due to   importing and exporting changes to Git. Most repositories are not noticeably   affected by this.</p> </li> </ul> <p>If you primarily use Jujutsu to modify the repository, the drawbacks are unlikely to affect you. Try colocating while you learn Jujutsu, then switch if you find a specific reason not to colocate.</p>"},{"location":"FAQ.html#jj-is-said-to-record-the-working-copy-after-jj-log-and-every-other-command-where-can-i-see-these-automatic-saves","title":"<code>jj</code> is said to record the working copy after <code>jj log</code> and every other command. Where can I see these automatic \"saves\"?","text":"<p>Indeed, every <code>jj</code> command updates the current \"working-copy\" revision, marked with <code>@</code> in <code>jj log</code>. You can notice this by how the commit ID of the working copy revision changes when it's updated. Note that, unless you move to another revision (with <code>jj new</code> or <code>jj edit</code>, for example), the change ID will not change.</p> <p>If you expected to see a historical view of your working copy changes in the parent-child relationships between commits you can see in <code>jj log</code>, this is simply not what they mean. What you can see in <code>jj log</code> is that after the working copy commit gets amended (after any edit), the commit ID changes.</p> <p>You can see the actual history of working copy changes using <code>jj evolog</code>. This will show the history of the commits that were previously the \"working-copy commit\", since the last time the change id of the working copy commit changed. The obsolete changes will be marked as \"hidden\". They are still accessible with any <code>jj</code> command (<code>jj diff</code>, for example), but you will need to use the commit id to refer to hidden commits.</p> <p>You can also use <code>jj evolog -r</code> on revisions that were previously the working-copy revisions (or on any other revisions). Use <code>jj evolog -p</code> as an easy way to see the evolution of the commit's contents.</p>"},{"location":"FAQ.html#can-i-prevent-jujutsu-from-recording-my-unfinished-work-im-not-ready-to-commit-it","title":"Can I prevent Jujutsu from recording my unfinished work? I'm not ready to commit it.","text":"<p>Jujutsu automatically records new files in the current working-copy commit and doesn't provide a way to prevent that.</p> <p>However, you can easily record intermediate drafts of your work. If you think you might want to go back to the current state of the working-copy commit, simply use <code>jj new</code>. There's no need for the commit to be \"finished\" or even have a description.</p> <p>Then future edits will go into a new working-copy commit on top of the now former working-copy commit. Whenever you are happy with another set of edits, use <code>jj squash</code> to amend the previous commit.</p> <p>If you have changes you never want to put in a public commit, see: How can I keep my scratch files in the repository without committing them?</p> <p>For more options see the next question.</p>"},{"location":"FAQ.html#can-i-interactively-create-a-new-commit-from-only-some-of-the-changes-in-the-working-copy-like-git-add-p-git-commit-or-hg-commit-i","title":"Can I interactively create a new commit from only some of the changes in the working copy, like <code>git add -p &amp;&amp; git commit</code> or <code>hg commit -i</code>?","text":"<p>Since the changes are already in the working-copy commit, the equivalent to <code>git add -p &amp;&amp; git commit</code>/<code>git commit -p</code>/<code>hg commit -i</code> is to split the working-copy commit with <code>jj split -i</code> (or the practically identical <code>jj commit -i</code>).</p> <p>For the equivalent of <code>git commit --amend -p</code>/<code>hg amend -i</code>, use <code>jj squash -i</code>.</p>"},{"location":"FAQ.html#is-there-something-like-git-rebase-interactive-or-hg-histedit","title":"Is there something like <code>git rebase --interactive</code> or <code>hg histedit</code>?","text":"<p>It is often sufficient to use some form of <code>jj rebase</code> with <code>-A/-B</code>. For example, if you have a linear chain of revisions <code>A</code> through <code>C</code> and want to move <code>C</code> before <code>B</code>, use <code>jj rebase -r C -B B</code>. See <code>jj help rebase</code> for more examples.</p> <p>There is a tracking issue you can check for updates.</p> <p>To squash or split commits, use <code>jj squash</code> and <code>jj split</code>.</p>"},{"location":"FAQ.html#how-can-i-keep-my-scratch-files-in-the-repository-without-committing-them","title":"How can I keep my scratch files in the repository without committing them?","text":"<p>You can set <code>snapshot.auto-track</code> to only start tracking new files matching the configured pattern (e.g. <code>\"none()\"</code>). Changes to already tracked files will still be snapshotted by every command. Files not matching the pattern can be tracked with <code>jj file track</code>.</p> <p>You can keep your notes and other scratch files in the repository, if you add a wildcard pattern to either the repo's <code>gitignore</code> or your global <code>gitignore</code>. Something like <code>*.scratch</code> or <code>*.scratchpad</code> should do, after that rename the files you want to keep around to match the pattern.</p> <p>If you keep your scratch files in their own directory with no tracked files, you can create a <code>.gitignore</code> file in that directory containing only <code>*</code>. This will ignore everything in the directory including the <code>.gitignore</code> file itself.</p> <p>If <code>$EDITOR</code> integration is important, something like <code>scratchpad.*</code> may be more helpful, as you can keep the filename extension intact (it matches <code>scratchpad.md</code>, <code>scratchpad.rs</code> and more). Another option is to add a directory to the global <code>.gitignore</code> which then stores all your temporary files and notes. For example, you could add <code>scratch/</code> to <code>~/.git/ignore</code> and then store arbitrary files in <code>&lt;your-git-repo&gt;/scratch/</code>.</p> <p>You can find more details on <code>gitignore</code> files here.</p>"},{"location":"FAQ.html#how-can-i-avoid-committing-my-local-only-changes-to-tracked-files","title":"How can I avoid committing my local-only changes to tracked files?","text":"<p>Suppose your repository tracks a file like <code>secret_config.json</code>, and you make some changes to that file to work locally. Since Jujutsu automatically commits the working copy, there's no way to prevent Jujutsu from committing changes to the file. But, you never want to push those changes to the remote repository.</p> <p>One solution is to keep these changes in a separate commit branched from the trunk. To use those changes in your working copy, merge the private commit into your branch.</p> <p>Suppose you have a commit \"Add new feature\":</p> <pre><code>$ jj log\n@  xxxxxxxx me@example.com 2024-08-21 11:13:21 ef612875\n\u2502  Add new feature\n\u25c9  yyyyyyyy me@example.com 2024-08-21 11:13:09 main b624cf12\n\u2502  Existing work\n~\n</code></pre> <p>First, create a new commit branched from main and add your private changes:</p> <pre><code>$ jj new main -m \"private: my credentials\"\nWorking copy  (@) now at: wwwwwwww 861de9eb (empty) private: my credentials\nParent commit (@-)      : yyyyyyyy b624cf12 main | Existing work\nAdded 0 files, modified 1 files, removed 0 files\n\n$ echo '{ \"password\": \"p@ssw0rd1\" }' &gt; secret_config.json\n</code></pre> <p>Now create a merge commit with the branch you're working on and the private commit:</p> <pre><code>$ jj new xxxxxxxx wwwwwwww\nWorking copy  (@) now at: vvvvvvvv ac4d9fbe (empty) (no description set)\nParent commit (@-)      : xxxxxxxx ef612875 Add new feature\nParent commit (@-)      : wwwwwwww 2106921e private: my credentials\nAdded 0 files, modified 1 files, removed 0 files\n\n$ jj log\n@    vvvvvvvv me@example.com 2024-08-22 08:57:40 ac4d9fbe\n\u251c\u2500\u256e  (empty) (no description set)\n\u2502 \u25c9  wwwwwwww me@example.com 2024-08-22 08:57:40 2106921e\n\u2502 \u2502  private: my credentials\n\u25c9 \u2502  xxxxxxxx me@example.com 2024-08-21 11:13:21 ef612875\n\u251c\u2500\u256f  Add new feature\n\u25c9  yyyyyyyy me@example.com 2024-08-21 11:13:09 main b624cf12\n\u2502  Existing work\n~\n</code></pre> <p>Now you're ready to work:</p> <ul> <li>Your work in progress xxxxxxxx is the first parent of the merge commit.</li> <li>The private commit wwwwwwww is the second parent of the merge commit.</li> <li>The working copy (vvvvvvvv) contains changes from both.</li> </ul> <p>As you work, squash your changes using <code>jj squash --into xxxxxxxx</code>.</p> <p>If you need a new empty commit on top of <code>xxxxxxxx</code> you can use the <code>--insert-after</code> and <code>--insert-before</code> options (<code>-A</code> and <code>-B</code> for short):</p> <pre><code># Insert a new commit after xxxxxxxx\n$ jj new --no-edit -A xxxxxxxx -m \"Another feature\"\nWorking copy  (@) now at: uuuuuuuu 1c3cff09 (empty) Another feature\nParent commit (@-)      : xxxxxxxx ef612875 Add new feature\n\n# Insert a new commit between yyyyyyyy and vvvvvvvv\n$ jj new --no-edit -A yyyyyyyy -B vvvvvvvv -m \"Yet another feature\"\nWorking copy  (@) now at: tttttttt 938ab831 (empty) Yet another feature\nParent commit (@-)      : yyyyyyyy b624cf12 Existing work\n</code></pre> <p>To avoid pushing change wwwwwwww by mistake, use the configuration git.private-commits:</p> <pre><code>jj config set --user git.private-commits \"'''description('private:*')'''\"\n</code></pre>"},{"location":"FAQ.html#i-accidentally-changed-files-in-the-wrong-commit-how-do-i-move-the-recent-changes-into-another-commit","title":"I accidentally changed files in the wrong commit, how do I move the recent changes into another commit?","text":"<p>Let's say we are editing a commit for \"featureA\", and we forgot to run <code>jj new</code> or <code>jj commit</code> before doing some work that belongs in a new commit:</p> <pre><code>$ jj log\n@  lnvvtrzo jjfan@example.org 2025-02-28 21:01:10 31a347e0\n\u2502  featureA\n\u25c6  zzzzzzzz root() 00000000\n$ cat file  # Oh no, the work on \"feature B\" should be in a separate commit!\nDone with feature A\nWorking on feature B\n</code></pre> <p>The goal is to restore change <code>lnvvtrzo</code> to its previous state and split the difference into a new child commit.</p>"},{"location":"FAQ.html#step-1-find-the-commit-id-for-the-last-good-version","title":"Step 1: Find the commit ID for the \"last good version\"","text":"<p>If you pushed <code>lnvvtrzo</code> already, then the version you probably want to restore is the version on the remote. For example, if the bookmark is <code>feature-a</code>, then the commit you want to restore is <code>feature-a@origin</code>.</p> <p>Otherwise, you can find all the past versions of the working copy revision that <code>jj</code> has saved by running <code>jj evolog</code>, perhaps with the <code>--patch</code> option. The obsolete versions will be marked as \"hidden\" and will have the same change ID, but will have different commit IDs. This represents the change evolving over time.</p> <p>For example, this is what the evolog might look like after you made two edits to the same change:</p> <pre><code>$ # Note the word \"hidden\", the commit IDs on the right,\n$ # and the unchanging change ID on the left.\n$ jj evolog\n@  lnvvtrzo jjfan@example.org 2025-02-28 21:01:10 31a347e0\n\u2502  featureA\n\u2502  -- operation 3cb7392c092c snapshot working copy\n\u25cb  lnvvtrzo/1 jjfan@example.org 2025-02-28 21:00:51 b8004ab8 (hidden)\n\u2502  featureA\n\u2502  -- operation 1280bfaec893 snapshot working copy\n\u25cb  lnvvtrzo/2 jjfan@example.org 2025-02-28 20:50:05 e4d831d (hidden)\n   (no description set)\n   -- operation 0418a5aa94b5 snapshot working copy\n</code></pre> <p>Since commit <code>b800</code> is hidden, it is considered obsolete and <code>jj log</code> (without arguments) will not show it. However, most <code>jj</code> operations work normally on such commits if you refer to them by their commit ID. Hidden commits can also be referred to by their change ID, but they require a change offset to distinguish them (e.g. <code>b800</code> can also be referred to as <code>lnv/1</code>, as shown in the evolog).</p> <p>To find out which of these versions is the last time before we started working on feature B (the point where we should have created a new change, but failed to do so), we can look at the actual changes between the <code>evolog</code> commits by running <code>jj evolog --patch</code>:</p> <pre><code>$ # When was the last saved point before we started working on feature B?\n$ jj evolog --patch --git  # We use `--git` to make diffs clear without colors\n@  lnvvtrzo jjfan@example.org 2025-02-28 21:01:10 31a347e0\n\u2502  featureA\n\u2502  -- operation 3cb7392c092c snapshot working copy\n\u2502  diff --git a/file b/file\n\u2502  index 2b455c4207..2a7e05a01a 100644\n\u2502  --- a/file\n\u2502  +++ b/file\n\u2502  @@ -1,1 +1,2 @@\n\u2502   Done with feature A\n\u2502  +Working on feature B\n\u25cb  lnvvtrzo/1 jjfan@example.org 2025-02-28 21:00:51 b8004ab8 (hidden)\n\u2502  featureA\n\u2502  -- operation 1280bfaec893 snapshot working copy\n\u2502  diff --git a/file b/file\n\u2502  index cb61245109..2b455c4207\n\u2502  --- a/file\n\u2502  +++ b/file\n\u2502  @@ -1,1 +1,1 @@\n\u2502  -Working on feature A\n\u2502  +Done with feature A\n\u25cb  lnvvtrzo/2 jjfan@example.org 2025-02-28 20:50:05 e4d831d (hidden)\n   (no description set)\n   -- operation 0418a5aa94b5 snapshot working copy\n   diff --git a/file b/file\n   index 0000000000..cb61245109\n   --- /dev/null\n   +++ b/file\n   @@ 0,0 +1,1 @@\n   +Working on feature A\n</code></pre> <p>In this example, the version of the change when we were actually done with feature A is when we edited the file to say \"Done with feature A\". This state was saved in the commit with ID <code>b80</code> (the second one in the list). The following edit (commit <code>31a</code>) belongs in a new change.</p>"},{"location":"FAQ.html#step-2-create-a-new-change-on-top-of-the-original-revision","title":"Step 2: Create a new change on top of the original revision","text":"<p>The \"featureA\" change is currently at commit <code>31a</code>:</p> <pre><code>$ jj log\n@  lnvvtrzo jjfan@example.org 2025-02-28 21:01:10 31a347e0\n\u2502  featureA\n\u25c6  zzzzzzzz root() 00000000\n</code></pre> <p>We'd like to create a new \"featureB\" change with the contents of the current commit <code>31a</code>, and we'd like the \"featureA\" change to be reverted to its former state at commit <code>b80</code> (see step 1 above for how we found that commit ID).</p> <p>First, we create a new empty child commit on top of <code>b80</code>:</p> <pre><code>$ jj new b80 -m \"featureB\"\nWorking copy  (@) now at: pvnrkl 47171aa (empty) featureB\nParent commit (@-)      : lnvvtr/1 b8004ab (divergent) featureA\n</code></pre> <p>There are now two visible commits with change ID <code>lnvvtr</code> (commit <code>b8004ab</code> and <code>31a347e0</code>), so we call these divergent. Similarly to hidden commits, divergent commits also require a change offset when using the change ID to refer to them, so you can see that <code>b8004ab</code> is still shown as <code>lnvvtr/1</code> in the output. This temporary divergence is okay and will be resolved in the next steps.</p> <p>Next, restore the contents of <code>31a347e0</code> into the working copy:</p> <pre><code>$ jj restore --from 31a347e0\nWorking copy  (@) now at: pvnrkl 468104c featureB\nParent commit (@-)      : lnvvtr/1 b8004ea (divergent) featureA\n$ cat file\nDone with feature A\nWorking on feature B\n</code></pre>"},{"location":"FAQ.html#step-3-move-any-bookmarks-to-the-original-revision","title":"Step 3: Move any bookmarks to the original revision","text":"<pre><code>$ jj bookmark move --from 31a347e0 --to b8004ea8\n</code></pre>"},{"location":"FAQ.html#step-4-abandon-the-unwanted-revision","title":"Step 4: Abandon the unwanted revision","text":"<pre><code>$ jj abandon 31a347e0\n</code></pre> <p>Now, we have achieved the exact state we desired:</p> <pre><code>$ jj log -p --git\n@  pvnrklkn jjfan@example.org 2025-02-28 21:39:29 468104c2\n\u2502  featureB\n\u2502  diff --git a/file b/file\n\u2502  index 2b455c4207..2a7e05a01a 100644\n\u2502  --- a/file\n\u2502  +++ b/file\n\u2502  @@ -1,1 +1,2 @@\n\u2502   Done with feature A\n\u2502  +Working on feature B\n\u25cb  lnvvtrzo jjfan@example.org 2025-02-28 21:00:51 b8004ab8\n\u2502  featureA\n\u2502  diff --git a/file b/file\n\u2502  new file mode 100644\n\u2502  index 0000000000..2b455c4207\n\u2502  --- /dev/null\n\u2502  +++ b/file\n\u2502  @@ -0,0 +1,1 @@\n\u2502  +Done with feature A\n\u25c6  zzzzzzzz root() 00000000\n$ jj diff --from b80 --to @- # No output means these are identical\n$ jj diff --from 31a --to @  # No output means these are identical\n</code></pre>"},{"location":"FAQ.html#how-do-i-resume-working-on-an-existing-change","title":"How do I resume working on an existing change?","text":"<p>There are two ways to resume working on an earlier change: <code>jj new</code> then <code>jj squash</code>, and <code>jj edit</code>. The first is generally recommended, but <code>jj edit</code> can be useful. When you use <code>jj edit</code>, the revision is directly amended with your new changes, making it difficult to tell what exactly you change. You should avoid using <code>jj edit</code> when the revision has a conflict, as you may accidentally break the plain-text annotations on your state without realizing.</p> <p>To start, use <code>jj new &lt;rev&gt;</code> to create a change based on that earlier revision. Make your edits, then use <code>jj squash</code> to update the earlier revision with those edits. For when you would use git stashing, use <code>jj edit &lt;rev&gt;</code> for expected behavior. Other workflows may prefer <code>jj edit</code> as well.</p>"},{"location":"FAQ.html#why-are-most-merge-commits-marked-as-empty","title":"Why are most merge commits marked as \"(empty)\"?","text":"<p>Jujutsu, like Git, is a snapshot-based VCS. That means that each commit logically records the state of all current files in the repo. The changes in a commit are not recorded but are instead calculated when needed by comparing the commit's state to the parent commit's state. Jujutsu defines the changes in a commit to be relative to the auto-merged parents (if there's only one parent, then that merge is trivial - it's the parent commit's state). As a result, a merge commit that was a clean merge (no conflict resolution, no additional changes) is considered empty. Conversely, if the merge commit contains conflict resolutions or additional changes, then it will be considered non-empty.</p> <p>This definition of the changes in a commit is used throughout Jujutsu. It's used by <code>jj diff -r</code> and <code>jj log -p</code> to show the changes in a commit. It's used by <code>jj rebase</code> to rebase the changes in a commit. It's used in <code>jj log</code> to indicate which commits are empty. It's used in the <code>files()</code> revset function (and by <code>jj log &lt;path&gt;</code>) to find commits that modify a certain path. And so on.</p>"},{"location":"FAQ.html#how-do-i-revert-a-merge-commit-jj-revert-r-merge-does-nothing","title":"How do I revert a merge commit? <code>jj revert -r &lt;merge&gt;</code> does nothing","text":"<p>Jujutsu defines the changes in a merge commit (and non-merge commits) as the changes made compared to the auto-merged parents. That means that merge commits are often empty. As a result, <code>jj revert</code> or a merge commit often results in an empty commit. To revert the changes merged in from the second parent, instead use <code>jj restore --from &lt;first parent&gt;</code> .</p> <p>Example:</p> <pre><code>@\n|\nC\n| \\\nB D\n|/\nA\n</code></pre> <p>To revert the merge in <code>C</code>, create a new commit with <code>jj new C</code>, then <code>jj restore --from B</code>, and then describe the message with something like <code>jj desc -m \"Revert the merge of D into B</code>. Now, commit <code>@</code> undoes the merge of <code>D</code> into  <code>B</code>. If necessary, you can now rebase it elsewhere, e.g. <code>jj rebase -r @ -o main</code>.</p>"},{"location":"FAQ.html#how-do-i-deal-with-divergent-changes","title":"How do I deal with divergent changes?","text":"<p>See: Handling divergent commits.</p>"},{"location":"FAQ.html#how-do-i-deal-with-conflicted-bookmarks-after-bookmark-name","title":"How do I deal with conflicted bookmarks ('??' after bookmark name)?","text":"<p>A conflicted bookmark is a bookmark that refers to multiple different commits because jj couldn't fully resolve its desired position. Resolving conflicted bookmarks is usually done by setting the bookmark to the correct commit using <code>jj bookmark move &lt;name&gt; --to &lt;commit ID&gt;</code>.</p> <p>Usually, the different commits associated with the conflicted bookmark should all appear in the log, but if they don't you can use <code>jj bookmark list</code>to show all the commits associated with it.</p>"},{"location":"FAQ.html#im-experiencing-jj-command-issues-in-a-vitevitest-project-how-do-i-fix-this","title":"I'm experiencing <code>jj</code> command issues in a Vite/Vitest project, how do I fix this?","text":"<p>When using Vite or Vitest in a Jujutsu repository, you may experience:</p> <ul> <li>Very slow vitest startup times</li> <li>Timeout errors in <code>jj</code> terminal commands</li> <li>Errors with 3rd party visual tools like <code>jjk</code> or <code>visual-jj</code></li> <li>Corrupted <code>working_copy.lock</code> files</li> </ul> <p>This happens because Vite watches the <code>.jj</code> directory where Jujutsu stores its internal state. This creates unnecessary overhead as Vite processes Jujutsu's frequent internal file changes, which can slow down both tools and occasionally cause file access conflicts.</p> <p>Solution: Configure Vite to ignore the <code>.jj</code> directory by adding it to the <code>server.watch.ignored</code> array inside your Vite configuration, for example:</p> <pre><code>// vite.config.js\nexport default defineConfig({\n  // ... other config like plugins, test setup, etc.\n  server: {\n    watch: {\n      ignored: [\n        \"**/.jj/**\",\n      ]\n    }\n  },\n})\n</code></pre> <p>Note: There was a request to include <code>.jj</code> in the default ignore list, but manual configuration remains the recommended approach.</p>"},{"location":"FAQ.html#i-want-to-write-a-tool-which-integrates-with-jujutsu-should-i-use-the-library-or-parse-the-cli","title":"I want to write a tool which integrates with Jujutsu. Should I use the library or parse the CLI?","text":"<p>There are some trade-offs and there is no definitive answer yet.</p> <ul> <li>Using <code>jj-lib</code> avoids parsing command output and makes error handling easier.</li> <li><code>jj-lib</code> is not a stable API, so you may have to make changes to your tool when the API changes.</li> <li>The CLI is not stable either, so you may need to make your tool detect the different versions and call the right command.</li> <li>Using the CLI means that your tool will work with custom-built <code>jj</code> binaries, like the one at Google (if you're using the library, you will not be able to detect custom backends and more).</li> </ul>"},{"location":"FAQ.html#why-is-jujutsu-a-separate-project-why-were-the-features-not-contributed-to-git-instead","title":"Why is Jujutsu a separate project? Why were the features not contributed to Git instead?","text":"<p>The project started as an experiment with the idea of representing the working copy by a regular commit. I (@martinvonz) considered how this feature would impact the Git CLI if it were added to Git. My conclusion was that it would effectively result in deprecating most existing Git commands and flags in favor of new commands and flags, especially considering I wanted to also support revsets. This seemed unlikely to be accepted by the Git project.</p>"},{"location":"bookmarks.html","title":"Bookmarks","text":""},{"location":"bookmarks.html#introduction","title":"Introduction","text":"<p>Bookmarks are named pointers to revisions (just like branches are in Git). You can move them without affecting the target revision's identity. Bookmarks automatically move when revisions are rewritten (e.g. by <code>jj rebase</code>). You can pass a bookmark's name to commands that want a revision as argument. For example, <code>jj new main</code> will create a new revision on top of the <code>main</code> bookmark. Use <code>jj bookmark list</code> to list bookmarks and <code>jj bookmark &lt;subcommand&gt;</code> to create, move, or delete bookmarks. There is currently no concept of an active/current/checked-out bookmark.</p>"},{"location":"bookmarks.html#mapping-to-git-branches","title":"Mapping to Git branches","text":"<p>Jujutsu maps its bookmarks to Git branches when interacting with Git repos. For example, <code>jj git push --bookmark foo</code> will push the state of the <code>foo</code> bookmark to the <code>foo</code> branch on the Git remote. Similarly, if you create a <code>bar</code> branch in the backing Git repo, then a subsequent <code>jj git import</code> will create a <code>bar</code> bookmark (reminder: that import happens automatically in colocated workspaces).</p>"},{"location":"bookmarks.html#remotes-and-tracked-bookmarks","title":"Remotes and tracked bookmarks","text":"<p>Jujutsu records the last seen position of a bookmark on each remote (just like Git's remote-tracking branches). This record is updated on every <code>jj git fetch</code> and <code>jj git push</code> of the bookmark. You can refer to the remembered remote bookmark positions with <code>&lt;bookmark name&gt;@&lt;remote name&gt;</code>, such as <code>jj new main@origin</code>. <code>jj</code> does not provide a way to manually edit these recorded positions.</p> <p>A remote bookmark can be associated with a local bookmark of the same name. This is called a tracked remote bookmark (which maps to a Git remote branch when using the Git backend). When you pull a tracked bookmark from a remote, any changes compared to the current record of the remote's state will be propagated to the corresponding local bookmark, which will be created if it doesn't exist already.</p> <p>Details: how <code>fetch</code> pulls bookmarks</p> <p>Let's say you run <code>jj git fetch --remote origin</code> and, during the fetch, <code>jj</code> determines that the remote's <code>main</code> bookmark has been moved so that its target is now ahead of the local record in <code>main@origin</code>.</p> <p><code>jj</code> will then update <code>main@origin</code> to the new target. If <code>main@origin</code> is tracked, <code>jj</code> will also apply the change to the local bookmark <code>main</code>. If the local target has also been moved compared to <code>main@origin</code> (probably because you ran <code>jj bookmark set main</code>), then the two updates will be merged. If one is ahead of the other, then that target will become the new target. Otherwise, the local bookmark will become conflicted (see the \"Conflicts\" section below for details).</p> <p>Most commands don't show the tracked remote bookmark if it has the same target as the local bookmark. The local bookmark (without <code>@&lt;remote name&gt;</code>) is considered the bookmark's desired target. Consequently, if you want to update a bookmark on a remote, you first update the bookmark locally and then push the update to the remote. If a local bookmark also exists on some remote but points to a different target there, <code>jj log</code> will show the bookmark name with an asterisk suffix (e.g. <code>main*</code>). That is meant to remind you that you may want to push the bookmark to some remote.</p> <p>If you want to know the internals of bookmark tracking, consult the Design Doc.</p>"},{"location":"bookmarks.html#terminology-summary","title":"Terminology summary","text":"<ul> <li>A remote bookmark is a bookmark ref on the remote. <code>jj</code> can find out its   actual state only when it's actively communicating with the remote. However,   <code>jj</code> does store the last-seen position of the remote bookmark; this is the   commit <code>jj show &lt;bookmark name&gt;@&lt;remote name&gt;</code> would show. This notion is   completely analogous to Git's \"remote-tracking branches\".</li> <li>A tracked (remote) bookmark is defined above. You can make a remote bookmark   tracked with the <code>jj bookmark track</code> command, for   example.</li> <li>A tracking (local) bookmark is the local bookmark that <code>jj</code> tries to keep   in sync with the tracked remote bookmark. For example, after <code>jj bookmark   track mybookmark --remote=origin</code>, there will be a local bookmark <code>mybookmark</code>   that's tracking the remote <code>mybookmark@origin</code> bookmark. A local bookmark can   track a bookmark of the same name on 0 or more remotes.</li> </ul> <p>The notion of tracked bookmarks serves a similar function to the Git notion of an \"upstream branch\". Unlike Git, a single local bookmark can be tracking remote bookmarks on multiple remotes, and the names of the local and remote bookmarks must match.</p>"},{"location":"bookmarks.html#manually-tracking-a-bookmark","title":"Manually tracking a bookmark","text":"<p>To track a bookmark permanently use <code>jj bookmark track &lt;bookmark name&gt; --remote=&lt;remote name&gt;</code>. It will now be imported as a local bookmark until you untrack it or it is deleted on the remote.</p> <p>Example:</p> <pre><code>$ # List all available bookmarks, as we want our colleague's bookmark.\n$ jj bookmark list --all\n$ # Find the bookmark.\n$ # [...]\n$ # Actually track the bookmark.\n$ jj bookmark track &lt;bookmark name&gt; --remote=&lt;remote name&gt; # Example: jj bookmark track my-feature --remote=origin\n$ # From this point on, &lt;bookmark name&gt; will be imported when fetching from &lt;remote name&gt;.\n$ jj git fetch --remote &lt;remote name&gt;\n$ # A local bookmark &lt;bookmark name&gt; should have been created or updated while fetching.\n$ jj new &lt;bookmark name&gt; # Do some local testing, etc.\n</code></pre>"},{"location":"bookmarks.html#untracking-a-bookmark","title":"Untracking a bookmark","text":"<p>To stop following a remote bookmark, you can <code>jj bookmark untrack</code> it. After that, subsequent fetches of that remote will no longer move the local bookmark to match the position of the remote bookmark.</p> <p>Example:</p> <pre><code>$ # List all local and remote bookmarks.\n$ jj bookmark list --all\n$ # Find the bookmark we no longer want to track.\n$ # [...]\n# # Actually untrack it.\n$ jj bookmark untrack &lt;bookmark name&gt; --remote=&lt;remote name&gt; # Example: jj bookmark untrack stuff --remote=origin\n$ # From this point on, this remote bookmark won't be imported anymore.\n$ # The local bookmark (e.g. stuff) is unaffected. It may or may not still\n$ # be tracking bookmarks on other remotes (e.g. stuff@upstream).\n</code></pre>"},{"location":"bookmarks.html#listing-tracked-bookmarks","title":"Listing tracked bookmarks","text":"<p>To list tracked bookmarks, you can <code>jj bookmark list --tracked</code> or <code>jj bookmark list -t</code>. This command omits local Git-tracking bookmarks by default.</p> <p>You can see if a specific bookmark is tracked with <code>jj bookmark list --tracked &lt;bookmark name&gt;</code>.</p>"},{"location":"bookmarks.html#automatic-tracking-of-bookmarks-auto-track-bookmarks-option","title":"Automatic tracking of bookmarks &amp; <code>auto-track-bookmarks</code> option","text":"<p>There are two situations where <code>jj</code> tracks bookmarks automatically. <code>jj git clone</code> automatically sets up the default remote bookmark (e.g. <code>main@origin</code>) as tracked. When you push a local bookmark, the newly created bookmark on the remote is marked as tracked.</p> <p>By default, every other remote bookmark is marked as \"not tracked\" when it's fetched. If desired, you need to manually <code>jj bookmark track</code> them. This works well for repositories where multiple people work on a large number of bookmarks.</p> <p>The default can be changed by setting the config <code>remotes.&lt;name&gt;.auto-track-bookmarks = \"*\"</code>. Then, <code>jj git fetch</code> tracks every newly fetched bookmark with a local bookmark. Branches that already existed before the <code>jj git fetch</code> are not affected. This is similar to Mercurial, which fetches all its bookmarks (equivalent to Git's branches) by default. Similarly, all newly created local bookmarks will be marked as \"tracked\", preparing them to be pushed with the next <code>jj git push</code> command. See \"Automatic tracking of bookmarks\" for details.</p>"},{"location":"bookmarks.html#bookmark-updates","title":"Bookmark updates","text":"<p>Currently Jujutsu automatically updates local bookmarks when these conditions are met:</p> <ul> <li>When a commit has been rewritten (e.g, when you rebase) bookmarks and the    working-copy will move along with it.</li> <li>When a commit has been abandoned, all associated bookmarks will be deleted.</li> </ul> <p>You could describe the updates as following along the change-id of the current bookmark commit, even if it isn't entirely accurate.</p>"},{"location":"bookmarks.html#pushing-bookmarks-safety-checks","title":"Pushing bookmarks: Safety checks","text":"<p>Before <code>jj git push</code> actually moves, creates, or deletes a remote bookmark, it makes several safety checks.</p> <ol> <li> <p><code>jj</code> will contact the remote and check that the actual state of the remote    bookmark matches <code>jj</code>'s record of its last known position. If there is a    conflict, <code>jj</code> will refuse to push the bookmark. In this case, you need to run    <code>jj git fetch --remote &lt;remote name&gt;</code> and resolve the resulting bookmark    conflict. Then, you can try <code>jj git push</code> again.</p> <p>If you are familiar with Git, this makes <code>jj git push</code> similar to <code>git  push --force-with-lease</code>.</p> <p>There are a few cases where <code>jj git push</code> will succeed even though the remote  bookmark is in an unexpected location. These are the cases where <code>jj git fetch</code>  would not create a bookmark conflict and would not move the local bookmark, e.g.  if the unexpected location is identical to the local position of the bookmark.</p> </li> <li> <p>The local bookmark must not be conflicted. If it is, you would    need to use <code>jj bookmark move</code>, for example, to resolve the conflict.</p> <p>This makes <code>jj git push</code> safe even if <code>jj git fetch</code> is performed on a timer  in the background (this situation is a known issue<sup>1</sup> with some  forms of <code>git push --force-with-lease</code>). If the bookmark moves on a remote in a  problematic way, <code>jj git fetch</code> will create a conflict. This should ensure  that the user becomes aware of the conflict before they can <code>jj git push</code> and  override the bookmark on the remote.</p> </li> <li> <p>If the remote bookmark already exists on the remote, it must be    tracked.</p> </li> </ol>"},{"location":"bookmarks.html#conflicts","title":"Conflicts","text":"<p>Bookmarks can end up in a conflicted state. When that happens, <code>jj status</code> will include information about the conflicted bookmarks (and instructions for how to mitigate it). <code>jj bookmark list</code> will have details. <code>jj log</code> will show the bookmark name with a double question mark suffix (e.g. <code>main??</code>) on each of the conflicted bookmark's potential target revisions. Using the bookmark name to look up a revision will resolve to all potential targets. That means that <code>jj new main</code> will error out, complaining that the revset resolved to multiple revisions.</p> <p>Both local bookmarks (e.g. <code>main</code>) and the remote bookmark (e.g. <code>main@origin</code>) can have conflicts. Both can end up in that state if concurrent operations were run in the repo. The local bookmark more typically becomes conflicted because it was updated both locally and on a remote.</p> <p>To resolve a conflicted state in a local bookmark (e.g. <code>main</code>), you can move the bookmark to the desired target with <code>jj bookmark move</code>. You may want to first either merge the conflicted targets with <code>jj new</code> (e.g. <code>jj new main</code>), or you may want to rebase one side on top of the other with <code>jj rebase</code>.</p> <p>To resolve a conflicted state in a remote bookmark (e.g. <code>main@origin</code>), simply pull from the remote (e.g. <code>jj git fetch</code>). The conflict resolution will also propagate to the local bookmark (which was presumably also conflicted).</p>"},{"location":"bookmarks.html#ease-of-use","title":"Ease of use","text":"<p>The use of bookmarks is frequent in some workflows, for example, when interacting with Git repositories containing branches. To this end, one-letter shortcuts have been implemented, both for the <code>jj bookmark</code> command itself through an alias (as <code>jj b</code>), and for its subcommands. For example, <code>jj bookmark create BOOKMARK-NAME -r@</code> can be abbreviated as <code>jj b c BOOKMARK-NAME -r@</code>.</p> <ol> <li> <p>See \"A general note on safety\" in https://git-scm.com/docs/git-push#Documentation/git-push.txt---no-force-with-lease \u21a9</p> </li> </ol>"},{"location":"changelog.html","title":"Changelog","text":""},{"location":"changelog.html#changelog","title":"Changelog","text":"<p>All notable changes to this project will be documented in this file.</p> <p>The format is based on Keep a Changelog, and this project adheres to Semantic Versioning.</p>"},{"location":"changelog.html#unreleased","title":"Unreleased","text":""},{"location":"changelog.html#release-highlights","title":"Release highlights","text":""},{"location":"changelog.html#breaking-changes","title":"Breaking changes","text":""},{"location":"changelog.html#deprecations","title":"Deprecations","text":""},{"location":"changelog.html#new-features","title":"New features","text":""},{"location":"changelog.html#fixed-bugs","title":"Fixed bugs","text":""},{"location":"changelog.html#0380-2026-02-04","title":"0.38.0 - 2026-02-04","text":""},{"location":"changelog.html#release-highlights_1","title":"Release highlights","text":"<ul> <li>Per-repo and per-workspace config is now stored outside the repo, for security   reasons. This is not a breaking change because we automatically migrate   legacy repos to this new format. <code>.jj/repo/config.toml</code> and   <code>.jj/workspace-config.toml</code> should no longer be used.</li> </ul>"},{"location":"changelog.html#breaking-changes_1","title":"Breaking changes","text":"<ul> <li> <p>The minimum supported <code>git</code> command version is now 2.41.0. macOS users will   need to either upgrade \"Developer Tools\" to 26 or install Git from   e.g. Homebrew.</p> </li> <li> <p>Deprecated <code>ui.always-allow-large-revsets</code> setting and <code>all:</code> revset modifier   have been removed.</p> </li> <li> <p><code>&lt;name&gt;@&lt;remote&gt;</code> revset symbols can also be resolved to remote tags. Tags are   prioritized ahead of bookmarks.</p> </li> <li> <p>Legacy placeholder support used for unset <code>user.name</code> or <code>user.email</code> has been   removed. Commits containing these values will now be pushed with <code>jj git push</code>   without producing an error.</p> </li> <li> <p>If any side of a conflicted file is missing a terminating newline, then the   materialized file in the working copy will no longer be terminated by a   newline.</p> </li> </ul>"},{"location":"changelog.html#deprecations_1","title":"Deprecations","text":"<ul> <li>The revset function <code>diff_contains()</code> has been renamed to <code>diff_lines()</code>.</li> </ul>"},{"location":"changelog.html#new-features_1","title":"New features","text":"<ul> <li> <p><code>jj git fetch</code> now shows details of abandoned commits (change IDs and   descriptions) by default, matching the <code>jj abandon</code> output format.   #3081</p> </li> <li> <p><code>jj workspace root</code> now accepts an optional <code>--name</code> argument to show   the root path of the specified workspace (defaults to the current one). When   given a workspace that was created before this release, it errors out.</p> </li> <li> <p><code>jj git push --bookmark &lt;name&gt;</code> will now automatically track the bookmark if   it isn't tracked with any remote already.</p> </li> <li> <p>Add <code>git_web_url([remote])</code> template function that converts a git remote URL   to a web URL, suitable for opening in a browser. Defaults to the \"origin\"   remote.</p> </li> <li> <p>New <code>divergent()</code> revset function for divergent changes.</p> </li> <li> <p>String pattern values in revsets and templates can now be substituted by   aliases. For example, <code>grep(x) = description(regex:x)</code> now works.</p> </li> <li> <p>A new config option <code>remotes.&lt;name&gt;.auto-track-created-bookmarks</code> behaves   similarly to <code>auto-track-bookmarks</code>, but it only applies to bookmarks created   locally. Setting it to <code>\"*\"</code> is now the closest replacement for the deprecated   <code>git.push-new-bookmarks</code> option.</p> </li> <li> <p><code>jj tag list</code> can now be filtered by revset.</p> </li> <li> <p>Conflict markers will use LF or CRLF as the line ending according to the   contents of the file.   #7376</p> </li> <li> <p>New experimental <code>jj git fetch --tag</code> flag to fetch tags in the same way as   bookmarks. If specified, tags won't be fetched implicitly, and only tags   matching the pattern will be fetched as <code>&lt;name&gt;@&lt;remote&gt;</code> tags. The fetched   remote tags will be tracked by the local tags of the same name.</p> </li> <li> <p>New <code>remote_tags()</code> revset function to query remote tags.</p> </li> <li> <p>New builtin <code>hyperlink()</code> template function that gracefully falls back to   text when outputting to a non-terminal, instead of emitting raw OSC 8 escape   codes. #7592</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_1","title":"Fixed bugs","text":"<ul> <li> <p><code>jj git init --colocate</code> now refuses to run inside a Git worktree, providing   a helpful error message with alternatives.   #8052</p> </li> <li> <p><code>jj git push</code> now ensures that tracked remote bookmarks are updated even if   there are no mappings in the Git fetch refspecs.   #5115</p> </li> <li> <p><code>jj git fetch</code>/<code>push</code> now forwards most of <code>git</code> stderr outputs such as   authentication requests. #5760</p> </li> <li> <p>Conflicted bookmarks and tags in <code>trunk()</code> will no longer generate verbose   warnings. The configured <code>trunk()</code> alias will temporarily be disabled.   #8501</p> </li> <li> <p>Dynamic shell completion for <code>jj config unset</code> now only completes   configuration options which are set.   #7774</p> </li> <li> <p>Dynamic shell completion no longer attempts to resolve aliases at the   completion position. This previously prevented a fully-typed alias from   being accepted on some shells and replaced it entirely with its expansion on   bash. Now, the completion will only resolve the alias, and suggest candidates   accordingly, after the cursor has been advanced to the next position.   #7773</p> </li> <li> <p>Setting the editor via <code>ui.editor</code>, <code>$EDITOR</code>, or <code>JJ_EDITOR</code> now respects shell quoting.</p> </li> <li> <p><code>jj gerrit upload</code> will no longer swallow errors and surface if changes fail   to get pushed to gerrit.   #8568</p> </li> <li> <p><code>jj file track --include-ignored</code> now works when <code>fsmonitor.backend=\"watchman\"</code>.   #8427</p> </li> <li> <p>Conflict labels are now preserved correctly when restoring files from commits   with different conflict labels.</p> </li> <li> <p>The empty tree is now always written when the working copy is empty.   #8480</p> </li> <li> <p>When using the Watchman filesystem monitor, changes to .gitignore now trigger   a scan of the affected subtree so newly unignored files are discovered.   #8427</p> </li> <li> <p><code>--quiet</code> now hides progress bars.</p> </li> </ul>"},{"location":"changelog.html#contributors","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Benjamin Davies (@Benjamin-Davies)</li> <li>Bryce Berger (@bryceberger)</li> <li>Chris Rose (@offbyone)</li> <li>Daniel Morsing (@DanielMorsing)</li> <li>David Fr\u00f6hlingsdorf (@2079884FDavid)</li> <li>David Higgs (@higgsd)</li> <li>David Rieber (@drieber)</li> <li>Federico G. Schwindt (@fgsch)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>George Christou (@gechr)</li> <li>itstrivial</li> <li>Jeff Turner (@jefft)</li> <li>Jonas Greitemann (@jgreitemann)</li> <li>Jonas Helgemo (@jonashelgemo)</li> <li>Joseph Lou (@josephlou5)</li> <li>Kaiyi Li (@06393993)</li> <li>Lukas Wirth (@Veykril)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Paul Smith (@paulsmith)</li> <li>Pavan Kumar Sunkara (@pksunkara)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Sami Jawhar (@sjawhar)</li> <li>Scott Taylor (@scott2000)</li> <li>Simone Cattaneo (@simonecattaneo91)</li> <li>Steve Klabnik (@steveklabnik)</li> <li>tom (@lecafard)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>_WD_ (@0WD0)</li> <li>xtqqczze (@xtqqczze)</li> <li>Yuya Nishihara (@yuja)</li> <li>yz (@yzheng453)</li> </ul>"},{"location":"changelog.html#0370-2026-01-07","title":"0.37.0 - 2026-01-07","text":""},{"location":"changelog.html#release-highlights_2","title":"Release highlights","text":"<ul> <li> <p>A new syntax for referring to hidden and divergent change IDs is available:   <code>xyz/n</code> where <code>n</code> is a number. For instance, <code>xyz/0</code> refers to the latest   version of <code>xyz</code>, while <code>xyz/1</code> refers to the previous version of <code>xyz</code>.   This allows you to perform actions like <code>jj restore --from xyz/1 --to xyz</code> to   restore <code>xyz</code> to its previous contents, if you made a mistake.</p> <p>For divergent changes, the numeric suffix will always be shown in the log, allowing you to disambiguate them in a similar manner.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_2","title":"Breaking changes","text":"<ul> <li> <p>String patterns in revsets, command   arguments, and configuration are now parsed as globs by default. Use   <code>substring:</code> or <code>exact:</code> prefix as needed.</p> </li> <li> <p><code>remotes.&lt;name&gt;.auto-track-bookmarks</code> is now parsed the same way they   are in revsets and can be combined with logical operators.</p> </li> <li> <p><code>jj bookmark track</code>/<code>untrack</code> now accepts <code>--remote</code> argument. If omitted, all   remote bookmarks matching the bookmark names will be tracked/untracked. The   old <code>&lt;bookmark&gt;@&lt;remote&gt;</code> syntax is deprecated in favor of <code>&lt;bookmark&gt;   --remote=&lt;remote&gt;</code>.</p> </li> <li> <p>On Windows, symlinks that point to a path with <code>/</code> won't be supported. This   path is invalid on Windows.</p> </li> <li> <p>The template alias <code>format_short_change_id_with_hidden_and_divergent_info(commit)</code>   has been replaced by <code>format_short_change_id_with_change_offset(commit)</code>.</p> </li> <li> <p>The following deprecated config options have been removed:</p> <ul> <li><code>git.push-bookmark-prefix</code></li> <li><code>ui.default-description</code></li> <li><code>ui.diff.format</code></li> <li><code>ui.diff.tool</code></li> </ul> </li> <li> <p>The deprecated <code>commit_id.normal_hex()</code> template method has been removed.</p> </li> <li> <p>Template expansion that did not produce a terminating newline will not be   fixed up to provide one by <code>jj log</code>, <code>jj evolog</code>, or <code>jj op log</code>.</p> </li> <li> <p>The <code>diff</code> conflict marker style can now use <code>\\\\\\\\\\\\\\</code> markers to indicate   the continuation of a conflict label from the previous line.</p> </li> </ul>"},{"location":"changelog.html#deprecations_2","title":"Deprecations","text":"<ul> <li>The <code>git_head()</code> and <code>git_refs()</code> functions will be removed from revsets and   templates. <code>git_head()</code> should point to the <code>first_parent(@)</code> revision in   colocated repositories. <code>git_refs()</code> can be approximated as   <code>remote_bookmarks(remote=glob:*) | tags()</code>.</li> </ul>"},{"location":"changelog.html#new-features_2","title":"New features","text":"<ul> <li> <p>The <code>config()</code> template function now returns <code>Option&lt;ConfigValue&gt;</code> instead of   failing if the config value is not found. This allows checking if a config   exists (e.g. <code>if(config(\"user.email\"), ...)</code>).</p> </li> <li> <p>Updated the executable bit representation in the local working copy to allow   ignoring executable bit changes on Unix. By default we try to detect the   filesystem's behavior, but this can be overridden manually by setting   <code>working-copy.exec-bit-change = \"respect\" | \"ignore\"</code>.</p> </li> <li> <p><code>jj workspace add</code> now also works for empty destination directories.</p> </li> <li> <p><code>jj git remote</code> family of commands now supports different fetch and push URLs.</p> </li> <li> <p><code>[colors]</code> table now supports <code>dim = true</code> attribute.</p> </li> <li> <p>In color-words diffs, context line numbers are now rendered with decreased   intensity.</p> </li> <li> <p>Hidden and divergent commits can now be unambiguously selected using their   change ID combined with a numeric suffix. For instance, if there are two   commits with change ID <code>xyz</code>, then one can be referred to as <code>xyz/0</code> and the   other can be referred to as <code>xyz/1</code>. These suffixes are shown in the log when   necessary to make a change ID unambiguous.</p> </li> <li> <p><code>jj util gc</code> now prunes unreachable files in <code>.jj/repo/store/extra</code> to save   disk space.</p> </li> <li> <p>Early version of a <code>jj file search</code> command for searching for a pattern in   files (like <code>git grep</code>).</p> </li> <li> <p>Conflict labels now contain information about where the sides of a conflict   came from (e.g. <code>nlqwxzwn 7dd24e73 \"first line of description\"</code>).</p> </li> <li> <p><code>--insert-before</code> now accepts a revset that resolves to an empty set when   used with <code>--insert-after</code>. The behavior is similar to <code>--onto</code>.</p> </li> <li> <p><code>jj tag list</code> now supports <code>--sort</code> option.</p> </li> <li> <p><code>TreeDiffEntry</code> type now has a <code>display_diff_path()</code> method that formats   renames/copies appropriately.</p> </li> <li> <p><code>TreeDiffEntry</code> now has a <code>status_char()</code> method that returns   single-character status codes (M/A/D/C/R).</p> </li> <li> <p><code>CommitEvolutionEntry</code> type now has a <code>predecessors()</code> method which   returns the predecessor commits (previous versions) of the entry's commit.</p> </li> <li> <p><code>CommitEvolutionEntry</code> type now has a  <code>inter_diff()</code> method  which   returns a <code>TreeDiff</code> between the entry's commit and its predecessor version.   Optionally accepts a fileset literal to limit the diff.</p> </li> <li> <p><code>jj file annotate</code> now reports an error for non-files instead of succeeding   and displaying no content.</p> </li> <li> <p><code>jj workspace forget</code> now warns about unknown workspaces instead of failing.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_2","title":"Fixed bugs","text":"<ul> <li> <p>Broken symlink on Windows. #6934.</p> </li> <li> <p>Fixed failure on exporting moved/deleted annotated tags to Git. Moved tags are   exported as lightweight tags.</p> </li> <li> <p><code>jj gerrit upload</code> now correctly handles mixed explicit and implicit   Change-Ids in chains of commits (#8219)</p> </li> <li> <p><code>jj git push</code> now updates partially-pushed remote bookmarks accordingly.   #6787</p> </li> <li> <p>Fixed problem of loading large Git packfiles.   https://github.com/GitoxideLabs/gitoxide/issues/2265</p> </li> <li> <p>The builtin pager won't get stuck when stdin is redirected.</p> </li> <li> <p><code>jj workspace add</code> now prevents creating an empty workspace name.</p> </li> <li> <p>Fixed checkout of symlinks pointing to themselves or <code>.git</code>/<code>.jj</code> on Unix. The   problem would still remain on Windows if symlinks are enabled.   #8348</p> </li> <li> <p>Fixed a bug where jj would fail to read git delta objects from pack files.   https://github.com/GitoxideLabs/gitoxide/issues/2344</p> </li> </ul>"},{"location":"changelog.html#contributors_1","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Bryce Berger (@bryceberger)</li> <li>Carlos Knippschild (@chuim)</li> <li>Cole Helbling (@cole-h)</li> <li>David Higgs (@higgsd)</li> <li>Eekle (@Eekle)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>Ian Wrzesinski (@isuffix)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Julian Howes (@jlnhws)</li> <li>Kaiyi Li (@06393993)</li> <li>Lukas Krejci (@metlos)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Ori Avtalion (@salty-horse)</li> <li>Scott Taylor (@scott2000)</li> <li>Shaoxuan (Max) Yuan (@ffyuanda)</li> <li>Stephen Jennings (@jennings)</li> <li>Steve Fink (@hotsphink)</li> <li>Steve Klabnik (@steveklabnik)</li> <li>Theo Buehler (@botovq)</li> <li>Thomas Castiglione (@gulbanana)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>xtqqczze (@xtqqczze)</li> <li>Yuantao Wang (@0WD0)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0360-2025-12-03","title":"0.36.0 - 2025-12-03","text":""},{"location":"changelog.html#release-highlights_3","title":"Release highlights","text":"<ul> <li> <p>The documentation has moved from https://jj-vcs.github.io/jj/ to   https://docs.jj-vcs.dev/.</p> <p>301 redirects are being issued towards the new domain, so any existing links should not be broken.</p> </li> <li> <p>Fixed race condition that could cause divergent operations when running   concurrent <code>jj</code> commands in colocated repositories. It is now safe to   continuously run e.g. <code>jj log</code> without <code>--ignore-working-copy</code> in one   terminal while you're running other commands in another terminal.   #6830</p> </li> <li> <p><code>jj</code> now ignores <code>$PAGER</code> set in the environment and uses <code>less -FRX</code> on most   platforms (<code>:builtin</code> on Windows). See the docs for   more information, and #3502 for   motivation.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_3","title":"Breaking changes","text":"<ul> <li> <p>In filesets or path patterns, glob matching   is enabled by default. You can use <code>cwd:\"path\"</code> to match literal paths.</p> </li> <li> <p>In the following commands, string pattern   arguments are now parsed the same way they   are in revsets and can be combined with logical operators: <code>jj bookmark   delete</code>/<code>forget</code>/<code>list</code>/<code>move</code>, <code>jj tag delete</code>/<code>list</code>, <code>jj git   clone</code>/<code>fetch</code>/<code>push</code></p> </li> <li> <p>In the following commands, unmatched bookmark/tag names is no longer an   error. A warning will be printed instead: <code>jj bookmark   delete</code>/<code>forget</code>/<code>move</code>/<code>track</code>/<code>untrack</code>, <code>jj tag delete</code>, <code>jj git   clone</code>/<code>push</code></p> </li> <li> <p>The default string pattern syntax in revsets will be changed to <code>glob:</code> in a   future release. You can opt in to the new default by setting   <code>ui.revsets-use-glob-by-default=true</code>.</p> </li> <li> <p>Upgraded <code>scm-record</code> from v0.8.0 to v0.9.0. See release notes at   https://github.com/arxanas/scm-record/releases/tag/v0.9.0.</p> </li> <li> <p>The minimum supported Rust version (MSRV) is now 1.89.</p> </li> <li> <p>On macOS, the deprecated config directory <code>~/Library/Application Support/jj</code>   is not read anymore. Use <code>$XDG_CONFIG_HOME/jj</code> instead (defaults to   <code>~/.config/jj</code>).</p> </li> <li> <p>Sub-repos are no longer tracked. Any directory containing <code>.jj</code> or <code>.git</code>   is ignored. Note that Git submodules are unaffected by this.</p> </li> </ul>"},{"location":"changelog.html#deprecations_3","title":"Deprecations","text":"<ul> <li> <p>The <code>--destination</code>/<code>-d</code> arguments for <code>jj rebase</code>, <code>jj split</code>, <code>jj revert</code>,   etc. were renamed to <code>--onto</code>/<code>-o</code>. The reasoning is that <code>--onto</code>,   <code>--insert-before</code>, and <code>--insert-after</code> are all destination arguments, so   calling one of them <code>--destination</code> was confusing and unclear. The old names   will be removed at some point in the future, but we realize that they are   deep in muscle memory, so you can expect an unusually long deprecation period.</p> </li> <li> <p><code>jj describe --edit</code> is deprecated in favor of <code>--editor</code>.</p> </li> <li> <p>The config options <code>git.auto-local-bookmark</code> and <code>git.push-new-bookmarks</code> are   deprecated in favor of <code>remotes.&lt;name&gt;.auto-track-bookmarks</code>. For example:</p> <pre><code>[remotes.origin]\nauto-track-bookmarks = \"glob:*\"\n</code></pre> <p>For more details, refer to the docs.</p> </li> <li> <p>The flag <code>--allow-new</code> on <code>jj git push</code> is deprecated. In order to push new   bookmarks, please track them with <code>jj bookmark track</code>. Alternatively, consider   setting up an auto-tracking configuration to avoid the chore of tracking   bookmarks manually. For example:</p> <pre><code>[remotes.origin]\nauto-track-bookmarks = \"glob:*\"\n</code></pre> <p>For more details, refer to the docs.</p> </li> </ul>"},{"location":"changelog.html#new-features_3","title":"New features","text":"<ul> <li> <p><code>jj commit</code>, <code>jj describe</code>, <code>jj squash</code>, and <code>jj split</code> now accept   <code>--editor</code>, which ensures an editor will be opened with the commit   description even if one was provided via <code>--message</code>/<code>-m</code>.</p> </li> <li> <p>All <code>jj</code> commands show a warning when the provided <code>fileset</code> expression   doesn't match any files.</p> </li> <li> <p>Added <code>files()</code> template function to <code>DiffStats</code>. This supports per-file stats   like <code>lines_added()</code> and <code>lines_removed()</code></p> </li> <li> <p>Added <code>join()</code> template function. This is different from <code>separate()</code> in that   it adds a separator between all arguments, even if empty.</p> </li> <li> <p><code>RepoPath</code> template type now has a <code>absolute() -&gt; String</code> method that returns   the absolute path as a string.</p> </li> <li> <p>Added <code>format_path(path)</code> template that controls how file paths are printed   with <code>jj file list</code>.</p> </li> <li> <p>New built-in revset aliases <code>visible()</code> and <code>hidden()</code>.</p> </li> <li> <p>Unquoted <code>*</code> is now allowed in revsets. <code>bookmarks(glob:foo*)</code> no longer   needs quoting.</p> </li> <li> <p><code>jj prev/next --no-edit</code> now generates an error if the working-copy has some   children.</p> </li> <li> <p>A new config option <code>remotes.&lt;name&gt;.auto-track-bookmarks</code> can be set to a   string pattern. New bookmarks matching it will be automatically tracked for   the specified remote. See   the docs.</p> </li> <li> <p><code>jj log</code> now supports a <code>--count</code> flag to print the number of commits instead   of displaying them.</p> </li> <li> <p><code>Commit</code> type now has a <code>conflicted_files()</code> method that returns a list of   files with merge conflicts.</p> </li> <li> <p><code>TreeEntry</code> type now has a <code>conflict_side_count()</code> method that returns the number   of sides in a merge conflict (1 for non-conflicted files, 2 or more for   conflicts).</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_3","title":"Fixed bugs","text":"<ul> <li> <p><code>jj fix</code> now prints a warning if a tool failed to run on a file.   #7971</p> </li> <li> <p>Shell completion now works with non\u2011normalized paths, fixing the previous   panic and allowing prefixes containing <code>.</code> or <code>..</code> to be completed correctly.   #6861</p> </li> <li> <p>Shell completion now always uses forward slashes to complete paths, even on   Windows. This renders completion results viable when using jj in Git Bash.   #7024</p> </li> <li> <p>Unexpected keyword arguments now return a parse failure for the <code>coalesce()</code>   and <code>concat()</code> templating functions.</p> </li> <li> <p>Nushell completion script documentation add <code>-f</code> option, to keep it up to   date.   #8007</p> </li> <li> <p>Ensured that with Git submodules, remnants of your submodules do not show up   in the working copy after running <code>jj new</code>.   #4349</p> </li> </ul>"},{"location":"changelog.html#contributors_2","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>abgox (@abgox)</li> <li>ase (@adamse)</li> <li>Bj\u00f6rn Kautler (@Vampire)</li> <li>Bryce Berger (@bryceberger)</li> <li>Chase Naples (@cnaples79)</li> <li>David Higgs (@higgsd)</li> <li>edef (@edef1c)</li> <li>Evan Mesterhazy (@emesterhazy)</li> <li>Fedor (@sheremetyev)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>George Christou (@gechr)</li> <li>Hubert Lefevre (@Paluche)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jonas Greitemann (@jgreitemann)</li> <li>Joseph Lou (@josephlou5)</li> <li>Julia DeMille (@judemille)</li> <li>Kaiyi Li (@06393993)</li> <li>Kyle Lippincott (@spectral54)</li> <li>Lander Brandt (@landaire)</li> <li>Lucio Franco (@LucioFranco)</li> <li>Luke Randall (@lukerandall)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Mitchell Skaggs (@magneticflux-)</li> <li>Peter Schilling (@schpet)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>QingyaoLin (@QingyaoLin)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Scott Taylor (@scott2000)</li> <li>Stephen Jennings (@jennings)</li> <li>Steve Klabnik (@steveklabnik)</li> <li>Tejas Sanap (@whereistejas)</li> <li>Tommi Virtanen (@tv42)</li> <li>Velociraptor115 (@Velociraptor115)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0350-2025-11-05","title":"0.35.0 - 2025-11-05","text":""},{"location":"changelog.html#release-highlights_4","title":"Release highlights","text":"<ul> <li> <p>Workspaces can now have their own separate configuration. For instance, you   can use <code>jj config set --workspace</code> to update a configuration option only in   the current workspace.</p> </li> <li> <p>After creating a local bookmark, it is now possible to use <code>jj bookmark track</code>   to associate the bookmark with a specific remote before pushing it. When   pushing a tracked bookmark, it is not necessary to use <code>--allow-new</code>.</p> </li> <li> <p>The new <code>jj git colocation enable</code> and <code>jj git colocation disable</code> commands   allow converting between colocated and non-colocated workspaces.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_4","title":"Breaking changes","text":"<ul> <li> <p>The <code>remote_bookmarks(remote=pattern)</code> revset now includes Git-tracking   bookmarks if the specified <code>pattern</code> matches <code>git</code>. The default is   <code>remote=~exact:\"git\"</code> as before.</p> </li> <li> <p>The deprecated flag <code>--summary</code> of <code>jj abandon</code> has been removed.</p> </li> <li> <p>The deprecated command <code>jj backout</code> has been removed, use <code>jj revert</code> instead.</p> </li> <li> <p>The following deprecated config options have been removed:</p> <ul> <li><code>signing.sign-all</code></li> <li><code>core.watchman.register_snapshot_trigger</code></li> <li><code>diff.format</code></li> </ul> </li> </ul>"},{"location":"changelog.html#deprecations_4","title":"Deprecations","text":"<ul> <li> <p><code>jj bisect run --command &lt;cmd&gt;</code> is deprecated in favor of    <code>jj bisect run -- &lt;cmd&gt;</code>.</p> </li> <li> <p><code>jj metaedit --update-committer-timestamp</code> was renamed to    <code>jj metaedit --force-rewrite</code> since the old name (and help text)    incorrectly suggested that the committer name and email would not    be updated.</p> </li> </ul>"},{"location":"changelog.html#new-features_4","title":"New features","text":"<ul> <li> <p>Workspaces may have an additional layered configuration, located at   <code>.jj/workspace-config.toml</code>. <code>jj config</code> subcommands which took layer options   like <code>--repo</code> now also support <code>--workspace</code>.</p> </li> <li> <p><code>jj bookmark track</code> can now associate new local bookmarks with remote.   Tracked bookmarks can be pushed without <code>--allow-new</code>.   #7072</p> </li> <li> <p>The new <code>jj git colocation</code> command provides sub-commands to show the   colocation state (<code>status</code>), to convert a non-colocated workspace into   a colocated workspace (<code>enable</code>), and vice-versa (<code>disable</code>).</p> </li> <li> <p>New <code>jj tag set</code>/<code>delete</code> commands to create/update/delete tags locally.   Created/updated tags are currently always exported to Git as lightweight   tags. If you would prefer them to be exported as annotated tags, please give   us feedback on #7908.</p> </li> <li> <p>Templates now support a <code>.split(separator, [limit])</code> method on strings to   split a string into a list of substrings.</p> </li> <li> <p><code>-G</code> is now available as a short form of <code>--no-graph</code> in <code>jj log</code>, <code>jj evolog</code>,   <code>jj op log</code>, <code>jj op show</code> and <code>jj op diff</code>.</p> </li> <li> <p><code>jj metaedit</code> now accepts <code>-m</code>/<code>--message</code> option to non-interactively update   the change description.</p> </li> <li> <p>The <code>CryptographicSignature.key()</code> template method now also works for SSH   signatures and returns the corresponding public key fingerprint.</p> </li> <li> <p>Added <code>template-aliases.empty_commit_marker</code>. Users can override this value in   their config to change the \"(empty)\" label on empty commits.</p> </li> <li> <p>Add support for <code>--when.workspaces</code> config scopes.</p> </li> <li> <p>Add support for <code>--when.hostnames</code> config scopes. This allows configuration to   be conditionally applied based on the hostname set in <code>operation.hostname</code>.</p> </li> <li> <p><code>jj bisect run</code> accepts the command and arguments to pass to the command   directly as positional arguments, such as   <code>jj bisect --range=..main -- cargo check --all-targets</code>.</p> </li> <li> <p>Divergent changes are no longer marked red in immutable revisions. Since the   revision is immutable, the user shouldn't take any action, so the red color   was unnecessarily alarming.</p> </li> <li> <p>New commit template keywords <code>local</code>/<code>remote_tags</code> to show only local/remote   tags. These keywords may be useful in non-colocated Git repositories where   local and exported <code>@git</code> tags can point to different revisions.</p> </li> <li> <p><code>jj git clone</code> now supports the <code>--branch</code> option to specify the branch(es)   to fetch during clone. If present, the first matching branch is used as the   working-copy parent.</p> </li> <li> <p>Revsets now support logical operators in string patterns.</p> </li> <li> <p><code>jj file track</code> now accepts an <code>--include-ignored</code> flag to track files that   are ignored by <code>.gitignore</code> or exceed the <code>snapshot.max-new-file-size</code> limit.   #2837</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_4","title":"Fixed bugs","text":"<ul> <li> <p><code>jj metaedit --author-timestamp</code> twice with the same value no longer edits the change twice in some cases.</p> </li> <li> <p><code>jj squash</code>: fixed improper revision rebase when both <code>--insert-after</code> and   <code>--insert-before</code> were used.</p> </li> <li> <p><code>jj undo</code> can now revert \"fetch\"/\"import\" operation that involves tag updates.   #6325</p> </li> <li> <p>Fixed parsing of <code>files(expr)</code> revset expression including parentheses.   #7747</p> </li> <li> <p>Fixed <code>jj describe --stdin</code> to append a final newline character.</p> </li> </ul>"},{"location":"changelog.html#contributors_3","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alpha Chen (@kejadlen)</li> <li>Angel Ezquerra (@AngelEzquerra)</li> <li>ase (@adamse)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>bipul (@bipulmgr)</li> <li>Brian Schroeder (@bts)</li> <li>Bryce Berger (@bryceberger)</li> <li>Cole Helbling (@cole-h)</li> <li>Daniel Luz (@mernen)</li> <li>David Higgs (@higgsd)</li> <li>Defelo (@Defelo)</li> <li>Fedor (@sheremetyev)</li> <li>Gabriel Goller (@kaffarell)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>George Christou (@gechr)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Isaac Corbrey (@icorbrey)</li> <li>James Coman (@jamescoman)</li> <li>Joseph Lou (@josephlou5)</li> <li>Lander Brandt (@landaire)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Michael Chirico (@MichaelChirico)</li> <li>Owen Brooks (@owenbrooks)</li> <li>Peter Schilling (@schpet)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Ross Smyth (@RossSmyth)</li> <li>Scott Taylor (@scott2000)</li> <li>Steve Fink (@hotsphink)</li> <li>Steve Klabnik (@steveklabnik)</li> <li>Theo Buehler (@botovq)</li> <li>Theodore Dubois (@tbodt)</li> <li>Theodore Keloglou (@sirodoht)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0340-2025-10-01","title":"0.34.0 - 2025-10-01","text":""},{"location":"changelog.html#release-highlights_5","title":"Release highlights","text":"<ul> <li> <p>Support for uploading changes to Gerrit Code Review with <code>jj gerrit upload</code>.   This lets you submit trees or multiple stacks of work at once. Support   for fetching changes, submitting changes, and other operations is not yet   implemented. This should be considered experimental, and we welcome feedback   on using it.</p> </li> <li> <p>Support for automated bisection using <code>jj bisect run</code>; this will continuously   bisect a commit range until a given commit is found to trigger a bug.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_5","title":"Breaking changes","text":"<ul> <li> <p>Git-based repositories are now colocated by default. Configure <code>git.colocate =   false</code> to keep the previous behavior.</p> </li> <li> <p>Conflicts written by jj &lt; 0.11 are no longer supported. They will now appear   as regular files with a <code>.jjconflict</code> suffix and JSON contents.</p> </li> <li> <p>The minimum supported Rust version (MSRV) is now 1.88.</p> </li> </ul>"},{"location":"changelog.html#deprecations_5","title":"Deprecations","text":"<ul> <li> <p>Various flags on <code>jj describe</code> and <code>jj commit</code> have been deprecated in favor   of <code>jj metaedit</code>. They are:</p> <ul> <li><code>describe</code>: <code>--author</code>, <code>--reset-author</code>, <code>--no-edit</code></li> <li><code>commit</code>:   <code>--author</code>, <code>--reset-author</code></li> </ul> </li> <li> <p>The storage format of remote bookmarks and tags has changed. Remote bookmarks   will be written in both old and new formats to retain forward compatibility.   Git-tracking tags are also recorded for future native tagging support. This   change should be transparent, but let us know if you see anything odd.</p> </li> </ul>"},{"location":"changelog.html#new-features_5","title":"New features","text":"<ul> <li> <p>The new command <code>jj bisect run</code> uses binary search to find a commit that   introduced a bug.</p> </li> <li> <p>The default editor on Unix is now <code>nano</code> instead of <code>pico</code>.</p> </li> <li> <p>New config option <code>merge.hunk-level = \"word\"</code> to enable word-level merging.</p> </li> <li> <p>New config option <code>merge.same-change = \"keep\"</code> to disable lossy resolution   rule for same-change conflicts.   #6369</p> </li> <li> <p>Templates now support a <code>replace()</code> method on strings for pattern-based   string replacement with optional limits. Supports all string patterns, including   regex with capture groups (e.g. <code>\"hello world\".replace(regex:'(\\w+) (\\w+)', \"$2 $1\")</code>).</p> </li> <li> <p>A new builtin <code>hyperlink(url, text)</code> template alias creates clickable   hyperlinks using OSC8 escape sequences   for terminals that support them.</p> </li> <li> <p>Added a new conditional configuration <code>--when.platforms</code> to include   settings only on certain platforms.</p> </li> <li> <p>External diff commands now support substitution variable <code>$width</code> for the   number of available terminal columns.</p> </li> <li> <p>The new <code>jj gerrit upload</code> command allows you to upload given revisions to an   instance of Gerrit Code Review.</p> </li> <li> <p><code>jj bookmark create/set/move</code> use the working copy as a default again and   no longer require an explicit revision argument. This walks back a   deprecation from <code>jj 0.26</code>, as the community feedback was mostly negative.   Instead, bookmarking an empty revision now produces a warning, to help you   catch the case where you meant to bookmark the parent revision.</p> </li> <li> <p>The revset function <code>exactly(x, n)</code> will now evaluate <code>x</code> and error if it does   not have exactly <code>n</code> elements.</p> </li> <li> <p><code>jj util exec</code> now matches the exit status of the program it runs, and   doesn't print anything.</p> </li> <li> <p><code>jj config get</code> now supports displaying array and table config values.</p> </li> <li> <p><code>jj util exec</code> sets the environment variable <code>JJ_WORKSPACE_ROOT</code></p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_5","title":"Fixed bugs","text":"<ul> <li>Fetching repositories that have submodules no longer errors even if   <code>submodule.recurse=true</code> is set in <code>.gitconfig</code> (but jj still isn't able to   fetch the submodules or to operate on them).</li> </ul>"},{"location":"changelog.html#contributors_4","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Angel Ezquerra (@AngelEzquerra)</li> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Antonin Delpeuch (@wetneb)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Conner Petzold (@ConnerPetzold)</li> <li>Daniel Luz (@mernen)</li> <li>Daniele Sassoli (@DanieleSassoli)</li> <li>David Barsky (@davidbarsky)</li> <li>Dinu Blanovschi (@dnbln)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>George Christou (@gechr)</li> <li>Ian Wrzesinski (@isuffix)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Isaac Corbrey (@icorbrey)</li> <li>Ivan Petkov (@ipetkov)</li> <li>Jonas Fierlings (@PigeonF)</li> <li>loudgolem (@phanirithvij)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Matt T. Proud (@matttproud)</li> <li>Michael Pratt (@prattmic)</li> <li>MochikoNyan (@MochikoNyan)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Reilly Brogan (@ReillyBrogan)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Reuven Lazarus (@rlazarus)</li> <li>Scott Taylor (@scott2000)</li> <li>Stephen Jennings (@jennings)</li> <li>Steven Sherry (@Steven0351)</li> <li>Theo Buehler (@botovq)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0330-2025-09-03","title":"0.33.0 - 2025-09-03","text":""},{"location":"changelog.html#release-highlights_6","title":"Release highlights","text":"<ul> <li> <p><code>jj undo</code> is now sequential: invoking it multiple times in sequence   repeatedly undoes actions in the operation log. Previously, <code>jj undo</code> would   only undo the most recent operation in the operation log. As a result, a new   <code>jj redo</code> command has been added.</p> </li> <li> <p>Experimental support for improving query performance over filesets and file   queries (like <code>jj log path/to/file.txt</code>) has been added. This is not enabled   by default. To enable this, you must use the <code>jj debug index-changed-paths</code>   command.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_6","title":"Breaking changes","text":"<ul> <li> <p><code>jj evolog</code> templates now accept <code>CommitEvolutionEntry</code> as context type. To   get <code>Commit</code> properties, use <code>commit.&lt;method&gt;()</code>. To customize the default   output, set <code>templates.evolog</code> instead of <code>templates.log</code>.</p> </li> <li> <p><code>jj op show</code> now uses <code>templates.op_show</code> configuration for its default template   instead of <code>templates.op_log</code>.</p> </li> <li> <p>The deprecated config option <code>git.auto-local-branch</code> has been removed. Use   <code>git.auto-local-bookmark</code> instead.</p> </li> <li> <p>The deprecated <code>Signature.username()</code> template method has been removed. Use   <code>Signature.email().local()</code> instead.</p> </li> <li> <p>The deprecated <code>--config-toml</code> flag has been removed. Use   <code>--config=NAME=VALUE</code> or <code>--config-file=PATH</code> instead.</p> </li> <li> <p><code>jj undo</code> can now undo multiple operations progressively by calling it   repeatedly, whereas previously, running <code>jj undo</code> twice was previously a no-op   (it only undid the last change).</p> </li> <li> <p><code>jj git fetch</code> will now only fetch the refspec patterns configured on remotes   when the <code>--branch</code> option is omitted. Only simple refspec patterns are   currently supported, and anything else (like refspecs which rename branches)   will be ignored.</p> </li> <li> <p>The <code>conflict</code> label used for coloring log graph nodes was renamed to   <code>conflicted</code>.</p> </li> </ul>"},{"location":"changelog.html#deprecations_6","title":"Deprecations","text":"<ul> <li> <p>The on-disk index format has changed. <code>jj</code> will write index files in both old   and new formats, so old <code>jj</code> versions should be able to read these index   files. This compatibility layer will be removed in a future release.</p> </li> <li> <p><code>jj op undo</code> is deprecated in favor of <code>jj op revert</code>. (<code>jj undo</code> is still   available, but with new semantics. See also the breaking changes above.)</p> </li> <li> <p>The argument <code>&lt;operation&gt;</code> of <code>jj undo</code> is deprecated in favor of   <code>jj op revert &lt;operation&gt;</code>.</p> </li> <li> <p>The <code>--what</code> flag on <code>jj undo</code> is deprecated. Consider using   <code>jj op restore --what</code> instead.</p> </li> </ul>"},{"location":"changelog.html#new-features_6","title":"New features","text":"<ul> <li> <p>The new command <code>jj redo</code> can progressively redo operations that were   previously undone by multiple calls to <code>jj undo</code>.</p> </li> <li> <p>Templates now support <code>any()</code> and <code>all()</code> methods on lists to check whether   any or all elements satisfy a predicate. Example: <code>parents.any(|c| c.mine())</code>   returns true if any parent commit is authored by the user.</p> </li> <li> <p>Add experimental support for indexing changed paths, which will speed up <code>jj   log PATH</code> query, <code>jj file annotate</code>, etc. The changed-path index can be   enabled by <code>jj debug index-changed-paths</code> command. Indexing may take tens of   minutes depending on the number of merge commits. The indexing command UI is   subject to change. #4674</p> </li> <li> <p><code>jj config list</code> now supports <code>-T'json(self) ++ \"\\n\"'</code> serialization output.</p> </li> <li> <p><code>jj file show</code> now accepts <code>-T</code>/<code>--template</code> option to insert file metadata.</p> </li> <li> <p>The template language now allows arbitrary whitespace between any operators.</p> </li> <li> <p>The new configuration option <code>git.colocate=boolean</code> controls whether or not   Git repositories are colocated by default.</p> </li> <li> <p>Both <code>jj git clone</code> and <code>jj git init</code> now take a <code>--no-colocate</code> flag to   disable colocation (in case <code>git.colocate</code> is set to <code>true</code>.)</p> </li> <li> <p><code>jj git remote add</code> and <code>jj git clone</code> now support <code>--fetch-tags</code> to control   when tags are fetched for all subsequent fetches.</p> </li> <li> <p><code>jj git fetch</code> now supports <code>--tracked</code> to fetch only tracked bookmarks.</p> </li> <li> <p><code>jj diff --stat</code> now shows the change in size to binary files.</p> </li> <li> <p><code>jj interdiff</code>, <code>jj evolog -p</code>, and <code>jj op log -p</code> now show diff of commit   descriptions.</p> </li> <li> <p><code>jj log</code> and <code>jj op log</code> output can now be anonymized with the   <code>builtin_log_redacted</code> and <code>builtin_op_log_redacted</code> templates.</p> </li> <li> <p><code>jj git init</code> now checks for an <code>upstream</code> remote in addition to <code>origin</code> when   setting the repository-level <code>trunk()</code> alias. The <code>upstream</code> remote takes   precedence over <code>origin</code> if both exist.</p> </li> <li> <p>Add the <code>jj metaedit</code> command, which modifies a revision's metadata. This can   be used to generate a new change-id, which may help resolve some divergences.   It also has options to modify author name, email and timestamp, as well as to   modify committer timestamp.</p> </li> <li> <p>Filesets now support case-insensitive glob patterns with the <code>glob-i:</code>,   <code>cwd-glob-i:</code>, and <code>root-glob-i:</code> pattern kinds. For example, <code>glob-i:\"*.rs\"</code>   will match both <code>file.rs</code> and <code>FILE.RS</code>.</p> </li> <li> <p><code>jj op show</code> now accepts <code>-T</code>/<code>--template</code> option to customize the operation   output using template expressions, similar to <code>jj op log</code>. Also added   <code>--no-op-diff</code> flag to suppress the operation diff.</p> </li> <li> <p>A nearly identical string pattern system as revsets is now supported in the   template language, and is exposed as <code>string.match(pattern)</code>.</p> </li> <li> <p>Merge tools can use the <code>$path</code> argument to learn where the file they   are merging will end up in the repository.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_6","title":"Fixed bugs","text":"<ul> <li> <p><code>jj git clone</code> now correctly fetches all tags, unless <code>--fetch-tags</code> is   explicitly specified, in which case the specified option will apply for both   the initial clone and subsequent fetches.</p> </li> <li> <p>Operation and working-copy state files are now synchronized to disk on save.   This will mitigate data corruption on system crash.   #4423</p> </li> </ul>"},{"location":"changelog.html#packaging-changes","title":"Packaging changes","text":"<ul> <li>The test suite no longer optionally uses Taplo CLI or jq, and packagers can   remove them as dependencies if present.</li> </ul>"},{"location":"changelog.html#contributors_5","title":"Contributors","text":"<ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Christian Hufnagel (@OvidiusCicero)</li> <li>Cl\u00e9ment (@drawbu)</li> <li>Daniel Luz (@mernen)</li> <li>Emily (@emilazy)</li> <li>Evan Martin (@evmar)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>George Christou (@gechr)</li> <li>Graham Christensen (@grahamc)</li> <li>Hegui Dai (@Natural-selection1)</li> <li>Ian Wrzesinski (@isuffix)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Isaac Corbrey (@icorbrey)</li> <li>Ivan Petkov (@ipetkov)</li> <li>Joaqu\u00edn Tri\u00f1anes (@JoaquinTrinanes)</li> <li>Kaiyi Li (@06393993)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Nigthknight (@nigthknight)</li> <li>Nikhil Marathe (@nikhilm)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Tijs-B (@Tijs-B)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0320-2025-08-06","title":"0.32.0 - 2025-08-06","text":""},{"location":"changelog.html#breaking-changes_7","title":"Breaking changes","text":"<ul> <li> <p>In revsets, symbol expressions (such as change ID prefix) no longer resolve to   multiple revisions, and error out if resolved to more than one revisions. Use   <code>change_id(prefix)</code> or <code>bookmarks(exact:name)</code> to query divergent changes or   conflicted bookmarks. Commands like <code>jj rebase</code> no longer require <code>all:</code> to   specify multiple destination revisions.</p> </li> <li> <p><code>jj op abandon</code> now discards previous versions of a change (or predecessors)   if they become unreachable from the operation history. The evolution history   is truncated accordingly.</p> <p>Once <code>jj op abandon</code> and <code>jj util gc</code> are run in a repository, old versions of <code>jj</code> might get \"commit not found\" error on <code>jj evolog</code>.</p> </li> <li> <p><code>commit.working_copies()</code> template method now returns <code>List&lt;WorkspaceRef&gt;</code></p> </li> <li> <p>The previously predefined <code>amend</code> alias has been removed. You can restore it   by setting the config <code>aliases.amend = [\"squash\"]</code>.</p> </li> </ul>"},{"location":"changelog.html#deprecations_7","title":"Deprecations","text":"<ul> <li> <p>The <code>all:</code> revset modifier and <code>ui.always-allow-large-revsets</code> setting is   planned to be removed in a future release.   #6016</p> </li> <li> <p>Rename the <code>core.fsmonitor</code> and <code>core.watchman</code> settings to   <code>fsmonitor.backend</code>, and <code>fsmonitor.watchman</code> respectively.</p> </li> </ul>"},{"location":"changelog.html#new-features_7","title":"New features","text":"<ul> <li> <p><code>jj workspace list</code> now accepts <code>-T</code>/<code>--template</code> option to customize its   output via templates.</p> </li> <li> <p>Added <code>templates.workspace_list</code> template to customize the output of   <code>jj workspace list</code>.</p> </li> <li> <p><code>jj fix</code> now buffers the standard error stream from subprocesses and emits   the output from each all at once. The file name is printed before the output.</p> </li> <li> <p><code>jj status</code> now collapses fully untracked directories into one line.   It still fully traverses them while snapshotting but they won't clutter up   the output with all of their contents.</p> </li> <li> <p>Add the <code>working-copy.eol-conversion</code> config which is similar to the git   <code>core.autocrlf</code> config. A heuristics is used to detect if a file is a binary   file to prevent the EOL conversion from changing binary files unexpectedly.</p> </li> <li> <p>Add a <code>.parents()</code> method to the   <code>Operation</code> type in the templating   language.</p> </li> <li> <p>Merge tools config can now explicitly forbid using them as diff editors or   diff formatters. Built-in tools that do not function well as diff editing   tools or as diff formatters will now report an error when used as such.</p> </li> <li> <p><code>jj diffedit</code> now accepts filesets to edit only the specified paths.</p> </li> <li> <p>AnnotationLine objects in templates now have a <code>original_line_number() -&gt;   Integer</code> method.</p> </li> <li> <p>Commit templates now support <code>.files()</code> to list all existing files at that   revision.</p> </li> <li> <p>Glob patterns now support <code>{foo,bar}</code> syntax. There may be subtle behavior   changes as we use the globset library now.</p> </li> <li> <p>The new <code>bisect(x)</code> revset function can help bisect a range of commits to   find when a bug was introduced.</p> </li> <li> <p>New <code>first_parent()</code> and <code>first_ancestors()</code> revset functions which are   similar to <code>parents()</code> and <code>ancestors()</code>, but only traverse the first parent   of each commit (similar to Git's <code>--first-parent</code> option).</p> </li> <li> <p>New <code>signing.backends.ssh.revocation-list</code> config for specifying a list of revoked   public keys for commit signature verification.</p> </li> <li> <p><code>jj fix</code> commands now replace <code>$root</code> with the workspace's root path. This is   useful for tools stored inside the workspace.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_7","title":"Fixed bugs","text":"<ul> <li> <p>Fixed an error in <code>jj util gc</code> caused by the empty blob being missing from   the Git store. #7062</p> </li> <li> <p><code>jj op diff -p</code> and <code>jj op log -p</code> now show content diffs from the first   predecessor only. #7090</p> </li> <li> <p><code>jj git fetch</code> no longer shows <code>NaN%</code> progress when connecting to slow remotes.   #7155</p> </li> </ul>"},{"location":"changelog.html#contributors_6","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>adamnemecek (@adamnemecek)</li> <li>Alexander Kobjolke (@jakalx)</li> <li>Apromixately (@Apromixately)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Bryce Berger (@bryceberger)</li> <li>Daniel Danner (@dnnr)</li> <li>Daniel Luz (@mernen)</li> <li>Evan Martin (@evmar)</li> <li>George Christou (@gechr)</li> <li>George Elliott-Hunter (@george-palmsens)</li> <li>Hubert G\u0142uchowski (@afishhh)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jade Lovelace (@lf-)</li> <li>Jake Martin (@jake-m-commits)</li> <li>Jan Klass (@Kissaki)</li> <li>Joaqu\u00edn Tri\u00f1anes (@JoaquinTrinanes)</li> <li>Josh Steadmon (@steadmon)</li> <li>Kaiyi Li (@06393993)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Nigthknight (@nigthknight)</li> <li>Ori Avtalion (@salty-horse)</li> <li>Pablo Brasero (@pablobm)</li> <li>Pavan Kumar Sunkara (@pksunkara)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>phoebe (@phoreverpheebs)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Scott Taylor (@scott2000)</li> <li>Stephen Jennings (@jennings)</li> <li>Theo Buehler (@botovq)</li> <li>Tyarel8 (@Tyarel8)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0310-2025-07-02","title":"0.31.0 - 2025-07-02","text":""},{"location":"changelog.html#breaking-changes_8","title":"Breaking changes","text":"<ul> <li> <p>Revset expressions like <code>hidden_id | description(x)</code> now search the specified   hidden revision and its ancestors as well   as all visible revisions.</p> </li> <li> <p>Commit templates no longer normalize <code>description</code> by appending final newline   character. Use <code>description.trim_end() ++ \"\\n\"</code> if needed.</p> </li> </ul>"},{"location":"changelog.html#deprecations_8","title":"Deprecations","text":"<ul> <li>The <code>git.push-bookmark-prefix</code> setting is deprecated in favor of   <code>templates.git_push_bookmark</code>, which supports templating. The old setting can   be expressed in template as <code>\"&lt;prefix&gt;\" ++ change_id.short()</code>.</li> </ul>"},{"location":"changelog.html#new-features_8","title":"New features","text":"<ul> <li> <p>New <code>change_id(prefix)</code>/<code>commit_id(prefix)</code> revset functions to explicitly   query commits by change/commit ID prefix.</p> </li> <li> <p>The <code>parents()</code> and <code>children()</code> revset functions now accept an optional   <code>depth</code> argument. For instance, <code>parents(x, 3)</code> is equivalent to <code>x---</code>, and   <code>children(x, 3)</code> is equivalent to <code>x+++</code>.</p> </li> <li> <p><code>jj evolog</code> can now follow changes from multiple revisions such as divergent   revisions.</p> </li> <li> <p><code>jj diff</code> now accepts <code>-T</code>/<code>--template</code> option to customize summary output.</p> </li> <li> <p>Log node templates are now specified in toml rather than hardcoded.</p> </li> <li> <p>Templates now support <code>json(x)</code> function to serialize values in JSON format.</p> </li> <li> <p>The ANSI 256-color palette can be used when configuring colors. For example,   <code>colors.\"diff removed token\" = { bg = \"ansi-color-52\", underline = false }</code>   will apply a dark red background on removed words in diffs.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_8","title":"Fixed bugs","text":"<ul> <li> <p><code>jj file annotate</code> can now process files at a hidden revision.</p> </li> <li> <p><code>jj op log --op-diff</code> no longer fails at displaying \"reconcile divergent   operations.\" #4465</p> </li> <li> <p><code>jj util gc --expire=now</code> now passes the corresponding flag to <code>git gc</code>.</p> </li> <li> <p><code>change_id</code>/<code>commit_id.shortest()</code> template functions now take conflicting   bookmark and tag names into account.   #2416</p> </li> <li> <p>Fixed lockfile issue on stale file handles observed with NFS.</p> </li> </ul>"},{"location":"changelog.html#packaging-changes_1","title":"Packaging changes","text":"<ul> <li><code>aarch64-windows</code> builds (release binaries and <code>main</code> snapshots) are now provided.</li> </ul>"},{"location":"changelog.html#contributors_7","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>Cyril Plisko (@imp)</li> <li>Daniel Luz (@mernen)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>Gilad Woloch (@giladwo)</li> <li>Greg Morenz (@gmorenz)</li> <li>Igor Velkov (@iav)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jade Lovelace (@lf-)</li> <li>Jonas Greitemann (@jgreitemann)</li> <li>Josh Steadmon (@steadmon)</li> <li>juemrami (@juemrami)</li> <li>Kaiyi Li (@06393993)</li> <li>Lars Francke (@lfrancke)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Osama Qarem (@osamaqarem)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>raylu (@raylu)</li> <li>Scott Taylor (@scott2000)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0300-2025-06-04","title":"0.30.0 - 2025-06-04","text":""},{"location":"changelog.html#release-highlights_7","title":"Release highlights","text":"<ul> <li> <p>The experimental support from release 0.29.0 for transferring the change ID   to/from Git remotes has been enabled by default. The change ID is stored in   the Git commit itself (in a commit header called <code>change-id</code>), which means   it will be transferred by regular <code>git push</code> etc. Please let us know if you   run into any problems with it. You can disable it setting   <code>git.write-change-id-header</code>. Note that some Git remotes (e.g GitLab) and   some Git commands (e.g. <code>git rebase</code>) do not preserve the change ids when   they rewrite commits.</p> </li> <li> <p><code>jj rebase</code> now automatically abandons divergent commits if another commit   with the same change ID is already present in the destination with identical   changes.</p> </li> <li> <p><code>jj split</code> has gained <code>--message</code>, <code>--insert-before</code>, <code>--insert-after</code>, and   <code>--destination</code> options.</p> </li> <li> <p><code>jj evolog</code> can show associated operations for commits created by new jj   versions.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_9","title":"Breaking changes","text":"<ul> <li> <p>The old <code>libgit2</code> code path for fetches and pushes has been removed,   and the <code>git.subprocess</code> setting along with it.</p> </li> <li> <p>In templates, bookmark/tag/remote names are now formatted in revset symbol   notation. The type of <code>bookmark.remote()</code> is changed to <code>Option&lt;_&gt;</code>.   <code>bookmark.remote() == \"foo\"</code> still works, but <code>bookmark.remote().&lt;method&gt;()</code>   might need <code>if(bookmark.remote(), ..)</code> to suppress error.</p> </li> <li> <p><code>jj rebase</code> now automatically abandons divergent commits if another commit   with the same change ID is already present in the destination with identical   changes. To keep these divergent commits, use the <code>--keep-divergent</code> flag.</p> </li> <li> <p>The deprecated <code>--skip-empty</code> flag for <code>jj rebase</code> has been removed. Use the   <code>--skip-emptied</code> flag instead.</p> </li> <li> <p>The deprecated <code>jj branch</code> subcommands have been removed. Use the <code>jj   bookmark</code> subcommands instead.</p> </li> <li> <p><code>jj util completion</code> now requires the name of the shell as a positional   argument and no longer produces Bash completions by default. The deprecated   optional arguments for different shells have been removed.</p> </li> <li> <p>External diff tools are now run in the temporary directory containing   the before (<code>left</code>) and after (<code>right</code>) directories, making diffs appear   more pleasing for tools that display file paths prominently. Users can   opt out of this by setting <code>merge-tools.&lt;tool&gt;.diff-do-chdir = false</code>,   but this will likely be removed in a future release. Please report any   issues you run into.</p> </li> <li> <p>The minimum supported Rust version (MSRV) is now 1.85.0.</p> </li> </ul>"},{"location":"changelog.html#deprecations_9","title":"Deprecations","text":"<ul> <li> <p>The <code>ui.diff.format</code> and <code>ui.diff.tool</code> config options have been merged as   <code>ui.diff-formatter</code>. The builtin format can be specified as <code>:&lt;format&gt;</code>   (e.g. <code>ui.diff-formatter=\":git\"</code> for Git diffs.)</p> </li> <li> <p>The <code>.normal_hex()</code> method will be removed from the <code>CommitId</code> template type.   It's useful only for the <code>ChangeId</code> type.</p> </li> </ul>"},{"location":"changelog.html#new-features_9","title":"New features","text":"<ul> <li> <p><code>jj split</code> has gained a <code>--message</code> option to set the description of the   commit with the selected changes.</p> </li> <li> <p><code>jj split</code> has gained the ability to place the revision with the selected   changes anywhere in the revision tree with the <code>--insert-before</code>,   <code>--insert-after</code> and <code>--destination</code> command line flags.</p> </li> <li> <p>Added <code>git.track-default-bookmark-on-clone</code> setting to control whether to   track the default remote bookmark on <code>jj git clone</code>.</p> </li> <li> <p>Templates can now do arithmetic on integers with the <code>+</code>, <code>-</code>, <code>*</code>, <code>/</code>, and   <code>%</code> infix operators.</p> </li> <li> <p>Evolution history is now stored in the operation log. <code>jj evolog</code> can show   associated operations for commits created by new jj versions.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_9","title":"Fixed bugs","text":"<ul> <li> <p>Work around a git issue that could cause subprocess operations to hang if the   <code>core.fsmonitor</code> gitconfig is set in the global or system gitconfigs.   #6440</p> </li> <li> <p><code>jj parallelize</code> can now parallelize groups of changes that start with an   immutable change, but do not contain any other immutable changes.</p> </li> <li> <p><code>jj</code> will no longer warn about deprecated paths on macOS if the configured   XDG directory is the deprecated one (~/Library/Application Support).</p> </li> <li> <p>The builtin diff editor now correctly handles splitting changes where a file   is replaced by a directory of the same name.   #5189</p> </li> </ul>"},{"location":"changelog.html#packaging-changes_2","title":"Packaging changes","text":"<ul> <li>Due to the removal of the <code>libgit2</code> code path, packagers should remove any   dependencies on <code>libgit2</code>, <code>libssh2</code>, Zlib, OpenSSL, and <code>pkg-config</code>, and   ensure they are not setting the Cargo <code>git2</code> or <code>vendored-openssl</code> features.</li> </ul>"},{"location":"changelog.html#contributors_8","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alper Cugun (@alper)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Bryce Berger (@bryceberger)</li> <li>Colin Nelson (@orthros)</li> <li>Doug Stephen (@dljsjr)</li> <li>Emily (@emilazy)</li> <li>Eyvind Bernhardsen (@eyvind)</li> <li>Felix Geisend\u00f6rfer (@felixge)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Isaac Corbrey (@icorbrey)</li> <li>Jonas Greitemann (@jgreitemann)</li> <li>Josep Mengual (@truita)</li> <li>kkoang (@kkoang)</li> <li>Manuel Mendez (@mmlb)</li> <li>Marshall Bowers (@maxdeviant)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Mateus Auler (@mateusauler)</li> <li>Michael Pratt (@prattmic)</li> <li>Nicole Patricia Mazzuca (@strega-nil)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Scott Taylor (@scott2000)</li> <li>T6 (@tjjfvi)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Winter (@winterqt)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0290-2025-05-07","title":"0.29.0 - 2025-05-07","text":""},{"location":"changelog.html#release-highlights_8","title":"Release highlights","text":"<ul> <li>Experimental support for transferring the change ID to/from Git remotes behind configuration   setting <code>git.write-change-id-header</code>. If this is enabled, the change ID will be stored in the Git   commit itself (in a commit header called <code>change-id</code>), which means it will be transferred by   regular <code>git push</code> etc. This is an evolving feature that currently defaults to \"false\". This   default will likely change in the future as we gain confidence with forge support and user   expectations.</li> </ul>"},{"location":"changelog.html#breaking-changes_10","title":"Breaking changes","text":"<ul> <li> <p><code>jj git push -c</code>/<code>--change</code> no longer moves existing local bookmarks.</p> </li> <li> <p>The <code>editor-*.jjdescription</code> files passed to your editor by e.g. <code>jj describe</code>   are now written to your system's temporary directory instead of <code>.jj/repo/</code>.</p> </li> </ul>"},{"location":"changelog.html#deprecations_10","title":"Deprecations","text":"<ul> <li> <p><code>git.subprocess = false</code> has been deprecated, and the old <code>libgit2</code>   code path for fetches and pushes will be removed entirely in 0.30.   Please report any remaining issues you have with the Git   subprocessing path.</p> </li> <li> <p><code>ui.default-description</code> has been deprecated, and will be migrated to   <code>template-aliases.default_commit_description</code>. Please also consider using   <code>templates.draft_commit_description</code>,   and/or <code>templates.commit_trailers</code>.</p> </li> <li> <p>On macOS, config.toml files in <code>~/Library/Application Support/jj</code> are   deprecated; one should instead use <code>$XDG_CONFIG_HOME/jj</code>   (defaults to <code>~/.config/jj</code>)</p> </li> </ul>"},{"location":"changelog.html#new-features_10","title":"New features","text":"<ul> <li> <p>Color-words diff has gained an option to compare conflict pairs without   materializing.</p> </li> <li> <p><code>jj show</code> patches can now be suppressed with <code>--no-patch</code>.</p> </li> <li> <p>Added <code>ui.bookmark-list-sort-keys</code> setting to configure default sort keys for the   <code>jj bookmark list</code> command.</p> </li> <li> <p>New <code>signed</code> revset function to filter for cryptographically signed commits.</p> </li> <li> <p><code>jj describe</code>, <code>jj commit</code>, <code>jj new</code>, <code>jj squash</code> and <code>jj split</code> add the   commit trailers, configured in the <code>commit_trailers</code> template, to the commit   description. Use cases include DCO Sign Off and Gerrit Change Id.</p> </li> <li> <p>Added <code>duplicate_description</code> template, which allows customizing the descriptions   of the commits <code>jj duplicate</code> creates.</p> </li> <li> <p><code>jj absorb</code> can now squash a deleted file if it was added by one of the   destination revisions.</p> </li> <li> <p>Added <code>ui.streampager.show-ruler</code> setting to configure whether the ruler should be   shown when the builtin pager starts up.</p> </li> <li> <p><code>jj git fetch</code> now warns instead of erroring for unknown <code>git.fetch</code> remotes   if other remotes are available.</p> </li> <li> <p>Commit objects in templates now have <code>trailers() -&gt; List&lt;Trailer&gt;</code>, the Trailer   objects have <code>key() -&gt; String</code> and <code>value() -&gt; String</code>.</p> </li> <li> <p><code>jj config edit</code> will now roll back to previous version if a syntax error has been introduced in the new config.</p> </li> <li> <p>When using dynamic command-line completion, revision names will be completed   in more complex expressions. For example, typing   <code>jj log -r first-bookmark..sec</code> and then pressing Tab could complete the   expression to <code>first-bookmark..second-bookmark</code>.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_10","title":"Fixed bugs","text":"<ul> <li> <p>Fixed crash on change-delete conflict resolution.   #6250</p> </li> <li> <p>The builtin diff editor now tries to preserve unresolved conflicts.   #4963</p> </li> <li> <p>Fixed bash and zsh shell completion when completing aliases of multiple arguments.   #5377</p> </li> </ul>"},{"location":"changelog.html#packaging-changes_3","title":"Packaging changes","text":"<ul> <li>Jujutsu now uses   <code>zlib-rs</code>, a   fast compression library written in Rust. Packagers should remove any   dependency on CMake and drop the <code>packaging</code> Cargo feature.</li> </ul>"},{"location":"changelog.html#contributors_9","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aleksey Kuznetsov (@zummenix)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Caleb White (@calebdw)</li> <li>Daniel Luz (@mernen)</li> <li>Emily (@emilazy)</li> <li>Emily (@neongreen)</li> <li>Ga\u00ebtan Lehmann (@glehmann)</li> <li>George Christou (@gechr)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jacob Hayes (@JacobHayes)</li> <li>Jonas Greitemann (@jgreitemann)</li> <li>Josh Steadmon (@steadmon)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Mateus Auler (@mateusauler)</li> <li>Nicole Patricia Mazzuca (@strega-nil)</li> <li>Nils Koch (@nilskch)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Sam (@Samasaur1)</li> <li>Steve Fink (@hotsphink)</li> <li>Th\u00e9o Daron (@tdaron)</li> <li>TimerErTim (@TimerErTim)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Winter (@winterqt)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0282-2025-04-07","title":"0.28.2 - 2025-04-07","text":""},{"location":"changelog.html#fixed-bugs_11","title":"Fixed bugs","text":"<ul> <li>Fixed problem that old commits could be re-imported from Git.   https://github.com/GitoxideLabs/gitoxide/issues/1928</li> </ul>"},{"location":"changelog.html#0281-2025-04-04","title":"0.28.1 - 2025-04-04","text":""},{"location":"changelog.html#security-fixes","title":"Security fixes","text":"<ul> <li>Fixed SHA-1 collision attacks not being detected.   (GHSA-794x-2rpg-rfgr)</li> </ul>"},{"location":"changelog.html#fixed-bugs_12","title":"Fixed bugs","text":"<ul> <li> <p>Resolved some potential build issues for packagers.   #6232</p> </li> <li> <p>Fix a bug with <code>:ours</code> and <code>:theirs</code> merge tools involving conflicted trees   with more than two sides. #6227</p> </li> </ul>"},{"location":"changelog.html#contributors_10","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Emily (@emilazy)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Nicole Patricia Mazzuca (@strega-nil)</li> <li>Scott Taylor (@scott2000)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0280-2025-04-02","title":"0.28.0 - 2025-04-02","text":""},{"location":"changelog.html#release-highlights_9","title":"Release highlights","text":"<ul> <li> <p>jj's configuration can now be split into multiple files more easily.</p> </li> <li> <p><code>jj resolve</code> now accepts built-in tools <code>:ours</code> and <code>:theirs</code>.</p> </li> <li> <p>In colocated repos, newly-created files will now appear in <code>git diff</code>.</p> </li> <li> <p>A long-standing bug relating to empty files in the built-in diff editor was   fixed. #3702</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_11","title":"Breaking changes","text":"<ul> <li> <p>The minimum supported Rust version (MSRV) is now 1.84.0.</p> </li> <li> <p>The <code>git.push-branch-prefix</code> config has been removed in favor of   <code>git.push-bookmark-prefix</code>.</p> </li> <li> <p><code>jj abandon</code> no longer supports <code>--summary</code> to suppress the list of abandoned   commits. The list won't show more than 10 commits to not clutter the console.</p> </li> <li> <p><code>jj unsquash</code> has been removed in favor of <code>jj squash</code> and   <code>jj diffedit --restore-descendants</code>.</p> </li> <li> <p>The <code>jj untrack</code> subcommand has been removed in favor of <code>jj file untrack</code>.</p> </li> <li> <p>The following deprecated revset functions have been removed:</p> <ul> <li><code>branches()</code>, <code>remote_branches()</code>, <code>tracked_remote_branches()</code>, and   <code>untracked_remote_branches()</code>, which were renamed to \"bookmarks\".</li> <li><code>file()</code> and <code>conflict()</code>, which were renamed to plural forms.</li> <li><code>files(x, y, ..)</code> with multiple patterns. Use <code>files(x|y|..)</code> instead.</li> </ul> </li> <li> <p>The following deprecated template functions have been removed:</p> <ul> <li><code>branches()</code>, <code>local_branches()</code>, and <code>remote_branches()</code>, which were   renamed to \"bookmarks\".</li> </ul> </li> <li> <p>The flags <code>--all</code> and <code>--tracked</code> on <code>jj git push</code> by themself do not cause   deleted bookmarks to be pushed anymore, as an additional safety measure. They   can now be combined with <code>--deleted</code> instead.</p> </li> </ul>"},{"location":"changelog.html#deprecations_11","title":"Deprecations","text":"<ul> <li> <p><code>core.watchman.register_snapshot_trigger</code> has been renamed to <code>core.watchman.register-snapshot-trigger</code> for consistency with other configuration options.</p> </li> <li> <p><code>jj backout</code> is deprecated in favor of <code>jj revert</code>.</p> </li> </ul>"},{"location":"changelog.html#new-features_11","title":"New features","text":"<ul> <li> <p><code>jj sign</code> can now sign with PKCS#12 certificates through the <code>gpgsm</code> backend.</p> </li> <li> <p><code>jj sign</code> will automatically use the gpg key associated with the author's email   in the absence of a <code>signing.key</code> configuration.</p> </li> <li> <p>Multiple user configs are now supported and are loaded in the following precedence order:</p> <ul> <li><code>$HOME/.jjconfig.toml</code></li> <li><code>$XDG_CONFIG_HOME/jj/config.toml</code></li> <li><code>$XDG_CONFIG_HOME/jj/conf.d/*.toml</code></li> </ul> </li> <li> <p>The <code>JJ_CONFIG</code> environment variable can now contain multiple paths separated   by a colon (or semicolon on Windows).</p> </li> <li> <p>The command <code>jj config list</code> now supports showing the origin of each variable   via the <code>builtin_config_list_detailed</code> template.</p> </li> <li> <p><code>jj config {edit,set,unset}</code> now prompt when multiple config files are found.</p> </li> <li> <p><code>jj diff -r</code> now allows multiple revisions (as long as there are no gaps in   the revset), such as <code>jj diff -r 'mutable()'</code>.</p> </li> <li> <p><code>jj git push</code> now accepts a <code>--named NAME=REVISION</code> argument to create a named   bookmark and immediately push it.</p> </li> <li> <p>The 'how to resolve conflicts' hint that is shown when conflicts appear can   be hidden by setting <code>hints.resolving-conflicts = false</code>.</p> </li> <li> <p><code>jj op diff</code> and <code>jj op log --op-diff</code> now show changes to which commits   correspond to working copies.</p> </li> <li> <p><code>jj op log -d</code> is now an alias for <code>jj op log --op-diff</code>.</p> </li> <li> <p><code>jj bookmark move --to/--from</code> can now be abbreviated to <code>jj bookmark move -t/-f</code></p> </li> <li> <p><code>jj bookmark list</code> now supports <code>--sort</code> option. Similar to <code>git branch --sort</code>.   See <code>jj bookmark list --help</code> for more details.</p> </li> <li> <p>A new command <code>jj revert</code> is added, which is similar to <code>jj backout</code> but   adds the <code>--destination</code>, <code>--insert-after</code>, and <code>--insert-before</code> options to   customize the location of reverted commits.</p> </li> <li> <p>A new command <code>jj git root</code> is added, which prints the location of the Git   directory of a repository using the Git backend.</p> </li> <li> <p>In colocated repos, any files that jj considers added in the working copy will   now show up in <code>git diff</code> (as if you had run <code>git add --intent-to-add</code> on   them).</p> </li> <li> <p>Reversing colors is now supported. For example, to highlight words by   reversing colors rather than underlining, you can set   <code>colors.\"diff token\"={ underline = false, reverse = true }</code> in your config.</p> </li> <li> <p>Added <code>revsets.log-graph-prioritize</code>, which can be used to configure   which branch in the <code>jj log</code> graph is displayed on the left instead of <code>@</code>   (e.g. <code>coalesce(description(\"megamerge\\n\"), trunk())</code>)</p> </li> <li> <p><code>jj resolve</code> now accepts new built-in merge tools <code>:ours</code> and <code>:theirs</code>.   These merge tools accept side #1 and side #2 of the conflict respectively.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_13","title":"Fixed bugs","text":"<ul> <li> <p><code>jj log -p --stat</code> now shows diff stats as well as the default color-words/git   diff output. #5986</p> </li> <li> <p>The built-in diff editor now correctly handles deleted files.   #3702</p> </li> <li> <p>The built-in diff editor now correctly retains the executable bit on newly   added files when splitting. #3846</p> </li> <li> <p><code>jj config set</code>/<code>--config</code> value parsing rule is relaxed in a way that   unquoted apostrophes are allowed.   #5748</p> </li> <li> <p><code>jj fix</code> could previously create new conflicts when a descendant of a fixed   revision was already correctly formatted.</p> </li> </ul>"},{"location":"changelog.html#contributors_11","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aleksey Kuznetsov (@zummenix)</li> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Baltasar Dinis (@bsdinis)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Brandon Hall (@tenkabuto)</li> <li>Caleb White (@calebdw)</li> <li>Daniel Luz (@mernen)</li> <li>David Rieber (@drieber)</li> <li>demize (@demize)</li> <li>Emily (@emilazy)</li> <li>Evan Mesterhazy (@emesterhazy)</li> <li>Fedor Sheremetyev (@sheremetyev)</li> <li>George Christou (@gechr)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jakob Hellermann (@jakobhellermann)</li> <li>Jo Liss (@joliss)</li> <li>Joachim Desroches (@jedesroches)</li> <li>Johannes Altmanninger (@krobelus)</li> <li>Jonathan Gilchrist (@jgilchrist)</li> <li>Kenyon Ralph (@kenyon)</li> <li>Lucas Garron (@lgarron)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Nick Pupko (@npupko)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Raphael Borun Das Gupta (@das-g)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Robin Stocker (@robinst)</li> <li>Scott Taylor (@scott2000)</li> <li>Siva Mahadevan (@svmhdvn)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0270-2025-03-05","title":"0.27.0 - 2025-03-05","text":""},{"location":"changelog.html#release-highlights_10","title":"Release highlights","text":"<ul> <li><code>git.subprocess</code> is now enabled by default, improving compatibility with Git   fetches and pushes by spawning an external <code>git</code> process. Users can opt out   of this by setting <code>git.subprocess = false</code>, but this will likely be removed   in a future release. Please report any issues you run into.</li> </ul>"},{"location":"changelog.html#breaking-changes_12","title":"Breaking changes","text":"<ul> <li> <p>Bookmark name to be created/updated is now parsed as a revset   symbol. Quotation may be needed in addition to shell   quotes. Example: <code>jj bookmark create -r@- \"'name with space'\"</code></p> </li> <li> <p><code>jj bookmark create</code>, <code>jj bookmark set</code> and <code>jj bookmark move</code> onto a hidden    commit make it visible.</p> </li> <li> <p><code>jj bookmark forget</code> now untracks any corresponding remote bookmarks instead   of forgetting them, since forgetting a remote bookmark can be unintuitive.   The old behavior is still available with the new <code>--include-remotes</code> flag.</p> </li> <li> <p><code>jj fix</code> now always sets the working directory of invoked tools to be the   workspace root, instead of the working directory of the <code>jj fix</code>.</p> </li> <li> <p>The <code>ui.allow-filesets</code> configuration option has been removed.   The \"fileset\" language has been enabled by default since v0.20.</p> </li> <li> <p><code>templates.annotate_commit_summary</code> is renamed to <code>templates.file_annotate</code>,   and now has an implicit <code>self</code> parameter of type <code>AnnotationLine</code>, instead of   <code>Commit</code>. All methods on <code>Commit</code> can be accessed with <code>commit.method()</code>, or   <code>self.commit().method()</code>.</p> </li> </ul>"},{"location":"changelog.html#deprecations_12","title":"Deprecations","text":"<ul> <li> <p>This release takes the first steps to make target revision required in   <code>bookmark create</code>, <code>bookmark move</code> and <code>bookmark set</code>. Those commands will display   a warning if the user does not specify target revision  explicitly. In the near   future those commands will fail if target revision is not specified.</p> </li> <li> <p>The <code>signing.sign-all</code> config option has been deprecated in favor of   <code>signing.behavior</code>. The new option accepts <code>drop</code> (never sign), <code>keep</code> (preserve   existing signatures), <code>own</code> (sign own commits), or <code>force</code> (sign all commits).   Existing <code>signing.sign-all = true</code> translates to <code>signing.behavior = \"own\"</code>, and   <code>false</code> translates to <code>\"keep\"</code>. Invalid configuration is now an error.</p> </li> </ul>"},{"location":"changelog.html#new-features_12","title":"New features","text":"<ul> <li> <p>The new <code>jj sign</code> and <code>jj unsign</code> commands allow for signing/unsigning commits.   <code>jj sign</code> supports configuring the default revset through <code>revsets.sign</code> when   no <code>--revisions</code> arguments are provided.</p> </li> <li> <p><code>jj git fetch</code> now supports string pattern syntax   on <code>--remote</code> option and <code>git.fetch</code> configuration.</p> </li> <li> <p>Template functions <code>truncate_start()</code> and <code>truncate_end()</code> gained an optional   <code>ellipsis</code> parameter; passing this prepends or appends the ellipsis to the   content if it is truncated to fit the maximum width.</p> </li> <li> <p>Templates now support <code>stringify(x)</code> function and string method   <code>.escape_json()</code>. The latter serializes the string in JSON format. It is   useful for making machine-readable templates by escaping problematic   characters like <code>\\n</code>.</p> </li> <li> <p>Templates now support <code>trim()</code>, <code>trim_start()</code> and <code>trim_end()</code> methods   which remove whitespace from the start and end of a <code>String</code> type.</p> </li> <li> <p>The description of commits backed out by <code>jj backout</code> can now be configured   using <code>templates.backout_description</code>.</p> </li> <li> <p>New <code>AnnotationLine</code> templater type. Used in <code>templates.file_annotate</code>.   Provides <code>self.commit()</code>, <code>.content()</code>, <code>.line_number()</code>, and   <code>.first_line_in_hunk()</code>.</p> </li> <li> <p>Templates now have <code>format_short_operation_id(id)</code> function for users to   customize the default operation id representation.</p> </li> <li> <p>The <code>jj init</code>/<code>jj revert</code> stubs that print errors can now be overridden with   aliases. All of <code>jj clone/init/revert</code> add a hint to a generic error.</p> </li> <li> <p>Help text is now colored (when stdout is a terminal).</p> </li> <li> <p>Commands that used to suggest <code>--ignore-immutable</code> now print the number of   immutable commits that would be rewritten if used and a link to the docs.</p> </li> <li> <p><code>jj undo</code> now shows a hint when undoing an undo operation that the user may    be looking for <code>jj op restore</code> instead.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_14","title":"Fixed bugs","text":"<ul> <li> <p><code>jj status</code> now shows untracked files under untracked directories.   #5389</p> </li> <li> <p>Added workaround for the bug that untracked files are ignored when watchman is   enabled. #5728</p> </li> <li> <p>The <code>signing.backends.ssh.allowed-signers</code> configuration option will now   expand <code>~/</code> to <code>$HOME/</code>.   #5626</p> </li> <li> <p><code>config-schema.json</code> now allows arrays of strings for the settings <code>ui.editor</code>   and <code>ui.diff.tool</code>.</p> </li> <li> <p><code>config-schema.json</code> now allows an array of strings or nested table for the   <code>ui.pager</code> setting.</p> </li> </ul>"},{"location":"changelog.html#contributors_12","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alain Leufroy (@aleufroy)</li> <li>Aleksey Kuznetsov (@zummenix)</li> <li>Alexander Mikhailov (@AM5800)</li> <li>Andrew Gilbert (@andyg0808)</li> <li>Antoine Martin (@alarsyo)</li> <li>Anton Bulakh (@necauqua)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Baltasar Dinis (@bsdinis)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Bryce Berger (@bryceberger)</li> <li>Burak Varl\u0131 (@unexge)</li> <li>David Rieber (@drieber)</li> <li>Emily (@emilazy)</li> <li>Evan Mesterhazy (@emesterhazy)</li> <li>George Christou (@gechr)</li> <li>HKalbasi (@HKalbasi)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jacob Hayes (@JacobHayes)</li> <li>Jonathan Frere (@MrJohz)</li> <li>Jonathan Tan (@jonathantanmy)</li> <li>Josh Steadmon (@steadmon)</li> <li>maan2003 (@maan2003)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matthew Davidson (@KingMob)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Philipp Albrecht (@pylbrecht)</li> <li>Roman Timushev (@rtimush)</li> <li>Samuel Tardieu (@samueltardieu)</li> <li>Scott Taylor (@scott2000)</li> <li>Stephan H\u00fcgel (@urschrei)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0260-2025-02-05","title":"0.26.0 - 2025-02-05","text":""},{"location":"changelog.html#release-highlights_11","title":"Release highlights","text":"<ul> <li> <p>Improved Git push/fetch compatibility by spawning an external <code>git</code> process.   This can be enabled by the <code>git.subprocess=true</code> config knob, and will be the   default in a future release.</p> </li> <li> <p><code>jj log</code> can now show cryptographic commit signatures. The output can be   controlled by the <code>ui.show-cryptographic-signatures=true</code> config knob.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_13","title":"Breaking changes","text":"<ul> <li> <p><code>jj abandon</code> now deletes bookmarks pointing to the revisions to be abandoned.   Use <code>--retain-bookmarks</code> to move bookmarks backwards. If deleted bookmarks   were tracking remote bookmarks, the associated bookmarks (or branches) will be   deleted from the remote on <code>jj git push --all</code>.   #3505</p> </li> <li> <p><code>jj init --git</code> and <code>jj init --git-repo</code> have been removed. They were   deprecated in early 2024. Use <code>jj git init</code> instead.</p> </li> <li> <p>The following deprecated commands have been removed:</p> <ul> <li><code>jj cat</code> is replaced by <code>jj file show</code>.</li> <li><code>jj chmod</code> is replaced by <code>jj file chmod</code>.</li> <li><code>jj files</code> is replaced by <code>jj file list</code>.</li> </ul> </li> <li> <p>The deprecated <code>-l</code> short alias for <code>--limit</code> in <code>jj log</code>, <code>jj op log</code>   and <code>jj obslog</code> has been removed. The <code>-n</code> short alias can be used instead.</p> </li> <li> <p>The deprecated <code>--siblings</code> options for <code>jj split</code> has been removed.   <code>jj split --parallel</code> can be used instead.</p> </li> <li> <p>The deprecated <code>fix.tool-command</code> config option has been removed.</p> </li> <li> <p>In colocated repos, the Git index now contains the changes from all parents   of the working copy instead of just the first parent (<code>HEAD</code>). 2-sided   conflicts from the merged parents are now added to the Git index as conflicts   as well.</p> </li> <li> <p>The following change introduced in 0.25.0 is reverted:</p> <ul> <li><code>jj config list</code> now prints inline tables <code>{ key = value, .. }</code> literally.   Inner items of inline tables are no longer merged across configuration   files.</li> </ul> </li> <li> <p><code>jj resolve</code> will now attempt to resolve all conflicted files instead of   resolving the first conflicted file. To resolve a single file, pass a file   path to <code>jj resolve</code>.</p> </li> <li> <p><code>jj util mangen</code> is replaced with <code>jj util install-man-pages</code>, which can   install man pages for all <code>jj</code> subcommands to a given path.</p> </li> <li> <p>In <code>jj config list</code> template, <code>value</code> is now typed as <code>ConfigValue</code>, not as   <code>String</code> serialized in TOML syntax.</p> </li> <li> <p><code>jj git remote add</code>/<code>set-url</code> now converts relative Git remote path to   absolute path.</p> </li> <li> <p><code>jj log</code>/<code>op log</code> now applies <code>-n</code>/<code>--limit</code> before the items are reversed.   Rationale: It's more useful to see the N most recent commits/operations, and   is more performant. The old behavior can be achieved by <code>jj log .. | head</code>.   #5403</p> </li> <li> <p>Upgraded <code>scm-record</code> from v0.4.0 to v0.5.0. See release notes at   https://github.com/arxanas/scm-record/releases/tag/v0.5.0.</p> </li> <li> <p>The builtin pager is switched to   streampager. It can handle large   inputs better and can be configured.</p> </li> <li> <p>Conflicts materialized in the working copy before <code>jj 0.19.0</code> may no longer   be parsed correctly. If you are using version 0.18.0 or earlier, check out a   non-conflicted commit before upgrading to prevent issues.</p> </li> </ul>"},{"location":"changelog.html#deprecations_13","title":"Deprecations","text":""},{"location":"changelog.html#new-features_13","title":"New features","text":"<ul> <li> <p><code>jj git {push,clone,fetch}</code> can now spawn an external <code>git</code> subprocess, via    the <code>git.subprocess = true</code> config knob. This provides an alternative that,    when turned on, fixes SSH bugs when interacting with Git remotes due to    <code>libgit2</code>s limitations #4979.</p> </li> <li> <p><code>jj describe</code> now accepts <code>--edit</code>.</p> </li> <li> <p><code>jj evolog</code> and <code>jj op log</code> now accept <code>--reversed</code>.</p> </li> <li> <p><code>jj restore</code> now supports <code>-i</code>/<code>--interactive</code> selection.</p> </li> <li> <p><code>jj file list</code> now supports templating.</p> </li> <li> <p>There is a new <code>builtin_op_log_oneline</code> template alias you can pass to <code>jj op   log -T</code> for a more compact output. You can use <code>format_operation_oneline</code> and   <code>format_snapshot_operation_oneline</code> to customize parts of it.</p> </li> <li> <p>New template function <code>config(name)</code> to access to configuration variable from   template.</p> </li> <li> <p>New template function <code>pad_centered()</code> to center content within a minimum   width.</p> </li> <li> <p>Templater now supports <code>list.filter(|x| ..)</code> method.</p> </li> <li> <p>The <code>diff</code> commit template keyword now supports custom formatting via   <code>diff.files()</code>. For example, <code>diff.files().map(|e| e.path().display())</code> prints   changed file paths.</p> </li> <li> <p>The <code>diff.stat()</code> template method now provides methods to get summary values.</p> </li> <li> <p><code>jj log</code> can now show cryptographic commit signatures. The output can be   controlled by the <code>ui.show-cryptographic-signatures=true</code> config knob. The   signature template can be customized using   <code>format_detailed_cryptographic_signature(signature)</code> and   <code>format_short_cryptographic_signature(signature)</code>.</p> </li> <li> <p>New <code>git.sign-on-push</code> config option to automatically sign commits which are   being pushed to a Git remote.</p> </li> <li> <p>New <code>git.push-new-bookmarks</code> config option to push new bookmarks without   <code>--allow-new</code>.</p> </li> <li> <p><code>jj status</code> now shows untracked files when they reside directly under a   tracked directory. There's still an issue that files under untracked   directories aren't listed. #5389</p> </li> <li> <p>New <code>merge-tools.&lt;TOOL&gt;.diff-expected-exit-codes</code> config option to suppress   warnings from tools exiting with non-zero exit codes.</p> </li> <li> <p>New <code>fix.tools.TOOL.enabled</code> config option to enable/disable tools. This is   useful for defining disabled tools in user configuration that can be enabled   in individual repositories with one config setting.</p> </li> <li> <p>Added <code>--into</code> flag to <code>jj restore</code>, similarly to <code>jj squash</code> and <code>jj   absorb</code>. It is equivalent to <code>--to</code>, but <code>--into</code> is the recommended name.</p> </li> <li> <p>Italic text is now supported. You can set e.g. <code>colors.error = { fg = \"red\",   italic = true }</code> in your config.</p> </li> <li> <p>New <code>author_name</code>/<code>author_email</code>/<code>committer_name</code>/<code>committer_email(pattern)</code>   revset functions to match either name or email field explicitly.</p> </li> <li> <p>New <code>subject(pattern)</code> revset function that matches first line of commit   descriptions.</p> </li> <li> <p>Conditional configuration now supports <code>--when.commands</code> to change   configuration based on subcommand.</p> </li> <li> <p>The Jujutsu documentation site now publishes a schema for the official   configuration file, which can be integrated into your editor for autocomplete,   inline errors, and more.   Please see the documentation for more   on this.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_15","title":"Fixed bugs","text":"<ul> <li> <p><code>jj git fetch</code> with multiple remotes will now fetch from all remotes before   importing refs into the jj repo. This fixes a race condition where the   treatment of a commit that is found in multiple fetch remotes depended on the   order the remotes were specified.</p> </li> <li> <p>Fixed diff selection by external tools with <code>jj split</code>/<code>commit -i FILESETS</code>.   #5252</p> </li> <li> <p>Conditional configuration now applies when initializing new repository.   #5144</p> </li> <li> <p><code>[diff.&lt;format&gt;]</code> configuration now applies to <code>.diff().&lt;format&gt;()</code> commit   template methods.</p> </li> <li> <p>Conflicts at the end of files which don't end with a newline character are   now materialized in a way that can be parsed correctly.   #3968</p> </li> <li> <p>Bookmark and remote names written by <code>jj git clone</code> to   <code>revset-aliases.'trunk()'</code> are now escaped if necessary.   #5359</p> </li> </ul>"},{"location":"changelog.html#contributors_13","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Angel Ezquerra (@AngelEzquerra)</li> <li>Antoine Martin (@alarsyo)</li> <li>Anton Bulakh (@necauqua)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Baltasar Dinis (@bsdinis)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>blinry (@blinry)</li> <li>Bryce Berger (@bryceberger)</li> <li>Charlie-83 (@Charlie-83)</li> <li>Christian Stoitner (@cstoitner)</li> <li>Evan Martin (@evmar)</li> <li>George Christou (@gechr)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jakob Hellermann (@jakobhellermann)</li> <li>JDSeiler (@JDSeiler)</li> <li>Jonathan Frere (@MrJohz)</li> <li>Jonathan Gilchrist (@jgilchrist)</li> <li>Josh Steadmon (@steadmon)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Kulukundis (@fowles)</li> <li>Ollivier Robert (@keltia)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Philipp Albrecht (@pylbrecht)</li> <li>Robert Jackson (@rwjblue)</li> <li>Samuel Tardieu (@samueltardieu)</li> <li>Scott Taylor (@scott2000)</li> <li>Stephen Jennings (@jennings)</li> <li>Valentin Gatien-Baron (@v-gb)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0250-2025-01-01","title":"0.25.0 - 2025-01-01","text":""},{"location":"changelog.html#release-highlights_12","title":"Release highlights","text":"<p>It's the holidays, and this release was overall pretty quiet, without many major changes. Two select improvements:</p> <ul> <li> <p>Improvements to configuration management, including support for conditional   variables in config files.</p> </li> <li> <p>Large files in the working copy will no longer cause commands to fail; instead   the large files will remain intact but untracked in the working copy.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_14","title":"Breaking changes","text":"<ul> <li> <p>Configuration variables are no longer \"stringly\" typed. For example, <code>true</code> is   not converted to a string <code>\"true\"</code>, and vice versa.</p> </li> <li> <p>The following configuration variables are now parsed strictly:   <code>colors.&lt;labels&gt;</code>, <code>git.abandon-unreachable-commits</code>,   <code>git.auto-local-bookmark</code>, <code>git.push-bookmark-prefix</code>, <code>revsets.log</code>,   <code>revsets.short-prefixes</code>, <code>signing.backend</code>, <code>operation.hostname</code>,   <code>operation.username</code>, <code>ui.allow-init-native</code>, <code>ui.color</code>,   <code>ui.default-description</code>, <code>ui.progress-indicator</code>, <code>ui.quiet</code>, <code>user.email</code>,   <code>user.name</code></p> </li> <li> <p><code>jj config list</code> now prints inline tables <code>{ key = value, .. }</code> literally.   Inner items of inline tables are no longer merged across configuration files.   See the table syntax   documentation for   details.</p> </li> <li> <p><code>jj config edit --user</code> now opens a file even if <code>$JJ_CONFIG</code> points to a   directory. If there are multiple config files, the command will fail.</p> </li> <li> <p><code>jj config set</code> no longer accepts a bare string value that looks like a TOML   expression. For example, <code>jj config set NAME '[foo]'</code> must be quoted as <code>jj   config set NAME '\"[foo]\"'</code>.</p> </li> <li> <p>The deprecated <code>[alias]</code> config section is no longer respected. Move command   aliases to the <code>[aliases]</code> section.</p> </li> <li> <p><code>jj absorb</code> now abandons the source commit if it becomes empty and has no   description.</p> </li> </ul>"},{"location":"changelog.html#deprecations_14","title":"Deprecations","text":"<ul> <li> <p><code>--config-toml=TOML</code> is deprecated in favor of <code>--config=NAME=VALUE</code> and   <code>--config-file=PATH</code>.</p> </li> <li> <p>The <code>Signature.username()</code> template method is deprecated for   <code>Signature.email().local()</code>.</p> </li> </ul>"},{"location":"changelog.html#new-features_14","title":"New features","text":"<ul> <li> <p><code>jj</code> command no longer fails due to new working-copy files larger than the   <code>snapshot.max-new-file-size</code> config option. It will print a warning and large   files will be left untracked.</p> </li> <li> <p>Configuration files now support conditional   variables.</p> </li> <li> <p>New command options <code>--config=NAME=VALUE</code> and <code>--config-file=PATH</code> to set   string value without quoting and to load additional configuration from files.</p> </li> <li> <p>Templates now support the <code>&gt;=</code>, <code>&gt;</code>, <code>&lt;=</code>, and <code>&lt;</code> relational operators for   <code>Integer</code> types.</p> </li> <li> <p>A new Email template type is added. <code>Signature.email()</code> now returns an Email   template type instead of a String.</p> </li> <li> <p>Adds a new template alias <code>commit_timestamp(commit)</code> which defaults to the   committer date.</p> </li> <li> <p>Conflict markers are now allowed to be longer than 7 characters, allowing   conflicts to be materialized and parsed correctly in files which already   contain lines that look like conflict markers.</p> </li> <li> <p>New <code>$marker_length</code> variable to allow merge tools to support longer conflict   markers (equivalent to \"%L\" for Git merge drivers).</p> </li> <li> <p><code>jj describe</code> now accepts a <code>JJ: ignore-rest</code> line that ignores everything   below it, similar to a \"scissor line\" in git. When editing multiple commits,   only ignore until the next <code>JJ: describe</code> line.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_16","title":"Fixed bugs","text":"<ul> <li> <p>The <code>$NO_COLOR</code> environment variable must now be non-empty to be respected.</p> </li> <li> <p>Fixed incompatible rendering of empty hunks in git/unified diffs.   #5049</p> </li> <li> <p>Fixed performance of progress bar rendering when fetching from Git remote.   #5057</p> </li> <li> <p><code>jj config path --user</code> no longer creates new file at the default config path.</p> </li> <li> <p>On Windows, workspace paths (printed by <code>jj root</code>) no longer use UNC-style   <code>\\\\?\\</code> paths unless necessary.</p> </li> <li> <p>On Windows, <code>jj git clone</code> now converts local Git remote path to   slash-separated path.</p> </li> <li> <p><code>jj resolve</code> no longer removes the executable bit on resolved files when using   an external merge tool.</p> </li> </ul>"},{"location":"changelog.html#contributors_14","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alex Stefanov (@umnikos)</li> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Bryce Berger (@bryceberger)</li> <li>Daniel Ploch (@torquestomp)</li> <li>David Crespo (@david-crespo)</li> <li>George Tsiamasiotis (@gtsiam)</li> <li>Jochen Kupperschmidt (@homeworkprod)</li> <li>Keane Nguyen (@keanemind)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Kulukundis (@fowles)</li> <li>Milo Moisson (@mrnossiom)</li> <li>petricavalry (@petricavalry)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Scott Taylor (@scott2000)</li> <li>Shane Sveller (@shanesveller)</li> <li>Stephen Jennings (@jennings)</li> <li>Tim Janik (@tim-janik)</li> <li>Vamsi Avula (@avamsi)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0240-2024-12-04","title":"0.24.0 - 2024-12-04","text":""},{"location":"changelog.html#release-highlights_13","title":"Release highlights","text":"<ul> <li> <p>New <code>jj absorb</code> command automatically squashes changes from the current commit into relevant ancestor commits.</p> </li> <li> <p>Experimental dynamic shell completions have been added; see the docs for configuration.</p> </li> <li> <p><code>jj duplicate</code> now accepts <code>--destination</code>/<code>--insert-before</code>/<code>--insert-after</code>.</p> </li> <li> <p>Some deprecated commands have been removed (<code>jj move</code>, <code>jj checkout</code>, <code>jj merge</code>).</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_15","title":"Breaking changes","text":"<ul> <li> <p><code>jj move</code> has been removed. It was deprecated in 0.16.0.</p> </li> <li> <p><code>jj checkout</code> and the built-in alias <code>jj co</code> have been removed.   It was deprecated in 0.14.0.</p> </li> <li> <p><code>jj merge</code> has been removed. It was deprecated in 0.14.0.</p> </li> <li> <p><code>jj git push</code> no longer pushes new bookmarks by default. Use <code>--allow-new</code> to   bypass this restriction.</p> </li> <li> <p>Lines prefixed with \"JJ:\" in commit descriptions and in sparse patterns (from   <code>jj sparse edit</code>) are now stripped even if they are not immediately followed   by a space. #5004</p> </li> </ul>"},{"location":"changelog.html#deprecations_15","title":"Deprecations","text":""},{"location":"changelog.html#new-features_15","title":"New features","text":"<ul> <li> <p>Templates now support the <code>==</code> and <code>!=</code> logical operators for <code>Boolean</code>,   <code>Integer</code>, and <code>String</code> types.</p> </li> <li> <p>New command <code>jj absorb</code> that moves changes to stack of mutable revisions.</p> </li> <li> <p>New command <code>jj util exec</code> that can be used for arbitrary aliases.</p> </li> <li> <p><code>jj rebase -b</code> can now be used with the <code>--insert-after</code> and <code>--insert-before</code>   options, like <code>jj rebase -r</code> and <code>jj rebase -s</code>.</p> </li> <li> <p>A preview of improved shell completions was added. Please refer to the   documentation   to activate them. They additionally complete context-dependent, dynamic values   like bookmarks, aliases, revisions, operations and files.</p> </li> <li> <p>Added the config setting <code>snapshot.auto-update-stale</code> for automatically   running <code>jj workspace update-stale</code> when applicable.</p> </li> <li> <p><code>jj duplicate</code> now accepts <code>--destination</code>, <code>--insert-after</code> and   <code>--insert-before</code> options to customize the location of the duplicated   revisions.</p> </li> <li> <p><code>jj log</code> now displays the working-copy branch first.</p> </li> <li> <p>New <code>fork_point()</code> revset function can be used to obtain the fork point   of multiple commits.</p> </li> <li> <p>The <code>tags()</code> revset function now takes an optional <code>pattern</code> argument,   mirroring that of <code>bookmarks()</code>.</p> </li> <li> <p>Several commands now support <code>-f/-t</code> shorthands for <code>--from/--to</code>:</p> <ul> <li><code>diff</code></li> <li><code>diffedit</code></li> <li><code>interdiff</code></li> <li><code>op diff</code></li> <li><code>restore</code></li> </ul> </li> <li> <p>New <code>ui.conflict-marker-style</code> config option to change how conflicts are   materialized in the working copy. The default option (\"diff\") renders   conflicts as a snapshot with a list of diffs to apply to the snapshot.   The new \"snapshot\" option renders conflicts as a series of snapshots, showing   each side and base of the conflict. The new \"git\" option replicates Git's   \"diff3\" conflict style, meaning it is more likely to work with external tools,   but it doesn't support conflicts with more than 2 sides.</p> </li> <li> <p>New <code>merge-tools.&lt;TOOL&gt;.conflict-marker-style</code> config option to override the   conflict marker style used for a specific merge tool.</p> </li> <li> <p>New <code>merge-tools.&lt;TOOL&gt;.merge-conflict-exit-codes</code> config option to allow a   merge tool to exit with a non-zero code to indicate that not all conflicts   were resolved.</p> </li> <li> <p><code>jj simplify-parents</code> now supports configuring the default revset when no    <code>--source</code> or <code>--revisions</code> arguments are provided with the    <code>revsets.simplify-parents</code> config.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_17","title":"Fixed bugs","text":"<ul> <li><code>jj config unset &lt;TABLE-NAME&gt;</code> no longer removes a table (such as <code>[ui]</code>.)</li> </ul>"},{"location":"changelog.html#contributors_15","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Emily (@neongreen)</li> <li>Essien Ita Essien (@essiene)</li> <li>Herman J. Radtke III (@hjr3)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Joaqu\u00edn Tri\u00f1anes (@JoaquinTrinanes)</li> <li>Lars Francke (@lfrancke)</li> <li>Luke Randall (@lukerandall)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Nathanael Huffman (@nathanaelhuffman)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Robin Stocker (@robinst)</li> <li>Scott Taylor (@scott2000)</li> <li>Shane Sveller (@shanesveller)</li> <li>Tim Janik (@tim-janik)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0230-2024-11-06","title":"0.23.0 - 2024-11-06","text":""},{"location":"changelog.html#security-fixes_1","title":"Security fixes","text":"<ul> <li>Fixed path traversal by cloning/checking out crafted Git repository containing   <code>..</code>, <code>.jj</code>, <code>.git</code> paths.   (GHSA-88h5-6w7m-5w56;CVE-2024-51990)</li> </ul>"},{"location":"changelog.html#breaking-changes_16","title":"Breaking changes","text":"<ul> <li> <p>Revset function names can no longer start with a number.</p> </li> <li> <p>Evaluation error of <code>revsets.short-prefixes</code> configuration is now reported.</p> </li> <li> <p>The <code>HEAD@git</code> symbol no longer resolves to the Git HEAD revision. Use   <code>git_head()</code> or <code>@-</code> revset expression instead. The <code>git_head</code> template   keyword now returns a boolean.</p> </li> <li> <p>Help command doesn't work recursively anymore, i.e. <code>jj workspace help root</code>   doesn't work anymore.</p> </li> <li> <p>The color label <code>op_log</code> from the <code>[colors]</code> config section now only   applies to the op log and not to the other places operations are displayed. In   almost all cases, if you configured <code>op_log</code> before, you should use the new   <code>operation</code> label instead.</p> </li> <li> <p>Default operation log template now shows end times of operations instead of   start times.</p> </li> </ul>"},{"location":"changelog.html#deprecations_16","title":"Deprecations","text":"<ul> <li><code>git.auto-local-bookmark</code> replaces <code>git.auto-local-branch</code>. The latter remains   supported for now (at lower precedence than the former).</li> </ul>"},{"location":"changelog.html#new-features_16","title":"New features","text":"<ul> <li> <p>Added diff options to ignore whitespace when comparing lines. Whitespace   changes are still highlighted.</p> </li> <li> <p>New command <code>jj simplify-parents</code> will remove redundant parent edges.</p> </li> <li> <p><code>jj squash</code> now supports <code>-f/-t</code> shorthands for <code>--from/--[in]to</code>.</p> </li> <li> <p>Initial support for shallow Git repositories has been implemented. However,   deepening the history of a shallow repository is not yet supported.</p> </li> <li> <p><code>jj git clone</code> now accepts a <code>--depth &lt;DEPTH&gt;</code> option, which   allows to clone the repository with a given depth.</p> </li> <li> <p>New command <code>jj file annotate</code> that annotates files line by line. This is similar   in functionality to <code>git blame</code>. Invoke the command with <code>jj file annotate &lt;file_path&gt;</code>.   The output can be customized via the <code>templates.annotate_commit_summary</code>   config variable.</p> </li> <li> <p><code>jj bookmark list</code> gained a <code>--remote REMOTE</code> option to display bookmarks    belonging to a remote. This option can be combined with <code>--tracked</code> or    <code>--conflicted</code>.</p> </li> <li> <p>New command <code>jj config unset</code> that unsets config values. For example,   <code>jj config unset --user user.name</code>.</p> </li> <li> <p><code>jj help</code> now has the flag <code>--keyword</code> (shorthand <code>-k</code>), which can give help   for some keywords (e.g. <code>jj help -k revsets</code>). To see a list of the available   keywords you can do <code>jj help --help</code>.</p> </li> <li> <p>New <code>at_operation(op, expr)</code> revset can be used in order to query revisions   based on historical state.</p> </li> <li> <p>String literals in filesets, revsets and templates now support hex bytes   (with <code>\\e</code> as escape / shorthand for <code>\\x1b</code>).</p> </li> <li> <p>New <code>coalesce(revsets...)</code> revset which returns commits in the first revset   in the <code>revsets</code> list that does not evaluate to <code>none()</code>.</p> </li> <li> <p>New template function <code>raw_escape_sequence(...)</code> preserves escape sequences.</p> </li> <li> <p>Timestamp objects in templates now have <code>after(date) -&gt; Boolean</code> and   <code>before(date) -&gt; Boolean</code> methods for comparing timestamps to other dates.</p> </li> <li> <p>New template functions <code>pad_start()</code>, <code>pad_end()</code>, <code>truncate_start()</code>, and   <code>truncate_end()</code> are added.</p> </li> <li> <p>Add a new template alias <code>builtin_log_compact_full_description()</code>.</p> </li> <li> <p>Added the config settings <code>diff.color-words.context</code> and <code>diff.git.context</code> to   control the default number of lines of context shown.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_18","title":"Fixed bugs","text":"<ul> <li> <p>Error on <code>trunk()</code> revset resolution is now handled gracefully.   #4616</p> </li> <li> <p>Updated the built-in diff editor <code>scm-record</code> to version   0.4.0, which   includes multiple fixes.</p> </li> </ul>"},{"location":"changelog.html#contributors_16","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alec Snyder (@allonsy)</li> <li>Arthur Grillo (Grillo-0)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Dave Townsend (@Mossop)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Emily (@neongreen)</li> <li>Essien Ita Essien (@essiene)</li> <li>Fedor Sheremetyev (@sheremetyev)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jakub Oko\u0144ski (@farnoy)</li> <li>Jcparkyn (@Jcparkyn)</li> <li>Joaqu\u00edn Tri\u00f1anes (@JoaquinTrinanes)</li> <li>Lukas Wirth (@Veykril)</li> <li>Marco Neumann (@crepererum)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Philipp Albrecht (@pylbrecht)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Richard Macklin (@rmacklin)</li> <li>Robin Stocker (@robinst)</li> <li>Samuel Tardieu (@samueltardieu)</li> <li>Sora (@SoraTenshi)</li> <li>Stephen Jennings (@jennings)</li> <li>Theodore Ehrenborg (@TheodoreEhrenborg)</li> <li>Vamsi Avula (@avamsi)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0220-2024-10-02","title":"0.22.0 - 2024-10-02","text":""},{"location":"changelog.html#breaking-changes_17","title":"Breaking changes","text":"<ul> <li> <p>Fixing #4239 means the   ordering of some messages have changed.</p> </li> <li> <p>Invalid <code>ui.graph.style</code> configuration is now an error.</p> </li> <li> <p>The builtin template <code>branch_list</code> has been renamed to <code>bookmark_list</code> as part   of the <code>jj branch</code> deprecation.</p> </li> </ul>"},{"location":"changelog.html#deprecations_17","title":"Deprecations","text":"<ul> <li> <p><code>jj branch</code> has been deprecated in favor of <code>jj bookmark</code>.</p> <p>Rationale: Jujutsu's branches don't behave like Git branches, which a confused many newcomers, as they expected a similar behavior given the name. We've renamed them to \"bookmarks\" to match the actual behavior, as we think that describes them better, and they also behave similar to Mercurial's bookmarks.</p> </li> <li> <p><code>jj obslog</code> is now called <code>jj evolution-log</code>/<code>jj evolog</code>. <code>jj obslog</code> remains   as an alias.</p> </li> <li> <p><code>jj unsquash</code> has been deprecated in favor of <code>jj squash</code> and   <code>jj diffedit --restore-descendants</code>.</p> <p>Rationale: <code>jj squash</code> can be used in interactive mode to pull changes from one commit to another, including from a parent commit to a child commit. For fine-grained dependent diffs, such as when the parent and the child commits must successively modify the same location in a file, <code>jj diffedit --restore-descendants</code> can be used to set the parent commit to the desired content without altering the content of the child commit.</p> </li> <li> <p>The <code>git.push-branch-prefix</code> config has been deprecated in favor of   <code>git.push-bookmark-prefix</code>.</p> </li> <li> <p><code>conflict()</code> and <code>file()</code> revsets have been renamed to <code>conflicts()</code> and <code>files()</code>   respectively. The old names are still around and will be removed in a future   release.</p> </li> </ul>"},{"location":"changelog.html#new-features_17","title":"New features","text":"<ul> <li> <p>The new config option <code>snapshot.auto-track</code> lets you automatically track only   the specified paths (all paths by default). Use the new <code>jj file track</code>   command to manually tracks path that were not automatically tracked. There is   no way to list untracked files yet. Use <code>git status</code> in a colocated workspace   as a workaround.   #323</p> </li> <li> <p><code>jj fix</code> now allows fixing unchanged files with the <code>--include-unchanged-files</code> flag. This   can be used to more easily introduce automatic formatting changes in a new   commit separate from other changes.</p> </li> <li> <p><code>jj workspace add</code> now accepts a <code>--sparse-patterns=&lt;MODE&gt;</code> option, which   allows control of the sparse patterns for a newly created workspace: <code>copy</code>   (inherit from parent; default), <code>full</code> (full working copy), or <code>empty</code> (the   empty working copy).</p> </li> <li> <p>New command <code>jj workspace rename</code> that can rename the current workspace.</p> </li> <li> <p><code>jj op log</code> gained an option to include operation diffs.</p> </li> <li> <p><code>jj git clone</code> now accepts a <code>--remote &lt;REMOTE NAME&gt;</code> option, which   allows to set a name for the remote instead of using the default   <code>origin</code>.</p> </li> <li> <p><code>jj op undo</code> now reports information on the operation that has been undone.</p> </li> <li> <p><code>jj squash</code>: the <code>-k</code> flag can be used as a shorthand for <code>--keep-emptied</code>.</p> </li> <li> <p>CommitId / ChangeId template types now support <code>.normal_hex()</code>.</p> </li> <li> <p><code>jj commit</code> and <code>jj describe</code> now accept <code>--author</code> option allowing to quickly change   author of given commit.</p> </li> <li> <p><code>jj diffedit</code>, <code>jj abandon</code>, and <code>jj restore</code> now accept a <code>--restore-descendants</code>   flag. When used, descendants of the edited or deleted commits will keep their original   content.</p> </li> <li> <p><code>jj git fetch -b &lt;remote-git-branch-name&gt;</code> will now warn if the branch(es)    can not be found in any of the specified/configured remotes.</p> </li> <li> <p><code>jj split</code> now lets the user select all changes in interactive mode. This may be used   to keeping all changes into the first commit while keeping the current commit   description for the second commit (the newly created empty one).</p> </li> <li> <p>Author and committer names are now yellow by default.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_19","title":"Fixed bugs","text":"<ul> <li> <p>Update working copy before reporting changes. This prevents errors during reporting   from leaving the working copy in a stale state.</p> </li> <li> <p>Fixed panic when parsing invalid conflict markers of a particular form.   (#2611)</p> </li> <li> <p>Editing a hidden commit now makes it visible.</p> </li> <li> <p>The <code>present()</code> revset now suppresses missing working copy error. For example,   <code>present(@)</code> evaluates to <code>none()</code> if the current workspace has no   working-copy commit.</p> </li> </ul>"},{"location":"changelog.html#contributors_17","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Danny Hooper (@hooper)</li> <li>Emily Shaffer (@nasamuffin)</li> <li>Essien Ita Essien (@essiene)</li> <li>Ethan Brierley (@eopb)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Kevin Liao (@kevincliao)</li> <li>Lukas Wirth (@Veykril)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Mateusz Miku\u0142a (@mati865)</li> <li>mlcui (@mlcui-corp)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Samuel Tardieu (@samueltardieu)</li> <li>Stephen Jennings (@jennings)</li> <li>Tyler Goffinet (@qubitz)</li> <li>Vamsi Avula (@avamsi)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0210-2024-09-04","title":"0.21.0 - 2024-09-04","text":""},{"location":"changelog.html#breaking-changes_18","title":"Breaking changes","text":"<ul> <li><code>next/prev</code> will no longer infer when to go into edit mode when moving from   commit to commit. It now either follows the flags <code>--edit|--no-edit</code> or it   gets the mode from <code>ui.movement.edit</code>.</li> </ul>"},{"location":"changelog.html#deprecations_18","title":"Deprecations","text":"<ul> <li><code>jj untrack</code> has been renamed to <code>jj file untrack</code>.</li> </ul>"},{"location":"changelog.html#new-features_18","title":"New features","text":"<ul> <li> <p>Add new boolean config knob, <code>ui.movement.edit</code> for controlling the behavior   of <code>prev/next</code>. The flag turns <code>edit</code> mode <code>on</code> and <code>off</code> permanently when set   respectively to <code>true</code> or <code>false</code>.</p> </li> <li> <p>All diff formats except <code>--name-only</code> now include information about copies and   moves. So do external diff tools in file-by-file mode. <code>jj status</code> also   includes information about copies and moves.</p> </li> <li> <p>Color-words diff has gained an option to display complex changes as separate   lines. It's enabled by default. To   restore the old behavior, set <code>diff.color-words.max-inline-alternation = -1</code>.</p> </li> <li> <p>A tilde (<code>~</code>) at the start of the path will now be expanded to the user's home   directory when configuring a <code>signing.key</code> for SSH commit signing.</p> </li> <li> <p>When reconfiguring the author, warn that the working copy won't be updated</p> </li> <li> <p><code>jj rebase -s</code> can now be used with the <code>--insert-after</code> and <code>--insert-before</code>   options, like <code>jj rebase -r</code>.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_20","title":"Fixed bugs","text":"<ul> <li>Release binaries for Intel Macs have been restored. They were previously   broken due to using a sunset version of GitHub's macOS runners (but nobody had   previously complained.)</li> </ul>"},{"location":"changelog.html#contributors_18","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aaron Bull Schaefer (@elasticdog)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Raniz Daniel Raneland (@Raniz85)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Essien Ita Essien (@essiene)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Kaleb Pace (@kalebpace)</li> <li>Marie (@NyCodeGHG)</li> <li>Marijan Smetko (@InCogNiTo124)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Kulukundis (@fowles)</li> <li>Scott Taylor (@scott2000)</li> <li>Stephen Jennings (@jennings)</li> <li>tingerrr (@tingerrr)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0200-2024-08-07","title":"0.20.0 - 2024-08-07","text":""},{"location":"changelog.html#note-to-packagers","title":"Note to packagers","text":"<ul> <li><code>jj</code> now links <code>libgit2</code> statically by default. To use dynamic linking, you   need to set the environment variable <code>LIBGIT2_NO_VENDOR=1</code> while compiling.   (#4163)</li> </ul>"},{"location":"changelog.html#breaking-changes_19","title":"Breaking changes","text":"<ul> <li> <p><code>jj rebase --skip-empty</code> has been renamed to <code>jj rebase --skip-emptied</code></p> </li> <li> <p><code>jj backout --revision</code> has been renamed to <code>jj backout --revisions</code>.   The short alias <code>-r</code> is still supported.</p> </li> <li> <p>The default <code>immutable_heads()</code> set   now includes <code>untracked_remote_branches()</code> with the assumption that untracked   branches aren't managed by you. Therefore, untracked branches are no longer   displayed in <code>jj log</code> by default.</p> </li> <li> <p>Updated defaults for graph node symbol templates <code>templates.log_node</code> and   <code>templates.op_log_node</code>.</p> </li> <li> <p>The \"fileset\" language is now enabled by default. It can   still be disabled by setting <code>ui.allow-filesets=false</code>.</p> </li> <li> <p>On <code>jj git fetch</code>/<code>import</code>, commits referred to by <code>HEAD@git</code> are no longer   preserved. If a checked-out named branch gets deleted locally or remotely, the   corresponding commits will be abandoned.</p> </li> <li> <p><code>jj --at-op=@</code> no longer merges concurrent operations if explicitly specified.</p> </li> <li> <p><code>jj obslog -p</code> no longer shows diffs at non-partial squash operations.   Previously, it showed the same diffs as the second predecessor.</p> </li> </ul>"},{"location":"changelog.html#deprecations_19","title":"Deprecations","text":"<ul> <li>The original configuration syntax for <code>jj fix</code> is now deprecated in favor of   one that allows defining multiple tools that can affect different filesets.   These can be used in combination for now. See <code>jj help fix</code> for details.</li> </ul>"},{"location":"changelog.html#new-features_19","title":"New features","text":"<ul> <li> <p>Define <code>immutable_heads()</code> revset alias in terms of a new <code>builtin_immutable_heads()</code>.   This enables users to redefine <code>immutable_heads()</code> as they wish, but still   have <code>builtin_immutable_heads()</code> which should not be redefined.</p> </li> <li> <p>External diff tools can now be configured to invoke the tool on each file   individually instead of being passed a directory by setting   <code>merge-tools.$TOOL.diff-invocation-mode=\"file-by-file\"</code> in config.toml.</p> </li> <li> <p>In git diffs, word-level hunks are now highlighted with underline. See diff   colors and styles for customization.</p> </li> <li> <p>New <code>.diff().&lt;format&gt;()</code> commit template methods are added. They can be used   in order to show diffs conditionally. For example,   <code>if(current_working_copy, diff.summary())</code>.</p> </li> <li> <p><code>jj git clone</code> and <code>jj git init</code> with an existing git repository adds the   default branch of the remote as repository settings for   <code>revset-aliases.\"trunk()\"</code>.`</p> </li> <li> <p><code>jj workspace forget</code> now abandons the workspace's working-copy commit if it   was empty.</p> </li> <li> <p><code>jj backout</code> now includes the backed out commit's subject in the new commit   message.</p> </li> <li> <p><code>jj backout</code> can now back out multiple commits at once.</p> </li> <li> <p><code>jj git clone some/nested/path</code> now creates the full directory tree for    nested destination paths if they don't exist.</p> </li> <li> <p>String patterns now support case\u2010insensitive matching by suffixing any   pattern kind with <code>-i</code>. <code>mine()</code> uses case\u2010insensitive matching on your email   address unconditionally. Only ASCII case folding is currently implemented,   but this will likely change in the future.</p> </li> <li> <p>String patterns now support <code>regex:\"pattern\"</code>.</p> </li> <li> <p>New <code>tracked_remote_branches()</code> and <code>untracked_remote_branches()</code> revset   functions can be used to select tracked/untracked remote branches.</p> </li> <li> <p>The <code>file()</code> revset function now accepts fileset as argument.</p> </li> <li> <p>New <code>diff_contains()</code> revset function can be used to search diffs.</p> </li> <li> <p>New command <code>jj operation diff</code> that can compare changes made between two   operations.</p> </li> <li> <p>New command <code>jj operation show</code> that can show the changes made in a single   operation.</p> </li> <li> <p>New config setting <code>git.private-commits</code> to prevent commits from being pushed.</p> </li> <li> <p>The default commit description template   can now be configured by <code>templates.draft_commit_description</code>.</p> </li> <li> <p><code>jj fix</code> can now be configured to run different tools on different filesets.   This simplifies the use case of configuring code formatters for specific file   types. See <code>jj help fix</code> for details.</p> </li> <li> <p>Added revset functions <code>author_date</code> and <code>committer_date</code>.</p> </li> <li> <p><code>jj describe</code> can now update the description of multiple commits.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_21","title":"Fixed bugs","text":"<ul> <li> <p><code>jj status</code> will show different messages in a conflicted tree, depending   on the state of the working commit. In particular, if a child commit fixes   a conflict in the parent, this will be reflected in the hint provided   by <code>jj status</code></p> </li> <li> <p><code>jj diff --git</code> no longer shows the contents of binary files.</p> </li> <li> <p>Windows binaries no longer require <code>vcruntime140.dll</code> to be installed   (normally through Visual Studio.)</p> </li> <li> <p>On quit, the builtin pager no longer waits for all outputs to be discarded.</p> </li> <li> <p><code>jj branch rename</code> no longer shows a warning in colocated repos.</p> </li> </ul>"},{"location":"changelog.html#contributors_19","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Danny Hooper (@hooper)</li> <li>Emily (@emilazy)</li> <li>Essien Ita Essien (@essiene)</li> <li>Fedor Sheremetyev (@sheremetyev)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jonathan Tan (@jonathantanmy)</li> <li>Julien Vincent (@julienvincent)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Kulukundis (@fowles)</li> <li>Matt Stark (@matts1)</li> <li>mlcui (@mlcui-corp)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Scott Taylor (@scott2000)</li> <li>Skyler Grey (@Minion3665)</li> <li>Stephen Jennings (@jennings)</li> <li>Tim Janik (@tim-janik)</li> <li>Vincent Ging Ho Yim (@cenviity)</li> <li>Vladim\u00edr \u010cun\u00e1t (@vcunat)</li> <li>Vladimir (@0xdeafbeef)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0190-2024-07-03","title":"0.19.0 - 2024-07-03","text":""},{"location":"changelog.html#breaking-changes_20","title":"Breaking changes","text":"<ul> <li> <p>In revset aliases, top-level <code>kind:pattern</code> expression is now parsed as   modifier. Surround with parentheses if it should be parsed as string/file   pattern.</p> </li> <li> <p>Dropped support for automatic upgrade of repo formats used by versions before   0.12.0.</p> </li> <li> <p><code>jj fix</code> now defaults to the broader revset <code>-s reachable(@, mutable())</code>   instead of <code>-s @</code>.</p> </li> <li> <p>Dropped support for deprecated <code>jj branch delete</code>/<code>forget</code> <code>--glob</code> option.</p> </li> <li> <p><code>jj branch set</code> now creates new branch if it doesn't exist. Use <code>jj branch   move</code> to ensure that the target branch already exists.   #3584</p> </li> </ul>"},{"location":"changelog.html#deprecations_20","title":"Deprecations","text":"<ul> <li> <p>Replacing <code>-l</code> shorthand for <code>--limit</code> with <code>-n</code> in <code>jj log</code>, <code>jj op log</code>   and <code>jj obslog</code>.</p> </li> <li> <p><code>jj split --siblings</code> is deprecated in favor of <code>jj split --parallel</code> (to   match <code>jj parallelize</code>).</p> </li> <li> <p>A new <code>jj file</code> subcommand now replaces several existing uncategorized   commands, which are deprecated.</p> <ul> <li><code>jj file show</code> replaces <code>jj cat</code>.</li> <li><code>jj file chmod</code> replaces <code>jj chmod</code>.</li> <li><code>jj file list</code> replaces <code>jj files</code>.</li> </ul> </li> </ul>"},{"location":"changelog.html#new-features_20","title":"New features","text":"<ul> <li> <p>Support background filesystem monitoring via watchman triggers enabled with   the <code>core.watchman.register_snapshot_trigger = true</code> config.</p> </li> <li> <p>Show paths to config files when configuration errors occur.</p> </li> <li> <p><code>jj fix</code> now supports configuring the default revset for <code>-s</code> using the   <code>revsets.fix</code> config.</p> </li> <li> <p>The <code>descendants()</code> revset function now accepts an optional <code>depth</code> argument;   like the <code>ancestors()</code> depth argument, it limits the depth of the set.</p> </li> <li> <p>Revset/template aliases now support function overloading.   #2966</p> </li> <li> <p>Conflicted files are individually simplified before being materialized.</p> </li> <li> <p>The <code>jj file</code> subcommand now contains several existing file utilities.</p> <ul> <li><code>jj file show</code>, replacing <code>jj cat</code>.</li> <li><code>jj file chmod</code> replacing <code>jj chmod</code>.</li> <li><code>jj file list</code> replacing <code>jj files</code>.</li> </ul> </li> <li> <p>New command <code>jj branch move</code> let you update branches by name pattern or source   revision.</p> </li> <li> <p>New diff option <code>jj diff --name-only</code> allows for easier shell scripting.</p> </li> <li> <p>In color-words diffs, hunks are now highlighted with underline. See diff   colors and styles for customization.</p> </li> <li> <p><code>jj git push -c &lt;arg&gt;</code> can now accept revsets that resolve to multiple   revisions. This means that <code>jj git push -c xyz -c abc</code> is now equivalent to   <code>jj git push -c 'all:(xyz | abc)'</code>.</p> </li> <li> <p><code>jj prev</code> and <code>jj next</code> have gained a <code>--conflict</code> flag which moves you   to the next conflict in a child commit.</p> </li> <li> <p>New command <code>jj git remote set-url</code> that sets the url of a git remote.</p> </li> <li> <p>Author timestamp is now reset when rewriting discardable commits (empty   commits with no description) if authored by the current user.   #2000</p> </li> <li> <p><code>jj commit</code> now accepts <code>--reset-author</code> option to match <code>jj describe</code>.</p> </li> <li> <p><code>jj squash</code> now accepts a <code>--keep-emptied</code> option to keep the source commit.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_22","title":"Fixed bugs","text":"<ul> <li> <p><code>jj git push</code> now ignores immutable commits when checking whether a   to-be-pushed commit has conflicts, or has no description / committer / author   set. #3029</p> </li> <li> <p><code>jj</code> will look for divergent changes outside the short prefix set even if it   finds the change id inside the short prefix set.   #2476</p> </li> </ul>"},{"location":"changelog.html#contributors_20","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Danny Hooper (@hooper)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>James Sully (@sullyj3)</li> <li>Jonathan Tan (@jonathantanmy)</li> <li>Kyle J Strand (@BatmanAoD)</li> <li>Manuel Caldeira (@KiitoX)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Kulukundis (@fowles)</li> <li>Matt Stark (@matts1)</li> <li>mlcui (@mlcui-corp)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Scott Taylor (@scott2000)</li> <li>Simon Wollwage (@Kintaro)</li> <li>Tal Pressman (@tp-woven)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0180-2024-06-05","title":"0.18.0 - 2024-06-05","text":""},{"location":"changelog.html#breaking-changes_21","title":"Breaking changes","text":"<ul> <li> <p>Dropped support for <code>ui.default-revset</code> config (replaced by <code>revsets.log</code> in   0.8.0).</p> </li> <li> <p>The <code>commit_summary_no_branches</code> template is superseded by   <code>templates.branch_list</code>.</p> </li> <li> <p><code>jj split</code> will now refuse to split an empty commit.</p> </li> <li> <p><code>jj config list</code> now uses multi-line strings and single-quoted strings in the   output when appropriate.</p> </li> <li> <p><code>jj config get</code>/<code>list</code>/<code>set</code> now parse <code>name</code> argument as TOML   key. Quote meta characters as needed.   Example: <code>jj config get \"revset-aliases.'trunk()'\"</code></p> </li> <li> <p>When updating the working copy away from an empty and undescribed commit, it   is now abandoned even if it is a merge commit.</p> </li> <li> <p>If a new working-copy commit is created because the old one was abandoned, and   the old commit was merge, then the new commit will now also be.   #2859</p> </li> <li> <p><code>jj new</code>'s <code>--insert-before</code>/<code>--insert-after</code> options must now be set for each   commit the new commit will be inserted before/after. Previously, those options   were global flags and specifying them once would insert the new commit before/   after all the specified commits.</p> </li> </ul>"},{"location":"changelog.html#deprecations_21","title":"Deprecations","text":"<ul> <li>Attempting to alias a built-in command now gives a warning, rather than being   silently ignored.</li> </ul>"},{"location":"changelog.html#new-features_21","title":"New features","text":"<ul> <li> <p><code>jj branch list</code>/<code>tag list</code> now accept <code>-T</code>/<code>--template</code> option. The tag list   prints commit summary along with the tag name by default.</p> </li> <li> <p>Conflict markers now include an explanation of what each part of the conflict   represents.</p> </li> <li> <p><code>ui.color = \"debug\"</code> prints active labels alongside the regular colored   output.</p> </li> <li> <p><code>jj branch track</code> now show conflicts if there are some.</p> </li> <li> <p>A new revset <code>reachable(srcs, domain)</code> will return all commits that are   reachable from <code>srcs</code> within <code>domain</code>.</p> </li> <li> <p>There are now prebuilt binaries for <code>aarch64-linux-unknown-musl</code>.   Note, these are cross compiled and currently untested.   We plan on providing fully tested builds later once our CI system allows it.</p> </li> <li> <p>Added new revsets <code>mutable()</code> and <code>immutable()</code>.</p> </li> <li> <p>Upgraded <code>scm-record</code> from v0.2.0 to v0.3.0. See release notes at   https://github.com/arxanas/scm-record/releases/tag/v0.3.0</p> </li> <li> <p>New command <code>jj fix</code> that can be configured to update commits by running code   formatters (or similar tools) on changed files. The configuration schema and   flags are minimal for now, with a number of improvements planned (for example,   #3800 and   #3801).</p> </li> <li> <p><code>jj new</code>'s <code>--insert-before</code> and <code>--insert-after</code> options can now be used   simultaneously.</p> </li> <li> <p><code>jj git push</code> now can push commits with empty descriptions with the   <code>--allow-empty-description</code> flag</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_23","title":"Fixed bugs","text":"<ul> <li> <p>Previously, <code>jj git push</code> only made sure that the branch is in the expected   location on the remote server when pushing a branch forward (as opposed to   sideways or backwards). Now, <code>jj git push</code> makes a safety check in all cases   and fails whenever <code>jj git fetch</code> would have introduced a conflict.</p> <p>In other words, previously branches that moved sideways or backward were pushed similarly to Git's <code>git push --force</code>; now they have protections similar to <code>git push --force-with-lease</code> (though not identical to it, to match the behavior of <code>jj git fetch</code>). Note also that because of the way <code>jj git fetch</code> works, <code>jj</code> does not suffer from the same problems as Git's <code>git push --force-with-lease</code> in situations when <code>git fetch</code> is run in the background.</p> </li> <li> <p>When the working copy commit becomes immutable, a new one is automatically   created   on top of it to avoid letting the user edit the immutable one.</p> </li> <li> <p><code>jj config list</code> now properly escapes TOML keys (#1322).</p> </li> <li> <p>Files with conflicts are now checked out as executable if all sides of the   conflict are executable.</p> </li> <li> <p>The progress bar (visible when using e.g. <code>jj git clone</code>) clears the   remainder of the cursor row after drawing rather than clearing the entire row   before drawing, eliminating the \"flicker\" effect seen on some terminals.</p> </li> </ul>"},{"location":"changelog.html#contributors_21","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alexander Potashev (@aspotashev)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Charles Crete (@Cretezy)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Danny Hooper (@hooper)</li> <li>Eidolon (@HybridEidolon)</li> <li>Glen Choo (@chooglen)</li> <li>Gregory Anders (@gpanders)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>jyn (@jyn514)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Matthew Davidson (@KingMob)</li> <li>Michael Gattozzi (@mgattozzi)</li> <li>mlcui (@mlcui-corp)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Remo Senekowitsch (@senekor)</li> <li>Thomas Castiglione (@gulbanana)</li> <li>Th\u00e9o Daron (@tdaron)</li> <li>tinger (@tingerrr)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0171-2024-05-07","title":"0.17.1 - 2024-05-07","text":""},{"location":"changelog.html#fixed-bugs_24","title":"Fixed bugs","text":"<ul> <li><code>jj status</code> no longer scans through the entire history to look for ancestors   with conflicts.</li> </ul>"},{"location":"changelog.html#0170-2024-05-01","title":"0.17.0 - 2024-05-01","text":""},{"location":"changelog.html#breaking-changes_22","title":"Breaking changes","text":"<ul> <li> <p>The default template aliases were replaced as follows:</p> <ul> <li><code>builtin_op_log_root(op_id: OperationId)</code> -&gt;   <code>format_root_operation(root: Operation)</code></li> <li><code>builtin_log_root(change_id: ChangeId, commit_id: CommitId)</code> -&gt;   <code>format_root_commit(root: Commit)</code></li> <li><code>builtin_change_id_with_hidden_and_divergent_info</code> -&gt;   <code>format_short_change_id_with_hidden_and_divergent_info(commit: Commit)</code></li> </ul> </li> <li> <p>The <code>--revision</code> option of <code>jj rebase</code> is renamed to <code>--revisions</code>. The short   alias <code>-r</code> is still supported.</p> </li> </ul>"},{"location":"changelog.html#new-features_22","title":"New features","text":"<ul> <li> <p>The list of conflicted paths is printed whenever the working copy changes.   This can be disabled with the <code>--quiet</code> option.</p> </li> <li> <p>Commit objects in templates now have a <code>mine() -&gt; Boolean</code> method analog to   the same function in revsets. It evaluates to true if the email of the commit   author matches the current <code>user.email</code>.</p> </li> <li> <p>Commit objects in templates now have a <code>contained_in(revset: String) -&gt;   Boolean</code> method.</p> </li> <li> <p>Operation objects in templates now have a <code>snapshot() -&gt; Boolean</code> method that   evaluates to true if the operation was a snapshot created by a non-mutating   command (e.g. <code>jj log</code>).</p> </li> <li> <p>Revsets and templates now support single-quoted raw string literals.</p> </li> <li> <p>A new config option <code>ui.always-allow-large-revsets</code> has been added to   allow large revsets expressions in some commands, without the <code>all:</code> prefix.</p> </li> <li> <p>A new config option <code>ui.allow-filesets</code> has been added to enable \"fileset\"   expressions. Note that filesets are currently experimental,   but will be enabled by default in a future release.</p> </li> <li> <p>A new global flag <code>--ignore-immutable</code> lets you rewrite immutable commits.</p> </li> <li> <p>New command <code>jj parallelize</code> that rebases a set of revisions into siblings.</p> </li> <li> <p><code>jj status</code> now supports filtering by paths. For example, <code>jj status .</code> will   only list changed files that are descendants of the current directory.</p> </li> <li> <p><code>jj prev</code> and <code>jj next</code> now work when the working copy revision is a merge.</p> </li> <li> <p><code>jj squash</code> now accepts a <code>--use-destination-message/-u</code> option that uses the   description of the destination for the new squashed revision and discards the   descriptions of the source revisions.</p> </li> <li> <p>You can check whether Watchman fsmonitor is enabled or installed with the new   <code>jj debug watchman status</code> command.</p> </li> <li> <p><code>jj rebase</code> now accepts revsets resolving to multiple revisions with the   <code>--revisions</code>/<code>-r</code> option.</p> </li> <li> <p><code>jj rebase -r</code> now accepts <code>--insert-after</code> and <code>--insert-before</code> options to   customize the location of the rebased revisions.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_25","title":"Fixed bugs","text":"<ul> <li> <p>Revsets now support <code>\\</code>-escapes in string literal.</p> </li> <li> <p>The builtin diff editor now allows empty files to be selected during   <code>jj split</code>.</p> </li> <li> <p>Fixed a bug with <code>jj split</code> introduced in 0.16.0 that caused it to incorrectly   rebase the children of the revision being split if they had other parents   (i.e. if the child was a merge).</p> </li> <li> <p>The <code>snapshot.max-new-file-size</code> option can now handle raw integer literals,   interpreted as a number of bytes, where previously it could only handle string   literals. This means that <code>snapshot.max-new-file-size=\"1\"</code> and   <code>snapshot.max-new-file-size=1</code> are now equivalent.</p> </li> <li> <p><code>jj squash &lt;path&gt;</code> is now a no-op if the path argument didn't match any paths   (it used to create new commits with bumped timestamp).   #3334</p> </li> </ul>"},{"location":"changelog.html#contributors_22","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Anton Bulakh (@necauqua)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Cretezy (@Cretezy)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Evan Mesterhazy (@emesterhazy)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Noah Mayr (@noahmayr)</li> <li>Jeremy O'Brien (@neutralinsomniac)</li> <li>Jonathan Lorimer (@JonathanLorimer)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Poliorcetics (@poliorcetics)</li> <li>Rowan Walsh (@rowan-walsh)</li> <li>Scott Olson (@solson)</li> <li>Th\u00e9o Daron (@tdaron)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0160-2024-04-03","title":"0.16.0 - 2024-04-03","text":""},{"location":"changelog.html#deprecations_22","title":"Deprecations","text":"<ul> <li><code>jj move</code> was deprecated in favor of <code>jj squash</code>.</li> </ul>"},{"location":"changelog.html#breaking-changes_23","title":"Breaking changes","text":"<ul> <li> <p>The <code>git_head</code> template keyword now returns an optional value instead of a   list of 0 or 1 element.</p> </li> <li> <p>The <code>jj sparse set --edit</code>/<code>--reset</code> flags were split up into <code>jj sparse   edit</code>/<code>reset</code> subcommands respectively.</p> </li> <li> <p>The <code>jj sparse</code> subcommands now parse and print patterns as workspace-relative   paths.</p> </li> <li> <p>The <code>jj log</code> command no longer uses the default revset when a path is   specified.</p> </li> </ul>"},{"location":"changelog.html#new-features_23","title":"New features","text":"<ul> <li> <p>Config now supports rgb hex colors (in the form <code>#rrggbb</code>) wherever existing   color names are supported.</p> </li> <li> <p><code>ui.default-command</code> now accepts multiple string arguments, for more complex   default <code>jj</code> commands.</p> </li> <li> <p>Graph node symbols are now configurable via templates</p> <ul> <li><code>templates.log_node</code></li> <li><code>templates.op_log_node</code></li> </ul> </li> <li> <p><code>jj log</code> now includes synthetic nodes in the graph where some revisions were   elided.</p> </li> <li> <p><code>jj squash</code> now accepts <code>--from</code> and <code>--into</code> (also aliased as <code>--to</code>) if <code>-r</code>   is not specified. It can now be used for all use cases where <code>jj move</code> could   previously be used. The <code>--from</code> argument accepts a revset that resolves to   more than one revision.</p> </li> <li> <p>Commit templates now support <code>immutable</code> keyword.</p> </li> <li> <p>New template function <code>coalesce(content, ..)</code> is added.</p> </li> <li> <p>Timestamps are now shown in local timezone and without milliseconds and   timezone offset by default.</p> </li> <li> <p><code>jj git push</code> now prints messages from the remote.</p> </li> <li> <p><code>jj branch list</code> now supports a <code>--conflicted/-c</code> option to show only   conflicted branches.</p> </li> <li> <p><code>jj duplicate</code> and <code>jj abandon</code> can now take more than a single <code>-r</code> argument,   for consistency with other commands.</p> </li> <li> <p><code>jj branch list</code> now allows combining <code>-r REVISIONS</code>/<code>NAMES</code> and <code>-a</code> options.</p> </li> <li> <p><code>--all</code> is now named <code>--all-remotes</code> for <code>jj branch list</code></p> </li> <li> <p>There is a new global <code>--quiet</code> flag to silence commands' non-primary output.</p> </li> <li> <p><code>jj split</code> now supports a <code>--siblings/-s</code> option that splits the target   revision into siblings with the same parents and children.</p> </li> <li> <p>New function <code>working_copies()</code> for revsets to show the working copy commits   of all workspaces.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_26","title":"Fixed bugs","text":"<p>None.</p>"},{"location":"changelog.html#contributors_23","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aleksey Kuznetsov (@zummenix)</li> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Chris Krycho (@chriskrycho)</li> <li>Christoph Koehler (@ckoehler)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Evan Mesterhazy (@emesterhazy)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Khionu Sybiern (@khionu)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matthew Davidson (@KingMob)</li> <li>mrstanwell (@mrstanwell)</li> <li>Noah Mayr (@noahmayr)</li> <li>Patric Stout (@TrueBrain)</li> <li>Poliorcetics (@poliorcetics)</li> <li>Simon Wollwage (@Kintaro)</li> <li>Steve Klabnik (@steveklabnik)</li> <li>Tom Ward (@tomafro)</li> <li>TrashCan (@TrashCan69420)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0151-2024-03-06","title":"0.15.1 - 2024-03-06","text":"<p>No code changes (fixing Rust <code>Cargo.toml</code> stuff).</p>"},{"location":"changelog.html#0150-2024-03-06","title":"0.15.0 - 2024-03-06","text":""},{"location":"changelog.html#breaking-changes_24","title":"Breaking changes","text":"<ul> <li> <p>The minimum supported Rust version (MSRV) is now 1.76.0.</p> </li> <li> <p>The on-disk index format changed. New index files will be created   automatically, but it can fail if the repository is colocated and predates   Git GC issues #815. If   reindexing failed, you'll need to clean up corrupted operation history by   <code>jj op abandon ..&lt;bad operation ID&gt;</code>.</p> </li> <li> <p>Dropped support for the \"legacy\" graph-drawing style. Use \"ascii\" for a very   similar result.</p> </li> <li> <p>The default log output no longer lists all tagged heads. Set <code>revsets.log =   \"@ | ancestors(immutable_heads().., 2) | heads(immutable_heads())\"</code> to restore   the old behavior.</p> </li> <li> <p>Dropped support for the deprecated <code>:</code> revset operator. Use <code>::</code> instead.</p> </li> <li> <p><code>jj rebase --skip-empty</code> no longer abandons commits that were already empty   before the rebase.</p> </li> </ul>"},{"location":"changelog.html#new-features_24","title":"New features","text":"<ul> <li> <p>Partial support for commit signing. Currently you can configure jj to \"keep\"   commit signatures by making new ones for rewritten commits, and to sign new   commits when they are created.</p> <p>This comes with out-of-the-box support for the following backends:</p> <ul> <li>GnuPG</li> <li>SSH</li> </ul> <p>Signature verification and an explicit sign command will hopefully come soon.</p> </li> <li> <p>Templates now support logical operators: <code>||</code>, <code>&amp;&amp;</code>, <code>!</code></p> </li> <li> <p>Templates now support the <code>self</code> keyword, which is the current commit in <code>jj   log</code>/<code>obslog</code> templates.</p> </li> <li> <p><code>jj show</code> now accepts <code>-T</code>/<code>--template</code> option to render its output using   template</p> </li> <li> <p><code>jj config list</code> now accepts <code>-T</code>/<code>--template</code> option.</p> </li> <li> <p><code>jj git fetch</code> now accepts <code>-b</code> as a shorthand for <code>--branch</code>, making it more   consistent with other commands that accept a branch</p> </li> <li> <p>In the templating language, Timestamps now have a <code>.local()</code> method for   converting to the local timezone.</p> </li> <li> <p><code>jj next/prev</code> now infer <code>--edit</code> when you're already editing a non-head   commit (a commit with children).</p> </li> <li> <p>A new built-in pager named <code>:builtin</code> is available on all platforms,   implemented with minus</p> </li> <li> <p>Set config <code>ui.log-synthetic-elided-nodes = true</code> to make <code>jj log</code> include   synthetic nodes in the graph where some revisions were elided   (#1252,   #2971). This may become the   default depending on feedback.</p> </li> <li> <p>When creating a new workspace, the sparse patterns are now copied over from   the current workspace.</p> </li> <li> <p><code>jj git init --colocate</code> can now import an existing Git repository. This is   equivalent to <code>jj git init --git-repo=.</code>.</p> </li> <li> <p><code>jj git fetch</code> now automatically prints new remote branches and tags by   default.</p> </li> <li> <p><code>--verbose/-v</code> is now <code>--debug</code> (no short option since it's not intended to be   used often)</p> </li> <li> <p><code>jj move --from/--to</code> can now be abbreviated to <code>jj move -f/-t</code></p> </li> <li> <p><code>jj commit</code>/<code>diffedit</code>/<code>move</code>/<code>resolve</code>/<code>split</code>/<code>squash</code>/<code>unsquash</code> now accept   <code>--tool=&lt;NAME&gt;</code> option to override the default.   #2575</p> </li> <li> <p>Added completions for Nushell to <code>jj util completion</code></p> </li> <li> <p><code>jj branch list</code> now supports a <code>--tracked/-t</code> option which can be used to   show tracked branches only. Omits local Git-tracking branches by default.</p> </li> <li> <p>Commands producing diffs now accept a <code>--context</code> flag for the number of   lines of context to show.</p> </li> <li> <p><code>jj</code> commands with the <code>-T</code>/<code>--template</code> option now provide a hint containing   defined template names when no argument is given, assisting the user in making   a selection.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_27","title":"Fixed bugs","text":"<ul> <li> <p>On Windows, symlinks in the repo are now supported when Developer Mode is   enabled.   When symlink support is unavailable, they will be materialized as regular   files in the   working copy (instead of resulting in a crash).   #2</p> </li> <li> <p>On Windows, the <code>:builtin</code> pager is now used by default, rather than being   disabled entirely.</p> </li> <li> <p>Auto-rebase now preserves the shape of history even for merge commits where   one parent is an ancestor of another.   #2600</p> </li> </ul>"},{"location":"changelog.html#contributors_24","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aleksey Kuznetsov (@zummenix)</li> <li>Anton Bulakh (@necauqua)</li> <li>Anton \u00c4lgmyr (@algmyr)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Daehyeok Mun (@daehyeok)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Evan Mesterhazy (@emesterhazy)</li> <li>gulbanana (@gulbanana)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jonathan Tan (@jonathantanmy)</li> <li>Julien Vincent (@julienvincent)</li> <li>jyn (@jyn514)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Paulo Coelho (@prscoelho)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Poliorcetics (@poliorcetics)</li> <li>Stephen Jennings (@jennings)</li> <li>Vladimir (@0xdeafbeef)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0140-2024-02-07","title":"0.14.0 - 2024-02-07","text":""},{"location":"changelog.html#deprecations_23","title":"Deprecations","text":"<ul> <li> <p><code>jj checkout</code> and <code>jj merge</code> are both deprecated; use <code>jj new</code> instead to   replace both of these commands in all instances.</p> <p>Rationale: <code>jj checkout</code> and <code>jj merge</code> both implement identical functionality, which is a subset of <code>jj new</code>. <code>checkout</code> creates a new working copy commit on top of a single specified revision, i.e. with one parent. <code>merge</code> creates a new working copy commit on top of at least two specified revisions, i.e. with two or more parents.</p> <p>The only difference between these commands and <code>jj new</code>, which also creates a new working copy commit, is that <code>new</code> can create a working copy commit on top of any arbitrary number of revisions, so it can handle both the previous cases at once. The only actual difference between these three commands is the command syntax and their name. These names were chosen to be familiar to users of other version control systems, but we instead encourage all users to adopt <code>jj new</code> instead; it is more general and easier to remember than both of these.</p> <p><code>jj checkout</code> and <code>jj merge</code> will no longer be shown as part of <code>jj help</code>, but will still function for now, emitting a warning about their deprecation.</p> <p>Deadline: <code>jj checkout</code> and <code>jj merge</code> will be deleted and are expected become a hard error later in 2024.</p> </li> <li> <p><code>jj init --git</code> and <code>jj init --git-repo</code> are now deprecated and will be   removed   in the near future.</p> <p>Use <code>jj git init</code> instead.</p> </li> </ul>"},{"location":"changelog.html#breaking-changes_25","title":"Breaking changes","text":"<ul> <li> <p>(Minor) Diff summaries (e.g. <code>jj diff -s</code>) now use <code>D</code> for \"Deleted\" instead   of <code>R</code> for \"Removed\". @joyously pointed out that <code>R</code> could also mean   \"Renamed\".</p> </li> <li> <p><code>jj util completion</code> now takes the shell as a positional argument, not a flag.   the previous behavior is deprecated, but supported for now. it will be removed   in the future.</p> </li> <li> <p><code>jj rebase</code> now preserves the shape of history even for merge commits where   one parent is an ancestor of another. You can follow the <code>jj rebase</code> by   <code>jj rebase -s &lt;merge commit&gt; -d &lt;single parent&gt;</code> if you want to linearize the   history.</p> </li> </ul>"},{"location":"changelog.html#new-features_25","title":"New features","text":"<ul> <li> <p><code>jj util completion</code> now supports powershell and elvish.</p> </li> <li> <p>Official binaries for macOS running on Apple Silicon (<code>aarch64-apple-darwin</code>)   are now available, alongside the existing macOS x86 binaries.</p> </li> <li> <p>New <code>jj op abandon</code> command is added to clean up the operation history. Git   refs and commit objects can be further compacted by <code>jj util gc</code>.</p> </li> <li> <p><code>jj util gc</code> now removes unreachable operation, view, and Git objects.</p> </li> <li> <p><code>jj branch rename</code> will now warn if the renamed branch has a remote branch,   since   those will have to be manually renamed outside of <code>jj</code>.</p> </li> <li> <p><code>jj git push</code> gained a <code>--tracked</code> option, to push all the tracked branches.</p> </li> <li> <p>There's now a virtual root operation, similar to the virtual root   commit. It appears at the end of <code>jj op log</code>.</p> </li> <li> <p><code>jj config list</code> gained a <code>--include-overridden</code> option to allow   printing overridden config values.</p> </li> <li> <p><code>jj config list</code> now accepts <code>--user</code> or <code>--repo</code> option to specify   config origin.</p> </li> <li> <p>New <code>jj config path</code> command to print the config file path without launching   an editor.</p> </li> <li> <p><code>jj tag list</code> command prints imported git tags.</p> </li> <li> <p><code>jj next</code> and <code>jj prev</code> now prompt in the event of the next/previous commit   being ambiguous, instead of failing outright.</p> </li> <li> <p><code>jj resolve</code> now displays the file being resolved.</p> </li> <li> <p><code>jj workspace root</code> was aliased to <code>jj root</code>, for ease of discoverability</p> </li> <li> <p><code>jj diff</code> no longer shows the contents of binary files.</p> </li> <li> <p><code>jj git</code> now has an <code>init</code> command that initializes a git backed repo.</p> </li> <li> <p>New template function <code>surround(prefix, suffix, content)</code> is added.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_28","title":"Fixed bugs","text":"<ul> <li> <p>Fixed snapshots of symlinks in <code>gitignore</code>-d directory.   #2878</p> </li> <li> <p>Fixed data loss in dirty working copy when checked-out branch is rebased or   abandoned by Git.   #2876</p> </li> </ul>"},{"location":"changelog.html#contributors_25","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>Chris Krycho (@chriskrycho)</li> <li>Daehyeok Mun (@daehyeok)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Essien Ita Essien (@essiene)</li> <li>Ikko Eltociear Ashimine (@eltociear)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jonathan Tan (@jonathantanmy)</li> <li>jyn (@jyn514)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Stark (@matts1)</li> <li>Michael Pratt (prattmic)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Stephen Jennings (@jennings)</li> <li>Valentin Gatien-Baron (@v-gb)</li> <li>vwkd (@vwkd)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0130-2024-01-03","title":"0.13.0 - 2024-01-03","text":""},{"location":"changelog.html#breaking-changes_26","title":"Breaking changes","text":"<ul> <li><code>jj git fetch</code> no longer imports new remote branches as local branches. Set   <code>git.auto-local-branch = true</code> to restore the old behavior.</li> </ul>"},{"location":"changelog.html#new-features_26","title":"New features","text":"<ul> <li> <p>Information about new and resolved conflicts is now printed by every command.</p> </li> <li> <p><code>jj branch</code> has gained a new <code>rename</code> subcommand that allows changing a branch   name atomically. <code>jj branch help rename</code> for details.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_29","title":"Fixed bugs","text":"<ul> <li>Command aliases can now be loaded from repository config relative to the   current working directory.   #2414</li> </ul>"},{"location":"changelog.html#contributors_26","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Essien Ita Essien (@essiene)</li> <li>Gabriel Scherer (@gasche)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0120-2023-12-05","title":"0.12.0 - 2023-12-05","text":""},{"location":"changelog.html#breaking-changes_27","title":"Breaking changes","text":"<ul> <li> <p>The <code>remote_branches()</code> revset no longer includes branches exported to the Git   repository (so called Git-tracking branches.)</p> </li> <li> <p><code>jj branch set</code> no longer creates a new branch. Use <code>jj branch create</code>   instead.</p> </li> <li> <p><code>jj init --git</code> in an existing Git repository now errors and exits rather than   creating a second Git store.</p> </li> </ul>"},{"location":"changelog.html#new-features_27","title":"New features","text":"<ul> <li> <p><code>jj workspace add</code> can now take multiple <code>--revision</code> arguments, which will   create a new workspace with its working-copy commit on top of all the parents,   as if you had run <code>jj new r1 r2 r3 ...</code>.</p> </li> <li> <p>You can now set <code>git.abandon-unreachable-commits = false</code> to disable the   usual behavior where commits that became unreachable in the Git repo are   abandoned (#2504).</p> </li> <li> <p><code>jj new</code> gained a <code>--no-edit</code> option to prevent editing the newly created   commit. For example, <code>jj new a b --no-edit -m Merge</code> creates a merge commit   without affecting the working copy.</p> </li> <li> <p><code>jj rebase</code> now takes the flag <code>--skip-empty</code>, which doesn't copy over commits   that would become empty after a rebase.</p> </li> <li> <p>There is a new <code>jj util gc</code> command for cleaning up the repository storage.   For now, it simply runs <code>git gc</code> on the backing Git repo (when using the Git   backend).</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_30","title":"Fixed bugs","text":"<ul> <li>Fixed another file conflict resolution issue where <code>jj status</code> would disagree   with the actual file content.   #2654</li> </ul>"},{"location":"changelog.html#contributors_27","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Antoine Cezar (@AntoineCezar)</li> <li>Anton Bulakh (@necauqua)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Saunders (@Ralith)</li> <li>Carlos Precioso (@cprecioso)</li> <li>Chris Krycho (@chriskrycho)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Jason R. Coombs (@jaraco)</li> <li>Jesse Somerville (@jessesomerville)</li> <li>\u0141ukasz Kurowski (@crackcomm)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>mlcui (@mlcui-corp)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0110-2023-11-01","title":"0.11.0 - 2023-11-01","text":""},{"location":"changelog.html#breaking-changes_28","title":"Breaking changes","text":"<ul> <li> <p>Conflicts are now stored in a different way. Commits written by a new <code>jj</code>   binary will not be read correctly by older <code>jj</code> binaries. The new model   solves some performance problems with the old model. For example, <code>jj log</code>   should be noticeably faster on large repos. You may need to create a new   clone to see the full speedup.</p> </li> <li> <p>The <code>remote_branches()</code> revset now includes branches exported to the Git   repository (so called Git-tracking branches.) This change will be reverted   in 0.12.0.</p> </li> <li> <p>Status messages are now printed to stderr.</p> </li> <li> <p><code>jj config set</code> now interprets the value as TOML also if it's a valid TOML   array or table. For example, <code>jj config set --user 'aliases.n' '[\"new\"]'</code></p> </li> <li> <p>Remote branches now have tracking or non-tracking flags. The   <code>git.auto-local-branch</code> setting is applied only to newly fetched remote   branches. Existing remote branches are migrated as follows:</p> <ul> <li>If local branch exists, the corresponding remote branches are considered   tracking branches.</li> <li>Otherwise, the remote branches are non-tracking branches.</li> </ul> <p>If the deduced tracking flags are wrong, use <code>jj branch track</code>/<code>untrack</code> commands to fix them up.</p> </li> <li> <p>Non-tracking remote branches aren't listed by default. Use <code>jj branch list   --all</code> to show all local and remote branches.</p> </li> <li> <p>It's not allowed to push branches if non-tracking remote branches of the same   name exist.</p> </li> <li> <p>Pushing deleted/moved branches no longer abandons the local commits referenced   by the remote branches.</p> </li> <li> <p><code>jj git fetch --branch</code> now requires <code>glob:</code> prefix to expand <code>*</code> in branch   name.</p> </li> </ul>"},{"location":"changelog.html#new-features_28","title":"New features","text":"<ul> <li> <p><code>jj</code>'s stable release can now be installed   with <code>cargo binstall jj-cli</code>.</p> </li> <li> <p><code>jj workspace add</code> now takes a <code>--revision</code> argument.</p> </li> <li> <p><code>jj workspace forget</code> can now forget multiple workspaces at once.</p> </li> <li> <p><code>branches()</code>/<code>remote_branches()</code>/<code>author()</code>/<code>committer()</code>/<code>description()</code>   revsets now support glob matching.</p> </li> <li> <p><code>jj branch delete</code>/<code>forget</code>/<code>list</code>, and <code>jj git push --branch</code> now support   string pattern syntax. The <code>--glob</code> option   is deprecated in favor of <code>glob:</code> pattern.</p> </li> <li> <p>The <code>branches</code>/<code>tags</code>/<code>git_refs</code>/<code>git_head</code> template keywords now return a   list of <code>RefName</code>s. They were previously pre-formatted strings.</p> </li> <li> <p>The new template keywords <code>local_branches</code>/<code>remote_branches</code> are added to show   only local/remote branches.</p> </li> <li> <p><code>jj workspace add</code> now preserves all parents of the old working-copy commit   instead of just the first one.</p> </li> <li> <p><code>jj rebase -r</code> gained the ability to rebase a revision <code>A</code> onto a descendant   of <code>A</code>.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_31","title":"Fixed bugs","text":"<ul> <li> <p>Updating the working copy to a commit where a file that's currently ignored   in the working copy no longer leads to a crash   (#976).</p> </li> <li> <p>Conflicts in executable files can now be resolved just like conflicts in   non-executable files (#1279).</p> </li> <li> <p><code>jj new --insert-before</code> and <code>--insert-after</code> now respect immutable revisions   (#2468).</p> </li> </ul>"},{"location":"changelog.html#contributors_28","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Antoine Cezar (@AntoineCezar)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Saunders (@Ralith)</li> <li>Gabriel Scherer (@gasche)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Infra (@1011X)</li> <li>Isabella Basso (@isinyaaa)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Tal Pressman (@talpr)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#0100-2023-10-04","title":"0.10.0 - 2023-10-04","text":""},{"location":"changelog.html#breaking-changes_29","title":"Breaking changes","text":"<ul> <li>A default revset-alias function <code>trunk()</code> now exists. If you previously   defined   your own <code>trunk()</code> alias it will continue to overwrite the built-in one.   Check revsets.toml   and revsets.md   to understand how the function can be adapted.</li> </ul>"},{"location":"changelog.html#new-features_29","title":"New features","text":"<ul> <li> <p>The <code>ancestors()</code> revset function now takes an optional <code>depth</code> argument   to limit the depth of the ancestor set. For example, use <code>jj log -r   'ancestors(@, 5)</code> to view the last 5 commits.</p> </li> <li> <p>Support for the Watchman filesystem monitor is now bundled by default. Set   <code>core.fsmonitor = \"watchman\"</code> in your repo to enable.</p> </li> <li> <p>You can now configure the set of immutable commits via   <code>revset-aliases.immutable_heads()</code>. For example, set it to   <code>\"remote_branches() | tags()\"</code> to prevent rewriting those those. Their   ancestors are implicitly also immutable.</p> </li> <li> <p><code>jj op log</code> now supports <code>--no-graph</code>.</p> </li> <li> <p>Templates now support an additional escape: <code>\\0</code>. This will output a literal   null byte. This may be useful for e.g.   <code>jj log -T 'description ++ \"\\0\"' --no-graph</code> to output descriptions only, but   be able to tell where the boundaries are</p> </li> <li> <p>jj now bundles a TUI tool to use as the default diff and merge editors. (The   previous default was <code>meld</code>.)</p> </li> <li> <p><code>jj split</code> supports the <code>--interactive</code> flag. (This is already the default if   no paths are provided.)</p> </li> <li> <p><code>jj commit</code> accepts an optional list of paths indicating a subset of files to   include in the first commit</p> </li> <li> <p><code>jj commit</code> accepts the <code>--interactive</code> flag.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_32","title":"Fixed bugs","text":""},{"location":"changelog.html#contributors_29","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Emily Kyle Fox (@emilykfox)</li> <li>glencbz (@glencbz)</li> <li>Hong Shin (@honglooker)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>James Sully (@sullyj3)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Ruben Slabbert (@rslabbert)</li> <li>Vamsi Avula (@avamsi)</li> <li>Waleed Khan (@arxanas)</li> <li>Willian Mori (@wmrmrx))</li> <li>Yuya Nishihara (@yuja)</li> <li>Zachary Dremann (@Dr-Emann)</li> </ul>"},{"location":"changelog.html#090-2023-09-06","title":"0.9.0 - 2023-09-06","text":""},{"location":"changelog.html#breaking-changes_30","title":"Breaking changes","text":"<ul> <li> <p>The minimum supported Rust version (MSRV) is now 1.71.0.</p> </li> <li> <p>The storage format of branches, tags, and git refs has changed. Newly-stored   repository data will no longer be loadable by older binaries.</p> </li> <li> <p>The <code>:</code> revset operator is deprecated. Use <code>::</code> instead. We plan to delete the   <code>:</code> form in jj 0.15+.</p> </li> <li> <p>The <code>--allow-large-revsets</code> flag for <code>jj rebase</code> and <code>jj new</code> was replaced by   a <code>all:</code> before the revset. For example, use <code>jj rebase -d 'all:foo-'</code>   instead of <code>jj rebase --allow-large-revsets -d 'foo-'</code>.</p> </li> <li> <p>The <code>--allow-large-revsets</code> flag for <code>jj rebase</code> and <code>jj new</code> can no longer be   used for allowing duplicate destinations. Include the potential duplicates   in a single expression instead (e.g. <code>jj new 'all:x|y'</code>).</p> </li> <li> <p>The <code>push.branch-prefix</code> option was renamed to <code>git.push-branch-prefix</code>.</p> </li> <li> <p>The default editor on Windows is now <code>Notepad</code> instead of <code>pico</code>.</p> </li> <li> <p><code>jj</code> will fail attempts to snapshot new files larger than 1MiB by default.   This behavior   can be customized with the <code>snapshot.max-new-file-size</code> config option.</p> </li> <li> <p>Author and committer signatures now use empty strings to represent unset   names and email addresses. The <code>author</code>/<code>committer</code> template keywords and   methods also return empty strings.   Older binaries may not warn user when attempting to <code>git push</code> commits   with such signatures.</p> </li> <li> <p>In revsets, the working-copy or remote symbols (such as <code>@</code>, <code>workspace_id@</code>,   and <code>branch@remote</code>) can no longer be quoted as a unit. If a workspace or   branch name contains whitespace, quote the name like <code>\"branch name\"@remote</code>.   Also, these symbols will not be resolved as revset aliases or function   parameters. For example, <code>author(foo@)</code> is now an error, and the revset alias   <code>'revset-aliases.foo@' = '@'</code> will be failed to parse.</p> </li> <li> <p>The <code>root</code> revset symbol has been converted to function <code>root()</code>.</p> </li> <li> <p>The <code>..x</code> revset is now evaluated to <code>root()..x</code>, which means the root commit   is no longer included.</p> </li> <li> <p><code>jj git push</code> will now push all branches in the range <code>remote_branches()..@</code>   instead of only branches pointing to <code>@</code> or <code>@-</code>.</p> </li> <li> <p>It's no longer allowed to create a Git remote named \"git\". Use <code>jj git remote   rename</code> to rename the existing remote.   #1690</p> </li> <li> <p>Revset expression like <code>origin/main</code> will no longer resolve to a   remote-tracking branch. Use <code>main@origin</code> instead.</p> </li> </ul>"},{"location":"changelog.html#new-features_30","title":"New features","text":"<ul> <li> <p>Default template for <code>jj log</code> now does not show irrelevant information   (timestamp, empty, message placeholder etc.) about the root commit.</p> </li> <li> <p>Commit templates now support the <code>root</code> keyword, which is <code>true</code> for the root   commit and <code>false</code> for every other commit.</p> </li> <li> <p><code>jj init --git-repo</code> now works with bare repositories.</p> </li> <li> <p><code>jj config edit --user</code> and <code>jj config set --user</code> will now pick a default   config location if no existing file is found, potentially creating parent   directories.</p> </li> <li> <p><code>jj log</code> output is now topologically grouped.   #242</p> </li> <li> <p><code>jj git clone</code> now supports the <code>--colocate</code> flag to create the git repo   in the same directory as the jj repo.</p> </li> <li> <p><code>jj restore</code> gained a new option <code>--changes-in</code> to restore files   from a merge revision's parents. This undoes the changes that <code>jj diff -r</code>   would show.</p> </li> <li> <p><code>jj diff</code>/<code>log</code> now supports <code>--tool &lt;name&gt;</code> option to generate diffs by   external program. For configuration, see the documentation.   #1886</p> </li> <li> <p>A new experimental diff editor <code>meld-3</code> is introduced that sets up Meld to   allow you to see both sides of the original diff while editing. This can be   used with <code>jj split</code>, <code>jj move -i</code>, etc.</p> </li> <li> <p><code>jj log</code>/<code>obslog</code>/<code>op log</code> now supports <code>--limit N</code> option to show the first   <code>N</code> entries.</p> </li> <li> <p>Added the <code>ui.paginate</code> option to enable/disable pager usage in commands</p> </li> <li> <p><code>jj checkout</code>/<code>jj describe</code>/<code>jj commit</code>/<code>jj new</code>/<code>jj squash</code> can take repeated   <code>-m/--message</code> arguments. Each passed message will be combined into paragraphs   (separated by a blank line)</p> </li> <li> <p>It is now possible to set a default description using the new   <code>ui.default-description</code> option, to use when describing changes with an empty   description.</p> </li> <li> <p><code>jj split</code> will now leave the description empty on the second part if the   description was empty on the input commit.</p> </li> <li> <p><code>branches()</code>/<code>remote_branches()</code>/<code>author()</code>/<code>committer()</code>/<code>description()</code>   revsets now support exact matching. For example, <code>branch(exact:main)</code>   selects the branch named \"main\", but not \"maint\". <code>description(exact:\"\")</code>   selects commits whose description is empty.</p> </li> <li> <p>Revsets gained a new function <code>mine()</code> that   aliases <code>author(exact:\"your_email\")</code>.</p> </li> <li> <p>Added support for <code>::</code> and <code>..</code> revset operators with both left and right   operands omitted. These expressions are equivalent to <code>all()</code> and <code>~root()</code>   respectively.</p> </li> <li> <p><code>jj log</code> timestamp format now accepts <code>.utc()</code> to convert a timestamp to UTC.</p> </li> <li> <p>templates now support additional string   methods <code>.starts_with(x)</code>, <code>.ends_with(x)</code> <code>.remove_prefix(x)</code>, <code>.remove_suffix(x)</code>, and <code>.substr(start, end)</code>.</p> </li> <li> <p><code>jj next</code> and <code>jj prev</code> are added, these allow you to traverse the history   in a linear style. For people coming from Sapling and <code>git-branchles</code>   see #2126 for   further pending improvements.</p> </li> <li> <p><code>jj diff --stat</code> has been implemented. It shows a histogram of the changes,   same as <code>git diff --stat</code>.   Fixes #2066</p> </li> <li> <p><code>jj git fetch --all-remotes</code> has been implemented. It fetches all remotes   instead of just the default remote</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_33","title":"Fixed bugs","text":"<ul> <li> <p>Fix issues related to .gitignore handling of untracked directories   #2051.</p> </li> <li> <p><code>jj config set --user</code> and <code>jj config edit --user</code> can now be used outside of   any repository.</p> </li> <li> <p>SSH authentication could hang when ssh-agent couldn't be reached   #1970</p> </li> <li> <p>SSH authentication can now use ed25519 and ed25519-sk keys. They still need   to be password-less.</p> </li> <li> <p>Git repository managed by the repo tool can now be detected as a \"colocated\"   repository.   #2011</p> </li> </ul>"},{"location":"changelog.html#contributors_30","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Alexander Potashev (@aspotashev)</li> <li>Anton Bulakh (@necauqua)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Brittain (@benbrittain)</li> <li>Benjamin Saunders (@Ralith)</li> <li>Christophe Poucet (@poucet)</li> <li>Emily Kyle Fox (@emilykfox)</li> <li>Glen Choo (@chooglen)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Kevin Liao (@kevincliao)</li> <li>Linus Arver (@listx)</li> <li>Martin Clausen (@maacl)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Matt Freitas-Stavola (@mbStavola)</li> <li>Oscar Bonilla (@ob)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Piotr Kufel (@qfel)</li> <li>Preston Van Loon (@prestonvanloon)</li> <li>Tal Pressman (@talpr)</li> <li>Vamsi Avula (@avamsi)</li> <li>Vincent Breitmoser (@Valodim)</li> <li>Vladimir (@0xdeafbeef)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> <li>Zachary Dremann (@Dr-Emann)</li> </ul>"},{"location":"changelog.html#080-2023-07-09","title":"0.8.0 - 2023-07-09","text":""},{"location":"changelog.html#breaking-changes_31","title":"Breaking changes","text":"<ul> <li> <p>The <code>jujutsu</code> and <code>jujutsu-lib</code> crates were renamed to <code>jj-cli</code> and <code>jj-lib</code>,   respectively.</p> </li> <li> <p>The <code>ui.oplog-relative-timestamps</code> option has been removed. Use the   <code>format_time_range()</code> template alias instead. For details, see   the documentation.</p> </li> <li> <p>Implicit concatenation of template expressions has been disabled. Use   <code>++</code> operator, <code>concat()</code>, or <code>separate()</code> function instead.   Example: <code>description ++ \"\\n\"</code></p> </li> <li> <p><code>jj git push</code> will consider pushing the parent commit only when the   current commit has no content and no description, such as right after   a <code>jj squash</code>.</p> </li> <li> <p>The minimum supported Rust version (MSRV) is now 1.64.0.</p> </li> <li> <p>The <code>heads()</code> revset function was split up into two functions. <code>heads()</code>   without arguments is now called <code>visible_heads()</code>. <code>heads()</code> with one argument   is unchanged.</p> </li> <li> <p>The <code>ui.default-revset</code> config was renamed to <code>revsets.log</code>.</p> </li> <li> <p>The <code>jj sparse</code> command was split up into <code>jj sparse list</code> and   <code>jj sparse set</code>.</p> </li> <li> <p><code>jj hide</code> (alias for <code>jj abandon</code>) is no longer available. Use <code>jj abandon</code>   instead.</p> </li> <li> <p><code>jj debug completion</code>, <code>jj debug mangen</code> and <code>jj debug config-schema</code> have   been moved from <code>jj debug</code> to <code>jj util</code>.</p> </li> <li> <p><code>jj</code> will no longer parse <code>br</code> as a git_ref <code>refs/heads/br</code> when a branch <code>br</code>   does not exist but the git_ref does (this is rare). Use <code>br@git</code> instead.</p> </li> <li> <p><code>jj git fetch</code> will no longer import unrelated branches from the underlying   Git repo.</p> </li> </ul>"},{"location":"changelog.html#new-features_31","title":"New features","text":"<ul> <li> <p><code>jj git push --deleted</code> will remove all locally deleted branches from the   remote.</p> </li> <li> <p><code>jj restore</code> without <code>--from</code> works correctly even if <code>@</code> is a merge   commit.</p> </li> <li> <p><code>jj rebase</code> now accepts multiple <code>-s</code> and <code>-b</code> arguments. Revsets with   multiple commits are allowed with <code>--allow-large-revsets</code>.</p> </li> <li> <p><code>jj git fetch</code> now supports a <code>--branch</code> argument to fetch some of the   branches only.</p> </li> <li> <p><code>jj config get</code> command allows retrieving config values for use in scripting.</p> </li> <li> <p><code>jj config set</code> command allows simple config edits like   <code>jj config set --repo user.email \"somebody@example.com\"</code></p> </li> <li> <p>Added <code>ui.log-word-wrap</code> option to wrap <code>jj log</code>/<code>obslog</code>/<code>op log</code> content   based on terminal width. #1043</p> </li> <li> <p>Nodes in the (text-based) graphical log output now use a <code>\u25c9</code> symbol instead   of the letter <code>o</code>. The ASCII-based graph styles still use <code>o</code>.</p> </li> <li> <p>Commands that accept a diff format (<code>jj diff</code>, <code>jj interdiff</code>, <code>jj show</code>,   <code>jj log</code>, and <code>jj obslog</code>) now accept <code>--types</code> to show only the type of file   before and after.</p> </li> <li> <p><code>jj describe</code> now supports <code>--reset-author</code> for resetting a commit's author   to the configured user. <code>jj describe</code> also gained a <code>--no-edit</code> option to   avoid opening the editor.</p> </li> <li> <p>Added <code>latest(x[, n])</code> revset function to select the latest <code>n</code> commits.</p> </li> <li> <p>Added <code>conflict()</code> revset function to select commits with conflicts.</p> </li> <li> <p><code>jj squash</code> AKA <code>jj amend</code> now accepts a <code>--message</code> option to set the   description of the squashed commit on the command-line.</p> </li> <li> <p>The progress display on <code>jj git clone/fetch</code> now includes the downloaded size.</p> </li> <li> <p>The formatter now supports a \"default\" color that can override another color   defined by a parent style.</p> </li> <li> <p><code>jj obslog</code> and <code>jj log</code> now show abandoned commits as hidden.</p> </li> <li> <p><code>jj git fetch</code> and <code>jj git push</code> will now use the single defined remote even   if it is not named \"origin\".</p> </li> <li> <p><code>jj git push</code> now accepts <code>--branch</code> and <code>--change</code> arguments together.</p> </li> <li> <p><code>jj git push</code> now accepts a <code>-r/--revisions</code> flag to specify revisions to   push. All branches pointing to any of the specified revisions will be pushed.   The flag can be used together with <code>--branch</code> and <code>--change</code>.</p> </li> <li> <p><code>jj</code> with no subcommand now defaults to <code>jj log</code> instead of showing help. This   command can be overridden by setting <code>ui.default-command</code>.</p> </li> <li> <p>Description tempfiles created via <code>jj describe</code> now have the file extension   <code>.jjdescription</code> to help external tooling detect a unique filetype.</p> </li> <li> <p>The shortest unique change ID prefixes and commit ID prefixes in <code>jj log</code> are   now shorter within the default log revset. You can override the default by   setting the <code>revsets.short-prefixes</code> config to a different revset.</p> </li> <li> <p>The last seen state of branches in the underlying git repo is now presented by   <code>jj branch list</code>/<code>jj log</code> as a remote called <code>git</code> (e.g. <code>main@git</code>). They can   also be referenced in revsets. Such branches exist in colocated repos or if   you use <code>jj git export</code>.</p> </li> <li> <p>The new <code>jj chmod</code> command allows setting or removing the executable bit on   paths. Unlike the POSIX <code>chmod</code>, it works on Windows, on conflicted files, and   on arbitrary revisions. Bits other than the executable bit are not planned to   be supported.</p> </li> <li> <p><code>jj sparse set</code> now accepts an <code>--edit</code> flag which brings up the <code>$EDITOR</code> to   edit sparse patterns.</p> </li> <li> <p><code>jj branch list</code> can now be filtered by revset.</p> </li> <li> <p>Initial support for the Watchman filesystem monitor. Set   <code>core.fsmonitor = \"watchman\"</code> in your repo to enable.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_34","title":"Fixed bugs","text":"<ul> <li> <p>Modify/delete conflicts now include context lines   #1244.</p> </li> <li> <p>It is now possible to modify either side of a modify/delete conflict (any   change used to be considered a resolution).</p> </li> <li> <p>Fixed a bug that could get partially resolved conflicts to be interpreted   incorrectly.</p> </li> <li> <p><code>jj git fetch</code>: when re-adding a remote repository that had been previously   removed, in some situations the remote branches were not recreated.</p> </li> <li> <p><code>jj git remote rename</code>: the git remote references were not rewritten with   the new name. If a new remote with the old name and containing the same   branches was added, the remote branches may not be recreated in some cases.</p> </li> <li> <p><code>jj workspace update-stale</code> now snapshots the working-copy changes before   updating to the new working-copy commit.</p> </li> <li> <p>It is no longer allowed to create branches at the root commit.</p> </li> <li> <p><code>git checkout</code> (without using <code>jj</code>) in colocated repo no longer abandons   the previously checked-out anonymous branch.   #1042.</p> </li> <li> <p><code>jj git fetch</code> in a colocated repo now abandons branches deleted on the   remote, just like in a non-colocated repo.   #864</p> </li> <li> <p><code>jj git fetch</code> can now fetch forgotten branches even if they didn't move on   the remote.   #1714 #1771</p> </li> <li> <p>It is now possible to <code>jj branch forget</code> deleted branches.   #1537</p> </li> <li> <p>Fixed race condition when assigning change id to Git commit. If you've   already had unreachable change ids, run <code>jj debug reindex</code>.   #924</p> </li> <li> <p>Fixed false divergence on racy working-copy snapshots.   #697,   #1608</p> </li> <li> <p>In colocated repos, a bug causing conflicts when undoing branch moves (#922)   has been fixed. Some surprising behaviors related to undoing <code>jj git push</code> or   <code>jj git fetch</code> remain.</p> </li> </ul>"},{"location":"changelog.html#contributors_31","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aaron Bull Schaefer (@elasticdog)</li> <li>Anton Bulakh (@necauqua)</li> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Saunders (@Ralith)</li> <li>B Wilson (@xelxebar)</li> <li>Christophe Poucet (@poucet)</li> <li>David Barnett (@dbarnett)</li> <li>Glen Choo (@chooglen)</li> <li>Gr\u00e9goire Geis (@71)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Isabella Basso (@isinyaaa)</li> <li>Kevin Liao (@kevincliao)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>mlcui (@mlcui-corp)</li> <li>Samuel Tardieu (@samueltardieu)</li> <li>Tal Pressman (@talpr)</li> <li>Vamsi Avula (@avamsi)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#070-2023-02-16","title":"0.7.0 - 2023-02-16","text":""},{"location":"changelog.html#breaking-changes_32","title":"Breaking changes","text":"<ul> <li> <p>The minimum supported Rust version (MSRV) is now 1.61.0.</p> </li> <li> <p>The <code>jj touchup</code> command was renamed to <code>jj diffedit</code>.</p> </li> <li> <p>The <code>-i</code> option to <code>jj restore</code> was removed in favor of new <code>--from</code>/<code>--to</code>   options to <code>jj diffedit</code>.</p> </li> <li> <p>To report the situation when a change id corresponds to multiple visible   commits, <code>jj log</code> now prints the change id in red and puts <code>??</code> after it.   Previously, it printed the word \"divergent\".</p> </li> <li> <p><code>jj log</code> prefixes commit descriptions with \"(empty)\" when they contain no   change compared to their parents.</p> </li> <li> <p>The <code>author</code>/<code>committer</code> templates now display both name and email. Use   <code>author.name()</code>/<code>committer.name()</code> to extract the name.</p> </li> <li> <p>Storage of the \"HEAD@git\" reference changed and can now have conflicts.   Operations written by a new <code>jj</code> binary will have a \"HEAD@git\" reference that   is not visible to older binaries.</p> </li> <li> <p>The <code>description</code> template keyword is now empty if no description set.   Use <code>if(description, description, \"(no description set)\\n\")</code> to get back   the previous behavior.</p> </li> <li> <p>The <code>template.log.graph</code> and <code>template.commit_summary</code> config keys were   renamed to <code>templates.log</code> and <code>templates.commit_summary</code> respectively.</p> </li> <li> <p>If a custom <code>templates.log</code> template is set, working-copy commit will   no longer be highlighted automatically. Wrap your template with   <code>label(if(current_working_copy, \"working_copy\"), ...)</code> to label the   working-copy entry.</p> </li> <li> <p>The <code>ui.relative-timestamps</code> option has been removed. Use the   <code>format_timestamp()</code> template alias instead. For details on showing relative   timestamps in <code>jj log</code> and <code>jj show</code>, see the documentation.</p> </li> <li> <p><code>jj op log</code> now shows relative timestamps by default. To disable, set   <code>ui.oplog-relative-timestamps</code> to <code>false</code>.</p> </li> <li> <p>The global <code>--no-commit-working-copy</code> is now called <code>--ignore-working-copy</code>.</p> </li> <li> <p>The <code>diff.format</code> config option is now called <code>ui.diff.format</code>. The old name   is still supported for now.</p> </li> <li> <p><code>merge-tools.&lt;name&gt;.edit-args</code> now requires <code>$left</code>/<code>$right</code> parameters.   The default is <code>edit-args = [\"$left\", \"$right\"]</code>.</p> </li> <li> <p>The builtin <code>jj update</code> and <code>jj up</code> aliases for <code>jj checkout</code> have been   deleted.</p> </li> <li> <p>Change IDs are now rendered using letters from the end of the alphabet (from   'z' through 'k') instead of the usual hex digits ('0' through '9' and 'a'   through 'f'). This is to clarify the distinction between change IDs and commit   IDs, and to allow more efficient lookup of unique prefixes. This change   doesn't affect the storage format; existing repositories will remain usable.</p> </li> </ul>"},{"location":"changelog.html#new-features_32","title":"New features","text":"<ul> <li> <p>The default log format now uses the committer timestamp instead of the author   timestamp.</p> </li> <li> <p><code>jj log --summary --patch</code> now shows both summary and diff outputs.</p> </li> <li> <p><code>jj git push</code> now accepts multiple <code>--branch</code>/<code>--change</code> arguments</p> </li> <li> <p><code>jj config list</code> command prints values from config and <code>config edit</code> opens   the config in an editor.</p> </li> <li> <p><code>jj debug config-schema</code> command prints out JSON schema for the jj TOML config   file format.</p> </li> <li> <p><code>jj resolve --list</code> can now describe the complexity of conflicts.</p> </li> <li> <p><code>jj resolve</code> now notifies the user of remaining conflicts, if any, on success.   This can be prevented by the new <code>--quiet</code> option.</p> </li> <li> <p>Per-repository configuration is now read from <code>.jj/repo/config.toml</code>.</p> </li> <li> <p>Background colors, bold text, and underlining are now supported. You can set   e.g. <code>colors.error = { bg = \"red\", bold = true, underline = true }</code> in your   <code>~/.jjconfig.toml</code>.</p> </li> <li> <p>The <code>empty</code> condition in templates is true when the commit makes no change to   the three compared to its parents.</p> </li> <li> <p><code>branches([needle])</code> revset function now takes <code>needle</code> as an optional   argument and matches just the branches whose name contains <code>needle</code>.</p> </li> <li> <p><code>remote_branches([branch_needle[, remote_needle]])</code> now takes <code>branch_needle</code>   and <code>remote_needle</code> as optional arguments and matches just the branches whose   name contains <code>branch_needle</code> and remote contains <code>remote_needle</code>.</p> </li> <li> <p><code>jj git fetch</code> accepts repeated <code>--remote</code> arguments.</p> </li> <li> <p>Default remotes can be configured for the <code>jj git fetch</code> and <code>jj git push</code>   operations (\"origin\" by default) using the <code>git.fetch</code> and <code>git.push</code>   configuration entries. <code>git.fetch</code> can be a list if multiple remotes must   be fetched from.</p> </li> <li> <p><code>jj duplicate</code> can now duplicate multiple changes in one go. This preserves   any parent-child relationships between them. For example, the entire tree of   descendants of <code>abc</code> can be duplicated with <code>jj duplicate abc:</code>.</p> </li> <li> <p><code>jj log</code> now highlights the shortest unique prefix of every commit and change   id and shows the rest in gray. To customize the length and style, use the   <code>format_short_id()</code> template alias. For details, see   the documentation.</p> </li> <li> <p><code>jj print</code> was renamed to <code>jj cat</code>. <code>jj print</code> remains as an alias.</p> </li> <li> <p>In content that goes to the terminal, the ANSI escape byte (0x1b) is replaced   by a \"\u241b\" character. That prevents them from interfering with the ANSI escapes   jj itself writes.</p> </li> <li> <p><code>jj workspace root</code> prints the root path of the current workspace.</p> </li> <li> <p>The <code>[alias]</code> config section was renamed to <code>[aliases]</code>. The old name is   still accepted for backwards compatibility for some time.</p> </li> <li> <p>Commands that draw an ASCII graph (<code>jj log</code>, <code>jj op log</code>, <code>jj obslog</code>) now   have different styles available by setting e.g. <code>ui.graph.style = \"curved\"</code>.</p> </li> <li> <p><code>jj split</code> accepts creating empty commits when given a path. <code>jj split .</code>   inserts an empty commit between the target commit and its children if any,   and <code>jj split any-non-existent-path</code> inserts an empty commit between the   target commit and its parents.</p> </li> <li> <p>Command arguments to <code>ui.diff-editor</code>/<code>ui.merge-editor</code> can now be specified   inline without referring to <code>[merge-tools]</code> table.</p> </li> <li> <p><code>jj rebase</code> now accepts a new <code>--allow-large-revsets</code> argument that allows the   revset in the <code>-d</code> argument to expand to several revisions. For example,   <code>jj rebase -s B -d B- -d C</code> now works even if <code>B</code> is a merge commit.</p> </li> <li> <p><code>jj new</code> now also accepts a <code>--allow-large-revsets</code> argument that behaves   similarly to <code>jj rebase --allow-large-revsets</code>.</p> </li> <li> <p><code>jj new --insert-before</code> inserts the new commit between the target commit and   its parents.</p> </li> <li> <p><code>jj new --insert-after</code> inserts the new commit between the target commit and   its children.</p> </li> <li> <p><code>author</code>/<code>committer</code> templates now support <code>.username()</code>, which leaves out the   domain information of <code>.email()</code>.</p> </li> <li> <p>It is now possible to change the author format of <code>jj log</code> with the   <code>format_short_signature()</code> template alias. For details, see   the documentation.</p> </li> <li> <p>Added support for template aliases. New symbols and functions can be   configured by <code>template-aliases.&lt;name&gt; = &lt;expression&gt;</code>. Be aware that   the template syntax isn't documented yet and is likely to change.</p> </li> <li> <p>The <code>ui.diff-instructions</code> config setting can be set to <code>false</code> to inhibit the   creation of the <code>JJ-INSTRUCTIONS</code> file as part of diff editing.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_35","title":"Fixed bugs","text":"<ul> <li> <p>When sharing the working copy with a Git repo, we used to forget to export   branches to Git when only the working copy had changed. That's now fixed.</p> </li> <li> <p>Commit description set by <code>-m</code>/<code>--message</code> is now terminated with a newline   character, just like descriptions set by editor are.</p> </li> <li> <p>The <code>-R</code>/<code>--repository</code> path must be a valid workspace directory. Its   ancestor directories are no longer searched.</p> </li> <li> <p>Fixed a crash when trying to access a commit that's never been imported into   the jj repo from a Git repo. They will now be considered as non-existent if   referenced explicitly instead of crashing.</p> </li> <li> <p>Fixed handling of escaped characters in .gitignore (only keep trailing spaces   if escaped properly).</p> </li> <li> <p><code>jj undo</code> now works after <code>jj duplicate</code>.</p> </li> <li> <p><code>jj duplicate</code> followed by <code>jj rebase</code> of a tree containing both the original   and duplicate commit no longer crashes. The fix should also resolve any   remaining   instances of https://github.com/jj-vcs/jj/issues/27.</p> </li> <li> <p>Fix the output of <code>jj debug completion --help</code> by reversing fish and zsh text.</p> </li> <li> <p>Fixed edge case in <code>jj git fetch</code> when a pruned branch is a prefix of another   branch.</p> </li> </ul>"},{"location":"changelog.html#contributors_32","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Aleksandr Mikhailov (@AM5800)</li> <li>Augie Fackler (@durin42)</li> <li>Benjamin Saunders (@Ralith)</li> <li>Daniel Ploch (@torquestomp)</li> <li>Danny Hooper (@hooper)</li> <li>David Barnett (@dbarnett)</li> <li>Glen Choo (@chooglen)</li> <li>Herby Gillot (@herbygillot)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Luke Granger-Brown (@lukegb)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Michael Forster (@MForster)</li> <li>Philip Metzger (@PhilipMetzger)</li> <li>Ruben Slabbert (@rslabbert)</li> <li>Samuel Tardieu (@samueltardieu)</li> <li>Tal Pressman (@talpr)</li> <li>Vamsi Avula (@avamsi)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"changelog.html#061-2022-12-05","title":"0.6.1 - 2022-12-05","text":"<p>No changes, only changed to a released version of the <code>thrift</code> crate dependency.</p>"},{"location":"changelog.html#060-2022-12-05","title":"0.6.0 - 2022-12-05","text":""},{"location":"changelog.html#breaking-changes_33","title":"Breaking changes","text":"<ul> <li> <p>Dropped candidates set argument from <code>description(needle)</code>, <code>author(needle)</code>,   <code>committer(needle)</code>, <code>merges()</code> revsets. Use <code>x &amp; description(needle)</code>   instead.</p> </li> <li> <p>Adjusted precedence of revset union/intersection/difference operators.   <code>x | y &amp; z</code> is now equivalent to <code>x | (y &amp; z)</code>.</p> </li> <li> <p>Support for open commits has been dropped. The <code>ui.enable-open-commits</code> config   that was added in 0.5.0 is no longer respected. The <code>jj open/close</code> commands   have been deleted.</p> </li> <li> <p><code>jj commit</code> is now a separate command from <code>jj close</code> (which no longer   exists). The behavior has changed slightly. It now always asks for a   description, even if there already was a description set. It now also only   works on the working-copy commit (there's no <code>-r</code> argument).</p> </li> <li> <p>If a workspace's working-copy commit has been updated from another workspace,   most commands in that workspace will now fail. Use the new   <code>jj workspace update-stale</code> command to update the workspace to the new   working-copy commit. (The old behavior was to automatically update the   workspace.)</p> </li> </ul>"},{"location":"changelog.html#new-features_33","title":"New features","text":"<ul> <li> <p>Commands with long output are paginated.   #9</p> </li> <li> <p>The new <code>jj git remote rename</code> command allows git remotes to be renamed   in-place.</p> </li> <li> <p>The new <code>jj resolve</code> command allows resolving simple conflicts with   an external 3-way-merge tool.</p> </li> <li> <p><code>jj git push</code> will search <code>@-</code> for branches to push if <code>@</code> has none.</p> </li> <li> <p>The new revset function <code>file(pattern..)</code> finds commits modifying the   paths specified by the <code>pattern..</code>.</p> </li> <li> <p>The new revset function <code>empty()</code> finds commits modifying no files.</p> </li> <li> <p>Added support for revset aliases. New symbols and functions can be configured   by <code>revset-aliases.&lt;name&gt; = &lt;expression&gt;</code>.</p> </li> <li> <p>It is now possible to specify configuration options on the command line   with the new <code>--config-toml</code> global option.</p> </li> <li> <p><code>jj git</code> subcommands will prompt for credentials when required for HTTPS   remotes rather than failing.   #469</p> </li> <li> <p>Branches that have a different target on some remote than they do locally are   now indicated by an asterisk suffix (e.g. <code>main*</code>) in <code>jj log</code>.   #254</p> </li> <li> <p>The commit ID was moved from first on the line in <code>jj log</code> output to close to   the end. The goal is to encourage users to use the change ID instead, since   that is generally more convenient, and it reduces the risk of creating   divergent commits.</p> </li> <li> <p>The username and hostname that appear in the operation log are now   configurable via config options <code>operation.username</code> and <code>operation.hostname</code>.</p> </li> <li> <p><code>jj git</code> subcommands now support credential helpers.</p> </li> <li> <p><code>jj log</code> will warn if it appears that the provided path was meant to be a   revset.</p> </li> <li> <p>The new global flag <code>-v/--verbose</code> will turn on debug logging to give   some additional insight into what is happening behind the scenes.   Note: This is not comprehensively supported by all operations yet.</p> </li> <li> <p><code>jj log</code>, <code>jj show</code>, and <code>jj obslog</code> now all support showing relative   timestamps by setting <code>ui.relative-timestamps = true</code> in the config file.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_36","title":"Fixed bugs","text":"<ul> <li> <p>A bug in the export of branches to Git caused spurious conflicted branches.   This typically occurred when running in a working copy colocated with Git   (created by running <code>jj init --git-dir=.</code>).   #463</p> </li> <li> <p>When exporting branches to Git, we used to fail if some branches could not be   exported (e.g. because Git doesn't allow a branch called <code>main</code> and another   branch called <code>main/sub</code>). We now print a warning about these branches   instead.   #493</p> </li> <li> <p>If you had modified branches in jj and also modified branches in conflicting   ways in Git, <code>jj git export</code> used to overwrite the changes you made in Git.   We now print a warning about these branches instead.</p> </li> <li> <p><code>jj edit root</code> now fails gracefully.</p> </li> <li> <p><code>jj git import</code> used to abandon a commit if Git branches and tags referring   to it were removed. We now keep it if a detached HEAD refers to it.</p> </li> <li> <p><code>jj git import</code> no longer crashes when all Git refs are removed.</p> </li> <li> <p>Git submodules are now ignored completely. Earlier, files present in the   submodule directory in the working copy would become added (tracked), and   later removed if you checked out another commit. You can now use <code>git</code> to   populate the submodule directory and <code>jj</code> will leave it alone.</p> </li> <li> <p>Git's GC could remove commits that were referenced from jj in some cases. We   are now better at adding Git refs to prevent that.   #815</p> </li> <li> <p>When the working-copy commit was a merge, <code>jj status</code> would list only the   first parent, and the diff summary would be against that parent. The output   now lists all parents and the diff summary is against the auto-merged parents.</p> </li> </ul>"},{"location":"changelog.html#contributors_33","title":"Contributors","text":"<p>Thanks to the people who made this release happen!</p> <ul> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Benjamin Saunders (@Ralith)</li> <li>Yuya Nishihara (@yuja)</li> <li>Glen Choo (@chooglen)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Ruben Slabbert (@rslabbert)</li> <li>Waleed Khan (@arxanas)</li> <li>Sean E. Russell (@xxxserxxx)</li> <li>Pranay Sashank (@pranaysashank)</li> <li>Luke Granger-Brown (@lukegb)</li> </ul>"},{"location":"changelog.html#051-2022-10-17","title":"0.5.1 - 2022-10-17","text":"<p>No changes (just trying to get automated GitHub release to work).</p>"},{"location":"changelog.html#050-2022-10-17","title":"0.5.0 - 2022-10-17","text":""},{"location":"changelog.html#breaking-changes_34","title":"Breaking changes","text":"<ul> <li> <p>Open commits are now disabled by default. That means that <code>jj checkout</code> will   always create a new change on top of the specified commit and will let you   edit that in the working copy. Set <code>ui.enable-open-commits = true</code> to restore   the old behavior and let us know that you did so we know how many people   prefer the workflow with open commits.</p> </li> <li> <p><code>jj [op] undo</code> and <code>jj op restore</code> used to take the operation to undo or   restore to as an argument to <code>-o/--operation</code>. It is now a positional   argument instead (i.e. <code>jj undo -o abc123</code> is now written <code>jj undo abc123</code>).</p> </li> <li> <p>An alias that is not configured as a string list (e.g. <code>my-status = \"status\"</code>   instead of <code>my-status = [\"status\"]</code>) is now an error instead of a warning.</p> </li> <li> <p><code>jj log</code> now defaults to showing only commits that are not on any remote   branches (plus their closest commit on the remote branch for context). This   set of commits can be overridden by setting <code>ui.default-revset</code>. Use   <code>jj log -r 'all()'</code> for the old behavior. Read more about revsets   here.   #250</p> </li> <li> <p><code>jj new</code> now always checks out the new commit (used to be only if the parent   was <code>@</code>).</p> </li> <li> <p><code>jj merge</code> now checks out the new commit. The command now behaves exactly   like <code>jj new</code>, except that it requires at least two arguments.</p> </li> <li> <p>When the working-copy commit is abandoned by <code>jj abandon</code> and the parent   commit is open, a new working-copy commit will be created on top (the open   parent commit used to get checked out).</p> </li> <li> <p><code>jj branch</code> now uses subcommands like <code>jj branch create</code> and   <code>jj branch forget</code> instead of options like <code>jj branch --forget</code>.   #330</p> </li> <li> <p>The <code>$NO_COLOR</code> environment variable no longer   overrides the <code>ui.color</code> configuration if explicitly set.</p> </li> <li> <p><code>jj edit</code> has been renamed to <code>jj touchup</code>, and <code>jj edit</code> is now a new command   with different behavior. The new <code>jj edit</code> lets you edit a commit in the   working copy, even if the specified commit is closed.</p> </li> <li> <p><code>jj git push</code> no longer aborts if you attempt to push an open commit (but it   now aborts if a commit does not have a description).</p> </li> <li> <p><code>jj git push</code> now pushes only branches pointing to the <code>@</code> by default. Use   <code>--all</code> to push all branches.</p> </li> <li> <p>The <code>checkouts</code> template keyword is now called <code>working_copies</code>, and   <code>current_checkout</code> is called <code>current_working_copy</code>.</p> </li> </ul>"},{"location":"changelog.html#new-features_34","title":"New features","text":"<ul> <li> <p>The new <code>jj interdiff</code> command compares the changes in commits, ignoring   changes from intervening commits.</p> </li> <li> <p><code>jj rebase</code> now accepts a <code>--branch/-b &lt;revision&gt;</code> argument, which can be used   instead of <code>-r</code> or <code>-s</code> to specify which commits to rebase. It will rebase the   whole branch, relative to the destination. The default mode has changed from   <code>-r @</code> to <code>-b @</code>.</p> </li> <li> <p>The new <code>jj print</code> command prints the contents of a file in a revision.</p> </li> <li> <p>The new <code>jj git remotes list</code> command lists the configured remotes and their   URLs.   #243</p> </li> <li> <p><code>jj move</code> and <code>jj squash</code> now lets you limit the set of changes to move by   specifying paths on the command line (in addition to the <code>--interactive</code>   mode). For example, use <code>jj move --to @-- foo</code> to move the changes to file   (or directory) <code>foo</code> in the working copy to the grandparent commit.</p> </li> <li> <p>When <code>jj move/squash/unsquash</code> abandons the source commit because it became   empty and both the source and the destination commits have non-empty   descriptions, it now asks for a combined description. If either description   was empty, it uses the other without asking.</p> </li> <li> <p><code>jj split</code> now lets you specify on the CLI which paths to include in the first   commit. The interactive diff-editing is not started when you do that.</p> </li> <li> <p>Sparse checkouts are now supported. In fact, all working copies are now   \"sparse\", only to different degrees. Use the <code>jj sparse</code> command to manage   the paths included in the sparse checkout.</p> </li> <li> <p>Configuration is now also read from <code>~/.jjconfig.toml</code>.</p> </li> <li> <p>The <code>$JJ_CONFIG</code> environment variable can now point to a directory. If it   does, all files in the directory will be read, in alphabetical order.</p> </li> <li> <p>The <code>$VISUAL</code> environment is now respected and overrides <code>$EDITOR</code>. The new   <code>ui.editor</code> config has higher priority than both of them. There is also a new   <code>$JJ_EDITOR</code> environment variable, which has even higher priority than the   config.</p> </li> <li> <p>You can now use <code>-</code> and <code>+</code> in revset symbols. You used to have to quote   branch names like <code>my-feature</code> in nested quotes (outer layer for your shell)   like <code>jj co '\"my-feature\"'</code>. The quoting is no longer needed.</p> </li> <li> <p>The new revset function <code>connected(x)</code> is the same as <code>x:x</code>.</p> </li> <li> <p>The new revset function <code>roots(x)</code> finds commits in the set that are not   descendants of other commits in the set.</p> </li> <li> <p>ssh-agent is now detected even if <code>$SSH_AGENT_PID</code> is not set (as long as   <code>$SSH_AUTH_SOCK</code> is set). This should help at least macOS users where   ssh-agent is launched by default and only <code>$SSH_AUTH_SOCK</code> is set.</p> </li> <li> <p>When importing from a git, any commits that are no longer referenced on the   git side will now be abandoned on the jj side as well. That means that   <code>jj git fetch</code> will now abandon unreferenced commits and rebase any local   changes you had on top.</p> </li> <li> <p><code>jj git push</code> gained a <code>--change &lt;revision&gt;</code> argument. When that's used, it   will create a branch named after the revision's change ID, so you don't have   to create a branch yourself. By default, the branch name will start with   <code>push-</code>, but this can be overridden by the <code>push.branch-prefix</code> config   setting.</p> </li> <li> <p><code>jj git push</code> now aborts if you attempt to push a commit without a   description or with the placeholder \"(no name/email configured)\" values for   author/committer.</p> </li> <li> <p>Diff editor command arguments can now be specified by config file.   Example:</p> <pre><code>[merge-tools.kdiff3]\nprogram = \"kdiff3\"\nedit-args = [\"--merge\", \"--cs\", \"CreateBakFiles=0\"]\n</code></pre> </li> <li> <p><code>jj branch</code> can accept any number of branches to update, rather than just one.</p> </li> <li> <p>Aliases can now call other aliases.</p> </li> <li> <p><code>jj log</code> now accepts a <code>--reversed</code> option, which will show older commits   first.</p> </li> <li> <p><code>jj log</code> now accepts file paths.</p> </li> <li> <p><code>jj obslog</code> now accepts <code>-p</code>/<code>--patch</code> option, which will show the diff   compared to the previous version of the change.</p> </li> <li> <p>The \"(no name/email configured)\" placeholder value for name/email will now be   replaced if once you modify a commit after having configured your name/email.</p> </li> <li> <p>Color setting can now be overridden by <code>--color=always|never|auto</code> option.</p> </li> <li> <p><code>jj checkout</code> now lets you specify a description with <code>--message/-m</code>.</p> </li> <li> <p><code>jj new</code> can now be used for creating merge commits. If you pass more than   one argument to it, the new commit will have all of them as parents.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_37","title":"Fixed bugs","text":"<ul> <li> <p>When rebasing a conflict where one side modified a file and the other side   deleted it, we no longer automatically resolve it in favor of the modified   content (this was a regression from commit c0ae4b16e8c4).</p> </li> <li> <p>Errors are now printed to stderr (they used to be printed to stdout).</p> </li> <li> <p>Updating the working copy to a commit where a file's executable bit changed   but the contents was the same used to lead to a crash. That has now been   fixed.</p> </li> <li> <p>If one side of a merge modified a directory and the other side deleted it, it   used to be considered a conflict. The same was true if both sides added a   directory with different files in. They are now merged as if the missing   directory had been empty.</p> </li> <li> <p>When using <code>jj move</code> to move part of a commit into an ancestor, any branches   pointing to the source commit used to be left on a hidden intermediate commit.   They are now correctly updated.</p> </li> <li> <p><code>jj untrack</code> now requires at least one path (allowing no arguments was a UX   bug).</p> </li> <li> <p><code>jj rebase</code> now requires at least one destination (allowing no arguments was a   UX bug).</p> </li> <li> <p><code>jj restore --to &lt;rev&gt;</code> now restores from the working copy (it used to restore   from the working copy's parent).</p> </li> <li> <p>You now get a proper error message instead of a crash when <code>$EDITOR</code> doesn't   exist or exits with an error.</p> </li> <li> <p>Global arguments, such as <code>--at-op=&lt;operation&gt;</code>, can now be passed before   an alias.</p> </li> <li> <p>Fixed relative path to the current directory in output to be <code>.</code> instead of   empty string.</p> </li> <li> <p>When adding a new workspace, the parent of the current workspace's current   checkout will be checked out. That was always the intent, but the root commit   was accidentally checked out instead.</p> </li> <li> <p>When checking out a commit, the previous commit is no longer abandoned if it   has a non-empty description.</p> </li> <li> <p>All commands now consistently snapshot the working copy (it was missing from   e.g. <code>jj undo</code> and <code>jj merge</code> before).</p> </li> </ul>"},{"location":"changelog.html#040-2022-04-02","title":"0.4.0 - 2022-04-02","text":""},{"location":"changelog.html#breaking-changes_35","title":"Breaking changes","text":"<ul> <li>Dropped support for config in <code>~/.jjconfig</code>. Your configuration is now read   from <code>&lt;config dir&gt;/jj/config.toml</code>, where <code>&lt;config dir&gt;</code> is   <code>${XDG_CONFIG_HOME}</code> or <code>~/.config/</code> on Linux,   <code>~/Library/Application Support/</code> on macOS, and <code>~\\AppData\\Roaming\\</code> on   Windows.</li> </ul>"},{"location":"changelog.html#new-features_35","title":"New features","text":"<ul> <li> <p>You can now set an environment variable called <code>$JJ_CONFIG</code> to a path to a   config file. That will then be read instead of your regular config file. This   is mostly intended for testing and scripts.</p> </li> <li> <p>The standard <code>$NO_COLOR</code> environment variable is now   respected.</p> </li> <li> <p><code>jj new</code> now lets you specify a description with <code>--message/-m</code>.</p> </li> <li> <p>When you check out a commit, the old commit no longer automatically gets   abandoned if it's empty and has descendants, it only gets abandoned if it's   empty and does not have descendants.</p> </li> <li> <p>When undoing an earlier operation, any new commits on top of commits from the   undone operation will be rebased away. For example, let's say you rebase   commit A so it becomes a new commit A', and then you create commit B on top of   A'. If you now undo the rebase operation, commit B will be rebased to be on   top of A instead. The same logic is used if the repo was modified by   concurrent operations (so if one operation added B on top of A, and one   operation rebased A as A', then B would be automatically rebased on top of   A'). See #111 for more examples.   #111</p> </li> <li> <p><code>jj log</code> now accepts <code>-p</code>/<code>--patch</code> option.</p> </li> </ul>"},{"location":"changelog.html#fixed-bugs_38","title":"Fixed bugs","text":"<ul> <li> <p>Fixed crash on <code>jj init --git-repo=.</code> (it almost always crashed).</p> </li> <li> <p>When sharing the working copy with a Git repo, the automatic importing and   exporting (sometimes?) didn't happen on Windows.</p> </li> </ul>"},{"location":"changelog.html#033-2022-03-16","title":"0.3.3 - 2022-03-16","text":"<p>No changes, only trying to get the automated build to work.</p>"},{"location":"changelog.html#032-2022-03-16","title":"0.3.2 - 2022-03-16","text":"<p>No changes, only trying to get the automated build to work.</p>"},{"location":"changelog.html#031-2022-03-13","title":"0.3.1 - 2022-03-13","text":""},{"location":"changelog.html#fixed-bugs_39","title":"Fixed bugs","text":"<ul> <li>Fixed crash when <code>core.excludesFile</code> pointed to nonexistent file, and made   leading <code>~/</code> in that config expand to <code>$HOME/</code> #131</li> </ul>"},{"location":"changelog.html#030-2022-03-12","title":"0.3.0 - 2022-03-12","text":"<p>Last release before this changelog started.</p>"},{"location":"cli-reference.html","title":"CLI reference","text":"<p>Warning</p> <p>This CLI reference is experimental. It is automatically generated, but does not match the <code>jj help</code> output exactly.</p> <p>Run <code>jj help &lt;COMMAND&gt;</code> for more authoritative documentation.</p> <p>If you see a significant difference, feel free to file a bug, or a PR to note the difference here.</p>"},{"location":"cli-reference.html#command-line-help-for-jj","title":"Command-Line Help for <code>jj</code>","text":"<p>This document contains the help content for the <code>jj</code> command-line program.</p> <p>Command Overview:</p> <ul> <li><code>jj</code>\u21b4</li> <li><code>jj abandon</code>\u21b4</li> <li><code>jj absorb</code>\u21b4</li> <li><code>jj bisect</code>\u21b4</li> <li><code>jj bisect run</code>\u21b4</li> <li><code>jj bookmark</code>\u21b4</li> <li><code>jj bookmark create</code>\u21b4</li> <li><code>jj bookmark delete</code>\u21b4</li> <li><code>jj bookmark forget</code>\u21b4</li> <li><code>jj bookmark list</code>\u21b4</li> <li><code>jj bookmark move</code>\u21b4</li> <li><code>jj bookmark rename</code>\u21b4</li> <li><code>jj bookmark set</code>\u21b4</li> <li><code>jj bookmark track</code>\u21b4</li> <li><code>jj bookmark untrack</code>\u21b4</li> <li><code>jj commit</code>\u21b4</li> <li><code>jj config</code>\u21b4</li> <li><code>jj config edit</code>\u21b4</li> <li><code>jj config get</code>\u21b4</li> <li><code>jj config list</code>\u21b4</li> <li><code>jj config path</code>\u21b4</li> <li><code>jj config set</code>\u21b4</li> <li><code>jj config unset</code>\u21b4</li> <li><code>jj describe</code>\u21b4</li> <li><code>jj diff</code>\u21b4</li> <li><code>jj diffedit</code>\u21b4</li> <li><code>jj duplicate</code>\u21b4</li> <li><code>jj edit</code>\u21b4</li> <li><code>jj evolog</code>\u21b4</li> <li><code>jj file</code>\u21b4</li> <li><code>jj file annotate</code>\u21b4</li> <li><code>jj file chmod</code>\u21b4</li> <li><code>jj file list</code>\u21b4</li> <li><code>jj file search</code>\u21b4</li> <li><code>jj file show</code>\u21b4</li> <li><code>jj file track</code>\u21b4</li> <li><code>jj file untrack</code>\u21b4</li> <li><code>jj fix</code>\u21b4</li> <li><code>jj gerrit</code>\u21b4</li> <li><code>jj gerrit upload</code>\u21b4</li> <li><code>jj git</code>\u21b4</li> <li><code>jj git clone</code>\u21b4</li> <li><code>jj git colocation</code>\u21b4</li> <li><code>jj git colocation disable</code>\u21b4</li> <li><code>jj git colocation enable</code>\u21b4</li> <li><code>jj git colocation status</code>\u21b4</li> <li><code>jj git export</code>\u21b4</li> <li><code>jj git fetch</code>\u21b4</li> <li><code>jj git import</code>\u21b4</li> <li><code>jj git init</code>\u21b4</li> <li><code>jj git push</code>\u21b4</li> <li><code>jj git remote</code>\u21b4</li> <li><code>jj git remote add</code>\u21b4</li> <li><code>jj git remote list</code>\u21b4</li> <li><code>jj git remote remove</code>\u21b4</li> <li><code>jj git remote rename</code>\u21b4</li> <li><code>jj git remote set-url</code>\u21b4</li> <li><code>jj git root</code>\u21b4</li> <li><code>jj help</code>\u21b4</li> <li><code>jj interdiff</code>\u21b4</li> <li><code>jj log</code>\u21b4</li> <li><code>jj metaedit</code>\u21b4</li> <li><code>jj new</code>\u21b4</li> <li><code>jj next</code>\u21b4</li> <li><code>jj operation</code>\u21b4</li> <li><code>jj operation abandon</code>\u21b4</li> <li><code>jj operation diff</code>\u21b4</li> <li><code>jj operation integrate</code>\u21b4</li> <li><code>jj operation log</code>\u21b4</li> <li><code>jj operation restore</code>\u21b4</li> <li><code>jj operation revert</code>\u21b4</li> <li><code>jj operation show</code>\u21b4</li> <li><code>jj parallelize</code>\u21b4</li> <li><code>jj prev</code>\u21b4</li> <li><code>jj rebase</code>\u21b4</li> <li><code>jj redo</code>\u21b4</li> <li><code>jj resolve</code>\u21b4</li> <li><code>jj restore</code>\u21b4</li> <li><code>jj revert</code>\u21b4</li> <li><code>jj root</code>\u21b4</li> <li><code>jj show</code>\u21b4</li> <li><code>jj sign</code>\u21b4</li> <li><code>jj simplify-parents</code>\u21b4</li> <li><code>jj sparse</code>\u21b4</li> <li><code>jj sparse edit</code>\u21b4</li> <li><code>jj sparse list</code>\u21b4</li> <li><code>jj sparse reset</code>\u21b4</li> <li><code>jj sparse set</code>\u21b4</li> <li><code>jj split</code>\u21b4</li> <li><code>jj squash</code>\u21b4</li> <li><code>jj status</code>\u21b4</li> <li><code>jj tag</code>\u21b4</li> <li><code>jj tag delete</code>\u21b4</li> <li><code>jj tag list</code>\u21b4</li> <li><code>jj tag set</code>\u21b4</li> <li><code>jj undo</code>\u21b4</li> <li><code>jj unsign</code>\u21b4</li> <li><code>jj util</code>\u21b4</li> <li><code>jj util completion</code>\u21b4</li> <li><code>jj util config-schema</code>\u21b4</li> <li><code>jj util exec</code>\u21b4</li> <li><code>jj util gc</code>\u21b4</li> <li><code>jj util install-man-pages</code>\u21b4</li> <li><code>jj util markdown-help</code>\u21b4</li> <li><code>jj version</code>\u21b4</li> <li><code>jj workspace</code>\u21b4</li> <li><code>jj workspace add</code>\u21b4</li> <li><code>jj workspace forget</code>\u21b4</li> <li><code>jj workspace list</code>\u21b4</li> <li><code>jj workspace rename</code>\u21b4</li> <li><code>jj workspace root</code>\u21b4</li> <li><code>jj workspace update-stale</code>\u21b4</li> </ul>"},{"location":"cli-reference.html#jj","title":"<code>jj</code>","text":"<p>Jujutsu (An experimental VCS)</p> <p>To get started, see the tutorial [<code>jj help -k tutorial</code>].</p> <p>Usage: <code>jj [OPTIONS] [COMMAND]</code></p> <p>'jj help --help' lists available keywords. Use 'jj help -k' to show help for one of these keywords.</p>"},{"location":"cli-reference.html#subcommands","title":"Subcommands:","text":"<ul> <li><code>abandon</code> \u2014 Abandon a revision</li> <li><code>absorb</code> \u2014 Move changes from a revision into the stack of mutable revisions</li> <li><code>bisect</code> \u2014 Find a bad revision by bisection</li> <li><code>bookmark</code> \u2014 Manage bookmarks [default alias: b]</li> <li><code>commit</code> \u2014 Update the description and create a new change on top [default alias: ci]</li> <li><code>config</code> \u2014 Manage config options</li> <li><code>describe</code> \u2014 Update the change description or other metadata [default alias: desc]</li> <li><code>diff</code> \u2014 Compare file contents between two revisions</li> <li><code>diffedit</code> \u2014 Touch up the content changes in a revision with a diff editor</li> <li><code>duplicate</code> \u2014 Create new changes with the same content as existing ones</li> <li><code>edit</code> \u2014 Sets the specified revision as the working-copy revision</li> <li><code>evolog</code> \u2014 Show how a change has evolved over time</li> <li><code>file</code> \u2014 File operations</li> <li><code>fix</code> \u2014 Update files with formatting fixes or other changes</li> <li><code>gerrit</code> \u2014 Interact with Gerrit Code Review</li> <li><code>git</code> \u2014 Commands for working with Git remotes and the underlying Git repo</li> <li><code>help</code> \u2014 Print this message or the help of the given subcommand(s)</li> <li><code>interdiff</code> \u2014 Show differences between the diffs of two revisions</li> <li><code>log</code> \u2014 Show revision history</li> <li><code>metaedit</code> \u2014 Modify the metadata of a revision without changing its content</li> <li><code>new</code> \u2014 Create a new, empty change and (by default) edit it in the working copy</li> <li><code>next</code> \u2014 Move the working-copy commit to the child revision</li> <li><code>operation</code> \u2014 Commands for working with the operation log</li> <li><code>parallelize</code> \u2014 Parallelize revisions by making them siblings</li> <li><code>prev</code> \u2014 Change the working copy revision relative to the parent revision</li> <li><code>rebase</code> \u2014 Move revisions to different parent(s)</li> <li><code>redo</code> \u2014 Redo the most recently undone operation</li> <li><code>resolve</code> \u2014 Resolve conflicted files with an external merge tool</li> <li><code>restore</code> \u2014 Restore paths from another revision</li> <li><code>revert</code> \u2014 Apply the reverse of the given revision(s)</li> <li><code>root</code> \u2014 Show the current workspace root directory (shortcut for <code>jj workspace root</code>)</li> <li><code>show</code> \u2014 Show commit description and changes in a revision</li> <li><code>sign</code> \u2014 Cryptographically sign a revision</li> <li><code>simplify-parents</code> \u2014 Simplify parent edges for the specified revision(s)</li> <li><code>sparse</code> \u2014 Manage which paths from the working-copy commit are present in the working copy</li> <li><code>split</code> \u2014 Split a revision in two</li> <li><code>squash</code> \u2014 Move changes from a revision into another revision</li> <li><code>status</code> \u2014 Show high-level repo status [default alias: st]</li> <li><code>tag</code> \u2014 Manage tags</li> <li><code>undo</code> \u2014 Undo the last operation</li> <li><code>unsign</code> \u2014 Drop a cryptographic signature</li> <li><code>util</code> \u2014 Infrequently used commands such as for generating shell completions</li> <li><code>version</code> \u2014 Display version information</li> <li><code>workspace</code> \u2014 Commands for working with workspaces</li> </ul>"},{"location":"cli-reference.html#options","title":"Options:","text":"<ul> <li> <p><code>-R</code>, <code>--repository &lt;REPOSITORY&gt;</code> \u2014 Path to repository to operate on</p> <p>By default, Jujutsu searches for the closest .jj/ directory in an ancestor of the current working directory.</p> </li> <li> <p><code>--ignore-working-copy</code> \u2014 Don't snapshot the working copy, and don't update it</p> <p>By default, Jujutsu snapshots the working copy at the beginning of every command. The working copy is also updated at the end of the command, if the command modified the working-copy commit (<code>@</code>). If you want to avoid snapshotting the working copy and instead see a possibly stale working-copy commit, you can use <code>--ignore-working-copy</code>. This may be useful e.g. in a command prompt, especially if you have another process that commits the working copy.</p> <p>Loading the repository at a specific operation with <code>--at-operation</code> implies <code>--ignore-working-copy</code>.</p> </li> <li> <p><code>--ignore-immutable</code> \u2014 Allow rewriting immutable commits</p> <p>By default, Jujutsu prevents rewriting commits in the configured set of immutable commits. This option disables that check and lets you rewrite any commit but the root commit.</p> <p>This option only affects the check. It does not affect the <code>immutable_heads()</code> revset or the <code>immutable</code> template keyword.</p> </li> <li> <p><code>--at-operation &lt;AT_OPERATION&gt;</code> [alias: <code>at-op</code>] \u2014 Operation to load the repo at</p> <p>Operation to load the repo at. By default, Jujutsu loads the repo at the most recent operation, or at the merge of the divergent operations if any.</p> <p>You can use <code>--at-op=&lt;operation ID&gt;</code> to see what the repo looked like at an earlier operation. For example <code>jj --at-op=&lt;operation ID&gt; st</code> will show you what <code>jj st</code> would have shown you when the given operation had just finished. <code>--at-op=@</code> is pretty much the same as the default except that divergent operations will never be merged.</p> <p>Use <code>jj op log</code> to find the operation ID you want. Any unambiguous prefix of the operation ID is enough.</p> <p>When loading the repo at an earlier operation, the working copy will be ignored, as if <code>--ignore-working-copy</code> had been specified.</p> <p>It is possible to run mutating commands when loading the repo at an earlier operation. Doing that is equivalent to having run concurrent commands starting at the earlier operation. There's rarely a reason to do that, but it is possible.</p> </li> <li> <p><code>--debug</code> \u2014 Enable debug logging</p> </li> <li> <p><code>--color &lt;WHEN&gt;</code> \u2014 When to colorize output</p> <p>Possible values: <code>always</code>, <code>never</code>, <code>debug</code>, <code>auto</code></p> </li> <li> <p><code>--quiet</code> \u2014 Silence non-primary command output</p> <p>For example, <code>jj file list</code> will still list files, but it won't tell you if the working copy was snapshotted or if descendants were rebased.</p> <p>Warnings and errors will still be printed.</p> </li> <li> <p><code>--no-pager</code> \u2014 Disable the pager</p> </li> <li> <p><code>--config &lt;NAME=VALUE&gt;</code> \u2014 Additional configuration options (can be repeated)</p> <p>The name should be specified as TOML dotted keys. The value should be specified as a TOML expression. If string value isn't enclosed by any TOML constructs (such as array notation), quotes can be omitted.</p> </li> <li> <p><code>--config-file &lt;PATH&gt;</code> \u2014 Additional configuration files (can be repeated)</p> </li> </ul>"},{"location":"cli-reference.html#jj-abandon","title":"<code>jj abandon</code>","text":"<p>Abandon a revision</p> <p>Abandon a revision, rebasing descendants onto its parent(s). The behavior is similar to <code>jj restore --changes-in</code>; the difference is that <code>jj abandon</code> gives you a new change, while <code>jj restore</code> updates the existing change.</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>Usage: <code>jj abandon [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) to abandon (default: @) [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#options_1","title":"Options:","text":"<ul> <li> <p><code>--retain-bookmarks</code> \u2014 Do not delete bookmarks pointing to the revisions to abandon</p> <p>Bookmarks will be moved to the parent revisions instead.</p> </li> <li> <p><code>--restore-descendants</code> \u2014 Do not modify the content of the children of the abandoned commits</p> </li> </ul>"},{"location":"cli-reference.html#jj-absorb","title":"<code>jj absorb</code>","text":"<p>Move changes from a revision into the stack of mutable revisions</p> <p>This command splits changes in the source revision and moves each change to the closest mutable ancestor where the corresponding lines were modified last. If the destination revision cannot be determined unambiguously, the change will be left in the source revision.</p> <p>The source revision will be abandoned if all changes are absorbed into the destination revisions, and if the source revision has no description.</p> <p>The modification made by <code>jj absorb</code> can be reviewed by <code>jj op show -p</code>.</p> <p>Usage: <code>jj absorb [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_1","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Move only changes to these paths (instead of all paths)</li> </ul>"},{"location":"cli-reference.html#options_2","title":"Options:","text":"<ul> <li> <p><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Source revision to absorb from</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-t</code>, <code>--into &lt;REVSETS&gt;</code> [alias: <code>to</code>] \u2014 Destination revisions to absorb into</p> <p>Only ancestors of the source revision will be considered.</p> <p>Default value: <code>mutable()</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-bisect","title":"<code>jj bisect</code>","text":"<p>Find a bad revision by bisection</p> <p>Usage: <code>jj bisect &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_1","title":"Subcommands:","text":"<ul> <li><code>run</code> \u2014 Run a given command to find the first bad revision</li> </ul>"},{"location":"cli-reference.html#jj-bisect-run","title":"<code>jj bisect run</code>","text":"<p>Run a given command to find the first bad revision.</p> <p>Uses binary search to find the first bad revision. Revisions are evaluated by running a given command (see the documentation for <code>--command</code> for details).</p> <p>It is assumed that if a given revision is bad, then all its descendants in the input range are also bad.</p> <p>The target of the bisection can be inverted to look for the first good revision by passing <code>--find-good</code>.</p> <p>Hint: You can pass your shell as evaluation command. You can then run manual tests in the shell and make sure to exit the shell with appropriate error code depending on the outcome (e.g. <code>exit 0</code> to mark the revision as good in Bash or Fish).</p> <p>Example: To run <code>cargo test</code> with the changes from revision <code>xyz</code> applied:</p> <p><code>jj bisect run --range v1.0..main -- bash -c \"jj duplicate -r xyz -B @ &amp;&amp; cargo test\"</code></p> <p>Usage: <code>jj bisect run [OPTIONS] --range &lt;REVSETS&gt; [COMMAND] [ARGS]...</code></p>"},{"location":"cli-reference.html#arguments_2","title":"Arguments:","text":"<ul> <li> <p><code>&lt;COMMAND&gt;</code> \u2014 Command to run to determine whether the bug is present</p> <p>The exit status of the command will be used to mark revisions as good or bad: status 0 means good, 125 means to skip the revision, 127 (command not found) will abort the bisection, and any other non-zero exit status means the revision is bad.</p> <p>The target's commit ID is available to the command in the <code>$JJ_BISECT_TARGET</code> environment variable.</p> </li> <li> <p><code>&lt;ARGS&gt;</code> \u2014 Arguments to pass to the command</p> <p>Hint: Use a <code>--</code> separator to allow passing arguments starting with <code>-</code>. For example <code>jj bisect run --range=... -- test -f some-file</code>.</p> </li> </ul>"},{"location":"cli-reference.html#options_3","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--range &lt;REVSETS&gt;</code> \u2014 Range of revisions to bisect</p> <p>This is typically a range like <code>v1.0..main</code>. The heads of the range are assumed to be bad. Ancestors of the range that are not also in the range are assumed to be good.</p> </li> <li> <p><code>--find-good</code> \u2014 Whether to find the first good revision instead</p> <p>Inverts the interpretation of exit statuses (excluding special exit statuses).</p> <p>Default value: <code>false</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark","title":"<code>jj bookmark</code>","text":"<p>Manage bookmarks [default alias: b]</p> <p>See [<code>jj help -k bookmarks</code>] for more information.</p> <p>Usage: <code>jj bookmark &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_2","title":"Subcommands:","text":"<ul> <li><code>create</code> \u2014 Create a new bookmark</li> <li><code>delete</code> \u2014 Delete an existing bookmark and propagate the deletion to remotes on the next push</li> <li><code>forget</code> \u2014 Forget a bookmark without marking it as a deletion to be pushed</li> <li><code>list</code> \u2014 List bookmarks and their targets</li> <li><code>move</code> \u2014 Move existing bookmarks to target revision</li> <li><code>rename</code> \u2014 Rename <code>old</code> bookmark name to <code>new</code> bookmark name</li> <li><code>set</code> \u2014 Create a new bookmark, or update an existing one by name</li> <li><code>track</code> \u2014 Start tracking given remote bookmarks</li> <li><code>untrack</code> \u2014 Stop tracking given remote bookmarks</li> </ul>"},{"location":"cli-reference.html#jj-bookmark-create","title":"<code>jj bookmark create</code>","text":"<p>Create a new bookmark</p> <p>Usage: <code>jj bookmark create [OPTIONS] &lt;NAMES&gt;...</code></p> <p>Command Alias: <code>c</code></p>"},{"location":"cli-reference.html#arguments_3","title":"Arguments:","text":"<ul> <li><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to create</li> </ul>"},{"location":"cli-reference.html#options_4","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> [alias: <code>to</code>] \u2014 The bookmark's target revision</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-delete","title":"<code>jj bookmark delete</code>","text":"<p>Delete an existing bookmark and propagate the deletion to remotes on the next push</p> <p>Revisions referred to by the deleted bookmarks are not abandoned. To delete revisions as well as bookmarks, use <code>jj abandon</code>. For example, <code>jj abandon main..&lt;bookmark&gt;</code> will abandon revisions belonging to the <code>&lt;bookmark&gt;</code> branch (relative to the <code>main</code> branch.)</p> <p>If you don't want the deletion of the local bookmark to propagate to any tracked remote bookmarks, use <code>jj bookmark forget</code> instead.</p> <p>Usage: <code>jj bookmark delete &lt;NAMES&gt;...</code></p> <p>Command Alias: <code>d</code></p>"},{"location":"cli-reference.html#arguments_4","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to delete</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-forget","title":"<code>jj bookmark forget</code>","text":"<p>Forget a bookmark without marking it as a deletion to be pushed</p> <p>If a local bookmark is forgotten, any corresponding remote bookmarks will become untracked to ensure that the forgotten bookmark will not impact remotes on future pushes.</p> <p>Usage: <code>jj bookmark forget [OPTIONS] &lt;NAMES&gt;...</code></p> <p>Command Alias: <code>f</code></p>"},{"location":"cli-reference.html#arguments_5","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to forget</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#options_5","title":"Options:","text":"<ul> <li> <p><code>--include-remotes</code> \u2014 When forgetting a local bookmark, also forget any corresponding remote bookmarks</p> <p>A forgotten remote bookmark will not impact remotes on future pushes. It will be recreated on future fetches if it still exists on the remote. If there is a corresponding Git-tracking remote bookmark, it will also be forgotten.</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-list","title":"<code>jj bookmark list</code>","text":"<p>List bookmarks and their targets</p> <p>By default, a tracked remote bookmark will be included only if its target is different from the local target. An untracked remote bookmark won't be listed. For a conflicted bookmark (both local and remote), old target revisions are preceded by a \"-\" and new target revisions are preceded by a \"+\".</p> <p>See [<code>jj help -k bookmarks</code>] for more information.</p> <p>Usage: <code>jj bookmark list [OPTIONS] [NAMES]...</code></p> <p>Command Alias: <code>l</code></p>"},{"location":"cli-reference.html#arguments_6","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Show bookmarks whose local name matches</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#options_6","title":"Options:","text":"<ul> <li><code>-a</code>, <code>--all-remotes</code> \u2014 Show all tracked and untracked remote bookmarks including the ones whose targets are synchronized with the local bookmarks</li> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 Show all tracked and untracked remote bookmarks belonging to this remote</p> <p>Can be combined with <code>--tracked</code> or <code>--conflicted</code> to filter the bookmarks shown (can be repeated.)</p> <p>By default, the specified pattern matches remote names with glob syntax. You can also use other string pattern syntax.</p> </li> <li> <p><code>-t</code>, <code>--tracked</code> \u2014 Show tracked remote bookmarks only</p> <p>This omits local Git-tracking bookmarks by default.</p> </li> <li> <p><code>-c</code>, <code>--conflicted</code> \u2014 Show conflicted bookmarks only</p> </li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Show bookmarks whose local targets are in the given revisions</p> <p>Note that <code>-r deleted_bookmark</code> will not work since <code>deleted_bookmark</code> wouldn't have a local target.</p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each bookmark using the given template</p> <p>All 0-argument methods of the [<code>CommitRef</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> </li> <li> <p><code>--sort &lt;SORT_KEY&gt;</code> \u2014 Sort bookmarks based on the given key (or multiple keys)</p> <p>Suffix the key with <code>-</code> to sort in descending order of the value (e.g. <code>--sort name-</code>). Note that when using multiple keys, the first key is the most significant.</p> <p>This defaults to the <code>ui.bookmark-list-sort-keys</code> setting.</p> <p>Possible values: <code>name</code>, <code>name-</code>, <code>author-name</code>, <code>author-name-</code>, <code>author-email</code>, <code>author-email-</code>, <code>author-date</code>, <code>author-date-</code>, <code>committer-name</code>, <code>committer-name-</code>, <code>committer-email</code>, <code>committer-email-</code>, <code>committer-date</code>, <code>committer-date-</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-move","title":"<code>jj bookmark move</code>","text":"<p>Move existing bookmarks to target revision</p> <p>Unlike <code>jj bookmark set</code>, this command cannot create new bookmarks.</p> <p>If bookmark names are given, the specified bookmarks will be updated to point to the target revision.</p> <p>If <code>--from</code> options are given, bookmarks currently pointing to the specified revisions will be updated. The bookmarks can also be filtered by names.</p> <p>Example: pull up the nearest bookmarks to the working-copy parent</p> <p>$ jj bookmark move --from 'heads(::@- &amp; bookmarks())' --to @-</p> <p>Usage: <code>jj bookmark move [OPTIONS] &lt;NAMES|--from &lt;REVSETS&gt;&gt;</code></p> <p>Command Alias: <code>m</code></p>"},{"location":"cli-reference.html#arguments_7","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Move bookmarks matching the given name patterns</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#options_7","title":"Options:","text":"<ul> <li><code>-f</code>, <code>--from &lt;REVSETS&gt;</code> \u2014 Move bookmarks from the given revisions</li> <li> <p><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 Move bookmarks to this revision</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-B</code>, <code>--allow-backwards</code> \u2014 Allow moving bookmarks backwards or sideways</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-rename","title":"<code>jj bookmark rename</code>","text":"<p>Rename <code>old</code> bookmark name to <code>new</code> bookmark name</p> <p>The new bookmark name points at the same commit as the old bookmark name.</p> <p>Usage: <code>jj bookmark rename &lt;OLD&gt; &lt;NEW&gt;</code></p> <p>Command Alias: <code>r</code></p>"},{"location":"cli-reference.html#arguments_8","title":"Arguments:","text":"<ul> <li><code>&lt;OLD&gt;</code> \u2014 The old name of the bookmark</li> <li><code>&lt;NEW&gt;</code> \u2014 The new name of the bookmark</li> </ul>"},{"location":"cli-reference.html#jj-bookmark-set","title":"<code>jj bookmark set</code>","text":"<p>Create a new bookmark, or update an existing one by name</p> <p>If you want to move bookmarks based on their current location rather than by name, use <code>jj bookmark move --from &lt;REVSETS&gt;</code>.</p> <p>Usage: <code>jj bookmark set [OPTIONS] &lt;NAMES&gt;...</code></p> <p>Command Alias: <code>s</code></p>"},{"location":"cli-reference.html#arguments_9","title":"Arguments:","text":"<ul> <li><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to update</li> </ul>"},{"location":"cli-reference.html#options_8","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> [alias: <code>to</code>] \u2014 The bookmark's target revision</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-B</code>, <code>--allow-backwards</code> \u2014 Allow moving the bookmark backwards or sideways</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-track","title":"<code>jj bookmark track</code>","text":"<p>Start tracking given remote bookmarks</p> <p>A tracked remote bookmark will be imported as a local bookmark of the same name. Changes to it will propagate to the existing local bookmark on future pulls.</p> <p>Usage: <code>jj bookmark track [OPTIONS] &lt;BOOKMARK&gt;...</code></p> <p>Command Alias: <code>t</code></p>"},{"location":"cli-reference.html#arguments_10","title":"Arguments:","text":"<ul> <li> <p><code>&lt;BOOKMARK&gt;</code> \u2014 Bookmark names to track</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#options_9","title":"Options:","text":"<ul> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 Remote names to track</p> <p>By default, the specified pattern matches remote names with glob syntax. You can also use other string pattern syntax.</p> <p>If no remote names are given, all remote bookmarks matching the bookmark names will be tracked.</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-untrack","title":"<code>jj bookmark untrack</code>","text":"<p>Stop tracking given remote bookmarks</p> <p>An untracked remote bookmark is just a pointer to the last-fetched remote bookmark. It won't be imported as a local bookmark on future pulls.</p> <p>If you want to forget a local bookmark while also untracking the corresponding remote bookmarks, use <code>jj bookmark forget</code> instead.</p> <p>Usage: <code>jj bookmark untrack [OPTIONS] &lt;BOOKMARK&gt;...</code></p>"},{"location":"cli-reference.html#arguments_11","title":"Arguments:","text":"<ul> <li> <p><code>&lt;BOOKMARK&gt;</code> \u2014 Bookmark names to untrack</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#options_10","title":"Options:","text":"<ul> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 Remote names to untrack</p> <p>By default, the specified pattern matches remote names with glob syntax. You can also use other string pattern syntax.</p> <p>If no remote names are given, all remote bookmarks matching the bookmark names will be untracked.</p> </li> </ul>"},{"location":"cli-reference.html#jj-commit","title":"<code>jj commit</code>","text":"<p>Update the description and create a new change on top [default alias: ci]</p> <p>When called without path arguments or <code>--interactive</code>, <code>jj commit</code> is equivalent to <code>jj describe</code> followed by <code>jj new</code>.</p> <p>When using <code>--interactive</code> or path arguments, the selected changes stay in the current commit while the remaining changes are moved to a new working-copy commit on top. This is very similar to <code>jj split</code>. Differences include:</p> <ul> <li> <p><code>jj commit</code> is not interactive by default (it selects all changes).</p> </li> <li> <p><code>jj commit</code> doesn't have a <code>-r</code> option. It always acts on the working-copy commit (@).</p> </li> <li> <p><code>jj split</code> (without <code>-o</code>/<code>-A</code>/<code>-B</code>) will move bookmarks forward from the old change to the child change. <code>jj commit</code> doesn't move bookmarks forward.</p> </li> <li> <p><code>jj split</code> allows you to move the selected changes to a different destination with <code>-o</code>/<code>-A</code>/<code>-B</code>.</p> </li> </ul> <p>Usage: <code>jj commit [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_12","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Put these paths in the current commit</li> </ul>"},{"location":"cli-reference.html#options_11","title":"Options:","text":"<ul> <li><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which changes to include in the current commit</li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</li> <li><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use (don't open editor)</li> <li> <p><code>--editor</code> \u2014 Open an editor to edit the change description</p> <p>Forces an editor to open when using <code>--message</code> to allow the message to be edited afterwards.</p> </li> </ul>"},{"location":"cli-reference.html#jj-config","title":"<code>jj config</code>","text":"<p>Manage config options</p> <p>Operates on jj configuration, which comes from the config file and environment variables.</p> <p>See [<code>jj help -k config</code>] to know more about file locations, supported config options, and other details about <code>jj config</code>.</p> <p>Usage: <code>jj config &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_3","title":"Subcommands:","text":"<ul> <li><code>edit</code> \u2014 Start an editor on a jj config file</li> <li><code>get</code> \u2014 Get the value of a given config option.</li> <li><code>list</code> \u2014 List variables set in config files, along with their values</li> <li><code>path</code> \u2014 Print the paths to the config files</li> <li><code>set</code> \u2014 Update a config file to set the given option to a given value</li> <li><code>unset</code> \u2014 Update a config file to unset the given option</li> </ul>"},{"location":"cli-reference.html#jj-config-edit","title":"<code>jj config edit</code>","text":"<p>Start an editor on a jj config file.</p> <p>Creates the file if it doesn't already exist regardless of what the editor does.</p> <p>Usage: <code>jj config edit &lt;--user|--repo|--workspace&gt;</code></p> <p>Command Alias: <code>e</code></p>"},{"location":"cli-reference.html#options_12","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> <li><code>--workspace</code> \u2014 Target the workspace-level config</li> </ul>"},{"location":"cli-reference.html#jj-config-get","title":"<code>jj config get</code>","text":"<p>Get the value of a given config option.</p> <p>Unlike <code>jj config list</code>, the result of <code>jj config get</code> is printed without extra formatting and therefore is usable in scripting. For example:</p> <p>$ jj config list user.name user.name=\"Martin von Zweigbergk\" $ jj config get user.name Martin von Zweigbergk</p> <p>Usage: <code>jj config get &lt;NAME&gt;</code></p> <p>Command Alias: <code>g</code></p>"},{"location":"cli-reference.html#arguments_13","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code></li> </ul>"},{"location":"cli-reference.html#jj-config-list","title":"<code>jj config list</code>","text":"<p>List variables set in config files, along with their values</p> <p>Usage: <code>jj config list [OPTIONS] [NAME]</code></p> <p>Command Alias: <code>l</code></p>"},{"location":"cli-reference.html#arguments_14","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code> \u2014 An optional name of a specific config option to look up</li> </ul>"},{"location":"cli-reference.html#options_13","title":"Options:","text":"<ul> <li><code>--include-defaults</code> \u2014 Whether to explicitly include built-in default values in the list</li> <li><code>--include-overridden</code> \u2014 Allow printing overridden values</li> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> <li><code>--workspace</code> \u2014 Target the workspace-level config</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each variable using the given template</p> <p>The following keywords are available in the template expression:</p> <ul> <li><code>name: String</code>: Config name, in TOML's \"dotted key\" format.</li> <li><code>value: ConfigValue</code>: Value to be formatted in TOML syntax.</li> <li><code>overridden: Boolean</code>: True if the value is shadowed by other.</li> <li><code>source: String</code>: Source of the value.</li> <li><code>path: String</code>: Path to the config file.</li> </ul> <p>Can be overridden by the <code>templates.config_list</code> setting. To  see a detailed config list, use the <code>builtin_config_list_detailed</code>  template.</p> <p>See [<code>jj help -k templates</code>] for more information.</p> </li> </ul>"},{"location":"cli-reference.html#jj-config-path","title":"<code>jj config path</code>","text":"<p>Print the paths to the config files</p> <p>A config file at that path may or may not exist.</p> <p>If <code>--repo</code> or <code>--workspace</code> is specified and the config file does not exist, jj will generate a new config directory for this repo/workspace and print the path to the config file in that directory.</p> <p>See <code>jj config edit</code> if you'd like to immediately edit a file.</p> <p>Usage: <code>jj config path &lt;--user|--repo|--workspace&gt;</code></p> <p>Command Alias: <code>p</code></p>"},{"location":"cli-reference.html#options_14","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> <li><code>--workspace</code> \u2014 Target the workspace-level config</li> </ul>"},{"location":"cli-reference.html#jj-config-set","title":"<code>jj config set</code>","text":"<p>Update a config file to set the given option to a given value</p> <p>Usage: <code>jj config set &lt;--user|--repo|--workspace&gt; &lt;NAME&gt; &lt;VALUE&gt;</code></p> <p>Command Alias: <code>s</code></p>"},{"location":"cli-reference.html#arguments_15","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code></li> <li> <p><code>&lt;VALUE&gt;</code> \u2014 New value to set</p> <p>The value should be specified as a TOML expression. If string value isn't enclosed by any TOML constructs (such as apostrophes or array notation), quotes can be omitted. Note that the value may also need shell quoting. TOML multi-line strings can be useful if the value contains apostrophes. For example, to set <code>foo.bar</code> to the string \"{don't}\" use <code>jj config set --user foo.bar \"'''{don't}'''\"</code>. This is valid in both Bash and Fish.</p> <p>Alternative, e.g. to avoid dealing with shell quoting, use <code>jj config edit</code> to edit the TOML file directly.</p> </li> </ul>"},{"location":"cli-reference.html#options_15","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> <li><code>--workspace</code> \u2014 Target the workspace-level config</li> </ul>"},{"location":"cli-reference.html#jj-config-unset","title":"<code>jj config unset</code>","text":"<p>Update a config file to unset the given option</p> <p>Usage: <code>jj config unset &lt;--user|--repo|--workspace&gt; &lt;NAME&gt;</code></p> <p>Command Alias: <code>u</code></p>"},{"location":"cli-reference.html#arguments_16","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code></li> </ul>"},{"location":"cli-reference.html#options_16","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> <li><code>--workspace</code> \u2014 Target the workspace-level config</li> </ul>"},{"location":"cli-reference.html#jj-describe","title":"<code>jj describe</code>","text":"<p>Update the change description or other metadata [default alias: desc]</p> <p>Starts an editor to let you edit the description of changes. The editor will be $EDITOR, or <code>nano</code> if that's not defined (<code>Notepad</code> on Windows).</p> <p>Usage: <code>jj describe [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_17","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) whose description to edit (default: @) [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#options_17","title":"Options:","text":"<ul> <li> <p><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use (don't open editor)</p> <p>If multiple revisions are specified, the same description will be used for all of them.</p> </li> <li> <p><code>--stdin</code> \u2014 Read the change description from stdin</p> <p>If multiple revisions are specified, the same description will be used for all of them.</p> </li> <li> <p><code>--editor</code> \u2014 Open an editor to edit the change description</p> <p>Forces an editor to open when using <code>--stdin</code> or <code>--message</code> to allow the message to be edited afterwards.</p> </li> </ul>"},{"location":"cli-reference.html#jj-diff","title":"<code>jj diff</code>","text":"<p>Compare file contents between two revisions</p> <p>With the <code>-r</code> option, shows the changes compared to the parent revision. If there are several parent revisions (i.e., the given revision is a merge), then they will be merged and the changes from the result to the given revision will be shown.</p> <p>With the <code>--from</code> and/or <code>--to</code> options, shows the difference from/to the given revisions. If either is left out, it defaults to the working-copy commit. For example, <code>jj diff --from main</code> shows the changes from \"main\" (perhaps a bookmark name) to the working-copy commit.</p> <p>If no option is specified, it defaults to <code>-r @</code>.</p> <p>Usage: <code>jj diff [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_18","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restrict the diff to these paths</li> </ul>"},{"location":"cli-reference.html#options_18","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Show changes in these revisions</p> <p>If there are multiple revisions, then the total diff for all of them will be shown. For example, if you have a linear chain of revisions A..D, then <code>jj diff -r B::D</code> equals <code>jj diff --from A --to D</code>. Multiple heads and/or roots are supported, but gaps in the revset are not supported (e.g. <code>jj diff -r 'A|C'</code> in a linear chain A..C).</p> <p>If a revision is a merge commit, this shows changes from the automatic merge of the contents of all of its parents to the contents of the revision itself.</p> <p>If none of <code>-r</code>, <code>-f</code>, or <code>-t</code> is provided, then the default is <code>-r @</code>.</p> </li> <li> <p><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Show changes from this revision</p> <p>If none of <code>-r</code>, <code>-f</code>, or <code>-t</code> is provided, then the default is <code>-r @</code>.</p> </li> <li> <p><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 Show changes to this revision</p> <p>If none of <code>-r</code>, <code>-f</code>, or <code>-t</code> is provided, then the default is <code>-r @</code>.</p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each file diff entry using the given template</p> <p>All 0-argument methods of the [<code>TreeDiffEntry</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>-w</code>, <code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>-b</code>, <code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-diffedit","title":"<code>jj diffedit</code>","text":"<p>Touch up the content changes in a revision with a diff editor</p> <p>With the <code>-r</code> option, starts a diff editor on the changes in the revision.</p> <p>With the <code>--from</code> and/or <code>--to</code> options, starts a diff editor comparing the \"from\" revision to the \"to\" revision.</p> <p>Edit the right side of the diff until it looks the way you want. Once you close the editor, the revision specified with <code>-r</code> or <code>--to</code> will be updated. Unless <code>--restore-descendants</code> is used, descendants will be rebased on top as usual, which may result in conflicts.</p> <p>See <code>jj restore</code> if you want to move entire files from one revision to another. For moving changes between revisions, see <code>jj squash -i</code>.</p> <p>Usage: <code>jj diffedit [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_19","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Edit only these paths (unmatched paths will remain unchanged)</li> </ul>"},{"location":"cli-reference.html#options_19","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to touch up</p> <p>Defaults to @ if neither --to nor --from are specified.</p> </li> <li> <p><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Show changes from this revision</p> <p>Defaults to @ if --to is specified.</p> </li> <li> <p><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 Edit changes in this revision</p> <p>Defaults to @ if --from is specified.</p> </li> <li> <p><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used</p> </li> <li> <p><code>--restore-descendants</code> \u2014 Preserve the content (not the diff) when rebasing descendants</p> <p>When rebasing a descendant on top of the rewritten revision, its diff compared to its parent(s) is normally preserved, i.e. the same way that descendants are always rebased. This flag makes it so the content/state is preserved instead of preserving the diff.</p> </li> </ul>"},{"location":"cli-reference.html#jj-duplicate","title":"<code>jj duplicate</code>","text":"<p>Create new changes with the same content as existing ones</p> <p>When none of the <code>--onto</code>, <code>--insert-after</code>, or <code>--insert-before</code> arguments are provided, commits will be duplicated onto their existing parents or onto other newly duplicated commits.</p> <p>When any of the <code>--onto</code>, <code>--insert-after</code>, or <code>--insert-before</code> arguments are provided, the roots of the specified commits will be duplicated onto the destination indicated by the arguments. Other specified commits will be duplicated onto these newly duplicated commits. If the <code>--insert-after</code> or <code>--insert-before</code> arguments are provided, the new children indicated by the arguments will be rebased onto the heads of the specified commits.</p> <p>By default, the duplicated commits retain the descriptions of the originals. This can be customized with the <code>templates.duplicate_description</code> setting.</p> <p>Usage: <code>jj duplicate [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_20","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) to duplicate (default: @) [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#options_20","title":"Options:","text":"<ul> <li><code>-o</code>, <code>--onto &lt;REVSETS&gt;</code> [alias: <code>destination</code>] \u2014 The revision(s) to duplicate onto (can be repeated to create a merge commit)</li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> [alias: <code>after</code>] \u2014 The revision(s) to insert after (can be repeated to create a merge commit)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> [alias: <code>before</code>] \u2014 The revision(s) to insert before (can be repeated to create a merge commit)</li> </ul>"},{"location":"cli-reference.html#jj-edit","title":"<code>jj edit</code>","text":"<p>Sets the specified revision as the working-copy revision</p> <p>Note: it is generally recommended to instead use <code>jj new</code> and <code>jj squash</code>.</p> <p>Usage: <code>jj edit &lt;REVSET|-r &lt;REVSET&gt;&gt;</code></p>"},{"location":"cli-reference.html#arguments_21","title":"Arguments:","text":"<ul> <li><code>&lt;REVSET&gt;</code> \u2014 The commit to edit [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#jj-evolog","title":"<code>jj evolog</code>","text":"<p>Show how a change has evolved over time</p> <p>Lists the previous commits which a change has pointed to. The current commit of a change evolves when the change is updated, rebased, etc.</p> <p>Usage: <code>jj evolog [OPTIONS]</code></p> <p>Command Alias: <code>evolution-log</code></p>"},{"location":"cli-reference.html#options_21","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Follow changes from these revisions</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-n</code>, <code>--limit &lt;LIMIT&gt;</code> \u2014 Limit number of revisions to show</p> <p>Applied after revisions are reordered topologically, but before being reversed.</p> </li> <li> <p><code>--reversed</code> \u2014 Show revisions in the opposite order (older revisions first)</p> </li> <li><code>-G</code>, <code>--no-graph</code> \u2014 Don't show the graph, show a flat list of revisions</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each revision using the given template</p> <p>All 0-argument methods of the [<code>CommitEvolutionEntry</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> <p>If not specified, this defaults to the <code>templates.evolog</code> setting.</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch compared to the previous version of this change</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-file","title":"<code>jj file</code>","text":"<p>File operations</p> <p>Usage: <code>jj file &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_4","title":"Subcommands:","text":"<ul> <li><code>annotate</code> \u2014 Show the source change for each line of the target file</li> <li><code>chmod</code> \u2014 Sets or removes the executable bit for paths in the repo</li> <li><code>list</code> \u2014 List files in a revision</li> <li><code>search</code> \u2014 Search for content in files</li> <li><code>show</code> \u2014 Print contents of files in a revision</li> <li><code>track</code> \u2014 Start tracking specified paths in the working copy</li> <li><code>untrack</code> \u2014 Stop tracking specified paths in the working copy</li> </ul>"},{"location":"cli-reference.html#jj-file-annotate","title":"<code>jj file annotate</code>","text":"<p>Show the source change for each line of the target file.</p> <p>Annotates a revision line by line. Each line includes the source change that introduced the associated line. A path to the desired file must be provided.</p> <p>Usage: <code>jj file annotate [OPTIONS] &lt;PATH&gt;</code></p>"},{"location":"cli-reference.html#arguments_22","title":"Arguments:","text":"<ul> <li><code>&lt;PATH&gt;</code> \u2014 the file to annotate</li> </ul>"},{"location":"cli-reference.html#options_22","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 an optional revision to start at</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each line using the given template</p> <p>All 0-argument methods of the [<code>AnnotationLine</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> <p>If not specified, this defaults to the <code>templates.file_annotate</code> setting.</p> </li> </ul>"},{"location":"cli-reference.html#jj-file-chmod","title":"<code>jj file chmod</code>","text":"<p>Sets or removes the executable bit for paths in the repo</p> <p>Unlike the POSIX <code>chmod</code>, <code>jj file chmod</code> also works on Windows, on conflicted files, and on arbitrary revisions.</p> <p>Usage: <code>jj file chmod [OPTIONS] &lt;MODE&gt; &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_23","title":"Arguments:","text":"<ul> <li> <p><code>&lt;MODE&gt;</code></p> <p>Possible values:</p> <ul> <li><code>n</code>:   Make a path non-executable (alias: normal)</li> <li><code>x</code>:   Make a path executable (alias: executable)</li> </ul> </li> <li> <p><code>&lt;FILESETS&gt;</code> \u2014 Paths to change the executable bit for</p> </li> </ul>"},{"location":"cli-reference.html#options_23","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to update</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-file-list","title":"<code>jj file list</code>","text":"<p>List files in a revision</p> <p>Usage: <code>jj file list [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_24","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Only list files matching these prefixes (instead of all files)</li> </ul>"},{"location":"cli-reference.html#options_24","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to list files in</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each file entry using the given template</p> <p>All 0-argument methods of the [<code>TreeEntry</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> </li> </ul>"},{"location":"cli-reference.html#jj-file-search","title":"<code>jj file search</code>","text":"<p>Search for content in files</p> <p>Lists files containing the specified pattern.</p> <p>This is an early version of the command. It only supports glob matching for now, it doesn't search files concurrently, and it doesn't indicate where in the file the match was found.</p> <p>Usage: <code>jj file search [OPTIONS] --pattern &lt;PATTERN&gt; [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_25","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Only search files matching these prefixes (instead of all files)</li> </ul>"},{"location":"cli-reference.html#options_25","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to search files in</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-p</code>, <code>--pattern &lt;PATTERN&gt;</code> \u2014 The glob pattern to search for</p> <p>The whole line must match the pattern, so you may want to pass something like <code>--pattern '*foo*'</code>.</p> </li> </ul>"},{"location":"cli-reference.html#jj-file-show","title":"<code>jj file show</code>","text":"<p>Print contents of files in a revision</p> <p>If the given path is a directory, files in the directory will be visited recursively.</p> <p>Usage: <code>jj file show [OPTIONS] &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_26","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Paths to print</li> </ul>"},{"location":"cli-reference.html#options_26","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to get the file contents from</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each file metadata using the given template</p> <p>All 0-argument methods of the [<code>TreeEntry</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> <p>If not specified, this defaults to the <code>templates.file_show</code> setting.</p> </li> </ul>"},{"location":"cli-reference.html#jj-file-track","title":"<code>jj file track</code>","text":"<p>Start tracking specified paths in the working copy</p> <p>Without arguments, all paths that are not ignored will be tracked.</p> <p>By default, new files in the working copy are automatically tracked, so this command has no effect. You can configure which paths to automatically track by setting <code>snapshot.auto-track</code> (e.g. to <code>\"none()\"</code> or <code>\"glob:**/*.rs\"</code>). Files that don't match the pattern can be manually tracked using this command. The default pattern is <code>all()</code>.</p> <p>Usage: <code>jj file track [OPTIONS] &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_27","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Paths to track</li> </ul>"},{"location":"cli-reference.html#options_27","title":"Options:","text":"<ul> <li> <p><code>--include-ignored</code> \u2014 Track paths even if they're ignored or too large</p> <p>By default, <code>jj file track</code> will not track files that are ignored by .gitignore or exceed the maximum file size. This flag overrides those restrictions, explicitly tracking the specified paths.</p> </li> </ul>"},{"location":"cli-reference.html#jj-file-untrack","title":"<code>jj file untrack</code>","text":"<p>Stop tracking specified paths in the working copy</p> <p>Usage: <code>jj file untrack &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_28","title":"Arguments:","text":"<ul> <li> <p><code>&lt;FILESETS&gt;</code> \u2014 Paths to untrack. They must already be ignored.</p> <p>The paths could be ignored via a .gitignore or .git/info/exclude (in colocated workspaces).</p> </li> </ul>"},{"location":"cli-reference.html#jj-fix","title":"<code>jj fix</code>","text":"<p>Update files with formatting fixes or other changes</p> <p>The primary use case for this command is to apply the results of automatic code formatting tools to revisions that may not be properly formatted yet. It can also be used to modify files with other tools like <code>sed</code> or <code>sort</code>.</p> <p>The modification made by <code>jj fix</code> can be reviewed by <code>jj op show -p</code>.</p>"},{"location":"cli-reference.html#how-it-works","title":"How it works","text":"<p>The changed files in the given revisions will be updated with any fixes determined by passing their file content through any external tools the user has configured for those files. Descendants will also be updated by passing their versions of the same files through the same tools, which will ensure that the fixes are not lost. This will never result in new conflicts. Files with existing conflicts will be updated on all sides of the conflict, which can potentially increase or decrease the number of conflict markers.</p>"},{"location":"cli-reference.html#deduplication","title":"Deduplication","text":"<p>When fixing multiple commits, if the same file content appears at the same path in different commits, the tool is run only once and the result is reused. This means that tools used with <code>jj fix</code> must produce deterministic output.</p>"},{"location":"cli-reference.html#configuration","title":"Configuration","text":"<p>See <code>jj help -k config</code> chapter <code>Code formatting and other file content transformations</code> to understand how to configure your tools.</p>"},{"location":"cli-reference.html#execution-example","title":"Execution Example","text":"<p>Let's consider the following configuration is set. We have two code formatters (<code>clang-format</code> and <code>black</code>), which apply to three different file extensions (<code>.cc</code>, <code>.h</code>, and <code>.py</code>):</p> <pre><code>[fix.tools.clang-format]\ncommand = [\"/usr/bin/clang-format\", \"--assume-filename=$path\"]\npatterns = [\"glob:'**/*.cc'\",\n            \"glob:'**/*.h'\"]\n\n[fix.tools.black]\ncommand = [\"/usr/bin/black\", \"-\", \"--stdin-filename=$path\"]\npatterns = [\"glob:'**/*.py'\"]\n</code></pre> <p>Now, let's see what would happen to the following history, when executing <code>jj fix</code>.</p> <pre><code>C (mutable)\n|  Modifies file: foo.py\n|\nB @ (working copy - mutable)\n|  Modifies file: README.md\n|\nA (mutable)\n|  Modifies files: src/bar.cc and src/bar.h\n|\nX (immutable)\n</code></pre> <p>By default, <code>jj fix</code> will modify revisions that matches the revset <code>reachable(@, mutable())</code> (see <code>jj help -k revsets</code>) which corresponds to the revisions <code>A</code>, <code>B</code> and <code>C</code> here.</p> <p>The following operations will then happen:</p> <ul> <li>For revision <code>A</code>, content from this revision for files <code>src/bar.cc</code> and   <code>src/bar.h</code> will each be provided to <code>clang-format</code> and the result output   will be used to recreate revision <code>A</code> which we will call <code>A'</code>. All other   files are untouched.</li> <li>For revision <code>B</code>, same thing happen for files <code>src/bar.cc</code> and <code>src/bar.h</code>   Their content from revision <code>B</code> will go through <code>clang-format</code>. The file   <code>README.md</code> as any other files, are untouched as no pattern matches it. We   obtain revision <code>B'</code>.</li> <li>For revision <code>C</code>, <code>src/bar.cc</code> and <code>src/bar.h</code> goes through <code>clang-format</code>   and file <code>foo.py</code> is fixed using <code>black</code>. Any other file is untouched. We   obtain revision <code>C'</code>.</li> </ul> <pre><code>C (mutable)                    /-&gt; C'\n|  src/bar.cc -&gt; clang-format -|   |\n|  src/bar.h --&gt; clang-format -|   |\n|  foo.py -----&gt; black --------|   |\n|  * --------------------------/   |\n|                                  |\nB @ (working copy - mutable)   /-&gt; B' @\n|  src/bar.cc -&gt; clang-format -|   |\n|  src/bar.h --&gt; clang-format -|   |\n|  * --------------------------|   |\n|                                  |\nA (mutable)                    /-&gt; A'\n|  src/bar.cc -&gt; clang-format -|   |\n|  src/bar.h --&gt; clang-format -|   |\n|  * --------------------------/   |\n|                                  |\nX (immutable)                      X\n</code></pre> <p>The revisions are now all correctly formatted according to the configuration.</p> <p>Usage: <code>jj fix [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_29","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Fix only these paths</li> </ul>"},{"location":"cli-reference.html#options_28","title":"Options:","text":"<ul> <li><code>-s</code>, <code>--source &lt;REVSETS&gt;</code> \u2014 Fix files in the specified revision(s) and their descendants. If no revisions are specified, this defaults to the <code>revsets.fix</code> setting, or <code>reachable(@, mutable())</code> if it is not set</li> <li><code>--include-unchanged-files</code> \u2014 Fix unchanged files in addition to changed ones. If no paths are specified, all files in the repo will be fixed</li> </ul>"},{"location":"cli-reference.html#jj-gerrit","title":"<code>jj gerrit</code>","text":"<p>Interact with Gerrit Code Review</p> <p>Usage: <code>jj gerrit &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_5","title":"Subcommands:","text":"<ul> <li><code>upload</code> \u2014 Upload changes to Gerrit for code review, or update existing changes</li> </ul>"},{"location":"cli-reference.html#jj-gerrit-upload","title":"<code>jj gerrit upload</code>","text":"<p>Upload changes to Gerrit for code review, or update existing changes.</p> <p>Uploading in a set of revisions to Gerrit creates a single \"change\" for each revision included in the revset. These changes are then available for review on your Gerrit instance.</p> <p>Note: The gerrit commit Id may not match that of your local commit Id, since we add a <code>Change-Id</code> footer to the commit message if one does not already exist. This ID is based off the jj Change-Id, but is not the same.</p> <p>If a change already exists for a given revision (i.e. it contains the same <code>Change-Id</code>), this command will update the contents of the existing change to match.</p> <p>Note: this command takes 1-or-more revsets arguments, each of which can resolve to multiple revisions; so you may post trees or ranges of commits to Gerrit for review all at once.</p> <p>Usage: <code>jj gerrit upload [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_29","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVISIONS&gt;</code> \u2014 The revset, selecting which revisions are sent in to Gerrit</p> <p>This can be any arbitrary set of commits. Note that when you push a commit at the head of a stack, all ancestors are pushed too. This means that <code>jj gerrit upload -r foo</code> is equivalent to <code>jj gerrit upload -r 'mutable()::foo</code>.</p> </li> <li> <p><code>-b</code>, <code>--remote-branch &lt;REMOTE_BRANCH&gt;</code> \u2014 The location where your changes are intended to land</p> <p>This should be a branch on the remote. Can be configured with the <code>gerrit.default-remote-branch</code> repository option.</p> </li> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 The Gerrit remote to push to</p> <p>Can be configured with the <code>gerrit.default-remote</code> repository option as well. This is typically a full SSH URL for your Gerrit instance.</p> </li> <li> <p><code>-n</code>, <code>--dry-run</code> \u2014 Do not actually push the changes to Gerrit</p> </li> </ul>"},{"location":"cli-reference.html#jj-git","title":"<code>jj git</code>","text":"<p>Commands for working with Git remotes and the underlying Git repo</p> <p>See this comparison, including a table of commands.</p> <p>Usage: <code>jj git &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_6","title":"Subcommands:","text":"<ul> <li><code>clone</code> \u2014 Create a new repo backed by a clone of a Git repo</li> <li><code>colocation</code> \u2014 Manage Jujutsu repository colocation with Git</li> <li><code>export</code> \u2014 Update the underlying Git repo with changes made in the repo</li> <li><code>fetch</code> \u2014 Fetch from a Git remote</li> <li><code>import</code> \u2014 Update repo with changes made in the underlying Git repo</li> <li><code>init</code> \u2014 Create a new Git backed repo</li> <li><code>push</code> \u2014 Push to a Git remote</li> <li><code>remote</code> \u2014 Manage Git remotes</li> <li><code>root</code> \u2014 Show the underlying Git directory of a repository using the Git backend</li> </ul>"},{"location":"cli-reference.html#jj-git-clone","title":"<code>jj git clone</code>","text":"<p>Create a new repo backed by a clone of a Git repo</p> <p>Usage: <code>jj git clone [OPTIONS] &lt;SOURCE&gt; [DESTINATION]</code></p>"},{"location":"cli-reference.html#arguments_30","title":"Arguments:","text":"<ul> <li> <p><code>&lt;SOURCE&gt;</code> \u2014 URL or path of the Git repo to clone</p> <p>Local path will be resolved to absolute form.</p> </li> <li> <p><code>&lt;DESTINATION&gt;</code> \u2014 Specifies the target directory for the Jujutsu repository clone. If not provided, defaults to a directory named after the last component of the source URL. The full directory path will be created if it doesn't exist</p> </li> </ul>"},{"location":"cli-reference.html#options_30","title":"Options:","text":"<ul> <li> <p><code>--remote &lt;REMOTE_NAME&gt;</code> \u2014 Name of the newly created remote</p> <p>Default value: <code>origin</code></p> </li> <li> <p><code>--colocate</code> \u2014 Colocate the Jujutsu repo with the git repo</p> <p>Specifies that the <code>jj</code> repo should also be a valid <code>git</code> repo, allowing the use of both <code>jj</code> and <code>git</code> commands in the same directory.</p> <p>The repository will contain a <code>.git</code> dir in the top-level. Regular Git tools will be able to operate on the repo.</p> <p>This is the default, and this option has no effect, unless the git.colocate config is set to <code>false</code>.</p> </li> <li> <p><code>--no-colocate</code> \u2014 Disable colocation of the Jujutsu repo with the git repo</p> <p>Prevent Git tools that are unaware of <code>jj</code> and regular Git commands from operating on the repo. The Git repository that stores most of the repo data will be hidden inside a sub-directory of the <code>.jj</code> directory.</p> <p>See colocation docs for some minor advantages of non-colocated workspaces.</p> </li> <li> <p><code>--depth &lt;DEPTH&gt;</code> \u2014 Create a shallow clone of the given depth</p> </li> <li> <p><code>--fetch-tags &lt;FETCH_TAGS&gt;</code> \u2014 Configure when to fetch tags</p> <p>Unless otherwise specified, the initial clone will fetch all tags, while all subsequent fetches will only fetch included tags.</p> <p>Possible values:</p> <ul> <li><code>all</code>:   Always fetch all tags</li> <li><code>included</code>:   Only fetch tags that point to objects that are already being transmitted</li> <li><code>none</code>:   Do not fetch any tags</li> </ul> </li> <li> <p><code>-b</code>, <code>--branch &lt;BRANCH&gt;</code> \u2014 Name of the branch to fetch and use as the parent of the working-copy change (can be repeated)</p> <p>If not present, all branches are fetched and the repository's default branch is used as parent of the working-copy change.</p> <p>By default, the specified pattern matches branch names with glob syntax, but only <code>*</code> is expanded. Other wildcard characters such as <code>?</code> are not supported. Patterns can be repeated or combined with logical operators to specify multiple branches, but only union and negative intersection are supported. If there are multiple matching branches, the first exact branch name is used as the working-copy parent.</p> <p>Examples: <code>push-*</code>, <code>(push-* | foo/*) ~ foo/unwanted</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-git-colocation","title":"<code>jj git colocation</code>","text":"<p>Manage Jujutsu repository colocation with Git</p> <p>Usage: <code>jj git colocation &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_7","title":"Subcommands:","text":"<ul> <li><code>disable</code> \u2014 Convert into a non-colocated Jujutsu/Git repository</li> <li><code>enable</code> \u2014 Convert into a colocated Jujutsu/Git repository</li> <li><code>status</code> \u2014 Show the current colocation status</li> </ul>"},{"location":"cli-reference.html#jj-git-colocation-disable","title":"<code>jj git colocation disable</code>","text":"<p>Convert into a non-colocated Jujutsu/Git repository</p> <p>This moves the Git repository that is at the root of the Jujutsu workspace into the .jj directory. Once this is done you will no longer be able to use Git commands directly in the Jujutsu workspace.</p> <p>Usage: <code>jj git colocation disable</code></p>"},{"location":"cli-reference.html#jj-git-colocation-enable","title":"<code>jj git colocation enable</code>","text":"<p>Convert into a colocated Jujutsu/Git repository</p> <p>This moves the underlying Git repository that is found inside the .jj directory to the root of the Jujutsu workspace. This allows you to use Git commands directly in the Jujutsu workspace.</p> <p>Usage: <code>jj git colocation enable</code></p>"},{"location":"cli-reference.html#jj-git-colocation-status","title":"<code>jj git colocation status</code>","text":"<p>Show the current colocation status</p> <p>Usage: <code>jj git colocation status</code></p>"},{"location":"cli-reference.html#jj-git-export","title":"<code>jj git export</code>","text":"<p>Update the underlying Git repo with changes made in the repo</p> <p>There is no need to run this command if you're in colocated workspace because the export happens automatically there.</p> <p>Usage: <code>jj git export</code></p>"},{"location":"cli-reference.html#jj-git-fetch","title":"<code>jj git fetch</code>","text":"<p>Fetch from a Git remote</p> <p>If no branches nor tags are specified, the default fetch refspecs are read from the Git configuration.</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>Usage: <code>jj git fetch [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_31","title":"Options:","text":"<ul> <li> <p><code>-b</code>, <code>--branch &lt;BRANCH&gt;</code> \u2014 Name of the branch to fetch (can be repeated)</p> <p>By default, the specified pattern matches branch names with glob syntax, but only <code>*</code> is expanded. Other wildcard characters such as <code>?</code> are not supported. Patterns can be repeated or combined with logical operators to specify multiple branches, but only union and negative intersection are supported.</p> <p>Examples: <code>push-*</code>, <code>(push-* | foo/*) ~ foo/unwanted</code></p> </li> <li> <p><code>--tracked</code> \u2014 Fetch only tracked bookmarks</p> <p>This fetches only bookmarks that are already tracked from the specified remote(s).</p> </li> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 The remote to fetch from (only named remotes are supported, can be repeated)</p> <p>This defaults to the <code>git.fetch</code> setting. If that is not configured, and if there are multiple remotes, the remote named \"origin\" will be used.</p> <p>By default, the specified pattern matches remote names with glob syntax, e.g. <code>--remote '*'</code>. You can also use other string pattern syntax.</p> </li> <li> <p><code>--all-remotes</code> \u2014 Fetch from all remotes</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-import","title":"<code>jj git import</code>","text":"<p>Update repo with changes made in the underlying Git repo</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>There is no need to run this command if you're in colocated workspace because the import happens automatically there.</p> <p>Usage: <code>jj git import</code></p>"},{"location":"cli-reference.html#jj-git-init","title":"<code>jj git init</code>","text":"<p>Create a new Git backed repo</p> <p>Usage: <code>jj git init [OPTIONS] [DESTINATION]</code></p>"},{"location":"cli-reference.html#arguments_31","title":"Arguments:","text":"<ul> <li> <p><code>&lt;DESTINATION&gt;</code> \u2014 The destination directory where the <code>jj</code> repo will be created. If the directory does not exist, it will be created. If no directory is given, the current directory is used.</p> <p>By default the <code>git</code> repo is under <code>$destination/.jj</code></p> <p>Default value: <code>.</code></p> </li> </ul>"},{"location":"cli-reference.html#options_32","title":"Options:","text":"<ul> <li> <p><code>--colocate</code> \u2014 Colocate the Jujutsu repo with the git repo</p> <p>Specifies that the <code>jj</code> repo should also be a valid <code>git</code> repo, allowing the use of both <code>jj</code> and <code>git</code> commands in the same directory.</p> <p>The repository will contain a <code>.git</code> dir in the top-level. Regular Git tools will be able to operate on the repo.</p> <p>This is the default, and this option has no effect, unless the git.colocate config is set to <code>false</code>.</p> <p>This option is mutually exclusive with <code>--git-repo</code>.</p> </li> <li> <p><code>--no-colocate</code> \u2014 Disable colocation of the Jujutsu repo with the git repo</p> <p>Prevent Git tools that are unaware of <code>jj</code> and regular Git commands from operating on the repo. The Git repository that stores most of the repo data will be hidden inside a sub-directory of the <code>.jj</code> directory.</p> <p>See colocation docs for some minor advantages of non-colocated workspaces.</p> </li> <li> <p><code>--git-repo &lt;GIT_REPO&gt;</code> \u2014 Specifies a path to an existing git repository to be used as the backing git repo for the newly created <code>jj</code> repo.</p> <p>If the specified <code>--git-repo</code> path happens to be the same as the <code>jj</code> repo path (both .jj and .git directories are in the same working directory), then both <code>jj</code> and <code>git</code> commands will work on the same repo. This is called a colocated workspace.</p> <p>This option is mutually exclusive with <code>--colocate</code>, and so if passed, turns colocation off.</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-push","title":"<code>jj git push</code>","text":"<p>Push to a Git remote</p> <p>By default, pushes tracking bookmarks pointing to <code>remote_bookmarks(remote=&lt;remote&gt;)..@</code>. Use <code>--bookmark</code> to push specific bookmarks. Use <code>--all</code> to push all bookmarks. Use <code>--change</code> to generate bookmark names based on the change IDs of specific commits.</p> <p>When pushing a bookmark, the command pushes all commits in the range from the remote's current position up to and including the bookmark's target commit. Any descendant commits beyond the bookmark are not pushed.</p> <p>If the local bookmark has changed from the last fetch, push will update the remote bookmark to the new position after passing safety checks. This is similar to <code>git push --force-with-lease</code> - the remote is updated only if its current state matches what Jujutsu last fetched.</p> <p>Unlike in Git, the remote to push to is not derived from the tracked remote bookmarks. Use <code>--remote</code> to select the remote Git repository by name. There is no option to push to multiple remotes.</p> <p>Before the command actually moves, creates, or deletes a remote bookmark, it makes several safety checks. If there is a problem, you may need to run <code>jj git fetch --remote &lt;remote name&gt;</code> and/or resolve some bookmark conflicts.</p> <p>Usage: <code>jj git push [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_33","title":"Options:","text":"<ul> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 The remote to push to (only named remotes are supported)</p> <p>This defaults to the <code>git.push</code> setting. If that is not configured, and if there are multiple remotes, the remote named \"origin\" will be used.</p> </li> <li> <p><code>-b</code>, <code>--bookmark &lt;BOOKMARK&gt;</code> \u2014 Push only this bookmark, or bookmarks matching a pattern (can be repeated)</p> <p>If a bookmark isn't tracking anything yet, the remote bookmark will be tracked automatically.</p> <p>By default, the specified pattern matches bookmark names with glob syntax. You can also use other string pattern syntax.</p> </li> <li> <p><code>--all</code> \u2014 Push all bookmarks (including new bookmarks)</p> </li> <li> <p><code>--tracked</code> \u2014 Push all tracked bookmarks</p> <p>This usually means that the bookmark was already pushed to or fetched from the relevant remote.</p> </li> <li> <p><code>--deleted</code> \u2014 Push all deleted bookmarks</p> <p>Only tracked bookmarks can be successfully deleted on the remote. A warning will be printed if any untracked bookmarks on the remote correspond to missing local bookmarks.</p> </li> <li> <p><code>--allow-empty-description</code> \u2014 Allow pushing commits with empty descriptions</p> </li> <li> <p><code>--allow-private</code> \u2014 Allow pushing commits that are private</p> <p>The set of private commits can be configured by the <code>git.private-commits</code> setting. The default is <code>none()</code>, meaning all commits are eligible to be pushed.</p> </li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Push bookmarks pointing to these commits (can be repeated)</p> </li> <li> <p><code>-c</code>, <code>--change &lt;REVSETS&gt;</code> \u2014 Push this commit by creating a bookmark (can be repeated)</p> <p>The created bookmark will be tracked automatically. Use the <code>templates.git_push_bookmark</code> setting to customize the generated bookmark name. The default is <code>\"push-\" ++ change_id.short()</code>.</p> </li> <li> <p><code>--named &lt;NAME=REVISION&gt;</code> \u2014 Specify a new bookmark name and a revision to push under that name, e.g. '--named myfeature=@'</p> <p>Automatically tracks the bookmark if it is new.</p> </li> <li> <p><code>--dry-run</code> \u2014 Only display what will change on the remote</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-remote","title":"<code>jj git remote</code>","text":"<p>Manage Git remotes</p> <p>The Git repo will be a bare git repo stored inside the <code>.jj/</code> directory.</p> <p>Usage: <code>jj git remote &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_8","title":"Subcommands:","text":"<ul> <li><code>add</code> \u2014 Add a Git remote</li> <li><code>list</code> \u2014 List Git remotes</li> <li><code>remove</code> \u2014 Remove a Git remote and forget its bookmarks</li> <li><code>rename</code> \u2014 Rename a Git remote</li> <li><code>set-url</code> \u2014 Set the URL of a Git remote</li> </ul>"},{"location":"cli-reference.html#jj-git-remote-add","title":"<code>jj git remote add</code>","text":"<p>Add a Git remote</p> <p>Usage: <code>jj git remote add [OPTIONS] &lt;REMOTE&gt; &lt;URL&gt;</code></p>"},{"location":"cli-reference.html#arguments_32","title":"Arguments:","text":"<ul> <li><code>&lt;REMOTE&gt;</code> \u2014 The remote's name</li> <li> <p><code>&lt;URL&gt;</code> \u2014 The remote's URL or path</p> <p>Local path will be resolved to absolute form.</p> </li> </ul>"},{"location":"cli-reference.html#options_34","title":"Options:","text":"<ul> <li> <p><code>--fetch-tags &lt;FETCH_TAGS&gt;</code> \u2014 Configure when to fetch tags</p> <p>Default value: <code>included</code></p> <p>Possible values:</p> <ul> <li><code>all</code>:   Always fetch all tags</li> <li><code>included</code>:   Only fetch tags that point to objects that are already being transmitted</li> <li><code>none</code>:   Do not fetch any tags</li> </ul> </li> <li> <p><code>--push-url &lt;PUSH_URL&gt;</code> \u2014 The URL used for push</p> <p>Local path will be resolved to absolute form</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-remote-list","title":"<code>jj git remote list</code>","text":"<p>List Git remotes</p> <p>Usage: <code>jj git remote list</code></p>"},{"location":"cli-reference.html#jj-git-remote-remove","title":"<code>jj git remote remove</code>","text":"<p>Remove a Git remote and forget its bookmarks</p> <p>Usage: <code>jj git remote remove &lt;REMOTE&gt;</code></p>"},{"location":"cli-reference.html#arguments_33","title":"Arguments:","text":"<ul> <li><code>&lt;REMOTE&gt;</code> \u2014 The remote's name</li> </ul>"},{"location":"cli-reference.html#jj-git-remote-rename","title":"<code>jj git remote rename</code>","text":"<p>Rename a Git remote</p> <p>Usage: <code>jj git remote rename &lt;OLD&gt; &lt;NEW&gt;</code></p>"},{"location":"cli-reference.html#arguments_34","title":"Arguments:","text":"<ul> <li><code>&lt;OLD&gt;</code> \u2014 The name of an existing remote</li> <li><code>&lt;NEW&gt;</code> \u2014 The desired name for <code>old</code></li> </ul>"},{"location":"cli-reference.html#jj-git-remote-set-url","title":"<code>jj git remote set-url</code>","text":"<p>Set the URL of a Git remote</p> <p>Usage: <code>jj git remote set-url [OPTIONS] &lt;REMOTE&gt; [URL]</code></p>"},{"location":"cli-reference.html#arguments_35","title":"Arguments:","text":"<ul> <li><code>&lt;REMOTE&gt;</code> \u2014 The remote's name</li> <li> <p><code>&lt;URL&gt;</code> \u2014 The URL or path to fetch from</p> <p>This is a short form, equivalent to using the explicit --fetch.</p> <p>Local path will be resolved to absolute form.</p> </li> </ul>"},{"location":"cli-reference.html#options_35","title":"Options:","text":"<ul> <li> <p><code>--push &lt;PUSH&gt;</code> \u2014 The URL or path to push to</p> <p>Local path will be resolved to absolute form.</p> </li> <li> <p><code>--fetch &lt;FETCH&gt;</code> \u2014 The URL or path to fetch from</p> <p>Local path will be resolved to absolute form.</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-root","title":"<code>jj git root</code>","text":"<p>Show the underlying Git directory of a repository using the Git backend</p> <p>Usage: <code>jj git root</code></p>"},{"location":"cli-reference.html#jj-help","title":"<code>jj help</code>","text":"<p>Print this message or the help of the given subcommand(s)</p> <p>Usage: <code>jj help [OPTIONS] [COMMAND]...</code></p>"},{"location":"cli-reference.html#arguments_36","title":"Arguments:","text":"<ul> <li><code>&lt;COMMAND&gt;</code> \u2014 Print help for the subcommand(s)</li> </ul>"},{"location":"cli-reference.html#options_36","title":"Options:","text":"<ul> <li> <p><code>-k</code>, <code>--keyword &lt;KEYWORD&gt;</code> \u2014 Show help for keywords instead of commands</p> <p>Possible values:</p> <ul> <li><code>bookmarks</code>:   Named pointers to revisions (similar to Git's branches)</li> <li><code>config</code>:   How and where to set configuration options</li> <li><code>filesets</code>:   A functional language for selecting a set of files</li> <li><code>glossary</code>:   Definitions of various terms</li> <li><code>revsets</code>:   A functional language for selecting a set of revision</li> <li><code>templates</code>:   A functional language to customize command output</li> <li><code>tutorial</code>:   Show a tutorial to get started with jj</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-interdiff","title":"<code>jj interdiff</code>","text":"<p>Show differences between the diffs of two revisions</p> <p>This is like running <code>jj diff -r</code> on each change, then comparing those results. It answers: \"How do the modifications introduced by revision A differ from the modifications introduced by revision B?\"</p> <p>For example, if two changes both add a feature but implement it differently, <code>jj interdiff --from @- --to other</code> shows what one implementation adds or removes that the other doesn't.</p> <p>A common use of this command is to compare how a change has changed since the last push to a remote:</p> <p><code>sh $ jj interdiff --from push-xyz@origin --to push-xyz</code></p> <p>This command is different from <code>jj diff --from A --to B</code>, which compares file contents directly. <code>interdiff</code> compares what the changes do in terms of their patches, rather than their file contents. This makes a difference when the two revisions have different parents: <code>jj diff --from A --to B</code> will include the changes between their parents while <code>jj interdiff --from A --to B</code> will not.</p> <p>Technically, this works by rebasing <code>--from</code> onto <code>--to</code>'s parents and comparing the result to <code>--to</code>.</p> <p>To see the changes throughout the whole evolution of a change instead of between just two revisions, use <code>jj evolog -p instead</code>.</p> <p>Usage: <code>jj interdiff [OPTIONS] &lt;--from &lt;REVSET&gt;|--to &lt;REVSET&gt;&gt; [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_37","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restrict the diff to these paths</li> </ul>"},{"location":"cli-reference.html#options_37","title":"Options:","text":"<ul> <li><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 The first revision to compare (default: @)</li> <li><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 The second revision to compare (default: @)</li> <li><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>-w</code>, <code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>-b</code>, <code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-log","title":"<code>jj log</code>","text":"<p>Show revision history</p> <p>Renders a graphical view of the project's history, ordered with children before parents. By default, the output only includes mutable revisions, along with some additional revisions for context. Use <code>jj log -r ::</code> to see all revisions. See [<code>jj help -k revsets</code>] for information about the syntax.</p> <p>Spans of revisions that are not included in the graph per <code>--revisions</code> are rendered as a synthetic node labeled \"(elided revisions)\".</p> <p>The working-copy commit is indicated by a <code>@</code> symbol in the graph. Immutable revisions have a <code>\u25c6</code> symbol. Other commits have a <code>\u25cb</code> symbol. All of these symbols can be customized.</p> <p>Usage: <code>jj log [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_38","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Show revisions modifying the given paths</li> </ul>"},{"location":"cli-reference.html#options_38","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Which revisions to show</p> <p>If no paths nor revisions are specified, this defaults to the <code>revsets.log</code> setting.</p> </li> <li> <p><code>-n</code>, <code>--limit &lt;LIMIT&gt;</code> \u2014 Limit number of revisions to show</p> <p>Applied after revisions are filtered and reordered topologically, but before being reversed.</p> </li> <li> <p><code>--reversed</code> \u2014 Show revisions in the opposite order (older revisions first)</p> </li> <li><code>-G</code>, <code>--no-graph</code> \u2014 Don't show the graph, show a flat list of revisions</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each revision using the given template</p> <p>Run <code>jj log -T</code> to list the built-in templates.</p> <p>You can also specify arbitrary template expressions using the built-in keywords. See [<code>jj help -k templates</code>] for more information.</p> <p>If not specified, this defaults to the <code>templates.log</code> setting.</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch</p> </li> <li><code>--count</code> \u2014 Print the number of commits instead of showing them</li> <li><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-metaedit","title":"<code>jj metaedit</code>","text":"<p>Modify the metadata of a revision without changing its content</p> <p>Whenever any metadata is updated, the committer name, email, and timestamp are also updated for all rebased commits. The name and email may come from the <code>JJ_USER</code> and <code>JJ_EMAIL</code> environment variables, as well as by passing <code>--config user.name</code> and <code>--config user.email</code>.</p> <p>Usage: <code>jj metaedit [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_39","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) to modify (default: @) [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#options_39","title":"Options:","text":"<ul> <li> <p><code>--update-change-id</code> \u2014 Generate a new change-id</p> <p>This generates a new change-id for the revision.</p> </li> <li> <p><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 Update the change description</p> <p>This updates the change description, without opening the editor.</p> <p>Use <code>jj describe</code> if you want to use an editor.</p> </li> <li> <p><code>--update-author-timestamp</code> \u2014 Update the author timestamp</p> <p>This updates the author date to the current time, without modifying the author.</p> </li> <li> <p><code>--update-author</code> \u2014 Update the author to the configured user</p> <p>This updates the author name and email. The author timestamp is not modified \u2013 use --update-author-timestamp to update the author timestamp.</p> <p>You can use it in combination with the JJ_USER and JJ_EMAIL environment variables to set a different author:</p> <p>$ JJ_USER='Foo Bar' JJ_EMAIL=foo@bar.com jj metaedit --update-author</p> </li> <li> <p><code>--author &lt;AUTHOR&gt;</code> \u2014 Set author to the provided string</p> <p>This changes author name and email while retaining author timestamp for non-discardable commits.</p> <p><code>shell $ jj metaedit --author \"Foo Bar &lt;foo@bar.com&gt;\"</code></p> </li> <li> <p><code>--author-timestamp &lt;AUTHOR_TIMESTAMP&gt;</code> \u2014 Set the author date to the given date</p> <p>The date can either be human readable (RFC2822, eg 'Sun, 23 Jan 2000 01:23:45 PST') or a time stamp (RFC3339, eg '2000-01-23T01:23:45-08:00').</p> </li> <li> <p><code>--force-rewrite</code> \u2014 Rewrite the commit, even if no other metadata changed</p> <p>This updates the committer timestamp to the current time, as well as the committer name and email.</p> <p>Even if this option is not passed, the committer name, email, and timestamp will be updated if other metadata is updated. This option just forces every commit to be rewritten whether or not there are other changes.</p> <p>You can use it in combination with the <code>JJ_USER</code> and <code>JJ_EMAIL</code> environment variables to set a different committer:</p> <p>$ JJ_USER='Foo Bar' JJ_EMAIL=foo@bar.com jj metaedit --force-rewrite</p> </li> </ul>"},{"location":"cli-reference.html#jj-new","title":"<code>jj new</code>","text":"<p>Create a new, empty change and (by default) edit it in the working copy</p> <p>By default, <code>jj</code> will edit the new change, making the working copy represent the new commit. This can be avoided with <code>--no-edit</code>.</p> <p>Note that you can create a merge commit by specifying multiple revisions as argument. For example, <code>jj new @ main</code> will create a new commit with the working copy and the <code>main</code> bookmark as parents.</p> <p>Usage: <code>jj new [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_40","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 Parent(s) of the new change [default: @] [aliases: -o, -r]</li> </ul>"},{"location":"cli-reference.html#options_40","title":"Options:","text":"<ul> <li><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use</li> <li><code>--no-edit</code> \u2014 Do not edit the newly created change</li> <li> <p><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> [alias: <code>after</code>] \u2014 Insert the new change after the given commit(s)</p> <p>Example: <code>jj new --insert-after A</code> creates a new change between <code>A</code> and  its children:</p> <pre><code>                B   C\n                 \\ /\n    B   C   =&gt;    @\n     \\ /          |\n      A           A\n</code></pre> <p>Specifying <code>--insert-after</code> multiple times will relocate all children of  the given commits.</p> <p>Example: <code>jj new --insert-after A --insert-after X</code> creates a change  with <code>A</code> and <code>X</code> as parents, and rebases all children on top of the new  change:</p> <pre><code>                B   Y\n                 \\ /\n    B  Y    =&gt;    @\n    |  |         / \\\n    A  X        A   X\n</code></pre> </li> <li> <p><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> [alias: <code>before</code>] \u2014 Insert the new change before the given commit(s)</p> <p>Example: <code>jj new --insert-before C</code> creates a new change between <code>C</code> and  its parents:</p> <pre><code>                   C\n                   |\n      C     =&gt;     @\n     / \\          / \\\n    A   B        A   B\n</code></pre> <p><code>--insert-after</code> and <code>--insert-before</code> can be combined.</p> <p>Example: <code>jj new --insert-after A --insert-before D</code>:</p> <pre><code>    D            D\n    |           / \\\n    C          |   C\n    |    =&gt;    @   |\n    B          |   B\n    |           \\ /\n    A            A\n</code></pre> <p>Similar to <code>--insert-after</code>, you can specify <code>--insert-before</code> multiple  times.</p> </li> </ul>"},{"location":"cli-reference.html#jj-next","title":"<code>jj next</code>","text":"<p>Move the working-copy commit to the child revision</p> <p>The command creates a new empty working copy revision that is the child of a descendant <code>offset</code> revisions ahead of the parent of the current working copy.</p> <p>For example, when the offset is 1:</p> <pre><code>D        D @\n|        |/\nC @  =&gt;  C\n|/       |\nB        B\n</code></pre> <p>If <code>--edit</code> is passed, the working copy revision is changed to the child of the current working copy revision.</p> <pre><code>D        D\n|        |\nC        C\n|        |\nB   =&gt;   @\n|        |\n@        A\n</code></pre> <p>Usage: <code>jj next [OPTIONS] [OFFSET]</code></p>"},{"location":"cli-reference.html#arguments_41","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OFFSET&gt;</code> \u2014 How many revisions to move forward. Advances to the next child by default</p> <p>Default value: <code>1</code></p> </li> </ul>"},{"location":"cli-reference.html#options_41","title":"Options:","text":"<ul> <li> <p><code>-e</code>, <code>--edit</code> \u2014 Instead of creating a new working-copy commit on top of the target commit (like <code>jj new</code>), edit the target commit directly (like <code>jj edit</code>)</p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = false</code></p> </li> <li> <p><code>-n</code>, <code>--no-edit</code> \u2014 The inverse of <code>--edit</code></p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = true</code></p> </li> <li> <p><code>--conflict</code> \u2014 Jump to the next conflicted descendant</p> </li> </ul>"},{"location":"cli-reference.html#jj-operation","title":"<code>jj operation</code>","text":"<p>Commands for working with the operation log</p> <p>See the operation log documentation for more information.</p> <p>Usage: <code>jj operation &lt;COMMAND&gt;</code></p> <p>Command Alias: <code>op</code></p>"},{"location":"cli-reference.html#subcommands_9","title":"Subcommands:","text":"<ul> <li><code>abandon</code> \u2014 Abandon operation history</li> <li><code>diff</code> \u2014 Compare changes to the repository between two operations</li> <li><code>integrate</code> \u2014 Make an operation part of the operation log</li> <li><code>log</code> \u2014 Show the operation log</li> <li><code>restore</code> \u2014 Create a new operation that restores the repo to an earlier state</li> <li><code>revert</code> \u2014 Create a new operation that reverts an earlier operation</li> <li><code>show</code> \u2014 Show changes to the repository in an operation</li> </ul>"},{"location":"cli-reference.html#jj-operation-abandon","title":"<code>jj operation abandon</code>","text":"<p>Abandon operation history</p> <p>To discard old operation history, use <code>jj op abandon ..&lt;operation ID&gt;</code>. It will abandon the specified operation and all its ancestors. The descendants will be reparented onto the root operation.</p> <p>To discard recent operations, use <code>jj op restore &lt;operation ID&gt;</code> followed by <code>jj op abandon &lt;operation ID&gt;..@-</code>.</p> <p>Previous versions of a change (or predecessors) are also discarded if they become unreachable from the operation history. The abandoned operations, commits, and other unreachable objects can later be garbage collected by using <code>jj util gc</code> command.</p> <p>Usage: <code>jj operation abandon &lt;OPERATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_42","title":"Arguments:","text":"<ul> <li><code>&lt;OPERATION&gt;</code> \u2014 The operation or operation range to abandon</li> </ul>"},{"location":"cli-reference.html#jj-operation-diff","title":"<code>jj operation diff</code>","text":"<p>Compare changes to the repository between two operations</p> <p>Usage: <code>jj operation diff [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_42","title":"Options:","text":"<ul> <li><code>--operation &lt;OPERATION&gt;</code> [alias: <code>op</code>] \u2014 Show repository changes in this operation, compared to its parent</li> <li><code>-f</code>, <code>--from &lt;FROM&gt;</code> \u2014 Show repository changes from this operation</li> <li><code>-t</code>, <code>--to &lt;TO&gt;</code> \u2014 Show repository changes to this operation</li> <li><code>-G</code>, <code>--no-graph</code> \u2014 Don't show the graph, show a flat list of modified changes</li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch of modifications to changes</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-operation-integrate","title":"<code>jj operation integrate</code>","text":"<p>Make an operation part of the operation log</p> <p>Sometimes an operation does not make it into the operation log for some reason. This command can then be used for making that operation part of the operation log.</p> <p>Running this command on an operation that is already in the operation log (<code>jj op log</code>) has no effect. Since operations should currently always be integrated into the operation log (until e.g. #2562 gets implemented), this command should always be a no-op. It would indicate a bug if this command is not a no-op. Only use it if you are told to by an error message.</p> <p>Usage: <code>jj operation integrate &lt;OPERATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_43","title":"Arguments:","text":"<ul> <li><code>&lt;OPERATION&gt;</code> \u2014 The operation to integrate</li> </ul>"},{"location":"cli-reference.html#jj-operation-log","title":"<code>jj operation log</code>","text":"<p>Show the operation log</p> <p>Like other commands, <code>jj op log</code> snapshots the current working-copy changes and reconciles divergent operations. Use <code>--at-op=@ --ignore-working-copy</code> to inspect the current state without mutation.</p> <p>Usage: <code>jj operation log [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_43","title":"Options:","text":"<ul> <li> <p><code>-n</code>, <code>--limit &lt;LIMIT&gt;</code> \u2014 Limit number of operations to show</p> <p>Applied after operations are reordered topologically, but before being reversed.</p> </li> <li> <p><code>--reversed</code> \u2014 Show operations in the opposite order (older operations first)</p> </li> <li><code>-G</code>, <code>--no-graph</code> \u2014 Don't show the graph, show a flat list of operations</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each operation using the given template</p> <p>You can specify arbitrary template expressions using the built-in keywords. See [<code>jj help -k templates</code>] for more information.</p> </li> <li> <p><code>-d</code>, <code>--op-diff</code> \u2014 Show changes to the repository at each operation</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch of modifications to changes (implies --op-diff)</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-operation-restore","title":"<code>jj operation restore</code>","text":"<p>Create a new operation that restores the repo to an earlier state</p> <p>This restores the repo to the state at the specified operation, effectively undoing all later operations. It does so by creating a new operation.</p> <p>Usage: <code>jj operation restore [OPTIONS] &lt;OPERATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_44","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 The operation to restore to</p> <p>Use <code>jj op log</code> to find an operation to restore to. Use e.g. <code>jj --at-op=&lt;operation ID&gt; log</code> before restoring to an operation to see the state of the repo at that operation.</p> </li> </ul>"},{"location":"cli-reference.html#options_44","title":"Options:","text":"<ul> <li> <p><code>--what &lt;WHAT&gt;</code> \u2014 What portions of the local state to restore (can be repeated)</p> <p>This option is EXPERIMENTAL.</p> <p>Default values: <code>repo</code>, <code>remote-tracking</code></p> <p>Possible values:</p> <ul> <li><code>repo</code>:   The jj repo state and local bookmarks</li> <li><code>remote-tracking</code>:   The remote-tracking bookmarks. Do not restore these if you'd like to push after the undo</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-operation-revert","title":"<code>jj operation revert</code>","text":"<p>Create a new operation that reverts an earlier operation</p> <p>This reverts an individual operation by applying the inverse of the operation.</p> <p>Usage: <code>jj operation revert [OPTIONS] [OPERATION]</code></p>"},{"location":"cli-reference.html#arguments_45","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 The operation to revert</p> <p>Use <code>jj op log</code> to find an operation to revert.</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_45","title":"Options:","text":"<ul> <li> <p><code>--what &lt;WHAT&gt;</code> \u2014 What portions of the local state to restore (can be repeated)</p> <p>This option is EXPERIMENTAL.</p> <p>Default values: <code>repo</code>, <code>remote-tracking</code></p> <p>Possible values:</p> <ul> <li><code>repo</code>:   The jj repo state and local bookmarks</li> <li><code>remote-tracking</code>:   The remote-tracking bookmarks. Do not restore these if you'd like to push after the undo</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-operation-show","title":"<code>jj operation show</code>","text":"<p>Show changes to the repository in an operation</p> <p>Usage: <code>jj operation show [OPTIONS] [OPERATION]</code></p>"},{"location":"cli-reference.html#arguments_46","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 Show repository changes in this operation, compared to its parent(s)</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_46","title":"Options:","text":"<ul> <li><code>-G</code>, <code>--no-graph</code> \u2014 Don't show the graph, show a flat list of modified changes</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render the operation using the given template</p> <p>You can specify arbitrary template expressions using the built-in keywords. See [<code>jj help -k templates</code>] for more information.</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch of modifications to changes</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>--no-op-diff</code> \u2014 Do not show operation diff</p> </li> <li><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-parallelize","title":"<code>jj parallelize</code>","text":"<p>Parallelize revisions by making them siblings</p> <p>Running <code>jj parallelize 1::2</code> will transform the history like this: <pre><code>3\n|             3\n2            / \\\n|    -&gt;     1   2\n1            \\ /\n|             0\n0\n</code></pre></p> <p>The command effectively says \"these revisions are actually independent\", meaning that they should no longer be ancestors/descendants of each other. However, revisions outside the set that were previously ancestors of a revision in the set will remain ancestors of it. For example, revision 0 above remains an ancestor of both 1 and 2. Similarly, revisions outside the set that were previously descendants of a revision in the set will remain descendants of it. For example, revision 3 above remains a descendant of both 1 and 2.</p> <p>Therefore, <code>jj parallelize '1 | 3'</code> is a no-op. That's because 2, which is not in the target set, was a descendant of 1 before, so it remains a descendant, and it was an ancestor of 3 before, so it remains an ancestor.</p> <p>Usage: <code>jj parallelize [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_47","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revisions to parallelize [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#jj-prev","title":"<code>jj prev</code>","text":"<p>Change the working copy revision relative to the parent revision</p> <p>The command creates a new empty working copy revision that is the child of an ancestor <code>offset</code> revisions behind the parent of the current working copy.</p> <p>For example, when the offset is 1:</p> <pre><code>D @      D\n|/       |\nA   =&gt;   A @\n|        |/\nB        B\n</code></pre> <p>If <code>--edit</code> is passed, the working copy revision is changed to the parent of the current working copy revision.</p> <pre><code>D @      D\n|/       |\nC   =&gt;   @\n|        |\nB        B\n|        |\nA        A\n</code></pre> <p>Usage: <code>jj prev [OPTIONS] [OFFSET]</code></p>"},{"location":"cli-reference.html#arguments_48","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OFFSET&gt;</code> \u2014 How many revisions to move backward. Moves to the parent by default</p> <p>Default value: <code>1</code></p> </li> </ul>"},{"location":"cli-reference.html#options_47","title":"Options:","text":"<ul> <li> <p><code>-e</code>, <code>--edit</code> \u2014 Edit the parent directly, instead of moving the working-copy commit</p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = false</code></p> </li> <li> <p><code>-n</code>, <code>--no-edit</code> \u2014 The inverse of <code>--edit</code></p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = true</code></p> </li> <li> <p><code>--conflict</code> \u2014 Jump to the previous conflicted ancestor</p> </li> </ul>"},{"location":"cli-reference.html#jj-rebase","title":"<code>jj rebase</code>","text":"<p>Move revisions to different parent(s)</p> <p>This command moves revisions to different parent(s) while preserving the changes (diff) in the revisions.</p> <p>There are three different ways of specifying which revisions to rebase:</p> <ul> <li><code>--source/-s</code> to rebase a revision and its descendants</li> <li><code>--branch/-b</code> to rebase a whole branch, relative to the destination</li> <li><code>--revisions/-r</code> to rebase the specified revisions without their   descendants</li> </ul> <p>If no option is specified, it defaults to <code>-b @</code>.</p> <p>There are three different ways of specifying where the revisions should be rebased to:</p> <ul> <li><code>--onto/-o</code> to rebase the revisions onto the specified targets</li> <li><code>--insert-after/-A</code> to rebase the revisions onto the specified targets and   to rebase the targets' descendants onto the rebased revisions</li> <li><code>--insert-before/-B</code> to rebase the revisions onto the specified targets'   parents and to rebase the targets and their descendants onto the rebased   revisions</li> </ul> <p>See the sections below for details about the different ways of specifying which revisions to rebase where.</p> <p>If a working-copy revision gets abandoned, it will be given a new, empty revision. This is true in general; it is not specific to this command.</p>"},{"location":"cli-reference.html#specifying-which-revisions-to-rebase","title":"Specifying which revisions to rebase","text":"<p>With <code>--source/-s</code>, the command rebases the specified revision and its descendants to the destination. For example, <code>jj rebase -s M -o O</code> would transform your history like this (letters followed by an apostrophe are post-rebase versions):</p> <pre><code>O           N'\n|           |\n| N         M'\n| |         |\n| M         O\n| |    =&gt;   |\n| | L       | L\n| |/        | |\n| K         | K\n|/          |/\nJ           J\n</code></pre> <p>Each revision passed to <code>-s</code> will become a direct child of the destination, so if you instead run <code>jj rebase -s M -s N -o O</code> (or <code>jj rebase -s 'M|N' -o O</code>) in the example above, then N' would instead be a direct child of O.</p> <p>With <code>--branch/-b</code>, the command rebases the whole \"branch\" containing the specified revision. A \"branch\" is the set of revisions that includes:</p> <ul> <li>the specified revision and ancestors that are not also ancestors of the   destination</li> <li>all descendants of those revisions</li> </ul> <p>In other words, <code>jj rebase -b X -o Y</code> rebases revisions in the revset <code>(Y..X)::</code> (which is equivalent to <code>jj rebase -s 'roots(Y..X)' -o Y</code> for a single root). For example, either <code>jj rebase -b L -o O</code> or <code>jj rebase -b M -o O</code> would transform your history like this (because <code>L</code> and <code>M</code> are on the same \"branch\", relative to the destination):</p> <pre><code>O           N'\n|           |\n| N         M'\n| |         |\n| M         | L'\n| |    =&gt;   |/\n| | L       K'\n| |/        |\n| K         O\n|/          |\nJ           J\n</code></pre> <p>With <code>--revisions/-r</code>, the command rebases only the specified revisions to the destination. Any \"hole\" left behind will be filled by rebasing descendants onto the specified revisions' parent(s). For example, <code>jj rebase -r K -o M</code> would transform your history like this:</p> <pre><code>M          K'\n|          |\n| L        M\n| |   =&gt;   |\n| K        | L'\n|/         |/\nJ          J\n</code></pre> <p>Multiple revisions can be specified, and any dependencies (graph edges) within the set will be preserved. For example, <code>jj rebase -r 'K|N' -o O</code> would transform your history like this:</p> <pre><code>O           N'\n|           |\n| N         K'\n| |         |\n| M         O\n| |    =&gt;   |\n| | L       | M'\n| |/        |/\n| K         | L'\n|/          |/\nJ           J\n</code></pre> <p><code>jj rebase -s X</code> is similar to <code>jj rebase -r X::</code> and will behave the same if X is a single revision. However, if X is a set of multiple revisions, or if you passed multiple <code>-s</code> arguments, then <code>jj rebase -s</code> will make each of the specified revisions an immediate child of the destination, while <code>jj rebase -r</code> will preserve dependencies within the set.</p> <p>Note that you can create a merge revision by repeating the <code>-o</code> argument. For example, if you realize that revision L actually depends on revision M in order to work (in addition to its current parent K), you can run <code>jj rebase -s L -o K -o M</code>:</p> <pre><code>M          L'\n|          |\\\n| L        M |\n| |   =&gt;   | |\n| K        | K\n|/         |/\nJ          J\n</code></pre>"},{"location":"cli-reference.html#specifying-where-to-rebase-the-revisions","title":"Specifying where to rebase the revisions","text":"<p>With <code>--onto/-o</code>, the command rebases the selected revisions onto the targets. Existing descendants of the targets will not be affected. See the section above for examples.</p> <p>With <code>--insert-after/-A</code>, the selected revisions will be inserted after the targets. This is similar to <code>-o</code>, but if the targets have any existing descendants, then those will be rebased onto the rebased selected revisions.</p> <p>For example, <code>jj rebase -r K -A L</code> will rewrite history like this: <pre><code>N           N'\n|           |\n| M         | M'\n|/          |/\nL      =&gt;   K'\n|           |\n| K         L\n|/          |\nJ           J\n</code></pre></p> <p>The <code>-A</code> (and <code>-B</code>) argument can also be used for reordering revisions. For example, <code>jj rebase -r M -A J</code> will rewrite history like this: <pre><code>M          L'\n|          |\nL          K'\n|     =&gt;   |\nK          M'\n|          |\nJ          J\n</code></pre></p> <p>With <code>--insert-before/-B</code>, the selected revisions will be inserted before the targets. This is achieved by rebasing the selected revisions onto the target revisions' parents, and then rebasing the target revisions and their descendants onto the rebased revisions.</p> <p>For example, <code>jj rebase -r K -B L</code> will rewrite history like this: <pre><code>N           N'\n|           |\n| M         | M'\n|/          |/\nL     =&gt;    L'\n|           |\n| K         K'\n|/          |\nJ           J\n</code></pre></p> <p>The <code>-A</code> and <code>-B</code> arguments can also be combined, which can be useful around merges. For example, you can use <code>jj rebase -r K -A J -B M</code> to create a new merge (but <code>jj rebase -r M -o L -o K</code> might be simpler in this particular case): <pre><code>M           M'\n|           |\\\nL           L |\n|     =&gt;    | |\n| K         | K'\n|/          |/\nJ           J\n</code></pre></p> <p>To insert a commit inside an existing merge with <code>jj rebase -r O -A K -B M</code>: <pre><code>O           N'\n|           |\\\nN           | M'\n|\\          | |\\\n| M         | O'|\n| |    =&gt;   |/ /\n| L         | L\n| |         | |\nK |         K |\n|/          |/\nJ           J\n</code></pre></p> <p>Usage: <code>jj rebase [OPTIONS] &lt;--onto &lt;REVSETS&gt;|--insert-after &lt;REVSETS&gt;|--insert-before &lt;REVSETS&gt;&gt;</code></p>"},{"location":"cli-reference.html#options_48","title":"Options:","text":"<ul> <li> <p><code>-b</code>, <code>--branch &lt;REVSETS&gt;</code> \u2014 Rebase the whole branch relative to destination's ancestors (can be repeated)</p> <p><code>jj rebase -b=br -o=dst</code> is equivalent to <code>jj rebase '-s=roots(dst..br)' -o=dst</code>.</p> <p>If none of <code>-b</code>, <code>-s</code>, or <code>-r</code> is provided, then the default is <code>-b @</code>.</p> </li> <li> <p><code>-s</code>, <code>--source &lt;REVSETS&gt;</code> \u2014 Rebase specified revision(s) together with their trees of descendants (can be repeated)</p> <p>Each specified revision will become a direct child of the destination revision(s), even if some of the source revisions are descendants of others.</p> <p>If none of <code>-b</code>, <code>-s</code>, or <code>-r</code> is provided, then the default is <code>-b @</code>.</p> </li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Rebase the given revisions, rebasing descendants onto this revision's parent(s)</p> <p>Unlike <code>-s</code> or <code>-b</code>, you may <code>jj rebase -r</code> a revision <code>A</code> onto a descendant of <code>A</code>.</p> <p>If none of <code>-b</code>, <code>-s</code>, or <code>-r</code> is provided, then the default is <code>-b @</code>.</p> </li> <li> <p><code>-o</code>, <code>--onto &lt;REVSETS&gt;</code> \u2014 The revision(s) to rebase onto (can be repeated to create a merge commit)</p> </li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> [alias: <code>after</code>] \u2014 The revision(s) to insert after (can be repeated to create a merge commit)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> [alias: <code>before</code>] \u2014 The revision(s) to insert before (can be repeated to create a merge commit)</li> <li><code>--skip-emptied</code> \u2014 If true, when rebasing would produce an empty commit, the commit is abandoned. It will not be abandoned if it was already empty before the rebase. Will never skip merge commits with multiple non-empty parents</li> <li> <p><code>--keep-divergent</code> \u2014 Keep divergent commits while rebasing</p> <p>Without this flag, divergent commits are abandoned while rebasing if another commit with the same change ID is already present in the destination with identical changes.</p> </li> </ul>"},{"location":"cli-reference.html#jj-redo","title":"<code>jj redo</code>","text":"<p>Redo the most recently undone operation</p> <p>This is the natural counterpart of <code>jj undo</code>. Repeated invocations of <code>jj undo</code> and <code>jj redo</code> act similarly to Undo/Redo commands in a text editor.</p> <p>Use <code>jj op log</code> to visualize the log of past operations, including a detailed description of any past undo/redo operations. See also <code>jj op restore</code> to explicitly restore an older operation by its id (available in the operation log).</p> <p>Usage: <code>jj redo</code></p>"},{"location":"cli-reference.html#jj-resolve","title":"<code>jj resolve</code>","text":"<p>Resolve conflicted files with an external merge tool</p> <p>Only conflicts that can be resolved with a 3-way merge are supported. See docs for merge tool configuration instructions. External merge tools will be invoked for each conflicted file one-by-one until all conflicts are resolved. To stop resolving conflicts, exit the merge tool without making any changes.</p> <p>Note that conflicts can also be resolved without using this command. You may edit the conflict markers in the conflicted file directly with a text editor.</p> <p>Usage: <code>jj resolve [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_49","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Only resolve conflicts in these paths. You can use the <code>--list</code> argument to find paths to use here</li> </ul>"},{"location":"cli-reference.html#options_49","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code></p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-l</code>, <code>--list</code> \u2014 Instead of resolving conflicts, list all the conflicts</p> </li> <li> <p><code>--tool &lt;NAME&gt;</code> \u2014 Specify 3-way merge tool to be used</p> <p>The built-in merge tools <code>:ours</code> and <code>:theirs</code> can be used to choose side #1 and side #2 of the conflict respectively.</p> </li> </ul>"},{"location":"cli-reference.html#jj-restore","title":"<code>jj restore</code>","text":"<p>Restore paths from another revision</p> <p>That means that the paths get the same content in the destination (<code>--into</code>) as they had in the source (<code>--from</code>). This is typically used for undoing changes to some paths in the working copy (<code>jj restore &lt;paths&gt;</code>).</p> <p>If only one of <code>--from</code> or <code>--into</code> is specified, the other one defaults to the working copy.</p> <p>When neither <code>--from</code> nor <code>--into</code> is specified, the command restores into the working copy from its parent(s). <code>jj restore</code> without arguments is similar to <code>jj abandon</code>, except that it leaves an empty revision with its description and other metadata preserved.</p> <p>See <code>jj diffedit</code> if you'd like to restore portions of files rather than entire files.</p> <p>Usage: <code>jj restore [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_50","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restore only these paths (instead of all paths)</li> </ul>"},{"location":"cli-reference.html#options_50","title":"Options:","text":"<ul> <li><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Revision to restore from (source)</li> <li><code>-t</code>, <code>--into &lt;REVSET&gt;</code> [alias: <code>to</code>] \u2014 Revision to restore into (destination)</li> <li> <p><code>-c</code>, <code>--changes-in &lt;REVSET&gt;</code> \u2014 Undo the changes in a revision as compared to the merge of its parents.</p> <p>This undoes the changes that can be seen with <code>jj diff -r REVSET</code>. If <code>REVSET</code> only has a single parent, this option is equivalent to <code>jj restore --into REVSET --from REVSET-</code>.</p> <p>The default behavior of <code>jj restore</code> is equivalent to <code>jj restore --changes-in @</code>.</p> </li> <li> <p><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which parts to restore</p> </li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</li> <li><code>--restore-descendants</code> \u2014 Preserve the content (not the diff) when rebasing descendants</li> </ul>"},{"location":"cli-reference.html#jj-revert","title":"<code>jj revert</code>","text":"<p>Apply the reverse of the given revision(s)</p> <p>The reverse of each of the given revisions is applied sequentially in reverse topological order at the given location.</p> <p>The description of the new revisions can be customized with the <code>templates.revert_description</code> config variable.</p> <p>Usage: <code>jj revert [OPTIONS] &lt;--onto &lt;REVSETS&gt;|--insert-after &lt;REVSETS&gt;|--insert-before &lt;REVSETS&gt;&gt;</code></p>"},{"location":"cli-reference.html#options_51","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 The revision(s) to apply the reverse of</li> <li><code>-o</code>, <code>--onto &lt;REVSETS&gt;</code> [alias: <code>destination</code>] \u2014 The revision(s) to apply the reverse changes on top of</li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> [alias: <code>after</code>] \u2014 The revision(s) to insert the reverse changes after (can be repeated to create a merge commit)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> [alias: <code>before</code>] \u2014 The revision(s) to insert the reverse changes before (can be repeated to create a merge commit)</li> </ul>"},{"location":"cli-reference.html#jj-root","title":"<code>jj root</code>","text":"<p>Show the current workspace root directory (shortcut for <code>jj workspace root</code>)</p> <p>Usage: <code>jj root</code></p>"},{"location":"cli-reference.html#jj-show","title":"<code>jj show</code>","text":"<p>Show commit description and changes in a revision</p> <p>Usage: <code>jj show [OPTIONS] [REVSET]</code></p>"},{"location":"cli-reference.html#arguments_51","title":"Arguments:","text":"<ul> <li><code>&lt;REVSET&gt;</code> \u2014 Show changes in this revision, compared to its parent(s) [default: @] [aliases: -r]</li> </ul>"},{"location":"cli-reference.html#options_52","title":"Options:","text":"<ul> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render a revision using the given template</p> <p>You can specify arbitrary template expressions using the built-in keywords. See [<code>jj help -k templates</code>] for more information.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li> <p><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</p> <p>A builtin format can also be specified as <code>:&lt;name&gt;</code>. For example, <code>--tool=:git</code> is equivalent to <code>--git</code>.</p> </li> <li> <p><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</p> </li> <li><code>--no-patch</code> \u2014 Do not show the patch</li> <li><code>-w</code>, <code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>-b</code>, <code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-sign","title":"<code>jj sign</code>","text":"<p>Cryptographically sign a revision</p> <p>This command requires configuring a commit signing backend.</p> <p>Usage: <code>jj sign [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_53","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 What revision(s) to sign</p> <p>If no revisions are specified, this defaults to the <code>revsets.sign</code> setting.</p> <p>Note that revisions are always re-signed.</p> <p>While that leads to discomfort for users, which sign with hardware devices, as of now we cannot reliably check if a commit is already signed by the user without creating a signature (see #5786).</p> </li> <li> <p><code>--key &lt;KEY&gt;</code> \u2014 The key used for signing</p> </li> </ul>"},{"location":"cli-reference.html#jj-simplify-parents","title":"<code>jj simplify-parents</code>","text":"<p>Simplify parent edges for the specified revision(s).</p> <p>Removes all parents of each of the specified revisions that are also indirect ancestors of the same revisions through other parents. This has no effect on any revision's contents, including the working copy.</p> <p>In other words, for all (A, B, C) where A has (B, C) as parents and C is an ancestor of B, A will be rewritten to have only B as a parent instead of B+C.</p> <p>Usage: <code>jj simplify-parents [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_54","title":"Options:","text":"<ul> <li><code>-s</code>, <code>--source &lt;REVSETS&gt;</code> \u2014 Simplify specified revision(s) together with their trees of descendants (can be repeated)</li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Simplify specified revision(s) (can be repeated)</p> <p>If both <code>--source</code> and <code>--revisions</code> are not provided, this defaults to the <code>revsets.simplify-parents</code> setting, or <code>reachable(@, mutable())</code> if it is not set.</p> </li> </ul>"},{"location":"cli-reference.html#jj-sparse","title":"<code>jj sparse</code>","text":"<p>Manage which paths from the working-copy commit are present in the working copy</p> <p>Usage: <code>jj sparse &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_10","title":"Subcommands:","text":"<ul> <li><code>edit</code> \u2014 Start an editor to update the patterns that are present in the working copy</li> <li><code>list</code> \u2014 List the patterns that are currently present in the working copy</li> <li><code>reset</code> \u2014 Reset the patterns to include all files in the working copy</li> <li><code>set</code> \u2014 Update the patterns that are present in the working copy</li> </ul>"},{"location":"cli-reference.html#jj-sparse-edit","title":"<code>jj sparse edit</code>","text":"<p>Start an editor to update the patterns that are present in the working copy</p> <p>Usage: <code>jj sparse edit</code></p>"},{"location":"cli-reference.html#jj-sparse-list","title":"<code>jj sparse list</code>","text":"<p>List the patterns that are currently present in the working copy</p> <p>By default, a newly cloned or initialized repo will have have a pattern matching all files from the repo root. That pattern is rendered as <code>.</code> (a single period).</p> <p>Usage: <code>jj sparse list</code></p>"},{"location":"cli-reference.html#jj-sparse-reset","title":"<code>jj sparse reset</code>","text":"<p>Reset the patterns to include all files in the working copy</p> <p>Usage: <code>jj sparse reset</code></p>"},{"location":"cli-reference.html#jj-sparse-set","title":"<code>jj sparse set</code>","text":"<p>Update the patterns that are present in the working copy</p> <p>For example, if all you need is the <code>README.md</code> and the <code>lib/</code> directory, use <code>jj sparse set --clear --add README.md --add lib</code>. If you no longer need the <code>lib</code> directory, use <code>jj sparse set --remove lib</code>.</p> <p>Usage: <code>jj sparse set [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_55","title":"Options:","text":"<ul> <li><code>--add &lt;ADD&gt;</code> \u2014 Patterns to add to the working copy</li> <li><code>--remove &lt;REMOVE&gt;</code> \u2014 Patterns to remove from the working copy</li> <li><code>--clear</code> \u2014 Include no files in the working copy (combine with --add)</li> </ul>"},{"location":"cli-reference.html#jj-split","title":"<code>jj split</code>","text":"<p>Split a revision in two</p> <p>Starts a diff editor on the changes in the revision. Edit the right side of the diff until it has the content you want in the first commit. Once you close the editor, your revision will be split into two commits.</p> <p>By default, the selected changes stay in the original commit, and the remaining changes go into a new child commit:</p> <pre><code>L                 L'\n|                 |\nK (split)   =&gt;    K\" (remaining)\n|                 |\nJ                 K' (selected)\n                  |\n                  J\n</code></pre> <p>With <code>--parallel/-p</code>, the two parts become sibling commits instead of parent and child:</p> <pre><code>                  L'\nL                / \\\n|               K'  |  (selected)\nK (split)  =&gt;   |   K\" (remaining)\n|                \\ /\nJ                 J\n</code></pre> <p>With <code>-o</code>, <code>-A</code>, or <code>-B</code>, the selected changes are extracted into a new commit at the specified location, while the remaining changes stay in place:</p> <pre><code>M                 M'\n|                 |\nL                 L'\n|                 |\nK (split)   =&gt;    K' (remaining, stays here)\n|                 |\nJ                 J'\n                  |\n                  K\" (selected, inserted before J with -B J)\n</code></pre> <p>If the change you split had a description, you will be asked to enter a change description for each commit. If the change did not have a description, the second commit will not get a description, and you will be asked for a description only for the first commit.</p> <p>Splitting an empty commit is not supported because the same effect can be achieved with <code>jj new</code>.</p> <p>Usage: <code>jj split [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_52","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Files matching any of these filesets are put in the selected changes</li> </ul>"},{"location":"cli-reference.html#options_56","title":"Options:","text":"<ul> <li> <p><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which parts to split</p> <p>This is the default if no filesets are provided.</p> </li> <li> <p><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</p> </li> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to split</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-o</code>, <code>--onto &lt;REVSETS&gt;</code> [alias: <code>destination</code>] \u2014 The revision(s) to rebase the selected changes onto (can be repeated to create a merge commit)</p> <p>Extracts the selected changes into a new commit based on the given revision(s). The remaining changes stay in the original commit's location.</p> </li> <li> <p><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> [alias: <code>after</code>] \u2014 The revision(s) to insert after (can be repeated to create a merge commit)</p> <p>Extracts the selected changes into a new commit inserted after the given revision(s). The remaining changes stay in the original commit's location.</p> </li> <li> <p><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> [alias: <code>before</code>] \u2014 The revision(s) to insert before (can be repeated to create a merge commit)</p> <p>Extracts the selected changes into a new commit inserted before the given revision(s). The remaining changes stay in the original commit's location.</p> </li> <li> <p><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use (don't open editor)</p> <p>Sets the description for the first commit (the one containing the selected changes). The second commit keeps the original description.</p> </li> <li> <p><code>--editor</code> \u2014 Open an editor to edit the change description</p> <p>Forces an editor to open when using <code>--message</code> to allow the message to be edited afterwards.</p> </li> <li> <p><code>-p</code>, <code>--parallel</code> \u2014 Split the revision into two parallel revisions instead of a parent and child</p> </li> </ul>"},{"location":"cli-reference.html#jj-squash","title":"<code>jj squash</code>","text":"<p>Move changes from a revision into another revision</p> <p>Without any options, moves the changes from the working-copy revision to the parent revision.</p> <p>With the <code>-r</code> option, moves the changes from the specified revision to the parent revision. Fails if there are several parent revisions (i.e., the given revision is a merge).</p> <p>With the <code>--from</code> and/or <code>--into</code> options, moves changes from/to the given revisions. If either is left out, it defaults to the working-copy commit. For example, <code>jj squash --into @--</code> moves changes from the working-copy commit to the grandparent.</p> <p>If, after moving changes out, the source revision is empty compared to its parent(s), and <code>--keep-emptied</code> is not set, it will be abandoned. Without <code>--interactive</code> or paths, the source revision will always be empty.</p> <p>If the source was abandoned and both the source and destination had a non-empty description, you will be asked for the combined description. If either was empty, then the other one will be used.</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>The name \"squash\" comes from the idea of combining (squashing) the changes from multiple revisions together.</p> <p>EXPERIMENTAL FEATURES</p> <p>An alternative squashing UI is available via the <code>-o</code>, <code>-A</code>, and <code>-B</code> options. Using any of these options creates a new commit. They can be used together with one or more <code>--from</code> options (if no <code>--from</code> is specified, <code>--from @</code> is assumed).</p> <p>Usage: <code>jj squash [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_53","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Move only changes to these paths (instead of all paths)</li> </ul>"},{"location":"cli-reference.html#options_57","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 Revision to squash into its parent (default: @). Incompatible with the experimental <code>-o</code>/<code>-A</code>/<code>-B</code> options</li> <li><code>-f</code>, <code>--from &lt;REVSETS&gt;</code> \u2014 Revision(s) to squash from (default: @)</li> <li><code>-t</code>, <code>--into &lt;REVSET&gt;</code> [alias: <code>to</code>] \u2014 Revision to squash into (default: @)</li> <li><code>-o</code>, <code>--onto &lt;REVSETS&gt;</code> [alias: <code>destination</code>] \u2014 (Experimental) The revision(s) to use as parent for the new commit (can be repeated to create a merge commit)</li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> [alias: <code>after</code>] \u2014 (Experimental) The revision(s) to insert the new commit after (can be repeated to create a merge commit)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> [alias: <code>before</code>] \u2014 (Experimental) The revision(s) to insert the new commit before (can be repeated to create a merge commit)</li> <li><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The description to use for squashed revision (don't open editor)</li> <li><code>-u</code>, <code>--use-destination-message</code> \u2014 Use the description of the destination revision and discard the description(s) of the source revision(s)</li> <li> <p><code>--editor</code> \u2014 Open an editor to edit the change description</p> <p>Forces an editor to open when using <code>--message</code> to allow the message to be edited afterwards.</p> </li> <li> <p><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which parts to squash</p> </li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</li> <li><code>-k</code>, <code>--keep-emptied</code> \u2014 The source revision will not be abandoned</li> </ul>"},{"location":"cli-reference.html#jj-status","title":"<code>jj status</code>","text":"<p>Show high-level repo status [default alias: st]</p> <p>This includes:</p> <ul> <li> <p>The working copy commit and its parents, and a summary of the changes in the working copy (compared to the merged parents)</p> </li> <li> <p>Conflicts in the working copy</p> </li> <li> <p>Conflicted bookmarks</p> </li> </ul> <p>Note: You can use <code>jj diff --summary -r &lt;rev&gt;</code> to see the changed files for a specific revision.</p> <p>Usage: <code>jj status [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_54","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restrict the status display to these paths</li> </ul>"},{"location":"cli-reference.html#jj-tag","title":"<code>jj tag</code>","text":"<p>Manage tags</p> <p>Usage: <code>jj tag &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_11","title":"Subcommands:","text":"<ul> <li><code>delete</code> \u2014 Delete existing tags</li> <li><code>list</code> \u2014 List tags and their targets</li> <li><code>set</code> \u2014 Create or update tags</li> </ul>"},{"location":"cli-reference.html#jj-tag-delete","title":"<code>jj tag delete</code>","text":"<p>Delete existing tags</p> <p>Revisions referred to by the deleted tags are not abandoned.</p> <p>Usage: <code>jj tag delete &lt;NAMES&gt;...</code></p> <p>Command Alias: <code>d</code></p>"},{"location":"cli-reference.html#arguments_55","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Tag names to delete</p> <p>By default, the specified pattern matches tag names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#jj-tag-list","title":"<code>jj tag list</code>","text":"<p>List tags and their targets</p> <p>By default, a tracked remote tag will be included only if its target is different from the local tag. An untracked remote tag won't be listed. For a conflicted tag (both local and remote), old target revisions are preceded by a \"-\" and new target revisions are preceded by a \"+\".</p> <p>Usage: <code>jj tag list [OPTIONS] [NAMES]...</code></p> <p>Command Alias: <code>l</code></p>"},{"location":"cli-reference.html#arguments_56","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Show tags whose local name matches</p> <p>By default, the specified pattern matches tag names with glob syntax. You can also use other string pattern syntax.</p> </li> </ul>"},{"location":"cli-reference.html#options_58","title":"Options:","text":"<ul> <li><code>-a</code>, <code>--all-remotes</code> \u2014 Show all tracked and untracked remote tags including the ones whose targets are synchronized with the local tags</li> <li><code>-c</code>, <code>--conflicted</code> \u2014 Show conflicted tags only</li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Show tags whose local targets are in the given revisions</p> <p>Note that <code>-r deleted_tag</code> will not work since <code>deleted_tag</code> wouldn't have a local target.</p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each tag using the given template</p> <p>All 0-argument methods of the [<code>CommitRef</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> </li> <li> <p><code>--sort &lt;SORT_KEY&gt;</code> \u2014 Sort tags based on the given key (or multiple keys)</p> <p>Suffix the key with <code>-</code> to sort in descending order of the value (e.g. <code>--sort name-</code>). Note that when using multiple keys, the first key is the most significant.</p> <p>This defaults to the <code>ui.tag-list-sort-keys</code> setting.</p> <p>Possible values: <code>name</code>, <code>name-</code>, <code>author-name</code>, <code>author-name-</code>, <code>author-email</code>, <code>author-email-</code>, <code>author-date</code>, <code>author-date-</code>, <code>committer-name</code>, <code>committer-name-</code>, <code>committer-email</code>, <code>committer-email-</code>, <code>committer-date</code>, <code>committer-date-</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-tag-set","title":"<code>jj tag set</code>","text":"<p>Create or update tags</p> <p>Usage: <code>jj tag set [OPTIONS] &lt;NAMES&gt;...</code></p> <p>Command Alias: <code>s</code></p>"},{"location":"cli-reference.html#arguments_57","title":"Arguments:","text":"<ul> <li><code>&lt;NAMES&gt;</code> \u2014 Tag names to create or update</li> </ul>"},{"location":"cli-reference.html#options_59","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> [alias: <code>to</code>] \u2014 Target revision to point to</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>--allow-move</code> \u2014 Allow moving existing tags</p> </li> </ul>"},{"location":"cli-reference.html#jj-undo","title":"<code>jj undo</code>","text":"<p>Undo the last operation</p> <p>If used once after a normal (non-<code>undo</code>) operation, this will undo that last operation by restoring its parent. If <code>jj undo</code> is used repeatedly, it will restore increasingly older operations, going further back into the past.</p> <p>There is also a complementary <code>jj redo</code> command that would instead move in the direction of the future after one or more <code>jj undo</code>s.</p> <p>Use <code>jj op log</code> to visualize the log of past operations, including a detailed description of any past undo/redo operations. See also <code>jj op restore</code> to explicitly restore an older operation by its id (available in the operation log).</p> <p>Usage: <code>jj undo [OPERATION]</code></p>"},{"location":"cli-reference.html#arguments_58","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 (deprecated, use <code>jj op revert &lt;operation&gt;</code>)</p> <p>The operation to undo</p> <p>Use <code>jj op log</code> to find an operation to undo.</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-unsign","title":"<code>jj unsign</code>","text":"<p>Drop a cryptographic signature</p> <p>See also commit signing docs.</p> <p>Usage: <code>jj unsign [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_60","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 What revision(s) to unsign</li> </ul>"},{"location":"cli-reference.html#jj-util","title":"<code>jj util</code>","text":"<p>Infrequently used commands such as for generating shell completions</p> <p>Usage: <code>jj util &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_12","title":"Subcommands:","text":"<ul> <li><code>completion</code> \u2014 Print a command-line-completion script</li> <li><code>config-schema</code> \u2014 Print the JSON schema for the jj TOML config format</li> <li><code>exec</code> \u2014 Execute an external command via jj</li> <li><code>gc</code> \u2014 Run backend-dependent garbage collection</li> <li><code>install-man-pages</code> \u2014 Install Jujutsu's manpages to the provided path</li> <li><code>markdown-help</code> \u2014 Print the CLI help for all subcommands in Markdown</li> </ul>"},{"location":"cli-reference.html#jj-util-completion","title":"<code>jj util completion</code>","text":"<p>Print a command-line-completion script</p> <p>Apply it by running one of these:</p> <ul> <li>Bash: <code>source &lt;(jj util completion bash)</code></li> <li>Fish: <code>jj util completion fish | source</code></li> <li>Nushell:     <pre><code>jj util completion nushell | save -f \"completions-jj.nu\"\nuse \"completions-jj.nu\" *  # Or `source \"completions-jj.nu\"`\n</code></pre></li> <li>Zsh:     <pre><code>autoload -U compinit\ncompinit\nsource &lt;(jj util completion zsh)\n</code></pre></li> </ul> <p>See the docs on command-line completion for more details.</p> <p>Usage: <code>jj util completion &lt;SHELL&gt;</code></p>"},{"location":"cli-reference.html#arguments_59","title":"Arguments:","text":"<ul> <li> <p><code>&lt;SHELL&gt;</code></p> <p>Possible values: <code>bash</code>, <code>elvish</code>, <code>fish</code>, <code>nushell</code>, <code>power-shell</code>, <code>zsh</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-util-config-schema","title":"<code>jj util config-schema</code>","text":"<p>Print the JSON schema for the jj TOML config format</p> <p>Usage: <code>jj util config-schema</code></p>"},{"location":"cli-reference.html#jj-util-exec","title":"<code>jj util exec</code>","text":"<p>Execute an external command via jj</p> <p>This command will have access to the environment variable JJ_WORKSPACE_ROOT.</p> <p>This is useful for arbitrary aliases.</p> <p>!! WARNING !!</p> <p>The following technique just provides a convenient syntax for running arbitrary code on your system. Using it irresponsibly may cause damage ranging from breaking the behavior of <code>jj undo</code> to wiping your file system. Exercise the same amount of caution while writing these aliases as you would when typing commands into the terminal!</p> <p>This feature may be removed or replaced by an embedded scripting language in the future.</p> <p>Let's assume you have a script called \"my-jj-script\" in you $PATH and you would like to execute it as \"jj my-script\". You would add the following line to your configuration file to achieve that:</p> <pre><code>[aliases]\nmy-script = [\"util\", \"exec\", \"--\", \"my-jj-script\"]\n#                            ^^^^\n# This makes sure that flags are passed to your script instead of parsed by jj.\n</code></pre> <p>If you don't want to manage your script as a separate file, you can even inline it into your config file:</p> <pre><code>[aliases]\nmy-inline-script = [\"util\", \"exec\", \"--\", \"bash\", \"-c\", \"\"\"\nset -euo pipefail\necho \"Look Ma, everything in one file!\"\necho \"args: $@\"\n\"\"\", \"\"]\n#    ^^\n# This last empty string will become \"$0\" in bash, so your actual arguments\n# are all included in \"$@\" and start at \"$1\" as expected.\n</code></pre> <p>Note: Shebangs (e.g. <code>#!/usr/bin/env</code>) aren't necessary since you're already explicitly passing your script into the right shell.</p> <p>Usage: <code>jj util exec &lt;COMMAND&gt; [ARGS]...</code></p>"},{"location":"cli-reference.html#arguments_60","title":"Arguments:","text":"<ul> <li><code>&lt;COMMAND&gt;</code> \u2014 External command to execute</li> <li><code>&lt;ARGS&gt;</code> \u2014 Arguments to pass to the external command</li> </ul>"},{"location":"cli-reference.html#jj-util-gc","title":"<code>jj util gc</code>","text":"<p>Run backend-dependent garbage collection.</p> <p>To garbage-collect old operations and the commits/objects referenced by them, run <code>jj op abandon ..&lt;some old operation&gt;</code> before <code>jj util gc</code>.</p> <p>Usage: <code>jj util gc [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_61","title":"Options:","text":"<ul> <li> <p><code>--expire &lt;EXPIRE&gt;</code> \u2014 Time threshold</p> <p>By default, only obsolete objects and operations older than 2 weeks are pruned.</p> <p>Only the string \"now\" can be passed to this parameter. Support for arbitrary absolute and relative timestamps will come in a subsequent release.</p> </li> </ul>"},{"location":"cli-reference.html#jj-util-install-man-pages","title":"<code>jj util install-man-pages</code>","text":"<p>Install Jujutsu's manpages to the provided path</p> <p>Usage: <code>jj util install-man-pages &lt;PATH&gt;</code></p>"},{"location":"cli-reference.html#arguments_61","title":"Arguments:","text":"<ul> <li><code>&lt;PATH&gt;</code> \u2014 The path where manpages will installed. An example path might be <code>/usr/share/man</code>. The provided path will be appended with <code>man1</code>, etc., as appropriate</li> </ul>"},{"location":"cli-reference.html#jj-util-markdown-help","title":"<code>jj util markdown-help</code>","text":"<p>Print the CLI help for all subcommands in Markdown</p> <p>Usage: <code>jj util markdown-help</code></p>"},{"location":"cli-reference.html#jj-version","title":"<code>jj version</code>","text":"<p>Display version information</p> <p>Usage: <code>jj version</code></p>"},{"location":"cli-reference.html#jj-workspace","title":"<code>jj workspace</code>","text":"<p>Commands for working with workspaces</p> <p>Workspaces let you add additional working copies attached to the same repo. A common use case is so you can run a slow build or test in one workspace while you're continuing to write code in another workspace.</p> <p>Each workspace has its own working-copy commit. When you have more than one workspace attached to a repo, they are indicated by <code>&lt;workspace name&gt;@</code> in <code>jj log</code>.</p> <p>Each workspace also has own sparse patterns.</p> <p>Usage: <code>jj workspace &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_13","title":"Subcommands:","text":"<ul> <li><code>add</code> \u2014 Add a workspace</li> <li><code>forget</code> \u2014 Stop tracking a workspace's working-copy commit in the repo</li> <li><code>list</code> \u2014 List workspaces</li> <li><code>rename</code> \u2014 Renames the current workspace</li> <li><code>root</code> \u2014 Show the workspace root directory</li> <li><code>update-stale</code> \u2014 Update a workspace that has become stale</li> </ul>"},{"location":"cli-reference.html#jj-workspace-add","title":"<code>jj workspace add</code>","text":"<p>Add a workspace</p> <p>By default, the new workspace inherits the sparse patterns of the current workspace. You can override this with the <code>--sparse-patterns</code> option.</p> <p>Usage: <code>jj workspace add [OPTIONS] &lt;DESTINATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_62","title":"Arguments:","text":"<ul> <li><code>&lt;DESTINATION&gt;</code> \u2014 Where to create the new workspace</li> </ul>"},{"location":"cli-reference.html#options_62","title":"Options:","text":"<ul> <li> <p><code>--name &lt;NAME&gt;</code> \u2014 A name for the workspace</p> <p>To override the default, which is the basename of the destination directory.</p> </li> <li> <p><code>-r</code>, <code>--revision &lt;REVSETS&gt;</code> \u2014 A list of parent revisions for the working-copy commit of the newly created workspace. You may specify nothing, or any number of parents.</p> <p>If no revisions are specified, the new workspace will be created, and its working-copy commit will exist on top of the parent(s) of the working-copy commit in the current workspace, i.e. they will share the same parent(s).</p> <p>If any revisions are specified, the new workspace will be created, and the new working-copy commit will be created with all these revisions as parents, i.e. the working-copy commit will exist as if you had run <code>jj new r1 r2 r3 ...</code>.</p> </li> <li> <p><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use</p> </li> <li> <p><code>--sparse-patterns &lt;SPARSE_PATTERNS&gt;</code> \u2014 How to handle sparse patterns when creating a new workspace</p> <p>Default value: <code>copy</code></p> <p>Possible values:</p> <ul> <li><code>copy</code>:   Copy all sparse patterns from the current workspace</li> <li><code>full</code>:   Include all files in the new workspace</li> <li><code>empty</code>:   Clear all files from the workspace (it will be empty)</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-workspace-forget","title":"<code>jj workspace forget</code>","text":"<p>Stop tracking a workspace's working-copy commit in the repo</p> <p>The workspace will not be touched on disk. It can be deleted from disk before or after running this command.</p> <p>Usage: <code>jj workspace forget [WORKSPACES]...</code></p>"},{"location":"cli-reference.html#arguments_63","title":"Arguments:","text":"<ul> <li><code>&lt;WORKSPACES&gt;</code> \u2014 Names of the workspaces to forget. By default, forgets only the current workspace</li> </ul>"},{"location":"cli-reference.html#jj-workspace-list","title":"<code>jj workspace list</code>","text":"<p>List workspaces</p> <p>Usage: <code>jj workspace list [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_63","title":"Options:","text":"<ul> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each workspace using the given template</p> <p>All 0-argument methods of the [<code>WorkspaceRef</code> type] are available as keywords in the template expression. See [<code>jj help -k templates</code>] for more information.</p> </li> </ul>"},{"location":"cli-reference.html#jj-workspace-rename","title":"<code>jj workspace rename</code>","text":"<p>Renames the current workspace</p> <p>Usage: <code>jj workspace rename &lt;NEW_WORKSPACE_NAME&gt;</code></p>"},{"location":"cli-reference.html#arguments_64","title":"Arguments:","text":"<ul> <li><code>&lt;NEW_WORKSPACE_NAME&gt;</code> \u2014 The name of the workspace to update to</li> </ul>"},{"location":"cli-reference.html#jj-workspace-root","title":"<code>jj workspace root</code>","text":"<p>Show the workspace root directory</p> <p>Usage: <code>jj workspace root [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_64","title":"Options:","text":"<ul> <li><code>--name &lt;NAME&gt;</code> \u2014 Name of the workspace (defaults to current)</li> </ul>"},{"location":"cli-reference.html#jj-workspace-update-stale","title":"<code>jj workspace update-stale</code>","text":"<p>Update a workspace that has become stale</p> <p>See the stale working copy documentation for more information.</p> <p>Usage: <code>jj workspace update-stale</code></p> <p>     This document was generated automatically by     <code>clap-markdown</code>. </p>"},{"location":"code-of-conduct.html","title":"Contributor Covenant Code of Conduct","text":""},{"location":"code-of-conduct.html#our-pledge","title":"Our Pledge","text":"<p>We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socioeconomic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.</p> <p>We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.</p>"},{"location":"code-of-conduct.html#our-standards","title":"Our Standards","text":"<p>Examples of behavior that contributes to a positive environment for our community include:</p> <ul> <li>Demonstrating empathy and kindness toward other people</li> <li>Being respectful of differing opinions, viewpoints, and experiences</li> <li>Giving and gracefully accepting constructive feedback</li> <li>Accepting responsibility and apologizing to those affected by our mistakes,   and learning from the experience</li> <li>Focusing on what is best not just for us as individuals, but for the overall   community</li> </ul> <p>Examples of unacceptable behavior include:</p> <ul> <li>The use of sexualized language or imagery, and sexual attention or advances of   any kind</li> <li>Trolling, insulting or derogatory comments, and personal or political attacks</li> <li>Public or private harassment</li> <li>Publishing others' private information, such as a physical or email address,   without their explicit permission</li> <li>Other conduct which could reasonably be considered inappropriate in a   professional setting</li> </ul>"},{"location":"code-of-conduct.html#enforcement-responsibilities","title":"Enforcement Responsibilities","text":"<p>Community leaders are responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.</p> <p>Community leaders have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.</p>"},{"location":"code-of-conduct.html#scope","title":"Scope","text":"<p>This Code of Conduct applies within all community spaces, and also applies when an individual is officially representing the community in public spaces. Examples of representing our community include using an official e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event.</p>"},{"location":"code-of-conduct.html#enforcement","title":"Enforcement","text":"<p>Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the community leaders responsible for enforcement at two or more of jaraco@jaraco.com, community@isaaccorbrey.com, me@waleedkhan.name, and opensource@google.com. All complaints will be reviewed and investigated promptly and fairly.</p> <p>All community leaders are obligated to respect the privacy and security of the reporter of any incident.</p>"},{"location":"code-of-conduct.html#enforcement-guidelines","title":"Enforcement Guidelines","text":"<p>Community leaders will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:</p>"},{"location":"code-of-conduct.html#1-correction","title":"1. Correction","text":"<p>Community Impact: Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community.</p> <p>Consequence: A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.</p>"},{"location":"code-of-conduct.html#2-warning","title":"2. Warning","text":"<p>Community Impact: A violation through a single incident or series of actions.</p> <p>Consequence: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.</p>"},{"location":"code-of-conduct.html#3-temporary-ban","title":"3. Temporary Ban","text":"<p>Community Impact: A serious violation of community standards, including sustained inappropriate behavior.</p> <p>Consequence: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.</p>"},{"location":"code-of-conduct.html#4-permanent-ban","title":"4. Permanent Ban","text":"<p>Community Impact: Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.</p> <p>Consequence: A permanent ban from any sort of public interaction within the community.</p>"},{"location":"code-of-conduct.html#attribution","title":"Attribution","text":"<p>This Code of Conduct is adapted from the Contributor Covenant, version 2.1, available at https://www.contributor-covenant.org/version/2/1/code_of_conduct.html.</p> <p>Community Impact Guidelines were inspired by Mozilla's code of conduct enforcement ladder.</p> <p>For answers to common questions about this code of conduct, see the FAQ at https://www.contributor-covenant.org/faq. Translations are available at https://www.contributor-covenant.org/translations.</p>"},{"location":"community_tools.html","title":"Community-built tools around Jujutsu","text":"<p>Many of these tools are not complete yet, just like Jujutsu itself. But they already simplify many workflows and can improve your experience.</p> <p>Warning</p> <p>The listed tools are community\u2011maintained; the Jujutsu project does not review, endorse, or guarantee their quality or security.</p>"},{"location":"community_tools.html#diffedit3","title":"Diffedit3","text":"<p>Diffedit3 is a web-based alternate to Meld, as it no longer is packaged and available for all Distros. Its creator is also a frequent contributor.</p> <p>Find it here</p>"},{"location":"community_tools.html#gg-gui-for-jj","title":"GG - GUI for JJ","text":"<p>GG is a cross platform GUI for Jujutsu which makes all graph manipulating workflows quite easy. Take a look at its README.md as it quite descriptive.</p> <p>Find it here.</p>"},{"location":"community_tools.html#hunknvim","title":"Hunk.nvim","text":"<p>Hunk.nvim is a Neovim based diff-editor for Jujutsu which can be used as an alternative to the default <code>:builtin</code> diff-editor.</p> <p>Find it here.</p>"},{"location":"community_tools.html#jj-fzf","title":"JJ-FZF","text":"<p>Centered around the <code>jj log</code> graph view, jj-fzf provides previews of diffs, the evolution-log, browses the op log and offers a large number of key bindings for commonly used <code>jj</code> operations from rebase to undo, and helps with divergent commits.</p> <p>Find it here.</p>"},{"location":"community_tools.html#jj-tui","title":"JJ TUI","text":"<p>This is TUI for Jujutsu built in Ocaml, it is unopiniated and its creator is open to feedback.</p> <p>Find it here.</p>"},{"location":"community_tools.html#jujutsu-kaizen","title":"Jujutsu Kaizen","text":"<p>Jujutsu Kaizen is a plugin for Visual Studio Code. The goal of this extension is to bring the great UX of Jujutsu into the VS Code UI. Its developers are currently focused on achieving parity for commonly used features of VS Code's built-in Git extension, such as the various operations possible via the Source Control view.</p> <p>Find it here.</p>"},{"location":"community_tools.html#lazyjj","title":"LazyJJ","text":"<p>lazyjj is a lazygit inspired TUI for Jujutsu.</p> <p>Find it here.</p>"},{"location":"community_tools.html#visual-jujutsu","title":"Visual Jujutsu","text":"<p>VJJ is a fzf (fuzzy finder) wrapper for Jujutsu, which is meant to be used interactively in the terminal.</p> <p>Find it here.</p>"},{"location":"community_tools.html#visualjj","title":"VisualJJ","text":"<p>VisualJJ is a plugin for Visual Studio Code which provides native integration for Jujutsu, not relying on Git colocation. Unlike other tools on this page, VisualJJ is not open-source.</p> <p>Find it here.</p>"},{"location":"community_tools.html#jujutsu-ui","title":"Jujutsu UI","text":"<p>jjui is a terminal user interface for working with Jujutsu version control system.</p> <p>Find it here.</p>"},{"location":"community_tools.html#selvejj","title":"Selvejj","text":"<p>Selvejj is a JetBrains plugin for integrating Jujutsu as a first-class VCS within the IDE.</p> <p>Find it here.</p>"},{"location":"community_tools.html#pscompletions","title":"PSCompletions","text":"<p>PSCompletions is a completion manager for a better and simpler tab-completion experience in PowerShell.</p> <p>It can provide completions via <code>psc add jj</code>, or offer a better completion menu for the official completions.</p> <p>Find it here.</p>"},{"location":"community_tools.html#finding-other-integrations","title":"Finding other integrations","text":"<p>You can find other community contributed tools and integrations in our Wiki.</p>"},{"location":"config.html","title":"Configuration","text":"<p>These are the config settings available to jj/Jujutsu.</p>"},{"location":"config.html#config-files-and-toml","title":"Config files and TOML","text":"<p><code>jj</code> loads several types of config settings:</p> <ul> <li> <p>The built-in settings. These cannot be edited. They can be viewed in the   <code>cli/src/config/</code> directory in <code>jj</code>'s source repo.</p> </li> <li> <p>The user settings. These can be edited with <code>jj config edit --user</code>. User settings are located in the user config files, which can be found with <code>jj config path --user</code>.</p> </li> <li> <p>The repo settings. These can be edited with <code>jj config edit --repo</code>, or found   with <code>jj config path --repo</code>. For security reasons, they are not located inside   the repo.</p> </li> <li> <p>The workspace settings. These can be edited with <code>jj config edit --workspace</code>,   or found with <code>jj config path --workspace</code>. For security reasons, they are not   located inside the workspace.</p> </li> <li> <p>Settings specified in the command-line.</p> </li> </ul> <p>These are listed in the order they are loaded; the settings from earlier items in the list are overridden by the settings from later items if they disagree. Every type of config except for the built-in settings is optional.</p> <p>You can enable JSON Schema validation in your editor by adding a <code>#:schema</code> reference at the top of your TOML config files. See JSON Schema Support for details.</p> <p>See the TOML site and the syntax guide for a detailed description of the syntax. We cover some of the basics below.</p> <p>The first thing to remember is that the value of a setting (the part to the right of the <code>=</code> sign) should be surrounded in quotes if it's a string.</p>"},{"location":"config.html#dotted-style-and-headings","title":"Dotted style and headings","text":"<p>In TOML, anything under a heading can be dotted instead. For example, <code>user.name = \"YOUR NAME\"</code> is equivalent to:</p> <pre><code>[user]\nname = \"YOUR NAME\"\n</code></pre> <p>For future reference, here are a couple of more complicated examples,</p> <pre><code># Dotted style\ntemplate-aliases.\"format_short_id(id)\" = \"id.shortest(12)\"\ncolors.\"commit_id prefix\".bold = true\n\n# is equivalent to:\n[template-aliases]\n\"format_short_id(id)\" = \"id.shortest(12)\"\n\n[colors]\n\"commit_id prefix\" = { bold = true }\n</code></pre> <p>The docs below refer to keys in text using dotted notation, but example blocks will use heading notation to be unambiguous. If you are confident with TOML then use whichever suits you in your config. If you mix dotted keys and headings, you must put the dotted keys before the first heading.</p> <p>That's probably enough TOML to keep you out of trouble but the syntax guide is very short if you ever need to check.</p>"},{"location":"config.html#user-settings","title":"User settings","text":"<pre><code>[user]\nname = \"YOUR NAME\"\nemail = \"YOUR_EMAIL@example.com\"\n</code></pre> <p>Don't forget to change these to your own details!</p>"},{"location":"config.html#ui-settings","title":"UI settings","text":""},{"location":"config.html#colorizing-output","title":"Colorizing output","text":"<p>Possible values are <code>always</code>, <code>never</code>, <code>debug</code> and <code>auto</code> (default: <code>auto</code>). <code>auto</code> will use color only when writing to a terminal. <code>debug</code> will print the active labels alongside the regular colorized output.</p> <p>This setting overrides the <code>NO_COLOR</code> environment variable (if set).</p> <pre><code>[ui]\ncolor = \"never\" # Turn off color\n</code></pre>"},{"location":"config.html#custom-colors-and-styles","title":"Custom colors and styles","text":"<p>You can customize the colors used for various elements of the UI. For example:</p> <pre><code>[colors]\ncommit_id = \"green\"\n</code></pre> <p>The following colors are available:</p> <ul> <li>black</li> <li>red</li> <li>green</li> <li>yellow</li> <li>blue</li> <li>magenta</li> <li>cyan</li> <li>white</li> <li>default</li> </ul> <p>All of them but \"default\" come in a bright version too, e.g. \"bright red\". The \"default\" color can be used to override a color defined by a parent style (explained below).</p> <p>You can also use a 6-digit hex code for more control over the exact color used:</p> <pre><code>[colors]\nchange_id = \"#ff1525\"\n</code></pre> <p><code>jj</code> also supports colors from the ANSI 256-color palette as <code>ansi-color-&lt;N&gt;</code>, where <code>&lt;N&gt;</code> is a number between 0 and 255:</p> <pre><code>[colors]\ncommit_id = \"ansi-color-81\"\n</code></pre> <p>If you use a string value for a color, as in the examples above, it will be used for the foreground color. You can also set the background color, reverse colors (swap foreground and background), or make the text bold, dim, italic, or underlined. For that, you need to use a table:</p> <pre><code>[colors]\ncommit_id = { fg = \"green\", bg = \"#ff1525\", bold = true, underline = true }\nchange_id = { reverse = true, dim = false, italic = true }\n</code></pre> <p>The key names are called \"labels\". The above used <code>commit_id</code> as label. You can also create rules combining multiple labels. The rules work a bit like CSS selectors. For example, if you want to color commit IDs green in general but make the commit ID of the working-copy commit also be underlined, you can do this:</p> <pre><code>[colors]\ncommit_id = \"green\"\n\"working_copy commit_id\" = { underline = true }\n</code></pre> <p>Parts of the style that are not overridden - such as the foreground color in the example above - are inherited from the style of the parent label.</p> <p>Which elements can be colored is not yet documented, but see the default color configuration for some examples of what's possible.</p>"},{"location":"config.html#default-command","title":"Default command","text":"<p>When <code>jj</code> is run with no explicit subcommand, the value of the <code>ui.default-command</code> setting will be used instead. Possible values are any valid subcommand name, subcommand alias, or user-defined alias (defaults to <code>\"log\"</code>).</p> <pre><code>[ui]\ndefault-command = [\"log\", \"--reversed\"]\n</code></pre>"},{"location":"config.html#default-description","title":"Default description","text":"<p>The editor content of a commit description can be populated by the <code>draft_commit_description</code> template. <code>self</code> is a <code>Commit</code> object.</p> <pre><code>[templates]\ndraft_commit_description = '''\nconcat(\n  builtin_draft_commit_description,\n  \"\\nJJ: ignore-rest\\n\",\n  diff.git(),\n)\n'''\n</code></pre> <p>You can override only the <code>default_commit_description</code> value if you like, e.g.:</p> <pre><code>[template-aliases]\ndefault_commit_description = '''\n\"\n\nCloses #NNNN\n\"\n'''\n</code></pre>"},{"location":"config.html#duplicate-commit-description","title":"Duplicate commit description","text":"<p>By default, <code>jj duplicate</code> copies the descriptions from the original commits. You can customize this behavior by specifying the <code>duplicate_description</code> template, which is given a <code>Commit</code> object of the original commit.</p> <pre><code>[templates]\nduplicate_description = '''\nconcat(\n  description.trim_end(),\n  \"\\n\\n(cherry picked from commit \",\n  commit_id,\n  \")\\n\"\n)\n'''\n</code></pre> <p>Note that <code>description</code> usually ends with a <code>\\n</code> if it is not blank. Use <code>.trim_end()</code> to remove the <code>\\n</code>.</p>"},{"location":"config.html#bookmarktag-listing-order","title":"Bookmark/tag listing order","text":"<p>By default, <code>jj bookmark list</code> and <code>jj tag list</code> display bookmarks and tags sorted alphabetically by name. You can customize this sorting behavior by specifying sort keys in your config file:</p> <pre><code>[ui]\nbookmark-list-sort-keys = [\"name\"]\ntag-list-sort-keys = [\"name\"]\n</code></pre> <p>The configuration works identically to using the <code>--sort</code> option. The following sort keys are supported: <code>name</code>, <code>author-name</code>, <code>author-email</code>, <code>author-date</code>, <code>committer-name</code>, <code>committer-email</code>, <code>committer-date</code>. Suffix the key with <code>-</code> to sort in descending order. Multiple keys can be supplied here, the first key is the most significant.</p> <p>When the <code>--sort</code> option is used, the configuration is ignored.</p>"},{"location":"config.html#commit-trailers","title":"Commit trailers","text":"<p>You can configure automatic addition of one or more trailers to commit descriptions using the <code>commit_trailers</code> template.</p> <p>Each line of the template is an individual trailer, usually in <code>Key: Value</code> format.</p> <p>Trailers defined in this template are deduplicated with the existing description: if the entire line of a trailer is already present, it will not be added again. To deduplicate based only on the trailer key, use the <code>trailers.contains_key(key)</code> method within the template.</p> <pre><code>[templates]\ncommit_trailers = '''\nformat_signed_off_by_trailer(self)\n++ if(!trailers.contains_key(\"Change-Id\"), format_gerrit_change_id_trailer(self))'''\n</code></pre> <p>Some ready-to-use trailer templates are available for frequently used trailers:</p> <ul> <li><code>format_signed_off_by_trailer(commit)</code> creates a \"Signed-off-by\" trailer   using the committer info.</li> <li><code>format_gerrit_change_id_trailer(commit)</code> creates a \"Change-Id\" trailer   suitable to be used with Gerrit. It is based Jujutsu's change id.</li> </ul> <p>Existing trailers are also accessible via <code>commit.trailers()</code>.</p>"},{"location":"config.html#diff-colors-and-styles","title":"Diff colors and styles","text":"<p>In color-words and git diffs, word-level hunks are rendered with underline. You can override the default style with the following keys:</p> <pre><code>[colors]\n# Highlight hunks with background\n\"diff removed token\" = { bg = \"#221111\", underline = false }\n\"diff added token\" = { bg = \"#002200\", underline = false }\n# Alternatively, swap colors\n\"diff token\" = { reverse = true, underline = false }\n</code></pre> <p>In color-words diffs, line numbers of context lines are rendered with decreased intensity to highlight changed lines. You can also decrease intensity of context contents.</p> <pre><code>[colors]\n# Dim context line numbers (default)\n\"diff context line_number\" = { dim = true }\n# Dim context line numbers and contents (applies to color-words and git diffs)\n\"diff context\" = { dim = true }\n</code></pre>"},{"location":"config.html#diff-format","title":"Diff format","text":"<pre><code>[ui]\n# Builtin formats: \":color-words\" (default), \":git\",\n#                  \":summary\", \":stat\", \":types\", \":name-only\"\n# or external command name and arguments (see below)\ndiff-formatter = \":git\"\n</code></pre>"},{"location":"config.html#color-words-diff-options","title":"Color-words diff options","text":"<p>In color-words diffs, changed words are displayed inline by default. Because it's difficult to read a diff line with many removed/added words, there's a threshold to switch to traditional separate-line format. You can also change the default number of lines of context shown.</p> <ul> <li> <p><code>max-inline-alternation</code>: Maximum number of removed/added word alternation to   inline. For example, <code>&lt;added&gt; ... &lt;added&gt;</code> sequence has 1 alternation, so the   line will be inline if <code>max-inline-alternation &gt;= 1</code>. <code>&lt;added&gt; ... &lt;removed&gt;   ... &lt;added&gt;</code> sequence has 3 alternation.</p> <ul> <li><code>0</code>: disable inlining, making <code>--color-words</code> more similar to <code>--git</code></li> <li><code>1</code>: inline removes-only or adds-only lines</li> <li><code>2</code>, <code>3</code>, ..: inline up to <code>2</code>, <code>3</code>, .. alternation</li> <li><code>-1</code>: inline all lines</li> </ul> <p>The default is <code>3</code>.</p> <p>This parameter is experimental. The definition is subject to change.</p> </li> <li> <p><code>conflict</code>: How conflicts are processed and displayed.</p> <ul> <li><code>\"materialize\"</code>: compare materialized contents (default)</li> <li><code>\"pair\"</code>: compare individual pairs</li> </ul> <p>This parameter is experimental.</p> </li> <li> <p><code>context</code>: Number of lines of context to show in the diff. The default is <code>3</code>.</p> </li> </ul> <pre><code>[diff.color-words]\nmax-inline-alternation = 3\ncontext = 3\n</code></pre>"},{"location":"config.html#git-diff-options","title":"Git diff options","text":"<p>In git diffs you can change the default number of lines of context shown.</p> <ul> <li><code>context</code>: Number of lines of context to show in the diff. The default is <code>3</code>.</li> </ul> <pre><code>[diff.git]\ncontext = 3\n</code></pre>"},{"location":"config.html#generating-diffs-by-external-command","title":"Generating diffs by external command","text":"<p>If <code>ui.diff-formatter</code> is not a builtin format, the specified diff command will be called.</p> <pre><code>[ui]\n# Use Difftastic by default\ndiff-formatter = [\"difft\", \"--color=always\", \"$left\", \"$right\"]\n# Use tool named \"&lt;name&gt;\" (see below)\ndiff-formatter = \"&lt;name&gt;\"\n</code></pre> <p>The external diff tool can also be enabled by <code>diff --tool &lt;name&gt;</code> argument. For the tool named <code>&lt;name&gt;</code>, command arguments can be configured as follows.</p> <pre><code>[merge-tools.&lt;name&gt;]\n# program = \"&lt;name&gt;\"  # Defaults to the name of the tool if not specified\ndiff-args = [\"--color=always\", \"$left\", \"$right\"]\n</code></pre> <ul> <li> <p><code>$left</code> and <code>$right</code> are replaced with the paths to the left and right   directories to diff respectively.</p> </li> <li> <p><code>$width</code> is replaced with the number of terminal columns available to the diff   content.</p> </li> <li> <p>If <code>diff-args</code> is not specified, <code>[\"$left\", \"$right\"]</code> will be used by default.</p> </li> <li> <p>If <code>diff-args = []</code>, <code>jj</code> will refuse to use this tool for diff formatting.   This is a way to explicitly state that a certain tool (e.g. <code>mergiraf</code>) does   not work for viewing diffs.</p> </li> </ul> <p>By default <code>jj</code> will invoke external tools with a directory containing the left and right sides. The <code>diff-invocation-mode</code> config can change this to file by file invocations as follows:</p> <pre><code>[ui]\ndiff-formatter = \"vimdiff\"\n\n[merge-tools.vimdiff]\ndiff-invocation-mode = \"file-by-file\"\n</code></pre> <p>By default <code>jj</code> will display a warning when the command exits with a non-success error code. The <code>diff-expected-exit-codes</code> config can suppress this warning message for specific exit codes:</p> <pre><code>[merge-tools.delta]\ndiff-expected-exit-codes = [0, 1]\n</code></pre>"},{"location":"config.html#conflict-marker-style","title":"Conflict marker style","text":"<p>You can configure which style of conflict markers to use when materializing conflicts:</p> <pre><code>[ui]\n# Shows a single snapshot and one or more diffs to apply to it\nconflict-marker-style = \"diff\"\n# Shows a snapshot for each side and base of the conflict\nconflict-marker-style = \"snapshot\"\n# Uses Git's \"diff3\" conflict markers to support tools that depend on it\nconflict-marker-style = \"git\"\n</code></pre> <p>For more details about these conflict marker styles, see the conflicts page.</p>"},{"location":"config.html#set-of-immutable-commits","title":"Set of immutable commits","text":"<p>You can configure the set of immutable commits via <code>revset-aliases.\"immutable_heads()\"</code>. The default set of immutable heads is <code>builtin_immutable_heads()</code>, which in turn is defined as <code>trunk() | tags() | untracked_remote_bookmarks()</code>. For example, to also consider the <code>release@origin</code> bookmark immutable:</p> <pre><code>[revset-aliases]\n\"immutable_heads()\" = \"builtin_immutable_heads() | release@origin\"\n</code></pre> <p>To prevent rewriting commits authored by other users:</p> <pre><code># The `trunk().. &amp;` bit is an optimization to scan for non-`mine()` commits\n# only among commits that are not in `trunk()`.\n[revset-aliases]\n\"immutable_heads()\" = \"builtin_immutable_heads() | (trunk().. &amp; ~mine())\"\n</code></pre> <p>Ancestors of the configured set are also immutable. The root commit is always immutable even if the set is empty.</p> <p>Immutable commits (other than the root commit) can be rewritten using the <code>--ignore-immutable</code> CLI flag.</p> <p>Warning</p> <p>Using <code>--ignore-immutable</code> will allow you to rewrite any commit in the history, and all descendants, without warning. Use this power wisely, and remember <code>jj undo</code>.</p>"},{"location":"config.html#behavior-of-prev-and-next-commands","title":"Behavior of prev and next commands","text":"<p>If you prefer using an \"edit-based\" workflow, rather than squashing modifications into parent changes, you may find yourself using the <code>prev</code> and <code>next</code> commands with their <code>--edit</code> flag often to move between your changes. You can avoid having to type the <code>--edit</code> flag every time you need it by actually making it the default:</p> <pre><code>[ui.movement]\nedit = true\n</code></pre> <p>You can pass the <code>--no-edit</code> flag to <code>prev</code> and <code>next</code> if you find yourself needing the original behavior.</p>"},{"location":"config.html#list","title":"List","text":""},{"location":"config.html#default-template","title":"Default Template","text":"<p>You can configure the template used when no <code>-T</code> is specified.</p> <ul> <li><code>templates.config_list</code> for <code>jj config list</code></li> </ul> <pre><code>[templates]\n# Use builtin config list template\nconfig_list = \"builtin_config_list\"\n</code></pre> <p>If you want to see the config variable origin (type and path) when you do <code>jj config list</code> you can add this to your config:</p> <pre><code>[templates]\nconfig_list = \"builtin_config_list_detailed\"\n</code></pre>"},{"location":"config.html#log","title":"Log","text":""},{"location":"config.html#default-revisions","title":"Default revisions","text":"<p>You can configure the revisions <code>jj log</code> would show when neither <code>-r</code> nor any paths are specified.</p> <pre><code>[revsets]\n# Show commits that are not in `main@origin`\nlog = \"main@origin..\"\n</code></pre> <p>The default value for <code>revsets.log</code> is <code>'present(@) | ancestors(immutable_heads().., 2) | trunk()'</code>.</p>"},{"location":"config.html#prioritize-revsets-in-the-log-over","title":"Prioritize Revsets in the Log over @","text":"<p>In some situations the default graph can be hard to read, for example when working with big merges. To improve this behavior you can configure which revset in the <code>jj log</code> graph is displayed on the left instead of <code>@</code>.</p> <p>The following example will prioritize the change with the description \"megamerge\" with a fallback to <code>trunk()</code> in case no such change exists:</p> <pre><code>[revsets]\nlog-graph-prioritize = 'coalesce(description(\"megamerge\\n\"), trunk())'\n</code></pre>"},{"location":"config.html#default-template_1","title":"Default Template","text":"<p>You can configure the template used when no <code>-T</code> is specified.</p> <ul> <li><code>templates.evolog</code> for <code>jj evolog</code></li> <li><code>templates.log</code> for <code>jj log</code></li> <li><code>templates.show</code> for <code>jj show</code></li> <li><code>templates.op_log</code> for <code>jj op log</code></li> <li><code>templates.op_show</code> for <code>jj op show</code></li> </ul> <pre><code>[templates]\n# Use builtin evolog template\nevolog = \"builtin_evolog_compact\"\n# Use builtin log template\nlog = \"builtin_log_compact\"\n# Use builtin show template\nshow = \"builtin_log_detailed\"\n# Use builtin op log template\nop_log = \"builtin_op_log_compact\"\n# Use builtin op log template\nop_show = \"builtin_op_log_compact\"\n</code></pre> <p>If you want to see the full description when you do <code>jj log</code> you can add this to your config:</p> <pre><code>[templates]\nlog = \"builtin_log_compact_full_description\"\n</code></pre>"},{"location":"config.html#graph-style","title":"Graph style","text":"<pre><code>[ui]\n# Possible values: \"curved\" (default), \"square\", \"ascii\", \"ascii-large\"\ngraph.style = \"square\"\n</code></pre>"},{"location":"config.html#node-style","title":"Node style","text":"<p>The symbols used to represent commits or operations can be customized via templates.</p> <ul> <li><code>templates.log_node</code> for commits (with <code>Option&lt;Commit&gt;</code> keywords)</li> <li><code>templates.op_log_node</code> for operations (with <code>Operation</code> keywords)</li> </ul> <p>For example:</p> <pre><code>[templates]\nlog_node = '''\ncoalesce(\n  if(!self, \"\ud83e\udf80\"),\n  if(current_working_copy, \"@\"),\n  if(root, \"\u2534\"),\n  if(immutable, \"\u25cf\", \"\u25cb\"),\n)\n'''\nop_log_node = 'if(current_operation, \"@\", \"\u25cb\")'\n</code></pre>"},{"location":"config.html#wrap-log-content","title":"Wrap log content","text":"<p>If enabled, <code>log</code>/<code>evolog</code>/<code>op log</code> content will be wrapped based on the terminal width.</p> <pre><code>[ui]\nlog-word-wrap = true\n</code></pre>"},{"location":"config.html#display-of-commit-and-change-ids","title":"Display of commit and change ids","text":"<p>Can be customized by the <code>format_short_id()</code> template alias.</p> <pre><code>[template-aliases]\n# Highlight unique prefix and show at least 12 characters (default)\n'format_short_id(id)' = 'id.shortest(12)'\n# Just the shortest possible unique prefix\n'format_short_id(id)' = 'id.shortest()'\n# Show unique prefix and the rest surrounded by brackets\n'format_short_id(id)' = 'id.shortest(12).prefix() ++ \"[\" ++ id.shortest(12).rest() ++ \"]\"'\n# Always show 12 characters\n'format_short_id(id)' = 'id.short(12)'\n</code></pre> <p>To customize these separately, use the <code>format_short_commit_id()</code> and <code>format_short_change_id()</code> aliases:</p> <pre><code>[template-aliases]\n# Uppercase change ids. `jj` treats change and commit ids as case-insensitive.\n'format_short_change_id(id)' = 'format_short_id(id).upper()'\n</code></pre> <p>Operation ids can be customized by the <code>format_short_operation_id()</code> alias:</p> <pre><code>[template-aliases]\n# Always show 12 characters\n'format_short_operation_id(id)' = 'id.short(12)'\n</code></pre> <p>To get shorter prefixes for certain revisions, set <code>revsets.short-prefixes</code>:</p> <pre><code>[revsets]\n# Prioritize the current bookmark\nshort-prefixes = \"(main..@)::\"\n</code></pre>"},{"location":"config.html#relative-timestamps","title":"Relative timestamps","text":"<p>Can be customized by the <code>format_timestamp()</code> template alias.</p> <pre><code>[template-aliases]\n# Full timestamp in ISO 8601 format\n'format_timestamp(timestamp)' = 'timestamp'\n# Relative timestamp rendered as \"x days/hours/seconds ago\"\n'format_timestamp(timestamp)' = 'timestamp.ago()'\n</code></pre> <p><code>jj op log</code> defaults to relative timestamps. To use absolute timestamps, you will need to modify the <code>format_time_range()</code> template alias.</p> <pre><code>[template-aliases]\n'format_time_range(time_range)' = 'time_range.start() ++ \" - \" ++ time_range.end()'\n</code></pre>"},{"location":"config.html#author-format","title":"Author format","text":"<p>Can be customized by the <code>format_short_signature()</code> template alias.</p> <pre><code>[template-aliases]\n# Full email address (default)\n'format_short_signature(signature)' = 'signature.email()'\n# Both name and email address\n'format_short_signature(signature)' = 'signature'\n# Username part of the email address\n'format_short_signature(signature)' = 'signature.email().local()'\n</code></pre>"},{"location":"config.html#commit-timestamp","title":"Commit timestamp","text":"<p>Commits have both an \"author timestamp\" and \"committer timestamp\". By default, jj displays the committer timestamp, but can be changed to show the author timestamp instead.</p> <p>The function must return a timestamp because the return value will likely be formatted with <code>format_timestamp()</code>.</p> <pre><code>[template-aliases]\n'commit_timestamp(commit)' = 'commit.author().timestamp()'\n</code></pre>"},{"location":"config.html#signature-format","title":"Signature format","text":"<p>Can be enabled with <code>ui.show-cryptographic-signatures</code>, and customized with <code>format_short_cryptographic_signature(sig)</code> and <code>format_detailed_cryptographic_signature(sig)</code>.</p> <p>Note that the formatting functions take an <code>Option&lt;CryptographicSignature&gt;</code>. This allows you to emit a custom message if a signature is not present, but will raise an error if you try to access methods on a signature that is not available.</p> <pre><code>[ui]\n# default is false\nshow-cryptographic-signatures = true\n\n[template-aliases]\n'format_short_cryptographic_signature(sig)' = '''\n  if(sig,\n    sig.status(),\n    \"(no sig)\",\n  )\n'''\n</code></pre>"},{"location":"config.html#pager","title":"Pager","text":"<p>By default, jj will paginate output that would scroll off the screen. It does this by passing output through <code>less -FRX</code> on most platforms (on Windows it uses the pager that is built-in to jj).</p> <p>Which pager to use can be customized by setting <code>ui.pager</code>. When choosing a pager, ensure that it either supports color codes or that you disable color (see Colorizing output).</p> <p>Examples:</p> <pre><code># Pipe output through `less -FRX` (default on non-Windows platforms)\n$ jj config set --user ui.pager \"less -FRX\"\n\n# Use the built-in pager (default on Windows)\n$ jj config set --user ui.pager :builtin\n\n# Use `$PAGER` environment variable if set (on non-Windows platforms)\n$ jj config set --user ui.pager '[\"sh\", \"-c\", \"exec ${PAGER:-less -FRX}\"]'\n</code></pre> <p>Additionally, paging behavior can be toggled via <code>ui.paginate</code> like so:</p> <pre><code>[ui]\n# Enable pagination for commands that support it (default)\npaginate = \"auto\"\n# Disable all pagination, equivalent to using --no-pager\npaginate = \"never\"\n</code></pre>"},{"location":"config.html#builtin-pager","title":"Builtin pager","text":"<p>Our builtin pager is based on <code>streampager</code> but is configured within <code>jj</code>'s config. It is configured via the <code>ui.streampager</code> table.</p>"},{"location":"config.html#key-bindings","title":"Key bindings","text":"<p>The built-in pager supports both navigation via arrows and Vim-style navigation. Beyond that, here are some useful keybindings for the pager:</p> Key Action <code>Ctrl-c</code> or <code>q</code> Quit <code>h</code> or <code>F1</code> Show all key bindings <code>Esc</code> Close help or prompt <code>\\</code> Toggle line wrapping <code>#</code> Toggle line numbers <code>Ctrl-r</code> Toggle the ruler <p>The built-in pager does not support mouse input.</p>"},{"location":"config.html#wrapping-config","title":"Wrapping config","text":"<p>Wrapping performed by the pager happens in addition to any wrapping that <code>jj</code> itself does.</p> <pre><code>[ui.streampager]\nwrapping = \"anywhere\"  # wrap at screen edge (default)\nwrapping = \"word\"      # wrap on word boundaries\nwrapping = \"none\"      # strip long lines, allow scrolling\n                       # left and right like `less -S`\n</code></pre>"},{"location":"config.html#auto-exit-clearing-the-screen-on-startup-or-exit","title":"Auto-exit, clearing the screen on startup or exit","text":"<p>You can configure whether the pager clears the screen on startup or exit, and whether it quits automatically on short inputs. When the pager auto-quits, features like word-wrapping are disabled.</p> <pre><code>[ui.streampager]\n# Do not clear screen on exit. Use a full-screen interface for long\n# output only. Like `less -FX`.\ninterface = \"quit-if-one-page\"  # (default).\n# Always use a full-screen interface, ask the terminal to clear the\n# screen on exit. Like `less -+FX`.\ninterface = \"full-screen-clear-output\"\n# Use the alternate screen if the input is either long or takes more\n# than 2 seconds to finish. Similar but not identical to `less -F -+X`.\ninterface = \"quit-quickly-or-clear-output\"\n</code></pre>"},{"location":"config.html#showing-the-ruler-on-startup","title":"Showing the ruler on startup","text":"<pre><code>[ui.streampager]\n# Start with the ruler showing\nshow-ruler = true # (default)\n# Start with the ruler hidden\nshow-ruler = false\n</code></pre>"},{"location":"config.html#processing-contents-to-be-paged","title":"Processing contents to be paged","text":"<p>If you'd like to pass the output through a formatter e.g. <code>diff-so-fancy</code> before piping it through a pager you must do it using a subshell as, unlike <code>git</code> or <code>hg</code>, the command will be executed directly. For example:</p> <pre><code>[ui]\npager = [\"sh\", \"-c\", \"diff-so-fancy | less -RFX\"]\n</code></pre> <p>Some formatters (like <code>delta</code>) require git style diffs for formatting. You can configure this style of diff as the default with the <code>ui.diff-formatter</code> setting. For example:</p> <pre><code>[ui]\npager = \"delta\"\ndiff-formatter = \":git\"\n</code></pre>"},{"location":"config.html#aliases","title":"Aliases","text":"<p>You can define aliases for commands, including their arguments. For example:</p> <pre><code>[aliases]\n# `jj l` shows commits on the working-copy commit's (anonymous) bookmark\n# compared to the `main` bookmark\nl = [\"log\", \"-r\", \"(main..@):: | (main..@)-\"]\n</code></pre> <p>This alias syntax can only run a single jj command. However, you may want to execute multiple jj commands with a single alias, or run arbitrary scripts that complement your version control workflow. This can be done, but be aware of the danger:</p> <p>Warning</p> <p>The following technique just provides a convenient syntax for running arbitrary code on your system. Using it irresponsibly may cause damage ranging from breaking the behavior of <code>jj undo</code> to wiping your file system. Exercise the same amount of caution while writing these aliases as you would when typing commands into the terminal!</p> <p>This feature may be removed or replaced by an embedded scripting language in the future.</p> <p>The command <code>jj util exec</code> will simply run any command you pass to it as an argument. Additional arguments are passed through. Here are some examples:</p> <pre><code>[aliases]\nmy-script = [\"util\", \"exec\", \"--\", \"my-jj-script\"]\n#                            ^^^^\n# This makes sure that flags are passed to your script instead of parsed by jj.\nmy-inline-script = [\"util\", \"exec\", \"--\", \"bash\", \"-c\", \"\"\"\nset -euo pipefail\necho \"Look Ma, everything in one file!\"\necho \"args: $@\"\n\"\"\", \"\"]\n#    ^^\n# This last empty string will become \"$0\" in bash, so your actual arguments\n# are all included in \"$@\" and start at \"$1\" as expected.\n</code></pre> <p>Note: Shebangs (e.g. <code>#!/usr/bin/env</code>) aren't necessary since you're already explicitly passing your script into the right shell.</p>"},{"location":"config.html#editor","title":"Editor","text":"<p>The default editor is set via <code>ui.editor</code>, though there are several places to set it. The priority is as follows (environment variables are marked with a <code>$</code>):</p> <p><code>$JJ_EDITOR</code> &gt; <code>ui.editor</code> &gt; <code>$VISUAL</code> &gt; <code>$EDITOR</code></p> <p>Nano is the default editor (Notepad on Windows) in the absence of any other setting, but you could set it explicitly too.</p> <pre><code>[ui]\neditor = \"pico\"\n</code></pre> <p>To use NeoVim instead:</p> <pre><code>[ui]\neditor = \"nvim\"\n</code></pre> <p>For GUI editors you possibly need to use a <code>-w</code> or <code>--wait</code>. Some examples:</p> <pre><code>[ui]\neditor = \"code -w\"       # VS Code\neditor = \"code.cmd -w\"   # VS Code on Windows\neditor = \"bbedit -w\"     # BBEdit\neditor = \"subl -n -w\"    # Sublime Text\neditor = \"mate -w\"       # TextMate\neditor = [\"C:/Program Files/Notepad++/notepad++.exe\",\n    \"-multiInst\", \"-notabbar\", \"-nosession\", \"-noPlugin\"] # Notepad++\neditor = \"idea --temp-project --wait\"   #IntelliJ\n</code></pre> <p>Obviously, you would only set one line, don't copy them all in!</p>"},{"location":"config.html#editing-diffs","title":"Editing diffs","text":"<p>The <code>ui.diff-editor</code> setting affects the default tool used for editing diffs (e.g. <code>jj split</code>, <code>jj squash -i</code>). If it is not set, the special value <code>:builtin</code> is used. It launches a built-in TUI tool (known as scm-diff-editor) to edit the diff in your terminal.</p> <p>You can try a different tool temporarily by doing e.g. <code>jj split --tool meld</code> or you can set the option to change the default. This requires that you have an appropriate tool installed, see for example the instructions for using Meld.</p> <p>Suggestion: If possible, it is recommended to try an external diff tool like Meld (see below for some other possibilities) for splitting commits and other diff editing, in addition to the built-in diff editor. It is good to know the capabilities of both. The built-in diff editor does not require external tools to be available, is faster for tasks like picking hunks, and does not require leaving the terminal. External tools give you the flexibility of picking out portions of lines from the diff or even arbitrarily editing the text of the files.</p> <p>If <code>ui.diff-editor</code> is a string, e.g. <code>\"meld\"</code>, the arguments will be read from the following config keys.</p> <pre><code>[merge-tools.meld]\n# program = \"meld\"      # Defaults to the name of the tool if not specified\nprogram = \"/path/to/meld\" # May be necessary if `meld` is not in the PATH\nedit-args = [\"--newtab\", \"$left\", \"$right\"]\n</code></pre> <p><code>jj</code> makes the following substitutions:</p> <ul> <li> <p><code>$left</code> and <code>$right</code> are replaced with the paths to the left and right   directories to diff respectively.</p> </li> <li> <p>If no <code>edit-args</code> are specified, <code>[\"$left\", \"$right\"]</code> are set by default.</p> </li> <li> <p>If <code>edit-args = []</code>, <code>jj</code> will refuse to use this tool for diff editing. This is a way to explicitly state that a certain tool (e.g. <code>mergiraf</code>) does not work for diff editing.</p> </li> </ul> <p>Finally, <code>ui.diff-editor</code> can be a list that specifies a command and its arguments.</p> <p>Some examples:</p> <pre><code>[ui]\n# Use merge-tools.meld.edit-args\ndiff-editor = \"meld\"  # Or `kdiff3`, or `diffedit3`, ...\n# Specify edit-args inline\ndiff-editor = [\"/path/to/binary\", \"--be-helpful\", \"$left\", \"$right\"]\n# Equivalent to [\"binary\", \"$left\", \"$right\"] arguments by default\ndiff-editor = \"binary\"\n</code></pre>"},{"location":"config.html#experimental-3-pane-diff-editing","title":"Experimental 3-pane diff editing","text":"<p>We offer two special \"3-pane\" diff editor configs:</p> <ul> <li><code>meld-3</code>, which requires installing Meld, and</li> <li><code>diffedit3</code>, which requires installing <code>diffedit3</code>.</li> </ul> <p><code>Meld</code> is a graphical application that is recommended, but can be difficult to install in some situations. <code>diffedit3</code> is designed to be easy to install and to be usable in environments where Meld is difficult to use (e.g. over SSH via port forwarding). <code>diffedit3</code> starts a local server that can be accessed via a web browser, similarly to Jupyter.</p> <p>There is also the <code>diffedit3-ssh</code> which is similar to <code>diffedit3</code> but does not try to open the web browser pointing to the local server (the URL printed to the terminal) automatically. <code>diffedit3-ssh</code> also always uses ports in between 17376-17380 and fails if they are all busy. This can be useful when working over SSH. Open the fold below for more details of how to set that up.</p>  Tips for using `diffedit3-ssh` over SSH   To use `diffedit3` over SSH, you need to set up port forwarding. One way to do this is to start SSH as follows (copy-paste the relevant lines):  <pre><code>ssh -L 17376:localhost:17376 \\\n    -L 17377:localhost:17377 \\\n    -L 17378:localhost:17378 \\\n    -L 17379:localhost:17379 \\\n    -L 17380:localhost:17380 \\\n    myhost.example.com\n</code></pre>  `diffedit3-ssh` is set up to use these 5 ports by default. Usually, only the first of them will be used. The rest are used if another program happens to use one of them, or if you run multiple instances of `diffedit3` at the same time.  Another way is to add a snippet to `~/.ssh/config`:  <pre><code>Host myhost\n    User     myself\n    Hostname myhost.example.com\n    LocalForward 17376 localhost:17376\n    LocalForward 17377 localhost:17377\n    LocalForward 17378 localhost:17378\n    LocalForward 17379 localhost:17379\n    LocalForward 17380 localhost:17380\n</code></pre>  With that configuration, you should be able to simply `ssh myhost`.   <p>Setting either <code>ui.diff-editor = \"meld-3\"</code> or <code>ui.diff-editor = \"diffedit3\"</code> will result in the diff editor showing 3 panes: the diff on the left and right, and an editing pane in the middle. This allow you to see both sides of the original diff while editing.</p> <p>If you use <code>ui.diff-editor = \"meld-3\"</code>, note that you can still get the 2-pane Meld view using <code>jj diff --tool meld</code>. <code>diffedit3</code> has a button you can use to switch to a 2-pane view.</p> <p>To configure other diff editors in this way, you can include <code>$output</code> together with <code>$left</code> and <code>$right</code> in <code>merge-tools.TOOL.edit-args</code>. <code>jj</code> will replace <code>$output</code> with the directory where the diff editor will be expected to put the result of the user's edits. Initially, the contents of <code>$output</code> will be the same as the contents of <code>$right</code>.</p>"},{"location":"config.html#jj-instructions","title":"<code>JJ-INSTRUCTIONS</code>","text":"<p>When editing a diff, jj will include a synthetic file called <code>JJ-INSTRUCTIONS</code> in the diff with instructions on how to edit the diff. Any changes you make to this file will be ignored. To suppress the creation of this file, set <code>ui.diff-instructions = false</code>.</p>"},{"location":"config.html#using-meld-as-a-diff-editor","title":"Using Meld as a diff editor","text":"<p>Meld is a nice and polished free diff editor. It can be obtained as follows:</p> <ul> <li> <p>Linux: use your favorite package manager, e.g. <code>sudo apt install meld</code>.</p> </li> <li> <p>Windows: Meld can be downloaded from https://meldmerge.org/.</p> </li> <li> <p>Mac OS: Install Homebrew and run <code>brew install --cask meld</code>.   This will install both an app in <code>/Applications/Meld.app</code> and the command-line   <code>meld</code> command that <code>jj</code> uses. You can read about more details and other   options but,   as of this writing, this is by far the easiest.</p> </li> </ul> <p><code>jj</code> has two diff editing configurations that use Meld: <code>meld</code> for a 2-pane view and <code>meld-3</code> for a three-pane view.</p> <p>There is also a <code>meld</code> merge tool that can be useful, but does not support displaying the merge base while merging.</p>"},{"location":"config.html#using-vim-as-a-diff-editor","title":"Using Vim as a diff editor","text":"<p>Using <code>ui.diff-editor = \"vimdiff\"</code> is possible but not recommended. For a better experience, you can follow instructions from the Wiki to configure the DirDiff Vim plugin and/or the vimtabdiff Python script.</p>"},{"location":"config.html#3-way-merge-tools-for-conflict-resolution","title":"3-way merge tools for conflict resolution","text":"<p>The <code>ui.merge-editor</code> key specifies the tool used for three-way merge tools by <code>jj resolve</code>. For example:</p> <pre><code>[ui]\n# Use merge-tools.meld.merge-args\nmerge-editor = \"meld\"  # Or \"vscode\" or \"vscodium\" or \"kdiff3\" or \"vimdiff\"\n# Specify merge-args inline\nmerge-editor = [\"meld\", \"$left\", \"$base\", \"$right\", \"-o\", \"$output\"]\n</code></pre> <p>The following tools can be used out of the box, as long as they are installed:</p> <ul> <li>\"kdiff3\"</li> <li>\"meld\"</li> <li>\"mergiraf\"</li> <li>\"smerge\"</li> <li>\"vimdiff\"</li> <li>\"vscode\"</li> <li>\"vscodium\"</li> </ul> <p>Using VS Code as a merge tool works well with VS Code's Remote Development functionality, as long as <code>jj</code> is called from VS Code's terminal.</p>"},{"location":"config.html#setting-up-a-custom-merge-tool","title":"Setting up a custom merge tool","text":"<p>To use a different tool named <code>TOOL</code>, the arguments to pass to the tool MUST be specified either inline or in the <code>merge-tools.TOOL.merge-args</code> key. As an example of how to set this key and other tool configuration options, here is the out-of-the-box configuration of the three default tools. (There is no need to copy it to your config file verbatim, but you are welcome to customize it.)</p> <pre><code>[merge-tools.kdiff3]\n# program  = \"kdiff3\"     # Defaults to the name of the tool if not specified\nmerge-args = [\"$base\", \"$left\", \"$right\", \"-o\", \"$output\", \"--auto\"]\n[merge-tools.meld]\nmerge-args = [\"$left\", \"$base\", \"$right\", \"-o\", \"$output\", \"--auto-merge\"]\n\n[merge-tools.vimdiff]\nmerge-args = [\"-f\", \"-d\", \"$output\", \"-M\",\n    \"$left\", \"$base\", \"$right\",\n    \"-c\", \"wincmd J\", \"-c\", \"set modifiable\",\n    \"-c\", \"set write\"]\nprogram = \"vim\"\nmerge-tool-edits-conflict-markers = true    # See below for an explanation\n</code></pre> <p><code>jj</code> makes the following substitutions:</p> <ul> <li> <p><code>$output</code> (REQUIRED) is replaced with the name of the file that the merge tool   should output. <code>jj</code> will read this file after the merge tool exits.</p> </li> <li> <p><code>$left</code> and <code>$right</code> are replaced with the paths to two files containing the   content of each side of the conflict.</p> </li> <li> <p><code>$base</code> is replaced with the path to a file containing the contents of the   conflicted file in the last common ancestor of the two sides of the conflict.</p> </li> <li> <p><code>$marker_length</code> is replaced with the length of the conflict markers which   should be used for the file. This can be useful if the merge tool parses   and/or generates conflict markers. Usually, <code>jj</code> uses conflict markers of   length 7, but they can be longer if necessary to make parsing unambiguous.</p> </li> <li> <p><code>$path</code> is replaced with the path in the repository at which the file   will be eventually stored. It is relative to the root directory of the   repository and uses <code>/</code> as separators.</p> </li> </ul> <p>Unlike <code>diff-args</code> or <code>edit-args</code>, there is no default value for <code>merge-args</code>. If <code>merge-args</code> are not specified, the tool cannot be used for conflict resolution.</p>"},{"location":"config.html#editing-conflict-markers-with-a-tool-or-a-text-editor","title":"Editing conflict markers with a tool or a text editor","text":"<p>By default, the merge tool starts with an empty output file. If the tool puts anything into the output file and exits with the 0 exit code, <code>jj</code> assumes that the conflict is fully resolved, while if the tool exits with a non-zero exit code, <code>jj</code> assumes that the merge should be canceled. This is appropriate for most graphical merge tools.</p> <p>For merge tools which try to automatically resolve conflicts without user input, this behavior may not be desired. For instance, some automatic merge tools use an exit code of 1 to indicate that some conflicts were unable to be resolved and that the output file should contain conflict markers. In that case, you could set the config option <code>merge-tools.TOOL.merge-conflict-exit-codes = [1]</code> to tell <code>jj</code> to expect conflict markers in the output file if the exit code is 1. If a merge tool produces output using Git's \"diff3\" conflict style, <code>jj</code> should be able to parse it correctly, so many Git merge drivers should be usable with <code>jj</code> as well.</p> <p>Some tools (e.g. <code>vimdiff</code>) can present a multi-way diff but don't resolve conflict themselves. When using such tools, <code>jj</code> can help you by populating the output file with conflict markers before starting the merge tool (instead of leaving the output file empty and letting the merge tool fill it in). To do that, set the <code>merge-tools.vimdiff.merge-tool-edits-conflict-markers = true</code> option.</p> <p>With this option set, if the output file still contains conflict markers after the conflict is done, <code>jj</code> assumes that the conflict was only partially resolved and parses the conflict markers to get the new state of the conflict. The conflict is considered fully resolved when there are no conflict markers left. The conflict marker style can also be customized per tool using the <code>merge-tools.TOOL.conflict-marker-style</code> option, which takes the same values as <code>ui.conflict-marker-style</code>.</p>"},{"location":"config.html#code-formatting-and-other-file-content-transformations","title":"Code formatting and other file content transformations","text":"<p>The <code>jj fix</code> command allows you to efficiently rewrite files in complex commit graphs with no risk of introducing conflicts, using tools like <code>clang-format</code> or <code>prettier</code>. The tools run as subprocesses that take a file content on standard input and repeat it, with any desired changes, on standard output.</p> <p>This enables the command to format many versions of the same file concurrently and without touching on the working copy. The local files are not and must not be used.</p> <p>The file is only rewritten if the subprocess produces a successful exit code.</p>"},{"location":"config.html#configuration_1","title":"Configuration","text":"<p>Tools are defined in a table where the keys are arbitrary identifiers and the values have the following properties:</p> <ul> <li><code>command</code>: The arguments used to run the tool. The first argument is the    path to an executable file. Arguments can contain these variables that will    be replaced:<ul> <li><code>$root</code> will be replaced with the workspace root path (the directory    containing the .jj directory).</li> <li><code>$path</code> will be replaced with the repo-relative path of the file being    fixed. It is useful to provide the path to tools that include the path    in error messages, or behave differently based on the directory or file    name.</li> </ul> </li> <li><code>patterns</code>: List of filesets (see: <code>jj help -k filesets</code>), determining    which files the tool will affect based on their path. If this list is    empty, no files will be affected by the tool. If there are multiple    patterns, the tool is applied only once to each file in the union of the    patterns.</li> <li><code>enabled</code>: Enables or disables the tool. If omitted, the tool is enabled.    This is useful for defining disabled tools in user configuration that can    be enabled in individual repositories with one config setting.</li> </ul> <p><code>jj fix</code> provides the file content anonymously on standard input, but the name of the file being formatted may be important for include sorting or other output like error messages. To address this, you can use the <code>$root</code> and <code>$path</code> in your arguments.</p>"},{"location":"config.html#enforce-coding-style-rules","title":"Enforce coding style rules","text":"<p>Suppose you want to use <code>clang-format</code> to format your <code>*.c</code> and <code>*.h</code> files, as well as sorting their <code>#include</code> directives.</p> <pre><code>[fix.tools.clang-format]\ncommand = [\"/usr/bin/clang-format\", \"--sort-includes\", \"--assume-filename=$path\"]\npatterns = [\"glob:'**/*.c'\",\n            \"glob:'**/*.h'\"]\n</code></pre>"},{"location":"config.html#sort-and-remove-duplicate-lines-from-a-file","title":"Sort and remove duplicate lines from a file","text":"<p><code>jj fix</code> can also be used with tools that are not considered code formatters.</p> <p>Suppose you have a list of words in a text file in your repository, and you want to keep the file sorted alphabetically and remove any duplicate words.</p> <pre><code>[fix.tools.sort-word-list]\ncommand = [\"sort\", \"-u\"]\npatterns = [\"word_list.txt\"]\n</code></pre>"},{"location":"config.html#tools-stored-inside-the-workspace","title":"Tools stored inside the workspace","text":"<p>Some fix tools may be stored inside the workspace. For example, a binary may be stored inside <code>node_modules</code>. Use the <code>$root</code> variable to create an absolute path to such a program:</p> <pre><code>[fix.tools.biome]\n\n# Linux and macOS\ncommand = [\"$root/node_modules/@biomejs/cli-linux-x64/biome\"]\n\n# Windows\ncommand = [\"$root\\\\node_modules\\\\@biomejs\\\\cli-win32-x64\\\\biome.exe\"]\n</code></pre>"},{"location":"config.html#execution-order-of-tools","title":"Execution order of tools","text":"<p>If two or more tools affect the same file, they are executed in the ascending lexicographical order of their configured names. Any tool, but the first one to be executed, get as input the content of the file produced by the previous tool. This will remain as a tie breaker if other ordering mechanisms are introduced in the future.</p> <p>If you use numbers in tool names to control execution order, remember to include enough leading zeros so that, for example, <code>09</code> sorts before <code>10</code>.</p> <p>Suppose you want to keep only the 10 smallest numbers in a text file that contains one number on each line. This can be accomplished with <code>sort</code> and <code>head</code>, but execution order is important.</p> <pre><code>[fix.tools.1-sort-numbers-file]\ncommand = [\"sort\", \"-n\"]\npatterns = [\"numbers.txt\"]\n\n[fix.tools.2-truncate-numbers-file]\ncommand = [\"head\", \"-n\", \"10\"]\npatterns = [\"numbers.txt\"]\n</code></pre>"},{"location":"config.html#disabling-and-enabling-tools","title":"Disabling and enabling tools","text":"<p>Tools can be disabled and enabled with the optional <code>enabled</code> config. This allows you to define tools globally but enable them only for specific repositories.</p> <p>In the user configuration, define a disabled tool for running rustfmt:</p> <pre><code>[fix.tools.rustfmt]\nenabled = false\ncommand = [\"rustfmt\", \"--emit\", \"stdout\"]\npatterns = [\"glob:'**/*.rs'\"]\n</code></pre> <p>Then to use the tool in a specific repository, set the <code>enabled</code> config:</p> <pre><code>$ jj config set --repo fix.tools.rustfmt.enabled true\n</code></pre>"},{"location":"config.html#commit-signing","title":"Commit Signing","text":"<p><code>jj</code> can be configured to sign and verify the commits it creates using either GnuPG or SSH signing keys.</p> <p>To do this you need to configure a signing backend.</p> <p>Setting the backend to <code>\"none\"</code> disables signing.</p>"},{"location":"config.html#gnupg-signing","title":"GnuPG Signing","text":"<pre><code>[signing]\nbehavior = \"own\"\nbackend = \"gpg\"\n## You can set `key` to anything accepted by `gpg -u`\n## If not set then defaults to the key associated with `user.email`\n# key = \"4ED556E9729E000F\"\n# key = \"signing@example.com\"\n</code></pre> <p>By default the gpg backend will look for a <code>gpg</code> binary on your path. If you want to change the program used or specify a path to <code>gpg</code> explicitly you can set:</p> <pre><code>[signing]\nbackends.gpg.program = \"gpg2\"\n</code></pre> <p>Also by default the gpg backend will consider key expiry when verifying commit signatures. To consider expired keys as valid you can set:</p> <pre><code>[signing]\nbackends.gpg.allow-expired-keys = true\n</code></pre>"},{"location":"config.html#pkcs12-certificates","title":"PKCS#12 Certificates","text":"<p>PKCS#12 certificates can be used to sign commits using the <code>gpgsm</code> backend.</p> <pre><code>[signing]\nbehavior = \"own\"\nbackend = \"gpgsm\"\n## You can set `key` to anything accepted by `gpgsm -u`\n## If not set then defaults to the key associated with `user.email`\n# key = \"4ED556E9729E000F\"\n# key = \"signing@example.com\"\n</code></pre> <p>By default the gpgsm backend will look for a <code>gpgsm</code> binary on your path. If you want to change the program used or specify a path to <code>gpgsm</code> explicitly you can set:</p> <pre><code>[signing]\nbackends.gpgsm.program = \"gpgsm\"\n</code></pre> <p>Also by default the gpgsm backend will consider key expiry when verifying commit signatures. To consider expired keys as valid you can set:</p> <pre><code>[signing]\nbackends.gpgsm.allow-expired-keys = true\n</code></pre>"},{"location":"config.html#ssh-signing","title":"SSH Signing","text":"<pre><code>[signing]\nbehavior = \"own\"\nbackend = \"ssh\"\nkey = \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIGj+J6N6SO+4P8dOZqfR1oiay2yxhhHnagH52avUqw5h\"\n## You can also use a path instead of embedding the key\n# key = \"~/.ssh/id_for_signing.pub\"\n</code></pre> <p>By default the ssh backend will look for a <code>ssh-keygen</code> binary on your path. If you want to change the program used or specify a path to <code>ssh-keygen</code> explicitly you can set:</p> <pre><code>[signing]\nbackends.ssh.program = \"/path/to/ssh-keygen\"\n</code></pre> <p>When verifying commit signatures the ssh backend needs to be provided with an allowed-signers file containing the public keys of authors whose signatures you want to be able to verify.</p> <p>You can find the format for this file in the ssh-keygen man page. This can be provided as follows:</p> <pre><code>[signing]\nbackends.ssh.allowed-signers = \"/path/to/allowed-signers\"\n</code></pre> <p>Additionally, an SSH KRL or list of revoked public keys (see ssh-keygen man page) can be provided with the <code>revocation-list</code> option. If a public key is found in this file then any signature relating to it is marked as invalid.</p> <pre><code>[signing]\nbackends.ssh.revocation-list = \"/path/to/revocation-list\"\n</code></pre>"},{"location":"config.html#manually-signing-commits","title":"Manually signing commits","text":"<p>You can use <code>jj sign</code>/<code>jj unsign</code> to sign/unsign commits manually.</p> <p>Warning</p> <p><code>jj sign</code> always signs commits, even if they are already signed by the user. While this is cumbersome for users signing via hardware devices, we cannot reliably check if a commit is already signed without creating a signature (see this issue).</p>"},{"location":"config.html#automatically-signing-commits","title":"Automatically signing commits","text":"<p>The <code>signing.behavior</code> configuration option has four different options for what to do with signing commits on modification of a change (e.g., rebasing or edits).</p> <ul> <li><code>drop</code>: do not automatically sign; if a change was signed before   modification, drop that signing after modification.</li> <li><code>keep</code>: if a change was signed before modification, and it was authored by   you, attempt to sign it again after the modification.</li> <li><code>own</code>: sign all commits that were authored by you when you modify them.</li> <li><code>force</code>: sign all commits after modification, always, even if you are not the   author.</li> </ul> <p>Instead of signing all commits during creation when <code>signing.behavior</code> is set to <code>own</code>, the <code>git.sign-on-push</code> configuration can be used to sign commits only upon running <code>jj git push</code>. All mutable unsigned commits being pushed will be signed prior to pushing. This might be preferred if the signing backend requires user interaction or is slow, so that signing is performed in a single batch operation.</p> <pre><code># Configure signing backend as before, but lazily signing only on push.\n[signing]\nbehavior = \"drop\"\nbackend = \"ssh\"\nkey = \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIGj+J6N6SO+4P8dOZqfR1oiay2yxhhHnagH52avUqw5h\"\n\n[git]\nsign-on-push = true\n</code></pre>"},{"location":"config.html#commit-signature-verification","title":"Commit Signature Verification","text":"<p>By default signature verification and display is disabled as it incurs a performance cost when rendering medium to large change logs. You can enable it by setting <code>ui.show-cryptographic-signatures</code> to true in your configuration.</p> <p>If you want to display commit signatures in your templates, you can use <code>commit.signature()</code> (see Commit type). The returned CryptographicSignature Type provides methods to retrieve signature details.</p>"},{"location":"config.html#git-settings","title":"Git settings","text":""},{"location":"config.html#default-colocation","title":"Default colocation","text":"<p>When creating a Git-backed Jujutsu repository, they use \"colocated\" mode by default, which places the <code>.git</code> directory next to the <code>.jj</code> directory. Colocation allows some amount of two-way interoperability, but it can perform worse in large repos.</p> <p>The setting <code>git.colocate</code> is a boolean option that controls whether or not the <code>jj git init</code> and <code>jj git clone</code> commands should create colocated workspace by default. Set <code>git.colocate</code> to <code>false</code> to disable it.</p> <p>See Colocated Jujutsu/Git workspaces for more information.</p>"},{"location":"config.html#default-remotes-for-jj-git-fetch-and-jj-git-push","title":"Default remotes for <code>jj git fetch</code> and <code>jj git push</code>","text":"<p>By default, if a single remote exists it is used for <code>jj git fetch</code> and <code>jj git push</code>; however if multiple remotes exist, the default remote is assumed to be named <code>\"origin\"</code>, just like in Git. Sometimes this is undesirable, e.g. when you want to fetch from a different remote than you push to, such as a GitHub fork.</p> <p>To change this behavior, you can modify the repository configuration variable <code>git.fetch</code>, which can be a single remote, or a list of remotes to fetch from multiple places:</p> <pre><code>jj config set --repo git.fetch \"upstream\"\njj config set --repo git.fetch '[\"origin\", \"upstream\"]'\n</code></pre> <p>By default, the specified pattern matches remote names with glob syntax. You can also use other string pattern syntax:</p> <pre><code>jj config set --repo git.fetch \"regex:'^(remote|upstream)'\"\njj config set --repo git.fetch '[\"remote*\", \"upstream*\"]'\n</code></pre> <p>Similarly, you can also set the variable <code>git.push</code> to cause <code>jj git push</code> to push to a different remote:</p> <pre><code>jj config set --repo git.push \"github\"\n</code></pre> <p>Note that unlike <code>git.fetch</code>, <code>git.push</code> can currently only be a single remote. This is not a hard limitation, and could be changed in the future if there is demand.</p>"},{"location":"config.html#automatic-tracking-of-bookmarks","title":"Automatic tracking of bookmarks","text":"<p>You can configure which bookmarks to track automatically per remote, using the <code>remotes.&lt;name&gt;.auto-track-bookmarks</code> config. The value is a string pattern that matches the names of the bookmarks to track. This setting is applied to all new bookmarks, including ones created locally and ones fetched from the remote. For example:</p> <pre><code>[remotes.origin]\nauto-track-bookmarks = \"*\"\n</code></pre> <p>This will simply track all bookmarks for the remote \"origin\". There are various reasons to restrict which bookmarks to track:</p> <ul> <li> <p>When collaborating with other people via the same remote, you may not want to   track all the bookmarks of your collaborators. Similarly, you may not want to   push some of your bookmarks to the remote at all; these may only be intended   for local use. Many people use a \"personal prefix\" in their bookmark names.   This marks a bookmark as belonging to one person, making it possible to track   and push only bookmarks with that prefix. For example, Alice may set her   configuration like so:</p> <pre><code>[remotes.origin]\nauto-track-bookmarks = \"alice/*\"\n</code></pre> <p>That way, bookmarks pushed by other people (who probably use a different prefix or none at all) are not tracked automatically. At the same time, Alice can create bookmarks without the prefix for local-only use. You can also configure Jujutsu to use your prefix for generated bookmark names; see the section \"Generated bookmark names on push\".</p> </li> <li> <p>Another reason to restrict the bookmarks to track may be that you're not   collaborating with people using the same remote, but a different one. For   example, if you make a fork on GitHub, your fork will usually be called   \"origin\", while the repository you forked from is usually called \"upstream\".   In that case, you may want to track all bookmarks from your fork, but only the   \"main\" bookmark from upstream. Here's an example how to achieve that:</p> <pre><code>[remotes.origin]\nauto-track-bookmarks = \"*\"\n[remotes.upstream]\nauto-track-bookmarks = \"main\"\n</code></pre> </li> <li> <p>If you're collaborating with people on the same remote, but your bookmark   names don't follow a pattern that allows a bookmark's \"owner\" to be identified   (e.g. <code>alice/*</code>), you can use <code>auto-track-created-bookmarks</code> instead:</p> <pre><code>[remotes.origin]\nauto-track-created-bookmarks = \"*\"\n</code></pre> <p>This pattern will only apply to bookmarks you create with <code>jj bookmark create</code> and <code>jj bookmark set</code>. The disadvantage of this option is the fact that you will have to track your own bookmarks manually if you fetch them from the remote. This may happen regularly if you use multiple computers to work on the same project.</p> </li> <li> <p>Lastly, you may be working on various projects with different conventions for   bookmark names. In that case, it can be handy to apply different configuration   to different (groups of) repositories. Read about how to do that in the   section \"Conditional variables\".</p> </li> </ul>"},{"location":"config.html#automatic-local-bookmark-creation-on-jj-git-clone","title":"Automatic local bookmark creation on <code>jj git clone</code>","text":"<p>When cloning a new Git repository, <code>jj</code> by default creates a local bookmark tracking the default remote bookmark (such as <code>main</code> for <code>main@origin</code>.) If you aren't going to update the <code>main</code> bookmark locally, the tracking bookmark isn't necessary.</p> <p>This behavior can be disabled by</p> <pre><code>[git]\ntrack-default-bookmark-on-clone = false\n</code></pre>"},{"location":"config.html#abandon-commits-that-became-unreachable-in-git","title":"Abandon commits that became unreachable in Git","text":"<p>By default, when <code>jj</code> imports refs from Git, it will look for commits that used to be reachable but no longer are reachable. Those commits will then be abandoned, and any descendant commits will be rebased off of them (as usual when commits are abandoned). You can disable this behavior and instead leave the Git-unreachable commits in your repo by setting:</p> <pre><code>[git]\nabandon-unreachable-commits = false\n</code></pre>"},{"location":"config.html#generated-bookmark-names-on-push","title":"Generated bookmark names on push","text":"<p><code>jj git push --change</code> generates bookmark names with a prefix of \"push-\" by default. You can pick a different prefix and formatting by setting the <code>templates.git_push_bookmark</code> template. For example:</p> <pre><code>[templates]\ngit_push_bookmark = '\"martinvonz/push-\" ++ change_id.short()'\n</code></pre> <p>This template should include expressions like <code>change_id</code> to generate unique and stable bookmark.</p>"},{"location":"config.html#set-of-private-commits","title":"Set of private commits","text":"<p>You can configure the set of private commits by setting <code>git.private-commits</code> to a revset. The value is a revset of commits that Jujutsu will refuse to push. If unset, all commits are eligible to be pushed.</p> <pre><code>[git]\n# Prevent pushing work in progress or anything explicitly labeled \"private\"\nprivate-commits = \"description('wip:*') | description('private:*')\"\n</code></pre> <p>If a commit is in <code>git.private-commits</code> but is already on the remote, then it is not considered a private commit. Commits that are immutable are also excluded from the private set.</p> <p>Private commits prevent their descendants from being pushed, since doing so would require pushing the private commit as well.</p>"},{"location":"config.html#git-subprocessing-behavior","title":"Git subprocessing behavior","text":"<p>Git remote interactions are handled by spawning a <code>git</code> subprocess. If <code>git</code> is not on your OS path, or you want to specify a particular binary, you can:</p> <pre><code>[git]\nexecutable-path = \"/path/to/git\"\n</code></pre>"},{"location":"config.html#merge-settings","title":"Merge settings","text":""},{"location":"config.html#granularity-of-hunks","title":"Granularity of hunks","text":"<p><code>jj</code> by default resolves content conflicts by splitting text into line-level hunks and merge them. This can be configured to split hunks further into word-level hunks.</p> <ul> <li><code>line</code>: split into line hunks (default)</li> <li><code>word</code>: split into word hunks</li> </ul> <pre><code>[merge]\nhunk-level = \"line\"\n</code></pre>"},{"location":"config.html#resolution-of-same-change-conflicts","title":"Resolution of same-change conflicts","text":"<p><code>jj</code> by default resolves conflicts if all sides made the same change. This matches what Git and Mercurial do (in the 3-way case at least), but not what Darcs does. It also means that repeated 3-way merging of multiple trees may give different results depending on the order of merging. To turn it off, set <code>same-change = \"keep\"</code>.</p> <ul> <li><code>keep</code>: leave same-change conflict unresolved</li> <li><code>accept</code>: resolve same-change conflict to new value (default)</li> </ul> <pre><code>[merge]\nsame-change = \"accept\"\n</code></pre>"},{"location":"config.html#filesystem-monitor","title":"Filesystem monitor","text":"<p>In large repositories, it may be beneficial to use a \"filesystem monitor\" to track changes to the working copy. This allows <code>jj</code> to take working copy snapshots without having to rescan the entire working copy.</p> <p>This is governed by the <code>fsmonitor.backend</code> option. Currently, the valid values are <code>\"none\"</code> or <code>\"watchman\"</code>.</p>"},{"location":"config.html#watchman","title":"Watchman","text":"<p>To configure the Watchman filesystem monitor, set <code>fsmonitor.backend = \"watchman\"</code>. Ensure that you have installed the Watchman executable on your system.</p> <p>You can configure <code>jj</code> to use watchman triggers to automatically create snapshots on filesystem changes by setting <code>fsmonitor.watchman.register-snapshot-trigger = true</code>.</p> <p>You can check whether Watchman is enabled and whether it is installed correctly using <code>jj debug watchman status</code>.</p> <p>Note: <code>watchman</code> heavily uses <code>inotify</code> and sets up a user watch per-file. On large repositories, this may cause <code>watchman</code> to fail and commands like <code>jj status</code> to take longer than expected. If you experience this run <code>jj debug watchman status</code> and tune your <code>inotify</code> limits.</p>"},{"location":"config.html#snapshot-settings","title":"Snapshot settings","text":""},{"location":"config.html#paths-to-automatically-track","title":"Paths to automatically track","text":"<p>All new files in the working copy that don't match the ignore patterns are tracked by default. You can set the <code>snapshot.auto-track</code> to set which paths get automatically tracked when they're added to the working copy. See the fileset documentation for the syntax. Files with paths matching ignore files are never tracked automatically.</p> <p>If you set <code>snapshot.auto-track</code> to a non-default value, untracked files can be tracked with <code>jj file track</code>.</p> <p>You can use <code>jj file untrack</code> to untrack a file while keeping it in the working copy. However, first ignore them or remove them from the <code>snapshot.auto-track</code> patterns; otherwise they will be immediately tracked again.</p>"},{"location":"config.html#maximum-size-for-new-files","title":"Maximum size for new files","text":"<p>By default, as an anti-footgun measure, <code>jj</code> will refuse to add new files to the snapshot that are larger than a certain size; the default is 1MiB. This can be changed by setting <code>snapshot.max-new-file-size</code> to a different value. For example:</p> <pre><code>[snapshot]\nmax-new-file-size = \"10MiB\"\n# the following is equivalent\nmax-new-file-size = 10485760\n</code></pre> <p>The value can be specified using a human readable string with typical suffixes; <code>B</code>, <code>MiB</code>, <code>GB</code>, etc. By default, if no suffix is provided, or the value is a raw integer literal, the value is interpreted as if it were specified in bytes.</p> <p>Files that already exist in the working copy are not subject to this limit.</p> <p>Setting this value to zero will disable the limit entirely.</p>"},{"location":"config.html#automatic-update-of-stale-working-copies","title":"Automatic update of stale working copies","text":"<p>When a working copy becomes stale (meaning the working copy's recorded commit is no longer the current commit for that workspace), <code>jj</code> will normally prompt you to update it with <code>jj workspace update-stale</code>. You can configure <code>jj</code> to automatically update stale working copies by setting:</p> <pre><code>[snapshot]\nauto-update-stale = true\n</code></pre> <p>This is particularly useful if you have multiple workspaces and want to avoid manually updating each one.</p> <p>For more information on stale working copies, see the working copy documentation.</p>"},{"location":"config.html#working-copy-settings","title":"Working copy settings","text":""},{"location":"config.html#eol-conversion-settings","title":"EOL conversion settings","text":"<p>This settings serves the same purpose as the <code>core.autocrlf</code> git config.</p> <p>The line endings conversion won't be applied to files detected as binary files via a heuristics<sup>1</sup> regardless of the settings. This is similar to git.</p> <pre><code>[working-copy]\n# No EOL conversion. Similar to core.autocrlf = false.\neol-conversion = \"none\"\n# Apply CRLF to LF EOL conversion when we check files in the backend store from\n# the local file system but not apply EOL conversion when we check out the code\n# from the backend store to the local file system. Similar to core.autocrlf =\n# input.\neol-conversion = \"input\"\n# Setting this to \"input-output\" if you want to have CRLF line endings in your\n# working directory and the repository has LF line endings. Similar to\n# core.autocrlf = true.\neol-conversion = \"input-output\"\n</code></pre>"},{"location":"config.html#respect-or-ignore-executable-bit-permission-changes","title":"Respect or ignore executable bit permission changes","text":"<p>Whether to respect or ignore changes to the executable bit for files on Unix. This option is unused on Windows.</p> <pre><code>[working-copy]\nexec-bit-change = \"respect\" | \"ignore\" | \"auto\" (default)\n</code></pre> <p>On Unix systems, files have a permission bit for whether they are executable as scripts or binary code. Jujutsu stores this state in the repository and will update it for files as you operate on a repository. If you set your working copy to a commit where a file is recorded as executable or not, <code>jj</code> will adjust the permission of that file. If you change a file's executable bit through the filesystem, <code>jj</code> will record that change when taking a snapshot.</p> <p>Setting this to <code>\"ignore\"</code> will make Jujutsu ignore the executable bit on the filesystem when updating the state for the repository. In addition, <code>jj</code> will not attempt to modify a file's executable bit and will add new files as \"not executable.\" This is already the behavior on Windows, and having the option to enable this behavior is useful for Unix users dual-booting Windows, Windows users accessing files from WSL, or anyone experimenting with other filesystem configurations.</p> <p>On Unix if <code>\"auto\"</code> is set (the default), <code>jj</code> will try to detect whether the filesystem supports changing executable bits to choose between <code>\"respect\"</code> or <code>\"ignore\"</code>. On errors, we assume <code>\"respect\"</code>, except if permission was denied which will assume <code>\"ignore\"</code>.</p> <p>On Windows, files have no executable bit so this option is unused.</p> <p>You can always use <code>jj file chmod</code> to update the recorded executable bit for a file manually. If this option is <code>\"respect\"</code>, <code>jj</code> will also attempt to propagate that change to the filesystem.</p> <p>Note that if you modify a file's executable bit before changing this setting from <code>\"ignore\"</code> or  <code>\"auto\"</code> to <code>\"respect\"</code>, <code>jj</code> may not update the stored executable bit until you modify the file's contents or update its modification time, e.g. with <code>touch</code>.</p>"},{"location":"config.html#ways-to-specify-jj-config-details","title":"Ways to specify <code>jj</code> config: details","text":""},{"location":"config.html#user-config-files","title":"User config files","text":"<p>An easy way to find the user config file/directory is:</p> <pre><code>jj config path --user\n</code></pre> <p>On all platforms, the user's global <code>jj</code> configurations are by default loaded in the following precedence order (with later configs overriding earlier ones):</p> <ul> <li><code>$HOME/.jjconfig.toml</code></li> <li><code>&lt;PLATFORM_SPECIFIC&gt;/jj/config.toml</code> (preferred)</li> <li><code>&lt;PLATFORM_SPECIFIC&gt;/jj/conf.d/*.toml</code></li> </ul> <p>where <code>$HOME</code> represents the user's home directory (<code>%USERPROFILE%</code> on Windows), and <code>&lt;PLATFORM_SPECIFIC&gt;</code> represents the platform-specific configuration directory shown in the table below. The platform-specific location is recommended for better integration with platform services.</p> <p>The files in the <code>conf.d</code> directory are loaded in lexicographic order. This allows configs to be split across multiple files and combines well with Conditional Variables.</p> Platform Location of <code>&lt;PLATFORM_SPECIFIC&gt;</code> dir Example config file location Linux and macOS <code>$XDG_CONFIG_HOME</code> or <code>$HOME/.config</code> <code>/home/alice/.config/jj/config.toml</code> Windows <code>{FOLDERID_RoamingAppData}</code> <code>C:\\Users\\Alice\\AppData\\Roaming\\jj\\config.toml</code> <p>The location of the <code>jj</code> user config files/directories can also be overridden with the <code>JJ_CONFIG</code> environment variable. If the environment variable is set (even to an empty string), it will be used instead of any configuration files in the default locations. It can be a path to a TOML file or a directory of TOML files, which will be loaded in lexicographic order and merged. Multiple paths can be specified by separating them with a platform-specific path separator (<code>:</code> on Unix-like systems, <code>;</code> on Windows).</p> <p>For example, the following could be used to run <code>jj</code> without loading any user configs:</p> <pre><code>JJ_CONFIG= jj log       # Ignores any settings specified in any config files.\n</code></pre> <p>There are also the <code>--config-file &lt;PATH&gt;</code> and <code>--config &lt;NAME=VALUE&gt;</code> global options which work with any <code>jj</code> command.</p>"},{"location":"config.html#json-schema-support","title":"JSON Schema Support","text":"<p>Many popular editors support TOML file syntax highlighting and validation. To enable schema validation in your editor, add this line at the top of your TOML config files:</p> <pre><code>#:schema https://docs.jj-vcs.dev/latest/config-schema.json\n</code></pre> <p>This enables features like:</p> <ul> <li>Autocomplete for config keys</li> <li>Type checking of values</li> <li>Documentation on hover</li> <li>Validation of settings</li> </ul> <p>Here are some popular editors with TOML schema validation support:</p> <ul> <li> <p>VS Code</p> <ul> <li>Install Even Better TOML</li> </ul> </li> <li> <p>Neovim/Vim</p> <ul> <li>Use with nvim-lspconfig and taplo</li> </ul> </li> <li> <p>Helix</p> <ul> <li>Install taplo</li> </ul> </li> <li> <p>JetBrains IDEs (IntelliJ, PyCharm, etc)</p> <ul> <li>Install TOML plugin</li> </ul> </li> <li> <p>Emacs</p> <ul> <li>Install lsp-mode and toml-mode</li> <li>Configure taplo as the LSP server</li> </ul> </li> </ul>"},{"location":"config.html#specifying-config-on-the-command-line","title":"Specifying config on the command-line","text":"<p>You can use one or more <code>--config</code>/<code>--config-file</code> options on the command line to specify additional configuration settings. This overrides settings defined in config files or environment variables. For example,</p> <pre><code># Must not have spaces around the `=`\njj --config ui.color=always --config ui.diff-editor=meld split\n</code></pre> <p>Config value should be specified as a TOML expression. If string value isn't enclosed by any TOML constructs (such as array notation), quotes can be omitted. Here is an example with more advanced TOML constructs:</p> <pre><code># Single quotes and the '\\' are interpreted by the shell and assume a Unix shell\n# Double quotes are passed to jj and are parsed as TOML syntax\njj log --config \\\n  'template-aliases.\"format_timestamp(timestamp)\"=\"\"\"timestamp.format(\"%Y-%m-%d %H:%M %:::z\")\"\"\"'\n</code></pre> <p>To load an entire TOML document, use <code>--config-file</code>:</p> <pre><code>jj --config-file=extra-config.toml log\n</code></pre>"},{"location":"config.html#conditional-variables","title":"Conditional variables","text":"<p>You can conditionally enable config variables by using <code>--when</code>.</p>"},{"location":"config.html#using-scope-tables","title":"Using <code>[[--scope]]</code> tables","text":"<p>Variables defined in <code>[[--scope]]</code> tables are expanded to the root table. <code>--when</code> specifies the condition to enable the scope table.</p> <p>If no conditions are specified, the table is always enabled. If multiple conditions are specified, their intersection is used.</p> <pre><code>[user]\nname = \"YOUR NAME\"\nemail = \"YOUR_DEFAULT_EMAIL@example.com\"\n\n# override user.email if the repository is located under ~/oss\n[[--scope]]\n--when.repositories = [\"~/oss\"]\n[--scope.user]\nemail = \"YOUR_OSS_EMAIL@example.org\"\n\n# override ui.pager on specific machines\n[[--scope]]\n--when.hostnames = [\"work-laptop\", \"work-desktop\"]\n[--scope.ui]\npager = \"delta\"\n\n# disable pagination for `jj status`, use `delta` for `jj diff` and `jj show`\n[[--scope]]\n--when.commands = [\"status\"]\n[--scope.ui]\npaginate = \"never\"\n[[--scope]]\n--when.commands = [\"diff\", \"show\"]\n[--scope.ui]\npager = \"delta\"\n</code></pre>"},{"location":"config.html#using-multiple-files","title":"Using multiple files","text":"<p><code>--when</code> can also be used on the top level of a TOML file, which is convenient when splitting your config across multiple files. The behavior of conditions are the same as when using <code>[[--scope]]</code> tables.</p> <pre><code># In $XDG_CONFIG_HOME/jj/config.toml\n[user]\nname = \"YOUR NAME\"\nemail = \"YOUR_DEFAULT_EMAIL@example.com\"\n</code></pre> <pre><code># In $XDG_CONFIG_HOME/jj/conf.d/work.toml\n--when.repositories = [\"~/the/work/repo\"]\n\n[user]\nemail = \"YOUR_WORK_EMAIL@workplace.com\"\n\n[revset-aliases]\nwork = \"heads(::@ ~ description(''))::\"\n\n[aliases]\nwip = [\"log\", \"-r\", \"work\"]\n</code></pre>"},{"location":"config.html#available-condition-keys","title":"Available condition keys","text":"<ul> <li> <p><code>--when.repositories</code>: List of paths to match the repository path prefix.</p> <p>Paths should be absolute. Each path component (directory or file name, drive letter, etc.) is compared case-sensitively on all platforms. A path starting with <code>~</code> is expanded to the home directory. On Windows, directory separator may be either <code>\\</code> or <code>/</code>. (Beware that <code>\\</code> needs escape in double-quoted strings.)</p> <p>Use <code>jj root</code> to see the workspace root directory. Note that the repository path is in the main workspace if you're using multiple workspaces with <code>jj workspace</code>.</p> </li> <li> <p><code>--when.workspaces</code>: List of paths to match the workspace path prefix.</p> <p>The same concerns about the path as for <code>--when.repositories</code> applies.</p> <p>Use <code>jj root</code> to see the workspace root directory.</p> </li> <li> <p><code>--when.hostnames</code>: List of hostnames to match against the <code>operation.hostname</code>   config setting.</p> <p>Hostnames are compared case-sensitively and must match exactly.</p> <pre><code>--when.hostnames = [\"work-laptop\"]               # matches only \"work-laptop\"\n--when.hostnames = [\"home-desktop\", \"laptop\"]    # matches \"home-desktop\" OR \"laptop\"\n</code></pre> </li> <li> <p><code>--when.commands</code>: List of subcommands to match.</p> <p>Subcommands are space-separated and matched by prefix.</p> <pre><code>--when.commands = [\"file\"]        # matches `jj file show`, `jj file list`, etc\n--when.commands = [\"file show\"]   # matches `jj file show` but *NOT* `jj file list`\n--when.commands = [\"file\", \"log\"] # matches `jj file` *OR* `jj log` (or subcommand of either)\n</code></pre> </li> <li> <p><code>--when.platforms</code>: List of platforms to match.</p> <p>The values are defined by both <code>std::env::consts::FAMILY</code> and <code>std::env::consts::OS</code>.</p> <pre><code>--when.platforms = [\"windows\"]            # matches only Windows\n--when.platforms = [\"linux\", \"freebsd\"]   # matches Linux or and FreeBSD, but not macOS\n--when.platforms = [\"unix\"]               # matches anything in the Unix family (Linux, FreeBSD, macOS, etc.)\n</code></pre> </li> </ul> <ol> <li> <p>To detect if a file is binary, Jujutsu currently checks if there is NULL   byte in the file which is different from the algorithm of   <code>gitoxide</code> or <code>git</code>. Jujutsu   doesn't plan to align the binary detection logic with git.\u00a0\u21a9</p> </li> </ol>"},{"location":"conflicts.html","title":"First-class conflicts","text":""},{"location":"conflicts.html#introduction","title":"Introduction","text":"<p>Conflicts happen when Jujutsu can't figure out how to merge different changes made to the same file. For instance, this can happen if two people are working on the same file and make different changes to the same part of the file, and then their commits are merged together with <code>jj new</code> (or one is rebased onto the other with <code>jj rebase</code>).</p> <p>Unlike most other VCSs, Jujutsu can record conflicted states in commits. For example, if you rebase a commit and it results in a conflict, the conflict will be recorded in the rebased commit and the rebase operation will succeed. You can then resolve the conflict whenever you want. Conflicted states can be further rebased, merged, or backed out. Note that what's stored in the commit is a logical representation of the conflict, not conflict markers; rebasing a conflict doesn't result in a nested conflict markers (see technical doc for how this works).</p>"},{"location":"conflicts.html#advantages","title":"Advantages","text":"<p>The deeper understanding of conflicts has many advantages:</p> <ul> <li>Removes the need for things like   <code>git rebase/merge/cherry-pick/etc --continue</code>. Instead, you get a single   workflow for resolving conflicts: check out the conflicted commit, resolve   conflicts, and amend.</li> <li>Enables the \"auto-rebase\" feature, where descendants of rewritten commits   automatically get rewritten. This feature mostly replaces Mercurial's   Changeset Evolution.</li> <li>Lets us define the change in a merge commit as being compared to the merged   parents. That way, we can rebase merge commits correctly (unlike both Git and   Mercurial). That includes conflict resolutions done in the merge commit,   addressing a common use case for   git rerere.   Since the changes in a merge commit are displayed and rebased as expected,   evil merges   are arguably not as evil anymore.</li> <li>Allows you to postpone conflict resolution until you're ready for it. You   can easily keep all your work-in-progress commits rebased onto upstream's head   if you like.</li> <li>Criss-cross merges   and octopus merges   become trivial (implementation-wise); some cases that Git can't currently   handle, or that would result in nested conflict markers, can be automatically   resolved.</li> <li>Enables collaborative conflict resolution. (This assumes that you can share   the conflicts with others, which you probably shouldn't do if some people   interact with your project using Git.)</li> </ul> <p>For information about how conflicts are handled in the working copy, see here.</p>"},{"location":"conflicts.html#conflict-markers","title":"Conflict markers","text":"<p>Conflicts are \"materialized\" using conflict markers in various contexts. For example, when you run <code>jj new</code> or <code>jj edit</code> on a commit with a conflict, it will be materialized in the working copy. Conflicts are also materialized when they are part of diff output (e.g. <code>jj show</code> on a commit that introduces or resolves a conflict).</p> <p>As an example, imagine that you have a file which contains the following text, all in lowercase:</p> <pre><code>apple\ngrape\norange\n</code></pre> <p>One person replaces the word \"grape\" with \"grapefruit\" in commit A, while another person changes every line to uppercase in commit B. If you merge the changes together with <code>jj new A B</code>, the resulting commit will have a conflict since Jujutsu can't figure out how to combine these changes. Therefore, Jujutsu will materialize the conflict in the working copy using conflict markers, which would look like this:</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; conflict 1 of 1\n%%%%%%% diff from: vpxusssl 38d49363 \"merge base\"\n\\\\\\\\\\\\\\        to: rtsqusxu 2768b0b9 \"commit A\"\n apple\n-grape\n+grapefruit\n orange\n+++++++ ysrnknol 7a20f389 \"commit B\"\nAPPLE\nGRAPE\nORANGE\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; conflict 1 of 1 ends\n</code></pre> <p>The markers <code>&lt;&lt;&lt;&lt;&lt;&lt;&lt;</code> and <code>&gt;&gt;&gt;&gt;&gt;&gt;&gt;</code> indicate the start and end of a conflict respectively. The marker <code>+++++++</code> indicates the start of a snapshot, while the marker <code>%%%%%%%</code> indicates the start of a diff to apply to the snapshot. The <code>\\\\\\\\\\\\\\</code> marker just allows the label to be split across two lines to make it more readable.</p> <p>Therefore, to resolve this conflict, you would apply the diff (changing \"grape\" to \"grapefruit\") to the snapshot (the side with every line in uppercase), editing the file to look like this:</p> <pre><code>APPLE\nGRAPEFRUIT\nORANGE\n</code></pre> <p>In practice, conflicts are usually 2-sided, meaning that there's only 2 conflicting changes being merged together at a time, but Jujutsu supports conflicts with arbitrarily many sides, which can happen when merging 3 or more commits at once. In that case, you would see a single snapshot section and multiple diff sections.</p> <p>Compared to just showing the content of each side of the conflict, the main benefit of Jujutsu's style of conflict markers is that you don't need to spend time manually comparing the sides to spot the differences between them. This is especially beneficial for many-sided conflicts, since resolving them just requires applying each diff to the snapshot one-by-one.</p>"},{"location":"conflicts.html#alternative-conflict-marker-styles","title":"Alternative conflict marker styles","text":"<p>If you prefer to just see the contents of each side of the conflict without the diff, Jujutsu also supports a \"snapshot\" style, which can be enabled by setting the <code>ui.conflict-marker-style</code> config option to \"snapshot\":</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; conflict 1 of 1\n+++++++ rtsqusxu 2768b0b9 \"commit A\"\napple\ngrapefruit\norange\n------- vpxusssl 38d49363 \"merge base\"\napple\ngrape\norange\n+++++++ ysrnknol 7a20f389 \"commit B\"\nAPPLE\nGRAPE\nORANGE\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; conflict 1 of 1 ends\n</code></pre> <p>Some tools expect Git-style conflict markers, so Jujutsu also supports Git's \"diff3\" style conflict markers by setting the <code>ui.conflict-marker-style</code> config option to \"git\":</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; rtsqusxu 2768b0b9 \"commit A\"\napple\ngrapefruit\norange\n||||||| vpxusssl 38d49363 \"merge base\"\napple\ngrape\norange\n=======\nAPPLE\nGRAPE\nORANGE\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; ysrnknol 7a20f389 \"commit B\"\n</code></pre> <p>This conflict marker style only supports 2-sided conflicts though, so it falls back to the similar \"snapshot\" conflict markers if there are more than 2 sides to the conflict.</p>"},{"location":"conflicts.html#long-conflict-markers","title":"Long conflict markers","text":"<p>Some files may contain lines which could be confused for conflict markers. For instance, a line could start with <code>=======</code>, which looks like a Git-style conflict marker. To ensure that it's always unambiguous which lines are conflict markers and which are just part of the file contents, <code>jj</code> sometimes uses conflict markers which are longer than normal:</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt; conflict 1 of 1\n%%%%%%%%%%%%%%% diff from: wqvuxsty cb9217d5 \"merge base\"\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\        to: kwntsput 0e15b770 \"commit A\"\n-Heading\n+HEADING\n =======\n+++++++++++++++ mpnwrytz 52020ed6 \"commit B\"\nNew Heading\n===========\n&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt; conflict 1 of 1 ends\n</code></pre>"},{"location":"conflicts.html#conflicts-with-missing-terminating-newline","title":"Conflicts with missing terminating newline","text":"<p>When materializing conflicts, <code>jj</code> outputs them in a line-based format, with each conflict marker line terminated by a newline character (<code>\\n</code>). This format works well for text files that consist of a series of lines, with each line terminated by a newline character as well.</p> <p>While most text files follow this convention, some do not. Since conflict markers must appear on their own line, when <code>jj</code> encounters a missing terminating newline character in a conflict, it still needs to ensure that there is a newline before the next conflict marker. To do this, it adds an extra newline to each term of the conflict. Then, to compensate for this extra newline, it also omits the terminating newline from the \"end of conflict\" marker (<code>&gt;&gt;&gt;&gt;&gt;&gt;&gt;</code>).</p> <p>For instance, if a file originally contained <code>grape</code> with no terminating newline character, and one person changed <code>grape</code> to <code>grapefruit</code>, while another person added the missing newline character to make <code>grape\\n</code>, the resulting conflict would look like this (\u240a demonstrates the <code>\\n</code> character explicitly, note that the last line doesn't have the terminating <code>\\n</code> character):</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; conflict 1 of 1\u240a\n+++++++ tlwwkqxk d121763d \"commit A\" (no terminating newline)\u240a\ngrapefruit\u240a\n%%%%%%% diff from: qwpqssno fe561d93 \"merge base\" (no terminating newline)\u240a\n\\\\\\\\\\\\\\        to: poxkmrxy c735fe02 \"commit B\"\u240a\n grape\u240a\n+\u240a\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; conflict 1 of 1 ends\n</code></pre> <p>Therefore, a resolution of this conflict could be <code>grapefruit\\n</code>, with the terminating newline character added.</p>"},{"location":"contributing.html","title":"How to Contribute","text":""},{"location":"contributing.html#policies","title":"Policies","text":"<p>We'd love to accept your patches and contributions to this project. There are just a few small guidelines you need to follow.</p>"},{"location":"contributing.html#contributor-license-agreement","title":"Contributor License Agreement","text":"<p>Contributions to this project must be accompanied by a Contributor License Agreement. You (or your employer) retain the copyright to your contribution; this simply gives us permission to use and redistribute your contributions as part of the project. Head over to https://cla.developers.google.com/ to see your current agreements on file or to sign a new one.</p> <p>You generally only need to submit a CLA once, so if you've already submitted one (even if it was for a different project), you probably don't need to do it again.</p>"},{"location":"contributing.html#commit-guidelines","title":"Commit guidelines","text":"<p>Unlike many GitHub projects (but like many VCS projects), we care more about the contents of commits than about the contents of PRs. We review each commit separately, and we don't squash-merge the PR (so please manually squash any fixup commits before sending for review).</p> <p>Each commit should ideally do one thing. For example, if you need to refactor a function in order to add a new feature cleanly, put the refactoring in one commit and the new feature in a different commit. If the refactoring itself consists of many parts, try to separate out those into separate commits. You can use <code>jj split</code> to do it if you didn't realize ahead of time how it should be split up. Include tests and documentation in the same commit as the code they test and document.</p> <p>The commit message should describe the changes in the commit; the PR description can even be empty, but feel free to include a personal message. We don't use Conventional Commits and instead start the commit message with <code>&lt;topic&gt;:</code> rather than like <code>chore:</code>, <code>feat:</code> and <code>fix:</code>. This means if you modified a command in the CLI, use its name as the topic, e.g. <code>next/prev: &lt;your-modification&gt;</code> or <code>conflicts: &lt;your-modification&gt;</code>. We don't currently have a specific guidelines on what to write in the topic field, but the reviewers will help you provide a topic if you have difficulties choosing it. How to Write a Git Commit Message is a good guide if you're new to writing good commit messages. We are not particularly strict about the style, but please do explain the reason for the change unless it's obvious.</p>"},{"location":"contributing.html#code-reviews","title":"Code reviews","text":"<p>All submissions, including submissions by project members, require review. We use GitHub pull requests for this purpose. Consult GitHub Help for more information on using pull requests.</p> <p>The project unfortunately has a shortage of reviewers (a common problem in open-source projects). To maximize the chances of getting a timely review, do what you can to provide reviewers (and other future readers) with the necessary context. For example, if you're adding a new feature, explain why that feature is useful, how it works from the user's point of view, how it's designed, and what the limitations of your design are. If you have considered other designs, it may be useful to mention them. Another way of speeding up reviews is to review others' PRs so the maintainers don't need to spend as much time on them.</p> <p>When you address comments on a PR, don't make the changes in a commit on top (as is typical on GitHub). Instead, please make the changes in the appropriate commit. You can do that by creating a new commit on top of the initial commit  (<code>jj new &lt;commit&gt;</code>) and then squash in the changes when you're done (<code>jj squash</code>). <code>jj git push</code> will automatically force-push the bookmark.</p> <p>When your first PR has been approved, we typically invite you to the <code>jj-vcs/contributors</code> team to give you contributor access, so you can address any remaining minor comments and then merge the PR yourself when you're ready. If you realize that some comments require non-trivial changes, please ask your reviewer to take another look.</p> <p>If your employer pays anyone (not necessarily you) to contribute to Jujutsu, please make sure your GitHub username is recorded. To avoid conflicts of interest, please don't merge a PR that has only been approved by someone from the same organization. Similarly, as a reviewer, there is no need to approve your coworkers' PRs, since the author should await an approval from someone else anyway. It is of course still appreciated if you review and comment on their PRs. Also, if the PR seems completely unrelated to your company's interests, do feel free to approve it.</p>"},{"location":"contributing.html#community-guidelines","title":"Community Guidelines","text":"<p>This project follows Google's Open Source Community Guidelines.</p>"},{"location":"contributing.html#contributing-large-patches","title":"Contributing large patches","text":"<p>Before sending a PR for a large change which designs/redesigns or reworks an existing component, we require an architecture review from  multiple stakeholders, which we do with Design Docs, see the process here.</p>"},{"location":"contributing.html#contributing-to-the-documentation","title":"Contributing to the documentation","text":"<p>We appreciate bug reports about any problems, however small, lurking in our documentation website or in the <code>jj help &lt;command&gt;</code> docs. If a part of the bug report template does not apply, you can just delete it.</p> <p>Before reporting a problem with the documentation website, we'd appreciate it if you could check that the problem still exists in the \"prerelease\" version of the documentation (as opposed to the docs for one of the released versions of <code>jj</code>). You can use the version switcher in the top-left of the website to do so.</p> <p>If you are willing to make a PR fixing a documentation problem, even better!</p> <p>The documentation website sources are Markdown files located in the <code>docs/</code> directory. You do not need to know Rust to work with them. See below for instructions on how to preview the HTML docs as you edit the Markdown files. Doing so is optional, but recommended.</p> <p>The <code>jj help</code> docs are sourced from the \"docstring\" comments inside the Rust sources, currently from the <code>cli/src/commands</code> directory. Working on them requires setting up a Rust development environment, as described below, and may occasionally require adjusting a test.</p>"},{"location":"contributing.html#learning-rust","title":"Learning Rust","text":"<p>In addition to the Rust Book and the other excellent resources at https://www.rust-lang.org/learn, we recommend the \"Comprehensive Rust\" mini-course for an overview, especially if you are familiar with C++.</p>"},{"location":"contributing.html#style-guide","title":"Style guide","text":"<p>See here.</p>"},{"location":"contributing.html#setting-up-a-development-environment","title":"Setting up a development environment","text":"<p>To develop <code>jj</code>, the mandatory steps are simply to install Rust (the default installer options are fine), clone the repository, and use <code>cargo build</code> , <code>cargo fmt</code>, <code>cargo clippy --workspace --all-targets</code>, and <code>cargo test --workspace</code>. If you are preparing a PR, there are some additional recommended steps.</p>"},{"location":"contributing.html#summary","title":"Summary","text":"<p>One-time setup:</p> <pre><code>rustup toolchain add nightly  # wanted for 'rustfmt'\nrustup toolchain add 1.89     # also specified in Cargo.toml\ncargo install --locked bacon\ncargo install --locked cargo-insta\ncargo install --locked cargo-nextest\n</code></pre> <p>During development (adapt according to your preference):</p> <pre><code>bacon clippy-all\ncargo +nightly fmt # Occasionally\ncargo nextest run --workspace # Occasionally\ncargo insta test --workspace --test-runner nextest # Occasionally\n</code></pre> <p>Warning</p> <p>Build artifacts from debug builds and especially from repeated invocations of <code>cargo test</code> can quickly take up 10s of GB of disk space. Cargo will happily use up your entire hard drive. If this happens, run <code>cargo clean</code>.</p>"},{"location":"contributing.html#explanation","title":"Explanation","text":"<p>These are listed roughly in order of decreasing importance.</p> <ol> <li> <p>Nearly any change to <code>jj</code>'s CLI will require writing or updating snapshot    tests that use the <code>insta</code> crate. To make this    convenient, install the <code>cargo-insta</code> binary.    Use <code>cargo insta test --workspace</code> to run tests,    and <code>cargo insta review --workspace</code> to update the snapshot tests.    The <code>--workspace</code> flag is needed to run the tests on all crates; by default,    only the crate in the current directory is tested.</p> </li> <li> <p>GitHub CI checks require that the code is formatted with the nightly    version of <code>rustfmt</code>. To do this on your computer, install the nightly    toolchain and use <code>cargo +nightly fmt</code>.</p> </li> <li> <p>Your code will be rejected if it cannot be compiled with the minimal    supported version of Rust (\"MSRV\"). Currently, <code>jj</code> follows a rather    casual MSRV policy: \"The current <code>rustc</code> stable version, minus one.\"    As of this writing, that version is 1.89.0.</p> </li> <li> <p>Your code needs to pass <code>cargo clippy</code>. You can also    use <code>cargo +nightly clippy</code> if you wish to see more warnings.</p> </li> <li> <p>You may also want to install and use <code>bacon</code>,    to automatically build, check, and / or run tests.</p> </li> <li> <p>To run tests more quickly, use <code>cargo nextest run --workspace</code>. To    use <code>nextest</code> with <code>insta</code>, use <code>cargo insta test --workspace    --test-runner nextest</code>.</p> <p>On Linux, you may be able to speed up <code>nextest</code> even further by using  the <code>mold</code> linker, as explained below.</p> </li> </ol>"},{"location":"contributing.html#configuring-jj-fix-to-run-rustfmt","title":"Configuring <code>jj fix</code> to run <code>rustfmt</code>","text":"<p>Run this in the jj repo:</p> <pre><code>jj config set --repo fix.tools.rustfmt '{ command = [\"rustfmt\", \"+nightly\"], patterns = [\"glob:**/*.rs\"] }'\n</code></pre> <p>Note: users of Nix and <code>direnv</code> should drop the <code>\"+nightly\"</code> argument above since the devShell is already configured to pull in a nightly version of rustfmt:</p> <pre><code>jj config set --repo fix.tools.rustfmt '{ command = [\"rustfmt\"], patterns = [\"glob:**/*.rs\"] }'\n</code></pre>"},{"location":"contributing.html#using-mold-for-faster-tests-on-linux","title":"Using <code>mold</code> for faster tests on Linux","text":"<p>On a machine with a multi-core CPU, one way to speed up <code>cargo nextest</code> on Linux is to use the multi-threaded <code>mold</code> linker. This linker may help if, currently, your CPU is underused while Rust is linking test binaries. Before proceeding with <code>mold</code>, you can check whether this is an issue worth solving using a system monitoring tool such as <code>htop</code>.</p> <p><code>mold</code> is packaged for many distributions. On Debian, for example, <code>sudo apt install mold</code> should just work.</p> <p>A simple way to use <code>mold</code> is via the <code>-run</code> option, e.g.:</p> <pre><code>mold -run cargo insta test --workspace --test-runner nextest\n</code></pre> <p>There will be no indication that a different linker is used, except for higher CPU usage while linking and, hopefully, faster completion. You can verify that <code>mold</code> was indeed used by running <code>readelf -p .comment target/debug/jj</code>.</p> <p>There are also ways of having Rust use <code>mold</code> by default, see the \"How to use\" instructions.</p> <p>On recent versions of MacOS, the default linker Rust uses is already multi-threaded. It should use all the CPU cores without any configuration.</p>"},{"location":"contributing.html#set-up-a-ram-disk-for-faster-tests-on-macos","title":"Set up a RAM disk for faster tests on macOS","text":"<p><code>jj</code> tests can be sped up significantly on macOS by using a RAM disk instead of the usual <code>/tmp</code> directory (on one Mac, the tests sped up ~3 times from 180 seconds to 55 seconds). You can set this up as follows:</p> <pre><code>sudo mkdir -p /Volumes/RAMDisk\nsudo chmod a+wx /Volumes/RAMDisk\nsudo mount_tmpfs /Volumes/RAMDisk  # Add `-e` to make it case-sensitive\n                      # Add `-o nobrowse` to hide the tmpfs from Finder\n</code></pre> <p>You will need to re-run this after a reboot. Consider making it a script you can run with <code>sudo</code>. (The first two commands don't need sudo if you change the dir to somewhere in your HOME, the last one always does.)</p> <p>Then, you can rust tests as, for example,</p> <pre><code>TMPDIR=/Volumes/RAMDisk cargo insta test --workspace --test-runner nextest\n</code></pre> <p>You can double-check whether or not the RAM disk is mounted with</p> <pre><code>mount | grep tmpfs\n</code></pre>  Some details and speculation    Hard drive speed is not the issue here. Experimentally, when <code>/tmp</code> is physical, Ilya experienced the tests doing writes at 60MB/s (as reported by the Activity Monitor) on an SSD that should be many times as fast.  Instead, it seems to have something to do with file locking and <code>fdatasync</code>. A likely curlprit is the presence of  global kernel locks in APFS. There are some benchmarks in this PR.  It might be possible to add an entry to `/etc/fstab` to mount tmpfs automatically. If you succeed with this, let us (and Ilya in particular) know!"},{"location":"contributing.html#editor-setup","title":"Editor setup","text":""},{"location":"contributing.html#visual-studio-code","title":"Visual Studio Code","text":"<p>We recommend at least these settings:</p> <pre><code>{\n    \"files.insertFinalNewline\": true,\n    \"files.trimTrailingWhitespace\": true,\n    \"[rust]\": {\n        \"files.trimTrailingWhitespace\": false\n    }\n}\n</code></pre>"},{"location":"contributing.html#zed","title":"Zed","text":"<pre><code>// .zed/settings.json\n{\n  \"ensure_final_newline_on_save\": true,\n  \"remove_trailing_whitespace_on_save\": true,\n\n  \"languages\": {\n    // We don't use a formatter for Markdown files, so format_on_save would just\n    // mess with others' docs\n    \"Markdown\": { \"format_on_save\": \"off\" }\n    \"Rust\": {\n      \"format_on_save\": \"on\",\n      // Avoid removing trailing spaces within multi-line string literals\n      \"remove_trailing_whitespace_on_save\": false\n    }\n  },\n\n  \"lsp\": {\n    \"rust-analyzer\": {\n      \"initialization_options\": {\n        // If you are working on docs and don't need `cargo check`, uncomment\n        // this option:\n        //\n        //   \"checkOnSave\": false,\n\n        // Use nightly `rustfmt`, equivalent to `cargo +nightly fmt`\n        \"rustfmt\": { \"extraArgs\": [\"+nightly\"] }\n      }\n    }\n  }\n}\n</code></pre>"},{"location":"contributing.html#helix","title":"Helix","text":"<pre><code># .helix/languages.toml\n[language-server.rust-analyzer.config.rustfmt]\nextraArgs = [\"+nightly\"]\n</code></pre>"},{"location":"contributing.html#alternative-development-setup-with-nix","title":"Alternative development setup with Nix","text":"<p>If you have Nix installed, you can use the provided <code>flake.nix</code> to get a development environment with all necessary tools pre-configured:</p> <pre><code>nix develop\n</code></pre> <p>Once inside the shell, you can run <code>cargo build</code>, <code>cargo test</code> etc. as usual. Other tools like <code>uv</code>, <code>cargo-insta</code>, <code>cargo-nextest</code> and more are installed, and so you should be able to follow any other recommendations in this guide as needed.</p> <p>Editor integration</p> <p>Launch your editor from within the <code>nix develop</code> shell so that rust-analyzer and other LSP tools can find the correct toolchain. For example:</p> <pre><code>nix develop\ncode .  # or your editor of choice\n</code></pre> <p>direnv users</p> <p>If you use direnv with nix-direnv, you can <code>echo \"source_env .envrc.recommended\" &gt;&gt; .envrc</code> to automatically activate the development environment when entering the directory.</p>"},{"location":"contributing.html#alternative-development-setup-with-mise","title":"Alternative development setup with <code>mise</code>","text":"<p>An experimental development setup is available using <code>mise</code>. If you try it, file bugs, PRs, or tell us on Discord/IRC/discussions if you experience problems or if this config is too inflexible. If we can make it work for most platforms and most people's needs, including people previously unfamiliar with <code>mise</code>, we may make <code>mise</code> the recommended way to set up a development environment.</p> <p>This tool manages the necessary dependencies for you, eliminating the need for a separate setup process. <code>mise</code> automatically installs the required tools when they are needed.</p> <p>Here are some of the commands you may find yourself using frequently during development:</p> <ul> <li><code>mise test</code>: Runs all tests.</li> <li><code>mise test &lt;string&gt;</code>: Runs tests that contain a specific string. For   example, <code>mise test squash</code> would run tests with \"squash\" in their name.</li> <li><code>mise build</code>: Compiles <code>jj</code>.</li> <li><code>mise build:release</code>: Compiles <code>jj</code> in release mode.</li> <li><code>mise build:docs</code>: Builds the documentation for <code>jj</code>.</li> </ul> <p>For a complete list of all available tasks, you can run <code>mise tasks</code> or review the configuration file at <code>.config/mise.toml</code>.</p> <p>You can customize this configuration using a <code>mise.local.toml</code> file.</p>"},{"location":"contributing.html#previewing-the-html-documentation","title":"Previewing the HTML documentation","text":"<p>The documentation for <code>jj</code> is automatically published online at https://docs.jj-vcs.dev/.</p> <p>When editing documentation, you should check your changes locally \u2014 especially if you are adding a new page, or doing a major rewrite.</p>"},{"location":"contributing.html#install-uv","title":"Install <code>uv</code>","text":"<p>The only thing you need is <code>uv</code> (version 0.5.1 or newer).</p> <p><code>uv</code> is a Python project manager written in Rust. It will fetch the right Python version and the dependencies needed to build the docs. Install it like so:</p> macOS/LinuxWindowsHomebrewCargoOther options <pre><code>curl -LsSf https://astral.sh/uv/install.sh | sh\n</code></pre> <p>Note</p> <p>If you don't have <code>~/.local/bin</code> in your <code>PATH</code>, the installer will modify your shell profile. To avoid it:</p> <pre><code>curl -LsSf https://astral.sh/uv/install.sh | env INSTALLER_NO_MODIFY_PATH=1 sh\n</code></pre> <pre><code>powershell -ExecutionPolicy ByPass -c \"irm https://astral.sh/uv/install.ps1 | iex\"\n</code></pre> <pre><code>brew install uv\n</code></pre> <pre><code># This might take a while\ncargo install --git https://github.com/astral-sh/uv uv\n</code></pre> <ul> <li>Directly download the binaries from GitHub: uv releases.</li> <li>Even more options: Installing uv.</li> </ul>"},{"location":"contributing.html#build-the-docs","title":"Build the docs","text":"<p>To build the docs, run while inside the <code>jj</code> repository:</p> <pre><code>uv run mkdocs serve\n</code></pre> <p>Open http://127.0.0.1:8000 in your browser to see the docs.</p> <p>As you edit the <code>.md</code> files in <code>docs/</code>, the website should be rebuilt and reloaded in your browser automatically.</p> <p>If the docs are not updating</p> <p>Check the terminal from which you ran <code>uv run mkdocs serve</code> for any build errors or warnings. Warnings about <code>\"GET /versions.json HTTP/1.1\" code 404</code> are expected and harmless.</p>"},{"location":"contributing.html#offline-distribution","title":"Offline distribution","text":"<p>To build the rendered docs for offline distribution or to view them from your file system, run while inside the <code>jj</code> repository:</p> <pre><code>MKDOCS_OFFLINE=true uv run mkdocs build\n</code></pre>"},{"location":"contributing.html#building-the-entire-website","title":"Building the entire website","text":"<p>Tip</p> <p>Building the entire website is not usually necessary. If you are editing documentation, the previous section is enough.</p> <p>These instructions are relevant if you are working on the versioning of the documentation that we currently do with <code>mike</code>.</p> <p>The full <code>jj</code> website includes the documentation for several <code>jj</code> versions (<code>prerelease</code>, latest release, and the older releases). The top-level URL https://docs.jj-vcs.dev redirects to https://docs.jj-vcs.dev/latest, which in turn redirects to the docs for the last stable version.</p> <p>The different versions of documentation are managed and deployed with <code>mike</code>, which can be run with <code>uv run mike</code>.</p> <p>On a POSIX system or WSL, one way to build the entire website is as follows (on Windows, you'll need to understand and adapt the shell script):</p> <ol> <li> <p>Check out <code>jj</code> (<code>jj git clone</code>), cloned from your fork of <code>jj</code> (e.g.   <code>github.com/jjfan/jj</code>). You can also use a pure Git repo if you prefer.</p> </li> <li> <p>Make sure <code>github.com/jjfan/jj</code> includes the <code>gh-pages</code> bookmark of the jj repo and run <code>git fetch origin gh-pages</code>.</p> </li> <li> <p>Go to the GitHub repository settings, enable GitHub Pages, and configure them to use the <code>gh-pages</code> bookmark (this is usually the default).</p> </li> <li> <p>Install <code>uv</code> as explained in Previewing the HTML documentation, and run the same <code>sh</code> script that is used in GitHub CI (details below):</p> <pre><code>.github/scripts/docs-build-deploy prerelease main --push\n</code></pre> <p>This should build the version of the docs from the current commit,   deploy it as a new commit to the <code>gh-pages</code> bookmark,   and push the <code>gh-pages</code> bookmark to the origin.</p> </li> <li> <p>Now, you should be able to see the full website, including your latest changes to the <code>prerelease</code> version, at <code>https://jjfan.github.io/jj/prerelease/</code>.</p> </li> <li> <p>(Optional) The previous steps actually only rebuild <code>https://jjfan.github.io/jj/prerelease/</code> and its alias <code>https://jjfan.github.io/jj/main/</code>. If you'd like to test out version switching back and forth, you can also rebuild the docs for the latest release as follows.</p> <pre><code>jj new v1.33.1  # Let's say `jj 1.33.1` is the currently the latest release\n.github/scripts/docs-build-deploy v1.33.1 latest --push\n</code></pre> </li> <li> <p>(Optional) When you are done, you may want to reset the <code>gh-pages</code> bookmark to the same spot as it is upstream. If you configured the \"upstream\" remote, this can be done with:</p> <pre><code># This will LOSE any changes you made to `gh-pages`\njj git fetch --remote upstream\njj bookmark set gh-pages -r gh-pages@upstream\njj git push --remote origin --bookmark gh-pages\n</code></pre> <p>If you want to preserve some of the changes you made, you can do <code>jj bookmark   set my-changes -r gh-pages</code> BEFORE running the above commands.</p> </li> </ol>"},{"location":"contributing.html#explanation-of-the-docs-build-deploy-script","title":"Explanation of the <code>docs-build-deploy</code> script","text":"<p>The script sets up a few environment variables and invokes <code>uv run mike deploy</code> with some default arguments and whatever arguments were passed to <code>docs-build-deploy</code>. Run <code>uv run mike help deploy</code> to find out what the arguments do.</p> <p>If you need to do something more complicated, you can use <code>uv run mike ...</code> commands. You can also edit the <code>gh-pages</code> bookmark directly, but take care to avoid files that will be overwritten by future invocations of <code>mike</code>. Then, you can submit a PR based on the <code>gh-pages</code> bookmark of https://docs.jj-vcs.dev/ (instead of the usual <code>main</code> bookmark).</p> <p>Previously, the version switcher would not work unless the value of the <code>site_url</code> config in <code>mkdocs.yml</code> matched the actual URL the site is being served from. This bug should now be fixed, but if you are not serving the site from https://docs.jj-vcs.dev/ and something fails weirdly, you might want to adjust the <code>site_url</code> to something like <code>https://jjfan.github.io/jj</code>.</p>"},{"location":"contributing.html#modifying-protobuffers-this-is-not-common","title":"Modifying protobuffers (this is not common)","text":"<p>Occasionally, you may need to change the <code>.proto</code> files that define jj's data  storage format. In this case, you will need to add a few steps to the above  workflow.</p> <ul> <li>Install the <code>protoc</code> compiler. This usually means either <code>apt-get install    protobuf-compiler</code> or downloading an official release. The    <code>prost</code> library docs have additional advice.</li> <li>Run <code>cargo run -p gen-protos</code> regularly (or after every edit to a <code>.proto</code>    file). This is the same as running <code>cargo run</code> from <code>lib/gen-protos</code>. The    <code>gen-protos</code> binary will use the <code>prost-build</code> library to compile the    <code>.proto</code> files into <code>.rs</code> files.</li> <li>If you are adding a new <code>.proto</code> file, you will need to edit the list of    these files in <code>lib/gen-protos/src/main.rs</code>.</li> </ul> <p>The <code>.rs</code> files generated from <code>.proto</code> files are included in the repository,  and there is a GitHub CI check that will complain if they do not match.</p>"},{"location":"contributing.html#logging","title":"Logging","text":"<p>You can print internal jj logs using <code>JJ_LOG</code>. It acts like the <code>RUST_LOG</code> environment variable, frequent in Rust codebases, and accepts one or more directives. You can also run <code>JJ_LOG=debug jj</code> to get <code>debug</code> level logs enabled for all targets. You can also use the <code>--debug</code> global option, which turns on <code>debug</code> log level for <code>jj-lib</code> and <code>jj-cli</code> only.</p>"},{"location":"contributing.html#profiling","title":"Profiling","text":""},{"location":"contributing.html#introduction","title":"Introduction","text":"<p>jj provides two main approaches to profiling:</p> <ol> <li>Tracing-based profiling - Uses the Rust <code>tracing</code> crate to record spans    and events. Good for understanding control flow and finding where time is spent    in instrumented code.</li> <li>Sampling-based profiling - Uses system profilers (perf, dtrace) to sample    the call stack. Good for finding hot spots including in uninstrumented code and    external libraries.</li> </ol>"},{"location":"contributing.html#tracing-based-profiling","title":"Tracing-based profiling","text":"<p>jj uses the <code>tracing</code> crate with Chrome Trace Format output.</p> <p>Set the <code>JJ_TRACE</code> environment variable to generate a trace file:</p> <pre><code># Generate trace with auto-generated filename (jj-trace-{timestamp}.json)\nJJ_TRACE= jj st\n\n# Generate trace with specific filename\nJJ_TRACE=/tmp/trace.json jj st\n</code></pre> <p>To include function argument values in the trace (useful for detailed debugging):</p> <pre><code>JJ_TRACE_INCLUDE_ARGS=1 JJ_TRACE=/tmp/trace.json jj log -r 'ancestors(@, 10)'\n</code></pre> <p>The produced profiles can be imported into chrome://tracing (on Google Chrome) or https://ui.perfetto.dev/ (all browsers).</p> <p>Only functions annotated with <code>#[tracing::instrument]</code> or explicit <code>trace_span!</code> macros appear in traces. If you need to profile a specific area that isn't instrumented, you can add <code>#[instrument]</code> attributes to the relevant functions.</p>"},{"location":"contributing.html#sampling-based-profiling","title":"Sampling-based profiling","text":"<p>Sampling profilers periodically capture the call stack to identify hot spots. This approach:</p> <ul> <li>Has lower overhead than tracing</li> <li>Captures all code, including uninstrumented functions and external libraries (like gitoxide)</li> <li>May miss short-lived function calls since it samples rather than traces every   call</li> </ul>"},{"location":"contributing.html#using-samply","title":"Using samply","text":"<p>One easy-to-use sampling profiler is samply. For example:</p> <pre><code>cargo install samply\nsamply record jj diff\n</code></pre> <p>Then just open the link it prints.</p>"},{"location":"contributing.html#using-cargo-flamegraph","title":"Using cargo-flamegraph","text":"<p>cargo-flamegraph generates flamegraph visualizations using system profilers:</p> <pre><code>cargo install flamegraph\ncargo flamegraph --bin jj -- diff\n</code></pre> <p>You may need to use <code>sudo</code> or install <code>perf</code> on your system, see flamegraph's documentation for more.</p>"},{"location":"core_tenets.html","title":"Core tenets","text":""},{"location":"core_tenets.html#jujutsus-core-tenets","title":"Jujutsu's Core Tenets","text":"<p>Jujutsu's core tenets are:</p> <ul> <li>Separation of logic and UI: It should be easy to create new UIs (CLIs, GUIs,    TUIs, servers) without having to duplicate logic.</li> <li>Easy-to-use APIs: It should be easy to create new commands. For example,    each command should not have to worry about concurrency, working-copy state,    and rebasing descendants of rewritten commits.</li> <li>User-friendliness: Making the working copy a commit is simpler. This is    how the project started.</li> <li>The repo is the source of truth: Most commands should operate on the commit    graph. The working copy is just one way of editing commits.</li> <li>Pluggable storage: Must be easy to integrate with different commit storage,    virtual file systems and more.</li> <li>Git-interoperability: Git is everywhere. We need to have good    interoperability to be adopted.</li> <li>All operations must be able to scale to Google-scale repos (lots of commits,    lots of files): Laziness is important, must avoid accessing data    unnecessarily.</li> <li>Having as few states as possible.</li> <li>Make it incredibly hard to lose work in your repo.</li> <li>Concurrent modifications to the repo should be safe.</li> <li>Allow concurrent edits on any commit, pending or finished.</li> <li>Make a \"stacked diffs\" workflow as easy as possible.</li> </ul>"},{"location":"design_doc_blueprint.html","title":"Title","text":"<p>A cool name for your Project</p> <p>Author: Your-Name</p> <p>If there are multiple authors, just list them all</p>"},{"location":"design_doc_blueprint.html#summary","title":"Summary","text":"<p>A short summary of your project/re-design/component and what problems it addresses in about 3-10 sentences.</p>"},{"location":"design_doc_blueprint.html#state-of-the-feature-as-of-version-optional","title":"State of the Feature as of <code>$VERSION</code> (optional)","text":"<p>The state of the feature you want to improve and where it currently falls short. If there's nothing to compare to, leave it out.</p>"},{"location":"design_doc_blueprint.html#prior-work-optional","title":"Prior work (optional)","text":"<p>Does this feature exist somewhere else and which tradeoffs it made.</p> <p>If there's no prior work, then use the related work section below.</p>"},{"location":"design_doc_blueprint.html#goals-and-non-goals","title":"Goals and non-goals","text":"<p>Direct goals of the project and features deemed not worth pursuing.</p>"},{"location":"design_doc_blueprint.html#overview","title":"Overview","text":"<p>A detailed overview of the project and the improvements it brings.</p>"},{"location":"design_doc_blueprint.html#detailed-design","title":"Detailed Design","text":"<p>The place to describe all new interfaces and interactions and how it plays into the existing code and behavior. This is the place for all nitty-gritty details which interact with the system.</p>"},{"location":"design_doc_blueprint.html#alternatives-considered-optional","title":"Alternatives considered (optional)","text":"<p>Other alternatives to your suggested approach, and why they fall short.</p>"},{"location":"design_doc_blueprint.html#issues-addressed-optional","title":"Issues addressed (optional)","text":"<p>A list of issues which are addressed by this design.</p>"},{"location":"design_doc_blueprint.html#related-work-optional","title":"Related Work (optional)","text":"<p>If there's a feature in another VCS which shares some similarities to your proposed work, it belongs here. An example would be Jujutsu sparse workspaces and Perforce client workspaces.</p>"},{"location":"design_doc_blueprint.html#future-possibilities","title":"Future Possibilities","text":"<p>The section for things which could be added to it or deemed out of scope during the discussion.</p>"},{"location":"design_docs.html","title":"Jujutsu Design Docs","text":"<p>Jujutsu uses Design Docs to drive technical decisions on large projects and it is the place to discuss your proposed design or new component. It is a very thorough process, in which the design doc must be approved before PRs for the feature will be accepted. It shares some similarities with Rust RFCs but mostly addresses technical problems and gauges the technical and social concerns of all stakeholders.</p> <p>So if you want to start building a native backend or the server component for Jujutsu, you'll need to go through this process.</p>"},{"location":"design_docs.html#process","title":"Process","text":"<ol> <li>Add a new markdown document to <code>docs/design</code>, named after your improvement    or project.</li> <li>Describe the current state of the world and the things you want to improve.</li> <li>Wait for the Maintainers and Stakeholders to show up.</li> <li>Iterate until everyone accepts the change in normal codereview fashion.</li> </ol>"},{"location":"design_docs.html#blueprint-template","title":"Blueprint (Template)","text":"<p>You can find the base template of a new Design Doc here.</p>"},{"location":"filesets.html","title":"Filesets","text":"<p>Jujutsu supports a functional language for selecting a set of files. Expressions in this language are called \"filesets\" (the idea comes from Mercurial). The language consists of file patterns, operators, and functions.</p>"},{"location":"filesets.html#quoting-file-names","title":"Quoting file names","text":"<p>Many <code>jj</code> commands accept fileset expressions as positional arguments. File names passed to these commands must be quoted if they contain whitespace or meta characters. However, as a special case, quotes can be omitted if the expression has no operators nor function calls. For example:</p> <ul> <li><code>jj diff 'Foo Bar'</code> (shell quotes are required, but inner quotes are optional)</li> <li><code>jj diff '~\"Foo Bar\"'</code> (both shell and inner quotes are required)</li> <li><code>jj diff '\"Foo(1)\"'</code> (both shell and inner quotes are required)</li> </ul> <p>Glob characters aren't considered meta characters, but shell quotes are still required:</p> <ul> <li><code>jj diff '~glob:**/*.rs'</code></li> </ul>"},{"location":"filesets.html#file-patterns","title":"File patterns","text":"<p>The following patterns are supported. In all cases, we do not mention any shell quoting that might be necessary, and the quotes around <code>\"path\"</code> are optional if the path has no special characters.</p> <p>By default, <code>\"path\"</code> is parsed as a <code>prefix-glob:</code> pattern, which matches cwd-relative path prefix.</p> <ul> <li><code>cwd:\"path\"</code>: Matches cwd-relative path prefix (file or files under directory   recursively.)</li> <li><code>file:\"path\"</code> or <code>cwd-file:\"path\"</code>: Matches cwd-relative file (or exact) path.</li> <li><code>glob:\"pattern\"</code> or <code>cwd-glob:\"pattern\"</code>: Matches file paths with cwd-relative   Unix-style shell wildcard <code>pattern</code>. For example, <code>glob:\"*.c\"</code> will   match all <code>.c</code> files in the current working directory non-recursively.</li> <li><code>prefix-glob:\"pattern\"</code> or <code>cwd-prefix-glob:\"pattern\"</code>: Like <code>glob:</code>, but also   matches path prefix (file or files under directory recursively.) For example,   <code>prefix-glob:\"*.d\"</code> is equivalent to <code>glob:\"*.d\" | glob:\"*.d/**\"</code>.</li> <li><code>root:\"path\"</code>: Matches workspace-relative path prefix (file or files under   directory recursively.)</li> <li><code>root-file:\"path\"</code>: Matches workspace-relative file (or exact) path.</li> <li><code>root-glob:\"pattern\"</code>: Matches file paths with workspace-relative Unix-style   shell wildcard <code>pattern</code>.</li> <li><code>root-prefix-glob:\"pattern\"</code>: Like <code>root-glob:</code>, but also matches path prefix   (file or files under directory recursively.)</li> </ul> <p>Glob patterns support case-insensitive matching by appending <code>-i</code> to the pattern name. For example, <code>glob-i:\"*.TXT\"</code> will match both <code>file.txt</code> and <code>FILE.TXT</code>.</p>"},{"location":"filesets.html#operators","title":"Operators","text":"<p>The following operators are supported. <code>x</code> and <code>y</code> below can be any fileset expressions.</p> <ul> <li><code>~x</code>: Matches everything but <code>x</code>.</li> <li><code>x &amp; y</code>: Matches both <code>x</code> and <code>y</code>.</li> <li><code>x ~ y</code>: Matches <code>x</code> but not <code>y</code>.</li> <li><code>x | y</code>: Matches either <code>x</code> or <code>y</code> (or both).</li> </ul> <p>(listed in order of binding strengths)</p> <p>You can use parentheses to control evaluation order, such as <code>(x &amp; y) | z</code> or <code>x &amp; (y | z)</code>.</p>"},{"location":"filesets.html#functions","title":"Functions","text":"<p>You can also specify patterns by using functions.</p> <ul> <li><code>all()</code>: Matches everything.</li> <li><code>none()</code>: Matches nothing.</li> </ul>"},{"location":"filesets.html#examples","title":"Examples","text":"<p>Show diff excluding <code>Cargo.lock</code>.</p> <pre><code>jj diff '~Cargo.lock'\n</code></pre> <p>List files in <code>src</code> excluding Rust sources.</p> <pre><code>jj file list 'src ~ glob:\"**/*.rs\"'\n</code></pre> <p>Split a revision in two, putting <code>foo</code> into the second commit.</p> <pre><code>jj split '~foo'\n</code></pre>"},{"location":"gerrit.html","title":"Using Jujutsu with Gerrit Code Review","text":"<p>JJ and Gerrit share the same mental model, which makes Gerrit feel like a natural collaboration tool for JJ. JJ tracks a \"change identity\" across rewrites, and Gerrit\u2019s <code>Change-Id</code> tracks the same logical change across patch sets. JJ and Gerrit's <code>Change-Id</code>s aren\u2019t natively compatible yet, but they\u2019re philosophically aligned. <code>jj gerrit upload</code> bridges the gap today by adding a Gerrit-style <code>Change-Id</code> while JJ keeps its own notion of change identity on the client. In practice, that means small, clean commits that evolve over time, exactly how Gerrit wants you to work.</p> <p>This guide assumes a basic understanding of Git, Gerrit, and Jujutsu.</p>"},{"location":"gerrit.html#set-up-a-gerrit-remote","title":"Set up a Gerrit remote","text":"<p>Jujutsu communicates with Gerrit by pushing commits to a Git remote. If you're starting from an existing Git repository with Gerrit remotes already configured, you can use <code>jj git init --colocate</code> to start using JJ in that repo. Otherwise, set up your Gerrit remote.</p> <pre><code># Option 1: Start JJ in an existing Git repo with Gerrit remotes\n$ jj git init --colocate\n\n# Option 2: Add a Gerrit remote to a JJ repo\n$ jj git remote add gerrit https://review.gerrithub.io/yourname/yourproject\n\n# Option 3: Clone the repo via jj\n$ jj git clone https://review.gerrithub.io/your/project\n</code></pre> <p>If you used option 2, you can configure default values in your repository config by appending the following lines to your config file, like so (to do this for a specific repo, run <code>jj config edit --repo</code>):</p> <pre><code>[gerrit]\ndefault-remote = \"gerrit\"       # name of the Git remote to push to\ndefault-remote-branch = \"main\"  # target branch in Gerrit\n</code></pre>"},{"location":"gerrit.html#basic-workflow","title":"Basic workflow","text":"<p><code>jj gerrit upload</code> takes one or more revsets, and uploads the stack of commits ending in them to Gerrit. Each JJ change will map to a single Gerrit change based on the JJ change ID. This should be what you want most of the time, but if you want to associate a JJ change with a specific change already uploaded to Gerrit, you can copy the Change-Id footer from Gerrit to the bottom of the commit description in JJ.</p> <p>Note: Gerrit identifies and updates changes by the <code>Change-Id</code> trailer. When you re-upload a commit with the same <code>Change-Id</code>, Gerrit creates a new patch set.</p>"},{"location":"gerrit.html#upload-a-single-change","title":"Upload a single change","text":"<pre><code># upload the previous commit (@-) for review to main\n$ jj gerrit upload -r @-\n</code></pre>"},{"location":"gerrit.html#selecting-revisions-revsets","title":"Selecting revisions (revsets)","text":"<p><code>jj gerrit upload</code> accepts one or more <code>-r/--revisions</code> arguments. Each argument may expand to multiple commits. Common patterns:</p> <ul> <li><code>-r @-</code>: the commit previous to the one you're currently working on</li> <li><code>-r A..B</code>: commits that are ancestors of B but not of A</li> </ul> <p>See the revsets guide for more information.</p>"},{"location":"gerrit.html#preview-without-pushing","title":"Preview without pushing","text":"<p>Use <code>--dry-run</code> to see which commits would be modified and pushed, and where, without changing anything or contacting the remote.</p> <pre><code>$ jj gerrit upload -r '@-' --remote-branch main --dry-run\n</code></pre>"},{"location":"gerrit.html#target-branch-and-remote-selection","title":"Target branch and remote selection","text":"<p>There are a few way of specifying the target remote for your projects:</p> <ul> <li>Please run <code>jj config set --user gerrit.default-remote-branch &lt;branch name&gt;</code> to set your   default branch across all repos</li> <li>Please run <code>jj config set --repo gerrit.default-remote-branch &lt;branch name&gt;</code> to set your   default branch for this specific repo.</li> <li>Use <code>--remote-branch &lt;branch name&gt;</code> to override this for one specific occasion.</li> </ul> <p>The remote used to push is determined as follows:</p> <ul> <li>If you have more than one origin, or the origin isn't called gerrit, run   <code>jj config set --repo gerrit.default_remote &lt;gerrit remote name&gt;</code> to set-up a   default remote.</li> <li>To upload to a specific remote as a one-off thing, use <code>--remote &lt;remote name&gt;</code></li> </ul>"},{"location":"gerrit.html#updating-changes-after-review","title":"Updating changes after review","text":"<p>To address review feedback, update your revisions, then run <code>jj gerrit upload</code> again with the same revsets. Gerrit will add new patch sets to the existing changes instead of creating new ones.</p> <p>Examples:</p> <pre><code># Edit an earlier commit in the stack\n$ jj edit xcv  # position on the stack to edit\n --- Apply needed edits ---\n$ jj gerrit upload -r xcv\n</code></pre>"},{"location":"gerrit.html#change-id-management","title":"<code>Change-Id</code> management","text":"<p>When uploading, <code>jj gerrit upload</code> adds a <code>Change-Id</code> footer based on the JJ change id. That means that any changes made to a JJ change will become a new patch set on the Gerrit change during the next upload.</p> <p>Keep this association in mind when splitting or squashing changes. For example, when splitting a change, the portion that you want associated with the original Gerrit change should remain in the original JJ change (the first half of the split). Similarly, when squashing new changes, you typically want to squash into the change that was previously uploaded to Gerrit.</p> <p>If your JJ changes no longer align with the desired mapping to Gerrit changes, you can manually copy a Gerrit <code>Change-Id</code> footer into your JJ change description to directly assign a JJ change to an exist Gerrit change.</p> <p>As an alternative to <code>jj gerrit upload</code>'s automatic <code>Change-Id</code> mapping, you can configure JJ to automatically add <code>Change-Id</code> footers to all change descriptions:</p> <pre><code>[templates]\ncommit_trailers = '''\nif(\n  !trailers.contains_key(\"Change-Id\"),\n  format_gerrit_change_id_trailer(self)\n)\n'''\n</code></pre> <p>In this case, the Gerrit change mapping is defined entirely by the <code>Change-Id</code> footers. When splitting or squashing changes, be sure to keep the <code>Change-Id</code> footers associated with the desired changes. Be sure not to duplicate the same <code>Change-Id</code> across different changes. Gerrit will reject pushes that contain duplicate <code>Change-Id</code>s, but if the uploads are done separately, you may unintentionally overwrite an existing change.</p>"},{"location":"git-command-table.html","title":"Git command table","text":"<p>Note that all <code>jj</code> commands can be run on any commit (not just the working-copy commit), but that's left out of the table to keep it simple. For example, <code>jj squash -r &lt;revision&gt;</code> will move the diff from that revision into its parent.</p> Use case Git command Jujutsu command Notes Create a new repo <code>git init</code> <code>jj git init [--no-colocate]</code> Clone an existing repo <code>git clone &lt;source&gt; &lt;destination&gt; [--origin &lt;remote name&gt;]</code> <code>jj git clone &lt;source&gt; &lt;destination&gt; [--remote &lt;remote name&gt;]</code> There is no support for cloning non-Git repos yet. Update the local repo with all bookmarks/branches from a remote <code>git fetch [&lt;remote&gt;]</code> <code>jj git fetch [--remote &lt;remote&gt;]</code> There is no support for fetching into non-Git repos yet. Update a remote repo with all bookmarks/branches from the local repo <code>git push --all [&lt;remote&gt;]</code> <code>jj git push --all [--remote &lt;remote&gt;]</code> There is no support for pushing from non-Git repos yet. Update a remote repo with a single bookmark from the local repo <code>git push &lt;remote&gt; &lt;bookmark name&gt;</code> <code>jj git push --bookmark &lt;bookmark name&gt; [--remote &lt;remote&gt;]</code> There is no support for pushing from non-Git repos yet. Add a remote target to the repo <code>git remote add &lt;remote&gt; &lt;url&gt;</code> <code>jj git remote add &lt;remote&gt; &lt;url&gt;</code> Show summary of current work and repo status <code>git status</code> <code>jj st</code> Show diff of the current change <code>git diff HEAD</code> <code>jj diff</code> Show diff of another change <code>git diff &lt;revision&gt;^ &lt;revision&gt;</code> <code>jj diff -r &lt;revision&gt;</code> Show diff from another change to the current change <code>git diff &lt;revision&gt;</code> <code>jj diff --from &lt;revision&gt;</code> Show diff from change A to change B <code>git diff A B</code> <code>jj diff --from A --to B</code> Show all the changes in A..B <code>git diff A...B</code> <code>jj diff -r A..B</code> Show description and diff of a change <code>git show &lt;revision&gt;</code> <code>jj show &lt;revision&gt;</code> Add a file to the current change <code>touch filename; git add filename</code> <code>touch filename</code> Remove a file from the current change <code>git rm filename</code> <code>rm filename</code> Remove a previously tracked file from the current change, but keep it in the working copy <code>git rm --cached filename</code> <code>jj file untrack filename</code> File name must match an ignore pattern to remain untracked. See the documentation for working copies for more. Modify a file in the current change <code>echo stuff &gt;&gt; filename</code> <code>echo stuff &gt;&gt; filename</code> Finish work on the current change and start a new change <code>git commit -a</code> <code>jj commit</code> See compact log graph of ancestors of the current commit <code>git log --oneline --graph</code> <code>jj log -r ::@</code> See compact log graph of all reachable commits <code>git log --oneline --graph --all</code> <code>jj log -r 'all()'</code> or <code>jj log -r ::</code> In a Git-backed Jujutsu repository the Git command will also show all commits preserved by Jujutsu, including hidden commits. To exclude all commits only preserved by Jujutsu, replace <code>--all</code> by <code>--exclude refs/jj/* --all</code>. This will also exclude the Jujutsu-reachable commits though, if they are not Git-reachable. Show compact log graph of commits not on the main branch <code>git log --oneline --graph --branches --not upstream/main</code> <code>jj log</code> Show log of commits that have the string \"stuff\" in the changed lines <code>git log -G stuff</code> <code>jj log -r 'diff_lines(regex:stuff)'</code> List versioned files in the working copy <code>git ls-files --cached</code> <code>jj file list</code> Search among files versioned in the repository <code>git grep foo</code> <code>grep foo $(jj file list)</code> or <code>rg --no-require-git foo</code> Abandon the current change and start a new change <code>git reset --hard</code> (cannot be undone) <code>jj abandon</code> Make the current change empty <code>git reset --hard</code> (same as abandoning a change since Git has no concept of a \"change\") <code>jj restore</code> Abandon the parent of the working copy, but keep its diff in the working copy <code>git reset --soft HEAD~</code> <code>jj squash --from @-</code> Discard working copy changes in some files <code>git restore &lt;paths&gt;...</code> or <code>git checkout HEAD -- &lt;paths&gt;...</code> <code>jj restore &lt;paths&gt;...</code> Edit description (commit message) of the current change Not supported <code>jj describe</code> Edit description (commit message) of the previous change <code>git commit --amend --only</code> <code>jj describe @-</code> Edit description (commit message) of any change <code>git commit --fixup=reword:X; git rebase --autosquash X^</code> <code>jj describe X</code> Temporarily put away the current change <code>git stash</code> <code>jj new @-</code> The old working-copy commit remains as a sibling commit. The old working-copy commit X can be restored with <code>jj edit X</code>. Start working on a new change based on the  bookmark/branch <code>git switch -c topic main</code> or <code>git checkout -b topic main</code> (may need to stash or commit first) <code>jj new main</code> Merge branch A into the current change <code>git merge A</code> <code>jj new @ A</code> Check out a named revision (or branch) to examine source <code>git checkout v1.0.1</code> <code>jj new v1.0.1</code> Creates new empty change on top (see <code>jj new main</code>) Move bookmark/branch A onto bookmark/branch B <code>git rebase B A</code> (may need to rebase other descendant branches separately) <code>jj rebase -b A -o B</code> Move change A and its descendants onto change B <code>git rebase --onto B A^ &lt;some descendant bookmark&gt;</code> (may need to rebase other descendant bookmarks separately) <code>jj rebase -s A -o B</code> Reorder changes from A-B-C-D to A-C-B-D <code>git rebase -i A</code> <code>jj rebase -r C --before B</code> Move the diff in the current change into the parent change <code>git commit --amend -a</code> <code>jj squash</code> Interactively move part of the diff in the current change into the parent change <code>git add -p; git commit --amend</code> <code>jj squash -i</code> Move the diff in the working copy into an ancestor <code>git commit --fixup=X; git rebase --autosquash X^</code> <code>jj squash --into X</code> Interactively move part of the diff in an arbitrary change to another arbitrary change Not supported <code>jj squash -i --from X --into Y</code> Interactively split the changes in the working copy in two <code>git commit -p</code> <code>jj split</code> Interactively split an arbitrary change in two Not supported (can be emulated with the \"edit\" action in <code>git rebase -i</code>) <code>jj split -r &lt;revision&gt;</code> Interactively edit the diff in a given change Not supported (can be emulated with the \"edit\" action in <code>git rebase -i</code>) <code>jj diffedit -r &lt;revision&gt;</code> Resolve conflicts and continue interrupted operation <code>echo resolved &gt; filename; git add filename; git rebase/merge/cherry-pick --continue</code> <code>echo resolved &gt; filename; jj squash</code> Operations don't get interrupted, so no need to continue. Create a copy of a commit on top of another commit <code>git co &lt;destination&gt;; git cherry-pick &lt;source&gt;</code> <code>jj duplicate &lt;source&gt; -o &lt;destination&gt;</code> Find the root of the working copy (or check if in a repo) <code>git rev-parse --show-toplevel</code> <code>jj workspace root</code> List bookmarks/branches <code>git branch</code> <code>jj bookmark list</code> or <code>jj b l</code> for short Create a bookmark/branch <code>git branch &lt;name&gt; &lt;revision&gt;</code> <code>jj bookmark create &lt;name&gt; -r &lt;revision&gt;</code> Move a bookmark/branch forward <code>git branch -f &lt;name&gt; &lt;revision&gt;</code> <code>jj bookmark move &lt;name&gt; --to &lt;revision&gt;</code> or <code>jj b m &lt;name&gt; -t &lt;revision&gt;</code> for short Move a bookmark/branch backward or sideways <code>git branch -f &lt;name&gt; &lt;revision&gt;</code> <code>jj bookmark move &lt;name&gt; --to &lt;revision&gt; --allow-backwards</code> Delete a bookmark/branch <code>git branch --delete &lt;name&gt;</code> <code>jj bookmark delete &lt;name&gt;</code> See log of operations performed on the repo Not supported <code>jj op log</code> Undo the last operation Not supported <code>jj undo</code> There is also a matching <code>jj redo</code> command to redo the most recently undone operation. Revert an earlier operation Not supported <code>jj op revert</code> Create a commit that cancels out a previous commit <code>git revert &lt;revision&gt;</code> <code>jj revert -r &lt;revision&gt; -B @</code> Show what revision and author last modified each line of a file <code>git blame &lt;file&gt;</code> <code>jj file annotate &lt;path&gt;</code>"},{"location":"git-comparison.html","title":"Comparison with Git","text":""},{"location":"git-comparison.html#introduction","title":"Introduction","text":"<p>This document attempts to describe how Jujutsu is different from Git. See the Git-compatibility doc for information about how the <code>jj</code> command interoperates with Git repos. See the Git command table for a table of similar commands.</p>"},{"location":"git-comparison.html#overview","title":"Overview","text":"<p>Here is a list of conceptual differences between Jujutsu and Git, along with links to more details where applicable and available. There's a table explaining how to achieve various use cases.</p> <ul> <li>The working copy is automatically committed. That results in a simpler and   more consistent CLI because the working copy is now treated like any other   commit. Details.</li> <li>There's no index (staging area). Because the working copy is automatically   committed, an index-like concept doesn't make sense. The index is very similar   to an intermediate commit between <code>HEAD</code> and the working copy, so workflows   that depend on it can be modeled using proper commits instead. Jujutsu has   excellent support for moving changes between commits. Details.</li> <li>No need for branch names (but they are supported as   bookmarks). Git lets you check out a commit without   attaching a branch to it. It calls this state \"detached HEAD\". This is the   normal state in Jujutsu (there's actually no way -- yet, at least -- to have   an active branch/bookmark). However, Jujutsu keeps track of all visible heads   (leaves) of the commit graph, so the commits won't get lost or   garbage-collected.</li> <li> <p>No current branch. Git lets you check out a branch, making it the 'current   branch', and new commits will automatically update the branch. This is   necessary in Git because Git might otherwise lose track of the new commits.</p> <p>Jujutsu does not have a corresponding concept of a 'current bookmark'; instead, you update bookmarks manually. For example, if you start work on top of a commit with a bookmark, new commits are created on top of the bookmark, then you issue a later command to update the bookmark.</p> </li> <li> <p>Conflicts can be committed. No commands fail because of merge conflicts.   The conflicts are instead recorded in commits and you can resolve them later.   Details. This lets us rebase conflict and conflict   resolutions, and thereby addressing most <code>git rerere</code> use cases.</p> </li> <li>Descendant commits are automatically rebased. Whenever you rewrite a   commit (e.g. by running <code>jj rebase</code>), all its descendants commits will   automatically be rebased on top. Branches pointing to it will also get   updated, and so will the working copy if it points to any of the rebased   commits.</li> <li>No \"evil merges\". In Git, a merge commit that contains changes that are   not in any parent are called evil merges. We believe the reason for this   opinionated term is that Git has historically not been very good at working   with such commits. For example, <code>git show</code> doesn't show them well (without   <code>--remerge-diff</code> from 2022), and <code>git rebase</code> drops the changes (without   <code>--rebase-merges</code> from 2018). Jujutsu defines the changes in a commit as   being relative to the auto-merged parents in all contexts, so you can safely   include change in merge commits.</li> <li>Bookmarks/branches are identified by their names (across remotes). For   example, if you pull from a remote that has a <code>main</code> branch, you'll get a   bookmark by that name in your local repo. If you then move it and push back to   the remote, the <code>main</code> branch on the remote will be updated.   Details.</li> <li>The operation log replaces reflogs. The operation log is similar to   reflogs, but is much more powerful. It keeps track of atomic updates to all   refs at once (Jujutsu thus improves on Git's per-ref history much in the same   way that Subversion improved on RCS's per-file history). The operation log   powers e.g. the undo functionality. Details</li> <li>There's a single, virtual root commit. Like Mercurial, Jujutsu has a   virtual commit (with a hash consisting of only zeros) called the \"root commit\"   (called the \"null revision\" in Mercurial). This commit is a common ancestor of   all commits. That removes the awkward state Git calls the \"unborn branch\"   state (which is the state a newly initialized Git repo is in), and related   command-line flags (e.g. <code>git rebase --root</code>, <code>git checkout --orphan</code>).</li> </ul>"},{"location":"git-comparison.html#the-index","title":"The index","text":"<p>Git's \"index\" has multiple roles. One role is as a cache of file system information. Jujutsu has something similar. Unfortunately, Git exposes the index to the user, which makes the CLI unnecessarily complicated (learning what the different flavors of <code>git reset</code> do, especially when combined with commits and/or paths, usually takes a while). Jujutsu, like Mercurial, doesn't make that mistake.</p> <p>As a Git power-user, you may think that you need the power of the index to commit only part of the working copy. However, Jujutsu provides commands for more directly achieving most use cases you're used to using Git's index for. For example, to create a commit from part of the changes in the working copy, you might be used to using <code>git add -p; git commit</code>. With Jujutsu, you'd instead use <code>jj split</code> to split the working-copy commit into two commits. To add more changes into the parent commit, which you might normally use <code>git add -p; git commit --amend</code> for, you can instead use <code>jj squash -i</code> to choose which changes to move into the parent commit, or <code>jj squash &lt;file&gt;</code> to move a specific file.</p>"},{"location":"git-compatibility.html","title":"Git compatibility","text":"<p>Jujutsu has two backends for storing commits. One of them uses a regular Git repo, which means that you can collaborate with Git users without them even knowing that you're not using the <code>git</code> CLI.</p> <p>See <code>jj help git</code> for help about the <code>jj git</code> family of commands, and e.g. <code>jj help git push</code> for help about a specific command (use <code>jj git push -h</code> for briefer help).</p>"},{"location":"git-compatibility.html#supported-features","title":"Supported features","text":"<p>The following list describes which Git features Jujutsu is compatible with. For a comparison with Git, including how workflows are different, see the Git-comparison doc.</p> <ul> <li>Configuration: Partial. The only configuration from Git (e.g. in   <code>~/.gitconfig</code>) that's respected is the following. Feel free to file a bug if   you miss any particular configuration options.<ul> <li>The configuration of remotes (<code>[remote \"&lt;name&gt;\"]</code>). Simple fetch refspecs   are respected when branches are not explicitly specified on the CLI.   (<code>git</code> is used for remote operations)</li> <li><code>core.excludesFile</code></li> </ul> </li> <li>Authentication: Yes. <code>git</code> is used for remote operations under the hood.</li> <li>Branches: Yes. You can read more about   how branches work in Jujutsu   and how they interoperate with Git.</li> <li>Tags: Partial. You can check out tagged commits by name (pointed to by   either annotated or lightweight tags). You can also create lightweight tags,   but you cannot create annotated tags.</li> <li>.gitignore: Yes. Patterns in <code>.gitignore</code> files are supported. So are   ignores in <code>.git/info/exclude</code> or configured via Git's <code>core.excludesFile</code>   config. Since working-copy files are snapshotted by almost every <code>jj</code> command,   you might need to run <code>jj file untrack</code> to exclude newly ignored files from the   working-copy commit. It's recommended to set up the ignore patterns earlier.   The <code>.gitignore</code> support uses a native implementation, so please report a bug   if you notice any difference compared to <code>git</code>.</li> <li>.gitattributes: No. There's #53   about adding support for at least the <code>eol</code> attribute.</li> <li>Hooks: No. There's #405   specifically for providing the checks from https://pre-commit.com.</li> <li>Merge commits: Yes. Octopus merges (i.e. with more than 2 parents) are   also supported.</li> <li>Detached HEAD: Yes. Jujutsu supports anonymous branches, so this is a   natural state.</li> <li>Orphan branch: Yes. Jujutsu has a virtual root commit that appears as   parent of all commits Git would call \"root commits\".</li> <li>Staging area: Kind of. The staging area will be ignored. For example,   <code>jj diff</code> will show a diff from the Git HEAD to the working copy. There are   ways of fulfilling your use cases without a staging   area.</li> <li>Garbage collection: Yes. It should be safe to run <code>git gc</code> in the Git   repo, but it's not tested, so it's probably a good idea to make a backup of   the whole workspace first. There's no garbage collection and repacking of   Jujutsu's own data structures yet,   however.</li> <li>Bare repositories: Yes. You can use <code>jj git init --git-repo=&lt;path&gt;</code> to   create a repo backed by a bare Git repo.</li> <li>Submodules: No. They will not show up in the working copy, but they will   not be lost either.</li> <li>Partial clones: No.</li> <li>Shallow clones: Kind of. Shallow commits all have the virtual root commit   as their parent. However, deepening or fully unshallowing a repository is   currently not yet supported and will cause issues.</li> <li>git-worktree: No. However, there's native support for multiple working   copies backed by a single repo. See the <code>jj workspace</code> family of commands.</li> <li>Sparse checkouts: No. However, there's native support for sparse   checkouts. See the <code>jj sparse</code> command.</li> <li>Signed commits: Yes.   You can sign commits automatically by configuration,   or use the <code>jj sign</code> command.</li> <li>Git LFS: No. (#80)</li> </ul>"},{"location":"git-compatibility.html#creating-an-empty-repo","title":"Creating an empty repo","text":"<p>To create an empty repo using the Git backend, use <code>jj git init &lt;name&gt;</code>. This creates a colocated Jujutsu workspace, there will be a <code>.jj</code> directory and a <code>.git</code> directory.</p>"},{"location":"git-compatibility.html#creating-a-repo-backed-by-an-existing-git-repo","title":"Creating a repo backed by an existing Git repo","text":"<p>To create a Jujutsu repo backed by a Git repo you already have on disk, use <code>jj git init --git-repo=&lt;path to Git repo&gt; &lt;name&gt;</code>. The repo will work similar to a Git worktree, meaning that the working copies files and the record of the working-copy commit will be separate, but the commits will be accessible in both repos. Use <code>jj git import</code> to update the Jujutsu repo with changes made in the Git repo. Use <code>jj git export</code> to update the Git repo with changes made in the Jujutsu repo.</p>"},{"location":"git-compatibility.html#creating-a-repo-by-cloning-a-git-repo","title":"Creating a repo by cloning a Git repo","text":"<p>To create a Jujutsu repo from a remote Git URL, use <code>jj git clone &lt;URL&gt; [&lt;destination&gt;]</code>. For example, <code>jj git clone https://github.com/octocat/Hello-World</code> will clone GitHub's \"Hello-World\" repo into a directory by the same name.</p> <p>By default, the remote repository will be named <code>origin</code>. You can use a name of your choice by adding <code>--remote &lt;remote name&gt;</code> to the <code>jj git clone</code> command.</p>"},{"location":"git-compatibility.html#colocated-jujutsugit-workspaces","title":"Colocated Jujutsu/Git workspaces","text":"<p>A colocated Jujutsu workspace is a hybrid Jujutsu/Git workspace. This is the default for Git-backed workspace created with <code>jj git init</code> or <code>jj git clone</code>. The Git repo and the Jujutsu workspace then share the same working copy. Jujutsu will import and export from and to the Git repo on every <code>jj</code> command automatically.</p> <p>This mode is very convenient when tools (e.g. build tools) expect a Git repo to be present.</p> <p>It is allowed to mix <code>jj</code> and <code>git</code> commands in such a workspace in any order. However, it may be easier to keep track of what is going on if you mostly use read-only <code>git</code> commands and use <code>jj</code> to make changes to the repo. One reason for this (see below for more) is that <code>jj</code> commands will usually put the Git repo in a \"detached HEAD\" state, since in <code>jj</code> there is not concept of a \"currently tracked branch\". Before doing mutating Git commands, you may need to tell Git what the current branch should be with a <code>git switch</code> command.</p> <p>You can undo the results of mutating <code>git</code> commands using <code>jj undo</code> and <code>jj op restore</code>. Inside <code>jj op log</code>, changes by <code>git</code> will be represented as an \"import git refs\" operation.</p> <p>You can disable colocation with the <code>--no-colocate</code> flag on the commands <code>jj git init</code> and <code>jj git clone</code> or by setting the configuration <code>git.colocate = false</code>. Much of the repo data will still be stored in the Git repository format, but the Git repository will be hidden inside a sub-directory of the <code>.jj</code> directory. Moreover, unless you explicitly use the <code>jj git import</code> and <code>jj git export</code> commands, that Git repository will either have no branches at all (not even a main branch) or will have branches that are out of date with jj's bookmarks.</p> <p>Colocation can be disabled because it does have some disadvantages:</p> <ul> <li> <p>Interleaving <code>jj</code> and <code>git</code> commands increases the chance of confusing branch   conflicts or conflicted (AKA divergent) change   ids. These never lose data, but can be   annoying.</p> <p>Such interleaving can happen unknowingly. For example, some IDEs can cause it because they automatically run <code>git fetch</code> in the background from time to time.</p> </li> <li> <p>In colocated workspaces with a very large number of branches or other refs,   <code>jj</code> commands can get noticeably slower because of the automatic   <code>jj git import</code> executed on each command. This can be mitigated by   occasionally running <code>jj util gc</code> to speed up the import (that command   includes packing the Git refs).</p> </li> <li> <p>Git tools will have trouble with revisions that contain conflicted files.   While <code>jj</code> renders these files with conflict markers in the working copy, they   are stored in a non-human-readable fashion inside the repo. Git tools will   often see this non-human-readable representation.</p> </li> <li> <p>When a <code>jj</code> branch is conflicted, the position of the branch in the Git repo   will disagree with one or more of the conflicted positions. The state of that   branch in git will be labeled as though it belongs to a remote named \"git\",   e.g. <code>branch@git</code>.</p> </li> <li> <p>Jujutsu will ignore Git's staging area. It will not understand merge conflicts   as Git represents them, unfinished <code>git rebase</code> states, as well as other less   common states a Git repository can be in.</p> </li> <li> <p>Colocated workspaces are less resilient to   concurrency   issues if you share the repo using an NFS filesystem or Dropbox. In general,   such use of Jujutsu is not currently thoroughly tested.</p> </li> <li> <p>There may still be bugs when interleaving mutating <code>jj</code> and <code>git</code> commands,   usually having to do with a branch pointer ending up in the wrong place. We   are working on the known ones, and are not aware of any major ones. Please   report any new ones you find, or if any of the known bugs are less minor than   they appear.</p> </li> </ul>"},{"location":"git-compatibility.html#converting-a-workspace-into-a-colocated-workspace","title":"Converting a workspace into a colocated workspace","text":"<p>A Jujutsu workspace backed by a Git repo has a full Git repo inside. Such a workspace can be converted into a colocated workspace using the <code>jj git colocation</code> command.</p> <p>To check the current colocation status of your workspace:</p> <pre><code>jj git colocation status\n</code></pre> <p>To convert to a colocated workspace:</p> <pre><code>jj git colocation enable\n</code></pre> <p>To convert to a non-colocated workspace:</p> <pre><code>jj git colocation disable\n</code></pre> <p>The <code>jj colocation enable</code> command automates the following manual process:</p> <pre><code># Ignore the .jj directory in Git\necho '/*' &gt; .jj/.gitignore\n# Move the Git repo\nmv .jj/repo/store/git .git\n# Tell jj where to find it (do not use on Windows! See below.)\necho -n '../../../.git' &gt; .jj/repo/store/git_target\n# Make the Git repository non-bare and set HEAD\ngit config --unset core.bare\n# Convince jj to update .git/HEAD to point to the working-copy commit's parent\njj new &amp;&amp; jj undo\n</code></pre> <p>Warning</p> <p>On Windows, the <code>echo</code> command will append line endings and cause <code>jj</code> to complain about the contents of <code>git_target</code>.</p> <p>Instead of the <code>echo -n ...</code> line, use: <code>Set-Content -Path .jj/repo/store/git_target -Value ../../../.git -NoNewLine</code></p>"},{"location":"git-compatibility.html#branches","title":"Branches","text":"<p>TODO: Describe how branches are mapped</p>"},{"location":"git-compatibility.html#format-mapping-details","title":"Format mapping details","text":"<p>Paths are assumed to be UTF-8. I have no current plans to support paths with other encodings.</p> <p>Commits created by <code>jj</code> have a ref starting with <code>refs/jj/</code> to prevent GC.</p> <p>Commit metadata that cannot be represented in Git commits (such as the Change ID and information about conflicts) is stored outside of the Git repo (currently in <code>.jj/store/extra/</code>).</p> <p>Commits with conflicts cannot be represented in Git. They appear in the Git commit as root directories called<code>.jjconflict-base-*/</code> and <code>.jjconflict-side-*/</code>. Note that the purpose of this representation is only to prevent GC of the relevant trees; the authoritative information is in the Git-external storage mentioned in the paragraph above. As long as you use <code>jj</code> commands to work with them, you won't notice those paths. If, on the other hand, you use e.g. <code>git switch</code> to check one of them out, you will see those directories in your working copy. If you then run e.g. <code>jj status</code>, the resulting snapshot will contain those directories, making it look like they replaced all the other paths in your repo. You will probably want to run <code>jj abandon</code> to get back to the state with the unresolved conflicts.</p> <p>Change IDs are stored in git commit headers as reverse hex encodings. This is a non-standard header and is not preserved by all <code>git</code> tooling. For example, the header is preserved by a <code>git commit --amend</code>, but is not preserved through a rebase operation. GitHub and other major forges seem to preserve them for the most part. This functionality is currently behind a <code>git.write-change-id-header</code> flag.</p>"},{"location":"git-experts.html","title":"Jujutsu for Git experts","text":"<p>People who are proficient with Git often ask what benefit there is to using Jujutsu. This page explains the practical advantages for Git experts, with examples showing how common workflows become easier, safer, or faster with Jujutsu.</p>"},{"location":"git-experts.html#git-can-be-used-side-by-side-in-the-same-repository","title":"Git can be used side-by-side in the same repository","text":"<p>Jujutsu and Git repositories exist in the same directory, so you can use <code>jj</code> and <code>git</code> side-by-side (this is called colocation). If you find a situation that's easier with Git, run the <code>git</code> command and return to <code>jj</code> when you're done (and please make a feature request if there isn't one yet!).</p> <p>Colocation makes migration easier because you can adopt Jujutsu for the workflows it improves without losing access to the Git commands and tools you already know.</p>"},{"location":"git-experts.html#the-git-indexstaging-area","title":"The Git index/staging area","text":"<p>Jujutsu does not have an index/staging area as Git does. Because rewriting commits is quick and easy, it's natural to use commits as a replacement for the index.</p> <p>Instead of separate commands just for interacting with the index (<code>git add</code>, <code>git rm --cached</code>), the commands <code>jj split</code> and <code>jj squash</code> can be used to move work-in-progress as easily as moving finished work.</p> <pre><code># Split the working copy commit into two sequential commits, putting file1 and\n# file2 In the first commit\njj split file1 file2\n\n# or interactively select which changes to split\njj split\n\n# Move the changes in file3 into the parent commit\njj squash file3\n# or, interactively:\njj squash -i\n</code></pre>"},{"location":"git-experts.html#automatic-and-safer-history-editing","title":"Automatic and safer history editing","text":"<p>If you frequently amend, reorder, or squash commits, Jujutsu can often perform the same operations in fewer commands.</p> <p>Suppose you want to amend an older commit. With Git you might do this in three steps:</p> <pre><code>git add file1 file2\ngit commit --fixup abc\ngit rebase -i --autosquash\n</code></pre> <p>With Jujutsu, you simply squash the changes directly into the commit you want to amend. All descendants are automatically rebased on top of the amended commit:</p> <pre><code>jj squash --into abc file1 file2\n</code></pre>"},{"location":"git-experts.html#undo-is-more-powerful-than-using-the-reflog","title":"Undo is more powerful than using the reflog","text":"<p>Git's reflog is powerful, but it's per-ref and can be awkward to use when multiple refs and operations are involved.</p> <p>Jujutsu's operation log records the state of the entire repository: Every change is an operation you can inspect, and you can restore to any earlier state with one command.</p> <p>Common uses of the operation log:</p> <ul> <li> <p><code>jj undo</code> reverts the last operation in one step, without needing to figure   out which ref to reset. You can repeat <code>jj undo</code> to continue stepping backwards   in time.</p> </li> <li> <p><code>jj op log -p</code> shows operations with diffs so you can inspect what happened.</p> </li> <li> <p><code>--at-operation ID</code> lets you run commands as if the repository were in a   previous state.</p> </li> </ul>"},{"location":"git-experts.html#the-evolution-log-shows-the-history-of-a-single-change","title":"The evolution log shows the history of a single change","text":"<p>The Git reflog shows how refs moved over time, but makes it difficult to see how a particular commit evolved over time. Jujutsu's evolution log (\"evolog\") shows exactly this: Each time a change is rewritten, the update is visible in the evolog.</p> <p>You can use the evolog to find a previous version, then <code>jj restore</code> to restore the complete or partial contents to the current version.</p>"},{"location":"git-experts.html#jj-absorb-makes-it-easier-to-update-a-patch-stack","title":"<code>jj absorb</code> makes it easier to update a patch stack","text":"<p>When amending several commits in a stack of changes, Git requires you to run <code>git commit --fixup &lt;ID&gt;</code> at least once for each commit before running <code>git rebase --autosquash</code>.</p> <p><code>jj absorb</code> is useful when you've made small fixes in the working copy and want them incorporated into recent commits. It automatically moves each change in the working copy into the previous commit where that line was changed.</p> <p>It doesn't solve all cases: If multiple commits in the stack modified the same line as was changed in the working copy, it will not move that change. But it does help the trivial cases, leaving you to decide how to squash the remaining changes.</p>"},{"location":"github.html","title":"Using Jujutsu with GitHub and GitLab Projects","text":"<p>This guide assumes a basic understanding of either Git or Mercurial.</p>"},{"location":"github.html#basic-workflow","title":"Basic workflow","text":"<p>The simplest way to start with Jujutsu is to create a stack of commits first. You will only need to create a bookmark when you need to push the stack to a remote. There are two primary workflows: using a generated bookmark name or naming a bookmark.</p>"},{"location":"github.html#using-a-generated-bookmark-name","title":"Using a generated bookmark name","text":"<p>In this example we're letting Jujutsu auto-create a bookmark.</p> <pre><code># Start a new commit off of the default bookmark.\n$ jj new main\n# Refactor some files, then add a description and start a new commit\n$ jj commit -m 'refactor(foo): restructure foo()'\n# Add a feature, then add a description and start a new commit\n$ jj commit -m 'feat(bar): add support for bar'\n# Let Jujutsu generate a bookmark name and push that to GitHub. Note that we\n# push the working-copy commit's *parent* because the working-copy commit\n# itself is empty.\n$ jj git push --change @- # or -c for short\n</code></pre>"},{"location":"github.html#using-a-named-bookmark","title":"Using a named bookmark","text":"<p>In this example, we create a bookmark named <code>bar</code> and then push it to the remote.</p> <pre><code># Start a new commit off of the default bookmark.\n$ jj new main\n# Refactor some files, then add a description and start a new commit\n$ jj commit -m 'refactor(foo): restructure foo()'\n# Add a feature, then add a description and start a new commit\n$ jj commit -m 'feat(bar): add support for bar'\n# Create a bookmark so we can push it to GitHub. Note that we created the bookmark\n# on the working-copy commit's *parent* because the working copy itself is empty.\n$ jj bookmark create bar -r @- # `bar` now contains the previous two commits.\n# Set the bookmark to be tracked on the remote.\n$ jj bookmark track bar\n# Push the bookmark to GitHub (pushes only `bar`)\n$ jj git push\n</code></pre> <p>While it's possible to create a bookmark in advance and commit on top of it in a Git-like manner, you will then need to move the bookmark manually when you create a new commits. Unlike Git, Jujutsu will not do it automatically.</p>"},{"location":"github.html#updating-the-repository","title":"Updating the repository","text":"<p>As of October 2023, Jujutsu has no equivalent to a <code>git pull</code> command (see issue #1039). Until such a command is added, you need to use <code>jj git fetch</code> followed by a <code>jj rebase -o $main_bookmark</code> to update your changes.</p>"},{"location":"github.html#working-in-a-git-colocated-workspaces","title":"Working in a Git colocated workspaces","text":"<p>After doing <code>jj git init</code>, which colocates the <code>.jj</code> and <code>.git</code> directories, Git will be in a detached HEAD state, which is unusual, as Git mainly works with named branches; jj does not.</p> <p>In a colocated workspace, every <code>jj</code> command will automatically synchronize Jujutsu's view of the repo with Git's view. For example, <code>jj commit</code> updates the HEAD of the Git repository, enabling an incremental migration.</p> <pre><code>$ nvim docs/tutorial.md\n$ # Do some more work.\n$ jj commit -m \"Update tutorial\"\n# Create a bookmark on the working-copy commit's parent\n$ jj bookmark create doc-update -r @-\n$ jj bookmark track doc-update\n$ jj git push\n</code></pre>"},{"location":"github.html#working-in-a-jujutsu-repository","title":"Working in a Jujutsu repository","text":"<p>In a Jujutsu repository, the workflow is simplified. If there's no need for explicitly named bookmarks, you can just generate one for a change. As Jujutsu is able to create a bookmark for a revision.</p> <pre><code>$ # Do your work\n$ jj commit\n$ # Push change \"mw\", letting Jujutsu automatically create a bookmark called\n$ # \"push-mwmpwkwknuz\"\n$ jj git push -c mw\n</code></pre>"},{"location":"github.html#addressing-review-comments","title":"Addressing review comments","text":"<p>There are two workflows for addressing review comments, depending on your project's preference. Many projects prefer that you address comments by adding commits to your bookmark<sup>1</sup>. Some projects (such as Jujutsu and LLVM) instead prefer that you keep your commits clean by rewriting them and then force-pushing<sup>2</sup>.</p>"},{"location":"github.html#adding-new-commits","title":"Adding new commits","text":"<p>If your project prefers that you address review comments by adding commits on top, you can do that by doing something like this:</p> <pre><code>$ # Create a new commit on top of the `your-feature` bookmark from above.\n$ jj new your-feature\n$ # Address the comments by updating the code. Then review the changes.\n$ jj diff\n$ # Give the fix a description and create a new working-copy on top.\n$ jj commit -m 'address pr comments'\n$ # Update the bookmark to point to the new commit.\n$ jj bookmark move your-feature --to @-\n$ # Push it to your remote\n$ jj git push\n</code></pre> <p>Notably, the above workflow creates a new commit for you. The same can be achieved without creating a new commit.</p> <p>Warning</p> <p>We strongly suggest to <code>jj new</code> after the example below, as all further edits still get amended to the previous commit.</p> <pre><code>$ # Create a new commit on top of the `your-feature` bookmark from above.\n$ jj new your-feature\n$ # Address the comments by updating the code. Then review the changes.\n$ jj diff\n$ # Give the fix a description.\n$ jj describe -m 'address pr comments'\n$ # Update the bookmark to point to the current commit.\n$ jj bookmark move your-feature --to @\n$ # Push it to your remote\n$ jj git push\n</code></pre>"},{"location":"github.html#rewriting-commits","title":"Rewriting commits","text":"<p>If your project prefers that you keep commits clean, you can do that by doing something like this:</p> <pre><code>$ # Create a new commit on top of the second-to-last commit in `your-feature`,\n$ # as reviewers requested a fix there.\n$ jj new your-feature- # NOTE: the trailing hyphen is not a typo!\n$ # Address the comments by updating the code. Then review the changes.\n$ jj diff\n$ # Squash the changes into the parent commit\n$ jj squash\n$ # Push the updated bookmark to the remote. Jujutsu automatically makes it a\n$ # force push\n$ jj git push --bookmark your-feature\n</code></pre> <p>The hyphen after <code>your-feature</code> comes from the revset syntax.</p>"},{"location":"github.html#working-with-other-peoples-bookmarks","title":"Working with other people's bookmarks","text":"<p>By default, <code>jj git clone</code> imports the default remote bookmark (which is usually <code>main</code> or <code>master</code>), but <code>jj git fetch</code> doesn't import new remote bookmarks to local bookmarks. This means that if you want to iterate or test another contributor's bookmark, you'll need to do <code>jj new &lt;bookmark&gt;@&lt;remote&gt;</code> onto it.</p> <p>If you want to import all remote bookmarks including inactive ones, set <code>remotes.&lt;name&gt;.auto-track-bookmarks = \"*\"</code> in the config file. Then you can specify a contributor's bookmark as <code>jj new &lt;bookmark&gt;</code> instead of <code>jj new &lt;bookmark&gt;@&lt;remote&gt;</code>.</p> <p>You can find more information on that setting here.</p>"},{"location":"github.html#using-github-cli","title":"Using GitHub CLI","text":"<p>GitHub CLI will have trouble finding the proper Git repository path in jj repos that aren't colocated (see issue #1008). You can configure the <code>$GIT_DIR</code> environment variable to point it to the right path:</p> <pre><code>$ GIT_DIR=.jj/repo/store/git gh issue list\n</code></pre> <p>You can make that automatic by installing direnv and defining hooks in a <code>.envrc</code> file in the repository root to configure <code>$GIT_DIR</code>. Just add this line into <code>.envrc</code>:</p> <pre><code>export GIT_DIR=$PWD/.jj/repo/store/git\n</code></pre> <p>and run <code>direnv allow</code> to approve it for direnv to run. Then GitHub CLI will work automatically even in workspaces that aren't colocated so you can execute commands like <code>gh issue list</code> normally.</p>"},{"location":"github.html#useful-revsets","title":"Useful Revsets","text":"<p>Log all revisions across all local bookmarks that aren't on the main bookmark nor on any remote:</p> <pre><code>$ jj log -r 'bookmarks() &amp; ~(main | remote_bookmarks())'\n</code></pre> <p>Log all revisions that you authored, across all bookmarks that aren't on any remote:</p> <pre><code>$ jj log -r 'mine() &amp; bookmarks() &amp; ~remote_bookmarks()'\n</code></pre> <p>Log all remote bookmarks that you authored or committed to:</p> <pre><code>$ jj log -r 'remote_bookmarks() &amp; (mine() | committer(your@email.com))'\n</code></pre> <p>Log all ancestors of the current working copy that aren't on any remote:</p> <pre><code>$ jj log -r 'remote_bookmarks()..@'\n</code></pre>"},{"location":"github.html#merge-conflicts","title":"Merge conflicts","text":"<p>For a detailed overview, how Jujutsu handles conflicts, revisit the tutorial.</p>"},{"location":"github.html#using-several-remotes","title":"Using several remotes","text":"<p>It is common to use several remotes when contributing to a shared repository. For example, \"upstream\" can designate the remote where the changes will be merged through a pull-request while \"origin\" is your private fork of the project.</p> <pre><code>$ jj git clone --remote upstream https://github.com/upstream-org/repo\n$ cd repo\n$ jj git remote add origin git@github.com:your-org/your-repo-fork\n</code></pre> <p>This will automatically setup your repository to track the main bookmark from the upstream repository, typically <code>main@upstream</code> or <code>master@upstream</code>.</p> <p>You might want to <code>jj git fetch</code> from \"upstream\" and to <code>jj git push</code> to \"origin\". You can configure the default remotes to fetch from and push to in your configuration file (<code>jj config edit --user|repo|workspace</code>):</p> <pre><code>[git]\nfetch = \"upstream\"\npush = \"origin\"\n</code></pre> <p>The default for both <code>git.fetch</code> and <code>git.push</code> is \"origin\".</p> <p>If you usually work on a project from several computers, you may configure <code>jj</code> to fetch from both repositories by default, in order to keep your own bookmarks synchronized through your <code>origin</code> repository:</p> <pre><code>[git]\nfetch = [\"upstream\", \"origin\"]\npush = \"origin\"\n</code></pre> <ol> <li> <p>This is a GitHub-style review, as GitHub currently only is able to compare bookmarks.\u00a0\u21a9</p> </li> <li> <p>If you're wondering why we prefer clean commits in this project, see e.g. this blog post \u21a9</p> </li> </ol>"},{"location":"glossary.html","title":"Glossary","text":""},{"location":"glossary.html#anonymous-branch","title":"Anonymous branch","text":"<p>An anonymous branch is a chain of commits that doesn't necessarily have any bookmarks pointing to it or to any of its descendants. Unlike Git, Jujutsu keeps commits on anonymous branches around until they are explicitly abandoned. Visible anonymous branches are tracked by the view, which stores a list of heads of such branches.</p>"},{"location":"glossary.html#backend","title":"Backend","text":"<p>A backend is an implementation of the storage layer. There is currently only one production-ready builtin commit backend: the Git backend. The Git backend stores commits in a Git repository. There are several backends used for testing. Google also has its own cloud-based backend.</p> <p>There are also pluggable backends for storing other information than commits, such as the \"operation store backend\" for storing the operation log.</p>"},{"location":"glossary.html#bookmark","title":"Bookmark","text":"<p>A bookmark is a named pointer to a commit. They are similar to Git's branches and even more similar to Mercurial's bookmarks. See here for details.</p> <p>Unlike in Git, there is no concept of a \"current bookmark\"; bookmarks do not move when you create a new commit. Bookmarks do automatically follow the commit if it gets rewritten.</p>"},{"location":"glossary.html#branch","title":"Branch","text":"<p>In the context of <code>jj</code>, the word \"branch\" usually refers to an anonymous branch or, less formally, a branch of the commit \"tree\" (which is itself an informal way to refer to the commit graph, parts of which might resemble a tree even when it's not mathematically a tree).</p> <p>We also sometimes discuss Git's branches and branches on Git remotes. Locally, these correspond to bookmarks. In a colocated workspace, each local Git branch corresponds to a <code>jj</code> bookmark.</p>"},{"location":"glossary.html#change","title":"Change","text":"<p>A change is a commit as it evolves over time. Changes themselves don't exist as an object in the data model; only the change ID does. The change ID is a property of a commit.</p>"},{"location":"glossary.html#change-id","title":"Change ID","text":"<p>A change ID is a unique identifier for a change. They are typically 16 bytes long and are often randomly generated. By default, <code>jj log</code> presents them as a sequence of 12 letters in the k-z range, at the beginning of a line. These are actually hexadecimal numbers that use \"digits\" z-k instead of 0-9a-f.</p>"},{"location":"glossary.html#change-offset","title":"Change offset","text":"<p>Sometimes a change ID might not unambiguously identify a commit, such as if the commit is hidden or if the change ID is divergent. In these cases, you can add an offset after the change ID to make it clear which commit you are referring to, with the most recent commit having an offset of 0. For instance, the most recent commit with change ID <code>xyz</code> could be referred to as <code>xyz/0</code>, while the one before it would be <code>xyz/1</code>, and so on.</p>"},{"location":"glossary.html#commit","title":"Commit","text":"<p>A snapshot of the files in the repository at a given point in time (technically a tree object), together with some metadata. The metadata includes the author, the date, and pointers to the commit's parents. Through the pointers to the parents, the commits form a Directed Acyclic Graph (DAG) .</p> <p>Note that even though commits are stored as snapshots, they are often treated as differences between snapshots, namely compared to their parent's snapshot. If they have more than one parent, then the difference is computed against the result of merging the parents. For example, <code>jj diff</code> will show the differences introduced by a commit compared to its parent(s), and <code>jj rebase</code> will apply those changes onto another base commit.</p> <p>The word \"revision\" is used as a synonym for \"commit\".</p>"},{"location":"glossary.html#commit-id","title":"Commit ID","text":"<p>A commit ID is a unique identifier for a commit. They are 20 bytes long when using the Git backend. They are presented in regular hexadecimal format at the end of the line in <code>jj log</code>, using 12 hexadecimal digits by default. When using the Git backend, the commit ID is the Git commit ID.</p>"},{"location":"glossary.html#colocated-workspaces","title":"Colocated workspaces","text":"<p>When using the Git backend and the backing Git repository's <code>.git/</code> directory is a sibling of <code>.jj/</code>, we call the workspace colocated. Most tools designed for Git can be easily used on such workspace. <code>jj</code> and <code>git</code> commands can be used interchangeably.</p> <p>See here for details.</p>"},{"location":"glossary.html#conflict","title":"Conflict","text":"<p>Conflicts can occur in many places. The most common type is conflicts in files. Those are the conflicts that users coming from other VCSs are usually familiar with. You can see them in <code>jj status</code> and in <code>jj log</code> (the red \"conflict\" label at the end of the line). See here for details.</p> <p>Conflicts can also occur in bookmarks. For example, if you moved a bookmark locally, and it was also moved on the remote, then the bookmark will be in a conflicted state after you pull from the remote. See here for details.</p> <p>Similar to a bookmark conflict, when a change is rewritten locally and remotely, for example, then the change will be in a conflicted state. We call that a divergent change.</p>"},{"location":"glossary.html#divergent-change","title":"Divergent change","text":"<p>A divergent change is a change that has more than one visible commit. These changes are displayed with a label of \"divergent\" in the log.</p>"},{"location":"glossary.html#head","title":"Head","text":"<p>A head is a commit with no descendants. The context in which it has no descendants varies. For example, the <code>heads(X)</code> revset function returns commits that have no descendants within the set <code>X</code> itself. The view records which anonymous heads (heads without a bookmark pointing to them) are visible at a given operation. Note that this is quite different from Git's HEAD.</p>"},{"location":"glossary.html#hidden-commits-abandoned-commits","title":"Hidden commits, abandoned commits","text":"<p>See visible commits.</p>"},{"location":"glossary.html#operation","title":"Operation","text":"<p>A snapshot of the visible commits and bookmarks at a given point in time (technically a view object), together with some metadata. The metadata includes the username, hostname, timestamps, and pointers to the operation's parents.</p>"},{"location":"glossary.html#operation-log","title":"Operation log","text":"<p>The operation log is the DAG formed by operation objects, much in the same way that commits form a DAG, which is sometimes called the \"commit history\". When operations happen in sequence, they form a single line in the graph. Operations that happen concurrently from jj's perspective result in forks and merges in the DAG.</p>"},{"location":"glossary.html#repository","title":"Repository","text":"<p>Basically everything under <code>.jj/</code>, i.e. the full set of operations and commits.</p>"},{"location":"glossary.html#remote","title":"Remote","text":"<p>A remote is a reference to a copy of your repository. The most common case is that the remote is hosted on the internet or another network, but local remotes are also possible. Remotes are useful when working on a project with multiple collaborators. As Jujutsu is compatible with Git you can use all popular providers that are also available for Git. For example GitHub, GitLab or Codeberg.</p>"},{"location":"glossary.html#revision","title":"Revision","text":"<p>A synonym for Commit.</p>"},{"location":"glossary.html#revset","title":"Revset","text":"<p>Jujutsu supports a functional language for selecting a set of revisions. Expressions in this language are called \"revsets\". See here for details. We also often use the term \"revset\" for the set of revisions selected by a revset.</p>"},{"location":"glossary.html#rewrite","title":"Rewrite","text":"<p>To \"rewrite\" a commit means to create a new version of that commit with different contents, metadata (including parent pointers), or both. Rewriting a commit results in a new commit, and thus a new commit ID, but the change ID generally remains the same. Some examples of rewriting a commit would be changing its description or rebasing it. Modifying the working copy rewrites the working copy commit.</p>"},{"location":"glossary.html#root-commit","title":"Root commit","text":"<p>The root commit is a virtual commit at the root of every repository. It has a commit ID consisting of all '0's (<code>00000000...</code>) and a change ID consisting of all 'z's (<code>zzzzzzzz...</code>). It can be referred to in revsets by the function <code>root()</code>. Note that our definition of \"root commit\" is different from Git's; Git's \"root commits\" are the first commit(s) in the repository, i.e. the commits <code>jj log -r 'root()+'</code> will show.</p>"},{"location":"glossary.html#tree","title":"Tree","text":"<p>A tree object represents a snapshot of a directory in the repository. Tree objects are defined recursively; each tree object only has the files and directories contained directly in the directory it represents.</p>"},{"location":"glossary.html#tracked-bookmarks-and-tracking-bookmarks","title":"Tracked bookmarks and tracking bookmarks","text":"<p>A remote bookmark can be made \"tracked\" with the <code>jj bookmark track</code> command. This results in a \"tracking\" local bookmark that tracks the remote bookmark.</p> <p>See the bookmarks documentation for a more detailed definition of these terms.</p>"},{"location":"glossary.html#visible-commits","title":"Visible commits","text":"<p>Visible commits are the commits you see in <code>jj log -r 'all()'</code>. They are the commits that are reachable from an anonymous head in the view. Ancestors of a visible commit are implicitly visible.</p> <p>Intuitively, visible commits are the \"latest versions\" of a given change. A commit that's abandoned or rewritten stops being visible and is labeled as \"hidden\". Such commits are no longer accessible using a change id, but they are still accessible by their commit id.</p>"},{"location":"glossary.html#view","title":"View","text":"<p>A view is a snapshot of bookmarks and their targets, anonymous heads, and working-copy commits. The anonymous heads define which commits are visible.</p> <p>A view object is similar to a tree object in that it represents a snapshot without history, and an operation object is similar to a commit object in that it adds metadata and history.</p>"},{"location":"glossary.html#workspace","title":"Workspace","text":"<p>A workspace is a working copy and an associated repository. There can be multiple workspaces for a single repository. Each workspace has a <code>.jj/</code> directory, but the commits and operations will be stored in the initial workspace; the other workspaces will have pointers to the initial workspace. See here for details.</p> <p>This is what Git calls a \"worktree\".</p>"},{"location":"glossary.html#working-copy","title":"Working copy","text":"<p>The working copy contains the files you're currently working on. It is automatically snapshot at the beginning of almost every <code>jj</code> command, thus creating a new working-copy commit if any changes had been made in the working copy. Conversely, the working copy is automatically updated to the state of the working-copy commit at the end of almost every <code>jj</code> command. See here for details.</p> <p>This is what Git calls a \"working tree\".</p>"},{"location":"glossary.html#working-copy-commit","title":"Working-copy commit","text":"<p>A commit that corresponds to the current state of the working copy. There is one working-copy commit per workspace. The current working-copy commits are tracked in the operation log.</p>"},{"location":"install-and-setup.html","title":"Installation and setup","text":""},{"location":"install-and-setup.html#installation","title":"Installation","text":""},{"location":"install-and-setup.html#download-pre-built-binaries-for-a-release","title":"Download pre-built binaries for a release","text":"<p>There are pre-built binaries of the last released version of <code>jj</code> for Windows, Mac, or Linux (the \"musl\" version should work on all distributions).</p>"},{"location":"install-and-setup.html#cargo-binstall","title":"Cargo Binstall","text":"<p>If you use <code>cargo-binstall</code>, you can install binaries of the latest <code>jj</code> release from GitHub as follows:</p> <pre><code># Will put the jj binary for the latest release in ~/.cargo/bin by default\ncargo binstall --strategies crate-meta-data jj-cli\n</code></pre> <p>Without the <code>--strategies</code> option, you may get equivalent binaries that should be compiled from the same source code.</p> <p>Note</p> <p>If you'd like to install a prerelease version, you'll need to use one of the options below.</p>"},{"location":"install-and-setup.html#linux","title":"Linux","text":""},{"location":"install-and-setup.html#from-source","title":"From Source","text":"<p>First make sure that you have a Rust version &gt;= 1.88 and that the <code>build-essential</code> package is installed by running something like this:</p> <pre><code>sudo apt-get install build-essential\n</code></pre> <p>Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git --locked --bin jj jj-cli\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --locked --bin jj jj-cli\n</code></pre>"},{"location":"install-and-setup.html#arch-linux","title":"Arch Linux","text":"<p>You can install the <code>jujutsu</code> package from the official extra repository:</p> <pre><code>pacman -S jujutsu\n</code></pre> <p>Or install from the AUR repository with an AUR Helper:</p> <pre><code>yay -S jujutsu-git\n</code></pre>"},{"location":"install-and-setup.html#nixos","title":"NixOS","text":"<p>If you're on NixOS you can install a released version of <code>jj</code> using the nixpkgs <code>jujutsu</code> package.</p> <p>To install a prerelease version, you can use the flake for this repository. For example, if you want to run <code>jj</code> loaded from the flake, use:</p> <pre><code>nix run 'github:jj-vcs/jj'\n</code></pre> <p>You can also add this flake url to your system input flakes. Or you can install the flake to your user profile:</p> <pre><code># Installs the prerelease version from the main branch\nnix profile install 'github:jj-vcs/jj'\n</code></pre>"},{"location":"install-and-setup.html#homebrew","title":"Homebrew","text":"<p>If you use Homebrew, you can run:</p> <pre><code># Installs the latest release\nbrew install jj\n</code></pre>"},{"location":"install-and-setup.html#gentoo-linux","title":"Gentoo Linux","text":"<p><code>dev-vcs/jj</code> is available in the GURU repository. Details on how to enable the GURU repository can be found here.</p> <p>Once you have synced the GURU repository, you can install <code>dev-vcs/jj</code> via Portage:</p> <pre><code>emerge -av dev-vcs/jj\n</code></pre>"},{"location":"install-and-setup.html#opensuse-tumbleweed","title":"openSUSE Tumbleweed","text":"<p><code>jujutsu</code> can be installed from the official openSUSE-Tumbleweed-Oss repository:</p> <pre><code>zypper install jujutsu\n</code></pre>"},{"location":"install-and-setup.html#mac","title":"Mac","text":""},{"location":"install-and-setup.html#from-source_1","title":"From Source","text":"<p>First make sure that you have a Rust version &gt;= 1.88. You may also need to run:</p> <pre><code>xcode-select --install\n</code></pre> <p>Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git \\\n     --locked --bin jj jj-cli\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --locked --bin jj jj-cli\n</code></pre>"},{"location":"install-and-setup.html#homebrew_1","title":"Homebrew","text":"<p>If you use Homebrew, you can run:</p> <pre><code># Installs the latest release\nbrew install jj\n</code></pre>"},{"location":"install-and-setup.html#macports","title":"MacPorts","text":"<p>You can also install <code>jj</code> via the MacPorts <code>jujutsu</code> port:</p> <pre><code># Installs the latest release\nsudo port install jujutsu\n</code></pre>"},{"location":"install-and-setup.html#windows","title":"Windows","text":"<p>First make sure that you have a Rust version &gt;= 1.88. Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git --locked --bin jj jj-cli\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --locked --bin jj jj-cli\n</code></pre> <p>via winget:</p> <pre><code># To install the latest release via winget\nwinget install jj-vcs.jj\n</code></pre> <p>via scoop:</p> <pre><code># To install the latest release via scoop\nscoop install main/jj\n</code></pre>"},{"location":"install-and-setup.html#initial-configuration","title":"Initial configuration","text":"<p>You may want to configure your name and email so commits are made in your name.</p> <pre><code>$ jj config set --user user.name \"Martin von Zweigbergk\"\n$ jj config set --user user.email \"martinvonz@google.com\"\n</code></pre>"},{"location":"install-and-setup.html#command-line-completion","title":"Command-line completion","text":"<p>Jujutsu provides 2 different command-line completion scripts.</p>"},{"location":"install-and-setup.html#standard-completions","title":"Standard completions","text":"<p>The standard completion script provides completions for <code>jj</code> subcommands and options.</p>"},{"location":"install-and-setup.html#dynamic-completions","title":"Dynamic completions","text":"<p>The dynamic completion script provides completions for <code>jj</code> subcommands and options, as well as additional completions, including bookmarks, aliases, revisions, operations and files. Dynamic completions can be context aware, for example they respect the global flags <code>--repository</code> and <code>--at-operation</code> as well as some command-specific ones like <code>--revision</code>, <code>--from</code>, and <code>--to</code>.</p> <p>Dynamic completions are not the default/only option since the underlying engine is still labeled unstable. We expect to transition to them as the default once the engine is stabilized. Please let us know if you encounter any issues with dynamic completions.</p> <p>Which completion script should I use?</p> <p>Generally, dynamic completions provide a much better completion experience. Although the underlying engine is deemed unstable, there have not been many issues in practice. Dynamic completions are the preferred option for many contributors and users.</p> <p>We recommend using the dynamic completion script, and falling back to the standard completion script if there are any issues.</p>"},{"location":"install-and-setup.html#bash","title":"Bash","text":"StandardDynamic <pre><code>source &lt;(jj util completion bash)\n</code></pre> <pre><code>source &lt;(COMPLETE=bash jj)\n</code></pre>"},{"location":"install-and-setup.html#zsh","title":"Zsh","text":"StandardDynamic <pre><code>autoload -U compinit\ncompinit\nsource &lt;(jj util completion zsh)\n</code></pre> <pre><code>source &lt;(COMPLETE=zsh jj)\n</code></pre>"},{"location":"install-and-setup.html#fish","title":"Fish","text":"StandardDynamic <pre><code>jj util completion fish | source\n</code></pre> <p>Note</p> <p>No configuration is required with fish &gt;= 4.0.2 which loads dynamic completions by default.</p> <pre><code>COMPLETE=fish jj | source\n</code></pre>"},{"location":"install-and-setup.html#nushell","title":"Nushell","text":"Standard <pre><code>jj util completion nushell | save -f completions-jj.nu\nuse completions-jj.nu *  # Or `source completions-jj.nu`\n</code></pre>"},{"location":"install-and-setup.html#powershell","title":"Powershell","text":"StandardDynamic <pre><code>jj util completion power-shell | Out-String | Invoke-Expression\n</code></pre> <pre><code>$env:COMPLETE = \"powershell\"\njj | Out-String | Invoke-Expression\nRemove-Item Env:\\COMPLETE\n</code></pre> <p>Insert the above into your <code>$PROFILE</code> file (usually <code>$HOME\\Documents\\PowerShell\\Microsoft.PowerShell_profile.ps1</code>).</p> <p>Note</p> <p>Note that to execute scripts in PowerShell on Windows, including <code>$PROFILE</code>, the execution policy needs to be set to <code>RemoteSigned</code> at minimum.</p>"},{"location":"operation-log.html","title":"Operation log","text":""},{"location":"operation-log.html#introduction","title":"Introduction","text":"<p>Jujutsu records each operation that modifies the repo in the \"operation log\". You can see the log with <code>jj op log</code>. Each operation object contains a snapshot of how the repo looked at the end of the operation. We call this snapshot a \"view\" object. The view contains information about where each bookmark, tag, and Git ref (in Git-backed repos) pointed, as well as the set of heads in the repo, and the current working-copy commit in each workspace. The operation object also (in addition to the view) contains pointers to the operation(s) immediately before it, as well as metadata about the operation, such as timestamps, username, hostname, description.</p> <p>The operation log allows you to undo operations one-by-one (<code>jj undo</code>) or even revert a specific one which isn't the most recent operation (<code>jj op revert</code>). It also lets you restore the entire repo to the way it looked at an earlier point (<code>jj op restore</code>).</p> <p>When referring to operations, you can use <code>@</code> to represent the current operation.</p> <p>The following operators are supported:</p> <ul> <li><code>x-</code>: Parents of <code>x</code> (e.g. <code>@-</code>)</li> <li><code>x+</code>: Children of <code>x</code></li> </ul>"},{"location":"operation-log.html#divergent-operations","title":"Divergent operations","text":"<p>One benefit of the operation log (and the reason for its creation) is that it allows lock-free concurrency -- you can run concurrent <code>jj</code> commands without corrupting the repo, even if you run the commands on different machines that access the repo via a distributed file system (as long as the file system guarantees that a write is only visible once previous writes are visible). When you run a <code>jj</code> command, it will start by loading the repo at the latest operation. It will not see any changes written by concurrent commands. If there are conflicts, you will be informed of them by subsequent <code>jj st</code> and/or <code>jj log</code> commands.</p> <p>As an example, let's say you had started editing the description of a change and then also update the contents of the change (maybe because you had forgotten the editor). When you eventually close your editor, the command will succeed and e.g. <code>jj log</code> will indicate that the change has diverged.</p>"},{"location":"operation-log.html#loading-an-old-version-of-the-repo","title":"Loading an old version of the repo","text":"<p>The top-level <code>--at-operation/--at-op</code> option allows you to load the repo at a specific operation. This can be useful for understanding how your repo got into the current state. It can be even more useful for understanding why someone else's repo got into its current state.</p> <p>When you use <code>--at-op</code>, the automatic snapshotting of the working copy will not take place. When referring to a revision with the <code>@</code> symbol (as many commands do by default), that will resolve to the working-copy commit recorded in the operation's view (which is actually how it always works -- it's just the snapshotting that's skipped with <code>--at-op</code>).</p> <p>As a top-level option, <code>--at-op</code> can be passed to any command. However, you will typically only want to run read-only commands. For example, <code>jj log</code>, <code>jj st</code>, and <code>jj diff</code> all make sense. It's still possible to run e.g. <code>jj --at-op=&lt;some operation ID&gt; describe</code>. That's equivalent to having started <code>jj describe</code> back when the specified operation was the most recent operation and then let it run until now (which can be done for that particular command by not closing the editor). There's practically no good reason to do that other than to simulate concurrent commands.</p>"},{"location":"paid_contributors.html","title":"Paying employers and their contributing employees","text":"<p>This is the list of companies paying for contributions to Jujutsu. For each company, all employees who have contributed are listed, whether it's part of their job to contribute or not.</p> <p>The purpose of this list is to make it easy to spot conflicts of interest, such as when an employee approves changes from another employee of the same company. See contribution docs for details on this policy.</p>"},{"location":"paid_contributors.html#east-river-source-control","title":"East River Source Control","text":"<ul> <li>benbrittain</li> <li>bts</li> <li>ConnerPetzold</li> <li>davidbarsky</li> <li>ilyagr</li> <li>steveklabnik</li> <li>thoughtpolice</li> </ul>"},{"location":"paid_contributors.html#google","title":"Google","text":"<ul> <li>06393993</li> <li>2079884FDavid</li> <li>algmyr</li> <li>AM5800</li> <li>aspotashev</li> <li>daehyeok</li> <li>drieber</li> <li>durin42</li> <li>edre</li> <li>emesterhazy</li> <li>essiene</li> <li>ffyuanda</li> <li>finque</li> <li>honglooker</li> <li>hooper</li> <li>incognito124</li> <li>jonathantanmy</li> <li>josephlou5</li> <li>kevincliao</li> <li>kiranani</li> <li>lukegb</li> <li>martinvonz</li> <li>matts1</li> <li>matttproud</li> <li>michaelchirico</li> <li>mlcui-corp</li> <li>orthros</li> <li>prattmic</li> <li>qfel</li> <li>Ralith</li> <li>rdamazio</li> <li>solson</li> <li>spectral54</li> <li>steadmon</li> <li>tbodt</li> <li>zygoloid</li> </ul>"},{"location":"paid_contributors.html#imc-trading","title":"IMC Trading","text":"<ul> <li>HoelzelJon</li> </ul>"},{"location":"related-work.html","title":"Related work","text":"<p>Similar tools:</p> <ul> <li>git-branchless: Helps you use a   branchless workflow in your Git repo. Supports anonymous branching, undo,   and faster rebase (<code>git move</code>). Under heavy development and quickly gaining   new features.</li> <li>Sapling: A heavily modified fork of   Mercurial developed and used at Meta. It   is compatible with Git, has undo functionality, and   a graphical interface.   See how it is different from Jujutsu.</li> <li>GitUp: A Mac-only GUI for Git. Like Jujutsu, supports   undo and restoring the repo to an earlier snapshot. Backed by its   GitUpKit library.</li> <li>Gitless: Another attempt at providing a simpler   interface for Git. Like Jujutsu, does not have an \"index\"/\"staging area\"   concept. Also doesn't move the working-copy changes between branches (which   we do simply as a consequence of making the working copy a commit).</li> <li>Breezy: Another VCS that's similar in that it   has multiple storage backends, including its own format as well as .git   support.</li> <li>GitButler: A Git client that works with multiple   virtual branches simultaneously, first-class conflicts, and operations history.</li> </ul>"},{"location":"releasing.html","title":"How to do a release","text":""},{"location":"releasing.html#update-changelog-and-cargo-versions","title":"Update changelog and Cargo versions","text":"<p>Send a PR similar to https://github.com/jj-vcs/jj/pull/7954. Feel free to copy-edit the changelog in order to:</p> <ul> <li>Populate \"Release highlights\" if relevant</li> <li>Put more important items first so the reader doesn't miss them</li> <li>Make items consistent when it comes to language and formatting</li> <li>Catch any misplaced changelog items by looking at the CHANGELOG diff.</li> </ul> <p>To get the CHANGELOG diff, you can run</p> <pre><code>jj log -r 'heads(tags())'  # Check that this shows the previous version\njj diff --from 'heads(tags())' --to main CHANGELOG.md\n</code></pre> <p>Make sure to add a corresponding reference link at the bottom of the CHANGELOG for the new version's tag. It should be the github url comparing the previous version tag with the new version tag (e.g. <code>https://github.com/jj-vcs/jj/compare/v0.32.0...v0.33.0</code>).</p> <p>Producing the list of contributors is a bit annoying. The current suggestion is to run something like this:</p> <pre><code>root=$(jj log --no-graph -r 'heads(tags(glob:\"v*.*.*\") &amp; ::trunk())' -T commit_id)\nfilter='\n   map(.commits[] | select(.author.login | endswith(\"[bot]\") | not))\n   | unique_by(.author.login)\n   | map(\"* \\(.commit.author.name) (@\\(.author.login))\")\n   | .[]\n'\ngh api \"/repos/jj-vcs/jj/compare/$root...main\" --paginate | jq -sr \"$filter\" | sort -f\n</code></pre> <p>https://docs.github.com/en/rest/commits/commits?apiVersion=2022-11-28#compare-two-commits</p> <p>Alternatively, the list can be produced locally:</p> <pre><code>jj log --no-graph -r 'heads(tags())..main' -T '\"* \" ++ author ++ \"\\n\"' | sort -fu\n</code></pre> <p>Then try to find the right GitHub username for each person and copy their name and username from the GitHub page for the person (e.g. https://github.com/martinvonz).</p> <p>Get the PR through review and get it merged as usual.</p>"},{"location":"releasing.html#create-a-tag-and-a-github-release","title":"Create a tag and a GitHub release","text":"<ol> <li>Go to https://github.com/jj-vcs/jj/releases and click \"Draft a new release\"</li> <li>Click \"Choose a tag\" and enter \"v0.\\&lt;number&gt;.0\" (e.g. \"v0.26.0\") to create a    new tag</li> <li>Click \"Target\", then \"Recent commits\", and select the commit from your merged    PR</li> <li>Use the name (e.g. \"v0.26.0\") as \"Release title\". Paste the changelog entries    into the message body</li> <li>Check \"Create a discussion for this release\"</li> <li>Click \"Publish release\"</li> </ol>"},{"location":"releasing.html#publish-the-crates-to-cratesio","title":"Publish the crates to crates.io","text":"<p>Go to a terminal and create a new clone of the repo <sup>1</sup>:</p> <pre><code>cd $(mktemp -d)\njj git clone https://github.com/jj-vcs/jj\ncd jj\njj new v0.&lt;number&gt;.0\n</code></pre> <p>Publish each crate:</p> <pre><code>(cd lib/proc-macros &amp;&amp; cargo publish)\n(cd lib &amp;&amp; cargo publish)\n(cd cli &amp;&amp; cargo publish)\n</code></pre> <ol> <li> <p>We recommend publishing from a new clone because <code>cargo publish</code> will   archive ignored files if they match the patterns in <code>[include]</code>   (example),   so it's a security risk to run it an existing clone where you may have   left sensitive content in an ignored file.\u00a0\u21a9</p> </li> </ol>"},{"location":"revsets.html","title":"Revsets","text":"<p>Jujutsu supports a functional language for selecting a set of revisions. Expressions in this language are called \"revsets\" (the idea comes from Mercurial). The language consists of symbols, operators, and functions.</p> <p>Most <code>jj</code> commands accept a revset (or multiple). Many commands, such as <code>jj edit &lt;revset&gt;</code> expect the revset to resolve to a single commit; it is an error to pass a revset that resolves to more than one commit (or zero commits) to such commands.</p> <p>The words \"revisions\" and \"commits\" are used interchangeably in this document.</p>"},{"location":"revsets.html#hidden-revisions","title":"Hidden revisions","text":"<p>Most revsets search only the visible commits. Other commits are only included if you explicitly mention them (e.g. by commit ID, <code>&lt;name&gt;@&lt;remote&gt;</code> symbol, or <code>at_operation()</code> function).</p> <p>If hidden commits are specified, their ancestors also become available to the search space. They are included in <code>all()</code>, <code>x..</code>, <code>~x</code>, etc., but not in <code>..visible_heads()</code>, etc. For example, <code>hidden_id | all()</code> is equivalent to <code>hidden_id | ::(hidden_id | visible_heads())</code>.</p>"},{"location":"revsets.html#symbols","title":"Symbols","text":"<p>The <code>@</code> expression refers to the working copy commit in the current workspace. Use <code>&lt;workspace name&gt;@</code> to refer to the working-copy commit in another workspace. Use <code>&lt;name&gt;@&lt;remote&gt;</code> to refer to a remote-tracking tag/bookmark.</p> <p>A full commit ID refers to a single commit. A unique prefix of the full commit ID can also be used. It is an error to use a non-unique prefix.</p> <p>A full change ID refers to a visible commit with that change ID. A unique prefix of the full change ID can also be used. It is an error to use a non-unique prefix or a divergent change ID. To refer to a hidden commit or divergent change, a change offset can be added using <code>&lt;change ID&gt;/&lt;offset&gt;</code> syntax.</p> <p>Use single or double quotes to prevent a symbol from being interpreted as an expression. For example, <code>\"x-\"</code> is the symbol <code>x-</code>, not the parents of symbol <code>x</code>. Taking shell quoting into account, you may need to use something like <code>jj log -r '\"x-\"'</code>.</p>"},{"location":"revsets.html#priority","title":"Priority","text":"<p>Jujutsu attempts to resolve a symbol in the following order:</p> <ol> <li>Tag name</li> <li>Bookmark name</li> <li>Git ref</li> <li>Commit ID or change ID</li> </ol> <p>To override the priority, use the appropriate revset function. For example, to resolve <code>abc</code> as a commit ID even if there happens to be a bookmark by the same name, use <code>commit_id(abc)</code>. This is particularly useful in scripts.</p>"},{"location":"revsets.html#operators","title":"Operators","text":"<p>The following operators are supported. <code>x</code> and <code>y</code> below can be any revset, not only symbols.</p> <p>Operators are listed in order of binding power from strongest to weakest, e.g. <code>x | y &amp; z</code> is interpreted as <code>x | (y &amp; z)</code> since <code>&amp;</code> has stronger binding power than <code>|</code>. Infix operators of the same binding power are parsed from left to right, e.g. <code>x ~ y &amp; z</code> is interpreted as <code>(x ~ y) &amp; z</code> rather than <code>x ~ (y &amp; z)</code>.</p> <p>As seen above, parentheses can be used to control evaluation order, e.g. <code>(x &amp; y) | z</code> or <code>x &amp; (y | z)</code>.</p> <ol> <li> <ul> <li><code>x-</code>: Parents of <code>x</code>, can be empty.</li> <li><code>x+</code>: Children of <code>x</code>, can be empty.</li> </ul> </li> <li> <ul> <li><code>x::</code>: Descendants of <code>x</code>, including the commits in <code>x</code> itself. Equivalent to      <code>x::visible_heads()</code> if no hidden revisions are mentioned.</li> <li><code>x..</code>: Revisions that are not ancestors of <code>x</code>. Equivalent to <code>~::x</code>, and    <code>x..visible_heads()</code> if no hidden revisions are mentioned.</li> <li><code>::x</code>: Ancestors of <code>x</code>, including the commits in <code>x</code> itself. Shorthand for    <code>root()::x</code>.</li> <li><code>..x</code>: Ancestors of <code>x</code>, including the commits in <code>x</code> itself, but excluding    the root commit. Shorthand for <code>root()..x</code>. Equivalent to <code>::x ~ root()</code>.</li> <li><code>x::y</code>: Descendants of <code>x</code> that are also ancestors of <code>y</code>. Equivalent     to <code>x:: &amp; ::y</code>. This is what <code>git log</code> calls <code>--ancestry-path x..y</code>.</li> <li><code>x..y</code>: Ancestors of <code>y</code> that are not also ancestors of <code>x</code>. Equivalent to    <code>::y ~ ::x</code>. This is what <code>git log</code> calls <code>x..y</code> (i.e. the same as we call it).</li> <li><code>::</code>: All visible commits in the repo. Equivalent to <code>all()</code>, and    <code>root()::visible_heads()</code> if no hidden revisions are mentioned.</li> <li><code>..</code>: All visible commits in the repo, but excluding the root commit.    Equivalent to <code>~root()</code>, and <code>root()..visible_heads()</code> if no hidden revisions    are mentioned.</li> </ul> </li> <li> <ul> <li><code>~x</code>: Revisions that are not in <code>x</code>.</li> </ul> </li> <li> <ul> <li><code>x &amp; y</code>: Revisions that are in both <code>x</code> and <code>y</code>.</li> <li><code>x ~ y</code>: Revisions that are in <code>x</code> but not in <code>y</code>.</li> </ul> </li> <li> <ul> <li><code>x | y</code>: Revisions that are in either <code>x</code> or <code>y</code> (or both).</li> </ul> </li> </ol> Examples <p>Given this history: <pre><code>o D\n|\\\n| o C\n| |\no | B\n|/\no A\n|\no root()\n</code></pre></p> <p>Operator <code>x-</code></p> <ul> <li><code>D-</code> \u21d2 <code>{C,B}</code></li> <li><code>B-</code> \u21d2 <code>{A}</code></li> <li><code>A-</code> \u21d2 <code>{root()}</code></li> <li><code>root()-</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>none()-</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(D|A)-</code> \u21d2 <code>{C,B,root()}</code></li> <li><code>(C|B)-</code> \u21d2 <code>{A}</code></li> </ul> <p>Operator <code>x+</code></p> <ul> <li><code>D+</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>B+</code> \u21d2 <code>{D}</code></li> <li><code>A+</code> \u21d2 <code>{B,C}</code></li> <li><code>root()+</code> \u21d2 <code>{A}</code></li> <li><code>none()+</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)+</code> \u21d2 <code>{D}</code></li> <li><code>(B|root())+</code> \u21d2 <code>{D,A}</code></li> </ul> <p>Operator <code>x::</code></p> <ul> <li><code>D::</code> \u21d2 <code>{D}</code></li> <li><code>B::</code> \u21d2 <code>{D,B}</code></li> <li><code>A::</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>root()::</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>none()::</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)::</code> \u21d2 <code>{D,C,B}</code></li> </ul> <p>Operator <code>x..</code></p> <ul> <li><code>D..</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>B..</code> \u21d2 <code>{D,C}</code> (note that, unlike <code>B::</code>, this includes <code>C</code>)</li> <li><code>A..</code> \u21d2 <code>{D,C,B}</code></li> <li><code>root()..</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>none()..</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>(C|B)..</code> \u21d2 <code>{D}</code></li> </ul> <p>Operator <code>::x</code></p> <ul> <li><code>::D</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>::B</code> \u21d2 <code>{B,A,root()}</code></li> <li><code>::A</code> \u21d2 <code>{A,root()}</code></li> <li><code>::root()</code> \u21d2 <code>{root()}</code></li> <li><code>::none()</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>::(C|B)</code> \u21d2 <code>{C,B,A,root()}</code></li> </ul> <p>Operator <code>..x</code></p> <ul> <li><code>..D</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>..B</code> \u21d2 <code>{B,A}</code></li> <li><code>..A</code> \u21d2 <code>{A}</code></li> <li><code>..root()</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>..none()</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>..(C|B)</code> \u21d2 <code>{C,B,A}</code></li> </ul> <p>Operator <code>x::y</code></p> <ul> <li><code>D::D</code> \u21d2 <code>{D}</code></li> <li><code>B::D</code> \u21d2 <code>{D,B}</code> (note that, unlike <code>B..D</code>, this includes <code>B</code> and excludes <code>C</code>)</li> <li><code>B::C</code> \u21d2 <code>{}</code> (empty set) (note that, unlike <code>B..C</code>, this excludes <code>C</code>)</li> <li><code>A::D</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>root()::D</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>none()::D</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>D::B</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)::(C|B)</code> \u21d2 <code>{C,B}</code></li> </ul> <p>Operator <code>x..y</code></p> <ul> <li><code>D..D</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>B..D</code> \u21d2 <code>{D,C}</code> (note that, unlike <code>B::D</code>, this includes <code>C</code> and excludes <code>B</code>)</li> <li><code>B..C</code> \u21d2 <code>{C}</code> (note that, unlike <code>B::C</code>, this includes <code>C</code>)</li> <li><code>A..D</code> \u21d2 <code>{D,C,B}</code></li> <li><code>root()..D</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>none()..D</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>D..B</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)..(C|B)</code> \u21d2 <code>{}</code> (empty set)</li> </ul>"},{"location":"revsets.html#functions","title":"Functions","text":"<p>You can also specify revisions by using functions. Some functions take other revsets (expressions) as arguments.</p> Function argument syntax <p>In this documentation, optional arguments are indicated with square brackets like <code>[arg]</code>. Some arguments also have an optional label which can be used to specify that argument without specifying all previous arguments.</p> <p>For instance, <code>remote_bookmarks([name_pattern], [[remote=]remote_pattern])</code> indicates that all of the following usages are valid:</p> <ul> <li><code>remote_bookmarks()</code></li> <li><code>remote_bookmarks(\"main\")</code></li> <li><code>remote_bookmarks(\"main\", \"origin\")</code></li> <li><code>remote_bookmarks(\"main\", remote=\"origin\")</code></li> <li><code>remote_bookmarks(remote=\"origin\")</code></li> </ul> <ul> <li> <p><code>parents(x, [depth])</code>: <code>parents(x)</code> is the same as <code>x-</code>.   <code>parents(x, depth)</code> returns the parents of <code>x</code> at the given <code>depth</code>. For   instance, <code>parents(x, 3)</code> is equivalent to <code>x---</code>.</p> </li> <li> <p><code>children(x, [depth])</code>: <code>children(x)</code> is the same as <code>x+</code>.   <code>children(x, depth)</code> returns the children of <code>x</code> at the given <code>depth</code>. For   instance, <code>children(x, 3)</code> is equivalent to <code>x+++</code>.</p> </li> <li> <p><code>ancestors(x, [depth])</code>: <code>ancestors(x)</code> is the same as <code>::x</code>.   <code>ancestors(x, depth)</code> returns the ancestors of <code>x</code> limited to the given   <code>depth</code>.</p> </li> <li> <p><code>descendants(x, [depth])</code>: <code>descendants(x)</code> is the same as <code>x::</code>.   <code>descendants(x, depth)</code> returns the descendants of <code>x</code> limited to the given   <code>depth</code>.</p> </li> <li> <p><code>first_parent(x, [depth])</code>: <code>first_parent(x)</code> is similar to <code>parents(x)</code>, but   for merges, it only returns the first parent instead of returning all parents.   The <code>depth</code> argument also works similarly, so <code>first_parent(x, 2)</code> is   equivalent to <code>first_parent(first_parent(x))</code>.</p> </li> <li> <p><code>first_ancestors(x, [depth])</code>: Similar to <code>ancestors(x, [depth])</code>, but only   traverses the first parent of each commit. In Git, the first parent of a merge   commit is conventionally the branch into which changes are being merged, so   <code>first_ancestors()</code> can be used to exclude changes made on other branches.</p> </li> <li> <p><code>reachable(srcs, domain)</code>: All commits reachable from <code>srcs</code> within   <code>domain</code>, traversing all parent and child edges. <code>srcs</code> outside <code>domain</code> are   not considered even if a parent or child edge would reach into <code>domain</code>.</p> </li> <li> <p><code>connected(x)</code>: Same as <code>x::x</code>. Useful when <code>x</code> includes several commits.</p> </li> <li> <p><code>all()</code>: All visible commits and ancestors of commits explicitly mentioned.</p> </li> <li> <p><code>none()</code>: No commits. This function is rarely useful; it is provided for   completeness.</p> </li> <li> <p><code>change_id(prefix)</code>: Commits with the given change ID prefix. If the specified   change is divergent, this resolves to multiple commits. It is an error to use a   non-unique prefix. Unmatched prefix isn't an error.</p> </li> <li> <p><code>commit_id(prefix)</code>: Commits with the given commit ID prefix. It is an error   to use a non-unique prefix. Unmatched prefix isn't an error.</p> </li> <li> <p><code>bookmarks([pattern])</code>: All local bookmark targets. If <code>pattern</code> is specified,   this selects the bookmarks whose name match the given string   pattern. For example, <code>bookmarks(*push*)</code> would match the   bookmarks <code>push-123</code> and <code>repushed</code> but not the bookmark <code>main</code>. If a bookmark   is in a conflicted state, all its possible targets are included.</p> </li> <li> <p><code>remote_bookmarks([name_pattern], [[remote=]remote_pattern])</code>: All remote   bookmarks targets across all remotes. If just the <code>name_pattern</code> is specified,   the bookmarks whose names match the given string pattern   across all remotes are selected. If both <code>name_pattern</code> and <code>remote_pattern</code>   are specified, the selection is further restricted to just the remotes whose   names match <code>remote_pattern</code>.</p> <p>For example, <code>remote_bookmarks(*push*, *ri*)</code> would match the bookmarks <code>push-123@origin</code> and <code>repushed@private</code> but not <code>push-123@upstream</code> or <code>main@origin</code> or <code>main@upstream</code>. If a bookmark is in a conflicted state, all its possible targets are included.</p> <p>Git-tracking bookmarks are excluded by default. Use <code>remote=\"git\"</code> or <code>remote=\"*\"</code> to select bookmarks including <code>@git</code> ones.</p> </li> <li> <p><code>tracked_remote_bookmarks([name_pattern], [[remote=]remote_pattern])</code>: All   targets of tracked remote bookmarks. Supports the same optional arguments as   <code>remote_bookmarks()</code>.</p> </li> <li> <p><code>untracked_remote_bookmarks([name_pattern], [[remote=]remote_pattern])</code>: All   targets of untracked remote bookmarks. Supports the same optional arguments as   <code>remote_bookmarks()</code>.</p> </li> <li> <p><code>tags([pattern])</code>: All tag targets. If <code>pattern</code> is specified, this selects   the tags whose name match the given string pattern. For   example, <code>tags(*v1*)</code> would match the tags <code>v123</code> and <code>rev1</code> but not the tag   <code>v2</code>. If a tag is in a conflicted state, all its possible targets are   included.</p> </li> <li> <p><code>remote_tags([name_pattern], [[remote=]remote_pattern])</code>: All remote tags   targets across all remotes. See <code>remote_bookmarks()</code> for arguments.</p> </li> <li> <p><code>visible_heads()</code>: All visible heads (same as <code>heads(all())</code> if no hidden   revisions are mentioned).</p> </li> <li> <p><code>root()</code>: The virtual commit that is the oldest ancestor of all other commits.</p> </li> <li> <p><code>heads(x)</code>: Commits in <code>x</code> that are not ancestors of other commits in <code>x</code>.   Equivalent to <code>x ~ ::x-</code>. Note that this is different from   Mercurial's <code>heads(x)</code>   function, which is equivalent to <code>x ~ x-</code>.</p> </li> <li> <p><code>roots(x)</code>: Commits in <code>x</code> that are not descendants of other commits in <code>x</code>.   Equivalent to <code>x ~ x+::</code>. Note that this is different from   Mercurial's <code>roots(x)</code>   function, which is equivalent to <code>x ~ x+</code>.</p> </li> <li> <p><code>latest(x, [count])</code>: Latest <code>count</code> commits in <code>x</code>, based on committer   timestamp. The default <code>count</code> is 1.</p> </li> <li> <p><code>fork_point(x)</code>: The fork point of all commits in <code>x</code>. The fork point is the   common ancestor(s) of all commits in <code>x</code> which do not have any descendants   that are also common ancestors of all commits in <code>x</code>. It is equivalent to   the revset <code>heads(::x_1 &amp; ::x_2 &amp; ... &amp; ::x_N)</code>, where <code>x_{1..N}</code> are commits   in <code>x</code>. If <code>x</code> resolves to a single commit, <code>fork_point(x)</code> resolves to <code>x</code>.</p> </li> <li> <p><code>bisect(x)</code>: Finds commits in the input set for which about half of the input   set are descendants. The current implementation deals somewhat poorly with   non-linear history.</p> </li> <li> <p><code>exactly(x, count)</code>: Evaluates <code>x</code>, and errors if it is not of exactly size   <code>count</code>. Otherwise, returns <code>x</code>. This is useful in particular with <code>count=1</code>   when you want to ensure that some revset expression has exactly one target.</p> </li> <li> <p><code>merges()</code>: Merge commits.</p> </li> <li> <p><code>description(pattern)</code>: Commits that have a description matching the given   string pattern.</p> <p>A non-empty description is usually terminated with newline character. For example, <code>description(\"\")</code> matches commits without description, and <code>description(\"foo\\n\")</code> matches commits with description <code>\"foo\\n\"</code>.</p> </li> <li> <p><code>subject(pattern)</code>: Commits that have a subject matching the given string   pattern. A subject is the first line of the description   (without newline character.)</p> </li> <li> <p><code>author(pattern)</code>: Commits with the author's name or email matching the given   string pattern. Equivalent to <code>author_name(pattern) |   author_email(pattern)</code>.</p> </li> <li> <p><code>author_name(pattern)</code>: Commits with the author's name matching the given   string pattern.</p> </li> <li> <p><code>author_email(pattern)</code>: Commits with the author's email matching the given   string pattern.</p> </li> <li> <p><code>author_date(pattern)</code>: Commits with author dates matching the specified date   pattern.</p> </li> <li> <p><code>mine()</code>: Commits where the author's email matches the email of the current   user. Equivalent to <code>author_email(exact-i:&lt;user-email&gt;)</code></p> </li> <li> <p><code>committer(pattern)</code>: Commits with the committer's name or email matching the   given string pattern. Equivalent to   <code>committer_name(pattern) | committer_email(pattern)</code>.</p> </li> <li> <p><code>committer_name(pattern)</code>: Commits with the committer's name matching the   given string pattern.</p> </li> <li> <p><code>committer_email(pattern)</code>: Commits with the committer's email matching the   given string pattern.</p> </li> <li> <p><code>committer_date(pattern)</code>: Commits with committer dates matching the specified   date pattern.</p> </li> <li> <p><code>signed()</code>: Commits that are cryptographically signed.</p> </li> <li> <p><code>empty()</code>: Commits modifying no files. This also includes <code>merges()</code> without   user modifications and <code>root()</code>.</p> </li> <li> <p><code>files(expression)</code>: Commits modifying paths matching the given fileset   expression.</p> <p>Paths are relative to the directory <code>jj</code> was invoked from. A directory name will match all files in that directory and its subdirectories.</p> <p>For example, <code>files(foo)</code> will match files <code>foo</code>, <code>foo/bar</code>, <code>foo/bar/baz</code>. It will not match <code>foobar</code> or <code>bar/foo</code>.</p> <p>Some file patterns might need quoting because the <code>expression</code> must also be parsable as a revset. For example, <code>.</code> has to be quoted in <code>files(\".\")</code>.</p> </li> <li> <p><code>diff_lines(text, [files])</code>: Commits containing diffs matching the given   <code>text</code> pattern line by line.</p> <p>The search paths can be narrowed by the <code>files</code> expression. All modified files are scanned by default, but it is likely to change in future version to respect the command line path arguments.</p> <p>For example, <code>diff_lines(\"*TODO*\", \"src\")</code> will search revisions where \"TODO\" is added to or removed from files under \"src\".</p> </li> <li> <p><code>conflicts()</code>: Commits that have files in a conflicted state.</p> </li> <li> <p><code>divergent()</code>: Commits that are divergent.</p> </li> <li> <p><code>present(x)</code>: Same as <code>x</code>, but evaluated to <code>none()</code> if any of the commits   in <code>x</code> doesn't exist (e.g. is an unknown bookmark name.)</p> </li> <li> <p><code>coalesce(revsets...)</code>: Commits in the first revset in the list of <code>revsets</code>   which does not evaluate to <code>none()</code>. If all revsets evaluate to <code>none()</code>, then   the result of <code>coalesce</code> will also be <code>none()</code>.</p> </li> <li> <p><code>working_copies()</code>: The working copy commits across all the workspaces.</p> </li> <li> <p><code>at_operation(op, x)</code>: Evaluates <code>x</code> at the specified operation. For   example, <code>at_operation(@-, visible_heads())</code> will return all heads which were   visible at the previous operation.</p> <p>Since <code>at_operation(op, x)</code> brings all commits that were visible at the operation to the search space, <code>at_operation(op, x) | all()</code> is equivalent to <code>at_operation(op, x) | ::(at_operation(op, x | visible_heads()) | visible_heads())</code>.</p> </li> </ul> Examples <p>Given this history: <pre><code>o E\n|\n| o D\n|/|\n| o C\n| |\no | B\n|/\no A\n|\no root()\n</code></pre></p> <p>function <code>reachable()</code></p> <ul> <li><code>reachable(E, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(D, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(C, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(B, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(A, A..)</code> \u21d2 <code>{}</code> (empty set)</li> </ul> <p>function <code>connected()</code></p> <ul> <li><code>connected(E|A)</code> \u21d2 <code>{E,B,A}</code></li> <li><code>connected(D|A)</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>connected(A)</code> \u21d2 <code>{A}</code></li> </ul> <p>function <code>heads()</code></p> <ul> <li><code>heads(E|D)</code> \u21d2 <code>{E,D}</code></li> <li><code>heads(E|C)</code> \u21d2 <code>{E,C}</code></li> <li><code>heads(E|B)</code> \u21d2 <code>{E}</code></li> <li><code>heads(E|A)</code> \u21d2 <code>{E}</code></li> <li><code>heads(A)</code> \u21d2 <code>{A}</code></li> </ul> <p>function <code>roots()</code></p> <ul> <li><code>roots(E|D)</code> \u21d2 <code>{E,D}</code></li> <li><code>roots(E|C)</code> \u21d2 <code>{E,C}</code></li> <li><code>roots(E|B)</code> \u21d2 <code>{B}</code></li> <li><code>roots(E|A)</code> \u21d2 <code>{A}</code></li> <li><code>roots(A)</code> \u21d2 <code>{A}</code></li> </ul> <p>function <code>fork_point()</code></p> <ul> <li><code>fork_point(E|D)</code> \u21d2 <code>{B}</code></li> <li><code>fork_point(E|C)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(E|B)</code> \u21d2 <code>{B}</code></li> <li><code>fork_point(E|A)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(D|C)</code> \u21d2 <code>{C}</code></li> <li><code>fork_point(D|B)</code> \u21d2 <code>{B}</code></li> <li><code>fork_point(B|C)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(A)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(none())</code> \u21d2 <code>{}</code></li> </ul>"},{"location":"revsets.html#string-patterns","title":"String patterns","text":"<p>Functions that perform string matching support the following pattern syntax (the quotes are optional).</p> <p>By default, <code>\"string\"</code> is parsed as a <code>glob:</code> pattern.</p> <ul> <li><code>exact:\"string\"</code>: Matches strings exactly equal to <code>string</code>.</li> <li><code>glob:\"pattern\"</code>: Matches strings with Unix-style shell wildcard   <code>pattern</code>.</li> <li><code>regex:\"pattern\"</code>: Matches substrings with regular   expression <code>pattern</code>.</li> <li><code>substring:\"string\"</code>: Matches strings that contain <code>string</code>.</li> </ul> <p>You can append <code>-i</code> after the kind to match case\u2010insensitively (e.g. <code>glob-i:\"fix*jpeg*\"</code>).</p> <p>String patterns can be combined by using logical operators (e.g. <code>bookmarks(~glob:\"ci/*\")</code>):</p> <ul> <li><code>~x</code>: Matches everything but <code>x</code>.</li> <li><code>x &amp; y</code>: Matches both <code>x</code> and <code>y</code>.</li> <li><code>x ~ y</code>: Matches <code>x</code> but not <code>y</code>.</li> <li><code>x | y</code>: Matches either <code>x</code> or <code>y</code> (or both).</li> </ul>"},{"location":"revsets.html#date-patterns","title":"Date patterns","text":"<p>Functions that perform date matching support the following pattern syntax:</p> <ul> <li><code>after:\"string\"</code>: Matches dates exactly at or after the given date.</li> <li><code>before:\"string\"</code>: Matches dates before, but not including, the given date.</li> </ul> <p>Date strings can be specified in several forms, including:</p> <ul> <li>2024-02-01</li> <li>2024-02-01T12:00:00</li> <li>2024-02-01T12:00:00-08:00</li> <li>2024-02-01 12:00:00</li> <li>2 days ago</li> <li>5 minutes ago</li> <li>yesterday</li> <li>yesterday 5pm</li> <li>yesterday 10:30</li> <li>yesterday 15:30</li> </ul>"},{"location":"revsets.html#aliases","title":"Aliases","text":"<p>New symbols and functions can be defined in the config file, by using any combination of the predefined symbols/functions and other aliases.</p> <p>Alias functions can be overloaded by the number of parameters. However, builtin function will be shadowed by name, and can't co-exist with aliases.</p> <p>For example:</p> <pre><code>[revset-aliases]\n'HEAD' = '@-'\n'user()' = 'user(\"me@example.org\")'\n'user(x)' = 'author(x) | committer(x)'\n</code></pre>"},{"location":"revsets.html#built-in-aliases","title":"Built-in Aliases","text":"<p>The following aliases are built-in and used for certain operations. These functions are defined as aliases in order to allow you to overwrite them as needed. See revsets.toml for a comprehensive list.</p> <ul> <li> <p><code>trunk()</code>: Resolves to the head commit for the default bookmark of the default   remote, or the remote named <code>upstream</code> or <code>origin</code>. This is set at the   repository level upon initialization of a Jujutsu repository.</p> <p>If the default bookmark cannot be resolved during initialization, the default global configuration tries the bookmarks <code>main</code>, <code>master</code>, and <code>trunk</code> on the <code>upstream</code> and <code>origin</code> remotes. If more than one potential trunk commit exists, the newest one is chosen. If none of the bookmarks exist, the revset evaluates to <code>root()</code>.</p> <p>You can override this as appropriate. If you do, make sure it always resolves to exactly one commit. For example:</p> <pre><code>[revset-aliases]\n'trunk()' = 'your-bookmark@your-remote'\n</code></pre> </li> <li> <p><code>builtin_immutable_heads()</code>: Resolves to <code>trunk() | tags() |   untracked_remote_bookmarks()</code>. It is used as the default definition for   <code>immutable_heads()</code> below. It is not recommended to redefine this   alias. Prefer to redefine <code>immutable_heads()</code> instead.</p> </li> <li> <p><code>immutable_heads()</code>: Resolves to <code>trunk() | tags() |   untracked_remote_bookmarks()</code> by default. It is actually defined as   <code>builtin_immutable_heads()</code>, and can be overridden as required. See   here for details.</p> </li> <li> <p><code>immutable()</code>: The set of commits that <code>jj</code> treats as immutable. This is   equivalent to <code>::(immutable_heads() | root())</code>. It is not recommended to redefine   this alias. Note that modifying this will not change whether a commit is immutable.   To do that, edit <code>immutable_heads()</code>.</p> </li> <li> <p><code>mutable()</code>: The set of commits that <code>jj</code> treats as mutable. This is   equivalent to <code>~immutable()</code>. It is not recommended to redefined this alias.   Note that modifying this will not change whether a commit is immutable.   To do that, edit <code>immutable_heads()</code>.</p> </li> <li> <p><code>visible()</code>: The set of visible commits. Resolves to <code>::visible_heads()</code>.   This is equal to <code>all()</code> unless your revset includes   hidden revisions.</p> </li> <li> <p><code>hidden()</code>: The set of hidden commits. Resolves to <code>~visible()</code>. This is empty   unless your revset includes hidden revisions. Note that   this is not the set of all previously visible   commits.</p> </li> </ul>"},{"location":"revsets.html#examples","title":"Examples","text":"<p>Show the parent(s) of the working-copy commit (like <code>git log -1 HEAD</code>):</p> <pre><code>jj log -r @-\n</code></pre> <p>Show all ancestors of the working copy (like plain <code>git log</code>)</p> <pre><code>jj log -r ::@\n</code></pre> <p>Show commits not on any remote bookmark:</p> <pre><code>jj log -r 'remote_bookmarks()..'\n</code></pre> <p>Show commits not on <code>origin</code> (if you have other remotes like <code>fork</code>):</p> <pre><code>jj log -r 'remote_bookmarks(remote=origin)..'\n</code></pre> <p>Show the initial commits in the repo (the ones Git calls \"root commits\"):</p> <pre><code>jj log -r 'root()+'\n</code></pre> <p>Show some important commits (like <code>git log --simplify-by-decoration</code>):</p> <pre><code>jj log -r 'tags() | bookmarks()'\n</code></pre> <p>Show local commits leading up to the working copy, as well as descendants of those commits:</p> <pre><code>jj log -r '(remote_bookmarks()..@)::'\n</code></pre> <p>Show commits authored by \"martinvonz\" and containing the word \"reset\" in the description:</p> <pre><code>jj log -r 'author(*martinvonz*) &amp; description(*reset*)'\n</code></pre>"},{"location":"roadmap.html","title":"Roadmap","text":"<p>This documents some of the goals we have. Many of them are quite independent.</p> <p>Note: Most people contributing to Jujutsu do so in their spare time, which  means that we cannot attach any target dates to any of the goals below.</p>"},{"location":"roadmap.html#support-for-copies-and-renames","title":"Support for copies and renames","text":"<p>We want to support copy tracing in a way that leaves it up to the commit backend to either record or detect copies. That should let us work with existing Git repos (Git does not record copies, it detects them on the fly) as well as with very large repos where detection would be too slow. See design doc.</p>"},{"location":"roadmap.html#forge-integrations","title":"Forge integrations","text":"<p>We would like to make it easier to work with various popular forges by providing something like <code>jj github submit</code> and <code>jj gitlab submit</code>. For popular forges, we might include that support by default in the standard <code>jj</code> binary.</p>"},{"location":"roadmap.html#submodule-support","title":"Submodule support","text":"<p>Git submodules are used frequently enough in large Git repos that we will probably need to support them. There are still big open questions around UX.</p>"},{"location":"roadmap.html#better-rust-api-for-uis","title":"Better Rust API for UIs","text":"<p>UIs like gg currently have to duplicate quite a bit of logic from <code>jj-cli</code>. We need to make this code not specific to the CLI (e.g. return status objects instead of printing messages) and move it into <code>jj-lib</code>.</p>"},{"location":"roadmap.html#rpc-api","title":"RPC API","text":"<p>One problem with writing tools using the Rust API is that they will only work with the backends they were compiled with. For example, a regular gg build will not work on Google repos because it doesn't have the backends necessary to load them. We want to provide an RPC API for tools that want to work with an unknown build of <code>jj</code> by having the tool run something like <code>jj api</code> to give it an address to talk to.</p> <p>In addition to helping with the problem of unknown backends, having an RPC API should make it easier for tools like VS Code that are not written in Rust. The RPC API will probably be at a higher abstraction level than the Rust API.</p> <p>See design doc.</p>"},{"location":"roadmap.html#open-source-cloud-based-repos-server-and-daemon-process","title":"Open-source cloud-based repos (server and daemon process)","text":"<p>Google has an internal Jujutsu server backed by a database. This server allows commits and repos (operation logs) to be stored in the cloud (i.e. the database). Working copies can still be stored locally.</p> <p>In order to reduce latency, there is a local daemon process that caches reads and writes. It also prefetches of objects it thinks the client might ask for next. In also helps with write latency by optimistically answering write requests (it therefore needs to know the server's hashing scheme so it can return the right IDs).</p> <p>We (the project, not necessarily Google) want to provide a similar experience for all users. We would therefore like to create a similar server and daemon. The daemon might be the same process as for the RPC API mentioned above.</p>"},{"location":"roadmap.html#virtual-file-system-vfs","title":"Virtual file system (VFS)","text":"<p>For very large projects and/or large files, it can be expensive to update the working copy. We want to provide a VFS to help with that. Updating the working copy to another commit can then be done simply by telling the VFS to use the other commit as base, without needing to download any large files in the target commit until the user asks for them via the file system. A VFS can also make it cheap to snapshot the working copy by keeping track of all changes compared to the base commit.</p> <p>Having a VFS can also be very benefial for <code>jj run</code>, since we can then cheaply create temporary working copies for the commands to run in.</p>"},{"location":"roadmap.html#better-support-for-large-files","title":"Better support for large files","text":"<p>We have talked about somehow using content-defined chunking (CDC) to reduce storage and transfer costs for large files. Maybe we will store files in our future cloud-based server using the same model as XetHub.</p>"},{"location":"sapling-comparison.html","title":"Comparison with Sapling","text":""},{"location":"sapling-comparison.html#introduction","title":"Introduction","text":"<p>This document attempts to describe how jj is different from Sapling. Sapling is a VCS developed by Meta. It was announced about 3 years after development started on jj. It is a heavily modified fork of Mercurial. Because jj has copied many ideas from Mercurial, there are many similarities between the two tools, such as:</p> <ul> <li>A user-friendly CLI</li> <li>A \"revset\" language for selecting revisions</li> <li>Good support for working with stacked commits, including tracking \"anonymous   heads\" (no \"detached HEAD\" state like in Git) and <code>split</code> commands, and   automatically rebasing descendant commits when you amend a commit.</li> <li>Flexible customization of output using templates</li> </ul>"},{"location":"sapling-comparison.html#differences","title":"Differences","text":"<p>Here is a list of some differences between jj and Sapling.</p> <ul> <li> <p>Working copy: When using Sapling (like most VCSs), the   user explicitly tells the tool when to create a commit and which files to   include. When using jj, the working copy   is automatically snapshotted by every command. New files   are automatically tracked and deleted files are automatically untracked. This   has several advantages:</p> <ul> <li>The working copy is effectively backed up every time you run a command.</li> <li>No commands fail because you have changes in the working copy (\"abort: 1   conflicting file changes: ...\"). No need for <code>sl shelve</code>.</li> <li>Simpler and more consistent CLI because the working copy is treated like any   other commit.</li> </ul> </li> <li> <p>Conflicts: Like most VCSs, Sapling requires the user to   resolve conflicts before committing. jj lets   you commit conflicts. Note that it's a representation of the   conflict that's committed, not conflict markers (<code>&lt;&lt;&lt;&lt;&lt;&lt;&lt;</code> etc.). This also   has several advantages:</p> <ul> <li>Merge conflicts won't prevent you from checking out another commit.</li> <li>You can resolve the conflicts when you feel like it.</li> <li>Rebasing descendants always succeeds. Like jj, Sapling automatically   rebases, but it will fail if there are conflicts.</li> <li>Merge commits can be rebased correctly (Sapling sometimes fails).</li> <li>You can rebase conflicts and conflict resolutions.</li> </ul> </li> <li> <p>Undo: jj's undo is powered by the operation log, which   records how the repo has changed over time. Sapling has a similar feature   with its MetaLog.   They seem to provide similar functionality, but jj also exposes the log to the   user via <code>jj op log</code>, so you can tell how far back you want to go back.   Sapling has <code>sl debugmetalog</code>, but that seems to show the history of a single   commit, not the whole repo's history. Thanks to jj snapshotting the working   copy, it's possible to undo changes to the working copy. For example, if   you <code>jj undo</code> a <code>jj commit</code>, <code>jj diff</code> will show the same changes as   before <code>jj commit</code>, but if you <code>sl undo</code> a <code>sl commit</code>, the working copy will   be clean.</p> </li> <li>Git interop: Sapling supports cloning, pushing, and pulling from a remote   Git repo. jj also does, and it also supports sharing a working copy with a Git   repo, so you can use <code>jj</code> and <code>git</code> interchangeably in the same repo.</li> <li>Polish: Sapling is more polished and feature-complete. Sapling has very   nice built-in web UI called   Interactive Smartlog, which lets   you drag and drop commits to rebase them, among other things.</li> <li>Forge workflow: Sapling has <code>sl pr submit --stack</code>, which lets you   push a stack of commits as separate GitHub PRs, including setting the base   branch. It only supports GitHub. jj doesn't have any direct integration with   GitHub or any other forge. However, it has <code>jj git push --change</code> for   automatically creating branches for specified commits. You have to specify   each commit you want to create a branch for by using   <code>jj git push --change X --change Y ...</code>, and you have to manually set up any   base branches in GitHub's UI (or GitLab's or ...). On subsequent pushes, you   can update all at once by specifying something like <code>jj git push -r main..@</code>   (to push all branches on the current stack of commits from where it forked   from <code>main</code>).</li> </ul>"},{"location":"style_guide.html","title":"Style guide","text":""},{"location":"style_guide.html#panics","title":"Panics","text":"<p>Panics are not allowed, especially in code that may run on a server. Calling <code>.unwrap()</code> is okay if it's guaranteed to be safe by previous checks or documented invariants. For example, if a function is documented as requiring a non-empty slice as input, it's fine to call <code>slice[0]</code> and panic.</p>"},{"location":"style_guide.html#markdown","title":"Markdown","text":"<p>Try to wrap at 80 columns. We don't have a formatter yet.</p>"},{"location":"style_guide.html#prefer-lower-level-tests-to-end-to-end-tests","title":"Prefer lower-level tests to end-to-end tests","text":"<p>When possible, prefer lower-level tests that don't use the <code>jj</code> binary. End-to-end tests are much slower than similar tests that create a repo using <code>jj-lib</code> (roughly 100x slower). It's also often easier to test edge cases in lower-level tests.</p> <p>It can still be useful to add a test case or two to check that the lower-level functionality is correctly hooked up in the CLI. For example, the end-to-end tests for <code>jj log</code> don't need to test that all kinds of revsets are evaluated correctly (we have tests in <code>jj-lib</code> for that), but they should check that the <code>-r</code> flag is respected.</p> <p>Use end-to-end tests for testing the CLI commands themselves.</p>"},{"location":"templates.html","title":"Templates","text":"<p>Jujutsu supports a functional language to customize output of commands. The language consists of literals, keywords, operators, functions, and methods.</p> <p>A couple of <code>jj</code> commands accept a template via <code>-T</code>/<code>--template</code> option.</p>"},{"location":"templates.html#keywords","title":"Keywords","text":"<p>Keywords represent objects of different types; the types are described in a follow-up section. In addition to context-specific keywords, the top-level object can be referenced as <code>self</code>.</p>"},{"location":"templates.html#commit-keywords","title":"Commit keywords","text":"<p>In <code>jj log</code> templates, all 0-argument methods of the <code>Commit</code> type are available as keywords. For example, <code>commit_id</code> is equivalent to <code>self.commit_id()</code>.</p>"},{"location":"templates.html#operation-keywords","title":"Operation keywords","text":"<p>In <code>jj op log</code> templates, all 0-argument methods of the <code>Operation</code> type are available as keywords. For example, <code>current_operation</code> is equivalent to <code>self.current_operation()</code>.</p>"},{"location":"templates.html#operators","title":"Operators","text":"<p>The following operators are supported.</p> <ul> <li><code>x.f()</code>: Method call.</li> <li><code>-x</code>: Negate integer value.</li> <li><code>!x</code>: Logical not.</li> <li><code>x * y</code>, <code>x / y</code>, <code>x % y</code>: Multiplication/division/remainder. Operands must   be <code>Integer</code>s.</li> <li><code>x + y</code>, <code>x - y</code>: Addition/subtraction. Operands must be <code>Integer</code>s.</li> <li><code>x &gt;= y</code>, <code>x &gt; y</code>, <code>x &lt;= y</code>, <code>x &lt; y</code>: Greater than or equal/greater than/   lesser than or equal/lesser than. Operands must be <code>Integer</code>s.</li> <li><code>x == y</code>, <code>x != y</code>: Equal/not equal. Operands must be either <code>Boolean</code>,   <code>Integer</code>, or <code>String</code>.</li> <li><code>x &amp;&amp; y</code>: Logical and, short-circuiting.</li> <li><code>x || y</code>: Logical or, short-circuiting.</li> <li><code>x ++ y</code>: Concatenate <code>x</code> and <code>y</code> templates.</li> </ul> <p>(listed in order of binding strengths)</p>"},{"location":"templates.html#global-functions","title":"Global functions","text":"<p>The following functions are defined.</p> <ul> <li><code>fill(width: Integer, content: Template) -&gt; Template</code>: Fill lines at   the given <code>width</code>.</li> <li><code>indent(prefix: Template, content: Template) -&gt; Template</code>: Indent   non-empty lines by the given <code>prefix</code>.</li> <li><code>pad_start(width: Integer, content: Template, [fill_char: Template])</code>: Pad (or   right-justify) content by adding leading fill characters. The <code>content</code>   shouldn't have newline character.</li> <li><code>pad_end(width: Integer, content: Template, [fill_char: Template])</code>: Pad (or   left-justify) content by adding trailing fill characters. The <code>content</code>   shouldn't have newline character.</li> <li><code>pad_centered(width: Integer, content: Template, [fill_char: Template])</code>: Pad   content by adding both leading and trailing fill characters. If an odd number   of fill characters are needed, the trailing fill will be one longer than the   leading fill. The <code>content</code> shouldn't have newline characters.</li> <li><code>truncate_start(width: Integer, content: Template, [ellipsis: Template])</code>:   Truncate <code>content</code> by removing leading characters. The <code>content</code> shouldn't   have newline character. If <code>ellipsis</code> is provided and <code>content</code> was truncated,   prepend the <code>ellipsis</code> to the result.</li> <li><code>truncate_end(width: Integer, content: Template, [ellipsis: Template])</code>:   Truncate <code>content</code> by removing trailing characters. The <code>content</code> shouldn't   have newline character. If <code>ellipsis</code> is provided and <code>content</code> was truncated,   append the <code>ellipsis</code> to the result.</li> <li><code>hash(content: Stringify) -&gt; String</code>:   Hash the input and return a hexadecimal string representation of the digest.</li> <li><code>label(label: Stringify, content: Template) -&gt; Template</code>: Apply a custom   color label to the content. The <code>label</code> is evaluated as a   space-separated string.</li> <li><code>hyperlink(url: Stringify, text: Template, [fallback: Template]) -&gt; Template</code>:   Render <code>text</code> as a hyperlink to <code>url</code> using OSC 8 escape sequences   when outputting with color enabled. Otherwise, renders <code>fallback</code> instead,   which defaults to <code>text</code>. Use <code>--color=always</code> to force hyperlinks when piping   output to a terminal emulator that supports OSC 8.</li> <li><code>raw_escape_sequence(content: Template) -&gt; Template</code>: Preserves any escape   sequences in <code>content</code> (i.e., bypasses sanitization) and strips labels.   Note: This function is intended for escape sequences and as such, its output   is expected to be invisible / of no display width. Outputting content with   nonzero display width may break wrapping, indentation etc.</li> <li><code>stringify(content: Stringify) -&gt; String</code>: Format <code>content</code> to string. This   effectively removes color labels.</li> <li><code>json(value: Serialize) -&gt; String</code>: Serialize <code>value</code> in JSON format.</li> <li><code>if(condition: Boolean, then: Template, [else: Template]) -&gt; Template</code>:   Conditionally evaluate <code>then</code>/<code>else</code> template content.</li> <li><code>coalesce(content: Template...) -&gt; Template</code>: Returns the first non-empty   content.</li> <li><code>concat(content: Template...) -&gt; Template</code>:   Same as <code>content_1 ++ ... ++ content_n</code>.</li> <li><code>join(separator: Template, content: Template...) -&gt; Template</code>: Insert   <code>separator</code> between <code>content</code>s.</li> <li><code>separate(separator: Template, content: Template...) -&gt; Template</code>: Insert   <code>separator</code> between non-empty <code>content</code>s.</li> <li><code>surround(prefix: Template, suffix: Template, content: Template) -&gt; Template</code>:   Surround non-empty content with texts such as parentheses.</li> <li><code>config(name: StringLiteral) -&gt; Option&lt;ConfigValue&gt;</code>: Look up configuration    value by <code>name</code>.</li> <li><code>git_web_url([remote: String]) -&gt; String</code>: Best-effort conversion of a git   remote URL to an HTTPS web URL. Defaults to the \"origin\" remote. Returns an   empty string on failure. SSH host alias resolution is currently unsupported.</li> </ul>"},{"location":"templates.html#types","title":"Types","text":""},{"location":"templates.html#annotationline-type","title":"<code>AnnotationLine</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>The following methods are defined.</p> <ul> <li><code>.commit() -&gt; Commit</code>: Commit responsible for changing the relevant line.</li> <li><code>.content() -&gt; Template</code>: Line content including newline character.</li> <li><code>.line_number() -&gt; Integer</code>: 1-based line number.</li> <li><code>.original_line_number() -&gt; Integer</code>: 1-based line number in the original commit.</li> <li><code>.first_line_in_hunk() -&gt; Boolean</code>: False when the directly preceding line   references the same commit.</li> </ul>"},{"location":"templates.html#boolean-type","title":"<code>Boolean</code> type","text":"<p>Conversion: <code>Boolean</code>: yes, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>No methods are defined. Can be constructed with <code>false</code> or <code>true</code> literal.</p>"},{"location":"templates.html#changeid-type","title":"<code>ChangeId</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.normal_hex() -&gt; String</code>: Normal hex representation (0-9a-f) instead of the   canonical \"reversed\" (z-k) representation.</li> <li><code>.short([len: Integer]) -&gt; String</code></li> <li><code>.shortest([min_len: Integer]) -&gt; ShortestIdPrefix</code>: Shortest unique prefix.</li> </ul>"},{"location":"templates.html#commit-type","title":"<code>Commit</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.description() -&gt; String</code>: Usually ends with a trailing <code>\\n</code>, if non-blank.</li> <li><code>.trailers() -&gt; List&lt;Trailer&gt;</code>: The trailers at the end of the commit   description that are formatted as <code>&lt;key&gt;: &lt;value&gt;</code>. These are returned in the   same order as they appear in the description, and there may be multiple   <code>Trailer</code>s with the same key.</li> <li><code>.change_id() -&gt; ChangeId</code></li> <li><code>.commit_id() -&gt; CommitId</code></li> <li><code>.parents() -&gt; List&lt;Commit&gt;</code></li> <li><code>.author() -&gt; Signature</code></li> <li><code>.committer() -&gt; Signature</code></li> <li><code>.signature() -&gt; Option&lt;CryptographicSignature&gt;</code>: Cryptographic signature if   the commit was signed.</li> <li><code>.mine() -&gt; Boolean</code>: Commits where the author's email matches the email of   the current user.</li> <li><code>.working_copies() -&gt; List&lt;WorkspaceRef&gt;</code>: For multi-workspace repositories,   returns a list of workspace references for each workspace whose working-copy   commit matches the current commit.</li> <li><code>.current_working_copy() -&gt; Boolean</code>: True for the working-copy commit of the   current workspace.</li> <li><code>.bookmarks() -&gt; List&lt;CommitRef&gt;</code>: Local and remote bookmarks pointing to the   commit. A tracked remote bookmark will be included only if its target is   different from the local one.</li> <li><code>.local_bookmarks() -&gt; List&lt;CommitRef&gt;</code>: All local bookmarks pointing to the   commit.</li> <li><code>.remote_bookmarks() -&gt; List&lt;CommitRef&gt;</code>: All remote bookmarks pointing to the   commit.</li> <li><code>.tags() -&gt; List&lt;CommitRef&gt;</code>: Local and remote tags pointing to the commit. A   tracked remote tag will be included only if its target is different from the   local one.</li> <li><code>.local_tags() -&gt; List&lt;CommitRef&gt;</code>: All local tags pointing to the commit.</li> <li><code>.remote_tags() -&gt; List&lt;CommitRef&gt;</code>: All remote tags pointing to the commit.</li> <li><code>.divergent() -&gt; Boolean</code>: True if the commit's change ID corresponds to multiple   visible commits.</li> <li><code>.hidden() -&gt; Boolean</code>: True if the commit is not visible (a.k.a. abandoned).</li> <li><code>.change_offset() -&gt; Option&lt;Integer&gt;</code>: The change offset   of this commit. May not be available for some commits.</li> <li><code>.immutable() -&gt; Boolean</code>: True if the commit is included in the set of   immutable commits.</li> <li><code>.contained_in(revset: StringLiteral) -&gt; Boolean</code>: True if the commit is included in   the provided revset.</li> <li><code>.conflict() -&gt; Boolean</code>: True if the commit contains merge conflicts.</li> <li><code>.empty() -&gt; Boolean</code>: True if the commit modifies no files.</li> <li><code>.diff([files: StringLiteral]) -&gt; TreeDiff</code>: Changes from the parents within the   <code>files</code> expression. All files are compared by default, but it is   likely to change in future version to respect the command line path arguments.</li> <li><code>.files([files: StringLiteral]) -&gt; List&lt;TreeEntry&gt;</code>: Files that exist in this commit,   matching the <code>files</code> expression. Use <code>.diff().files()</code> to list   changed files.</li> <li><code>.conflicted_files() -&gt; List&lt;TreeEntry&gt;</code>: Conflicted files in this commit.</li> <li><code>.root() -&gt; Boolean</code>: True if the commit is the root commit.</li> </ul>"},{"location":"templates.html#commitevolutionentry-type","title":"<code>CommitEvolutionEntry</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.commit() -&gt; Commit</code>: New commit.</li> <li><code>.operation() -&gt; Operation</code>: Operation where the commit was created or   rewritten.</li> <li><code>.predecessors() -&gt; List&lt;Commit&gt;</code>: Predecessor commits of this entry.</li> <li><code>.inter_diff([files: StringLiteral]) -&gt; TreeDiff</code>: Changes between this commit and its   predecessor version(s), rebased onto the parents of this commit to avoid unrelated   changes (similar to <code>jj evolog -p</code>).</li> </ul>"},{"location":"templates.html#commitid-type","title":"<code>CommitId</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.short([len: Integer]) -&gt; String</code></li> <li><code>.shortest([min_len: Integer]) -&gt; ShortestIdPrefix</code>: Shortest unique prefix.</li> </ul>"},{"location":"templates.html#commitref-type","title":"<code>CommitRef</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.name() -&gt; RefSymbol</code>: Local bookmark or tag name.</li> <li><code>.remote() -&gt; Option&lt;RefSymbol&gt;</code>: Remote name if this is a remote ref.</li> <li><code>.present() -&gt; Boolean</code>: True if the ref points to any commit.</li> <li><code>.conflict() -&gt; Boolean</code>: True if the bookmark or tag is   conflicted.</li> <li><code>.normal_target() -&gt; Option&lt;Commit&gt;</code>: Target commit if the ref is not   conflicted and points to a commit.</li> <li><code>.removed_targets() -&gt; List&lt;Commit&gt;</code>: Old target commits if conflicted.</li> <li><code>.added_targets() -&gt; List&lt;Commit&gt;</code>: New target commits. The list usually   contains one \"normal\" target.</li> <li><code>.tracked() -&gt; Boolean</code>: True if the ref is tracked by a local ref. The local   ref might have been deleted (but not pushed yet.)</li> <li><code>.tracking_present() -&gt; Boolean</code>: True if the ref is tracked by a local ref,     and if the local ref points to any commit.</li> <li><code>.tracking_ahead_count() -&gt; SizeHint</code>: Number of commits ahead of the tracking   local ref.</li> <li><code>.tracking_behind_count() -&gt; SizeHint</code>: Number of commits behind of the   tracking local ref.</li> <li><code>.synced() -&gt; Boolean</code>: For a local bookmark, true if synced with all tracked   remotes. For a remote bookmark, true if synced with the tracking local   bookmark.</li> </ul>"},{"location":"templates.html#configvalue-type","title":"<code>ConfigValue</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>This type can be printed in TOML syntax. The following methods are defined.</p> <ul> <li><code>.as_boolean() -&gt; Boolean</code>: Extract boolean.</li> <li><code>.as_integer() -&gt; Integer</code>: Extract integer.</li> <li><code>.as_string() -&gt; String</code>: Extract string. This does not convert non-string   value (e.g. integer) to string.</li> <li><code>.as_string_list() -&gt; List&lt;String&gt;</code>: Extract list of strings.</li> </ul>"},{"location":"templates.html#cryptographicsignature-type","title":"<code>CryptographicSignature</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>The following methods are defined.</p> <ul> <li><code>.status() -&gt; String</code>: The signature's status (<code>\"good\"</code>, <code>\"bad\"</code>, <code>\"unknown\"</code>,   <code>\"invalid\"</code>).</li> <li><code>.key() -&gt; String</code>: The signature's key id representation (for GPG and SSH,   this is the public key fingerprint).</li> <li><code>.display() -&gt; String</code>: The signature's display string (for GPG, this is the   formatted primary user ID; for SSH, this is the principal).</li> </ul> <p>Warning</p> <p>Calling any of <code>.status()</code>, <code>.key()</code>, or <code>.display()</code> is slow, as it incurs the performance cost of verifying the signature (for example shelling out to <code>gpg</code> or <code>ssh-keygen</code>). Though consecutive calls will be faster, because the backend caches the verification result.</p> <p>Info</p> <p>As opposed to calling any of <code>.status()</code>, <code>.key()</code>, or <code>.display()</code>, checking for signature presence through boolean coercion is fast: <pre><code>if(commit.signature(), \"commit has a signature\", \"commit is unsigned\")\n</code></pre></p>"},{"location":"templates.html#diffstatentry-type","title":"<code>DiffStatEntry</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>This type holds the diff stats per file. The following methods are defined.</p> <ul> <li><code>.bytes_delta() -&gt; Integer</code>: The difference in size of the file, in bytes.</li> <li><code>.lines_added() -&gt; Integer</code>: Number of lines added.</li> <li><code>.lines_removed() -&gt; Integer</code>: Number of lines deleted.</li> <li><code>.path() -&gt; RepoPath</code>: Path to the entry. If the entry is a copy/rename, this   points to the target (or right) entry.</li> <li><code>.display_diff_path() -&gt; String</code>: Format path for display, taking into account copy/rename information.</li> <li><code>.status() -&gt; String</code>: One of <code>\"modified\"</code>, <code>\"added\"</code>, <code>\"removed\"</code>, <code>\"copied\"</code>, or <code>\"renamed\"</code>.</li> <li><code>.status_char() -&gt; String</code>: One of <code>\"M\"</code> (modified), <code>\"A\"</code> (added), <code>\"D\"</code> (removed),   <code>\"C\"</code> (copied), or <code>\"R\"</code> (renamed).</li> </ul>"},{"location":"templates.html#diffstats-type","title":"<code>DiffStats</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: yes</p> <p>This type can be printed as a histogram of the changes. The following methods are defined.</p> <ul> <li><code>.files() -&gt; List&lt;DiffStatEntry&gt;</code>: Per-file stats for changed files.</li> <li><code>.total_added() -&gt; Integer</code>: Total number of insertions.</li> <li><code>.total_removed() -&gt; Integer</code>: Total number of deletions.</li> </ul>"},{"location":"templates.html#email-type","title":"<code>Email</code> type","text":"<p>Conversion: <code>Boolean</code>: yes, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The email field of a signature may or may not look like an email address. It may be empty, may not contain the symbol <code>@</code>, and could in principle contain multiple <code>@</code>s.</p> <p>The following methods are defined.</p> <ul> <li><code>.local() -&gt; String</code>: the part of the email before the first <code>@</code>, usually the   username.</li> <li><code>.domain() -&gt; String</code>: the part of the email after the first <code>@</code> or the empty   string.</li> </ul>"},{"location":"templates.html#integer-type","title":"<code>Integer</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>No methods are defined.</p>"},{"location":"templates.html#list-type","title":"<code>List</code> type","text":"<p>Conversion: <code>Boolean</code>: yes, <code>Serialize</code>: maybe, <code>Template</code>: maybe</p> <p>A list can be implicitly converted to <code>Boolean</code>. The following methods are defined.</p> <ul> <li><code>.len() -&gt; Integer</code>: Number of elements in the list.</li> <li><code>.join(separator: Template) -&gt; Template</code>: Concatenate elements with   the given <code>separator</code>.</li> <li><code>.filter(|item| expression) -&gt; List</code>: Filter list elements by predicate   <code>expression</code>. Example: <code>description.lines().filter(|s| s.contains(\"#\"))</code></li> <li><code>.map(|item| expression) -&gt; ListTemplate</code>: Apply template <code>expression</code>   to each element. Example: <code>parents.map(|c| c.commit_id().short())</code></li> <li><code>.any(|item| expression) -&gt; Boolean</code>: Returns true if any element satisfies   the predicate <code>expression</code>. Example: <code>parents.any(|c| c.description().contains(\"fix\"))</code></li> <li><code>.all(|item| expression) -&gt; Boolean</code>: Returns true if all elements satisfy   the predicate <code>expression</code>. Example: <code>parents.all(|c| c.mine())</code></li> </ul>"},{"location":"templates.html#listtrailer-type","title":"<code>List&lt;Trailer&gt;</code> type","text":"<p>The following methods are defined. See also the <code>List</code> type.</p> <ul> <li><code>.contains_key(key: Stringify) -&gt; Boolean</code>: True if the commit description   contains at least one trailer with the key <code>key</code>.</li> </ul>"},{"location":"templates.html#listtemplate-type","title":"<code>ListTemplate</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.join(separator: Template) -&gt; Template</code>: Concatenate elements with   the given <code>separator</code>.</li> </ul>"},{"location":"templates.html#operation-type","title":"<code>Operation</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.current_operation() -&gt; Boolean</code></li> <li><code>.description() -&gt; String</code></li> <li><code>.id() -&gt; OperationId</code></li> <li><code>.tags() -&gt; String</code></li> <li><code>.time() -&gt; TimestampRange</code></li> <li><code>.user() -&gt; String</code></li> <li><code>.snapshot() -&gt; Boolean</code>: True if the operation is a snapshot operation.</li> <li><code>.root() -&gt; Boolean</code>: True if the operation is the root operation.</li> <li><code>.parents() -&gt; List&lt;Operation&gt;</code></li> </ul>"},{"location":"templates.html#operationid-type","title":"<code>OperationId</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.short([len: Integer]) -&gt; String</code></li> </ul>"},{"location":"templates.html#option-type","title":"<code>Option</code> type","text":"<p>Conversion: <code>Boolean</code>: yes, <code>Serialize</code>: maybe, <code>Template</code>: maybe</p> <p>An option can be implicitly converted to <code>Boolean</code> denoting whether the contained value is set. If set, all methods of the contained value can be invoked. If not set, an error will be reported inline on method call.</p> <p>On comparison between two optional values or optional and non-optional values, unset value is not an error. Unset value is considered less than any set values.</p>"},{"location":"templates.html#refsymbol-type","title":"<code>RefSymbol</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>A <code>String</code> type, but is formatted as revset symbol by quoting and escaping if necessary. Unlike strings, this cannot be implicitly converted to <code>Boolean</code>.</p>"},{"location":"templates.html#repopath-type","title":"<code>RepoPath</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>A slash-separated path relative to the repository root. The following methods are defined.</p> <ul> <li><code>.absolute() -&gt; String</code>: Format as absolute path using platform-native   separator.</li> <li><code>.display() -&gt; String</code>: Format path for display. The formatted path uses   platform-native separator, and is relative to the current working directory.</li> <li><code>.parent() -&gt; Option&lt;RepoPath&gt;</code>: Parent directory path.</li> </ul>"},{"location":"templates.html#serialize-type","title":"<code>Serialize</code> type","text":"<p>An expression that can be serialized in machine-readable format such as JSON.</p> <p>Note</p> <p>Field names and value types in the serialized output are usually stable across jj versions, but the backward compatibility isn't guaranteed. If the underlying data model is updated, the serialized output may change.</p>"},{"location":"templates.html#shortestidprefix-type","title":"<code>ShortestIdPrefix</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.prefix() -&gt; String</code></li> <li><code>.rest() -&gt; String</code></li> <li><code>.upper() -&gt; ShortestIdPrefix</code></li> <li><code>.lower() -&gt; ShortestIdPrefix</code></li> </ul>"},{"location":"templates.html#signature-type","title":"<code>Signature</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.name() -&gt; String</code></li> <li><code>.email() -&gt; Email</code></li> <li><code>.timestamp() -&gt; Timestamp</code></li> </ul>"},{"location":"templates.html#sizehint-type","title":"<code>SizeHint</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.lower() -&gt; Integer</code>: Lower bound.</li> <li><code>.upper() -&gt; Option&lt;Integer&gt;</code>: Upper bound if known.</li> <li><code>.exact() -&gt; Option&lt;Integer&gt;</code>: Exact value if upper bound is known and it   equals to the lower bound.</li> <li><code>.zero() -&gt; Boolean</code>: True if upper bound is known and is <code>0</code>. Equivalent to   <code>.upper() == 0</code>.</li> </ul>"},{"location":"templates.html#string-type","title":"<code>String</code> type","text":"<p>Conversion: <code>Boolean</code>: yes, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>A string can be implicitly converted to <code>Boolean</code>. The following methods are defined.</p> <ul> <li><code>.len() -&gt; Integer</code>: Length in UTF-8 bytes.</li> <li><code>.contains(needle: Stringify) -&gt; Boolean</code>: Whether the string contains the   provided stringifiable value as a substring.</li> <li> <p><code>.match(needle: StringPattern) -&gt; String</code>: Extracts   the first matching part of the string for the given pattern.</p> <p>An empty string is returned if there is no match.</p> </li> <li> <p><code>.replace(pattern: StringPattern, replacement: Stringify, [limit: Integer]) -&gt; String</code>:   Replace occurrences of the given <code>pattern</code> with the <code>replacement</code> string.</p> <p>By default, all occurrences are replaced. If <code>limit</code> is specified, at most that many occurrences are replaced.</p> <p>Supports capture groups in patterns using <code>$0</code> (entire match), <code>$1</code>, <code>$2</code> etc.</p> </li> <li> <p><code>.first_line() -&gt; String</code></p> </li> <li><code>.lines() -&gt; List&lt;String&gt;</code>: Split into lines excluding newline characters.</li> <li><code>.split(separator: StringPattern, [limit: Integer]) -&gt; List&lt;String&gt;</code>: Split into   substrings by the given <code>separator</code> pattern. If <code>limit</code> is specified, it   determines the maximum number of elements in the result, with the remainder   of the string returned as the final element. A <code>limit</code> of 0 returns an empty list.</li> <li><code>.upper() -&gt; String</code></li> <li><code>.lower() -&gt; String</code></li> <li><code>.starts_with(needle: Stringify) -&gt; Boolean</code></li> <li><code>.ends_with(needle: Stringify) -&gt; Boolean</code></li> <li><code>.remove_prefix(needle: Stringify) -&gt; String</code>: Removes the passed prefix, if   present.</li> <li><code>.remove_suffix(needle: Stringify) -&gt; String</code>: Removes the passed suffix, if   present.</li> <li><code>.trim() -&gt; String</code>: Removes leading and trailing whitespace</li> <li><code>.trim_start() -&gt; String</code>: Removes leading whitespace</li> <li><code>.trim_end() -&gt; String</code>: Removes trailing whitespace</li> <li><code>.substr(start: Integer, end: Integer) -&gt; String</code>: Extract substring. The   <code>start</code>/<code>end</code> indices should be specified in UTF-8 bytes. Indices are 0-based   and <code>end</code> is exclusive. Negative values count from the end of the string,   with <code>-1</code> being the last byte. If the <code>start</code> index is in the middle of a UTF-8   codepoint, the codepoint is fully part of the result. If the <code>end</code> index is in   the middle of a UTF-8 codepoint, the codepoint is not part of the result.</li> <li><code>.escape_json() -&gt; String</code>: Serializes the string in JSON format. This   function is useful for making machine-readable templates. For example, you   can use it in a template like <code>'{ \"foo\": ' ++ foo.escape_json() ++ ' }'</code> to   return a JSON/JSONL.</li> </ul>"},{"location":"templates.html#stringify-type","title":"<code>Stringify</code> type","text":"<p>An expression that can be converted to a <code>String</code>.</p> <p>Any types that can be converted to <code>Template</code> can also be <code>Stringify</code>. Unlike <code>Template</code>, color labels are stripped.</p>"},{"location":"templates.html#stringliteral-type","title":"<code>StringLiteral</code> type","text":"<p>A string literal known at parse time. Unlike <code>Stringify</code>, this cannot be a dynamic expression - it must be a literal value like <code>\"main\"</code> or <code>\"format\"</code>.</p> <p>String literals must be surrounded by single or double quotes (<code>'</code> or <code>\"</code>). A double-quoted string literal supports the following escape sequences:</p> <ul> <li><code>\\\"</code>: double quote</li> <li><code>\\\\</code>: backslash</li> <li><code>\\t</code>: horizontal tab</li> <li><code>\\r</code>: carriage return</li> <li><code>\\n</code>: new line</li> <li><code>\\0</code>: null</li> <li><code>\\e</code>: escape (i.e., <code>\\x1b</code>)</li> <li><code>\\xHH</code>: byte with hex value <code>HH</code></li> </ul> <p>Other escape sequences are not supported. Any UTF-8 characters are allowed inside a string literal, with two exceptions: unescaped <code>\"</code>-s and uses of <code>\\</code> that don't form a valid escape sequence.</p> <p>A single-quoted string literal has no escape syntax. <code>'</code> can't be expressed inside a single-quoted string literal.</p> <p>String literals have their own type so that the value can be validated at parse time. For example, <code>contained_in(revset)</code> requires a literal so the revset can be parsed and checked before the template is evaluated.</p>"},{"location":"templates.html#stringpattern-type","title":"<code>StringPattern</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>These are the exact same as the String pattern type in revsets, except that quotes are mandatory.</p> <p>Literal strings may be used, which are interpreted as case-sensitive substring matching.</p> <p>Currently <code>StringPattern</code> values cannot be passed around as values and may only occur directly in the call site they are used in.</p>"},{"location":"templates.html#template-type","title":"<code>Template</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: yes</p> <p>Most types can be implicitly converted to <code>Template</code>. No methods are defined.</p>"},{"location":"templates.html#timestamp-type","title":"<code>Timestamp</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.ago() -&gt; String</code>: Format as relative timestamp.</li> <li><code>.format(format: StringLiteral) -&gt; String</code>: Format with the specified strftime-like   format string.</li> <li><code>.utc() -&gt; Timestamp</code>: Convert timestamp into UTC timezone.</li> <li><code>.local() -&gt; Timestamp</code>: Convert timestamp into local timezone.</li> <li><code>.after(date: StringLiteral) -&gt; Boolean</code>: True if the timestamp is exactly at or   after the given date. Supported date formats are the same as the revset   Date pattern type.</li> <li><code>.before(date: StringLiteral) -&gt; Boolean</code>: True if the timestamp is before, but   not including, the given date. Supported date formats are the same as the   revset Date pattern type.</li> </ul>"},{"location":"templates.html#timestamprange-type","title":"<code>TimestampRange</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.start() -&gt; Timestamp</code></li> <li><code>.end() -&gt; Timestamp</code></li> <li><code>.duration() -&gt; String</code></li> </ul>"},{"location":"templates.html#trailer-type","title":"<code>Trailer</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.key() -&gt; String</code></li> <li><code>.value() -&gt; String</code></li> </ul>"},{"location":"templates.html#treediff-type","title":"<code>TreeDiff</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.files() -&gt; List&lt;TreeDiffEntry&gt;</code>: Changed files.</li> <li><code>.color_words([context: Integer]) -&gt; Template</code>: Format as a word-level diff   with changes indicated only by color.</li> <li><code>.git([context: Integer]) -&gt; Template</code>: Format as a Git diff.</li> <li><code>.stat([width: Integer]) -&gt; DiffStats</code>: Calculate stats of changed lines.</li> <li><code>.summary() -&gt; Template</code>: Format as a list of status code and path pairs.</li> </ul>"},{"location":"templates.html#treediffentry-type","title":"<code>TreeDiffEntry</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.path() -&gt; RepoPath</code>: Path to the entry. If the entry is a copy/rename, this   points to the target (or right) entry.</li> <li><code>.display_diff_path() -&gt; String</code>: Format path for display, taking into account copy/rename information.</li> <li><code>.status() -&gt; String</code>: One of <code>\"modified\"</code>, <code>\"added\"</code>, <code>\"removed\"</code>,   <code>\"copied\"</code>, or <code>\"renamed\"</code>.</li> <li><code>.status_char() -&gt; String</code>: Single-character status indicator: <code>\"M\"</code> for modified,   <code>\"A\"</code> for added, <code>\"D\"</code> for removed, <code>\"C\"</code> for copied, or <code>\"R\"</code> for renamed.</li> <li><code>.source() -&gt; TreeEntry</code>: The source (or left) entry.</li> <li><code>.target() -&gt; TreeEntry</code>: The target (or right) entry.</li> </ul>"},{"location":"templates.html#treeentry-type","title":"<code>TreeEntry</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: no, <code>Template</code>: no</p> <p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.path() -&gt; RepoPath</code>: Path to the entry.</li> <li><code>.conflict() -&gt; Boolean</code>: True if the entry is a merge conflict.</li> <li><code>.conflict_side_count() -&gt; Integer</code>: Number of sides in the merge conflict (1 if not   conflicted, 2 or more for multi-way merges).</li> <li><code>.file_type() -&gt; String</code>: One of <code>\"file\"</code>, <code>\"symlink\"</code>, <code>\"tree\"</code>,   <code>\"git-submodule\"</code>, or <code>\"conflict\"</code>.</li> <li><code>.executable() -&gt; Boolean</code>: True if the entry is an executable file.</li> </ul>"},{"location":"templates.html#workspaceref-type","title":"<code>WorkspaceRef</code> type","text":"<p>Conversion: <code>Boolean</code>: no, <code>Serialize</code>: yes, <code>Template</code>: yes</p> <p>The following methods are defined.</p> <ul> <li><code>.name() -&gt; RefSymbol</code>: Returns the workspace name as a symbol.</li> <li><code>.target() -&gt; Commit</code>: Returns the working-copy commit of this workspace.</li> </ul>"},{"location":"templates.html#color-labels","title":"Color labels","text":"<p>You can customize the output colors by using color labels. <code>jj</code> adds some labels automatically; they can also be added manually.</p> <p>Template fragments are usually automatically labeled with the command name, the context (or the top-level object), and the method names. For example, the following template is labeled as <code>op_log operation id short</code> automatically:</p> <pre><code>jj op log -T 'self.id().short()'\n</code></pre> <p>The exact names of such labels are often straightforward, but are not currently documented. You can discover the actual label names used with the <code>--color=debug</code> option, e.g.</p> <pre><code>jj op log -T 'self.id().short()' --color=debug\n</code></pre> <p>Additionally, you can manually insert arbitrary labels using the <code>label(label, content)</code> function. For example,</p> <pre><code>jj op log -T '\"ID: \" ++ self.id().short().substr(0, 1) ++ label(\"id short\",  \"&lt;redacted&gt;\")'\n</code></pre> <p>will print \"ID:\" in the default style, and the string <code>&lt;redacted&gt;</code> in the same style as the first character of the id. It would also be fine to use an arbitrary template instead of the string <code>\"&lt;redacted&gt;\"</code>, possibly including nested invocations of <code>label()</code>.</p> <p>You are free to use custom label names as well. This will only have a visible effect if you also customize their colors explicitly.</p>"},{"location":"templates.html#configuration","title":"Configuration","text":"<p>The default templates and aliases() are defined in the <code>[templates]</code> and <code>[template-aliases]</code> sections of the config respectively. The exact definitions can be seen in the <code>cli/src/config/templates.toml</code> file in jj's source tree.</p> <p>New keywords and functions can be defined as aliases, by using any combination of the predefined keywords/functions and other aliases.</p> <p>Alias functions can be overloaded by the number of parameters. However, builtin functions will be shadowed by name, and can't co-exist with aliases.</p> <p>For example:</p> <pre><code>[template-aliases]\n'commit_change_ids' = '''\nconcat(\n  format_field(\"Commit ID\", commit_id),\n  format_field(\"Change ID\", change_id),\n)\n'''\n'format_field(key, value)' = 'key ++ \": \" ++ value ++ \"\\n\"'\n</code></pre>"},{"location":"templates.html#examples","title":"Examples","text":"<p>Get short commit IDs of the working-copy parents:</p> <pre><code>jj log --no-graph -r @ -T 'parents.map(|c| c.commit_id().short()).join(\",\")'\n</code></pre> <p>Show machine-readable list of full commit and change IDs:</p> <pre><code>jj log --no-graph -T 'commit_id ++ \" \" ++ change_id ++ \"\\n\"'\n</code></pre> <p>Print the description of the current commit, defaulting to <code>(no description set)</code>:</p> <pre><code>jj log -r @ --no-graph -T 'coalesce(description, \"(no description set)\\n\")'\n</code></pre>"},{"location":"testimonials.html","title":"Testimonials","text":"<p>You might not be ready to make the jump to Jujutsu yet. It's understandable; new tools come with new lessons, failures, and ideas to absorb. They require practice. In order to provide some motivation, we've collected a number of real, 100% authentic testimonials \u2014 from our loving users, our silly developers \u2014 all to tip the scales and get you on our side!</p>"},{"location":"testimonials.html#what-the-users-have-to-say","title":"What the users have to say","text":"<p>I've spent many years of my career working on version control. What I like most about Jujutsu is how it has non-obvious solutions to UX problems that we've run into in the past. What most people may not realize is that there are many novel features which all interlock to make it easy to use.</p> <p>For example, consider Jujutsu's support for automatically rebasing descendants of amended revisions. When we implemented that in Mercurial, we ran into an issue: what if there's a merge conflict? Our solution was to warn users and just not perform the auto-rebase. Now, suddenly, users have to understand that there can be old versions of the same revision visible in their log, and learn how to fix this state.</p> <p>In contrast, Jujutsu's solution is to simply make merge conflicts first-class. This is not just an improvement in general, it is also specifically an improvement for auto-rebase \u2014 users no longer have to learn about old versions of a revision unless they want to look at the obslog.</p> <p>Over and over, I'm struck by how well Jujutsu demonstrates this kind of evolved thinking, which as an experienced version control developer I deeply appreciate.</p> <p>\u2014 Rain, engineer at Oxide Computer Company, former VCS developer</p> <p>Jujutsu is amazing... I couldn't have come up with anything remotely as elegant.</p> <p>It's so rare that a solution attacks the innermost core of a problem so thoroughly, I genuinely feel blessed to be in its presence. And also a bit vindicated in not even trying to learn to use any of the tools that felt like more crutches stacked upon a sand castle</p> <p>\u2014 Anonymous user, speaking from the shadows</p> <p>It's the easiest time I've ever had learning a tool this deeply this quickly, because of the ability to experiment and undo, instead of triple-checking before trying a new scary command.</p> <p>\u2014 Scott Olson, advanced Git user and now a Jujutsu user</p> <p>I initially started to use Jujutsu for personal repos, and it has quickly gone from \"neat, let's try this more\" to \"very neat, added to my permanent config and automatically installed for new machines\".</p> <p>\u2014 Poliorcetics, on GitHub</p> <p>when i worked on the rust compiler, my job was to chain together a bunch of strange and cursed tools that broke often. jujutsu breaks about half as much, so that's pretty good i guess</p> <p>\u2014 jyn514, Rust contributor</p> <p>Jujutsu is pretty cool, you can even keep most of your existing workflows</p> <p>\u2014 Ben, who doesn't want you keeping your existing workflow</p> <p>Wait, it's not called Jujitsu?</p> <p>\u2014 Phil, Mercurial contributor (who doesn't have to learn Git, now that Jujutsu exists)</p> <p>When I heard about Jujutsu I decided to try it out before forming an opinion. Technically it never formed, because I haven't considered going back.</p> <p>\u2014 gul banana, computer programmer</p> <p>muwhahaha, I have corrupted my cofounder and now 100% of brontosource dev is on JJ.</p> <p>\u2014 Matt Kulunkundis, cofounder BrontoSource</p> <p>jj is genuinely the first tool since Rust that has me excited.</p> <p>\u2014 David Barsky, rust-analyzer and <code>tokio-rs/tracing</code> developer</p> <p>Today I did some complex surgery on a legacy repo that has been committed to for years by a number of individuals with varying hygienic habits. [..]</p> <p>Now, this still took me about two hours using jj. But at no point did I seriously consider physical violence to humans or inanimate objects. Everything progressed calmly and methodically. I was able to introspect changes before I made them, and when I did screw up\u2026 <code>jj undo</code> to the rescue.</p> <p>\u2014 An unknown scientist, who couldn't have done it with Git.</p> <p>jj was my first exposure to revsets and at first I was \"why would I ever need that\", but now after exercising that math part of my brain that's been stale since high school, they're indispensable</p> <p>\u2014 Marijan Smetko, who previously only knew Git.</p> <p>I think my favorite thing about jj is it makes the way I abused Git via lazygit the standard way of doing things</p> <p>\u2014 Isaac Corbrey, reformed Git user</p>"},{"location":"testimonials.html#what-the-developers-have-to-say","title":"What the developers have to say","text":"<p>I've been a FOSS contributor using Git for over 16 years, and Jujutsu continues to amaze me every day. It has that sweet simplicity I was fond of in Darcs, but it boils down all my most core and fundamental workflows \u2014 developed over years of experience \u2014 into a simple set of primitives. The internal design is simple and beautiful; it looks like a database, making the implementation elegant, safe, and extensible. All this, using the same Git repositories my coworkers use.</p> <p>It's like if you found out one day that you built your entire home on a vein of rich gold. Every day I seem to find new and beautiful emergent behaviors, all adding up to a tool that is greater than the sum of its parts.</p> <p>\u2014 Austin Seipp, \"No 1. Jujutsu Fan\"</p> <p>Honestly, I implemented signing support mostly for that sweet dopamine hit that you get from the green checkmark on GitHub. Yeah.</p> <p>\u2014 Anton Bulakh, contributor and dopamine enthusiast</p> <p>I'm sometimes still surprised that navigating with <code>jj next</code> and <code>jj prev</code> works.</p> <p>\u2014 Philip Metzger, author of <code>jj next</code> and <code>jj prev</code></p> <p>I'm surprised when it works.</p> <p>\u2014 Martin von Zweigbergk, project creator and leader</p>"},{"location":"testimonials.html#spread-the-word-yourself","title":"Spread the word yourself","text":"<p>Are you satisfied with Jujutsu? Ready to recommend it to a Jujillion of your friends and coworkers? Great! The easiest way to help the project grow is word of mouth. So make sure to talk to them about it and show off your hip new tool. Maybe post a link to it on your other favorite tool that you love using, Slack?</p> <p>If you're not sure what to say, we hired the cheapest marketing team we could find to design a list of Pre-Approved Endorsements in their laboratory. Just copy and paste these right into a text box! Shilling for an open source project has never been easier than this.</p> <p>Jujutsu is an alright tool. I guess.</p> <p>Jujutsu is my favorite software tool of all time. I am saying this for no particular reason, definitely not because I was paid to.</p> <p>I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu.</p>"},{"location":"tutorial.html","title":"Tutorial","text":"<p>Hint: This tutorial covers the basics accurately, but since it was written Jujutsu has gained many new features. For a tutorial covering a wider range of features, you may find the (not quite finished) tutorial by Steve Klabnik helpful. If you're looking for a tutorial that doesn't require experience with Git, take a look at Jujutsu for everyone.</p> <p>This text assumes that the reader is familiar with Git.</p>"},{"location":"tutorial.html#preparation","title":"Preparation","text":"<p>If you haven't already, make sure you install and configure Jujutsu.</p>"},{"location":"tutorial.html#cloning-a-git-repository","title":"Cloning a Git repository","text":"<p>Hint: Most identifiers used in this tutorial will be different when you try this at home!</p> <p>Let's start by cloning GitHub's Hello-World repo using <code>jj</code>:</p> <pre><code># Note the \"git\" before \"clone\" (there is no support for cloning native jj\n# repos yet)\n$ jj git clone https://github.com/octocat/Hello-World\nFetching into new repo in \"/tmp/tmp.O1DWMiaKd4/Hello-World\"\nremote: Enumerating objects: 13, done.\nremote: Total 13 (delta 0), reused 0 (delta 0), pack-reused 13 (from 1)\nbookmark: master@origin          [new] untracked\nbookmark: octocat-patch-1@origin [new] untracked\nbookmark: test@origin            [new] untracked\nSetting the revset alias `trunk()` to `master@origin`\nWorking copy  (@) now at: kntqzsqt d7439b06 (empty) (no description set)\nParent commit (@-)      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\nAdded 1 files, modified 0 files, removed 0 files\n$ cd Hello-World\n</code></pre> <p>Running <code>jj st</code> (short for <code>jj status</code>) now yields something like this:</p> <pre><code>$ jj st\nThe working copy has no changes.\nWorking copy  (@) : kntqzsqt d7439b06 (empty) (no description set)\nParent commit (@-): orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\n</code></pre> <p>Let's look at that output as it introduces new concepts. You can see two commits: Parent and working copy. Both are identified using two separate identifiers: the \"change ID\" and the \"commit ID\".</p> <p>The parent commit, for example, has the change ID <code>orrkosyo</code> and the commit ID <code>7fd1a60b</code>.</p> <p>Git users: The commit ID/hash is what you're used to from Git and should match what you see when you look at the repository using <code>git log</code> in a Git checkout of the repository. The change ID however, is a new concept, unique to Jujutsu.</p> <p>We can also see from the output above that our working copy is an actual commit with a commit ID (<code>d7439b06</code> in the example). When you make a change in the working copy, the working-copy commit gets automatically amended by the next <code>jj</code> command.</p> <p>Git users: This is a huge difference from Git where the working copy is a separate concept and not yet a commit.</p>"},{"location":"tutorial.html#changes","title":"Changes","text":"<p>A change is a commit that can evolve while keeping a stable identifier (similar to Gerrit's Change-Id). In other words: You can make changes to files in a change, resulting in a new commit hash, but the change ID will remain the same.</p> <p>You can see that our clone operation automatically created a new change:</p> <pre><code>Working copy  (@) : kntqzsqt d7439b06 (empty) (no description set)\n</code></pre> <p>This new change has the ID <code>kntqzsqt</code> and it is currently empty (contains no changes compared to the parent) and has no description.</p>"},{"location":"tutorial.html#creating-our-first-change","title":"Creating our first change","text":"<p>Let's say we want to edit the <code>README</code> file in the repo to say \"Goodbye\" instead of \"Hello\". Start by describing the change (adding a commit message) so we don't forget what we're working on:</p> <pre><code># This brings up $EDITOR (or `nano` or `Notepad` by default).\n# Enter something like \"Say goodbye\" in the editor and then save the file and close\n# the editor.\n$ jj describe\nWorking copy  (@) now at: kntqzsqt e427edcf (empty) Say goodbye\nParent commit (@-)      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\n</code></pre> <p>Now make the change in the README:</p> <pre><code># Adjust as necessary for compatibility with your flavor of `sed`\n$ sed -i 's/Hello/Goodbye/' README\n$ jj st\nWorking copy changes:\nM README\nWorking copy  (@) : kntqzsqt 5d39e19d Say goodbye\nParent commit (@-): orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\n</code></pre> <p>Note that you didn't have to tell Jujutsu to add the change like you would with <code>git add</code>. You actually don't even need to tell it when you add new files or remove existing files. To untrack a path, add it to your <code>.gitignore</code> and run <code>jj file untrack &lt;path&gt;</code>.</p> <p>Also note that the commit hash for our current change (<code>kntqzsqt</code>) changed from <code>e427edcf</code> to <code>5d39e19d</code>!</p> <p>To see the diff, run <code>jj diff</code>:</p> <pre><code>$ jj diff --git  # Feel free to skip the `--git` flag\ndiff --git a/README b/README\nindex 980a0d5f19..1ce3f81130 100644\n--- a/README\n+++ b/README\n@@ -1,1 +1,1 @@\n-Hello World!\n+Goodbye World!\n</code></pre> <p>Jujutsu's diff format currently defaults to inline coloring of the diff (like <code>git diff --color-words</code>), so we used <code>--git</code> above to make the diff readable in this tutorial.</p> <p>As you may have noticed, the working-copy commit's ID changed both when we edited the description and when we edited the README. However, the parent commit stayed the same. Each change to the working-copy commit amends the previous version. So how do we tell Jujutsu that we are done amending the current change and want to start working on a new one? That is what <code>jj new</code> is for. That will create a new commit on top of your current working-copy commit. The new commit is for the working-copy changes.</p> <p>So, let's say we're now done with this change, so we create a new change:</p> <pre><code>$ jj new\nWorking copy  (@) now at: mpqrykyp aef4df99 (empty) (no description set)\nParent commit (@-)      : kntqzsqt 5d39e19d Say goodbye\n$ jj st\nThe working copy has no changes.\nWorking copy  (@) : mpqrykyp aef4df99 (empty) (no description set)\nParent commit (@-): kntqzsqt 5d39e19d Say goodbye\n</code></pre> <p>If we later realize that we want to make further changes, we can make them in the working copy and then run <code>jj squash</code>. That command squashes (moves) the changes from a given commit into its parent commit. Like most commands, it acts on the working-copy commit by default. When run on the working-copy commit, it behaves very similar to <code>git commit --amend</code>.</p> <p>Alternatively, we can use <code>jj edit &lt;commit&gt;</code> to resume editing a commit in the working copy. Any further changes in the working copy will then amend the commit. Whether you choose to create a new change and squash, or to edit, typically depends on how done you are with the change; if the change is almost done, it makes sense to use <code>jj new</code> so you can easily review your adjustments with <code>jj diff</code> before running <code>jj squash</code>.</p> <p>To view how a change has evolved over time, we can use <code>jj evolog</code> to see each recorded change for the current commit. This records changes to the working copy, message, squashes, rebases, etc.</p>"},{"location":"tutorial.html#the-log-command-and-revsets","title":"The log command and \"revsets\"","text":"<p>You're probably familiar with <code>git log</code>. Jujutsu has very similar functionality in its <code>jj log</code> command:</p> <pre><code>$ jj log\n@  mpqrykyp martinvonz@google.com 2023-02-12 15:00:22 aef4df99\n\u2502  (empty) (no description set)\n\u25cb  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59 5d39e19d\n\u2502  Say goodbye\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>The <code>@</code> indicates the working-copy commit. The first ID on a line (e.g. \"mpqrykyp\" above) is the change ID. The second ID is the commit ID. You can give either ID to commands that take revisions as arguments. We will generally prefer change IDs because they stay the same when the commit is rewritten.</p> <p>By default, <code>jj log</code> lists your local commits, with some remote commits added for context. The <code>~</code> indicates that the commit has parents that are not included in the graph. We can use the <code>--revisions</code>/<code>-r</code> flag to select a different set of revisions to list. The flag accepts a \"revset\", which is an expression in a simple language for specifying revisions. For example, <code>@</code> refers to the working-copy commit, <code>root()</code> refers to the root commit, <code>bookmarks()</code> refers to all commits pointed to by bookmarks (similar to Git's branches). We can combine expressions with <code>|</code> for union, <code>&amp;</code> for intersection and <code>~</code> for difference. For example:</p> <pre><code>$ jj log -r '@ | root() | bookmarks()'\n@  mpqrykyp martinvonz@google.com 2023-02-12 15:00:22 aef4df99\n\u2502  (empty) (no description set)\n~  (elided revisions)\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~  (elided revisions)\n\u25c6  zzzzzzzz root() 00000000\n</code></pre> <p>The <code>00000000</code> commit (change ID <code>zzzzzzzz</code>) is a virtual commit that's called the \"root commit\". It's the root commit of every repo. The <code>root()</code> function in the revset matches it.</p> <p>There are also operators for getting the parents (<code>foo-</code>), children (<code>foo+</code>), ancestors (<code>::foo</code>), descendants (<code>foo::</code>), DAG range (<code>foo::bar</code>, like <code>git log --ancestry-path</code>), range (<code>foo..bar</code>, same as Git's). See the revset documentation for all revset operators and functions.</p> <p>Hint: If the default <code>jj log</code> omits some commits you expect to see, you can always run <code>jj log -r ::</code> (or, equivalently, <code>jj log -r 'all()'</code>) to see all the commits.</p>"},{"location":"tutorial.html#conflicts","title":"Conflicts","text":"<p>Now let's see how Jujutsu deals with merge conflicts. We'll start by making some commits. We use <code>jj new</code> with the <code>--message</code>/<code>-m</code> option to set change descriptions (commit messages) right away.</p> <pre><code># Start creating a chain of commits off of the `master` bookmark\n$ jj new master -m A; echo a &gt; file1\nWorking copy  (@) now at: nuvyytnq 00a2aeed (empty) A\nParent commit (@-)      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\nAdded 0 files, modified 1 files, removed 0 files\n$ jj new -m B1; echo b1 &gt; file1\nWorking copy  (@) now at: ovknlmro 967d9f9f (empty) B1\nParent commit (@-)      : nuvyytnq 5dda2f09 A\n$ jj new -m B2; echo b2 &gt; file1\nWorking copy  (@) now at: puqltutt 8ebeaffa (empty) B2\nParent commit (@-)      : ovknlmro 7d7c6e6b B1\n$ jj new -m C; echo c &gt; file2\nWorking copy  (@) now at: qzvqqupx 62a3c6d3 (empty) C\nParent commit (@-)      : puqltutt daa6ffd5 B2\n$ jj log\n@  qzvqqupx martinvonz@google.com 2023-02-12 15:07:41 2370ddf3\n\u2502  C\n\u25cb  puqltutt martinvonz@google.com 2023-02-12 15:07:33 daa6ffd5\n\u2502  B2\n\u25cb  ovknlmro martinvonz@google.com 2023-02-12 15:07:24 7d7c6e6b\n\u2502  B1\n\u25cb  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05 5dda2f09\n\u2502  A\n\u2502 \u25cb  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>We now have a few commits, where A, B1, and B2 modify the same file, while C modifies a different file. Let's now rebase B2 directly onto A. We use the <code>--source</code>/<code>-s</code> option on the change ID of B2, and <code>--onto</code>/<code>-o</code> option on A.</p> <pre><code>$ jj rebase -s puqltutt -o nuvyytnq  # Replace the IDs by what you have for B2 and A\nRebased 2 commits to destination\nWorking copy  (@) now at: qzvqqupx 1978b534 (conflict) C\nParent commit (@-)      : puqltutt f7fb5943 (conflict) B2\nAdded 0 files, modified 1 files, removed 0 files\nWarning: There are unresolved conflicts at these paths:\nfile1    2-sided conflict\nNew conflicts appeared in 2 commits:\n  qzvqqupx 1978b534 (conflict) C\n  puqltutt f7fb5943 (conflict) B2\nHint: To resolve the conflicts, start by creating a commit on top of\nthe first conflicted commit:\n  jj new puqltutt\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you can inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n\n$ jj log\n@  qzvqqupx martinvonz@google.com 2023-02-12 15:08:33 1978b534 (conflict)\n\u2502  C\n\u00d7  puqltutt martinvonz@google.com 2023-02-12 15:08:33 f7fb5943 (conflict)\n\u2502  B2\n\u2502 \u25cb  ovknlmro martinvonz@google.com 2023-02-12 15:07:24 7d7c6e6b\n\u251c\u2500\u256f  B1\n\u25cb  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05 5dda2f09\n\u2502  A\n\u2502 \u25cb  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>There are several things worth noting here. First, the <code>jj rebase</code> command said \"Rebased 2 commits\". That's because we asked it to rebase commit B2 with the <code>-s</code> option, which also rebases descendants (commit C in this case). Second, because B2 modified the same file (and word) as B1, rebasing it resulted in conflicts, as the output indicates. Third, the conflicts did not prevent the rebase from completing successfully, nor did it prevent C from getting rebased on top.</p> <p>Now let's resolve the conflict in B2. We'll do that by creating a new commit on top of B2. Once we've resolved the conflict, we'll squash the conflict resolution into the conflicted B2. That might look like this:</p> <pre><code>$ jj new puqltutt  # Replace the ID by what you have for B2\nWorking copy  (@) now at: zxoosnnp c7068d1c (conflict) (empty) (no description set)\nParent commit (@-)      : puqltutt f7fb5943 (conflict) B2\nAdded 0 files, modified 0 files, removed 1 files\nWarning: There are unresolved conflicts at these paths:\nfile1    2-sided conflict\n\n$ jj st\nThe working copy has no changes.\nWorking copy  (@) : zxoosnnp c7068d1c (conflict) (empty) (no description set)\nParent commit (@-): puqltutt f7fb5943 (conflict) B2\nWarning: There are unresolved conflicts at these paths:\nfile1    2-sided conflict\nHint: To resolve the conflicts, start by creating a commit on top of\nthe conflicted commit:\n  jj new puqltutt\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you can inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n\n$ cat file1\n&lt;&lt;&lt;&lt;&lt;&lt;&lt; conflict 1 of 1\n%%%%%%% diff from: ovknlmro 7d7c6e6b \"B1\" (parents of rebased revision)\n\\\\\\\\\\\\\\        to: nuvyytnq 5dda2f09 \"A\" (rebase destination)\n-b1\n+a\n+++++++ puqltutt daa6ffd5 \"B2\" (rebased revision)\nb2\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; conflict 1 of 1 ends\n\n$ echo resolved &gt; file1\n\n$ jj st\nWorking copy changes:\nM file1\nWorking copy  (@) : zxoosnnp c2a31a06 (no description set)\nParent commit (@-): puqltutt f7fb5943 (conflict) B2\nHint: Conflict in parent commit has been resolved in working copy\n\n$ jj squash\nRebased 1 descendant commits\nWorking copy  (@) now at: ntxxqymr e3c279cc (empty) (no description set)\nParent commit (@-)      : puqltutt 2c7a658e B2\nExisting conflicts were resolved or abandoned from 2 commits.\n\n$ jj log\n@  ntxxqymr martinvonz@google.com 2023-02-12 19:34:09 e3c279cc\n\u2502  (empty) (no description set)\n\u2502 \u25cb  qzvqqupx martinvonz@google.com 2023-02-12 19:34:09 b9da9d28\n\u251c\u2500\u256f  C\n\u25cb  puqltutt martinvonz@google.com 2023-02-12 19:34:09 2c7a658e\n\u2502  B2\n\u2502 \u25cb  ovknlmro martinvonz@google.com 2023-02-12 15:07:24 7d7c6e6b\n\u251c\u2500\u256f  B1\n\u25cb  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05 5dda2f09\n\u2502  A\n\u2502 \u25cb  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>Note that commit C automatically got rebased on top of the resolved B2, and that C is also resolved (since it modified only a different file).</p> <p>By the way, if we want to get rid of B1 now, we can run <code>jj abandon ovknlmro</code>. That will hide the commit from the log output and will rebase any descendants to its parent.</p>"},{"location":"tutorial.html#the-operation-log","title":"The operation log","text":"<p>Jujutsu keeps a record of all changes you've made to the repo in what's called the \"operation log\". Use the <code>jj op</code> (short for <code>jj operation</code>) family of commands to interact with it. To list the operations, use <code>jj op log</code>:</p> <pre><code>$ jj op log\n@  d3b77addea49 martinvonz@vonz.svl.corp.google.com 3 minutes ago, lasted 3 milliseconds\n\u2502  squash commits into f7fb5943a6b9460eb106dba2fac5cac1625c6f7a\n\u2502  args: jj squash\n\u25cb  6fc1873c1180 martinvonz@vonz.svl.corp.google.com 3 minutes ago, lasted 1 milliseconds\n\u2502  snapshot working copy\n\u2502  args: jj st\n\u25cb  ed91f7bcc1fb martinvonz@vonz.svl.corp.google.com 6 minutes ago, lasted 1 milliseconds\n\u2502  new empty commit\n\u2502  args: jj new puqltutt\n\u25cb  367400773f87 martinvonz@vonz.svl.corp.google.com 12 minutes ago, lasted 3 milliseconds\n\u2502  rebase commit daa6ffd5a09a8a7d09a65796194e69b7ed0a566d and descendants\n\u2502  args: jj rebase -s puqltutt -o nuvyytnq\n[many more lines]\n</code></pre> <p>The most useful command is <code>jj undo</code>, which will undo your last operation.</p> <pre><code>$ jj undo\nReverted operation: d3b77addea49 (2025-05-12 00:27:27) squash commits into f7fb5943a6b9460eb106dba2fac5cac1625c6f7a\nWorking copy  (@) now at: zxoosnnp 63874fe6 (no description set)\nParent commit (@-)      : puqltutt f7fb5943 (conflict) B2\nNew conflicts appeared in 2 commits:\n  qzvqqupx 1978b534 (conflict) C\n  puqltutt f7fb5943 (conflict) B2\nHint: To resolve the conflicts, start by creating a commit on top of\nthe first conflicted commit:\n  jj new puqltutt\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you can inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n\n$ jj log\n@  zxoosnnp martinvonz@google.com 2023-02-12 19:34:09 63874fe6\n\u2502  (no description set)\n\u2502 \u00d7  qzvqqupx martinvonz@google.com 2023-02-12 15:08:33 1978b534 (conflict)\n\u251c\u2500\u256f  C\n\u00d7  puqltutt martinvonz@google.com 2023-02-12 15:08:33 f7fb5943 (conflict)\n\u2502  B2\n\u2502 \u25cb  ovknlmro martinvonz@google.com 2023-02-12 15:07:24 7d7c6e6b\n\u251c\u2500\u256f  B1\n\u25cb  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05 5dda2f09\n\u2502  A\n\u2502 \u25cb  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>As you can perhaps see, that undid the <code>jj squash</code> invocation we used for squashing the conflict resolution into commit B2 earlier. Notice that it also updated the working copy.</p> <p>You can also view the repo the way it looked after some earlier operation. For example, if you want to see <code>jj log</code> output right after the <code>jj rebase</code> operation, try <code>jj log --at-op=367400773f87</code> but use the hash from your own <code>jj op log</code>.</p>"},{"location":"tutorial.html#moving-content-changes-between-commits","title":"Moving content changes between commits","text":"<p>You have already seen how <code>jj squash</code> can combine the changes from two commits into one. There are several other commands for changing the contents of existing commits.</p> <p>We'll need some more complex content to test these commands, so let's create a few more commits:</p> <pre><code>$ jj new master -m abc; printf 'a\\nb\\nc\\n' &gt; file\nWorking copy  (@) now at: ztqrpvnw f94e49cf (empty) abc\nParent commit (@-)      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\nAdded 0 files, modified 0 files, removed 1 files\n\n$ jj new -m ABC; printf 'A\\nB\\nc\\n' &gt; file\nWorking copy  (@) now at: kwtuwqnm 6f30cd1f (empty) ABC\nParent commit (@-)      : ztqrpvnw 51002261 abc\n\n$ jj new -m ABCD; printf 'A\\nB\\nC\\nD\\n' &gt; file\nWorking copy  (@) now at: mrxqplyk a6749154 (empty) ABCD\nParent commit (@-)      : kwtuwqnm 30aecc08 ABC\n\n$ jj log -r master::@\n@  mrxqplyk martinvonz@google.com 2023-02-12 19:38:21 b98c607b\n\u2502  ABCD\n\u25cb  kwtuwqnm martinvonz@google.com 2023-02-12 19:38:12 30aecc08\n\u2502  ABC\n\u25cb  ztqrpvnw martinvonz@google.com 2023-02-12 19:38:03 51002261\n\u2502  abc\n\u25c6  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>We \"forgot\" to capitalize \"c\" in the second commit when we capitalized the other letters. We then fixed that in the third commit when we also added \"D\". It would be cleaner to move the capitalization of \"c\" into the second commit. We can do that by running <code>jj squash</code> with the <code>--interactive</code>/<code>-i</code> option on the third commit. Remember that <code>jj squash</code> moves all the changes from one commit into its parent. <code>jj squash -i</code> moves only part of the changes into its parent. Now try that:</p> <pre><code>$ jj squash -i\nHint: Using default editor ':builtin'; run `jj config set --user ui.diff-editor :builtin` to disable this message.\nRebased 1 descendant commits\nWorking copy  (@) now at: mrxqplyk 52a6c7fd ABCD\nParent commit (@-)      : kwtuwqnm 643061ac ABC\n</code></pre> <p>That will bring up the built-in diff editor<sup>1</sup> with a diff of the changes in the \"ABCD\" commit. Expand the file by clicking on <code>(+)</code> or with right arrow, then select the sections/line to include by clicking or using space. Once complete, press <code>c</code> to confirm changes, or <code>q</code> to exit without saving. You can also use the mouse to click on the menu items to see more options (keyboard navigation is currently limited).</p> <p>If we look at the diff of the second commit, we now see that all three lines got capitalized:</p> <pre><code>$ jj diff -r @- --git\ndiff --git a/file b/file\nindex de980441c3..b1e67221af 100644\n--- a/file\n+++ b/file\n@@ -1,3 +1,3 @@\n-a\n-b\n-c\n+A\n+B\n+C\n</code></pre> <p>The child change (\"ABCD\" in our case) will have the same content state after the <code>jj squash</code> command. That means that you can move any changes you want into the parent change, even if they touch the same word, and it won't cause any conflicts.</p> <p>Let's try one final command for changing the contents of an existing commit. That command is <code>jj diffedit</code>, which lets you edit the changes in a commit without checking it out.</p> <pre><code>$ jj diffedit -r @-\nHint: Using default editor ':builtin'; run `jj config set --user ui.diff-editor :builtin` to disable this message.\nRebased 1 descendant commits\nWorking copy  (@) now at: mrxqplyk 1c72cd50 (conflict) ABCD\nParent commit (@-)      : kwtuwqnm 70985eaa ABC\nAdded 0 files, modified 1 files, removed 0 files\nWarning: There are unresolved conflicts at these paths:\nfile    2-sided conflict\nNew conflicts appeared in 1 commits:\n  mrxqplyk 1c72cd50 (conflict) ABCD\nHint: To resolve the conflicts, start by creating a commit on top of\nthe conflicted commit:\n  jj new mrxqplyk\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you can inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n</code></pre> <p>In the diff editor, use the arrow keys and spacebar to select all lines but the last. Press 'c' to save the changes and close it. You can now inspect the rewritten commit with <code>jj diff -r @-</code> again, and you should see your deletion of the last line. Unlike <code>jj squash -i</code>, which left the content state of the commit unchanged, <code>jj diffedit</code> (typically) results in a different state, which means that descendant commits may have conflicts.</p> <p>Another command for rewriting contents of existing commits is <code>jj split</code>. Now that you've seen how <code>jj squash -i</code> and <code>jj diffedit</code> work, you can hopefully figure out how it works (with the help of the instructions in the diff).</p> <ol> <li> <p>There are many other diff editors you could use. For example, if you have Meld installed and in the PATH, you can use it via <code>jj squash -i --tool meld</code> or a fancier config with <code>jj squash -i --tool meld-3</code>. You can configure the default with the <code>ui.diff-editor</code> option; those docs also explain how to specify a path to an executable if it is not in the PATH.\u00a0\u21a9</p> </li> </ol>"},{"location":"windows.html","title":"Working on Windows","text":"<p>Jujutsu works the same on all platforms, but there are some caveats that Windows users should be aware of.</p>"},{"location":"windows.html#line-endings-conversion","title":"Line endings conversion","text":"<p>Jujutsu currently has a setting, <code>working-copy.eol-conversion</code>, similar to Git's <code>core.autocrlf</code><sup>1</sup>, but does not currently honor <code>.gitattributes</code> and the <code>core.autocrlf</code> git config, so it is recommended to keep the <code>working-copy.eol-conversion</code> setting and the <code>core.autocrlf</code> git config in sync<sup>1</sup>.</p> <p>Note</p> <p>If you created a colocated git workspace, forget to keep these 2 settings in sync, and result in a dirty working copy with only EOL diffs, you can set the <code>working-copy.eol-conversion</code> setting correctly and run <code>jj abandon</code> to fix it.</p> <p>The line endings conversion won't be applied to files detected as a binary files via a heuristics<sup>2</sup> regardless of the settings. This behavior is subject to change when we support the text git attribute.</p> <p>Jujutsu may make incorrect decision on whether a file is a binary file and apply line conversion incorrectly, but currently, Jujutsu doesn't support configuring line endings conversion for particular files. If this issue is hit, one should not enable the line conversion setting.</p> <p>Note</p> <p>If Jujutsu applies line endings conversion on incorrect files, you should not enable the line conversion setting and the git <code>core.autocrlf</code> setting. See below.</p> <p>To disable line conversion, set the <code>core.autocrlf</code> setting to <code>none</code> or just remove the setting.</p> <pre><code>PS&gt; git config core.autocrlf input\n# We use none instead of input to avoid applying EOL conversion.\nPS&gt; jj config set --repo working-copy.eol-conversion none\n# Abandoning the working copy will cause Jujutsu to overwrite all files with\n# CRLF line endings with the line endings they are committed with, probably LF\nPS&gt; jj abandon\n</code></pre> <p>This means that line endings will be checked out exactly as they are committed and committed exactly as authored.</p> <p>This setting ensures Git will check out files with LF line endings without converting them to CRLF. You'll want to make sure any tooling you use, especially IDEs, preserve LF line endings.</p>"},{"location":"windows.html#pagination","title":"Pagination","text":"<p>On Windows, <code>jj</code> will use its integrated pager called <code>streampager</code> by default, unless the config <code>ui.pager</code> is explicitly set. See the pager section of the config docs for more details.</p> <p>If the built-in pager doesn't meet your needs and you have Git installed, you can switch to using Git's pager as follows:</p> <pre><code>PS&gt; jj config set --user ui.pager '[\"C:\\\\Program Files\\\\Git\\\\usr\\\\bin\\\\less.exe\", \"-FRX\"]'\nPS&gt; jj config set --user ui.paginate auto\n</code></pre>"},{"location":"windows.html#typing-in-powershell","title":"Typing <code>@</code> in PowerShell","text":"<p>PowerShell uses <code>@</code> as part the array sub-expression operator, so it often needs to be escaped or quoted in commands:</p> <pre><code>PS&gt; jj log -r `@\nPS&gt; jj log -r '@'\n</code></pre> <p>One solution is to create a revset alias. For example, to make <code>HEAD</code> an alias for <code>@</code>:</p> <pre><code>PS&gt; jj config set --user revset-aliases.HEAD '@'\nPS&gt; jj log -r HEAD\n</code></pre>"},{"location":"windows.html#wsl-sets-the-execute-bit-on-all-files","title":"WSL sets the execute bit on all files","text":"<p>When viewing a Windows drive from WSL (via /mnt/c or a similar path), Windows exposes all files with the execute bit set. Since Jujutsu automatically records changes to the working copy, this sets the execute bit on all files committed in your repository.</p> <p>If you only need to access the repository in WSL, the best solution is to clone the repository in the Linux file system (for example, in <code>~/my-repo</code>).</p> <p>If you need to use the repository in both WSL and Windows, one solution is to create a workspace in the Linux file system:</p> <pre><code>PS&gt; jj workspace add --name wsl ~/my-repo\n</code></pre> <p>Then only use the <code>~/my-repo</code> workspace from Linux.</p>"},{"location":"windows.html#symbolic-link-support","title":"Symbolic link support","text":"<p><code>jj</code> supports symlinks on Windows only when they are enabled by the operating system. This requires Windows 10 version 14972 or higher, as well as Developer Mode. If those conditions are not satisfied, <code>jj</code> will materialize symlinks as ordinary files.</p> <p>For colocated workspaces, Git support must also be enabled using the <code>git config</code> option <code>core.symlinks=true</code>.</p> <ol> <li> <p>This poses the question if we should support reading the <code>core.autocrlf</code>   setting in colocated workspaces. See details at the   issue.\u00a0\u21a9\u21a9</p> </li> <li> <p>To detect if a file is binary, Jujutsu currently checks if there is 0 byte   in the file which is different from the algorithm of   <code>gitoxide</code> or <code>git</code>. Jujutsu   doesn't plan to align the binary detection logic with git.\u00a0\u21a9</p> </li> </ol>"},{"location":"working-copy.html","title":"Working copy","text":""},{"location":"working-copy.html#introduction","title":"Introduction","text":"<p>The working copy is where the current working-copy commit's files are written so you can interact with them. It is also where files are read from in order to create new commits (though there are many other ways of creating new commits).</p> <p>Unlike most other VCSs, Jujutsu will automatically create commits from the working-copy contents when they have changed. Most <code>jj</code> commands you run will commit the working-copy changes if they have changed. The resulting revision will replace the previous working-copy revision.</p> <p>Also unlike most other VCSs, added files are implicitly tracked by default. That means that if you add a new file to the working copy, it will be automatically committed once you run e.g. <code>jj st</code>. Similarly, if you remove a file from the working copy, it will implicitly be untracked.</p> <p>The <code>snapshot.auto-track</code> config option controls which paths get automatically tracked when they're added to the working copy. See the fileset documentation for the syntax. Files with paths matching ignore files are never tracked automatically.</p> <p>If you set <code>snapshot.auto-track</code> to a non-default value, untracked files can be tracked with <code>jj file track</code>.</p> <p>You can use <code>jj file untrack</code> to untrack a file while keeping it in the working copy. However, first ignore them or remove them from the <code>snapshot.auto-track</code> patterns; otherwise they will be immediately tracked again.</p>"},{"location":"working-copy.html#conflicts","title":"Conflicts","text":"<p>When you check out a commit with conflicts, those conflicts need to be represented in the working copy somehow. However, the file system doesn't understand conflicts. Jujutsu's solution is to add conflict markers to conflicted files when it writes them to the working copy. It also keeps track of the (typically 3) different parts involved in the conflict. Whenever it scans the working copy thereafter, it parses the conflict markers and recreates the conflict state from them. You can resolve conflicts by replacing the conflict markers by the resolved text. You don't need to resolve all conflicts at once. You can even resolve part of a conflict by updating the different parts of the conflict marker.</p> <p>To resolve conflicts in a commit, use <code>jj new &lt;commit&gt;</code> to create a working-copy commit on top. You would then have the same conflicts in the working-copy commit. Once you have resolved the conflicts, you can inspect the conflict resolutions with <code>jj diff</code>. Then run <code>jj squash</code> to move the conflict resolutions into the conflicted commit. Alternatively, you can edit the commit with conflicts directly in the working copy by using <code>jj edit &lt;commit&gt;</code>. The main disadvantage of that is that it's harder to inspect the conflict resolutions.</p> <p>With the <code>jj resolve</code> command, you can use an external merge tool to resolve conflicts that have 2 sides and a base. There is not yet a good way of resolving conflicts between directories, files, and symlinks (https://github.com/jj-vcs/jj/issues/19). You can use <code>jj restore</code> to choose one side of the conflict, but there's no way to even see where the involved parts came from.</p>"},{"location":"working-copy.html#ignored-files","title":"Ignored files","text":"<p>You probably don't want build outputs and temporary files to be under version control. You can tell Jujutsu to not automatically track certain files by using <code>.gitignore</code> files (there's no such thing as <code>.jjignore</code> yet). See https://git-scm.com/docs/gitignore for details about the format. <code>.gitignore</code> files are supported in any directory in the working copy, as well as in <code>$XDG_CONFIG_HOME/git/ignore</code> and <code>$GIT_DIR/info/exclude</code>.</p> <p>Ignored files are never tracked automatically (regardless of the value of <code>snapshot.auto-track</code>), but files that were already tracked will remain tracked even if they match ignore patterns. You can untrack such files with the <code>jj file untrack</code> command.</p>"},{"location":"working-copy.html#workspaces","title":"Workspaces","text":"<p>You can have multiple working copies backed by a single repo. Use <code>jj workspace add</code> to create a new working copy. The working copy will have a <code>.jj/</code> directory linked to the main repo. The working copy and the <code>.jj/</code> directory together is called a \"workspace\". Each workspace can have a different commit checked out.</p> <p>Having multiple workspaces can be useful for running long-running tests in a one while you continue developing in another, for example. If needed, <code>jj workspace root --name &lt;workspace&gt;</code> prints the root path of the specified workspace (defaults to the current one).</p> <p>When you're done using a workspace, use <code>jj workspace forget</code> to make the repo forget about it. The files can be deleted from disk separately (either before or after).</p>"},{"location":"working-copy.html#stale-working-copy","title":"Stale working copy","text":"<p>Almost all commands go through three main steps:</p> <ol> <li>Snapshot the working copy (which gets recorded as an operation)</li> <li>Create new commits etc. \"in memory\" and record that as a new operation</li> <li>Update the working copy to match the new operation, i.e. to the commit that    the operation says that <code>@</code> should point to</li> </ol> <p>If step 3 doesn't happen for some reason, the working copy is considered \"stale\". We can detect that because the working copy (<code>.jj/working_copy/</code>) keeps track of which operation it was last updated to. When the working copy is stale, use <code>jj workspace update-stale</code> to update the files in the working copy.</p> <p>A common reason that step 3 doesn't happen for a working copy is that you rewrote the commit from another workspace. When you modify workspace A's working-copy commit from workspace B, workspace A's working copy will become stale.</p> <p>A working copy can also become stale because some error, such as <code>^C</code> prevented step 3 from completing. It's also possible that it was successfully updated in step 3 but the operation has then been lost (e.g. by <code>jj op abandon</code> or \"spontaneously\" by certain storage backends). If the operation has been lost, then <code>jj workspace update-stale</code> will create a recovery commit with the contents of the working copy but parented to the current operation's working-copy commit.</p>"},{"location":"design/copy-tracking.html","title":"Copy Tracking and Tracing Design","text":"<p>Authors: Daniel Ploch, Martin von Zweigbergk</p> <p>Summary: This Document documents an approach to tracking and detecting copy information in jj repos, in a way that is compatible with both Git's detection model and with custom backends that have more complicated tracking of copy information. This design affects the output of diff commands as well as the results of rebasing across remote copies.</p>"},{"location":"design/copy-tracking.html#objective","title":"Objective","text":"<p>Add support for copy information that is sufficient for at least the following use cases:</p> <ul> <li>Diffing: If a file has been copied, show a diff compared to the source version   instead of showing a full addition.</li> <li>Merging: When one side of a merge (or rebase) has renamed a file and the other   side has modified it, propagate the changes to the other side. (There are many   other cases to handle too.)</li> <li>Log: It should be possible to run something like <code>jj log -p &lt;file&gt;</code> and follow   the file backwards when it had been created by copying.</li> <li>Annotate (blame): Similar to the log use case, we should follow the file   backwards when it had been created by copying.</li> </ul> <p>The solution should support recording and retrieving copy info in a way that is performant both for Git, which synthesizes copy info on the fly between arbitrary trees, and for custom backends which may explicitly record and re-serve copy info over arbitrarily large commit ranges.</p> <p>The APIs should be defined in a way that makes it easy for custom backends to ignore copy info entirely until they are ready to implement it.</p>"},{"location":"design/copy-tracking.html#desired-ux","title":"Desired UX","text":"<p>The following sections describe some scenarios and how we would ideally handle them.</p> <p>We have not seen much reason to distinguish copies from renames, so a rename is simply the same thing as a copy plus a deletion. This means that we cannot distinguish \"copy <code>foo</code> to <code>bar</code> and rename <code>foo</code> to <code>baz</code>\" from \"copy <code>foo</code> to <code>baz</code> and rename <code>foo</code> to <code>bar</code>\".</p>"},{"location":"design/copy-tracking.html#restoring-from-a-commit-should-preserve-copies","title":"Restoring from a commit should preserve copies","text":"<p>For example, <code>jj new X--; jj restore --from X</code> should restore any copies made in <code>X-</code> and <code>X</code> into the new working copy. Transitive copies should be \"flattened\". For example, if <code>X-</code> renamed <code>foo</code> to <code>bar</code> and <code>X</code> renamed <code>bar</code> to <code>baz</code>, then the restored commit should rename <code>foo</code> to <code>baz</code>.</p> <p>This also applies to reparenting in general, such as for \"verbatim rebase\".</p>"},{"location":"design/copy-tracking.html#diff-after-restore","title":"Diff after restore","text":"<p><code>jj restore --from X; jj diff --from X</code> should be empty, at least when it comes to file contents. It may indicate that renamed file have different history.</p>"},{"location":"design/copy-tracking.html#lossless-round-trip-of-rebase","title":"Lossless round-trip of rebase","text":"<p>Except for the <code>A+(A-B)=A</code> rule, rebasing is currently never lossy; rebasing a commit and then rebasing it back yields the same content. We should ideally preserve this property when possible.</p> <p>For example:</p> <pre><code>$ jj log\nC rename bar-&gt;baz\n|\nB rename foo-&gt;bar\n|\nA add foo\n\n$ jj rebase -r C -o A\n$ jj rebase -r C -o B # Takes us back to the state above\n</code></pre>"},{"location":"design/copy-tracking.html#reverting-the-parent-commit-should-be-a-no-op","title":"Reverting the parent commit should be a no-op","text":"<p>Patches should be reversible so you can make a change and then revert it, and end up with an empty diff across both commits.</p> <p>For example:</p> <pre><code>$ jj log\nB rename foo-&gt;bar\n|\nA add foo\n\n$ jj revert -r B -o B\n$ jj diff --from B- --to B+ # Should be empty\n</code></pre>"},{"location":"design/copy-tracking.html#parallelizeserialize","title":"Parallelize/serialize","text":"<p>This is a special case of the lossless rebase.</p> <pre><code>$ jj log\nE edit qux\n|\nD rename baz-&gt;qux\n|\nC rename bar-&gt;baz\n|\nB rename foo-&gt;bar\n|\nA add foo\n\n$ jj parallelize B::D\n# There should be no conflict in E and it should look like a\n# regular edit just like before\n$ jj rebase -r C -A B\n$ jj rebase -r D -A C\n# Now we're back to the same graph as before.\n</code></pre>"},{"location":"design/copy-tracking.html#copies-inside-merge-commit","title":"Copies inside merge commit","text":"<p>We should be able to resolve a naming conflict:</p> <pre><code>$ jj log\nD  resolve naming conflict by choosing `foo` as the source\n|\\\nC | rename bar-&gt;baz\n| |\n| B rename foo-&gt;baz\n|/\nA add foo and bar\n\n$ jj file annotate baz # Should not include changes from C\n</code></pre> <p>We should also be able to back out that resolution and get back into the name-conflicted state.</p> <p>We should be able to rename files that exist on only one side:</p> <pre><code>$ jj log\nD  rename foo2-&gt;foo3 and bar2-&gt;bar3\n|\\\nC | rename bar-&gt;bar2\n| |\n| B rename foo-&gt;foo2\n|/\nA add foo and bar\n</code></pre>"},{"location":"design/copy-tracking.html#copies-across-merge-commit","title":"Copies across merge commit","text":"<pre><code>$ jj log\nD delete baz\n|\\\nC | rename foo-&gt;baz\n| |\n| B rename foo-&gt;bar\n|/\nA add foo\n</code></pre> <p><code>jj diff --from C --to D</code> should now show a baz-&gt;bar rename (just like <code>jj diff --from C --to B</code> would). <code>jj diff --from B --to D</code> should show no renames. That's despite there being a rename in C.</p>"},{"location":"design/copy-tracking.html#high-level-design","title":"High-level Design","text":"<p>Jujutsu uses a snapshot-based model similar to Git's. The algebra for our first-class conflicts is also based on snapshots and being able to calculate patches as differences between states. That means that we have to fit copy information into that snapshot-based model too <sup>1</sup>.</p> <p>The proposal is to update tree objects to also contain information about a file's past names. For example, if file <code>foo</code> gets renamed to <code>bar</code> in one commit and then to <code>baz</code> in another commit, we will record that <code>baz</code> previously had names <code>bar</code> and <code>foo</code>.</p> <p>To support merging two files into one, the list of past names is actually a DAG. Merging can happen in a merge commit when two sides copy/rename different source files to the same target file. By having support for it in the model, we can also support merging multiple files into one in a regular non-merge commit.</p> <p>To avoid having to store all past paths in the tree object entry, we will write the copy history as an object and the tree will refer to the object by ID. Each ID refers to a node in the copy history DAG, similar to how commit IDs refer to a node in the commit DAG.</p> <p>Each node in the copy history DAG stores the path. Having the path in the copy graph can be useful for finding copy sources without having to scan the whole tree or having to ask the backend.</p> <p>If we use only the file name as only input to the ID, then we get deterministic tree IDs. On the other hand, if we add a salt to the copy graph node, then we can represent that a file was rewritten from scratch. For example, a <code>foo</code> might have copy ID <code>123</code> in the previous commit and when the file gets rewritten in the current commit, it gets copy ID <code>456</code> even though there was no copy from an existing file involved. That makes logical sense, but I'm not sure how useful it will be.</p> <p>The data structure might look like this:</p> <pre><code>// Current `TreeValue::File` variant:\nFile { id: FileId, executable: bool },\n// New `TreeValue::File` variant:\nFile { id: FileId, executable: bool, copy_id: CopyId },\n\n// A CopyId is a hash of this struct:\nstruct CopyHistory {\n    path: RepoPath,\n    parents: Vec&lt;CopyId&gt;\n}\n</code></pre> <p>Should we support copy tracking for symlinks? Their history is not very useful for annotation purposes, but knowing the history may at least be useful for detecting directory renames (if all files and symlinks in a directory were renamed).</p> <p>We probably should not support tracking copied directories because it seems complicated. I haven't spent much thinking about it, so it's also possible that it's not that complicated.</p>"},{"location":"design/copy-tracking.html#diffing","title":"Diffing","text":"<p>When diffing two trees, we first diff the trees without considering copy info. For any copy IDs that changed in that diff, we walk all of their copy graphs to figure out how they're related and which source file to associate with which destination file.</p> <p>The details of the algorithm is left for the implementation. The following sections provide some examples to hopefully show that it's feasible.</p>"},{"location":"design/copy-tracking.html#example-divergent-copy-and-rename","title":"Example: Divergent copy and rename","text":"<p>Let's look at an example of how this model would look in this scenario:</p> <pre><code>M rename foo-&gt;baz, create bar\n|\n| L copy foo-&gt;bar, create baz\n|/\nK add foo\n</code></pre> <p>Assuming the new files are different in each commit, we get the following trees. Notation:</p> <ul> <li><code>id</code>is the hash of the contents (the <code>FileId</code>)</li> <li>The <code>2:bar-&gt;1:foo</code> means that copy ID 2 (i.e. hash of the <code>CopyHistory</code>   struct) has file <code>bar</code>, which was copied from copy ID <code>1</code>, where it was   called <code>foo</code>.</li> </ul> <pre><code>Commit K:\nname: foo, id: K, copy_id: 1:foo\n\nCommit L:\nname: bar, id: L, copy_id: 2:bar-&gt;1:foo\nname: baz, id: L, copy_id: 3:baz\nname: foo, id: K, copy_id: 1:foo\n\nCommit M:\nname: bar, id: M, copy_id: 4:bar\nname: baz, id: M, copy_id: 5:baz-&gt;1:foo\n</code></pre> <p>This graph also shows the relationship between the copy IDs and which commits they appear in:</p> <pre><code>graph LR\n\n    subgraph L[\"Commit L\"]\n        2[\"2:bar\"]\n        3[\"3:baz\"]\n        subgraph K[\"Commit K\"]\n            1[\"1:foo\"]\n        end\n    end\n\n    subgraph M[\"Commit M\"]\n        4[\"4:bar\"]\n        5[\"5:baz\"]\n    end\n\n    2 --&gt; 1\n    5 --&gt; 1</code></pre> <p>Let's first consider the diff from <code>K</code> to <code>M</code>. Looking at just the trees, that diff finds that copy IDs 1,4,5 were affected. By walking their graphs, we find 1 and 5 are related, while 4 is not. Considering that copy graph (involving IDs 1 and 5), since <code>foo</code> doesn't exist in the destination and <code>baz</code> doesn't exist in the source, we consider it a rename.</p> <p>Let's now consider the diff from <code>L</code> to <code>M</code>. This is the same as the diff of the commit <code>M2</code> we'd get by running <code>jj new L; jj bookmark create M2; jj restore --from M --to M2</code> (which would result in the commit <code>M2</code> having the same tree as <code>M</code>). Diffing from <code>L</code> to <code>M</code> (or <code>M2</code>) finds 1,2,3,4,5 as changed copy IDs. By walking their graphs, we find that 1,2, and 5 are related, while 3 and 4 are not.</p> <p>The <code>bar</code> and <code>baz</code> files have unrelated copy graphs, i.e. the copy graphs for the <code>bar</code> file in commit <code>L</code> and the <code>bar</code> file in commit <code>M</code> are disjoint, and the same is true for the <code>baz</code> file. Therefore, we break up their diffs into two separate diffs for each file.</p> <p>Among the remaining copy IDs, the shortest path in the copy graph is between <code>foo</code> on the source side and <code>baz</code> on the destination side, so we start with. Since <code>foo</code> doesn't exist on the destination side and <code>baz</code> doesn't exist on the source side (with a related copy ID), we consider it a rename.</p> <p>The remaining file is <code>bar</code> on the source side. Its closest relative on the destination side is <code>baz</code>. Since we already used <code>baz</code> as a rename target for <code>foo</code>, we won't consider <code>bar</code> renamed to it. So we consider <code>bar</code> as copied into <code>baz</code>.</p> <p>So we get these diffs:</p> <ul> <li><code>baz</code> is deleted (deleting content <code>L</code>)</li> <li><code>bar</code> is created (with content <code>M</code>)</li> <li><code>foo</code> is renamed to <code>baz</code> (showing diff from <code>K</code> to <code>M</code>)</li> <li><code>bar</code> is merged into <code>baz</code> (showing diff from <code>L</code> to <code>M</code>)</li> </ul>"},{"location":"design/copy-tracking.html#example-divergent-copy-and-rename-best-rename-target","title":"Example: Divergent copy and rename (best rename target)","text":"<pre><code>N copy baz-&gt;qux\n|\nM rename foo-&gt;baz\n|\n| L rename foo-&gt;bar\n|/\nK add foo\n</code></pre> <p>When diffing <code>L</code> to <code>N</code>, we find that all files are related. Since <code>bar</code> does not exist in the destination, we should find a rename target to match it with. We pick <code>baz</code> because it's closer in the graph than <code>qux</code> is. So the diff is:</p> <ul> <li><code>bar</code> is renamed to <code>baz</code></li> <li><code>bar</code> is copied to <code>qux</code></li> </ul>"},{"location":"design/copy-tracking.html#example-copy-onto-deleted-file","title":"Example: Copy onto deleted file","text":"<pre><code>M copy foo-&gt;bar\n|\nL delete bar\n|\nK add foo, bar\n</code></pre> <p>When diffing from <code>K</code> to <code>M</code>, we notice that <code>bar</code> has different and unrelated copy IDs. We present one record saying that <code>bar</code> was deleted, and one record saying that <code>bar</code> was copied from <code>foo</code>.</p> <p>When diffing from <code>M</code> to <code>K</code>, we will instead present one record that says that <code>bar</code> was created, and one record that says that <code>bar</code> was merged into <code>foo</code>.</p>"},{"location":"design/copy-tracking.html#merging","title":"Merging","text":"<p>When merging, we need to add a phase before the content-level merging where we handle copies. As before, we start by creating the completely unresolved merged tree based on the input trees. To find the relevant copy information, we look at the files changed in each diff and then look up the full copy graph for each. For each copy graph, we can then walk the copy graph to find possible target paths, which we then look up in the other side of the merge. If the path exists in the tree and has the right copy ID, then we know that the files are related.</p> <p>We assume that the differences between the bases and the first term in the conflict can be very large, so we don't look at that diff. Assuming that the commit backend can look up the full copy graph based on a given copy ID, we don't need that diff for correctness.</p> <p>Once we have found all copies involved in the merge, we analyze them to find conflicts, such as when two sides of the merge rename a file to the same target. If there are conflicts, we leave the trees unchanged. The user can then resolve the name conflicts using <code>jj resolve</code> (once we've added support for that). Depending on how slow the naming conflict phase turns out to be, we may want to write a flag to commits indicating that they have unresolved naming conflicts, so subsequent calls can avoid that phase.</p> <p>When merging trees, we start by rewriting each diff to match any different names in the destination tree. For example, if the tree conflict is <code>A+(B-C)+(D-E)</code>, then we will rewrite the <code>(B-C)</code> diff and the <code>(D-E)</code> diff to the paths in <code>A</code>. To translate the <code>(B-C)</code> diff, we calculate renames from <code>C</code> to <code>A</code> and then we apply those renames to both <code>C</code> and <code>B</code>. This may result in conflicts.</p> <p>If a file has a conflict in the copy ID, it will appear as if it doesn't exist when materialized. It will therefore not show up in the working copy until the user has resolved the conflict.</p> <p>For example:</p> <pre><code>M set foo=\"bye\"\n|\n| L rename foo-&gt;bar\n|/\nK add foo=\"hello\"\n</code></pre> <p>When rebasing <code>M</code> onto <code>L</code>, we apply the <code>foo-&gt;bar</code> rename to the trees in <code>M</code> and its parent.</p> <p>Another example:</p> <pre><code>N rename foo-&gt;bar\n|\n| M create foo=\"M\"\n| |\n| L delete foo\n|/\nK add foo=\"K\"\n</code></pre> <p>When rebasing <code>M</code> onto <code>N</code>, we find the <code>foo-&gt;bar</code> rename in <code>N</code>, but since it is unrelated to the <code>foo</code> file in <code>M</code> (assuming the <code>foo</code> file created in <code>M</code> used a different salt), we will not perform any renames. The new <code>foo</code> file is then simply created in the rebased <code>M</code> just like it was before the rebase.</p>"},{"location":"design/copy-tracking.html#propagating-changes-across-copies","title":"Propagating changes across copies?","text":"<p>Should we propagate changes to copies? For example, if you've modified file <code>foo</code> and then rebase it onto a commit that copied <code>foo</code> to <code>bar</code>, should we apply your change to <code>bar</code> too? Mercurial does that but Git doesn't. It's particularly useful when a file has been split in two. For example, let's say you've made various changes in file <code>foo</code> and then rebase those change onto a commit that split <code>foo</code> into <code>foo1</code> and <code>foo2</code> (or <code>foo</code> and <code>bar</code>). If we propagate the changes to both files, each change will apply successfully in one file (assuming the changes do not overlap with the split boundary). Each change will have a modify/delete conflicts in the other file. Those can relatively easily be resolved in favor of the deleted hunk. If we do not propagate changes, then changes that belong in one of the files will instead only appear as modify/delete conflicts in the first file and you will have to manually copy over the changes to the copied file.</p> <p>Propagating changes to copies means that rebasing a commit and then rebasing it back is no longer a no-op even when ignoring the \"same-change rule\". For example, if your commit modifies file <code>foo</code> and you rebase that commit onto a commit that copied <code>foo</code> to <code>bar</code>, and then you rebase it back, the same change will be applied twice to <code>foo</code>. However, thanks to the same-change rule, we won't consider it a conflict, so maybe it actually works well in practice.</p> <p>A third option is to not leave it up to the user whether to propagate the change across the copy. We can do this by leaving the relevant paths in the input trees unchanged in the conflicted commit. Then we will redo the copy tracking process every time the commit is inspected. We can have <code>jj resolve</code> ask the user if they want to propagate the changes to the copy target with a simple yes/no question per copy target.</p> <p>Decision: Asking the user about propagating copies seems like the best option. It avoids surprises, and it makes the conflict algebra work in more cases.</p>"},{"location":"design/copy-tracking.html#example-propagate-changes-to-copied-file-then-rebase-back","title":"Example: Propagate changes to copied file, then rebase back","text":"<pre><code>M foo=\"M\"\n|\n| L copy foo-&gt;bar\n|/\nK add foo=\"K\"\n</code></pre> <p>Let's say we rebase <code>M</code> onto <code>L</code>. Since we decided to not automatically propagate changes to copies, we will leave the <code>M+(L-K)</code> tree unresolved (i.e. without making any changes to the three trees). If the user does not resolve the conflict, and instead rebases <code>L</code> back onto <code>K</code>, the conflict will be resolved automatically per the usual conflict simplification.</p>"},{"location":"design/copy-tracking.html#example-multiple-copies","title":"Example: Multiple copies","text":"<pre><code>N foo=\"N\"\n|\n| M foo=\"M, foo2=\"M2\", foo3=\"M3\"\n| |\n| L copy foo-&gt;foo2, copy foo-&gt;foo3\n|/\nK add foo=\"K\"\n</code></pre> <p>Let's say we rebase <code>M</code> onto <code>N</code>. The changes to <code>foo</code>, <code>foo2</code>, and<code>foo3</code> will then all apply to <code>foo</code>, which means we get a 4-sided conflict.</p>"},{"location":"design/copy-tracking.html#example-convergent-renames","title":"Example: Convergent renames","text":"<p>Consider this \"convergent copy/rename\" scenario:</p> <pre><code>$ jj log\nC rename bar-&gt;baz\n|\n| B rename foo-&gt;baz\n|/\nA add foo, add bar\n\n$ jj new B C\n</code></pre> <p>It seems clear that <code>baz</code>'s copy graph should inherit from both <code>foo</code> and <code>bar</code>, producing a merge in copy graph. The trees would look like this:</p> <pre><code>Commit A:\nname: foo, id: aaa111, copy_id: 1:foo\nname: bar, id: aaa111, copy_id: 2:bar\n\nCommit B:\nname: bar, id: aaa111, copy_id: 2:bar\nname: baz, id: aaa111, copy_id: 3:baz-&gt;1:foo\n\nCommit C:\nname: foo, id: aaa111, copy_id: 1:foo\nname: baz, id: aaa111, copy_id: 4:baz-&gt;2:bar\n\nMerge commit:\nname: baz, id: aaa111, copy_id: 5:baz-&gt;{3:baz-&gt;1:foo,4:baz-&gt;2:bar}\n</code></pre> <p>We used the same content for both <code>foo</code> and <code>bar</code> above to simplify. If they had been different, we would have had a conflict in the contents but the copy ID would still have been clear.</p>"},{"location":"design/copy-tracking.html#example-rebasing","title":"Example: Rebasing","text":"<pre><code>$ jj log\nC rename bar-&gt;baz\n|\nB rename foo-&gt;bar\n|\nA add foo\n\n$ jj rebase -r C -o A\n</code></pre> <pre><code>$ jj log\nC rename foo-&gt;baz\n|\n| B rename foo-&gt;bar\n|/\nA add foo\n\n$ jj rebase -r C -o B\n</code></pre>"},{"location":"design/copy-tracking.html#example-rename-added-file","title":"Example: Rename added file","text":"<p>A well-known and thorny problem in Mercurial occurs in the following scenario:</p> <pre><code>$ jj log\nC rename foo-&gt;bar\n|\n| B modify foo\n|/\nA add foo\n\n$ jj squash --from C --into A\n</code></pre> <p>The problem here for Mercurial is that after squashing C into A, the new A has file <code>bar</code> but no record that it used to be called <code>foo</code>. The design proposed above handles this case because we keep the copy ID of <code>bar</code> after squashing, so we can detect that the modifications to <code>foo</code> in commit B should be propagated to <code>bar</code>.</p>"},{"location":"design/copy-tracking.html#example-divergent-renames","title":"Example: Divergent renames","text":"<p>Consider this \"divergent rename\" scenario:</p> <pre><code>$ jj log\nC rename foo-&gt;baz\n|\n| B rename foo-&gt;bar\n|/\nA add foo\n\n$ jj new B C\n</code></pre> <p>In this scenario, the regular 3-way merge of the trees without considering copy info results in a tree without conflicts. However, the user might reasonably expect to have to choose between the <code>bar</code> and <code>baz</code> names. Here's what Git says in this scenario:</p> <pre><code>$ git merge main\nCONFLICT (rename/rename): foo renamed to baz in HEAD and to bar in main.\nAutomatic merge failed; fix conflicts and then commit the result.\n\n$ git st\nHEAD detached from ab0b8e3\nYou have unmerged paths.\n  (fix conflicts and run \"git commit\")\n  (use \"git merge --abort\" to abort the merge)\n\nUnmerged paths:\n  (use \"git add/rm &lt;file&gt;...\" as appropriate to mark resolution)\n        added by them:   bar\n        added by us:     baz\n        both deleted:    foo\n</code></pre> <p>Interestingly, Git seems to represent this state by using index states that would not normally end up in the index as a result of conflicts.</p> <p>Here's what Mercurial says:</p> <pre><code>$ hg merge main\nnote: possible conflict - foo was renamed multiple times to:\n bar\n baz\n1 files updated, 0 files merged, 0 files removed, 0 files unresolved\n(branch merge, don't forget to commit)\n</code></pre> <p>Mercurial doesn't have a place to record this state, so it just prints that note and leaves it at that.</p> <p>The model and algorithm described in this document would result in a conflict in the copy ID at both paths after propagating the renames.</p>"},{"location":"design/copy-tracking.html#example-jonathantanmys-test-case","title":"Example: @jonathantanmy's test case:","text":"<p>TODO: fill this out</p> <pre><code>$ jj log\nE baz=\"baz\" (resolves conflict)\n|\nD &lt;conflict&gt;\n|\\\nC | rename bar-&gt;baz\n| |\n| B rename foo-&gt;baz\n|/\nA add foo=\"foo\" and bar=\"bar\"\n\n$ jj rebase -r E -o C\n$ jj new D E -m F\n</code></pre> <p>If F is empty (auto-merged), it should have the same state as E before.</p>"},{"location":"design/copy-tracking.html#log","title":"Log","text":"<p>The copy graph contains all past paths and copy IDs of a file, so when doing <code>jj log &lt;filename&gt;</code>, we might want to translate that to a revset that's similar to <code>files()</code> but matches specific (path, copy ID) pairs instead of specific paths.</p>"},{"location":"design/copy-tracking.html#annotate","title":"Annotate","text":"<p>TBD</p>"},{"location":"design/copy-tracking.html#representation-in-git","title":"Representation in Git","text":"<p>Do we ever want to record renames in the Git backend? If we do, we would presumably store it outside the Git object, similar to how we store the change id for commits.</p> <p>What do we use for trees where we don't have any copy graph recorded? If we simply create a new copy graph based on the current path, then the caller will never find any copies. Do we need an indexing pass to detect all renames in a repo when running <code>jj git init</code>? That can be very expensive for large repos. For reference, <code>git log --summary --find-copies-harder</code> takes about 165 seconds in the git.git repo on my computer, and about 13 hours in the Nixpkgs repo.</p> <p>An alternative is to do copy indexing in the background after cloning a repo. That would mean that copy information would not show up until some time later. It would also be more work to implement it this way.</p> <p>How to deal with two trees having the same content but different file ids? Actually store the additional data linked from the commit object? That would not work if we point to trees from somewhere that's not a commit. We point to a tree from the working-copy state.</p> <p>One could imagine not storing any copy info in Git and instead making the model described above an implementation detail of the backend. Then it could be used by the native backend and the Google backend, while we still use on-the-fly copy detection in the Git backend. However, if we want to be able to tell the user about details of conflicting copy IDs so they can decide how to resolve such conflicts, then we would have to somehow represent that abstractly too.</p>"},{"location":"design/copy-tracking.html#representation-in-cloud-repo-eg-google","title":"Representation in cloud repo (e.g. Google)","text":"<p>Let's say you have a commit with some files you've modified. You now want to sync (rebase) that to an updated main branch. If some of the files you modified no longer exist on the main branch, we want to figure out if they were renamed so we should propagate your changes to the new file location. As described earlier, we can do that by finding files that have a different copy ID since the last time you synced with the main branch. However, if there are 10 million new commits on the main branch, there's perhaps tens of thousands of such files spread across the entire tree. That can therefore can be very expensive to calculate. We therefore need to be able to get help from a custom backend implementation with this query.</p> <p>Since we are only interested in copy graphs that involve files modified in the rebased commit, it should be sufficient if the backend provides a method to fetch the whole copy graph for a given copy ID (or list of copy IDs). We would then first find all copy IDs involved in the diff of the rebased commit. Then we query the backend to get the full copy graphs. We then need to walk the copy graphs to see if a node exists in the destination tree.</p> <p>A weakness of this solution is that the search gets expensive if there are very many related files. That's probably not much of a problem in practice. The server might want to populate the index only for public/immutable commits. Otherwise, a user could poison the index by creating tons of copies (intentionally or by mistake), which would make all future queries about those files expensive.</p>"},{"location":"design/copy-tracking.html#implementation-plan","title":"Implementation plan","text":"<p>A rough implementation plan may look like this:</p> <ol> <li>Implement support for copy-tracking in the test backend</li> <li>Implement diff algorithm and test it</li> <li>Implement merge algorithm and test it</li> <li>Implement blame algorithm and test it</li> <li>Implement file-following log algorithm and test it</li> <li>Extract some queries to the commit backend trait so cloud-based backends    (like the Google backend) can provide versions implemented using database    indexes</li> <li>Implement support for copy-tracking in the Git backend. This may involve    backfilling, possibly lazily. Or it may involve new abstractions in the    commit backend trait.</li> <li>Implement CLI for recording copies and for resolving conflicts in copies</li> </ol>"},{"location":"design/copy-tracking.html#alternatives-considered","title":"Alternatives considered","text":""},{"location":"design/copy-tracking.html#detect-copies-like-git","title":"Detect copies (like Git)","text":"<p>Git doesn't record copy info. Instead, it infers it when comparing two trees.</p> <p>It's hard to make this model scale to very large repos. For example, let's say you're rebasing your local commit to a new upstream commit that's 1 million commits ahead. We would then want to find if any of the files in your local commit has been copied upstream. That's very expensive to do by comparing the old and the new base trees. However, since the query APIs defined above take commits (not trees) as input, we allow the backend to take the history into account when calculating the copies. A backend can then create an index based on the input files (in your local commit) and find if it's been copied without comparing the full trees.</p>"},{"location":"design/copy-tracking.html#record-logical-file-identifiers-in-trees-bitkeeper-like-model","title":"Record logical file identifiers in trees (BitKeeper-like model)","text":"<p>BitKeeper records a file ID (which identifies a logical file, unlike our <code>FileId</code> type) for each path (or maybe it's a path for each file ID). That way you can compare two arbitrary trees, find the added and deleted files and just compare the file IDs to figure out which of them are renames.</p> <p>This model doesn't seem to be easily extensible to support copies (it only supports renames).</p> <p>To perform a rebase across millions of commits, we would not want to diff the full trees because that would be too expensive (probably millions of modified files). We could perhaps instead find renames by bisecting to find commits that deleted any of the files modified in the commit we're rebasing.</p> <p>Another problem is how to synthesize the file IDs in the Git backend. That could perhaps be done by walking from the root commits and persisting an index.</p>"},{"location":"design/copy-tracking.html#include-copy-info-in-the-fileid-mercurial-like-model","title":"Include copy info in the FileId (Mercurial-like model)","text":"<p>Mercurial stores copy info in a metadata section in the file content itself <sup>2</sup>. That means that a file will get a new file (content) ID if its copy history changes. That's quite similar to the proposal in this document. One difference is that Mercurial's model stores information only about the most recent copy. If the file is then modified, it will get a new file ID. One therefore has to walk the history of the file to find the previous name (which is usually not much of a problem because Mercurial stores a revision DAG per file in addition to the revision DAG at the commit level).</p>"},{"location":"design/copy-tracking.html#hybrid-snapshotpatch-model-with-copy-info-stored-in-commits","title":"Hybrid snapshot/patch model with copy info stored in commits","text":"<p>We considered storing copy info about the copies/renames in the commit object. That has some significant impact on the data model:</p> <ul> <li>Without copy info, if there's a linear chain of commits A..D, you can find   the total diff by diffing just D-A. That works because (B-A)+(C-B)+(D-C)   simplifies to just D-A. However, if there is copy info, the total diff will   involve copy info. If that's associated with the individual commits, we will   need to aggregate it somehow.</li> <li>Restoring from another tree is no longer just a matter of copying that tree;   we also need to figure out copies between the old tree and the new tree.</li> <li>Conflict states are represented by a series of states to add and remove. This   does not work with the patch-based copy info. We spent a lot of time trying   to figure out a solution that works, but it seems like the snapshot-based   conflict model and the patch-based copy info model are not reconcilable.   Therefore, we won't track conflicted copy info, such as between a <code>foo</code>-&gt;<code>baz</code>   rename and a <code>bar</code>-&gt;<code>baz</code> rename.</li> <li>Since copy records are relative to the auto-merged parents, that unfortunately   means that the records will depend on the merge algorithm, so it's possible   that a future change to the merge algorithm will make some copy records   invalid. We will therefore need to not assume that the copy source exists.</li> </ul> <p>For the state in conflicted commits, we considered using a representation like this:</p> <pre><code>struct MergedTree {\n    snapshot: Tree,\n    diffs: Diff\n}\n\nstruct Diff {\n    before: Tree,\n    after: Tree,\n    /// Copies from `before` to `after`\n    copies: Vec&lt;CopyInfo&gt;,\n    /// Copies from `before` to `snapshot`\n    copies_to_snapshot: Vec&lt;CopyInfo&gt;,\n}\n\nstruct CopyInfo {\n    source: RepoPathBuf,\n    target: RepoPathBuf,\n    // Maybe more fields here for e.g. \"do not propagate\"\n}\n</code></pre> <p>That works for calculating the resulting tree, but it does not seem to allow for doing the conflict algebra we currently do. That means that things like parallelizing commits and then serializing them again would lose copy information.</p> <ol> <li> <p>This took me (@martinvonz) months to really understand.\u00a0\u21a9</p> </li> <li> <p>From around https://repo.mercurial-scm.org/hg/rev/49ad315b39ee, Mercurial also supports storing copy info in commits. That made it the kind of snapshot/patch model we described above as not working well.\u00a0\u21a9</p> </li> </ol>"},{"location":"design/git-submodule-storage.html","title":"Git submodule storage","text":""},{"location":"design/git-submodule-storage.html#objective","title":"Objective","text":"<p>Decide what approach(es) to Git submodule storage we should pursue. The decision will be recorded in ./git-submodules.md.</p>"},{"location":"design/git-submodule-storage.html#use-cases-to-consider","title":"Use cases to consider","text":"<p>The submodule storage format should support the workflows specified in the submodules roadmap. It should be obvious how \"Phase 1\" requirements will be supported, and we should have an idea of how \"Phases 2,3,X\" might be supported.</p> <p>Notable use cases and workflows are noted below.</p>"},{"location":"design/git-submodule-storage.html#fetching-submodule-commits","title":"Fetching submodule commits","text":"<p>Git's protocol is designed for communicating between copies of the same repository. Notably, a Git fetch calculates the list of required objects by performing reachability checks between the refs on the local and the remote side. We should expect that this will only work well if the submodule repository is stored as a local Git repository.</p> <p>Rolling our own Git fetch is too complex to be worth the effort.</p>"},{"location":"design/git-submodule-storage.html#jj-op-restore-and-operation-log-format","title":"\"jj op restore\" and operation log format","text":"<p>We want <code>jj op restore</code> to restore to an \"expected\" state in the submodule. There is a potential distinction between running <code>jj op restore</code> in the superproject vs in the submodule, and the expected behavior may be different in each case, e.g. in the superproject, it might be enough to restore the submodule working copy, but in the submodule, refs also need to be restored.</p> <p>Currently, the operation log only references objects and refs in the superproject, so it is likely that proposed approaches will need to extend this format. It is also worth considering that submodules may be added, updated or removed in superproject commits, thus the list of submodules is likely to change over the repository's lifetime.</p>"},{"location":"design/git-submodule-storage.html#nested-submodules","title":"Nested submodules","text":"<p>Git submodules may contain submodules themselves, so our chosen storage schemes should support that.</p> <p>We should consider limiting the recursion depth to avoid nasty edge cases (e.g. cyclical submodules.) that might surprise users.</p>"},{"location":"design/git-submodule-storage.html#supporting-future-extensions","title":"Supporting future extensions","text":"<p>There are certain extensions we may want to make in the future, but we don't have a timeline for them today. Proposed approaches should take these extensions into account (e.g. the approach should be theoretically extensible), but a full proposal for implementing them is not necessary.</p> <p>These extensions are:</p> <ul> <li>Non-git subrepos</li> <li>Colocated Git workspace</li> <li>The superproject using a non-git backend</li> </ul>"},{"location":"design/git-submodule-storage.html#proposed-design","title":"Proposed design","text":"<p>Git submodules will be stored as full jj repos. In the code, jj commands will only interact with the submodule's repo as an entire unit, e.g. it cannot query the submodule's commit backend directly. A well-abstracted submodule will extend well to non-git backends and non-git subrepos.</p> <p>The main challenge with this approach is that the submodule repo can be in a state that is internally valid (when considering only the submodule's repo), but invalid when considering the superproject-submodule system. This will be managed by requiring all submodule interactions go through the superproject so that superproject-submodule coordination can occur. For example, jj will not allow the user to work on the submodule's repo without going through the superproject (unlike Git).</p> <p>The notable workflows could be addressed like so:</p>"},{"location":"design/git-submodule-storage.html#fetching-submodule-commits_1","title":"Fetching submodule commits","text":"<p>The submodule would fetch using the equivalent of <code>jj git fetch</code>. It remains to be decided how a \"recursive\" fetch should work, especially if a newly fetched superproject commit references an unfetched submodule commit. A reasonable approximation would be to fetch all branches in the submodule, and then, if the submodule commit is still missing, gracefully handle it.</p>"},{"location":"design/git-submodule-storage.html#jj-op-restore-and-operation-log-format_1","title":"\"jj op restore\" and operation log format","text":"<p>As full repos, each submodule will have its own operation log. We will continue to use the existing operation log format, where each operation log tracks their own repo's commits. As commands are run in the superproject, corresponding commands will be run in the submodule as necessary, e.g. checking out a superproject commit will cause a submodule commit to also be checked out.</p> <p>Since there is no association between a superproject operation and a submodule operation, <code>jj op restore</code> in the superproject will not restore the submodule to a previous operation. Instead, the appropriate submodule operation(s) will be created. This is sufficient to preserve the superproject-submodule relationship; it precludes \"recursive\" restore (e.g. restoring branches in the superproject and submodules) but it seems unlikely that we will need such a thing.</p>"},{"location":"design/git-submodule-storage.html#nested-submodules_1","title":"Nested submodules","text":"<p>Since submodules are full repos, they can contain submodules themselves. Nesting is unlikely to complicate any of the core features, since the top-level superproject/submodule relationship is almost identical to the submodule/nested submodule relationship.</p>"},{"location":"design/git-submodule-storage.html#extending-to-colocated-git-workspaces","title":"Extending to colocated Git workspaces","text":"<p>Git expects submodules to be in <code>.git/modules</code>, so it will not understand this storage format. To support colocated Git workspaces, we will have to change Git to allow a submodule's gitdir to be in an alternate location (e.g. we could add a new <code>submodule.&lt;name&gt;.gitdir</code> config option). This is a simple change, so it should be feasible.</p>"},{"location":"design/git-submodule-storage.html#alternatives-considered","title":"Alternatives considered","text":""},{"location":"design/git-submodule-storage.html#git-repos-in-the-main-git-backend","title":"Git repos in the main Git backend","text":"<p>Since the Git backend contains a Git repository, an 'obvious' default would be to store them in the Git superproject the same way Git does, i.e. in <code>.git/modules</code>. Since Git submodules are full repositories that can have submodules, this storage scheme naturally extends to nested submodules.</p> <p>Most of the work in storing submodules and querying them would be well-isolated to the Git backend, which gives us a lot of flexibility to make changes without affecting the rest of jj. However, the operation log will need a significant rework since it isn't designed to reference submodules, and handling edge cases (e.g. a submodule being added/removed, nested submodules) will be tricky.</p> <p>This is rejected because handling that operation log complexity isn't worth it when very little of the work extends to non-Git backends.</p>"},{"location":"design/git-submodule-storage.html#store-git-submodules-as-alternate-git-backends","title":"Store Git submodules as alternate Git backends","text":"<p>Teach jj to use multiple commit backends and store Git submodules as Git backends. Since submodules are separate from the 'main' backend, a repository can use whatever backend it wants as its 'main' one, while still having Git submodules in the 'alternate' Git backends.</p> <p>This approach extends fairly well to non-Git submodules (which would be stored in non-Git commit backends). However, this requires significantly reworking the operation log to account for multiple commit backends. It is also not clear how nested submodules will be supported since there isn't an obvious way to represent a nested submodule's relationship to its superproject.</p>"},{"location":"design/git-submodules.html","title":"Git submodules","text":"<p>This is an aspirational document that describes how jj will support Git submodules. Readers are assumed to have some familiarity with Git and Git submodules.</p> <p>This document is a work in progress; submodules are a big feature, and relevant details will be filled in incrementally.</p>"},{"location":"design/git-submodules.html#objective","title":"Objective","text":"<p>This proposal aims to replicate the workflows users are used to with Git submodules, e.g.:</p> <ul> <li>Cloning submodules</li> <li>Making new submodule commits and updating the superproject</li> <li>Fetching and pushing updates to the submodule's remote</li> <li>Viewing submodule history</li> </ul> <p>When it is convenient, this proposal will also aim to make submodules easier to use than Git's implementation.</p>"},{"location":"design/git-submodules.html#non-goals","title":"Non-goals","text":"<ul> <li>Non-Git 'submodules' (e.g. native jj submodules, other VCSes)</li> <li>Non-Git backends (e.g. Google internal backend)</li> <li>Changing how Git submodules are implemented in Git</li> </ul>"},{"location":"design/git-submodules.html#background","title":"Background","text":"<p>We mainly want to support Git submodules for feature parity, since Git submodules are a standard feature in Git and are popular enough that we have received user requests for them. Secondarily (and distantly so), Git submodules are notoriously difficult to use, so there is an opportunity to improve the UX over Git's implementation.</p>"},{"location":"design/git-submodules.html#intro-to-git-submodules","title":"Intro to Git Submodules","text":"<p>Git submodules are a feature of Git that allow a repository (submodule) to be embedded inside another repository (the superproject). Notably, a submodule is a full repository, complete with its own index, object store and ref store. It can be interacted with like any other repository, regardless of the superproject.</p> <p>In a superproject commit, submodule information is captured in two places:</p> <ul> <li> <p>A <code>gitlink</code> entry in the commit's tree, where the value of the <code>gitlink</code> entry   is the submodule commit id. This tells Git what to populate in the working   tree.</p> </li> <li> <p>A top level <code>.gitmodules</code> file. This file is in Git's config syntax and   entries take the form <code>submodule.&lt;submodule-name&gt;.*</code>. These include many   settings about the submodules, but most importantly:</p> <ul> <li> <p><code>submodule&lt;submodule-name&gt;.path</code> contains the path from the root of the tree   to the <code>gitlink</code> being described.</p> </li> <li> <p><code>submodule&lt;submodule-name&gt;.url</code> contains the url to clone the submodule   from.</p> </li> </ul> </li> </ul> <p>In the working tree, Git notices the presence of a submodule by the <code>.git</code> entry (signifying the root of a Git repository working tree). This is either the submodule's actual Git directory (an \"old-form\" submodule), or a <code>.git</code> file pointing to <code>&lt;superproject-git-directory&gt;/modules/&lt;submodule-name&gt;</code>. The latter is sometimes called the \"absorbed form\", and is Git's preferred mode of operation.</p>"},{"location":"design/git-submodules.html#roadmap","title":"Roadmap","text":"<p>Git submodules should be implemented in an order that supports an increasing set of workflows, with the goal of getting feedback early and often. When support is incomplete, jj should not crash, but instead provide fallback behavior and warn the user where needed.</p> <p>The goal is to land good support for pure Jujutsu workspaces, while colocated workspaces will be supported when convenient.</p> <p>This section should be treated as a set of guidelines, not a strict order of work.</p>"},{"location":"design/git-submodules.html#phase-1-readonly-submodules","title":"Phase 1: Readonly submodules","text":"<p>This includes work that inspects submodule contents but does not create new objects in the submodule. This requires a way to store submodules in a jj repository that supports readonly operations.</p>"},{"location":"design/git-submodules.html#outcomes","title":"Outcomes","text":"<ul> <li>Submodules can be cloned anew</li> <li>New submodule commits can be fetched</li> <li>Submodule history and branches can be viewed</li> <li>Submodule contents are populated in the working copy</li> <li>Superproject gitlink can be updated to an existing submodule commit</li> <li>Conflicts in the superproject gitlink can be resolved to an existing submodule   commit</li> </ul>"},{"location":"design/git-submodules.html#phase-2-snapshotting-new-changes","title":"Phase 2: Snapshotting new changes","text":"<p>This allows a user to write new contents to a submodule and its remote.</p>"},{"location":"design/git-submodules.html#outcomes_1","title":"Outcomes","text":"<ul> <li>Changes in the working copy can be recorded in a submodule commit</li> <li>Submodule branches can be modified</li> <li>Submodules and their branches can be pushed to their remote</li> </ul>"},{"location":"design/git-submodules.html#phase-3-mergingrebasingconflicts","title":"Phase 3: Merging/rebasing/conflicts","text":"<p>This allows merging and rebasing of superproject commits in a content-aware way (in contrast to Git, where only the gitlink commit ids are compared), as well as workflows that make resolving conflicts easy and sensible.</p> <p>This can be done in tandem with Phase 2, but will likely require a significant amount of design work on its own.</p>"},{"location":"design/git-submodules.html#outcomes_2","title":"Outcomes","text":"<ul> <li>Merged/rebased submodules result in merged/rebased working copy content</li> <li>Merged/rebased working copy content can be committed, possibly by creating   sensible merged/rebased submodule commits</li> <li>Merge/rebase between submodule and non-submodule gives a sensible result</li> <li>Merge/rebase between submodule A and submodule B gives a sensible result</li> </ul>"},{"location":"design/git-submodules.html#phase-an-ideal-world","title":"Phase ?: An ideal world","text":"<p>I.e. outcomes we would like to see if there were no constraints whatsoever.</p> <ul> <li>Rewriting submodule commits rewrites descendants correctly and updates   superproject gitlinks.</li> <li>Submodule conflicts automatically resolve to the 'correct' submodule commits,   e.g. a merge between superproject commits creating a merge of the submodule   commits.</li> <li>Nested submodules are as easy to work with as non-nested submodules.</li> <li>The operation log captures changes in the submodule.</li> </ul>"},{"location":"design/git-submodules.html#design","title":"Design","text":""},{"location":"design/git-submodules.html#guiding-principles","title":"Guiding principles","text":"<p>TODO</p>"},{"location":"design/git-submodules.html#storing-submodules","title":"Storing submodules","text":"<p>Possible approaches under discussion. See ./git-submodule-storage.md.</p>"},{"location":"design/git-submodules.html#snapshotting-new-submodule-changes","title":"Snapshotting new submodule changes","text":"<p>TODO</p>"},{"location":"design/git-submodules.html#mergingrebasing-with-submodules","title":"Merging/rebasing with submodules","text":"<p>TODO</p>"},{"location":"design/jj-converge-command.html","title":"jj converge (aka resolve-divergence) Command Design","text":"<p>Authors: David Rieber, Martin von Zweigbergk</p> <p>Summary: This document is a proposal for a new <code>jj converge</code> command to help users resolve (or reduce) divergence. The command will use heuristics --and sometimes will prompt the user for input-- to rewrite the N visible commits for a given change with a single new commit, without introducing new divergence in the process. <code>jj resolve-divergence</code> will be an alias for <code>jj converge</code>.</p>"},{"location":"design/jj-converge-command.html#objective","title":"Objective","text":"<p>A divergent change occurs when multiple visible commits have the same change ID. Divergence is not a desirable state, but is not a bad state either. In this regard divergence is similar to conflicts: the user can choose when and how to deal with divergence. The Handling divergent commits guide has some useful tips, but nevertheless divergence is confusing to our users. We can do better than that. It should be possible to solve divergence (after the fact) in many scenarios with the help of this command. Solving divergence means rewriting the commit graph to end up with a single visible commit for the given change id. For the purposes of this design doc we call this commit the \"solution\".</p> <p>The command should produce informative messages to summarize any changes made, and will prompt for user input in some situations. The user may of course not like the solution. <code>jj undo</code> can be used in that case.</p>"},{"location":"design/jj-converge-command.html#divergent-changes","title":"Divergent changes","text":"<p>Divergent commits (for the same change-id) can differ:</p> <ul> <li>In their commit description (including tags)</li> <li>In their commit trees</li> <li>In the parent(s) of the commits (commits B/0 and B/1 for change B have     different parents)</li> <li>In the commit author</li> <li>It is also possible divergence involves two commits with different     timestamps that are otherwise identical</li> </ul> <p>As you read this design doc it is important to not confuse the predecessor/successor relationship versus the ancestor/descendant relationship.</p>"},{"location":"design/jj-converge-command.html#some-divergence-scenarios","title":"Some divergence scenarios","text":"<p>Divergence can be introduced in many ways. This document does not aim to explain any/all of those scenarios accurately, this section is only meant to be rough background material. Here are some examples:</p> <ul> <li> <p>In one terminal you type <code>jj describe</code> to edit a commit description and     while the editor is open you take a coffee break, when you come back you     open another terminal and do something that rewrites the commit (for example     you modify a file and run <code>jj log</code>, causing a snapshot). When you save the     new description <code>jj describe</code> completes and you end up with 2 visible     commits with the same change id.</p> </li> <li> <p>In general any interactive jj command (<code>jj split -i</code>, <code>jj squash -i</code>, etc)     can lead to divergence in a similar way.</p> </li> <li> <p>You can introduce divergence by making some hidden predecessor of your     change visible again. There are many ways this could happen.</p> </li> <li> <p>Divergence can happen when mutating two workspaces. For example, assume you     have workspaces w1 and w2 with working copy commits A and B     respectively, where B is a child of A. In w2 you run <code>jj git fetch</code> and     then rebase the whole branch onto main. Go back to w1 (which is now stale),     modify some file on disk and take a snapshot (e.g. run <code>jj log</code>). This     introduces divergence.</p> </li> <li> <p>When using the Git backend jj propagates change-id. The change-id is stored     in the commit header, so after jj git fetch you can end up with a second     commit with the same change-id.</p> </li> <li> <p>There is a Google-specific jj upload command to upload a commit to Google's     review/test/submit system, and there is an associated Google-specific     command to \"download\" a change from that system back to your jj repo. This     can introduce divergence very much like in the Git scenario.</p> </li> <li> <p>At Google, snapshotting operations happen concurrently on different machines     (e.g. two terminals, or more commonly, a terminal and an IDE). Often times     they end up snapshotting the same content. Google's backend does not hold     locks while snapshotting because it's a distributed filesystem, so locking     would be slow.</p> </li> </ul>"},{"location":"design/jj-converge-command.html#strawman-proposal","title":"Strawman proposal","text":"<p>We look at some examples to illustrate what the command should do, starting with simple cases and moving on to more complex ones.</p>"},{"location":"design/jj-converge-command.html#examples-and-expected-behavior-with-basic-evolution-graph","title":"Examples and expected behavior (with basic evolution graph)","text":"<p>The first few examples assume commits B/0 and B/1 are visible commits for change B. First we assume B/0 and B/1 evolve directly from a common predecessor commit P, which is now hidden (no longer visible). Later we look at more complex evolution graphs. Note that P's change id is also B.</p> <pre><code>Evolution graph for examples 1, 2, 3 and 4.\nB/0 and B/1 may have other predecessors for unrelated change-ids, P may have\npredecessors (even for change-id B):\n\nB/0\n|  B/1\n| /\nP\n</code></pre> <p>We will write <code>A\u207b</code> to denote the parent trees of commit <code>A</code>.</p>"},{"location":"design/jj-converge-command.html#example-1-two-commits-for-change-b-same-parent","title":"Example 1: two commits for change B, same parent","text":"<pre><code>$ jj log\nB/0\n|\n| B/1\n|/\nA\n</code></pre> <p>In this simple case it is clear the solution should be a child of A:</p> <pre><code>$ jj log\n B (solution)\n |\n | B/0 (not visible)\n |/\n | B/1 (not visible)\n | /\n A\n</code></pre> <p>Let's now consider two cases: when P's parent is A, and when P has some other parent. First, if P's parent is A we have:</p> <pre><code>$ jj log\nB/0\n| B/1\n|/\n| P (not visible)\n|/\nA\n</code></pre> <p>Here P, B/0 and B/1 are siblings. The command needs to determine the description, parents, tree and author of the solution. It uses a simple data structure for this purpose:</p> <pre><code>struct MergedState {\n  author: Merge&lt;Signature&gt;,\n  description: Merge&lt;String&gt;,\n  parents: Merge&lt;Vec&lt;CommitId&gt;&gt;,\n  tree: Merge&lt;MergedTree&gt;,\n}\n</code></pre> <p>Each of the fields of <code>MergedState</code> are populated by doing a merge of the corresponding fields of P, B/0 and B/1. Loosely speaking each merge can be expressed as <code>P + (B/0 - P) + (B/1 - P)</code> for each of the fields. The command attempts to resolve the various Merge objects trivially, using <code>same_change: SameChange::Accept</code> (later on in this design doc we will tweak the merge algorithm a bit).</p> <p>The description is merged as a String value. If the description does not trivially resolve, the user's merge tool will be invoked, with conflict markers. If author does not trivially resolve, the user will be presented with the options to choose from. Once that's all done we have our solution commit B. All descendants of B/0 and B/1 are rebased onto B. The command records the operation in the operation log with a new View where B is a visible commit with {B/0, B/1} as predecessors. B/0 and B/1 become hidden commits.</p> <p>Note that in some cases the solution may be identical to either B/0 or B/1 (in all regards except the commit timestamp): we choose to create a new commit B to make the evolution graph and op log more clearly show that jj converge was invoked. Alternatively we could keep the matching commit instead of creating a new commit (this could result in cycles in the evolog).</p>"},{"location":"design/jj-converge-command.html#example-2-two-commits-for-change-b-with-same-parent-predecessor-has-a-different-parent","title":"Example 2: two commits for change B with same parent (predecessor has a different parent)","text":"<p>Now lets consider the case where P has a different parent:</p> <pre><code>$ jj log\nB/0\n|\n| B/1\n|/\nA\n|  P (not visible)\n| /\nX\n</code></pre> <p>In this case we first rebase P onto A (in-memory) to produce <code>P' = A + (P - P\u207b)</code>. This essentially reduces the problem to the previous case. We now produce the solution as before: <code>B = P' + (B/0 - P') + (B/1 - P')</code>. Note that again the parent of the solution is A.</p>"},{"location":"design/jj-converge-command.html#example-3-divergent-commits-with-different-parents","title":"Example 3: divergent commits with different parents","text":"<pre><code>$ jj log\nB/0\n|\n|  B/1\n|  /\n| C\n|/\nA\n</code></pre> <p>In this case it is not immediately obvious which commit should be the parent of the solution. Let's first consider the case where P is a child of A.</p> <pre><code>$ jj log\nB/0\n|\n|  B/1\n|  /\n| C\n|/\n|  P (not visible)\n| /\nA\n</code></pre> <p>We determine the parent(s) of the solution as follows:</p> <pre><code>parents = P\u207b + (B/0\u207b - P\u207b) + (B/1\u207b - P\u207b)\n</code></pre> <p>In this example the expression evaluates to <code>{A} + ({A} - {A}) + ({C} - {A}) = {C}</code>. Since this expression resolves trivially to {C}, we use that as the parents of the solution.</p> <p>Note that this simple algorithm produces the desired output in example 1 and example 2. In example 2, the expression looks like this:</p> <pre><code>parents = P\u207b + (B/0\u207b - P\u207b) + (B/1\u207b - P\u207b)\n        = {X} + ({A} - {X}) + ({A} - {X})\n        = {A} + ({A} - {X})\n</code></pre> <p>That expression resolves trivially to {A} when using SameChange::Accept.</p>"},{"location":"design/jj-converge-command.html#example-4-divergent-commits-with-different-parents-must-prompt-user-to-choose-parents","title":"Example 4: divergent commits with different parents, must prompt user to choose parents","text":"<p>If instead P is a child of some other commit X, the story is a bit different:</p> <pre><code>$ jj log\nB/0\n|\n| B/1\n| |\n| C\n|/\nA\n|  P (not visible)\n| /\nX\n</code></pre> <p>In this case parents will be</p> <pre><code>{X} + ({A} - {X}) + ({C} - {X}) = {A} + ({C} - {X})\n</code></pre> <p>Since this does not trivially resolve, the command prompts the user to select the desired parents for the solution: either {A} or {C}.</p> <p>Assume the user chooses {C}. The command then rebases (in memory) B/0, B/1 and P onto the chosen parents:</p> <pre><code>In-memory commits after rebasing B/0, B/1 and P on top of C (edges represent\nparent/child relationship):\n\n# B/0' = C + (B/0 - A)\n# B/1' = C + (B/1 - C) = B/1\n# P' = C + (P - X)\n\nB/0'\n|\n|  B/1'\n|/\n|  P'\n| /\nC\n</code></pre> <p>As a result we obtain B/0', B/1' and P', and these are sibling commits. At this point the command does a 3-way merge of <code>MergedTree</code> objects to produce <code>MergedState::tree</code> (in reality it is enough to rebase the commit trees).</p>"},{"location":"design/jj-converge-command.html#example-5-more-than-2-divergent-commits","title":"Example 5: more than 2 divergent commits","text":"<p>There can be more than 2 visible commits for a given change-id. We are assuming here B/0, B/1 and B/2 are all direct successors of commit P (which is invisible).</p> <pre><code>$ jj log\nB/0\n|\n| B/1\n| |\n| | B/2\n| |/\n|/\nA\n</code></pre> <p>This is completely analogous to the first example, we simply have more terms on all merges. The same thing applies to all previous examples, in all cases we can deal with any number of divergent commits for change B.</p>"},{"location":"design/jj-converge-command.html#examples-and-expected-behavior-with-arbitrary-evolution-graph","title":"Examples and expected behavior (with arbitrary evolution graph)","text":"<p>So far we only considered simple cases where all divergent commits are direct successors of a common predecessor P. Now we extend the ideas to arbitrary evolution history. To that end we introduce the \"truncated evolution graph for B/0, B/1, ... , B/n\", where B/0, B/1, ... , B/n are two or more commits with the same change-id B. This is a directed graph. Its nodes are commits for change-id B and the edges are from a commit to its (immediate) predecessor(s), ignoring predecessors with unrelated change-ids. The graph is built by traversing the operation log and associated View objects, adding nodes and predecessor edges as needed. Nodes are added this way until a single most-recent common predecessor commit is found. We call the most-recent common predecessor the \"evolution fork point of B/0, ... , B/n\". The traversal keeps track of visited commits to avoid infinite loops <sup>1</sup> <sup>2</sup>.</p>"},{"location":"design/jj-converge-command.html#example-6-a-two-level-evolution-graph","title":"Example 6: a two-level evolution graph","text":"<p>We continue by looking at a truncated evolution graph that is slightly more complex than the basic 3-commit case. This will serve as motivation for the general case. Here is our truncated evolution graph (remember the edges here represent change evolution, not parent-child relations):</p> <pre><code>Truncated evolution graph. B/0, B/1 and Q may have other predecessors for\nunrelated change-ids. P is the evolution fork point (it may have predecessors,\neven for change-id B):\n\nB/0     (description: \"v3\")\n|\n|  B/1  (description: \"v2\")\nQ  /    (description: \"v2\")\n| /\nP       (description: \"v1\")\n</code></pre> <p>Commit P evolved into Q and B/1, and Q evolved into B/0. As before B/0 and B/1 are visible, P and Q are not. Since both sides of the evolution transitioned from \"v1\" to \"v2\", and then one side further transitioned to \"v3\", it seems a good heuristic to take \"v3\" as the description of the solution. Note that this observation would not be possible if the algorithm only considered the leafs (B/0, B/1) and their evolution fork point (P).</p> <p>Note: Why do we care about divergence producing two commits with the exact same change? It may seem this would be a very uncommon scenario, however, as mentioned in the last bullet point in the \"Some divergence scenarios\" section, this is in fact fairly common at Google due to the distributed nature of Google's backend filesystem.</p> <p>To implement the heuristic we outlined above in example 6 (i.e. to produce \"v3\"), we propose introducing a new try_resolve_deduplicating_same_diffs method to <code>Merge&lt;T&gt;</code>, and using that in calls to attempt to resolve the MergedState::description, MergedState::parent, MergedState::author and MergedState::trees. try_resolve_deduplicate_same_diffs is similar to resolve_trivial, but it counts multiple identical (X - Y) terms exactly once, otherwise it follows the same flow as resolve_trivial with SameChange::Accept.</p> <p>We illustrate what try_resolve_deduplicating_same_diffs does when resolving the description merge for the case in example 6. We build a <code>Merge&lt;String&gt;</code>, starting with the description of the evolution fork point P, then adding desc(Y) - desc(X) terms for each X-&gt;Y edge in the truncated evolution graph. Then we call try_resolve_deduplicating_same_diffs to get:</p> <pre><code>P + (Q - P) + (B/1 - P) + (B/0 - Q) =\n       = v1 + (v2 - v1) + (v2 - v1) + (v3 - v2)    &lt;== collapse duplicate\n                                                       (v2 - v1) edge/term\n       = v1 + (v2 - v1) + (v3 - v2)\n       = v3\n</code></pre> <p>try_resolve_deduplicating_same_diffs returns our desired value \"v3\". Note that resolve_trivial (with either SameChange value) would return none. Here is another example:</p> <pre><code>Truncated evolution graph:\n\nB/0     ( foo.txt contents: \"v3\" )\n|\n|  B/1  ( foo.txt contents: \"v2\" )\nQ  /    ( foo.txt contents: \"v1\" )\n| /\nP       ( foo.txt contents: \"v1\" )\n</code></pre> <p>In this case try_resolve_deduplicating_same_diffs produces none. jj converge cannot automatically resolve this merge so the user has to merge the description: the command invokes the user's merge-tool with base \"v1\" and sides \"v2\"/\"v3\".</p>"},{"location":"design/jj-converge-command.html#edge-cases-when-choosing-the-parents-of-the-solution","title":"Edge cases when choosing the parents of the solution","text":"<p>When attempting to produce the solution parents, the command applies try_resolve_deduplicating_same_diffs to MergedState::parents (of type <code>Merge&lt;Vec&lt;CommitId&gt;&gt;</code>). If the result is <code>Some&lt;Vec&lt;CommitId&gt;&gt;</code> we have a set of possible parents for the solution. If these candidate parents are all visible commits with change-ids other than B, and none of those are descendants of B/0, B/1, ... B/n, then we have the desired parents for the solution commit.</p> <p>On the other hand,</p> <ul> <li>if any candidate parent is a descendant of one of the divergent commits we     are trying to solve, or</li> <li>if any of the candidate parents are hidden and the chain starting at visible     roots and leading up to and including the parent has any commit for the     divergent change we are trying to solve (B), or for any other visible     commit (divergent or not), or the chain itself has two or more commits with     the same change-id,</li> </ul> <p>then we would introduce new divergence or cycles in the commit graph if we based on the solution on such candidate parents. In these edge cases the command will simply discard the candidate parents and will instead ask the user to choose which parents to use (or quit quit without making any changes). Care must be taken when picking the options to present to the user for choosing parents: essentially the user will choose between the parents of B/0, the parents of B/1, and so on, but we will skip any B/i if any of the parents of B/i descends from any B/j. Since the commit graph is a DAG, at least one option is viable.</p>"},{"location":"design/jj-converge-command.html#multiple-divergent-change-ids","title":"Multiple divergent change-ids","text":"<p>If there are multiple divergent change-ids, the command could prompt the user to choose one, or apply heuristics to choose one programmatically. In the first version it is OK to prompt the user.</p> <p>If the command successfully resolves divergence in the first divergent change-id, it could continue to process the next divergent change-id, and so on. To avoid complexity the first implementation will only deal with one divergent change per invocation.</p>"},{"location":"design/jj-converge-command.html#rebasing-descendants-and-persisting","title":"Rebasing descendants and persisting","text":"<p>The last step is to rebase all descendants of the divergent commits on top of the new solution commit, persist the changes and record the operation in the op log. The command will move local bookmarks pointing to any of the rewritten divergent commits to point to the solution commit.</p>"},{"location":"design/jj-converge-command.html#other-edge-cases","title":"Other edge cases","text":"<p>When the command starts it needs to find the divergent change-ids and their corresponding visible commits. If the portion of the visible commit graph leading up to immutable heads is too big, the command should error out.</p> <p>There could be pathological cases where the evolution history is too long. When building the truncated evolution graph, if we have traversed too many nodes (say 50) and we have not yet completed the traversal, the algorithm will not traverse any more commits. We could simply error out, or we could use an incomplete truncated evolution graph by adding a virtual evolution fork point. It is probably best to error out.</p>"},{"location":"design/jj-converge-command.html#open-questions","title":"Open questions","text":"<ul> <li>Do we ever have divergence of committer? Is it safe to mess with committer?</li> </ul>"},{"location":"design/jj-converge-command.html#alternatives-considered","title":"Alternatives considered","text":""},{"location":"design/jj-converge-command.html#automatically-resolving-divergence","title":"Automatically resolving divergence","text":"<p>It would be nice if divergence was avoided in the first place, at least in some cases, at the point where jj is about to introduce the second (or third or fourth etc) visible commit for a given change id. This should be investigated separately.</p>"},{"location":"design/jj-converge-command.html#resolve-divergence-two-commits-at-a-time","title":"Resolve divergence two commits at a time","text":"<p>The algorithm in this proposal should work when there are any number of divergent commits (for a given change id). In practice we expect most often there will be just 2 or perhaps a few divergent commits. We could design an algorithm for just 2 commits, but we chose to think about the more general case.</p>"},{"location":"design/jj-converge-command.html#only-considering-the-evolution-fork-point-and-visible-commits","title":"Only considering the evolution fork point and visible commits","text":"<p>As explained in example 6 this proposal uses the truncated evolution graph and try_resolve_deduplicating_same_diffs to produce the solution. That example shows why we think this leads to a better heuristic. We could instead only consider P and B/0, B/1, ... , B/n. That would be slightly simpler.</p> <ol> <li> <p>It is unclear if the evolution history can contain cycles today, but there has been some discussion about <code>jj undo</code> possibly producing cycles. In any case, it is very easy to deal with that possibility, so we may as well handle it?\u00a0\u21a9</p> </li> <li> <p>Today there should always be a single evolution fork point. However, we could handle cases where a change-id \"emanates from multiple initial commits\" by adding a single virtual evolution fork point commit with empty state: empty description, empty tree and empty author, and having the root commit as its parent, and treating it as a predecessor of all initial commits. Again, we probably don't need to worry about this, but it is good to know we could handle it.\u00a0\u21a9</p> </li> </ol>"},{"location":"design/run.html","title":"Introducing JJ run","text":"<p>Authors: Philip Metzger, Martin von Zweigberk, Danny Hooper, Waleed Khan</p> <p>Initial Version, 10.12.2022 (view full history here)</p> <p>Summary: This Document documents the design of a new <code>run</code> command for Jujutsu which will be used to seamlessly integrate with build systems, linters and formatters. This is achieved by running a user-provided command or script across multiple revisions. For more details, read the Use-Cases of jj run.</p>"},{"location":"design/run.html#preface","title":"Preface","text":"<p>The goal of this Design Document is to specify the correct behavior of <code>jj run</code>. The points we decide on here I (Philip Metzger) will try to implement. There exists some prior work in other DVCS:</p> <ul> <li><code>git test</code>: part of git-branchless. Similar to this proposal for <code>jj run</code>.</li> <li><code>hg run</code>: Google's internal Mercurial extension. Similar to this proposal for <code>jj run</code>. Details not available.</li> <li><code>hg fix</code>: Google's open source Mercurial extension: source code. A more specialized approach to rewriting file content without full context of the working directory.</li> <li><code>git rebase -x</code>: runs commands opportunistically as part of rebase.</li> <li><code>git bisect run</code>: run a command to determine which commit introduced a bug.</li> </ul>"},{"location":"design/run.html#context-and-scope","title":"Context and Scope","text":"<p>The initial need for some kind of command runner integrated in the VCS, surfaced in a github discussion. In a discussion on discord about the git-hook model, there was consensus about not repeating their mistakes.</p> <p>For <code>jj run</code> there is prior art in Mercurial, git branchless and Google's internal Mercurial. Currently git-branchless <code>git test</code> and <code>hg fix</code> implement some kind of command runner. The Google internal <code>hg run</code> works in conjunction with CitC (Clients in the Cloud) which allows it to lazily apply the current command to any affected file. Currently no open-source Jujutsu backend (Git, Simple) has a fancy virtual filesystem supporting it, so we can't apply this optimization. We could do the same once we have an implementation of the working copy based on a virtual file system. Until then, we have to run the commands in regular local-disk working copies.</p>"},{"location":"design/run.html#goals-and-non-goals","title":"Goals and Non-Goals","text":""},{"location":"design/run.html#goals","title":"Goals","text":"<ul> <li>We should be able to apply the command to any revision, published or unpublished.</li> <li>We should be able to parallelize running the actual command, while preserving a good console output.</li> <li>The run command should be able to work in any commit, the working-copy commit itself or any other commit.</li> <li>There should exist some way to signal hard failure.</li> <li>The command should build enough infrastructure for <code>jj test</code>, <code>jj fix</code> and <code>jj format</code>.</li> <li>The main goal is to be good enough, as we can always expand the functionality in the future.</li> </ul>"},{"location":"design/run.html#non-goals","title":"Non-Goals","text":"<ul> <li>While we should build a base for <code>jj test</code>, <code>jj format</code> and <code>jj fix</code>, we shouldn't mash their use-cases into <code>jj run</code>.</li> <li>The command shouldn't be too smart, as too many assumptions about workflows makes the command confusing for users.</li> <li>The smart caching of outputs, as user input commands can be unpredictable. makes the command confusing for users.</li> <li>Avoid the smart caching of outputs, as user input commands can be unpredictable.</li> <li>Fine grained user facing configuration, as it's unwarranted complexity.</li> <li>A <code>fix</code> subcommand as it cuts too much design space.</li> </ul>"},{"location":"design/run.html#use-cases-of-jj-run","title":"Use-Cases of jj run","text":"<p>Linting and Formatting:</p> <ul> <li><code>jj run 'pre-commit run' -r $revset</code></li> <li><code>jj run 'cargo clippy' -r $revset</code></li> <li><code>jj run 'cargo +nightly fmt'</code></li> </ul> <p>Large scale changes across repositories, local and remote:</p> <ul> <li><code>jj run 'sed /some/test/' -r 'mine() &amp; ~remote_bookmarks(\"origin\")'</code></li> <li><code>jj run '$rewrite-tool' -r '$revset'</code></li> </ul> <p>Build systems:</p> <ul> <li><code>jj run 'bazel build //some/target:somewhere'</code></li> <li><code>jj run 'ninja check-lld'</code></li> </ul> <p>Some of these use-cases should get a specialized command, as this allows further optimization. A command could be <code>jj format</code>, which runs a list of formatters over a subset of a file in a revision. Another command could be <code>jj fix</code>, which runs a command like <code>rustfmt --fix</code> or <code>cargo clippy --fix</code> over a subset of a file in a revision.</p>"},{"location":"design/run.html#design","title":"Design","text":""},{"location":"design/run.html#base-design","title":"Base Design","text":"<p>All the work will be done in the <code>.jj/</code> directory. This allows us to hide all complexity from the users, while preserving the user's current workspace.</p> <p>We will copy the approach from git-branchless's <code>git test</code> of creating a temporary working copy for each parallel command. The working copies will be reused between <code>jj run</code> invocations. They will also be reused within <code>jj run</code> invocation if there are more commits to run on than there are parallel jobs.</p> <p>We will leave ignored files in the temporary directory between runs. That enables incremental builds (e.g. by letting cargo reuse its <code>target/</code> directory). However, it also means that runs potentially become less reproducible. We will provide a flag for removing ignored files from the temporary working copies to address that.</p> <p>Another problem with leaving ignored files in the temporary directories is that they take up space. That is especially problematic in the case of cargo (the <code>target/</code> directory often takes up tens of GBs). The same flag for cleaning up ignored files can be used to address that. We may want to also have a flag for cleaning up temporary working copies after running the command.</p> <p>An early version of the command will directly use Treestate to to manage the temporary working copies. That means that running <code>jj</code> inside the temporary working copies will not work . We can later extend that to use a full Workspace. To prevent operations in the working copies from impacting the repo, we can use a separate OpHeadsStore for it.</p>"},{"location":"design/run.html#modifying-the-working-copy","title":"Modifying the Working Copy","text":"<p>Since the subprocesses will run in temporary working copies, they won't interfere with the user's working copy. The user can therefore continue to work in it while <code>jj run</code> is running.</p> <p>We want subprocesses to be able to make changes to the repo by updating their assigned working copy. Let's say the user runs <code>jj run</code> on just commits A and B, where B's parent is A. Any changes made on top of A would be squashed into A, forming A'. Similarly B' would be formed by squasing it into B. We can then either do a normal rebase of B' onto A', or we can simply update its parent to A'. The former is useful, e.g. when the subprocess only makes a partial update of the tree based on the parent commit. In addition to these two modes, we may want to have an option to ignore any changes made in the subprocess's working copy.</p>"},{"location":"design/run.html#modifying-the-repo","title":"Modifying the Repo","text":"<p>Once we give the subprocess access to a fork of the repo via separate OpHeadsStore, it will be able to create new operations in its fork. If the user runs <code>jj run -r foo</code> and the subprocess checks out another commit, it's not clear what that should do. We should probably just verify that the working-copy commit's parents are unchanged after the subprocess returns. Any operations created by the subprocess will be ignored.</p>"},{"location":"design/run.html#rewriting-the-revisions","title":"Rewriting the revisions","text":"<p>Like all commands, <code>jj run</code> will refuse to rewrite public/immutable commits. For private/unpublished revisions, we either amend or reparent the changes, which are available as command options.</p>"},{"location":"design/run.html#execution-orderparallelism","title":"Execution order/parallelism","text":"<p>It may be useful to execute commands in topological order. For example, commands with costs proportional to incremental changes, like build systems. There may also be other relevant heuristics, but topological order is an easy and effective way to start.</p> <p>Parallel execution of commands on different commits may choose to schedule commits to still reduce incremental changes in the working copy used by each execution slot/\"thread\". However, running the command on all commits concurrently should be possible if desired.</p> <p>Executing commands in topological order allows for more meaningful use of any potential features that stop execution \"at the first failure\". For example, when running tests on a chain of commits, it might be useful to proceed in topological/chronological order, and stop on the first failure, because it might imply that the remaining executions will be undesirable because they will also fail.</p>"},{"location":"design/run.html#dealing-with-failure","title":"Dealing with failure","text":"<p>It will be useful to have multiple strategies to deal with failures on a single or multiple revisions. The reason for these strategies is to allow customized conflict handling. These strategies then can be exposed in the ui with a matching option.</p> <p>Continue: If any subprocess fails, we will continue the work on child revisions. Notify the user on exit about the failed revisions.</p> <p>Stop: Signal a fatal failure and cancel any scheduled work that has not yet started running, but let any already started subprocess finish. Notify the user about the failed command and display the generated error from the subprocess.</p> <p>Fatal: Signal a fatal failure and immediately stop processing and kill any running processes. Notify the user that we failed to apply the command to the specific revision.</p> <p>We will leave any affected commit in its current state, if any subprocess fails. This allows us to provide a better user experience, as leaving revisions in an undesirable state, e.g partially formatted, may confuse users.</p>"},{"location":"design/run.html#resource-constraints","title":"Resource constraints","text":"<p>It will be useful to constrain the execution to prevent resource exhaustion. Relevant resources could include:</p> <ul> <li>CPU and memory available on the machine running the commands. <code>jj run</code> can provide some simple mitigations like limiting parallelism to \"number of CPUs\" by default, and limiting parallelism by dividing \"available memory\" by some estimate or measurement of per-invocation memory use of the commands.</li> <li>External resources that are not immediately known to jj. For example, commands run in parallel may wish to limit the total number of connections to a server. We might choose to defer any handling of this to the implementation of the command being invoked, instead of trying to communicate that information to jj.</li> </ul>"},{"location":"design/run.html#command-options","title":"Command Options","text":"<p>The base command of any jj command should be usable. By default <code>jj run</code> works on the <code>@</code> the current working copy.</p> <ul> <li>--command, explicit name of the first argument</li> <li>-x, for git compatibility (may alias another command)</li> <li>-j, --jobs, the amount of parallelism to use</li> <li>-k, --keep-going, continue on failure (may alias another command)</li> <li>--show, display the diff for an affected revision</li> <li>--dry-run, do the command execution without doing any work, logging all intended files and arguments</li> <li>--rebase, rebase all parents on the consulitng diff (may alias another command)</li> <li>--reparent, change the parent of an effected revision to the new change (may alias another command)</li> <li>--clean, remove existing workspaces and remove the ignored files</li> <li>--readonly, ignore changes across multiple run invocations</li> <li>--error-strategy=<code>continue|stop|fatal</code>, see Dealing with failure</li> </ul>"},{"location":"design/run.html#integrating-with-other-commands","title":"Integrating with other commands","text":"<p><code>jj log</code>: No special handling needed <code>jj diff</code>: No special handling needed <code>jj st</code>: For now reprint the final output of <code>jj run</code> <code>jj op log</code>: No special handling needed, but awaits further discussion in #963 <code>jj undo/jj op revert</code>: No special handling needed</p>"},{"location":"design/run.html#open-points","title":"Open Points","text":"<p>Should the command be working copy backend specific? How do we manage the Processes which the command will spawn? Configuration options, User and Repository Wide?</p>"},{"location":"design/run.html#future-possibilities","title":"Future possibilities","text":"<ul> <li>We could rewrite the file in memory, which is a neat optimization</li> <li>Exposing some internal state, to allow preciser resource constraints</li> <li>Integration options for virtual filesystems, which allow them to cache the needed working copies.</li> <li>A Jujutsu wide concept for a cached working copy, as they could be expensive to materialize.</li> <li>Customized failure messages, this maybe useful for bots, it could be similar to Bazel's <code>select(..., message = \"arch not supported for $project\")</code>.</li> <li>Make <code>jj run</code> asynchronous by spawning a <code>main</code> process, directly return to the user and incrementally updating the output of <code>jj st</code>.</li> </ul>"},{"location":"design/secure-config.html","title":"Secure JJ config","text":"<p>Author: Matt Stark</p>"},{"location":"design/secure-config.html#the-problem","title":"The problem","text":"<p>An attacker that has control over your jj configuration has full control over your system when you run specific commands. As an example, an attacker can have you enable the following repo config:</p> <pre><code>[fix.tools.foo]\ncommand = [\"malicious\", \"command\"]\n</code></pre> <p>When a user then runs <code>jj fix</code>, this will run their malicious command and they can gain full control over your system. This can be achieved via zipping up a repo and sending it to the user, with the <code>.jj/repo/config.toml</code> file containing the above config (hence why this is colloquially known as the \u201czip file problem\u201d).</p> <p>There are plans to add features such as hooks to jj which will only make it easier for this to occur. For simplicity\u2019s sake, we will assume that if an attacker has their configuration enabled on your system, it is compromised.</p> <p>Assume any reference to repo config can equivalently be replaced with workspace configs. We will treat them in the same way.</p>"},{"location":"design/secure-config.html#threat-model","title":"Threat model","text":"<p>This is not something that can be 100% defended against. Defense against all possible attack vectors is infeasible, so we will instead note all the attack vectors and what it would take to defend against them.</p>"},{"location":"design/secure-config.html#attack-vector-1-no-knowledge-attacker","title":"Attack vector 1: No-knowledge attacker","text":"<ol> <li>The attacker creates a repo</li> <li>The attacker runs     <code>jj config set --repo fix.tools.foo \u2018[\u201cmalicious\u201d, \u201ccommand\u201d]\u2019</code></li> <li>The attacker zips up their repo and sends it to the victim</li> <li>The victim unzips the repo, make some changes, then run <code>jj fix</code></li> <li>They have now executed an arbitrary command on the victim\u2019s system</li> </ol> <p>This attack vector can be solved by ensuring that we can determine the user who created the repo.</p>"},{"location":"design/secure-config.html#attack-vector-2-basic-replay-attack","title":"Attack vector 2: Basic replay attack","text":"<ol> <li>The victim uploads a zip file of a repository they have locally on their     system</li> <li>The attacker can now see any configs / config references stored in the     repository</li> <li>The attacker runs     <code>jj config set --repo fix.tools.foo \u2018[\u201cmalicious\u201d, \u201ccommand\u201d]\u2019</code></li> <li>The attacker copies the victim\u2019s cryptographic signature and puts it in     their malicious repository.</li> <li>The attacker zips up their repo and sends it to the victim</li> <li>The victim unzips the repo at an arbitrary location, make some changes, then     run <code>jj fix</code></li> <li>They have now executed an arbitrary command on the victim\u2019s system</li> </ol> <p>This attack vector can be solved by ensuring that we can determine the path that the repo was stored at.</p>"},{"location":"design/secure-config.html#attack-vector-3-replay-attack-with-social-engineering-to-preserve-paths","title":"Attack vector 3: Replay attack with social engineering to preserve paths","text":"<ol> <li>The victim uploads a zip file of a repository they have locally on their     system at <code>/path/to/repo</code></li> <li>The attacker can now see any configs / config references stored in the     repository</li> <li>The attacker runs     <code>jj config set --repo fix.tools.foo \u2018[\u201cmalicious\u201d, \u201ccommand\u201d]\u2019</code></li> <li>The attacker copies the victim\u2019s cryptographic signature and puts it in     their malicious repository.</li> <li>The attacker zips up their repo, sends it to the victim, and instructs them     to install it at <code>/path/to/repo</code></li> <li>The victim unzips the repo at <code>/path/to/repo</code>, make some changes, then run     <code>jj fix</code></li> <li>They have now executed an arbitrary command on the victim\u2019s system</li> </ol> <p>This attack vector can be solved by making repository configuration untamperable.</p>"},{"location":"design/secure-config.html#attack-vector-4-extremely-advanced-replay-attack-with-insecure-code","title":"Attack vector 4: Extremely advanced replay attack with insecure code","text":"<ol> <li>The victim creates a repo</li> <li>The victim runs <code>jj config set --repo fix.tools.foo = [\u201c$repo/format.py\u201d]</code></li> <li>The victim uploads a zip file of a repository they have locally on their     system at <code>/path/to/repo</code></li> <li>The attacker can now see any configs / config references stored in the     repository</li> <li>The attacker modifies <code>format.py</code> to be malicious</li> <li>The attacker zips up their repo and sends it to the victim</li> <li>The victim runs <code>jj fix</code></li> <li>They have now executed an arbitrary command on the victim\u2019s system</li> </ol> <p>This attack vector cannot feasibly be dealt with. It would require a signature of the transitive closure of files that can be accessed via jj configs to solve.</p>"},{"location":"design/secure-config.html#objective","title":"Objective","text":""},{"location":"design/secure-config.html#goals","title":"Goals","text":"<ul> <li>Prevent as many of the above attack vectors as possible</li> <li>Have minimal negative impacts on UX</li> </ul>"},{"location":"design/secure-config.html#non-goals-optional","title":"Non-goals (Optional)","text":"<ul> <li>Use strategies such as sandboxing to mitigate damage     *   We could do this for formatters, for example, but then repo hooks would         have the same problem     *   These options are not mutually exclusive</li> </ul>"},{"location":"design/secure-config.html#detailed-design","title":"Detailed Design","text":"<p>Note that this design uses the word \"repo\" for everything, but we will use precisely the same technique for workspace configs.</p>"},{"location":"design/secure-config.html#storing-config-out-of-repo","title":"Storing config out-of-repo","text":"<p>We start by creating the concept of a \"config ID\".</p> <ul> <li>A config ID is a randomly generated ID used to identify a configuration.</li> <li>It should be stored in the repo</li> <li>It should uniquely identify a single repository / workspace</li> </ul> <p>For clarity's sake, we will call these \"config IDs\" for repos, and \"workspace config IDs\" for workspaces.</p> <p>We will store per-repo configuration in <code>etcetera::BaseStrategy::config_dir().join(\u201cjj\u201d).join(\u201crepos\u201d).join(config_id)</code>.</p> <p>The filesystem structure will look like:</p> <pre><code>$HOME/.config/jj/\n  repos/\n    abc123/\n      metadata.binpb\n      config.toml\n  workspaces/\n    def456/\n      config.toml\n      metadata.binpb\nmy-repo/.jj/\n  workspace-config-id (contains \"def456\")\n  workspace-config.toml (unused by jj, details below)\n  repo/\n    config-id (contains \"abc123\")\n    config.toml (unused by jj, details below)\n</code></pre> <p><code>metadata.binpb</code> will refer to the following protobuf:</p> <pre><code>message Metadata {\n  // This is used to distinguish between copies and moves.\n  string path = 1;\n}\n</code></pre> <p>The function to load repository configuration, will roughly speaking, look like:</p> <pre><code>enum ConfigLoadError { NoRepoId, NoConfig, PathMismatch, }\n\nfn load_repo_config_path(repo: &amp;Path) -&gt; Result&lt;PathBuf, ConfigLoadError&gt; {\n  let config_id = std::fs::read_to_string(repo.join(\"config-id\"))\n    .map_err(|_|Err(NoRepoId))?;\n  let repo_config_dir = config_dir.join(\"repos\").join(config_id);\n  let metadata = Metadata::decode(\n    std::fs::read(repo_config_dir.join(\"metadata.binpb\")) .map_err(|_|\n    Err(NoConfig))? )?;\n  if metadata.path != repo {\n    return Err(PathMismatch)\n  }\n  Ok(repo_config_dir.join(\"config.toml\"))\n}\n</code></pre>"},{"location":"design/secure-config.html#happy-path","title":"Happy path","text":"<p>Normally we will simply:</p> <ol> <li>Load the <code>config-id</code> file</li> <li>Check that <code>$HOME/.config/jj/repos/$CONFIG_ID</code> exists</li> <li>Validate that the path in <code>$HOME/.config/jj/repos/$CONFIG_ID/metadata.binpb</code>    matches the repo's path</li> <li>Find the corresponding config in    <code>$HOME/.config/jj/repos/$CONFIG_ID/config.toml</code></li> <li>Load that config.</li> </ol> <p>However, these steps can fail. The following sections are how we will handle the errors.</p>"},{"location":"design/secure-config.html#no-config-id-file","title":"No config-ID file","text":""},{"location":"design/secure-config.html#without-config-files","title":"Without config files","text":"<p>If <code>$repo/.jj/repo/config.toml</code> does not exist, the repo doesn't have any config, and thus requires no config ID.</p> <p>Note that the expected way to generate a config-ID would be for the user to either run <code>jj config edit</code> or <code>jj config path</code>.</p>"},{"location":"design/secure-config.html#with-config-files","title":"With config files","text":"<p>If the config file exists, then this corresponds to a legacy repo. To preserve backwards compatibility, we will introduce a period of auto-migration. The current plan is 12 jj versions (approximately 1 year). During this period, if a config ID has not yet been generated, we will silently perform the following (order matters, to ensure failure halfway through doesn\u2019t affect things):</p> <ol> <li>Generate a config ID <code>abc123</code></li> <li>Create <code>$HOME/.config/jj/repo/abc123/metadata.binpb</code></li> <li>Create <code>$HOME/.config/jj/repo/abc123/config.toml</code> as a copy of the original     config file</li> <li>Atomically generate a <code>config-id</code> file containing <code>abc123</code></li> <li>Remove the original config file</li> <li>For the user's convenience, and for older version of jj, we:     *   Try to symlink the old config to the new config     *   If this fails (symlinks don't play nice on windows), we replace it with         the same file content, with an extra comment at the top telling the user         not to edit the file, and set it to readonly.</li> </ol> <p>After the migration period is over, we will:</p> <ul> <li>Stop the auto-migration</li> <li>If the config file was previously created by auto-migration, delete it<ul> <li><code>zip</code> follows symlinks by default, so this would reveal the content of your   config to an attacker if they convinced you to send them your repo.</li> </ul> </li> <li>If the config file exists, print a warning that the config file has been ignored.</li> </ul>"},{"location":"design/secure-config.html#no-config-directory-for-the-config-id","title":"No config directory for the config-ID","text":"<p>This could occur, for example, if the user created a repository in linux, rebooted into windows on the same computer, and attempted to access that repo.</p> <p>In this event, the user probably expects their config to be attached to the repository, and they expect it to still work on linux, so we will:</p> <ul> <li>Create a new <code>$HOME/.config/jj/repo/$CONFIG_ID</code> directory for the same config   ID (to ensure that the config still works on windows)</li> <li>Print a warning that if there was any per-repo configuration, it is no longer   available.</li> </ul>"},{"location":"design/secure-config.html#distinguishing-copies-from-moves","title":"Distinguishing copies from moves","text":"<p>A user's expectation is that if they run <code>cp -r old_repo new_repo</code>, then modify the old repo's config, the new repo's config is not affected. Thus, we need to make sure that the repo remains in a 1:1 relationship with the config. Multiple repos should not point to the same config.</p> <p>To achieve this, we point the repo at the config, and the config back at the repo. If the path stored in the config doesn't match, we know that something has happened. To decide precisely what happened:</p> <ul> <li>If the path stored in the config no longer exists, we assume it's a move<ul> <li>We update <code>metadata.path</code> to point to the new path</li> </ul> </li> <li>Otherwise, we attempt to write to a temporary file in <code>$NEW_REPO/.jj/repo</code>.<ul> <li>If it shows up in the original repository, it's some kind of reference   (link, mount, etc.), so we don't do anything.</li> <li>Otherwise, it's a copy, so we generate a new config ID and copy the old   config to it</li> </ul> </li> </ul> <p>Note that with a copy, we only actually copy the config when the user runs a <code>jj</code> command. This means that you can end up in a situation where you:</p> <ol> <li><code>cp -r old_repo new_repo</code></li> <li>In <code>old_repo</code>, <code>jj config set --repo</code></li> <li>Run a jj command in the copy. This copies the config, including the config    from step 2.</li> </ol> <p>However, this is inherent to storing config out of the repo and is thus unavoidable.</p>"},{"location":"design/secure-config.html#garbage-collection","title":"Garbage collection","text":"<p>We could, in the future, add a <code>gc</code> command to garbage-collect configs to deleted repo configs. However, there are some things to consider before doing so:</p> <ul> <li>Each config would likely be very small, so cleaning it up may have limited   benefit.</li> <li>It is impossible to distinguish \"deleted\" from \"moved\".</li> <li>If you have something like a chroot or a dual boot where you share the   config, you may have references to config IDs with a different path.</li> </ul>"},{"location":"design/secure-config.html#attack-vectors-remaining","title":"Attack vectors remaining","text":"<p>Unfortunately, there is no way to distinguish copying / moving from a replay attack. The attacker, if they know a config ID that exists on your system, can create a repo with the same config ID. However, the fact that the config itself is stored out of repo inherently prevents simple replay attacks. In order for the attacker to exploit this, they would need to:</p> <ul> <li>Know your config ID (requires uploading a zip file or something similar)</li> <li>Get lucky by the victim having a \u201crisky\u201d per-repo config</li> <li>Eg. fix.tools pointing to <code>$repo/formatter</code></li> <li>Know how to exploit it</li> <li>Because your config file is stored out-of-repo, the attacker will likely not   know any of this without some social engineering</li> </ul> <p>Given the impossibility of distinguishing copying / moving from a replay attack, any security measures we come up with to deal with this would have false positives whenever you do a copy / move, creating a significant UX cost. Thus, we intentionally choose not to deal with this kind of attack in the initial version, and have no current intention to solve it in future versions either.</p> <p>We could potentially deal with this attack vector as an opt-in feature in the future, but it has dubious benefit, as the kind of user who would opt in to something like this is also the kind of user who would never upload their repo as a zip file.</p> <p>Because only the config-id is stored in-repo, the only attack vector remaining is the replay attack I mentioned above.</p>"},{"location":"design/secure-config.html#ux-issues","title":"UX issues","text":"<ul> <li>Copying the repo is essentially a symlink to an old config until you update     it</li> <li>Multiple users on the same system would each have different per-repo configs     *   This can be solved by simply symlinking <code>$HOME/.config/jj</code> to         <code>%APPDATA%/jj</code> (or vice versa) to solve this issue. You were probably         doing this anyway with specifically the user config file instead of the         directory.</li> <li>The repo config will no longer be available across machines if the user is     using something like a distributed file system. This is probably OK, since     if the user has a complex setup like this, they will also have issues with     the config of every other application not being shared, and could easily     solve this by sharing <code>~/.config</code>.</li> </ul>"},{"location":"design/secure-config.html#alternatives-considered","title":"Alternatives considered","text":""},{"location":"design/secure-config.html#store-the-configs-in-repo-with-an-untamperable-cryptographic-signature","title":"Store the configs in-repo with an untamperable cryptographic signature","text":"<p>There are a few questions we would need to resolve here, all with significant drawbacks:</p>"},{"location":"design/secure-config.html#do-we-include-paths-in-the-signature","title":"Do we include paths in the signature?","text":"<p>If we do, we introduce a whole bunch of additional annoying UX to the user when they move repos around.</p> <p>If we don't, we leave ourselved exposed to additional attack vectors</p>"},{"location":"design/secure-config.html#how-to-sign-the-content-of-the-repo-config","title":"How to sign the content of the repo config?","text":"<ul> <li>We could not sign it at all, but that would leave ourselves exposed to     additional attack vectors.</li> <li>We could sign the content of the repo config, but then when the user     manually edits the file we have additional UX we need to introduce.</li> <li>We could store both the content and the signature in the repo protobuf, but     the config would no longer exist on disk as a regular file, and thus you     couldn't use standard tools to read and write the config.</li> </ul> <p>All of these options were discussed in the original PR (#7761), which, unlike the current approach, introduced user interventions and a review process. The current approach, on the other hand, while it does have some extremely minor UX weirdness, has no such issues.</p>"},{"location":"design/sparse-v2.html","title":"Sparse Patterns v2 redesign","text":"<p>Authors: Daniel Ploch</p> <p>Summary: This Document documents a redesign of the sparse command and it's internal storage format in jj, in order to facilitate several desirable improvements for large repos. It covers both the migration path and the planned end state.</p>"},{"location":"design/sparse-v2.html#objective","title":"Objective","text":"<p>Redesign Sparse Patterns to accommodate more advanced features for native and custom implementations. This includes three main goals:</p> <ol> <li>Sparse Patterns should be versioned with the working copy</li> <li>Sparse Patterns should support more flexible matching rules</li> <li>Sparse Patterns should support client path remapping</li> </ol>"},{"location":"design/sparse-v2.html#current-state-as-of-jj-0130","title":"Current State (as of jj 0.13.0)","text":"<p>Sparse patterns are an effectively unordered list of prefix strings:</p> <pre><code>path/one\npath/to/dir/two\n</code></pre> <p>The set of files identified by the Sparse Patterns is all paths which match any provided prefix. This governs what gets materialized in the working copy on checkout, and what is updated on snapshot. The set is stored in working copy state files which are not versioned in the Op Store.</p> <p>Because all paths are bare strings with no escaping or higher-level formatting, the current design makes it difficult to add new features like exclusions or path remappings.</p>"},{"location":"design/sparse-v2.html#proposed-state-sparse-patterns-v2","title":"Proposed State (Sparse Patterns v2)","text":"<p>Sparse Patterns v2 will be stored as objects in the Op Store, referenced by a <code>WorkingCopyPatternsId</code> from the active <code>View</code>. They will have a new, ordered structure which can fully represent previous patterns.</p> <pre><code>/// Analogues of RepoPath, specifically describing paths in the working copy.\nstruct WorkingCopyPathBuf {\n    String\n}\nstruct WorkingCopyPath {\n    str\n}\n\npub enum SparsePatternsPathType {\n    Dir,    // Everything under &lt;path&gt;/...\n    Files,  // Files under &lt;path&gt;/*\n    Exact,  // &lt;path&gt; exactly\n}\n\npub struct SparsePatternsPath {\n    path_type: SparsePatternsPathType,\n    include: bool,  // True if included, false if excluded.\n    path: RepoPathBuf,\n}\n\npub struct WorkingCopyMapping {\n    src_path: RepoPathBuf,\n    dst_path: WorkingCopyPathBuf,\n    recursive: bool,  // If false, only immediate children of src_path (files) are renamed.\n}\n\npub struct WorkingCopyPatterns {\n    sparse_paths: Vec&lt;SparsePatternsPath&gt;,\n    mappings: Vec&lt;WorkingCopyMapping&gt;,\n}\n\npub trait OpStore {\n    ...\n    pub fn read_working_copy_patterns(&amp;self, id: &amp;WorkingCopyPatternsId) -&gt; OpStoreResult&lt;WorkingCopyPatterns&gt; { ... }\n    pub fn write_working_copy_patterns(&amp;self, sparse_patterns: &amp;WorkingCopyPatterns) -&gt; OpStoreResult&lt;WorkingCopyPatternsId&gt; { .. }\n}\n</code></pre> <p>To support these more complex behaviors, a new <code>WorkingCopyPatterns</code> trait will be introduced, initially only as a thin wrapper around the existing prefix format, but soon to be expanded with richer types and functionality.</p> <pre><code>impl WorkingCopyPatterns {\n    pub fn to_matcher(&amp;self) -&gt; Box&lt;dyn Matcher&gt; {\n        ...\n    }\n\n    ...\n}\n</code></pre>"},{"location":"design/sparse-v2.html#command-syntax","title":"Command Syntax","text":"<p><code>SparsePatternsPath</code> rules can be specified on the CLI and in an editor via a compact syntax:</p> <pre><code>(include|exclude):(dir|files|exact):&lt;path&gt;\n</code></pre> <p>If both prefix terms are omitted, then <code>include:dir:</code> is assumed. If any prefix is specified, both must be specified. The editor and CLI will both accept path rules in either format going forward.</p> <ul> <li><code>jj sparse set --add foo/bar</code> is equal to <code>jj sparse set --add include:dir:foo/bar</code></li> <li><code>jj sparse set --add exclude:dir:foo/bar</code> adds a new <code>Dir</code> type rule with <code>include = false</code></li> <li><code>jj sparse set --exclude foo/bar</code> as a possible shorthand for the above</li> <li><code>jj sparse list</code> will print the explicit rules</li> </ul> <p>Paths will be stored in an ordered, canonical form which unambiguously describes the set of files to be included. Every <code>--add</code> command will append to the end of this list before the patterns are canonicalized. Whether a file is included is determined by the first matching rule in reverse order.</p> <p>For example:</p> <pre><code>include:dir:foo\nexclude:dir:foo/bar\ninclude:dir:foo/bar/baz\nexclude:dir:foo/bar/baz/qux\n</code></pre> <p>Produces rule set which includes \"foo/file.txt\", excludes \"foo/bar/file.txt\", includes \"foo/bar/baz/file.txt\", and excludes \"foo/bar/baz/qux/file.txt\".</p> <p>If the rules are subtly re-ordered, they become canonicalized to a smaller, but functionally equivalent form:</p> <pre><code># Before\ninclude:dir:foo\nexclude:dir:foo/bar/baz/qux\ninclude:dir:foo/bar/baz\nexclude:dir:foo/bar\n\n# Canonicalized\ninclude:dir:foo\nexclude:dir:foo/bar\n</code></pre>"},{"location":"design/sparse-v2.html#canonicalization","title":"Canonicalization","text":"<p>There are many ways to represent functionally equivalent <code>WorkingCopyPatterns</code>. For instance, the following 4 rule sets are all functionally equivalent:</p> <pre><code># Set 1\ninclude:dir:bar\ninclude:dir:foo\n\n# Set 2\ninclude:dir:foo\ninclude:dir:bar\n\n# Set 3\ninclude:dir:bar\ninclude:dir:bar/baz/qux\ninclude:dir:foo\n\n# Set 4\ninclude:dir:foo\nexclude:dir:foo/baz\ninclude:dir:bar\ninclude:dir:foo/baz\n</code></pre> <p>Because these patterns are stored in the Op Store now, it is useful for all of these representations to be rewritten into a minimal, canonical form before serialization. In this case, <code>Set 1</code> will be the canonical set. The canonical form of a <code>WorkingCopyPatterns</code> is defined as the form such that:</p> <ul> <li>Every rule affects the functionality (there are no redundant rules)</li> <li>Rules are sorted lexicographically, but with '/' sorted before all else<ul> <li>This special sorting order is useful for constructing path tries</li> </ul> </li> </ul>"},{"location":"design/sparse-v2.html#working-copy-map","title":"Working Copy Map","text":"<p>Warning</p> <p>This section is intentionally lacking, more research is needed.</p> <p>All <code>WorkingCopyPatterns</code> will come equipped with a default no-op mapping. These mappings are inspired by and similar to Perforce client views.</p> <pre><code>vec![WorkingCopyMapping {\n    src_path: RepoPathBuf::root(),\n    dst_path: WorkingCopyPathBuf::root(),\n    recursive: true,\n}]\n</code></pre> <p><code>WorkingCopyPatterns</code> will provide an interface to map working copy paths into repo paths and vice versa. The `WorkingCopy`` trait will apply this mapping to all snapshot and checkout operations, and jj commands which accept relative paths will need to be updated to perform working copy path -&gt; repo path translations as needed. It's not clear at this time which commands will need changing, as some are more likely to refer to repo paths rather than working copy paths.</p> <p>TODO: Expand this section.</p> <p>In particular, the path rules for sparse patterns will always be repo paths, not working copy paths. Thus, if the working copy wants to track \"foo\" and rename it to \"subdir/bar\", they must <code>jj sparse set --add foo</code> and <code>jj map set --from foo --to bar</code>. In other words, the mapping operation can be thought of as always after the sparse operation.</p>"},{"location":"design/sparse-v2.html#command-syntax_1","title":"Command Syntax","text":"<p>New commands will enable editing of the <code>WorkingCopyMapping</code>s:</p> <p>TODO: Maybe this should be <code>jj workspace map ...</code>?</p> <ul> <li><code>jj map list</code> will print all mapping pairs.</li> <li><code>jj map add --from foo --to bar</code> will add a new mapping to the end of the list.</li> <li><code>jj map remove --from foo</code> will remove a specific mapping rule.</li> <li><code>jj map edit</code> will pull up a text editor for manual editing.</li> </ul> <p>Like sparse paths, mappings will have a compact text syntax for editing in file form, or for adding a rule textually on the CLI:</p> <pre><code>\"&lt;from&gt;\" -&gt; \"&lt;to&gt;\" [nonrecursive]\n</code></pre> <p>Like sparse paths, mapping rules are defined to apply in order and on any save operation will be modified to a minimal canonical form. Thus, <code>jj map set --from \"\" --to \"\"</code> will always completely wipe the map. The first matching rule in reverse list order determines how a particular repo path should be mapped into the working copy, and likewise how a particular working copy path should be mapped into the repo. For simplicity, the 'last rule wins' applies both for repo-&gt;WC conversions, as well as WC-&gt;repo conversions, using the same ordering.</p> <p>If a working copy mapping places the same repo file at two distinct working copy paths, snapshotting will fail unless these files are identical. Some specialized filesystems may even treat these as the 'same' file, allowing this to work in some cases.</p> <p>If a working copy mapping places two distinct repo files at the same working copy path, checkout will fail with an error regardless of equivalence.</p>"},{"location":"design/sparse-v2.html#versioning-and-storage","title":"Versioning and Storage","text":"<p>Updating the active <code>WorkingCopyPatterns</code> for a particular working copy will now take place in two separate steps: one transaction which updates the op store, and a separate <code>LockedWorkingCopy</code> operation which actually updates the working copy. The working copy proto will no longer store <code>WorkingCopyPatterns</code> directly, instead storing only a <code>WorkingCopyPatternsId</code>. On mismatch with the current op head, the user will be prompted to run <code>jj workspace update-stale</code>.</p> <p>This gives the user the ability to update the active <code>WorkingCopyPatterns</code> whilst not interacting with the local working copy, which is useful for custom integrations which may not be able to check out particular working copy patterns due to problems with the backend (encoding, permission errors, etc.). A bad <code>jj sparse set --add oops</code> command can thus be undone, even via <code>jj op undo</code> if desired.</p>"},{"location":"design/sparse-v2.html#view-updates","title":"View Updates","text":"<p>The View object will be migrated to store working copy patterns via id. The indirection will save on storage since working copy patterns are not expected to change very frequently.</p> <pre><code>// Before:\npub wc_commit_ids: HashMap&lt;WorkspaceNameBuf, CommitId&gt;,\n\n// After:\npub struct WorkingCopyInfo {\n    pub commit_id: CommitId,\n    pub wc_patterns_id: WorkingCopyPatternsId,\n}\n...\npub wc_info: HashMap&lt;WorkspaceNameBuf, WorkingCopyInfo&gt;,\n</code></pre> <p>A View object with no stored working copy patterns will be modified at read time to include the current working copy patterns, thus all <code>read_view</code> operations will need to pass in the current working copy patterns for a migration period of at least 6 months. After that, we may choose to auto-fill missing working copy infos with a default <code>WorkingCopyPatterns</code> as needed.</p>"},{"location":"design/sparse-v2.html#appendix","title":"Appendix","text":""},{"location":"design/sparse-v2.html#related-work","title":"Related Work","text":"<p>Perforce client maps  are very similar in concept to the entirety of <code>WorkingCopyPatterns</code>, and this  design aims to achieve similar functionality.</p> <p>The Josh Project implements partial git clones in a way similar to how sparse patterns try to work.</p>"},{"location":"design/sparse-v2.html#patterns-via-configuration","title":"Patterns via configuration","text":"<p>There may be some scenarios where it is valuable to configure working copy patterns via a configuration file, rather than through explicit commands. Generally this only makes sense for automated repos, with the configuration coming from outside the repo - there are too many caveats and edge cases if the configuration comes from inside the repo and/or is fought with by a human.</p> <p>No configuration syntax is planned at this time but if we add any, we should probably reuse the compact line syntaxes as much as possible for consistency.</p>"},{"location":"design/tracking-branches.html","title":"Remote/<code>@git</code> tracking branches","text":"<p>This is a plan to implement more Git-like remote tracking branch UX.</p>"},{"location":"design/tracking-branches.html#objective","title":"Objective","text":"<p><code>jj</code> imports all remote branches to local branches by default. As described in #1136, this doesn't interact nicely with Git if we have multiple Git remotes with a number of branches. The <code>git.auto-local-bookmark</code> config can mitigate this problem, but we'll get locally-deleted branches instead.</p> <p>The goal of this plan is to implement</p> <ul> <li>proper support for tracking/non-tracking remote branches</li> <li>logically consistent data model for importing/exporting Git refs</li> </ul>"},{"location":"design/tracking-branches.html#current-data-model-as-of-jj-080","title":"Current data model (as of jj 0.8.0)","text":"<p>Under the current model, all remote branches are \"tracking\" branches, and remote changes are merged into the local counterparts.</p> <pre><code>branches\n  [name]:\n    local_target?\n    remote_targets[remote]: target\ntags\n  [name]: target\ngit_refs\n  [\"refs/heads/{name}\"]: target             # last-known local branches\n  [\"refs/remotes/{remote}/{name}\"]: target  # last-known remote branches\n                                            # (copied to remote_targets)\n  [\"refs/tags/{name}\"]: target              # last-known tags\ngit_head: target?\n</code></pre> <ul> <li>Remote branches are stored in both <code>branches[name].remote_targets</code> and   <code>git_refs[\"refs/remotes\"]</code>. These two are mostly kept in sync, but there   are two scenarios where remote-tracking branches and git refs can diverge:<ol> <li><code>jj branch forget</code></li> <li><code>jj op revert</code>/<code>restore</code> in colocated workspace</li> </ol> </li> <li>Pseudo <code>@git</code> tracking branches are stored in <code>git_refs[\"refs/heads\"]</code>. We   need special case to resolve <code>@git</code> branches, and their behavior is slightly   different from the other remote-tracking branches.</li> </ul>"},{"location":"design/tracking-branches.html#proposed-data-model","title":"Proposed data model","text":"<p>We'll add a per-remote-branch <code>state</code> to distinguish non-tracking branches from tracking ones.</p> <pre><code>state = new        # not merged in the local branch or tag\n      | tracking   # merged in the local branch or tag\n# `ignored` state could be added if we want to manage it by view, not by\n# config file. target of ignored remote branch would be absent.\n</code></pre> <p>We'll add a per-remote view-like object to record the last known remote branches. It will replace <code>branches[name].remote_targets</code> in the current model. <code>@git</code> branches will be stored in <code>remotes[\"git\"]</code>.</p> <pre><code>branches\n  [name]: target\ntags\n  [name]: target\nremotes\n  [\"git\"]:\n    branches\n      [name]: target, state                 # refs/heads/{name}\n    tags\n      [name]: target, state = tracking      # refs/tags/{name}\n    head: target?, state = TBD              # refs/HEAD\n  [remote]:\n    branches\n      [name]: target, state                 # refs/remotes/{remote}/{name}\n    tags: (empty)\n    head: (empty)\ngit_refs                                    # last imported/exported refs\n  [\"refs/heads/{name}\"]: target\n  [\"refs/remotes/{remote}/{name}\"]: target\n  [\"refs/tags/{name}\"]: target\n</code></pre> <p>With the proposed data model, we can</p> <ul> <li>naturally support remote branches which have no local counterparts</li> <li>deduplicate <code>branches[name].remote_targets</code> and <code>git_refs[\"refs/remotes\"]</code></li> </ul>"},{"location":"design/tracking-branches.html#importexport-data-flow","title":"Import/export data flow","text":"<pre><code>       export flow                              import flow\n       -----------                              -----------\n                        +----------------+                   --.\n   +-------------------&gt;|backing Git repo|---+                 :\n   |                    +----------------+   |                 : unchanged\n   |[update]                                 |[copy]           : on \"op restore\"\n   |                      +----------+       |                 :\n   |      +--------------&gt;| git_refs |&lt;------+                 :\n   |      |               +----------+       |               --'\n   +--[compare]                            [diff]--+\n          |   .--       +---------------+    |     |         --.\n          |   :    +---&gt;|remotes[\"git\"] |    |     |           :\n          +---:    |    |               |&lt;---+     |           :\n              :    |    |remotes[remote]|          |           : restored\n              '--  |    +---------------+          |[merge]    : on \"op restore\"\n                   |                               |           : by default\n             [copy]|    +---------------+          |           :\n                   +----| (local)       |&lt;---------+           :\n                        | branches/tags |                      :\n                        +---------------+                    --'\n</code></pre> <ul> <li><code>jj git import</code> applies diff between <code>git_refs</code> and <code>remotes[]</code>. <code>git_refs</code> is   always copied from the backing Git repo.</li> <li><code>jj git export</code> copies jj's <code>remotes</code> view back to the Git repo. If a ref in   the Git repo has been updated since the last import, the ref isn't exported.</li> <li><code>jj op restore</code> never rolls back <code>git_refs</code>.</li> </ul>"},{"location":"design/tracking-branches.html#tracking-state","title":"Tracking state","text":"<p>The <code>git.auto-local-bookmark</code> config knob is applied when importing new remote branch. <code>jj branch</code> sub commands will be added to change the tracking state.</p> <pre><code>fn default_state_for_newly_imported_branch(config, remote) {\n    if remote == \"git\" {\n        State::Tracked\n    } else if config[\"git.auto-local-bookmark\"] {\n        State::Tracked\n    } else {\n        State::New\n    }\n}\n</code></pre> <p>A branch target to be merged is calculated based on the <code>state</code>.</p> <pre><code>fn target_in_merge_context(known_target, state) {\n    match state {\n        State::New =&gt; RefTarget::absent(),\n        State::Tracked =&gt; known_target,\n    }\n}\n</code></pre>"},{"location":"design/tracking-branches.html#mapping-to-the-current-data-model","title":"Mapping to the current data model","text":"<ul> <li>New <code>remotes[\"git\"].branches</code> corresponds to <code>git_refs[\"refs/heads\"]</code>, but   forgotten branches are removed from <code>remotes[\"git\"].branches</code>.</li> <li>New <code>remotes[\"git\"].tags</code> corresponds to <code>git_refs[\"refs/tags\"]</code>.</li> <li>New <code>remotes[\"git\"].head</code> corresponds to <code>git_head</code>.</li> <li>New <code>remotes[remote].branches</code> corresponds to   <code>branches[].remote_targets[remote]</code>.</li> <li><code>state = new|tracking</code> doesn't exist in the current model. It's determined   by <code>git.auto-local-bookmark</code> config.</li> </ul>"},{"location":"design/tracking-branches.html#common-command-behaviors","title":"Common command behaviors","text":"<p>In the following sections, a merge is expressed as <code>adds - removes</code>. In particular, a merge of local and remote targets is <code>[local, remote] - [known_remote]</code>.</p>"},{"location":"design/tracking-branches.html#fetchimport","title":"fetch/import","text":"<ul> <li> <p><code>jj git fetch</code></p> <ol> <li>Fetches remote changes to the backing Git repo.</li> <li>Import changes only for <code>remotes[remote].branches[glob]</code> (see below)<ul> <li>TODO: how about fetched <code>.tags</code>?</li> </ul> </li> </ol> </li> <li> <p><code>jj git import</code></p> <ol> <li>Copies <code>git_refs</code> from the backing Git repo.</li> <li>Calculates diff from the known <code>remotes</code> to the new <code>git_refs</code>.<ul> <li><code>git_refs[\"refs/heads\"] - remotes[\"git\"].branches</code></li> <li><code>git_refs[\"refs/tags\"] - remotes[\"git\"].tags</code></li> <li>TBD: <code>\"HEAD\" - remotes[\"git\"].head</code> (unused)</li> <li><code>git_refs[\"refs/remotes/{remote}\"] - remotes[remote]</code></li> </ul> </li> <li>Merges diff in local <code>branches</code> and <code>tags</code> if <code>state</code> is <code>tracking</code>.<ul> <li>If the known <code>target</code> is <code>absent</code>, the default <code>state</code> should be    calculated. This also applies to previously-forgotten branches.</li> </ul> </li> <li>Updates <code>remotes</code> reflecting the import.</li> <li>Abandons commits that are no longer referenced.</li> </ol> </li> </ul>"},{"location":"design/tracking-branches.html#pushexport","title":"push/export","text":"<ul> <li> <p><code>jj git push</code></p> <ol> <li>Calculates diff from the known <code>remotes[remote]</code> to the local changes.<ul> <li><code>branches - remotes[remote].branches</code><ul> <li>If <code>state</code> is <code>new</code> (i.e. untracked), the known remote branch <code>target</code>    is considered <code>absent</code>.</li> <li>If <code>state</code> is <code>new</code>, and if the local branch <code>target</code> is <code>absent</code>, the    diff <code>[absent, remote] - absent</code> is noop. So it's not allowed to push    deleted branch to untracked remote.</li> <li>TODO: Copy Git's <code>--force-with-lease</code> behavior?</li> </ul> </li> <li>~<code>tags</code>~ (not implemented, but should be the same as <code>branches</code>)</li> </ul> </li> <li>Pushes diff to the remote Git repo (as well as remote tracking branches    in the backing Git repo.)</li> <li>Updates <code>remotes[remote]</code> and <code>git_refs</code> reflecting the push.</li> </ol> </li> <li> <p><code>jj git export</code></p> <ol> <li>Copies local <code>branches</code>/<code>tags</code> back to <code>remotes[\"git\"]</code>.<ul> <li>Conceptually, <code>remotes[\"git\"].branches[name].state</code> can be set to    untracked. Untracked local branches won't be exported to Git.</li> <li>If <code>remotes[\"git\"].branches[name]</code> is <code>absent</code>, the default    <code>state = tracking</code> applies. This also applies to forgotten branches.</li> <li>~<code>tags</code>~ (not implemented, but should be the same as <code>branches</code>)</li> </ul> </li> <li>Calculates diff from the known <code>git_refs</code> to the new <code>remotes[remote]</code>.</li> <li>Applies diff to the backing Git repo.</li> <li>Updates <code>git_refs</code> reflecting the export.</li> </ol> <p>If a ref failed to export at the step 3, the preceding steps should also be rolled back for that ref.</p> </li> </ul>"},{"location":"design/tracking-branches.html#initclone","title":"init/clone","text":"<ul> <li> <p><code>jj init</code></p> <ul> <li>Import, track, and merge per <code>git.auto_local_branch</code> config.</li> <li>If <code>!git.auto_local_branch</code>, no <code>tracking</code> state will be set.</li> </ul> </li> <li> <p><code>jj git clone</code></p> <ul> <li>Import, track, and merge per <code>git.auto_local_branch</code> config.</li> <li>The default branch will be tracked regardless of <code>git.auto_local_branch</code>   config. This isn't technically needed, but will help users coming from Git.</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#branch","title":"branch","text":"<ul> <li><code>jj branch set {name}</code><ol> <li>Sets local <code>branches[name]</code> entry.</li> </ol> </li> <li><code>jj branch delete {name}</code><ol> <li>Removes local <code>branches[name]</code> entry.</li> </ol> </li> <li><code>jj branch forget {name}</code><ol> <li>Removes local <code>branches[name]</code> entry if exists.</li> <li>Removes <code>remotes[remote].branches[name]</code> entries if exist.    TODO: maybe better to not remove non-tracking remote branches?</li> </ol> </li> <li><code>jj branch track {name}@{remote}</code> (new command)<ol> <li>Merges <code>[local, remote] - [absent]</code> in local branch.<ul> <li>Same as \"fetching/importing existing branch from untracked remote\".</li> </ul> </li> <li>Sets <code>remotes[remote].branches[name].state = tracking</code>.</li> </ol> </li> <li><code>jj branch untrack {name}@{remote}</code> (new command)<ol> <li>Sets <code>remotes[remote].branches[name].state = new</code>.</li> </ol> </li> <li><code>jj branch list</code><ul> <li>TODO: hide non-tracking branches by default? ...</li> </ul> </li> </ul> <p>Note: desired behavior of <code>jj branch forget</code> is to</p> <ul> <li>discard both local and remote branches (without actually removing branches   at remotes)</li> <li>not abandon commits which belongs to those branches (even if the branch is   removed at a remote)</li> </ul>"},{"location":"design/tracking-branches.html#command-behavior-examples","title":"Command behavior examples","text":""},{"location":"design/tracking-branches.html#fetchimport_1","title":"fetch/import","text":"<ul> <li>Fetching/importing new branch<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>If new <code>state</code> is <code>tracking</code>, merges <code>[absent, new_remote] - [absent]</code>    (i.e. creates local branch with <code>new_remote</code> target)</li> <li>Sets <code>remotes[remote].branches[name].state</code></li> </ol> </li> <li>Fetching/importing existing branch from tracking remote<ol> <li>Merges <code>[local, new_remote] - [known_remote]</code></li> </ol> </li> <li>Fetching/importing existing branch from untracked remote<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>If new <code>state</code> is <code>tracking</code>, merges <code>[local, new_remote] - [absent]</code></li> <li>Sets <code>remotes[remote].branches[name].state</code></li> </ol> </li> <li>Fetching/importing remotely-deleted branch from tracking remote<ol> <li>Merges <code>[local, absent] - [known_remote]</code></li> <li>Removes <code>remotes[remote].branches[name]</code> (<code>target</code> becomes <code>absent</code>)    (i.e. the remote branch is no longer tracked)</li> <li>Abandons commits in the deleted branch</li> </ol> </li> <li>Fetching/importing remotely-deleted branch from untracked remote<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>Noop anyway since <code>[local, absent] - [absent]</code> -&gt; <code>local</code></li> </ol> </li> <li>Fetching previously-forgotten branch from remote<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>If new <code>state</code> is <code>tracking</code>, merges   <code>[absent, new_remote] - [absent]</code> -&gt; <code>new_remote</code></li> <li>Sets <code>remotes[remote].branches[name].state</code></li> </ol> </li> <li>Fetching forgotten and remotely-deleted branch<ul> <li>Same as \"remotely-deleted branch from untracked remote\" since forgotten   remote branch should be <code>state = new</code></li> <li>Therefore, no local commits should be abandoned</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#push","title":"push","text":"<ul> <li>Pushing new branch, remote doesn't exist<ol> <li>Pushes <code>[local, absent] - [absent]</code> -&gt; <code>local</code></li> <li>Sets <code>remotes[remote].branches[name].target = local</code>, <code>.state = tracking</code></li> </ol> </li> <li>Pushing new branch, untracked remote exists<ol> <li>Pushes <code>[local, remote] - [absent]</code><ul> <li>Fails if <code>local</code> moved backwards or sideways</li> </ul> </li> <li>Sets <code>remotes[remote].branches[name].target = local</code>, <code>.state = tracking</code></li> </ol> </li> <li>Pushing existing branch to tracking remote<ol> <li>Pushes <code>[local, remote] - [remote]</code> -&gt; <code>local</code><ul> <li>Fails if <code>local</code> moved backwards or sideways, and if <code>remote</code> is out of    sync</li> </ul> </li> <li>Sets <code>remotes[remote].branches[name].target = local</code></li> </ol> </li> <li>Pushing existing branch to untracked remote<ul> <li>Same as \"new branch\"</li> </ul> </li> <li>Pushing deleted branch to tracking remote<ol> <li>Pushes <code>[absent, remote] - [remote]</code> -&gt; <code>absent</code><ul> <li>TODO: Fails if <code>remote</code> is out of sync?</li> </ul> </li> <li>Removes <code>remotes[remote].branches[name]</code> (<code>target</code> becomes <code>absent</code>)</li> </ol> </li> <li>Pushing deleted branch to untracked remote<ul> <li>Noop since <code>[absent, remote] - [absent]</code> -&gt; <code>remote</code></li> <li>Perhaps, UI will report error</li> </ul> </li> <li>Pushing forgotten branch to untracked remote<ul> <li>Same as \"deleted branch to untracked remote\"</li> </ul> </li> <li>Pushing previously-forgotten branch to remote<ul> <li>Same as \"new branch, untracked remote exists\"</li> <li>The <code>target</code> of forgotten remote branch is <code>absent</code></li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#export","title":"export","text":"<ul> <li>Exporting new local branch, git branch doesn't exist<ol> <li>Sets <code>remotes[\"git\"].branches[name].target = local</code>, <code>.state = tracking</code></li> <li>Exports <code>[local, absent] - [absent]</code> -&gt; <code>local</code></li> </ol> </li> <li>Exporting new local branch, git branch is out of sync<ol> <li>Exports <code>[local, git] - [absent]</code> -&gt; fail</li> </ol> </li> <li>Exporting existing local branch, git branch is synced<ol> <li>Sets <code>remotes[\"git\"].branches[name].target = local</code></li> <li>Exports <code>[local, git] - [git]</code> -&gt; <code>local</code></li> </ol> </li> <li>Exporting deleted local branch, git branch is synced<ol> <li>Removes <code>remotes[\"git\"].branches[name]</code></li> <li>Exports <code>[absent, git] - [git]</code> -&gt; <code>absent</code></li> </ol> </li> <li>Exporting forgotten branches, git branches are synced<ol> <li>Exports <code>[absent, git] - [git]</code> -&gt; <code>absent</code> for forgotten local/remote    branches</li> </ol> </li> </ul>"},{"location":"design/tracking-branches.html#undo-fetch","title":"undo fetch","text":"<ul> <li>Exporting undone fetch, git branches are synced<ol> <li>Exports <code>[old, git] - [git]</code> -&gt; <code>old</code> for undone local/remote branches</li> </ol> </li> <li>Redoing undone fetch without exporting<ul> <li>Same as plain fetch since the known <code>git_refs</code> isn't diffed against the   refs in the backing Git repo.</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#git-remote","title":"<code>@git</code> remote","text":"<ul> <li><code>jj branch untrack {name}@git</code><ul> <li>Maybe rejected (to avoid confusion)?</li> <li>Allowing this would mean different local branches of the same name coexist   in jj and git.</li> </ul> </li> <li><code>jj git fetch --remote git</code><ul> <li>Rejected. The implementation is different.</li> <li>Conceptually, it's <code>git::import_refs()</code> only for local branches.</li> </ul> </li> <li><code>jj git push --remote git</code><ul> <li>Rejected. The implementation is different.</li> <li>Conceptually, it's <code>jj branch track</code> and <code>git::export_refs()</code> only for   local branches.</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#remaining-issues","title":"Remaining issues","text":"<ul> <li>https://github.com/jj-vcs/jj/issues/1278 pushing to tracked remote<ul> <li>Option could be added to push to all <code>tracking</code> remotes?</li> </ul> </li> <li>Track remote branch locally with different name<ul> <li>Local branch name could be stored per remote branch</li> <li>Consider UI complexity</li> </ul> </li> <li>\"private\" state (suggested by @ilyagr)<ul> <li>\"private\" branches can be pushed to their own remote, but not to the   upstream repo</li> <li>This might be a state attached to a local branch (similar to Mercurial's   \"secret\" phase)</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#references","title":"References","text":"<ul> <li>https://github.com/jj-vcs/jj/issues/1136</li> <li>https://github.com/jj-vcs/jj/issues/1666</li> <li>https://github.com/jj-vcs/jj/issues/1690</li> <li>https://github.com/jj-vcs/jj/issues/1734</li> <li>https://github.com/jj-vcs/jj/pull/1739</li> </ul>"},{"location":"governance/GOVERNANCE.html","title":"Jujutsu Governance","text":""},{"location":"governance/GOVERNANCE.html#overview","title":"Overview","text":"<p>Jujutsu is an open source project, led, maintained and designed for a worldwide community. Anyone who is interested can join, contribute, and participate in the decision-making process. This document is intended to help you understand how you can do that.</p>"},{"location":"governance/GOVERNANCE.html#project-roles","title":"Project roles","text":"<p>We greatly appreciate everyone's contributions, and Jujutsu has benefited greatly from people who shared a single idea, change, or a suggestion, without ever becoming a regular contributor. We also want everybody to feel welcome to share their suggestions for the project (as long as you follow the Community Guidelines).</p> <p>There are two special roles for participants in the Jujutsu projects: Maintainers and Contributors.</p> <p>The role of the Maintainer is formally defined. These are the people empowered to collectively make final decisions about most aspects of the project. They are expected to take community's input seriously and to aim for the benefit of the entire community.</p> <p>The role of a Contributor is less formal. In situations where opinions become numerous or contentious, it is acceptable for the maintainers to assign more weight to the voices of the more established Contributors.</p>"},{"location":"governance/GOVERNANCE.html#maintainers","title":"Maintainers","text":"<p>Maintainers are the people who contribute, review, guide, and collectively make decisions about the direction and scope of the project (see: Decision Making). Maintainers are elected by a voting process.</p> <p>A typical Maintainer is not only someone who has made \"large\" contributions, but someone who has shown they are continuously committed to the project and its community. Some expected responsibilities of maintainers include (but are not exclusively limited to):</p> <ul> <li>Displaying a high level of commitment to the project and its community, and   being a role model for others.</li> <li>Writing patches \u2014 a lot of patches, especially \"glue code\" or \"grunt   work\" or general \"housekeeping\"; fixing bugs, ensuring documentation is always   high quality, consistent UX design, improving processes, making judgments on   dependencies, handling security vulnerabilities, and so on and so forth.</li> <li>Reviewing code submitted by others \u2014 with an eye to maintainability,   performance, code quality, and \"style\" (fitting in with the project).</li> <li>Participating in design discussions, especially with regards to architecture   or long-term vision.</li> <li>Ensuring the community remains a warm and welcoming place, to new and veteran   members alike.</li> <li>Practicing transparency in the project, communicating decisions and their   rationale when appropriate.</li> </ul> <p>This is not an exhaustive list, nor is it intended that every Maintainer does each and every one of these individual tasks to equal amounts. Rather this is only a guideline for what Maintainers are expected to conceptually do.</p> <p>In short, Maintainers are the outwardly visible stewards of the project.</p>"},{"location":"governance/GOVERNANCE.html#current-list-of-maintainers","title":"Current list of Maintainers","text":"<p>The current list of Maintainers:</p> <ul> <li>Austin Seipp (@thoughtpolice)</li> <li>Benjamin Tan (@bnjmnt4n)</li> <li>Ilya Grigoriev (@ilyagr)</li> <li>Martin von Zweigbergk (@martinvonz)</li> <li>Scott Taylor (@scott2000)</li> <li>Waleed Khan (@arxanas)</li> <li>Yuya Nishihara (@yuja)</li> </ul>"},{"location":"governance/GOVERNANCE.html#contributors","title":"Contributors","text":"<p>We consider contributors to be active participants in the project and community who are not maintainers. These are people who might:</p> <ul> <li>Help users by answering questions</li> <li>Participating in lively and respectful discussions across various channels</li> <li>Submit high-quality bug reports, reproduce reported bugs, and verifying fixes</li> <li>Submit patches or pull requests</li> <li>Provide reviews and input on others' pull requests</li> <li>Help with testing and quality assurance</li> <li>Submit feedback about planned features, use cases, or bugs</li> </ul> <p>We essentially define them as people who actively participate in the project. Examples of things that would not make you a contributor are:</p> <ul> <li>Submitting a single bug report and never returning</li> <li>Writing blog posts or other evangelism</li> <li>Using the software in production</li> <li>Forking the project and maintaining your own version</li> <li>Writing a third-party tool or add-on</li> </ul> <p>While these are all generally quite valuable, we don't consider these ongoing contributions to the codebase or project itself, and on their own do not constitute \"active participation\".</p>"},{"location":"governance/GOVERNANCE.html#processes","title":"Processes","text":"<p>For the purposes of making decisions across the project, the following processes are defined.</p>"},{"location":"governance/GOVERNANCE.html#decision-making","title":"Decision-Making","text":"<p>The person proposing a decision to be made (i.e. technical, project direction, etc.) can offer a proposal, along with a 2-to-4 week deadline for discussion. During this time, Maintainers may participate with a vote of:</p> <p>A) Support B) Reject C) Abstain</p> <p>Each Maintainer gets one vote. The total number of \"participating votes\" is the number of Maintainer votes which are not Abstain. The proposal is accepted when more than half of the participating votes are Support.</p> <p>In the event that a decision is reached before the proposed timeline, said proposal can move on and be accepted immediately. In the event no consensus is reached, a proposal may be re-submitted later on.</p> <p>This document itself is subject to the Decision-Making process by the existing set of Maintainers.</p>"},{"location":"governance/GOVERNANCE.html#adding-and-removing-maintainers","title":"Adding and Removing Maintainers","text":"<p>An active Contributor may, at any given time, nominate themselves or another Contributor to become a Maintainer. This process is purely optional and no Contributor is expected to do so; however, self-nomination is encouraged for active participants. A vote and discussion by the existing Maintainers will be used to decide the outcome.</p> <p>Note that Contributors should demonstrate a high standard of continuous participation to become a Maintainer; the upper limit on the number of Maintainers is practically bounded, and so rejection should be considered as a real possibility. As the scope of the project changes, this limit may increase, but it is fundamentally fluid. (If you are unsure, you are free to privately ask existing Maintainers before self-nominating if there is room.)</p> <p>A Maintainer may, at any time, cede their responsibility and step down without a vote.</p> <p>A Maintainer can be removed by other Maintainers, subject to a vote of at-least a 2/3rds majority from the existing Maintainer group (excluding the vote of the Maintainer in question). This can be due to lack of participation or conduct violations, among other things. Note that Maintainers are subject to a higher set of behavioral and communicative standards than average contributor or participant.</p>"},{"location":"governance/GOVERNANCE.html#single-company-influence","title":"Single-Company Influence","text":"<p>At most 1/3 of the maintainers may be paid for their contributions by a single company. This is to reduce the risk of a single company controlling the project's direction. If the 1/3 limit gets exceeded because an existing maintainer gets hired by the same company as some other existing maintainer(s), then the maintainers will have to decide how to resolve the situation. The maintainer in question gets to vote, as long as this doesn't mean the company in question has half the votes (usually meaning there are at least 5 maintainers total).</p>"},{"location":"governance/temporary-voting.html","title":"Getting Community Buy-in for Working Group Proposals","text":""},{"location":"governance/temporary-voting.html#introduction","title":"Introduction","text":"<p>We're introducing a temporary process to describe how we'll gain approval to adopt permanent governance policies - basically, how we make social and technical decisions as a community. This temporary process describes how the governance working group can propose these policies and how community members can influence them and vote on them. Once permanent governance policies are in place, the temporary process will stop being used, and the permanent governance policies will be used instead.</p>"},{"location":"governance/temporary-voting.html#context","title":"Context","text":"<p>The governance working group was appointed by recommendation from Martin (jj's original author and current sole maintainer), without recommendation or approval from the broader jj community. This isn't a problem in itself - but it does mean that the governance working group (Austin Seipp/aseipp, Waleed Khan/arxanas, Martin von Zweigbergk/martinvonz, and Emily Shaffer/nasamuffin) needs to get some community approval before setting policy for the entire jj project. If we skip this step, we risk being perceived as exercising excessive control over the project.</p>"},{"location":"governance/temporary-voting.html#goals-and-non-goals","title":"Goals and Non-Goals","text":"<ul> <li>This process will be used to approve things like a <code>governance.md</code> (describing   the formal structure of governance used for this project), technical design   approval process, and code review process.</li> <li>This is not a process that will be used forever. It is intended as a   temporary process, only used to approve more permanent processes and policies   for the project.</li> <li>This process is used to gather feedback, approval, and acceptance from   invested jj community members. Current members of the community should be able   to participate in voting without hardship.<ul> <li>Current community members include code committers, code reviewers, those   providing user support, those providing quality, actionable feedback, those   providing documentation (first-party or third-party), developers of   jj-compatible tools and add-ons (like GUIs or IDE extensions), and those   providing design input and feedback.<ul> <li>If you feel that you are a member of the community but do not fit into one   of these buckets, please reach out to one of the members of the working   group to have this list expanded.</li> </ul> </li> </ul> </li> <li>This process is the primary way for general community members to influence   governance policies and processes. It should invite constructive feedback and   help us form policies that are acceptable to the jj group as a whole.<ul> <li>It's intended to meet community members where they are - on GitHub and on   Discord, where all development occurs and most support and technical   discussion occurs.</li> </ul> </li> <li>This is not a process for gaining unanimous agreement - there are too   many of us for that to be feasible. Instead, it is a process for gaining   widespread community approval.</li> </ul>"},{"location":"governance/temporary-voting.html#process","title":"Process","text":""},{"location":"governance/temporary-voting.html#stage-1-advance-notice-of-effort","title":"Stage 1: Advance Notice of Effort","text":"<p>The working group lets the community know about upcoming policy drafts they're intending to share for approval. This must happen at least a week before entering stage 3, and ideally should happen even earlier.</p> <p>At this time, the working group should:</p> <ul> <li>Describe why the working group feels this policy is needed</li> <li>Describe the basic goals the policy should achieve</li> <li>Describe implementation details that are being considered, if any</li> <li>Create discussion thread on GitHub (and link to it from Discord). The GitHub   discussion thread is the canonical thread for discussion and will be reused   through the lifetime of a proposal as it moves through this process.</li> </ul> <p>At this time, the community is invited to:</p> <ul> <li>Recommend additional goals, or discuss nuances of the stated goals the working   group has already shared</li> <li>Recommend implementation details</li> </ul> <p>The working group will consider these recommendations in good faith, but may choose not to adopt them.</p>"},{"location":"governance/temporary-voting.html#stage-2-proposal-review-period","title":"Stage 2: Proposal Review Period","text":"<p>This stage lasts until the working group feels major concerns have been addressed and the proposal is ready for a vote. However, at least 72 hours must elapse between the proposal being published and the vote starting, to allow community members around the globe to read and comment. Typically, this stage should last at least one week.</p> <p>At this time, the working group should:</p> <ul> <li>Share the full text of the proposal as a GitHub pull request (PR)</li> <li>Link this GitHub PR to the existing Discord notification thread and GitHub   discussion</li> <li>Explain how the proposal meets the goals stated in Stage 1, either within the   proposal itself or in commentary next to the proposal</li> </ul> <p>At this time, the community is invited to:</p> <ul> <li>Share constructive recommendations in GitHub to modify the text of the   proposal, or discuss nuances of the proposal's wording</li> <li>Share showstopper concerns in GitHub about the proposal, including details   about how and why the concern is especially dire</li> </ul> <p>Think of this like a code review; the goal of this stage is to build a proposal that is representative of the community's will. Keep recommendations actionable and constructive: \"This clause discourages X; if we phrase it like \"foo bar baz\" it could be less exclusive\" is much more productive than \"It's obvious that the governance working group doesn't want X!\"</p> <p>At the discretion of the working group, but based on the outcome of the discussion, the proposal will go to a vote or the proposal will be dropped.</p>"},{"location":"governance/temporary-voting.html#stage-3-proposal-voting-period","title":"Stage 3: Proposal Voting Period","text":"<p>When the working group feels that major concerns have been addressed and is happy with the text of the proposal, the working group will open voting on the proposal.</p> <ul> <li>Voting occurs on GitHub using the poll feature and is advertised heavily on   Discord during the voting period.<ul> <li>If community members want to vote but aren't able to use GitHub, they can   message nasamuffin@ (on Discord, or nasamuffin at google dot com) with their   vote to have it manually included. Only one working group member is listed   in order to avoid accidental double-counting.</li> <li>When voting against, community members should comment on the post explaining   why and describe what change would be required for them to abstain or vote   in favor.</li> <li>Generally, assume that the votes may be publicly visible or may be made   publicly visible at a later time.</li> </ul> </li> <li>Voting is open for at least 1 week, but may be open as long as 2 weeks when   appropriate. After that deadline, the GitHub poll will be locked.<ul> <li>The deadline must be announced at the beginning of the voting period -   once voting has begun, the deadline cannot change.</li> <li>The working group may set the voting period longer to encompass two   weekends (for more participation around day jobs), for less urgent or more   complex proposals, or to account for holidays during the voting period.</li> </ul> </li> <li>Participants can vote in favor or against.<ul> <li>\"Participants\" means the group of community members as enumerated at the   beginning of this document.</li> </ul> </li> </ul> <p>Proposals with 2/3 or more votes in favor at the end of the voting period will be approved.</p> <p>After voting has concluded, either:</p> <ul> <li>The proposal will be implemented (if accepted)</li> <li>The proposal may be revised and begin again at stage 2 (if rejected)</li> <li>The proposal may be abandoned (if rejected)</li> </ul> <p>Deciding whether to revise or abandon is up to the discretion of the governance working group. The working group is expected to double-check their assumption that the goals the proposal is attempting to meet are desirable after the proposal fails to be accepted.</p>"},{"location":"governance/temporary-voting.html#stage-4-implementation","title":"Stage 4: Implementation","text":"<p>Typically, implementation will look like merging the document with the policy into the jj codebase and remembering to use that policy in conversations moving forward.</p> <p>In some cases, implementation may also involve nomination of individuals to a group or committee. When this is necessary, expect the policy being proposed to describe how these individuals will be nominated, both initially and moving into the future.</p> <p>It's possible (but unlikely) that during implementation, some obstacle will arise that means the policy doesn't actually work. If this does happen, expect the working group to be transparent with the community about the situation. We may reuse some of all of this process to figure out how to move forward.</p>"},{"location":"guides/cli-revision-options.html","title":"CLI options for specifying revisions","text":"<p>Jujutsu has several CLI options for selecting revisions. They are used consistently, but it can be difficult to remember when each one is used.</p> <p>This document explains the difference between each option.</p>"},{"location":"guides/cli-revision-options.html#summary","title":"Summary","text":"<p>These flags are used to specify the sources of the operation:</p> Long flag Short flag Description <code>--revision</code> (or <code>--revisions</code>) <code>-r</code> The default, especially for commands that don't need to specify a destination. <code>--source</code> <code>-s</code> The specified revision and all its descendants. <code>--from</code> <code>-f</code> The contents of a revision. <code>--branch</code> <code>-b</code> A whole branch, relative to the destination. <p>These flags are used when commands need both a \"source\" revision and a \"destination\" revision:</p> Long flag Short flag Description <code>--onto</code> <code>-o</code> Create children of the specified revisions. <code>--insert-after</code> <code>-A</code> Insert between the specified revisions and their children. <code>--insert-before</code> <code>-B</code> Insert between the specified revisions and their parents. <code>--to</code>, <code>--into</code> <code>-t</code> Which revision to place the selected contents."},{"location":"guides/cli-revision-options.html#manipulating-revisions","title":"Manipulating revisions","text":"<p>Most commands accept a revset with <code>-r</code>. This selects the revisions in the revset, and no more. Examples: <code>jj log -r REV</code> displays revisions in <code>REV</code>, <code>jj split -r REV</code> splits revision <code>REV</code> into multiple revisions.</p> <p><code>--source</code> (<code>-s</code>) is used with commands that manipulate revisions and their descendants. <code>-s REV</code> is essentially identical to <code>-r REV::</code>.</p> <p>Examples of <code>-r</code> and <code>-s</code>:</p> <ul> <li> <p><code>jj log -r xyz</code> displays revision <code>xyz</code>.</p> </li> <li> <p><code>jj fix -s xyz</code> runs fix tools on files in <code>xyz</code> and all of its descendants.   This command must operate on all of a revision's descendants, so it accepts   <code>-s</code> and not <code>-r</code> to communicate this fact.</p> </li> </ul>"},{"location":"guides/cli-revision-options.html#specifying-destinations","title":"Specifying destinations","text":"<p>Commands that move revisions around also need to specify the destinations.</p> <ul> <li><code>--onto REV</code> (<code>-o REV</code>) places revisions as children of <code>REV</code>.</li> <li><code>--insert-after REV</code> (<code>-A REV</code>) inserts revisions as children of <code>REV</code> and parents of <code>REV+</code>.</li> <li><code>--insert-before REV</code> (<code>-B REV</code>) inserts revisions as the children of <code>REV-</code> and parents of <code>REV</code>.</li> </ul> <p>Examples:</p> <ul> <li><code>jj rebase -r REV -o main</code> rebases revisions in <code>REV</code> as children of <code>main</code>.</li> <li><code>jj rebase -r REV -B yyy</code> inserts revisions <code>REV</code> between <code>yyy</code> and its parents.</li> <li><code>jj rebase -r REV -A main -B yyy</code> inserts revisions <code>REV</code> between <code>main</code> and <code>yyy</code>.</li> <li><code>jj revert -r xyz -o main</code> creates a revision that reverts <code>xyz</code> then rebases it on top of <code>main</code>.</li> </ul>"},{"location":"guides/cli-revision-options.html#manipulating-diffs-and-file-contents","title":"Manipulating diffs and file contents","text":"<p>Commands that view or manipulate the contents of revisions use <code>--from</code> and <code>--to</code> (or <code>--into</code>).</p> <p>Examples:</p> <ul> <li> <p><code>jj diff --from F --to T</code> compares the files at revision <code>F</code> to the files at   revision <code>T</code>.</p> </li> <li> <p><code>jj restore --from F --to T</code> copies file contents from <code>F</code> to <code>T</code>.</p> </li> <li> <p><code>jj squash --from F --into T</code> moves the file changes from <code>F</code> to <code>T</code>.</p> </li> </ul> <p>Info</p> <p>Commands that accept <code>--into</code> also accept <code>--to</code>. You can always use <code>--to</code> if you're not sure which to use.</p> <p>They both exist because \"into\" makes some commands read more clearly in English. For example, <code>jj squash --from X --into Y</code>.</p>"},{"location":"guides/cli-revision-options.html#special-cases-that-use-r","title":"Special cases that use <code>-r</code>","text":"<p>Some commands manipulate revision contents but allow for <code>-r</code>. This means \"compared with its parent\". For example, <code>jj diff -r R</code> means \"compare revision <code>R</code> to its parent <code>R-</code>\".</p>"},{"location":"guides/cli-revision-options.html#special-cases-that-dont-use-any-option","title":"Special cases that don't use any option","text":"<p>Most commands accept revisions as options and paths as positional parameters. For example, the command to display the diff of a specific file in a specific revision is:</p> <pre><code>$ jj diff -r REV file.txt\n</code></pre> <p>However, some commands cannot accept paths, so they allow omitting the <code>-r</code> flag. For example, the canonical command would be <code>jj new -r xyz</code>, but this command is so common that Jujutsu allows <code>jj new xyz</code>.</p> <p>The commands that allow omitting the <code>-r</code> are:</p> <ul> <li><code>jj abandon</code></li> <li><code>jj describe</code></li> <li><code>jj duplicate</code></li> <li><code>jj metaedit</code></li> <li><code>jj new</code></li> <li><code>jj parallelize</code></li> <li><code>jj show</code></li> </ul>"},{"location":"guides/cli-revision-options.html#other-special-cases","title":"Other special cases","text":"<p><code>jj git push --change REV</code> (<code>-c REV</code>) means (a) create a new bookmark with a generated name, and (b) immediately push it to the remote.</p> <p><code>jj restore --changes-in REV</code> (<code>-c REV</code>) means, \"remove any changes to the given files in <code>REV</code>\". This doesn't use <code>-r</code> because <code>jj restore -r REV</code> might seem like it would restore files from <code>REV</code> into the working copy.</p> <p><code>jj rebase --branch REV</code> (<code>-b REV</code>) rebases a topological branch of revisions with respect to some base. This is a convenience for a very common operation. These commands are equivalent:</p> <ul> <li><code>jj rebase -o main -b @</code></li> <li><code>jj rebase -o main -r (main..@)::</code></li> <li><code>jj rebase -o main -s roots(main..@)</code></li> <li><code>jj rebase -o main</code> (this is so common that <code>-b @</code> is the default \"source\" of   a rebase if unspecified)</li> </ul>"},{"location":"guides/divergence.html","title":"Handling divergent changes","text":""},{"location":"guides/divergence.html#what-are-divergent-changes","title":"What are divergent changes?","text":"<p>A divergent change occurs when multiple visible commits have the same change ID. These changes are displayed with a change offset after their change ID and a label of \"divergent\":</p> <pre><code>$ jj log\n@  mzvwutvl/0 test.user@example.com 2001-02-03 08:05:12 29d07a2d (divergent)\n\u2502  a divergent change\n</code></pre> <p>Normally, when commits are rewritten, the original version (the \"predecessor\") becomes hidden and the new commit (the \"successor\") is visible. Thus, only one commit with a given change ID is visible at a time.</p> <p>But, a hidden commit can become visible again. This can happen if:</p> <ul> <li> <p>A visible descendant is added locally. For example, <code>jj new REV</code> will make   <code>REV</code> visible even if it was hidden before.</p> </li> <li> <p>A visible descendant is fetched from a remote. If the hidden commit was pushed   to a remote, others may base new commits off of them. When their new commits are   fetched, their visibility makes the hidden commit visible again.</p> </li> <li> <p>It is made the working copy. <code>jj edit REV</code> will make <code>REV</code> and all its   ancestors visible if it wasn't already.</p> </li> <li> <p>Some other operations make hidden commits visible. For example, adding a   bookmark to a hidden commit makes it visible with the assumption that you are   now working with that commit again.</p> </li> </ul> <p>Divergent changes also occur if two different users or processes amend the same change, creating two visible successors. This can happen when:</p> <ul> <li> <p>Another author modifies commits in a branch that you have also modified   locally.</p> </li> <li> <p>You perform operations on the same change from different workspaces of the   same repository.</p> </li> <li> <p>Two programs modify the repository at the same time. For example, you run   <code>jj describe</code> and, while writing your commit description, an IDE integration   fetches and rebases the branch you're working on.</p> </li> </ul>"},{"location":"guides/divergence.html#how-do-i-resolve-divergent-changes","title":"How do I resolve divergent changes?","text":"<p>When you encounter divergent changes, you have several strategies to choose from. The best approach depends on whether you want to keep the content from one commit, both commits, or merge them together.</p> <p>Note that revsets must refer to the divergent commit either using its commit ID or using its change ID with a change offset like <code>/0</code> or <code>/1</code> as shown in the log, since the change ID is ambiguous by itself.</p>"},{"location":"guides/divergence.html#strategy-1-abandon-one-of-the-commits","title":"Strategy 1: Abandon one of the commits","text":"<p>If one of the divergent commits is clearly obsolete or incorrect, simply abandon it:</p> <pre><code># Abandon the unwanted commit using its commit ID (or change ID with offset)\njj abandon &lt;unwanted-commit-id&gt;\n\n# You can abandon several at once with:\n# jj abandon abc def 123\n# jj abandon abc::\n</code></pre> <p>This is the simplest solution when you know which version to keep.</p>"},{"location":"guides/divergence.html#strategy-2-generate-a-new-change-id","title":"Strategy 2: Generate a new change ID","text":"<p>If you want to keep both versions as separate changes with different change IDs, you can generate a new change ID for one of the commits:</p> <pre><code>jj metaedit --update-change-id &lt;commit-id&gt;\n</code></pre> <p>This preserves both versions of the content while resolving the divergence.</p>"},{"location":"guides/divergence.html#strategy-3-squash-the-commits-together","title":"Strategy 3: Squash the commits together","text":"<p>When you want to combine the content from both divergent commits:</p> <pre><code># Squash one commit into the other\njj squash --from &lt;source-commit-id&gt; --into &lt;target-commit-id&gt;\n</code></pre> <p>This combines the changes from both commits into a single commit. The source commit will be abandoned.</p>"},{"location":"guides/divergence.html#strategy-4-ignore-the-divergence","title":"Strategy 4: Ignore the divergence","text":"<p>Divergence isn't an error. If the divergence doesn't cause immediate problems, you can leave it as-is. If both commits are part of immutable history, this may be your only option.</p> <p>However, it can be inconvenient since you cannot refer to divergent changes unambiguously using their change ID alone.</p>"},{"location":"guides/multiple-remotes.html","title":"Multiple remotes","text":"<p>When using multiple remote repositories, how you configure them in Jujutsu depends on your workflow and the role each remote plays.</p> <p>The setup varies based on whether you are contributing to an upstream project, or integrating changes from another repository.</p>"},{"location":"guides/multiple-remotes.html#nomenclature","title":"Nomenclature","text":"<p>A remote named <code>origin</code> is one you have write-access to and is usually where you push changes.</p> <p>A remote named <code>upstream</code> is the more well-known repository. You may not be able to push to this repository.</p> <p>The trunk in each repository is assumed to be <code>main</code>, so the remote bookmarks are <code>main@origin</code> and <code>main@upstream</code>.</p>"},{"location":"guides/multiple-remotes.html#contributing-upstream-with-a-github-style-fork","title":"Contributing upstream with a GitHub-style fork","text":"<p>This is a GitHub-style fork used to contribute to the upstream repository. <code>upstream</code> is the canonical upstream remote, and <code>origin</code> is where you push contributions, most likely so you can open pull requests.</p> <p>Actions you might take:</p> <ul> <li>Fetch from <code>upstream</code> to get the latest changes.</li> <li>Push <code>main</code> to <code>origin</code> to keep it up-to-date.</li> <li>Push <code>my-feature</code> to <code>origin</code>, then open a pull request to <code>upstream</code>.</li> </ul> <p>To support this scenario, you should:</p> <ul> <li>Track <code>main@upstream</code> so your local <code>main</code> branch is updated whenever you   fetch from <code>upstream</code>.</li> <li>Track <code>main@origin</code> so when you <code>jj git push</code>, your fork's <code>main</code> branch is   updated.</li> <li>Set <code>main@upstream</code> as the <code>trunk()</code> revset alias so it is immutable.</li> </ul> <pre><code># Fetch from both remotes by default\n$ jj config set --repo git.fetch '[\"upstream\", \"origin\"]'\n\n# Push only to the fork by default\n$ jj config set --repo git.push origin\n\n# Track both remote bookmarks\n$ jj bookmark track main\n\n# The upstream repository defines the trunk\n$ jj config set --repo 'revset-aliases.\"trunk()\"' main@upstream\n</code></pre>"},{"location":"guides/multiple-remotes.html#maintaining-an-independent-repository-that-integrates-changes-from-upstream","title":"Maintaining an independent repository that integrates changes from upstream","text":"<p>This is a repository that was originally cloned from upstream, but now contains changes in its <code>main</code> branch that are not upstream and might never be contributed back.</p> <ul> <li><code>origin</code> is the repository you are working in.</li> <li><code>upstream</code> is the repository you periodically integrate changes from.</li> </ul> <p>Actions you might take:</p> <ul> <li>Fetch from <code>origin</code> to get the latest changes.</li> <li>Push bookmarks to <code>origin</code>.</li> <li>Merge pull requests into <code>main@origin</code>.</li> <li>Periodically fetch from <code>main@upstream</code> and merge, rebase, or duplicate its   changes into <code>main@origin</code>.</li> </ul> <p>To support this scenario, you should:</p> <ul> <li>Track only <code>main@origin</code> so your local <code>main</code> branch is updated whenever you   fetch from <code>origin</code>, and so you can push to it if necessary.</li> <li>Do not track <code>main@upstream</code>.</li> <li>Set <code>main@origin</code> as the <code>trunk()</code> revset alias so it is immutable.</li> </ul> <pre><code># Fetch from origin or both remotes by default\n$ jj config set --repo git.fetch '[\"origin\"]'\n# or: jj config set --repo git.fetch '[\"upstream\", \"origin\"]'\n\n# Push only to origin by default\n$ jj config set --repo git.push origin\n\n# Track only the origin bookmark\n$ jj bookmark track main --remote=origin\n$ jj bookmark untrack main --remote=upstream\n\n# The origin repository defines the trunk\n$ jj config set --repo 'revset-aliases.\"trunk()\"' main@origin\n</code></pre>"},{"location":"guides/multiple-remotes.html#other-workflows","title":"Other workflows","text":"<p>Other workflows may be supported. Some general guidance for this:</p> <ul> <li> <p>Set <code>trunk()</code> to be the remote bookmark you usually rebase upon. If you always   rebase against upstream, set it to <code>main@upstream</code>.</p> </li> <li> <p>Tracking a remote bookmark <code>main@origin</code> means it and <code>main</code> represent the   same branch. When one moves, the other should move with it. If you want them to   automatically move together, you should track the remote bookmark. If not, do   not track it.</p> </li> </ul> <p>If you have a workflow that is not well-supported, discussion is welcome in Discord. There is also an open discussion for enhancing how bookmark tracking works.</p>"},{"location":"technical/architecture.html","title":"Architecture","text":""},{"location":"technical/architecture.html#data-model","title":"Data model","text":"<p>The commit data model is similar to Git's object model , but with some differences.</p>"},{"location":"technical/architecture.html#separation-of-library-from-ui","title":"Separation of library from UI","text":"<p>The <code>jj</code> binary consists of two Rust crates: the library crate (<code>jj-lib</code>) and the CLI crate (<code>jj-cli</code>). The library crate is currently only used by the CLI crate, but it is meant to also be usable from a GUI or TUI, or in a server serving requests from multiple users. As a result, the library should avoid interacting directly with the user via the terminal or by other means; all input/output is handled by the CLI crate <sup>1</sup>. Since the library crate is meant to usable in a server, it also cannot read configuration from the user's home directory, or from user-specific environment variables.</p> <p>A lot of thought has gone into making the library crate's API easy to use, but not much has gone into \"details\" such as which collection types are used, or which symbols are exposed in the API.</p>"},{"location":"technical/architecture.html#storage-independent-apis","title":"Storage-independent APIs","text":"<p>One overarching principle in the design is that it should be easy to change where data is stored. The goal was to be able to put storage on local-disk by default but also be able to move storage to the cloud at Google (and for anyone). To that end, commits (and trees, files, etc.) are stored by the commit backend, operations (and views) are stored by the operation backend, the heads of the operation log are stored by the \"op heads\" backend, the commit index is stored by the index backend, and the working copy is stored by the working copy backend. The interfaces are defined in terms of plain Rust data types, not tied to a specific format. The working copy doesn't have its own trait defined yet, but its interface is small and easy to create traits for when needed.</p> <p>The commit backend to use when loading a repo is specified in the <code>.jj/repo/store/type</code> file. There are similar files for the other backends (<code>.jj/repo/index/type</code>, <code>.jj/repo/op_store/type</code>, <code>.jj/repo/op_heads/type</code>).</p>"},{"location":"technical/architecture.html#design-of-the-library-crate","title":"Design of the library crate","text":""},{"location":"technical/architecture.html#overview","title":"Overview","text":"<p>Here's a diagram showing some important types in the library crate, and how they relate. For example, given a <code>Workspace</code>, you can use it to get a <code>WorkingCopy</code> or a <code>RepoLoader</code>. A <code>Transaction</code> is required to acquire a <code>MutableRepo</code>, etc. The following sections describe each component.</p> <p></p> <p>This diagram was created with Excalidraw. You can get a copy of it at this location, and Right Click &gt; \"Copy to Clipboard as SVG\".</p>"},{"location":"technical/architecture.html#backend","title":"Backend","text":"<p>The <code>Backend</code> trait defines the interface each commit backend needs to implement. The current in-tree commit backends are <code>GitBackend</code> and <code>SimpleBackend</code>.</p> <p>Since there are non-commit backends, the <code>Backend</code> trait should probably be renamed to <code>CommitBackend</code>.</p>"},{"location":"technical/architecture.html#gitbackend","title":"GitBackend","text":"<p>The <code>GitBackend</code> stores commits in a Git repository. It uses <code>gitoxide</code> to read and write commits and refs.</p> <p>To prevent GC from deleting commits that are still reachable from the operation log, the <code>GitBackend</code> stores a ref for each commit in the operation log in the <code>refs/jj/keep/</code> namespace.</p> <p>Commit data that is available in Jujutsu's model but not in Git's model is stored in a <code>StackedTable</code> in <code>.jj/repo/store/extra/</code>. That is currently the change ID and the list of predecessors. For commits that don't have any data in that table, which is any commit created by <code>git</code>, we use an empty list as predecessors, and the bit-reversed commit ID as change ID.</p> <p>Because we use the Git Object ID as commit ID, two commits that differ only in their change ID, for example, will get the same commit ID, so we error out when trying to write the second one of them.</p>"},{"location":"technical/architecture.html#simplebackend","title":"SimpleBackend","text":"<p>The <code>SimpleBackend</code> is just a proof of concept. It stores objects addressed by their hash, with one file per object.</p>"},{"location":"technical/architecture.html#store","title":"Store","text":"<p>The <code>Store</code> type wraps the <code>Backend</code> and returns wrapped types for commits and trees to make them easier to use. The wrapped objects have a reference to the <code>Store</code> itself, so you can do e.g. <code>commit.parents()</code> without having to provide the <code>Store</code> as an argument.</p> <p>The <code>Store</code> type also provides caching of commits and trees.</p>"},{"location":"technical/architecture.html#readonlyrepo","title":"ReadonlyRepo","text":"<p>A <code>ReadonlyRepo</code> represents the state of a repo at a specific operation. It keeps the view object associated with that operation.</p> <p>The repository doesn't know where on disk any working copies live. It knows, via the view object, which commit is supposed to be the current working-copy commit in each workspace.</p>"},{"location":"technical/architecture.html#mutablerepo","title":"MutableRepo","text":"<p>A <code>MutableRepo</code> is a mutable version of <code>ReadonlyRepo</code>. It has a reference to its base <code>ReadonlyRepo</code>, but it has its own copy of the view object and lets the caller modify it.</p>"},{"location":"technical/architecture.html#transaction","title":"Transaction","text":"<p>The <code>Transaction</code> object has a <code>MutableRepo</code> and metadata that will go into the operation log. When the transaction commits, the <code>MutableRepo</code> becomes a view object in the operation log on disk, and the <code>Transaction</code> object becomes an operation object. In memory, <code>Transaction::commit()</code> returns a new <code>ReadonlyRepo</code>.</p>"},{"location":"technical/architecture.html#repoloader","title":"RepoLoader","text":"<p>The <code>RepoLoader</code> represents a repository at an unspecified operation. You can think of as a pointer to the <code>.jj/repo/</code> directory. It can create a <code>ReadonlyRepo</code> given an operation ID.</p>"},{"location":"technical/architecture.html#treestate","title":"TreeState","text":"<p>The <code>TreeState</code> type represents the state of the files in a working copy. It keep track of the mtime and size for each tracked file. It knows the <code>TreeId</code> that the working copy represents. It has a <code>snapshot()</code> method that will use the recorded mtimes and sizes and detect changes in the working copy. If anything changed, it will return a new <code>TreeId</code>. It also has <code>checkout()</code> for updating the files on disk to match a requested <code>TreeId</code>.</p> <p>The <code>TreeState</code> type supports sparse checkouts. In fact, all working copies are sparse; they simply track the full repo in most cases.</p>"},{"location":"technical/architecture.html#workingcopy","title":"WorkingCopy","text":"<p>The <code>WorkingCopy</code> type has a <code>TreeState</code> but also knows which <code>WorkspaceName</code> it has and at which operation it was most recently updated.</p>"},{"location":"technical/architecture.html#workspace","title":"Workspace","text":"<p>The <code>Workspace</code> type represents the combination of a repo and a working copy ( like Git's 'worktree' concept).</p> <p>The repo view at the current operation determines the desired working-copy commit in each workspace. The <code>WorkingCopy</code> determines what is actually in the working copy. The working copy can become stale if the working-copy commit was changed from another workspace (or if the process updating the working copy crashed, for example).</p>"},{"location":"technical/architecture.html#git","title":"Git","text":"<p>The <code>git</code> module contains functionality for interoperating with a Git repo, at a higher level than the <code>GitBackend</code>. The <code>GitBackend</code> is restricted by the <code>Backend</code> trait; the <code>git</code> module is specifically for Git-backed repos. It has functionality for importing refs from the Git repo and for exporting to refs in the Git repo. It also has functionality for pushing and pulling to/from Git remotes.</p>"},{"location":"technical/architecture.html#revsets","title":"Revsets","text":"<p>A user-provided revset expression string goes through a few different stages to be evaluated:</p> <ol> <li>Parse the expression into a <code>RevsetExpression</code>, which is close to an AST</li> <li>Resolve symbols and functions like <code>tags()</code> into specific commits. After    this stage, the expression is still a <code>RevsetExpression</code>, but it won't have    any <code>CommitRef</code> variants in it.</li> <li>Resolve visibility. This stage resolves <code>visible_heads()</code> and <code>all()</code> and    produces a <code>ResolvedExpression</code>.</li> <li>Evaluate the <code>ResolvedExpression</code> into a <code>Revset</code>.</li> </ol> <p>This evaluation step is performed by <code>Index::evaluate_revset()</code>, allowing the <code>Revset</code> implementation to leverage the specifics of a custom index implementation. The first three steps are independent of the index implementation.</p>"},{"location":"technical/architecture.html#stackedtable","title":"StackedTable","text":"<p><code>StackedTable</code> (actually <code>ReadonlyTable</code> and <code>MutableTable</code>) is a simple disk format for storing key-value pairs sorted by key. The keys have to have the same size but the values can have different sizes. We use our own format because we want lock-free concurrency and there doesn't seem to be an existing key-value store we could use.</p> <p>The file format contains a lookup table followed by concatenated values. The lookup table is a sorted list of keys, where each key is followed by the associated value's offset in the concatenated values.</p> <p>A table can have a parent table. When looking up a key, if it's not found in the current table, the parent table is searched. We never update a table in place. If the number of new entries to write is less than half the number of entries in the parent table, we create a new table with the new entries and a pointer to the parent. Otherwise, we copy the entries from the parent table and the new entries into a new table with the grandparent as the parent. We do that recursively so parent tables are at least 2 times as large as child tables. This results in O(log N) amortized insertion time and lookup time.</p> <p>There's no garbage collection of unreachable tables yet.</p> <p>The tables are named by their hash. We keep a separate directory of pointers to the current leaf tables, in the same way as we do for the operation log.</p>"},{"location":"technical/architecture.html#design-of-the-cli-crate","title":"Design of the CLI crate","text":""},{"location":"technical/architecture.html#templates","title":"Templates","text":"<p>The concept is copied from Mercurial, but the syntax is different. The main difference is that the top-level expression is a template expression, not a string like in Mercurial. There is also no string interpolation (e.g. <code>\"Commit ID: {node}\"</code> in Mercurial).</p>"},{"location":"technical/architecture.html#diff-editing","title":"Diff-editing","text":"<p>Diff-editing works by creating two very sparse working copies, containing only the files we want the user to edit. We then let the user edit the right-hand side of the diff. Then we simply snapshot that working copy to create the new tree.</p> <ol> <li> <p>There are a few exceptions, such as for messages printed during automatic upgrades of the repo format\u00a0\u21a9</p> </li> </ol>"},{"location":"technical/concurrency.html","title":"Concurrency","text":""},{"location":"technical/concurrency.html#introduction","title":"Introduction","text":"<p>Concurrent editing is a key feature of DVCSs -- that's why they're called Distributed Version Control Systems. A DVCS that didn't let users edit files and create commits on separate machines at the same time wouldn't be much of a distributed VCS.</p> <p>When conflicting changes are made in different clones, a DVCS will have to deal with that when you push or pull. For example, when using Mercurial, if the remote has updated a bookmark called <code>main</code> (Mercurial's bookmarks are similar to a Git's branches) and you had updated the same bookmark locally but made it point to a different target, Mercurial would add a bookmark called <code>main@origin</code> to indicate the conflict. Git instead prevents the conflict by renaming pulled branches to <code>origin/main</code> whether or not there was a conflict. However, most DVCSs treat local concurrency quite differently, typically by using lock files to prevent concurrent edits. Unlike those DVCSs, Jujutsu treats concurrent edits the same whether they're made locally or remotely.</p> <p>One problem with using lock files is that they don't work when the clone is in a distributed file system. Most clones are of course not stored in distributed file systems, but it is a big problem when they are (Mercurial repos frequently get corrupted, for example).</p> <p>Another problem with using lock files is related to complexity of implementation. The simplest way of using lock files is to take coarse-grained locks early: every command that may modify the repo takes a lock at the very beginning. However, that means that operations that wouldn't actually conflict would still have to wait for each other. The user experience can be improved by using finer-grained locks and/or taking the locks later. The drawback of that is complexity. For example, you need to verify that any assumptions you made before locking are still valid after you take the lock.</p> <p>To avoid depending on lock files, Jujutsu takes a different approach by accepting that concurrent changes can always happen. It instead exposes any conflicting changes to the user, much like other DVCSs do for conflicting changes made remotely.</p>"},{"location":"technical/concurrency.html#syncing-with-rsync-nfs-dropbox-etc","title":"Syncing with <code>rsync</code>, NFS, Dropbox, etc","text":"<p>Jujutsu's lock-free concurrency means that it's possible to update copies of the clone on different machines and then let <code>rsync</code> (or Dropbox, or NFS, etc.) merge them. The working copy may mismatch what's supposed to be checked out, but no changes to the repo will be lost (added commits, moved bookmarks, etc.). If conflicting changes were made, they will appear as conflicts. For example, if a bookmark was moved to two different locations, they will appear in <code>jj log</code> in both locations but with a \"?\" after the name, and <code>jj status</code> will also inform the user about the conflict.</p> <p>Note that, for now, there are known bugs in this area. Most notably, with the Git backend, repository corruption is possible because the backend is not entirely lock-free. If that corruption occurs, there is an easy recovery path: <code>jj debug reindex</code> (documented in the linked issue).</p> <p>Moreover, such use of Jujutsu is not currently thoroughly tested, especially in the context of colocated repositories. While the contents of commits should be safe, concurrent modification of a repository from different computers might conceivably lose some bookmark pointers. Note that, unlike in pure Git, losing a bookmark pointer does not lead to losing commits.</p>"},{"location":"technical/concurrency.html#operation-log","title":"Operation log","text":"<p>The most important piece in the lock-free design is the \"operation log\". That is what allows us to detect and merge divergent operations.</p> <p>The operation log is similar to a commit DAG (such as in Git's object model), but each commit object is instead an \"operation\" and each tree object is instead a \"view\". The view object contains the set of visible head commits, bookmarks, tags, and the working-copy commit in each workspace. The operation object contains a pointer to the view object (like how commit objects point to tree objects), pointers to parent operation(s) (like how commit objects point to parent commit(s)), and metadata about the operation. These types are defined in <code>op_store.proto</code> The operation log is normally linear. It becomes non-linear if there are divergent operations.</p> <p>When a command starts, it loads the repo at the latest operation. Because the associated view object completely defines the repo state, the running command will not see any changes made by other processes thereafter. When the operation completes, it is written with the start operation as parent. The operation cannot fail to commit (except for disk failures and such). It is left for the next command to notice if there were divergent operations. It will have to be able to do that anyway since the concurrent operation could have arrived via a distributed file system. This model -- where each operation sees a consistent view of the repo and is guaranteed to be able to commit their changes -- greatly simplifies the implementation of commands.</p> <p>It is possible to load the repo at a particular operation with <code>jj --at-operation=&lt;operation ID&gt; &lt;command&gt;</code>. If the command is mutational, that will result in a fork in the operation log. That works exactly the same as if any later operations had not existed when the command started. In other words, running commands on a repo loaded at an earlier operation works the same way as if the operations had been concurrent. This can be useful for simulating divergent operations.</p>"},{"location":"technical/concurrency.html#merging-divergent-operations","title":"Merging divergent operations","text":"<p>If Jujutsu tries to load the repo and finds multiple heads in the operation log, it will do a 3-way merge of the view objects based on their common ancestor (possibly several 3-way merges if there were more than two heads). Conflicts are recorded in the resulting view object. For example, if bookmark <code>main</code> was moved from commit A to commit B in one operation and moved to commit C in a concurrent operation, then <code>main</code> will be recorded as \"moved from A to B or C\". See the <code>RefTarget</code> definition in <code>op_store.proto</code>.</p> <p>Because we allow bookmarks (etc.) to be in a conflicted state rather than just erroring out when there are multiple heads, the user can continue to use the repo, including performing further operations on the repo. Of course, some commands will fail when using a conflicted bookmark. For example, <code>jj new main</code> when <code>main</code> is in a conflicted state will result in an error telling you that <code>main</code> resolved to multiple revisions.</p>"},{"location":"technical/concurrency.html#storage","title":"Storage","text":"<p>The operation objects and view objects are stored in content-addressed storage just like Git commits are. That makes them safe to write without locking.</p> <p>We also need a way of finding the current head of the operation log. We do that by keeping the ID of the current head(s) as a file in a directory. The ID is the name of the file; it has no contents. When an operation completes, we add a file pointing to the new operation and then remove the file pointing to the old operation. Writing the new file is what makes the operation visible (if the old file didn't get properly deleted, then future readers will take care of that). This scheme ensures that transactions are atomic.</p>"},{"location":"technical/conflicts.html","title":"First-class conflicts","text":""},{"location":"technical/conflicts.html#introduction","title":"Introduction","text":"<p>Conflicts can happen when two changes are applied to some state. This document is about conflicts between changes to files (not about conflicts between changes to bookmark targets, for example).</p> <p>For example, if you merge two branches in a repo, there may be conflicting changes between the two branches. Most DVCSs require you to resolve those conflicts before you can finish the merge operation. Jujutsu instead records the conflicts in the commit and lets you resolve the conflict when you feel like it.</p>"},{"location":"technical/conflicts.html#data-model","title":"Data model","text":"<p>When a merge conflict happens, it is recorded as an ordered list of tree objects linked from the commit (instead of the usual single tree per commit). There will always be an odd number of trees linked from the commit. You can think of the first tree as a start tree, and the subsequent pairs of trees to apply the diff between onto the start. Examples:</p> <ul> <li>If the commit has trees A, B, C, D, and E it means that the contents should be   calculated as A+(C-B)+(E-D).</li> <li>A three-way merge between A and C with B as base can be represented as a commit with trees A, B, and C, also known as A+(C-B).</li> </ul> <p>The resulting tree contents is calculated on demand. Note that we often don't need to merge the entire tree. For example, when checking out a commit in the working copy, we only need to merge parts of the tree that differs from the tree that was previously checked out in the working copy. As another example, when listing paths with conflicts, we only need to traverse parts of the tree that cannot be trivially resolved; if only one side modified <code>lib/</code>, then we don't need to look for conflicts in that sub-tree.</p> <p>When merging trees, if we can't resolve a sub-tree conflict trivially by looking at just the tree id, we recurse into the sub-tree. Similarly, if we can't resolve a file conflict trivially by looking at just the id, we recursive into the hunks within the file.</p> <p>See here for how conflicts are stored when using the Git commit backend.</p>"},{"location":"technical/conflicts.html#conflict-simplification","title":"Conflict simplification","text":"<p>Remember that a 3-way merge can be written <code>A+C-B</code>. If one of those states is itself a conflict, then we simply insert the conflict expression there. Then we simplify by removing canceling terms. These two steps are implemented in <code>Merge::flatten()</code> and <code>Merge::simplify()</code> in <code>merge.rs</code>.</p> <p>For example, let's say commit B is based on A and is rebased to C, where it results in conflicts (<code>C+(B-A)</code>), which the user leaves unresolved. If the commit is then rebased to D, the result will be <code>D+((C+(B-A))-C)</code>. That expression can be simplified to <code>D+(B-A)</code>, which is a regular 3-way merge between D and B with A as base (no trace of C). This is what lets the user keep old commits rebased to head without resolving conflicts and still not get messy recursive conflicts.</p> <p>As another example, let's go through what happens when you back out a conflicted commit. Let's say we have the usual <code>E = C+(B-A)</code> conflict on top of non-conflict state <code>C</code>. We then revert that change. Reverting a change means applying its reverse diff <code>-(E-C)</code>, so the result is <code>E+(C-E) = (C+(B-A))+(C-(C+(B-A)))</code>, which we can simplify to just <code>C</code> (i.e. no conflict).</p>"},{"location":"technical/conflicts.html#same-change-rule","title":"Same-change rule","text":"<p>When all sides of a conflict make the same change, we automatically consider it resolved to that value by default. We call this \"the same-change rule\". This behavior matches what Git and Mercurial do. Darcs, on the other hand, considers it a conflict. The automatic conflict resolution we do is lossy in terms of conflict algebra; it means that rebasing a commit onto a commit that has the same changes (or a subset thereof) and then rebasing it back will lose changes (for a real-life example see bug #6369). We do it because it is more user-friendly in the vast majority of cases.</p>"}]}