/*
 * Copyright (c) 2016, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jfr.internal;

/* Mapped against c++ enum in jfrLogTagSet.hpp */
public enum LogTag {
    /**
     * Covers
     * <ul>
     * <li>Initialization of Flight Recorder
     * <li> recording life cycle (start, stop and dump)
     * <li> repository life cycle
     * <li>loading of configuration files.
     * </ul>
     * Target audience: operations
     */
    JFR(0),
    /**
     * Covers general implementation aspects of JFR (for Hotspot developers)
     */
    JFR_SYSTEM(1),
    /**
     * Covers JVM/JDK events (for Hotspot developers)
     */
    JFR_SYSTEM_EVENT(2),
    /**
     * Covers setting for the JVM/JDK  (for Hotspot developers)
     */
    JFR_SYSTEM_SETTING(3),
    /**
     * Covers generated bytecode (for Hotspot developers)
     */
    JFR_SYSTEM_BYTECODE(4),
    /**
     * Covers XML parsing (for Hotspot developers)
     */
    JFR_SYSTEM_PARSER(5),
    /**
     * Covers metadata for JVM/JDK (for Hotspot developers)
     */
    JFR_SYSTEM_METADATA(6),
    /**
     *  Covers streaming (for Hotspot developers)
     */
    JFR_SYSTEM_STREAMING(7),
    /**
     *  Covers throttling (for Hotspot developers)
     */
    JFR_SYSTEM_THROTTLE(8),
    /**
     *  Covers periodic task work (for Hotspot developer)
     */
    JFR_SYSTEM_PERIODIC(9),
    /**
     *  Covers periodic event work (for users of the JDK)
     */
    JFR_PERIODIC(10),
    /**
     *  Covers metadata for Java user (for Hotspot developers)
     */
    JFR_METADATA(11),
    /**
     * Covers events (for users of the JDK)
     */
    JFR_EVENT(12),
    /**
     * Covers setting (for users of the JDK)
     */
    JFR_SETTING(13),
    /**
     * Covers usage of jcmd with JFR
     */
    JFR_DCMD(14),
    /**
     * -XX:StartFlightRecording
     */
    JFR_START(15);

    /* set from native side */
    volatile int tagSetLevel = 100; // prevent logging if JVM log system has not been initialized

    final int id;

    LogTag(int tagId) {
        id = tagId;
    }

    public LogLevel level() {
        for (LogLevel l : LogLevel.values()) {
            if (l.level == tagSetLevel) {
                return l;
            }
        }
        return LogLevel.WARN; // default
    }
 }
