"""SOCKS5 protocol constants."""

# SOCKS5 version
VERSION = 0x05

# Authentication methods
AUTH_NO_AUTHENTICATION_REQUIRED = 0x00
AUTH_GSSAPI = 0x01
AUTH_USERNAME_PASSWORD = 0x02
AUTH_NO_ACCEPTABLE_METHODS = 0xFF

# Authentication status
AUTH_STATUS_SUCCESS = 0x00
AUTH_STATUS_FAILURE = 0x01

# Command codes
CMD_CONNECT = 0x01
CMD_BIND = 0x02
CMD_UDP_ASSOCIATE = 0x03

# Address types
ATYP_IPV4 = 0x01
ATYP_DOMAINNAME = 0x03
ATYP_IPV6 = 0x04

# Reply codes
REP_SUCCEEDED = 0x00
REP_GENERAL_FAILURE = 0x01
REP_CONNECTION_NOT_ALLOWED = 0x02
REP_NETWORK_UNREACHABLE = 0x03
REP_HOST_UNREACHABLE = 0x04
REP_CONNECTION_REFUSED = 0x05
REP_TTL_EXPIRED = 0x06
REP_COMMAND_NOT_SUPPORTED = 0x07
REP_ADDRESS_TYPE_NOT_SUPPORTED = 0x08

# Common messages
SERVER_GREETING_NO_AUTH = bytes([VERSION, AUTH_NO_AUTHENTICATION_REQUIRED])
SERVER_GREETING_USER_PASS = bytes([VERSION, AUTH_USERNAME_PASSWORD])
AUTH_SUCCESS = bytes([0x01, AUTH_STATUS_SUCCESS])
AUTH_FAILURE = bytes([0x01, AUTH_STATUS_FAILURE])
SUCCESS_REPLY = bytes([VERSION, REP_SUCCEEDED, 0x00, ATYP_IPV4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
