// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/csssection.h>
#include <gtkmm/private/csssection_p.h>


/* Copyright (C) 2014 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<CssSection*>(gobject) is needed:
 *
 * A CssSection instance is in fact always a GtkCssSection instance.
 * Unfortunately, GtkCssSection cannot be a member of CssSection,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because CssSection does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gtk::CssSection> wrap(GtkCssSection* object, bool take_copy)
{
  if(take_copy && object)
    gtk_css_section_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Gtk::CssSection>(reinterpret_cast<Gtk::CssSection*>(object));
}

} // namespace Glib


namespace Gtk
{

void CssSection::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_css_section_ref(reinterpret_cast<GtkCssSection*>(const_cast<CssSection*>(this)));
}

void CssSection::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_css_section_unref(reinterpret_cast<GtkCssSection*>(const_cast<CssSection*>(this)));
}

GtkCssSection* CssSection::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GtkCssSection*>(this);
}

const GtkCssSection* CssSection::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GtkCssSection*>(this);
}

GtkCssSection* CssSection::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GtkCssSection*>(const_cast<CssSection*>(this));
  gtk_css_section_ref(gobject);
  return gobject;
}


Glib::RefPtr<CssSection> CssSection::create(const Glib::RefPtr<Gio::File>& file, const CssLocation& start, const CssLocation& end)
{
  return Glib::wrap(gtk_css_section_new(const_cast<GFile*>(Glib::unwrap<Gio::File>(file)), (start).gobj(), (end).gobj()));
}

Glib::RefPtr<CssSection> CssSection::create(const Glib::RefPtr<Gio::File>& file, const Glib::RefPtr<const Glib::Bytes>& bytes, const CssLocation& start, const CssLocation& end)
{
  return Glib::wrap(gtk_css_section_new_with_bytes(const_cast<GFile*>(Glib::unwrap<Gio::File>(file)), const_cast<GBytes*>(Glib::unwrap<Glib::Bytes>(bytes)), (start).gobj(), (end).gobj()));
}

Glib::ustring CssSection::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_css_section_to_string(const_cast<GtkCssSection*>(gobj())));
}

Glib::RefPtr<CssSection> CssSection::get_parent()
{
  auto retvalue = Glib::wrap(gtk_css_section_get_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const CssSection> CssSection::get_parent() const
{
  return const_cast<CssSection*>(this)->get_parent();
}

Glib::RefPtr<Gio::File> CssSection::get_file()
{
  auto retvalue = Glib::wrap(gtk_css_section_get_file(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::File> CssSection::get_file() const
{
  return const_cast<CssSection*>(this)->get_file();
}

Glib::RefPtr<Glib::Bytes> CssSection::get_bytes() const
{
  auto retvalue = Glib::wrap(gtk_css_section_get_bytes(const_cast<GtkCssSection*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

CssLocation CssSection::get_start_location() const
{
  return Glib::wrap(gtk_css_section_get_start_location(const_cast<GtkCssSection*>(gobj())));
}

CssLocation CssSection::get_end_location() const
{
  return Glib::wrap(gtk_css_section_get_end_location(const_cast<GtkCssSection*>(gobj())));
}


} // namespace Gtk


