package testdata

// Mixed: generic function with non-generic parameters and return
func Transform[T, U any](input []T, fn func(T) U) []U {
	result := make([]U, len(input))
	for i, v := range input {
		result[i] = fn(v)
	}
	return result
}
