// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Full Stack Disaster Recovery API
//
// Use the Full Stack Disaster Recovery (DR) API to manage disaster recovery for business applications.
// Full Stack DR is an OCI disaster recovery orchestration and management service that provides comprehensive disaster
// recovery capabilities for all layers of an application stack, including infrastructure, middleware, database,
// and application.
//

package disasterrecovery

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateDrProtectionGroupMemberMySqlDbSystemDetails Create properties for a HeatWave MySQL DB System member.
type CreateDrProtectionGroupMemberMySqlDbSystemDetails struct {

	// The OCID of the member.
	// Example: `ocid1.instance.oc1..uniqueID`
	MemberId *string `mandatory:"true" json:"memberId"`

	// The OCID of the peer HeatWave MySQL DB System from the peer region.
	// Example: `ocid1.mysqldbsystem.oc1..uniqueID`
	PeerDbSystemId *string `mandatory:"false" json:"peerDbSystemId"`

	// The maximum time (in seconds) to wait for the Global Transaction Identifier (GTID) synchronization process to complete before timing out.
	// Example: `600`
	GtidReconciliationTimeout *int `mandatory:"false" json:"gtidReconciliationTimeout"`

	// A flag indicating whether to continue with DR operation if the Global Transaction Identifier (GTID) reconciliation operation times out.
	// Example: `false`
	IsContinueOnGtidReconciliationTimeout *bool `mandatory:"false" json:"isContinueOnGtidReconciliationTimeout"`

	DbSystemAdminUserDetails *CreateMySqlDbSystemAdminUserDetails `mandatory:"false" json:"dbSystemAdminUserDetails"`

	DbSystemReplicationUserDetails *CreateMySqlDbSystemReplicationUserDetails `mandatory:"false" json:"dbSystemReplicationUserDetails"`
}

// GetMemberId returns MemberId
func (m CreateDrProtectionGroupMemberMySqlDbSystemDetails) GetMemberId() *string {
	return m.MemberId
}

func (m CreateDrProtectionGroupMemberMySqlDbSystemDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateDrProtectionGroupMemberMySqlDbSystemDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m CreateDrProtectionGroupMemberMySqlDbSystemDetails) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeCreateDrProtectionGroupMemberMySqlDbSystemDetails CreateDrProtectionGroupMemberMySqlDbSystemDetails
	s := struct {
		DiscriminatorParam string `json:"memberType"`
		MarshalTypeCreateDrProtectionGroupMemberMySqlDbSystemDetails
	}{
		"MYSQL_DB_SYSTEM",
		(MarshalTypeCreateDrProtectionGroupMemberMySqlDbSystemDetails)(m),
	}

	return json.Marshal(&s)
}
