// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.oracle.com/iaas/Content/application-dependency-management/home.htm).
//

package adm

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateVulnerabilityAuditDetails Details to create a vulnerability audit.
type CreateVulnerabilityAuditDetails struct {

	// The Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
	KnowledgeBaseId *string `mandatory:"true" json:"knowledgeBaseId"`

	// The compartment Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
	// If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
	CompartmentId *string `mandatory:"false" json:"compartmentId"`

	// List of application dependencies (without vulnerabilities).
	ApplicationDependencies []ApplicationDependency `mandatory:"false" json:"applicationDependencies"`

	// The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
	BuildType VulnerabilityAuditBuildTypeEnum `mandatory:"false" json:"buildType,omitempty"`

	Configuration *VulnerabilityAuditConfiguration `mandatory:"false" json:"configuration"`

	UsageData UsageDataDetails `mandatory:"false" json:"usageData"`

	// The name of the vulnerability audit.
	DisplayName *string `mandatory:"false" json:"displayName"`

	Source VulnerabilityAuditSource `mandatory:"false" json:"source"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`
}

func (m CreateVulnerabilityAuditDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateVulnerabilityAuditDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingVulnerabilityAuditBuildTypeEnum(string(m.BuildType)); !ok && m.BuildType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for BuildType: %s. Supported values are: %s.", m.BuildType, strings.Join(GetVulnerabilityAuditBuildTypeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *CreateVulnerabilityAuditDetails) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		CompartmentId           *string                           `json:"compartmentId"`
		ApplicationDependencies []ApplicationDependency           `json:"applicationDependencies"`
		BuildType               VulnerabilityAuditBuildTypeEnum   `json:"buildType"`
		Configuration           *VulnerabilityAuditConfiguration  `json:"configuration"`
		UsageData               usagedatadetails                  `json:"usageData"`
		DisplayName             *string                           `json:"displayName"`
		Source                  vulnerabilityauditsource          `json:"source"`
		FreeformTags            map[string]string                 `json:"freeformTags"`
		DefinedTags             map[string]map[string]interface{} `json:"definedTags"`
		KnowledgeBaseId         *string                           `json:"knowledgeBaseId"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.CompartmentId = model.CompartmentId

	m.ApplicationDependencies = make([]ApplicationDependency, len(model.ApplicationDependencies))
	copy(m.ApplicationDependencies, model.ApplicationDependencies)
	m.BuildType = model.BuildType

	m.Configuration = model.Configuration

	nn, e = model.UsageData.UnmarshalPolymorphicJSON(model.UsageData.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.UsageData = nn.(UsageDataDetails)
	} else {
		m.UsageData = nil
	}

	m.DisplayName = model.DisplayName

	nn, e = model.Source.UnmarshalPolymorphicJSON(model.Source.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.Source = nn.(VulnerabilityAuditSource)
	} else {
		m.Source = nil
	}

	m.FreeformTags = model.FreeformTags

	m.DefinedTags = model.DefinedTags

	m.KnowledgeBaseId = model.KnowledgeBaseId

	return
}
