Contributing    {#contributing}
============

Want to contribute? Great! First, read this page (including the small print at
the end).

# Before you contribute
Before we can use your code, you must sign the
[Google Individual Contributor License Agreement](https://developers.google.com/open-source/cla/individual?csw=1)
(CLA), which you can do online. The CLA is necessary mainly because you own the
copyright to your changes, even after your contribution becomes part of our
codebase, so we need your permission to use and distribute your code. We also
need to be sure of various other things—for instance that you'll tell us if you
know that your code infringes on other people's patents. You don't have to sign
the CLA until after you've submitted your code for review and a member has
approved it, but you must do it before we can put your code into our codebase.
Before you start working on a larger contribution, you should get in touch with
us first through the issue tracker with your idea so that we can help out and
possibly guide you. Coordinating up front makes it much easier to avoid
frustration later on.

# Code reviews
All submissions, including submissions by project members, require review. We
use Github pull requests for this purpose.

Some tips for good pull requests:
* Use our code
  [style guide](https://google.github.io/styleguide/cppguide.html).
  When in doubt, try to stay true to the existing code of the project.
* Write a descriptive commit message. What problem are you solving and what
  are the consequences? Where and what did you test? Some good tips:
  [here](http://robots.thoughtbot.com/5-useful-tips-for-a-better-commit-message)
  and [here](https://www.kernel.org/doc/Documentation/SubmittingPatches).
* If your PR consists of multiple commits which are successive improvements /
  fixes to your first commit, consider squashing them into a single commit
  (`git rebase -i`) such that your PR is a single commit on top of the current
  HEAD. This make reviewing the code so much easier, and our history more
  readable.

# The small print
Contributions made by corporations are covered by a different agreement than
the one above, the Software Grant and Corporate Contributor License Agreement.

# Code

TL/DR

See [how to build flatc](https://flatbuffers.dev/building/).

When making changes, build `flatc` and then re-generate the goldens files to see the effect of your changes:

```
$ cp build/flatc .
$ goldens/generate_goldens.py
```

Re-generate other code files to see the effects of the changes:

```
$ scripts/generate_code.py
```

Run tests with [TestAll.sh](tests/TestAll.sh) in [tests](tests), or directly any of the sub-scripts run by it.

[Format the code](Formatters.md) before submitting a PR.
