/*
* oscilloscope.h
* DIN Is Noise is copyright (c) 2006-2025 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __oscilloscope
#define __oscilloscope

#include "box.h"
#include "ui.h"
#include "arrow_button.h"
#include "alarm.h"

#include <string>
#include <vector>

struct oscilloscope_params_t {

  int left, base;
  int height;
  int visible;
  int autoresize;
  int folded;
	int num_samples;
  float opacity;

	oscilloscope_params_t (int l, int b, int h, int ns, float op, int v, int rs, int f);

};

struct oscilloscope : ui, widget, click_listener {

	struct samplet {
		static float lmin, lmax; // min/max of L
		static float rmin, rmax; // min/max of R
		float left, right; // L and R value  
		samplet () {left = right = 0.0f;}
	};

  samplet* samples;
  int num_samples, max_samples, startsamp;
  void alloc (int n);
  void add_samples (float* outl, float* outr, int n);
  int set_num_samples (int n, int allscopes = 0);



  oscilloscope (const std::string& _settingsf);
  ~oscilloscope ();

  std::vector<oscilloscope_params_t> params; // for each instrument
  std::string settingsf;

  int load ();
  int save ();
	void load_current_instrument ();
	void save_current_instrument ();

	// gl
  int* vertices;
  float* colors;
  int ndraw;

	// ui
	//

  arrow_button fold;
  int folded;
  void set_folded (int f);

  // channel labels
  int lly, lry, lh;
  static const int buf_size = 64;
  char lbuf1 [buf_size], rbuf1 [buf_size];
  alarm_t updlbl;

  int left, base;
  int height;
  int leftx, rightx, endx;
  box<int> win, pick_win;
  void set_height (int h);

	float lr, lg, lb; // L color
	float rr, rg, rb; // R color
  int limit; // > 1 red, < 1 norm

	int lmb_clicked;
  void clicked (button& b);

	int px, py;
	int move, stop_move;
  int handle_input ();

  void calc_draw_params ();
  void draw ();

  float opacity;

  int autoresize;
  void resize (int tox);

};
#endif



