/*
* delaylevels.h
* DIN Is Noise is copyright (c) 2006-2025 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __delaylevels
#define __delaylevels

#define PARAM(W) \
\
void mov##W (delay& d, float dy) {\
  d.W##_crv.move (0, dy);\
  d.W##_lis.edited (0, 0);\
}\
\
VALUE_CHANGED(delaylevels, W##_both_lis) {\
  delaylevels& dl = uis.delaylevs;\
  float dy = dl.W.both ();\
  mov##W (left_delay, dy);\
  mov##W (right_delay, dy);\
}\
\
VALUE_CHANGED(delaylevels,W##_left_lis) {\
  delaylevels& dl = uis.delaylevs;\
  float dy = dl.L.W ();\
  mov##W (left_delay, dy);\
}\
\
VALUE_CHANGED(delaylevels,W##_right_lis) {\
  delaylevels& dl = uis.delaylevs;\
  float dy = dl.R.W ();\
  mov##W (right_delay, dy);\
}

#include "spinner.h"
#include "slider.h"

#include <map>

struct curve_editor;
struct delaylevels : widget, change_listener<slider<float>> {

  ~delaylevels ();

  struct S {
    spinner<float> fbk, vol;
    float beats;
  } L, R;

  struct {
    spinner<float> both;
  } fbk, vol;

	label title;

	int folded;
	arrow_button fold;

  label len;
  slider<float> sl;

  void setup ();
  void draw ();
  int handle_input ();

  MAKE_CLICK_LISTENER(fold_lis, foldl)

  MAKE_FIELD_LISTENER(fbk_both_lis, fbkbothl)
  MAKE_FIELD_LISTENER(fbk_left_lis, fbkll)
  MAKE_FIELD_LISTENER(fbk_right_lis, fbkrl)
  MAKE_FIELD_LISTENER(vol_both_lis, volbothl)
  MAKE_FIELD_LISTENER(vol_left_lis, volll)
  MAKE_FIELD_LISTENER(vol_right_lis, volrl)

  void changed (slider<float>& s);

};

struct delay;
void movfbk (delay& d, float dy);
void movvol (delay& d, float dy);

#endif
