use clap::ValueEnum;
use forgejo_api::structs::StateType;
use serde::{Deserialize, Serialize};
use strum::{Display, EnumIter, EnumString, VariantArray};

#[derive(
    Debug,
    Clone,
    Copy,
    Serialize,
    Deserialize,
    ValueEnum,
    Display,
    EnumIter,
    EnumString,
    VariantArray,
)]
#[strum(serialize_all = "lowercase")]
#[serde(rename_all = "lowercase")]
pub enum ViewStateType {
    Closed,
    Open,
    All,
}

impl ViewStateType {
    pub fn available_for_choosing() -> [Self; 2] {
        use ViewStateType::*;
        [Closed, Open]
    }

    pub fn is_done(&self) -> bool {
        use ViewStateType::*;
        match self {
            Closed => true,
            Open => false,
            All => false,
        }
    }
}

#[derive(
    Debug,
    Clone,
    Copy,
    Serialize,
    Deserialize,
    ValueEnum,
    Display,
    EnumIter,
    EnumString,
    VariantArray,
)]
#[strum(serialize_all = "lowercase")]
#[serde(rename_all = "lowercase")]
pub enum ExclusiveStateType {
    Closed,
    Open,
}

impl ExclusiveStateType {
    pub fn available_for_choosing() -> [Self; 2] {
        use ExclusiveStateType::*;
        [Closed, Open]
    }

    pub fn is_done(&self) -> bool {
        use ExclusiveStateType::*;
        match self {
            Closed => true,
            Open => false,
        }
    }
}

impl From<StateType> for ExclusiveStateType {
    fn from(value: StateType) -> Self {
        match value {
            StateType::Open => Self::Open,
            StateType::Closed => Self::Closed,
        }
    }
}

impl From<ExclusiveStateType> for StateType {
    fn from(value: ExclusiveStateType) -> Self {
        match value {
            ExclusiveStateType::Open => Self::Open,
            ExclusiveStateType::Closed => Self::Closed,
        }
    }
}
