pub mod create;
pub mod list;

use clap::Subcommand;

use super::GlobalArgs;

/// Release subcommands
#[derive(Subcommand, Debug)]
pub enum ReleaseArgs {
    Create(create::CreateReleaseArgs),
    List(list::ListReleaseArgs),
}

impl ReleaseArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            ReleaseArgs::Create(args) => args.run(global_args).await,
            ReleaseArgs::List(args) => args.run(global_args).await,
        }
    }
}
