{ inputs, ... }:
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          logoutAuth = {
            withAuth = true;
            test = ''
              ${testLib.berg_run { cmd = "auth logout --skip-confirmation"; }}
            '';
          };
          logoutNoAuth = {
            withAuth = false;
            test = ''
              ${testLib.berg_run {
                cmd = "auth logout --skip-confirmation";
                success = false;
              }}
            '';
          };
          tokenIsSecret = {
            withAuth = true;
            test = ''
              token_perms = forgejo.succeed("stat -c \"%a\" ~/.local/share/berg-cli/forgejo:3000/TOKEN").strip()
              print(token_perms)

              assert token_perms == "600", f"token permissions were not secret\n{token_perms}"
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
