{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      lib,
      pkgs,
      ...
    }:
    let
      tapeTestLib = inputs.self.tapeTestLib { inherit self' lib pkgs; };
    in
    {
      checks =
        let
          releaseSetup =
            tagName:
            [
              ''berg auth login --token TOKEN''
              ''berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}''
              ''berg repo clone ${sharedLib.user}/${sharedLib.repo}''
              ''cd ${sharedLib.repo}''
              ''git checkout -b ${sharedLib.main}''
              ''echo 'Hello, World!' > hello.txt''
              ''git add -A''
              ''git commit -m 'Hello, World!' ''
              ''git push origin ${sharedLib.main}''
            ]
            ++ (lib.optionals (tagName != null) [
              ''git tag ${tagName}''
              ''git push --tags''
            ]);
        in
        tapeTestLib.embeddInFlake {
          releaseCreateNoTags = {
            extraSetup = releaseSetup null;
            exec = [
              ''Type "berg release create"''
              ''Enter''
              ''Sleep 5s''
            ];
          };
          releaseCreateVersion = {
            extraSetup = releaseSetup "v1.0.0";
            exec = [
              ''Type "berg release create"''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Sleep 5s''
            ];
          };
          releaseCreateNonVersion = {
            extraSetup = releaseSetup "firstRelease";
            exec = [
              ''Type "berg release create"''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Sleep 5s''
            ];
          };
          releaseCreateMixedVersions = {
            extraSetup = (releaseSetup "firstRelease") ++ [
              ''git tag v1.0.0''
              ''git push --tags''
              ''Sleep 500ms''
            ];
            exec = [
              ''Type "berg release create"''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Sleep 5s''
            ];
          };
          releaseCreateAllCLIOptionsSet = {
            extraSetup = releaseSetup "v1.0.0";
            exec = [
              ''Type "berg release create --description 'foo' --name 'bar'"''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Enter''
              ''Sleep 500ms''
              ''Sleep 5s''
            ];
          };
        };
    };
}
