/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverLineG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;

    public DriverLineG2d(double dpiFactor) {
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        ULine shape = (ULine)ushape;
        Line2D.Double line = new Line2D.Double(x, y, x + shape.getDX(), y + shape.getDY());
        DriverLineG2d.manageStroke(param, g2d);
        if (shape.getDeltaShadow() != 0.0) {
            this.drawShadow(g2d, line, shape.getDeltaShadow(), this.dpiFactor);
        }
        g2d.setColor(mapper.getMappedColor(param.getColor()));
        g2d.draw(line);
    }

    static void manageStroke(UParam param, Graphics2D g2d) {
        UStroke stroke = param.getStroke();
        float thickness = (float)(stroke.getThickness() * param.getScale());
        if (stroke.getDashVisible() == 0.0) {
            g2d.setStroke(new BasicStroke(thickness));
        } else {
            float dash1 = (float)stroke.getDashVisible();
            float dash2 = (float)stroke.getDashSpace();
            float[] style = new float[]{dash1, dash2};
            g2d.setStroke(new BasicStroke(thickness, 0, 0, 10.0f, style, 0.0f));
        }
    }
}

