/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImagePseudoState
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final TextBlock desc;

    public EntityImagePseudoState(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.desc = Display.create("H").create(new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE, stereotype), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(22.0, 22.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(22.0, 22.0);
        if (this.getSkinParam().shadowing()) {
            circle.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UStroke(1.5));
        ug = ug.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo()))).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo())));
        ug.draw(circle);
        ug = ug.apply(new UStroke());
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double heightDesc = dimDesc.getHeight();
        double x = (22.0 - widthDesc) / 2.0;
        double y = (22.0 - heightDesc) / 2.0;
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

