/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernActor
extends AbstractTextualComponent {
    private final StickMan stickman;
    private final boolean head;

    public ComponentBlueModernActor(HtmlColor backgroundColor, HtmlColor foregroundColor, FontConfiguration font, Display stringsToDisplay, boolean head, ISkinSimple spriteContainer) {
        super(stringsToDisplay, font, HorizontalAlignment.CENTER, 3, 3, 0, spriteContainer, 0.0, false, null, null);
        this.head = head;
        this.stickman = new StickMan(backgroundColor, foregroundColor);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        ug = ug.apply(new UChangeColor(this.getFontColor()));
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = ug.getStringBounder();
        double delta = (this.getPreferredWidth(stringBounder) - this.stickman.getPreferredWidth()) / 2.0;
        if (this.head) {
            textBlock.drawU(ug.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), this.stickman.getPreferredHeight())));
            ug = ug.apply(new UTranslate(delta, 0.0));
        } else {
            textBlock.drawU(ug.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), 0.0)));
            ug = ug.apply(new UTranslate(delta, this.getTextHeight(stringBounder)));
        }
        this.stickman.drawU(ug);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.stickman.getPreferredHeight() + this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.stickman.getPreferredWidth(), this.getTextWidth(stringBounder));
    }
}

