/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class Reference
extends AbstractEvent
implements Event {
    private final List<Participant> participants;
    private final Url url;
    private final HtmlColor backColorGeneral;
    private final HtmlColor backColorElement;
    private final Display strings;

    public Reference(List<Participant> participants, Url url, Display strings, HtmlColor backColorGeneral, HtmlColor backColorElement) {
        this.participants = participants;
        this.url = url;
        this.strings = strings;
        this.backColorGeneral = backColorGeneral;
        this.backColorElement = backColorElement;
    }

    public List<Participant> getParticipant() {
        return Collections.unmodifiableList(this.participants);
    }

    public Display getStrings() {
        return this.strings;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.participants.contains(someone);
    }

    @Override
    public final Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Participant> it = this.participants.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getCode());
            if (!it.hasNext()) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public final HtmlColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    public final HtmlColor getBackColorElement() {
        return this.backColorElement;
    }
}

