/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DecorInterfaceProvider;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.posimo.PathDrawer;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.posimo.RacorderOrthogonal;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PathDrawerInterface
implements PathDrawer {
    private final Rose rose;
    private final ISkinParam param;
    private final LinkType linkType;

    public static PathDrawerInterface create(ISkinParam param, LinkType linkType) {
        return new PathDrawerInterface(new Rose(), param, linkType);
    }

    private PathDrawerInterface(Rose rose, ISkinParam param, LinkType linkType) {
        this.rose = rose;
        this.param = param;
        this.linkType = linkType;
    }

    @Override
    public void drawPathBefore(UGraphic ug, Positionable start, Positionable end, Path path) {
    }

    private void noDash(UGraphic ug) {
        throw new UnsupportedOperationException();
    }

    private void goDash(UGraphic ug) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawPathAfter(UGraphic ug, Positionable start, Positionable end, Path path) {
        LinkStyle style;
        DotPath dotPath = path.getDotPath();
        RacorderOrthogonal racorder = new RacorderOrthogonal();
        Point2D endPath = dotPath.getEndPoint();
        DotPath in = racorder.getRacordIn(PositionableUtils.convert(end), dotPath.getEndTangeante());
        Point2D inPoint = in.getEndPoint();
        double theta1 = this.atan2(endPath, inPoint);
        Point2D middle1 = this.drawSymbol(ug, theta1, inPoint, this.linkType.getDecor1());
        Point2D startPath = dotPath.getStartPoint();
        DotPath out = racorder.getRacordOut(PositionableUtils.convert(start), dotPath.getStartTangeante());
        Point2D outPoint = out.getStartPoint();
        double theta2 = this.atan2(startPath, outPoint);
        Point2D middle2 = this.drawSymbol(ug, theta2, outPoint, this.linkType.getDecor2());
        if (middle1 != null) {
            CubicCurve2D.Double after = this.getLine(endPath, middle1);
            dotPath = dotPath.addAfter(after);
        }
        if (middle2 != null) {
            CubicCurve2D.Double before = this.getLine(middle2, startPath);
            dotPath = dotPath.addBefore(before);
        }
        if ((style = this.linkType.getStyle()) == LinkStyle.__toremove_INTERFACE_PROVIDER || style == LinkStyle.__toremove_INTERFACE_USER) {
            DecorInterfaceProvider decor = new DecorInterfaceProvider(style);
            Map<Point2D, Double> all = dotPath.somePoints();
            Point2D p = PathDrawerInterface.getFarest(outPoint, inPoint, all.keySet());
            ug = ug.apply(new UChangeBackColor(this.rose.getHtmlColor(this.param, ColorParam.background)));
            ug = ug.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
            decor.drawDecor(ug, p, all.get(p));
        }
        ug = ug.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
        if (this.linkType.isDashed()) {
            this.goDash(ug);
        }
        ug.draw(dotPath);
        if (this.linkType.isDashed()) {
            this.noDash(ug);
        }
    }

    private double atan2(Point2D endPath, Point2D inPoint) {
        double y = -endPath.getX() + inPoint.getX();
        double x = endPath.getY() - inPoint.getY();
        double angle = Math.atan2(y, x);
        return angle;
    }

    private Point2D drawSymbol(UGraphic ug, double theta, Point2D position, LinkDecor decor) {
        throw new UnsupportedOperationException();
    }

    private CubicCurve2D.Double getLine(Point2D p1, Point2D p2) {
        return new CubicCurve2D.Double(p1.getX(), p1.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY(), p2.getX(), p2.getY());
    }

    private static Point2D getFarest(Point2D p1, Point2D p2, Collection<Point2D> all) {
        Point2D result = null;
        double farest = 0.0;
        for (Point2D p : all) {
            if (result == null) {
                result = p;
                farest = p1.distanceSq(result) + p2.distanceSq(result);
                continue;
            }
            double candidat = p1.distanceSq(p) + p2.distanceSq(p);
            if (!(candidat < farest)) continue;
            result = p;
            farest = candidat;
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private Point2D drawSquare(UGraphic ug, double centerX, double centerY) {
        ug = ug.apply(new UChangeBackColor(this.rose.getHtmlColor(this.param, ColorParam.classBackground)));
        ug = ug.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
        double width = 10.0;
        double height = 10.0;
        ug.apply(new UTranslate(centerX - 5.0, centerY - 5.0)).draw(new URectangle(10.0, 10.0));
        return new Point2D.Double(centerX, centerY);
    }

    Point2D drawExtends(UGraphic ug, double x, double y, double theta) {
        ug = ug.apply(new UChangeBackColor(this.rose.getHtmlColor(this.param, ColorParam.background)));
        ug = ug.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
        UPolygon triangle = new UPolygon();
        triangle.addPoint(0.0, 1.0);
        double width = 18.0;
        double height = 26.0;
        triangle.addPoint(-9.0, 26.0);
        triangle.addPoint(9.0, 26.0);
        triangle.rotate(theta);
        ug.apply(new UTranslate(x, y)).draw(triangle);
        Point2D middle = BezierUtils.middle(triangle.getPoints().get(1), triangle.getPoints().get(2));
        middle.setLocation(middle.getX() + x, middle.getY() + y);
        return middle;
    }

    private Point2D drawDiamond(UGraphic ug, double x, double y, double theta) {
        UPolygon triangle = new UPolygon();
        triangle.addPoint(0.0, 0.0);
        double width = 10.0;
        double height = 14.0;
        triangle.addPoint(-5.0, 7.0);
        triangle.addPoint(0.0, 14.0);
        triangle.addPoint(5.0, 7.0);
        triangle.rotate(theta);
        ug.apply(new UTranslate(x, y)).draw(triangle);
        Point2D middle = triangle.getPoints().get(2);
        middle.setLocation(middle.getX() + x, middle.getY() + y);
        return middle;
    }

    private Point2D drawArrow(UGraphic ug, double x, double y, double theta) {
        UPolygon triangle = new UPolygon();
        triangle.addPoint(0.0, 0.0);
        double width = 12.0;
        double height = 10.0;
        triangle.addPoint(-6.0, 10.0);
        double height2 = 4.0;
        triangle.addPoint(0.0, 4.0);
        triangle.addPoint(6.0, 10.0);
        triangle.rotate(theta);
        ug.apply(new UTranslate(x, y)).draw(triangle);
        Point2D middle = triangle.getPoints().get(2);
        middle.setLocation(middle.getX() + x, middle.getY() + y);
        return middle;
    }

    private Point2D nullIfContained(Point2D p, Positionable start, Positionable end) {
        if (PositionableUtils.contains(start, p)) {
            return null;
        }
        if (PositionableUtils.contains(end, p)) {
            return null;
        }
        return p;
    }
}

