/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.html;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.html.LinkHtmlPrinter;

public final class CucaDiagramHtmlMaker {
    private final CucaDiagram diagram;
    private final File dir;

    public CucaDiagramHtmlMaker(CucaDiagram diagram, File dir) {
        this.diagram = diagram;
        this.dir = dir;
    }

    public List<File> create() throws IOException {
        this.dir.mkdirs();
        if (!this.dir.exists()) {
            throw new IOException("Cannot create " + this.dir);
        }
        File f = new File(this.dir, "index.html");
        PrintWriter pw = new PrintWriter(f);
        pw.println("<html>");
        this.printAllType(pw, LeafType.ENUM);
        this.printAllType(pw, LeafType.INTERFACE);
        this.printAllType(pw, LeafType.ANNOTATION);
        this.printAllType(pw, LeafType.ABSTRACT_CLASS);
        this.printAllType(pw, LeafType.CLASS);
        this.htmlClose(pw);
        return Arrays.asList(this.dir);
    }

    private void printAllType(PrintWriter pw, LeafType type) throws IOException {
        if (this.hasSome(type)) {
            pw.println("<h2>" + type.toHtml() + "</h2>");
            for (IEntity iEntity : this.diagram.getLeafsvalues()) {
                if (iEntity.getEntityType() != type) continue;
                this.export(iEntity);
                pw.println("<li>");
                pw.println(LinkHtmlPrinter.htmlLink(iEntity));
                pw.println("</li>");
            }
        }
    }

    private boolean hasSome(LeafType type) {
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            if (iEntity.getEntityType() != type) continue;
            return true;
        }
        return false;
    }

    private void export(IEntity entity) throws IOException {
        File f = new File(this.dir, LinkHtmlPrinter.urlOf(entity));
        PrintWriter pw = new PrintWriter(f);
        pw.println("<html>");
        pw.println("<title>" + StringUtils.unicodeForHtml(entity.getCode().getFullName()) + "</title>");
        pw.println("<h2>" + entity.getEntityType().toHtml() + "</h2>");
        for (Iterator<Member> s : entity.getDisplay()) {
            pw.println(StringUtils.unicodeForHtml(s.toString()));
            pw.println("<br>");
        }
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null) {
            pw.println("<hr>");
            pw.println("<h3>Stereotype</h3>");
            for (String string : stereotype.getLabels(this.diagram.getSkinParam().useGuillemet())) {
                pw.println(string);
                pw.println("<br>");
            }
        }
        pw.println("<hr>");
        if (entity.getBodier().getFieldsToDisplay().size() == 0) {
            pw.println("<h2>No fields</h2>");
        } else {
            pw.println("<h2>Fields:</h2>");
            pw.println("<ul>");
            for (Member member : entity.getBodier().getFieldsToDisplay()) {
                pw.println("<li>");
                pw.println(StringUtils.unicodeForHtml(member.getDisplay(true)));
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        pw.println("<hr>");
        if (entity.getBodier().getMethodsToDisplay().size() == 0) {
            pw.println("<h2>No methods</h2>");
        } else {
            pw.println("<h2>Methods:</h2>");
            pw.println("<ul>");
            for (Member member : entity.getBodier().getMethodsToDisplay()) {
                pw.println("<li>");
                pw.println(StringUtils.unicodeForHtml(member.getDisplay(true)));
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        pw.println("<hr>");
        Collection<Link> links = this.getLinksButNotes(entity);
        if (links.size() == 0) {
            pw.println("<h2>No links</h2>");
        } else {
            pw.println("<h2>Links:</h2>");
            pw.println("<ul>");
            for (Link l : links) {
                pw.println("<li>");
                new LinkHtmlPrinter(l, entity).printLink(pw);
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        Collection<IEntity> collection = this.getNotes(entity);
        if (collection.size() > 0) {
            pw.println("<hr>");
            pw.println("<h2>Notes:</h2>");
            pw.println("<ul>");
            for (IEntity note : collection) {
                pw.println("<li>");
                for (CharSequence s : note.getDisplay()) {
                    pw.println(StringUtils.unicodeForHtml(s.toString()));
                    pw.println("<br>");
                }
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        this.htmlClose(pw);
    }

    private void htmlClose(PrintWriter pw) {
        pw.println("<hr>");
        pw.println("<a href=index.html>Back to index</a>");
        pw.println("</html>");
        pw.close();
    }

    private Collection<IEntity> getNotes(IEntity ent) {
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(ent) || link.getEntity1().getEntityType() != LeafType.NOTE && link.getEntity2().getEntityType() != LeafType.NOTE) continue;
            result.add(link.getOther(ent));
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<Link> getLinksButNotes(IEntity ent) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(ent) || link.getEntity1().getEntityType() == LeafType.NOTE || link.getEntity2().getEntityType() == LeafType.NOTE) continue;
            result.add(link);
        }
        return Collections.unmodifiableList(result);
    }
}

