/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockBordered
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final HtmlColor color;

    public TextBlockBordered(TextBlock textBlock, HtmlColor color) {
        this.textBlock = textBlock;
        this.color = color;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 1.0, 1.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        Dimension2D dim = this.textBlock.calculateDimension(ug.getStringBounder());
        this.textBlock.drawU(ug.apply(new UTranslate(1.0, 1.0)));
        ug.apply(new UChangeColor(this.color)).draw(new URectangle(dim.getWidth(), dim.getHeight()));
    }
}

