/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public SvgAttributes() {
    }

    private SvgAttributes(SvgAttributes other) {
        this.attributes.putAll(other.attributes);
    }

    public SvgAttributes(String args) {
        Pattern p = MyPattern.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");
        Matcher m = p.matcher(args);
        while (m.find()) {
            this.attributes.put(m.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m.group(2)));
        }
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String key, String value) {
        SvgAttributes result = new SvgAttributes(this);
        result.attributes.put(key, value);
        return result;
    }

    public SvgAttributes add(SvgAttributes toBeAdded) {
        SvgAttributes result = new SvgAttributes(this);
        result.attributes.putAll(toBeAdded.attributes);
        return result;
    }
}

