/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;

class ColorAndSizeChange
implements FontChange {
    static final Pattern colorPattern = MyPattern.cmpile("(?i)color\\s*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?");
    static final Pattern sizePattern = MyPattern.cmpile("(?i)size\\s*=\\s*[%g]?(\\d+)[%g]?");
    private final HtmlColor color;
    private final Integer size;

    ColorAndSizeChange(String s) {
        Matcher matcherColor = colorPattern.matcher(s);
        this.color = matcherColor.find() ? HtmlColorSet.getInstance().getColorIfValid(matcherColor.group(1)) : null;
        Matcher matcherSize = sizePattern.matcher(s);
        this.size = matcherSize.find() ? new Integer(matcherSize.group(1)) : null;
    }

    HtmlColor getColor() {
        return this.color;
    }

    Integer getSize() {
        return this.size;
    }

    @Override
    public FontConfiguration apply(FontConfiguration initial) {
        FontConfiguration result = initial;
        if (this.color != null) {
            result = result.changeColor(this.color);
        }
        if (this.size != null) {
            result = result.changeSize(this.size.intValue());
        }
        return result;
    }
}

