/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;

public class GroupPrinter {
    private final PrintWriter pw;

    private GroupPrinter(PrintWriter pw) {
        this.pw = pw;
    }

    private void printGroup(IGroup group) {
        this.pw.println("<table border=1 cellpadding=8 cellspacing=0>");
        this.pw.println("<tr>");
        this.pw.println("<td bgcolor=#DDDDDD>");
        this.pw.println(group.getCode());
        this.pw.println("<tr>");
        this.pw.println("<td>");
        if (group.getLeafsDirect().size() == 0) {
            this.pw.println("<i>No direct leaf</i>");
        } else {
            for (ILeaf leaf : group.getLeafsDirect()) {
                this.pw.println("<ul>");
                this.printLeaf(leaf);
                this.pw.println("</ul>");
            }
        }
        this.pw.println("</td>");
        this.pw.println("</tr>");
        if (group.getChildren().size() > 0) {
            this.pw.println("<tr>");
            this.pw.println("<td>");
            for (IGroup g : group.getChildren()) {
                this.pw.println("<br>");
                this.printGroup(g);
                this.pw.println("<br>");
            }
            this.pw.println("</td>");
            this.pw.println("</tr>");
        }
        this.pw.println("</table>");
    }

    private void printLeaf(ILeaf leaf) {
        this.pw.println("<li>" + leaf.getCode());
    }

    public static void print(File f, IGroup rootGroup) {
        try {
            PrintWriter pw = new PrintWriter(f);
            pw.println("<html>");
            new GroupPrinter(pw).printGroup(rootGroup);
            pw.println("</html>");
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

