/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondFoo1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileWhile
extends AbstractFtile {
    private final Ftile whileBlock;
    private final Ftile diamond1;
    private final TextBlock supplementarySouthText;

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>(this.whileBlock.getSwimlanes());
        result.add(this.getSwimlaneIn());
        return result;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    private FtileWhile(Ftile whileBlock, Ftile diamond1, TextBlock supplementarySouthText) {
        super(whileBlock.shadowing());
        this.whileBlock = whileBlock;
        this.diamond1 = diamond1;
        this.supplementarySouthText = supplementarySouthText;
    }

    private static TextBlock createLabel1(Display test, Display yes, UFont font, ISkinSimple spriteContainer, HtmlColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        FontConfiguration fc = new FontConfiguration(font, HtmlColorUtils.BLACK, hyperlinkColor, useUnderlineForHyperlink);
        TextBlock tmpb = yes.create(fc, HorizontalAlignment.LEFT, spriteContainer);
        if (test == null) {
            return tmpb;
        }
        return TextBlockUtils.mergeTB(test.create(fc, HorizontalAlignment.LEFT, spriteContainer), tmpb, HorizontalAlignment.CENTER);
    }

    public static Ftile create(Swimlane swimlane, Ftile whileBlock, Display test, HtmlColor borderColor, HtmlColor backColor, HtmlColor arrowColor, Display yes, Display out2, UFont fontArrow, HtmlColor endInlinkColor, LinkRendering afterEndwhile, FtileFactory ftileFactory, ConditionStyle conditionStyle, UFont fontTest, HtmlColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        AbstractFtile diamond1;
        TextBlock supplementarySouthText;
        FontConfiguration fcArrow = new FontConfiguration(fontArrow, HtmlColorUtils.BLACK, hyperlinkColor, useUnderlineForHyperlink);
        FontConfiguration fcTest = new FontConfiguration(fontTest, HtmlColorUtils.BLACK, hyperlinkColor, useUnderlineForHyperlink);
        TextBlock yesTb = yes.create(fcArrow, HorizontalAlignment.LEFT, ftileFactory);
        TextBlock testTb = test.create(fcTest, HorizontalAlignment.LEFT, ftileFactory);
        TextBlock out = out2.create(fcArrow, HorizontalAlignment.LEFT, ftileFactory);
        if (conditionStyle == ConditionStyle.INSIDE) {
            supplementarySouthText = TextBlockUtils.empty(0.0, 0.0);
            diamond1 = new FtileDiamondInside(whileBlock.shadowing(), backColor, borderColor, swimlane, testTb).withNorth(yesTb).withWest(out);
        } else if (conditionStyle == ConditionStyle.FOO1) {
            supplementarySouthText = TextBlockUtils.empty(0.0, 0.0);
            diamond1 = new FtileDiamondFoo1(whileBlock.shadowing(), backColor, borderColor, swimlane, testTb).withNorth(yesTb).withWest(out);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            supplementarySouthText = FtileWhile.createLabel1(test, yes, fontArrow, ftileFactory, hyperlinkColor, useUnderlineForHyperlink);
            diamond1 = new FtileDiamond(whileBlock.shadowing(), backColor, borderColor, swimlane).withWest(out).withSouth(supplementarySouthText);
        } else {
            throw new IllegalStateException();
        }
        FtileWhile result = new FtileWhile(whileBlock, diamond1, supplementarySouthText);
        HtmlColor afterEndwhileColor = arrowColor;
        if (afterEndwhile != null && afterEndwhile.getColor() != null) {
            afterEndwhileColor = afterEndwhile.getColor();
        }
        ArrayList<Connection> conns = new ArrayList<Connection>();
        FtileWhile ftileWhile = result;
        ftileWhile.getClass();
        conns.add(ftileWhile.new ConnectionIn(LinkRendering.getColor(whileBlock.getInLinkRendering(), arrowColor)));
        FtileWhile ftileWhile2 = result;
        ftileWhile2.getClass();
        conns.add(ftileWhile2.new ConnectionBack(endInlinkColor));
        FtileWhile ftileWhile3 = result;
        ftileWhile3.getClass();
        conns.add(ftileWhile3.new ConnectionOut(afterEndwhileColor));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateForWhile(stringBounder)).draw(this.whileBlock);
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry geoDiamond1 = this.diamond1.calculateDimension(stringBounder);
        Dimension2D dimSupplementarySouth = this.supplementarySouthText.calculateDimension(stringBounder);
        FtileGeometry geoWhile = this.whileBlock.calculateDimension(stringBounder);
        double diff = dimSupplementarySouth.getWidth() - geoWhile.getWidth();
        if (diff > 0.0) {
            geoWhile = geoWhile.addMarginX(diff / 2.0);
        }
        FtileGeometry geo = geoDiamond1.appendBottom(geoWhile);
        double height = geo.getHeight() + 48.0 + dimSupplementarySouth.getHeight();
        double dx = 24.0;
        return new FtileGeometry(geo.getWidth() + 24.0 + 12.0, height, geo.getLeft() + 24.0, 0.0, height);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.whileBlock) {
            return this.getTranslateForWhile(stringBounder);
        }
        if (child == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForWhile(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimWhile = this.whileBlock.calculateDimension(stringBounder);
        double y = dimDiamond1.getHeight() + (dimTotal.getHeight() - dimDiamond1.getHeight() - dimWhile.getHeight()) / 2.0;
        double x = dimTotal.getLeft() - dimWhile.getLeft();
        return new UTranslate(x, y);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double y1 = 0.0;
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, 0.0);
    }

    class ConnectionOut
    extends AbstractConnection {
        private final HtmlColor afterEndwhileColor;

        public ConnectionOut(HtmlColor afterEndwhileColor) {
            super(FtileWhile.this.diamond1, null);
            this.afterEndwhileColor = afterEndwhileColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            return new Point2D.Double(dimTotal.getLeft(), dimTotal.getHeight());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = new Snake(this.afterEndwhileColor);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY() + dimDiamond1.getOutY() / 2.0;
            double x2 = p2.getX();
            double y2 = p2.getY();
            snake.addPoint(x1, y1);
            snake.addPoint(12.0, y1);
            snake.addPoint(12.0, y2);
            snake.emphasizeDirection(Direction.DOWN);
            ug.draw(snake);
            Snake snake2 = new Snake(this.afterEndwhileColor);
            snake2.addPoint(12.0, y2);
            snake2.addPoint(x2, y2);
            ug.draw(snake2);
        }
    }

    class ConnectionBack
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor endInlinkColor;

        public ConnectionBack(HtmlColor endInlinkColor) {
            super(FtileWhile.this.whileBlock, FtileWhile.this.diamond1);
            this.endInlinkColor = endInlinkColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry geo = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return null;
            }
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(geo.getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = new Snake(this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            Point2D p1 = this.getP1(stringBounder);
            if (p1 == null) {
                return;
            }
            Point2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + dimDiamond1.getWidth();
            double y2 = p2.getY() + dimDiamond1.getOutY() / 2.0;
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y1 + 12.0);
            double xx = ((Dimension2D)dimTotal).getWidth();
            snake.addPoint(xx, y1 + 12.0);
            snake.addPoint(xx, y2);
            snake.addPoint(x2, y2);
            snake.emphasizeDirection(Direction.UP);
            ug.draw(snake);
            ug.apply(new UTranslate(x1, y1 + 12.0)).draw(new UEmpty(5.0, 12.0));
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = new Snake(this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            Point2D ap1 = this.getP1(stringBounder);
            Point2D ap2 = this.getP2(stringBounder);
            Point2D p1 = translate1.getTranslated(ap1);
            Point2D p2 = translate2.getTranslated(ap2);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + ((Dimension2D)dimDiamond1).getWidth();
            double y2 = p2.getY() + ((Dimension2D)dimDiamond1).getHeight() / 2.0;
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y1 + 12.0);
            double xx = Math.max(translate1.getDx(), translate2.getDx()) + ((Dimension2D)dimTotal).getWidth();
            snake.addPoint(xx, y1 + 12.0);
            snake.addPoint(xx, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
            ug.apply(new UTranslate(x1, y1 + 12.0)).draw(new UEmpty(5.0, 12.0));
            ug = ug.apply(new UChangeColor(this.endInlinkColor)).apply(new UChangeBackColor(this.endInlinkColor));
            ug.apply(new UTranslate(xx, (y1 + y2) / 2.0)).draw(Arrows.asToUp());
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor arrowColor) {
            super(FtileWhile.this.diamond1, FtileWhile.this.whileBlock);
            this.arrowColor = arrowColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }
}

