/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public enum BoxStyle {
    PLAIN{

        @Override
        protected Shadowable getShape(double width, double height) {
            return new URectangle(width, height, 25.0, 25.0);
        }
    }
    ,
    SDL_INPUT('<'){

        @Override
        protected Shadowable getShape(double width, double height) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, height / 2.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_OUTPUT('>'){

        @Override
        protected Shadowable getShape(double width, double height) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width, 0.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, height / 2.0);
            result.addPoint(width, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_PROCEDURE('|'){

        @Override
        protected void drawInternal(UGraphic ug, double width, double height, boolean shadowing) {
            URectangle rect = new URectangle(width, height);
            if (shadowing) {
                rect.setDeltaShadow(3.0);
            }
            ug.draw(rect);
            ULine vline = new ULine(0.0, height);
            ug.apply(new UTranslate(PADDING, 0.0)).draw(vline);
            ug.apply(new UTranslate(width - (double)PADDING, 0.0)).draw(vline);
        }
    }
    ,
    SDL_SAVE('/'){

        @Override
        protected Shadowable getShape(double width, double height) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width - (double)DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, height);
            result.addPoint(DELTA_INPUT_OUTPUT, height);
            return result;
        }
    }
    ,
    SDL_CONTINUOUS('}'){

        @Override
        protected Shadowable getShape(double width, double height) {
            UPath result = new UPath();
            double[] c1 = new double[]{DELTA_CONTINUOUS, 0.0};
            double[] c2 = new double[]{0.0, height / 2.0};
            double[] c3 = new double[]{DELTA_CONTINUOUS, height};
            result.add(c1, USegmentType.SEG_MOVETO);
            result.add(c2, USegmentType.SEG_LINETO);
            result.add(c3, USegmentType.SEG_LINETO);
            double[] c4 = new double[]{width - DELTA_CONTINUOUS, 0.0};
            double[] c5 = new double[]{width, height / 2.0};
            double[] c6 = new double[]{width - DELTA_CONTINUOUS, height};
            result.add(c4, USegmentType.SEG_MOVETO);
            result.add(c5, USegmentType.SEG_LINETO);
            result.add(c6, USegmentType.SEG_LINETO);
            return result;
        }
    }
    ,
    SDL_TASK(']'){

        @Override
        protected Shadowable getShape(double width, double height) {
            return new URectangle(width, height);
        }
    };

    private static final int CORNER = 25;
    private final char style;
    private static int DELTA_INPUT_OUTPUT;
    private static double DELTA_CONTINUOUS;
    private static int PADDING;

    private BoxStyle() {
        this('\u0000');
    }

    private BoxStyle(char style) {
        this.style = style;
    }

    public static BoxStyle fromChar(char style) {
        for (BoxStyle bs : BoxStyle.values()) {
            if (bs.style != style) continue;
            return bs;
        }
        return PLAIN;
    }

    public final UDrawable getUDrawable(final double width, final double height, final boolean shadowing) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                BoxStyle.this.drawInternal(ug, width, height, shadowing);
            }
        };
    }

    protected Shadowable getShape(double width, double height) {
        return null;
    }

    protected void drawInternal(UGraphic ug, double width, double height, boolean shadowing) {
        Shadowable s = this.getShape(width, height);
        if (shadowing) {
            s.setDeltaShadow(3.0);
        }
        ug.draw(s);
    }

    static {
        DELTA_INPUT_OUTPUT = 10;
        DELTA_CONTINUOUS = 5.0;
        PADDING = 5;
    }
}

