/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.oregon;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.oregon.Keyboard;
import net.sourceforge.plantuml.oregon.KeyboardList;
import net.sourceforge.plantuml.oregon.NoInputException;
import net.sourceforge.plantuml.oregon.OregonBasicGame;
import net.sourceforge.plantuml.oregon.Screen;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemOregon
extends AbstractPSystem {
    private Screen screen;
    private List<String> inputs;

    @Deprecated
    public PSystemOregon(Keyboard keyboard) {
        OregonBasicGame game = new OregonBasicGame();
        try {
            game.run(keyboard);
            this.screen = game.getScreen();
        }
        catch (NoInputException e) {
            this.screen = game.getScreen();
        }
    }

    public PSystemOregon() {
        this.inputs = new ArrayList<String>();
    }

    public void add(String line) {
        if (StringUtils.isNotEmpty(line)) {
            this.inputs.add(line);
        }
    }

    private Screen getScreen() {
        if (this.screen == null) {
            KeyboardList keyboard = new KeyboardList(this.inputs);
            OregonBasicGame game = new OregonBasicGame();
            try {
                game.run(keyboard);
                this.screen = game.getScreen();
            }
            catch (NoInputException e) {
                this.screen = game.getScreen();
            }
        }
        return this.screen;
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        GraphicStrings result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.addUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont font = new UFont("Monospaced", 0, 14);
        return new GraphicStrings(this.getScreen().getLines(), font, HtmlColorUtils.GREEN, HtmlColorUtils.BLACK, UAntiAliasing.ANTI_ALIASING_OFF);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(The Oregon Trail)", this.getClass());
    }
}

