/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.AddStyle;
import net.sourceforge.plantuml.graphic.ColorAndSizeChange;
import net.sourceforge.plantuml.graphic.ColorChange;
import net.sourceforge.plantuml.graphic.ExposantChange;
import net.sourceforge.plantuml.graphic.FontFamilyChange;
import net.sourceforge.plantuml.graphic.FontPosition;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.RemoveStyle;
import net.sourceforge.plantuml.graphic.ResetFont;
import net.sourceforge.plantuml.graphic.SizeChange;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.SpriteCommand;
import net.sourceforge.plantuml.graphic.SvgAttributesChange;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextLink;

class HtmlCommandFactory {
    static final Pattern addStyle;
    static final Pattern removeStyle;
    private Pattern htmlTag = MyPattern.cmpile(Splitter.htmlTag, 2);

    HtmlCommandFactory() {
    }

    HtmlCommand getHtmlCommand(String s) {
        if (!this.htmlTag.matcher(s).matches()) {
            return new Text(s);
        }
        if (MyPattern.mtches(s, "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>")) {
            return Img.getInstance(s, true);
        }
        if (MyPattern.mtches(s, "\\<img[\\s:]+([^>]+)/?\\>")) {
            return Img.getInstance(s, false);
        }
        if (addStyle.matcher(s).matches()) {
            return new AddStyle(s);
        }
        if (removeStyle.matcher(s).matches()) {
            return new RemoveStyle(FontStyle.getStyle(s));
        }
        if (MyPattern.mtches(s, "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>")) {
            return new ColorAndSizeChange(s);
        }
        if (MyPattern.mtches(s, "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>")) {
            return new ColorChange(s);
        }
        if (MyPattern.mtches(s, "\\<size[\\s:]+(\\d+)[%s]*\\>")) {
            return new SizeChange(s);
        }
        if (MyPattern.mtches(s, "\\<sup\\>")) {
            return new ExposantChange(FontPosition.EXPOSANT);
        }
        if (MyPattern.mtches(s, "\\<sub\\>")) {
            return new ExposantChange(FontPosition.INDICE);
        }
        if (MyPattern.mtches(s, "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>")) {
            return new ResetFont();
        }
        if (MyPattern.mtches(s, "\\</sup\\>|\\</sub\\>")) {
            return new ExposantChange(FontPosition.NORMAL);
        }
        if (MyPattern.mtches(s, "\\<font[\\s:]+([^>]+)/?\\>")) {
            return new FontFamilyChange(s);
        }
        if (MyPattern.mtches(s, "\\<\\$[\\p{L}0-9_]+\\>")) {
            return new SpriteCommand(s);
        }
        if (MyPattern.mtches(s, "\\[\\[([^\\[\\]]+)\\]\\]")) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(s);
            url.setMember(true);
            return new TextLink(url);
        }
        if (MyPattern.mtches(s, "\\<text[\\s:]+([^>]+)/?\\>")) {
            return new SvgAttributesChange(s);
        }
        return null;
    }

    static {
        StringBuilder sbAddStyle = new StringBuilder();
        StringBuilder sbRemoveStyle = new StringBuilder();
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            if (style == FontStyle.PLAIN) continue;
            if (sbAddStyle.length() > 0) {
                sbAddStyle.append('|');
                sbRemoveStyle.append('|');
            }
            sbAddStyle.append(style.getActivationPattern());
            sbRemoveStyle.append(style.getDeactivationPattern());
        }
        addStyle = MyPattern.cmpile(sbAddStyle.toString(), 2);
        removeStyle = MyPattern.cmpile(sbRemoveStyle.toString(), 2);
    }
}

