/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemBasicFactory<P extends AbstractPSystem>
extends PSystemAbstractFactory {
    public PSystemBasicFactory(DiagramType diagramType) {
        super(diagramType);
    }

    public PSystemBasicFactory() {
        this(DiagramType.UML);
    }

    public abstract P executeLine(P var1, String var2);

    public P init(String startLine) {
        return null;
    }

    @Override
    public final Diagram createSystem(UmlSource source) {
        IteratorCounter2 it = source.iterator2();
        CharSequence2 startLine = (CharSequence2)it.next();
        P system = this.init(startLine.toString2());
        while (it.hasNext()) {
            CharSequence2 s = (CharSequence2)it.next();
            if (StartUtils.isArobaseEndDiagram(s)) {
                if (source.getTotalLineCount() == 2) {
                    return this.buildEmptyError(source, s.getLocation());
                }
                if (system != null) {
                    ((AbstractPSystem)system).setSource(source);
                }
                return system;
            }
            if ((system = this.executeLine(system, s.toString2())) != null) continue;
            return new PSystemError(source, new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", it.currentNum() - 1, s.getLocation()), null);
        }
        if (system != null) {
            ((AbstractPSystem)system).setSource(source);
        }
        return system;
    }
}

