package hashprefix

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
)

func TestCacheItem(t *testing.T) {
	item := &cacheItem{
		expiry: time.Unix(0x01_23_45_67_89_AB_CD_EF, 0),
		hashes: []hostnameHash{{
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		}, {
			0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
			0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
			0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
			0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
		}},
	}

	wantData := []byte{
		0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF,
		0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
		0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
		0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
		0x01, 0x03, 0x05, 0x07, 0x02, 0x04, 0x06, 0x08,
	}

	gotData := fromCacheItem(item)
	assert.Equal(t, wantData, gotData)

	newItem := toCacheItem(gotData)
	gotData = fromCacheItem(newItem)
	assert.Equal(t, wantData, gotData)
}
